/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class TargetWordCounterFeature
implements SimpleFeature {
    public static final String NAME = "target-word-count";
    public static final String LABEL = "TargetWords";
    private static final IntWritable ZERO = new IntWritable(0);

    @Override
    public Writable score(RuleWritable r) {
        int words = 0;
        for (int tok : r.target) {
            if (Vocabulary.nt(tok)) continue;
            ++words;
        }
        return new IntWritable(words);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }
}

