/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class WordCompressionRatioFeature
implements SimpleFeature {
    public static final String NAME = "word-cr";
    public static final String LABEL = "WordLogCR";
    private static final IntWritable ZERO = new IntWritable(0);

    @Override
    public Writable score(RuleWritable r) {
        int src_count = 0;
        for (int tok : r.source) {
            if (Vocabulary.nt(tok)) continue;
            ++src_count;
        }
        int tgt_count = 0;
        for (int tok : r.target) {
            if (Vocabulary.nt(tok)) continue;
            ++tgt_count;
        }
        if (src_count == 0 || tgt_count == 0) {
            return ZERO;
        }
        return new FloatWritable((float)Math.log((float)tgt_count / (float)src_count));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }
}

