/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class WordCountDifferenceFeature
implements SimpleFeature {
    public static final String NAME = "word-count-difference";
    public static final String LABEL = "WordCountDiff";
    private static final IntWritable ZERO = new IntWritable(0);

    @Override
    public Writable score(RuleWritable r) {
        int word_difference = 0;
        for (int tok : r.source) {
            if (Vocabulary.nt(tok)) continue;
            --word_difference;
        }
        for (int tok : r.target) {
            if (Vocabulary.nt(tok)) continue;
            ++word_difference;
        }
        return new IntWritable(word_difference);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }
}

