/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;

public class WordLengthDifferenceFeature
implements SimpleFeature {
    public static final String NAME = "word-length-difference";
    public static final String LABEL = "WordLenDiff";
    private static final FloatWritable ZERO = new FloatWritable(0.0f);

    @Override
    public Writable score(RuleWritable r) {
        int src_length = 0;
        int src_count = 0;
        for (int tok : r.source) {
            if (Vocabulary.nt(tok)) continue;
            src_length += Vocabulary.word(tok).length();
            ++src_count;
        }
        int tgt_length = 0;
        int tgt_count = 0;
        for (int tok : r.target) {
            if (Vocabulary.nt(tok)) continue;
            tgt_length += Vocabulary.word(tok).length();
            ++tgt_count;
        }
        if (src_count == 0 || tgt_count == 0) {
            return ZERO;
        }
        float avg_src_length = (float)src_length / (float)src_count;
        float avg_tgt_length = (float)tgt_length / (float)tgt_count;
        return new FloatWritable(avg_tgt_length - avg_src_length);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }
}

