/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features;

import edu.jhu.thrax.datatypes.AlignedSentencePair;
import edu.jhu.thrax.datatypes.Alignment;
import edu.jhu.thrax.util.Vocabulary;
import edu.jhu.thrax.util.exceptions.MalformedInputException;
import edu.jhu.thrax.util.io.InputUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;

public class WordLexicalProbabilityCalculator
extends Configured {
    public static final long UNALIGNED = 0L;
    public static final long MARGINAL = 0L;

    public static class Partition
    extends Partitioner<LongWritable, IntWritable> {
        public int getPartition(LongWritable key, IntWritable value, int numPartitions) {
            return ((int)(key.get() >> 32) & Integer.MAX_VALUE) % numPartitions;
        }
    }

    public static class Reduce
    extends Reducer<LongWritable, IntWritable, LongWritable, FloatWritable> {
        private int current = -1;
        private int marginalCount;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
            Vocabulary.initialize(conf, vocabulary_path);
        }

        protected void reduce(LongWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long pair = key.get();
            int tgt = (int)(pair >> 32);
            int src = (int)(pair & 0xFFFFFFFFL);
            if (tgt != this.current) {
                if ((long)src != 0L) {
                    throw new RuntimeException("Sorting something before marginal.");
                }
                this.current = tgt;
                this.marginalCount = 0;
                for (IntWritable x : values) {
                    this.marginalCount += x.get();
                }
                return;
            }
            int my_count = 0;
            for (IntWritable x : values) {
                my_count += x.get();
            }
            context.write((Object)key, (Object)new FloatWritable((float)my_count / (float)this.marginalCount));
        }
    }

    public static class Map
    extends Mapper<LongWritable, Text, LongWritable, IntWritable> {
        private HashMap<Long, Integer> counts = new HashMap();
        private boolean sourceParsed;
        private boolean targetParsed;
        private boolean reverse;
        private boolean sourceGivenTarget;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
            Vocabulary.initialize(conf, vocabulary_path);
            this.sourceParsed = conf.getBoolean("thrax.source-is-parsed", false);
            this.targetParsed = conf.getBoolean("thrax.target-is-parsed", false);
            this.reverse = conf.getBoolean("thrax.reverse", false);
            this.sourceGivenTarget = conf.getBoolean("thrax.__wordlexprob_sgt", false);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            AlignedSentencePair sentencePair;
            this.counts.clear();
            String line = value.toString();
            try {
                sentencePair = InputUtilities.alignedSentencePair(line, this.sourceParsed, this.targetParsed, !(this.reverse ^ this.sourceGivenTarget));
            }
            catch (MalformedInputException e) {
                context.getCounter("input errors", e.getMessage()).increment(1L);
                return;
            }
            int[] source = sentencePair.source;
            int[] target = sentencePair.target;
            Alignment alignment = sentencePair.alignment;
            for (int i = 0; i < source.length; ++i) {
                int src = source[i];
                if (alignment.sourceIndexIsAligned(i)) {
                    Iterator<Integer> target_indices = alignment.targetIndicesAlignedTo(i);
                    while (target_indices.hasNext()) {
                        int tgt = target[target_indices.next()];
                        long pair = ((long)tgt << 32) + (long)src;
                        long marginal = ((long)tgt << 32) + 0L;
                        this.counts.put(pair, this.counts.containsKey(pair) ? this.counts.get(pair) + 1 : 1);
                        this.counts.put(marginal, this.counts.containsKey(marginal) ? this.counts.get(marginal) + 1 : 1);
                    }
                    continue;
                }
                long pair = 0L | (long)src;
                long marginal = 0L;
                this.counts.put(pair, this.counts.containsKey(pair) ? this.counts.get(pair) + 1 : 1);
                this.counts.put(marginal, this.counts.containsKey(marginal) ? this.counts.get(marginal) + 1 : 1);
            }
            for (long pair : this.counts.keySet()) {
                context.write((Object)new LongWritable(pair), (Object)new IntWritable(this.counts.get(pair).intValue()));
            }
        }
    }
}

