/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.annotation;

import edu.jhu.thrax.hadoop.features.annotation.AlignmentFeature;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.features.annotation.CountFeature;
import edu.jhu.thrax.hadoop.features.annotation.LogCountFeature;
import edu.jhu.thrax.hadoop.features.annotation.RarityPenaltyFeature;
import edu.jhu.thrax.hadoop.features.annotation.SourceGivenTargetLexicalProbabilityFeature;
import edu.jhu.thrax.hadoop.features.annotation.TargetGivenSourceLexicalProbabilityFeature;
import edu.jhu.thrax.hadoop.features.annotation.UnalignedSourceCounterFeature;
import edu.jhu.thrax.hadoop.features.annotation.UnalignedTargetCounterFeature;
import edu.jhu.thrax.util.FormatUtils;
import java.util.ArrayList;
import java.util.List;

public class AnnotationFeatureFactory {
    public static AnnotationFeature get(String name) {
        if (name.equals("unaligned-source")) {
            return new UnalignedSourceCounterFeature();
        }
        if (name.equals("unaligned-target")) {
            return new UnalignedTargetCounterFeature();
        }
        if (name.equals("rarity")) {
            return new RarityPenaltyFeature();
        }
        if (name.equals("count")) {
            return new CountFeature();
        }
        if (name.equals("logcount")) {
            return new LogCountFeature();
        }
        if (name.equals("f_given_e_lex")) {
            return new SourceGivenTargetLexicalProbabilityFeature();
        }
        if (name.equals("e_given_f_lex")) {
            return new TargetGivenSourceLexicalProbabilityFeature();
        }
        if (name.equals("alignment")) {
            return new AlignmentFeature();
        }
        return null;
    }

    public static List<AnnotationFeature> getAll(String names) {
        String[] feature_names = FormatUtils.P_COMMA_OR_SPACE.split(names);
        ArrayList<AnnotationFeature> features = new ArrayList<AnnotationFeature>();
        for (String feature_name : feature_names) {
            AnnotationFeature feature = AnnotationFeatureFactory.get(feature_name);
            if (feature == null) continue;
            features.add(feature);
        }
        return features;
    }
}

