/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.annotation;

import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.FeaturePair;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeatureFactory;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationPassthroughFeature;
import edu.jhu.thrax.util.BackwardsCompatibility;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;

public class AnnotationReducer
extends Reducer<RuleWritable, Annotation, RuleWritable, FeaturePair> {
    private List<AnnotationFeature> annotationFeatures;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
        Vocabulary.initialize(conf, vocabulary_path);
        String features = BackwardsCompatibility.equivalent(conf.get("thrax.features", ""));
        String type = conf.get("thrax.type", "translation");
        if ("paraphrasing".equals(type)) {
            this.annotationFeatures = new ArrayList<AnnotationFeature>();
            this.annotationFeatures.add(new AnnotationPassthroughFeature());
        } else {
            this.annotationFeatures = AnnotationFeatureFactory.getAll(features);
        }
        for (AnnotationFeature af : this.annotationFeatures) {
            af.init(context);
        }
    }

    protected void reduce(RuleWritable key, Iterable<Annotation> values, Reducer.Context context) throws IOException, InterruptedException {
        for (Annotation annotation : values) {
            for (AnnotationFeature f : this.annotationFeatures) {
                context.write((Object)key, (Object)new FeaturePair(Vocabulary.id(f.getLabel()), f.score(key, annotation)));
            }
        }
    }
}

