/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.annotation;

import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;

public class CountFeature
implements AnnotationFeature {
    public static final String NAME = "count";
    public static final String LABEL = "Count";
    private static final IntWritable ZERO = new IntWritable(0);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public Writable score(RuleWritable r, Annotation annotation) {
        return new IntWritable(annotation.count());
    }

    @Override
    public void init(Reducer.Context context) {
    }

    @Override
    public Set<Class<? extends ThraxJob>> getPrerequisites() {
        return null;
    }
}

