/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.annotation;

import edu.jhu.thrax.hadoop.datatypes.AlignmentWritable;
import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.jobs.TargetWordGivenSourceWordProbabilityJob;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import edu.jhu.thrax.lexprob.TrieLexprobTable;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;

public class TargetGivenSourceLexicalProbabilityFeature
implements AnnotationFeature {
    public static final String NAME = "e_given_f_lex";
    public static final String LABEL = "Lex(e|f)";
    private static final float DEFAULT_PROB = 1.0E-6f;
    private TrieLexprobTable table;
    private static final FloatWritable ONE_PROB = new FloatWritable(0.0f);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public void init(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String work_dir = conf.getRaw("thrax.work-dir");
        String tgs_path = work_dir + "lexprobs_tgs/part-*";
        this.table = new TrieLexprobTable(conf, tgs_path);
        context.progress();
    }

    @Override
    public Writable score(RuleWritable key, Annotation annotation) {
        return new FloatWritable(this.targetGivenSource(key, annotation.e2f()));
    }

    private float targetGivenSource(RuleWritable rule, AlignmentWritable e2f) {
        byte[] points = e2f.points;
        int[] source = rule.source;
        int[] target = rule.target;
        float total = 0.0f;
        float prob = 0.0f;
        byte prev = -1;
        int n = points.length / 2;
        int m = 0;
        int expected = 0;
        for (int i = 0; i < n; ++i) {
            float p;
            byte e = points[2 * i];
            byte f = points[2 * i + 1];
            if (e != prev && prev != -1) {
                total = (float)((double)total + (Math.log(prob) - Math.log(m)));
                prob = 0.0f;
                m = 0;
            }
            prev = e;
            ++m;
            while (expected < e) {
                if (!Vocabulary.nt(target[expected])) {
                    p = this.table.get(Vocabulary.getUnknownId(), target[expected]);
                    total = (float)((double)total + (p < 0.0f ? Math.log(1.0E-6f) : Math.log(p)));
                }
                ++expected;
            }
            expected = e + 1;
            p = this.table.get(source[f], target[e]);
            prob += p < 0.0f ? 1.0E-6f : p;
            if (!(p <= 0.0f)) continue;
            System.err.printf("WARNING: could not read lexprob p(%s|%s)\n", Vocabulary.word(target[e]), Vocabulary.word(source[f]));
        }
        if (m != 0) {
            total = (float)((double)total + (Math.log(prob) - Math.log(m)));
        }
        while (expected < target.length) {
            if (!Vocabulary.nt(target[expected])) {
                float p = this.table.get(Vocabulary.getUnknownId(), target[expected]);
                total = (float)((double)total + (p < 0.0f ? Math.log(1.0E-6f) : Math.log(p)));
            }
            ++expected;
        }
        return -total;
    }

    @Override
    public Set<Class<? extends ThraxJob>> getPrerequisites() {
        HashSet<Class<? extends ThraxJob>> pqs = new HashSet<Class<? extends ThraxJob>>();
        pqs.add(TargetWordGivenSourceWordProbabilityJob.class);
        return pqs;
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ONE_PROB);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ONE_PROB);
    }
}

