/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.mapred;

import edu.jhu.thrax.hadoop.datatypes.FeaturePair;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.Feature;
import edu.jhu.thrax.hadoop.jobs.ExtractionJob;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.IntSumReducer;

public abstract class MapReduceFeature
implements Feature,
ThraxJob {
    @Override
    public String getOutputSuffix() {
        return this.getName();
    }

    public Class<? extends Reducer> combinerClass() {
        return IntSumReducer.class;
    }

    public abstract Class<? extends Mapper> mapperClass();

    public abstract Class<? extends WritableComparator> sortComparatorClass();

    public abstract Class<? extends Partitioner> partitionerClass();

    public abstract Class<? extends Reducer> reducerClass();

    @Override
    public Job getJob(Configuration conf) throws IOException {
        String name = this.getName();
        Job job = new Job(conf, name);
        job.setJarByClass(this.getClass());
        job.setMapperClass(this.mapperClass());
        job.setCombinerClass(this.combinerClass());
        job.setSortComparatorClass(this.sortComparatorClass());
        job.setPartitionerClass(this.partitionerClass());
        job.setReducerClass(this.reducerClass());
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(RuleWritable.class);
        job.setOutputValueClass(FeaturePair.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        this.setMapOutputFormat(job);
        int num_reducers = conf.getInt("thrax.reducers", 4);
        job.setNumReduceTasks(num_reducers);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(conf.get("thrax.work-dir") + "rules")});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(conf.get("thrax.work-dir") + name));
        return job;
    }

    @Override
    public Set<Class<? extends ThraxJob>> getPrerequisites() {
        HashSet<Class<? extends ThraxJob>> result = new HashSet<Class<? extends ThraxJob>>();
        result.add(ExtractionJob.class);
        return result;
    }

    @Override
    public abstract void unaryGlueRuleScore(int var1, Map<Integer, Writable> var2);

    @Override
    public abstract void binaryGlueRuleScore(int var1, Map<Integer, Writable> var2);

    protected void setMapOutputFormat(Job job) {
        job.setMapOutputKeyClass(RuleWritable.class);
        job.setMapOutputValueClass(IntWritable.class);
    }
}

