/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.mapred;

import edu.jhu.thrax.hadoop.features.mapred.LhsGivenSourcePhraseFeature;
import edu.jhu.thrax.hadoop.features.mapred.LhsGivenTargetPhraseFeature;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeature;
import edu.jhu.thrax.hadoop.features.mapred.SourcePhraseGivenLHSFeature;
import edu.jhu.thrax.hadoop.features.mapred.SourcePhraseGivenTargetFeature;
import edu.jhu.thrax.hadoop.features.mapred.SourcePhraseGivenTargetandLHSFeature;
import edu.jhu.thrax.hadoop.features.mapred.TargetPhraseGivenLHSFeature;
import edu.jhu.thrax.hadoop.features.mapred.TargetPhraseGivenSourceFeature;
import edu.jhu.thrax.hadoop.features.mapred.TargetPhraseGivenSourceandLHSFeature;
import edu.jhu.thrax.util.FormatUtils;
import java.util.ArrayList;
import java.util.List;

public class MapReduceFeatureFactory {
    public static MapReduceFeature get(String name) {
        if (name.equals("f_given_e_phrase")) {
            return new SourcePhraseGivenTargetFeature();
        }
        if (name.equals("e_given_f_phrase")) {
            return new TargetPhraseGivenSourceFeature();
        }
        if (name.equals("f_given_lhs")) {
            return new SourcePhraseGivenLHSFeature();
        }
        if (name.equals("lhs_given_f")) {
            return new LhsGivenSourcePhraseFeature();
        }
        if (name.equals("f_given_e_and_lhs")) {
            return new SourcePhraseGivenTargetandLHSFeature();
        }
        if (name.equals("e_given_f_and_lhs")) {
            return new TargetPhraseGivenSourceandLHSFeature();
        }
        if (name.equals("e_given_lhs")) {
            return new TargetPhraseGivenLHSFeature();
        }
        if (name.equals("lhs_given_e")) {
            return new LhsGivenTargetPhraseFeature();
        }
        return null;
    }

    public static List<MapReduceFeature> getAll(String names) {
        String[] feature_names = FormatUtils.P_COMMA_OR_SPACE.split(names);
        ArrayList<MapReduceFeature> features = new ArrayList<MapReduceFeature>();
        for (String feature_name : feature_names) {
            MapReduceFeature feature = MapReduceFeatureFactory.get(feature_name);
            if (feature == null) continue;
            features.add(feature);
        }
        return features;
    }
}

