/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.mapred;

import edu.jhu.thrax.hadoop.comparators.FieldComparator;
import edu.jhu.thrax.hadoop.comparators.PrimitiveArrayMarginalComparator;
import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.FeaturePair;
import edu.jhu.thrax.hadoop.datatypes.PrimitiveUtils;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;

public class TargetPhraseGivenLHSFeature
extends MapReduceFeature {
    public static final String NAME = "e_given_lhs";
    public static final String LABEL = "p(e|LHS)";
    private static final FloatWritable ZERO = new FloatWritable(0.0f);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Class<? extends WritableComparator> sortComparatorClass() {
        return Comparator.class;
    }

    @Override
    public Class<? extends Partitioner> partitionerClass() {
        return RuleWritable.LHSPartitioner.class;
    }

    @Override
    public Class<? extends Mapper> mapperClass() {
        return Map.class;
    }

    @Override
    public Class<? extends Reducer> reducerClass() {
        return Reduce.class;
    }

    @Override
    public void unaryGlueRuleScore(int nt, java.util.Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, java.util.Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    public static class Comparator
    extends WritableComparator {
        private static final WritableComparator PARRAY_COMP = new PrimitiveArrayMarginalComparator();
        private static final FieldComparator SOURCE_COMP = new FieldComparator(0, PARRAY_COMP);
        private static final FieldComparator TARGET_COMP = new FieldComparator(1, PARRAY_COMP);

        public Comparator() {
            super(RuleWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int h1 = WritableUtils.decodeVIntSize((byte)b1[s1 + 1]) + 1;
                int h2 = WritableUtils.decodeVIntSize((byte)b2[s2 + 1]) + 1;
                int lhs1 = Math.abs(WritableComparator.readVInt((byte[])b1, (int)(s1 + 1)));
                int lhs2 = Math.abs(WritableComparator.readVInt((byte[])b2, (int)(s2 + 1)));
                int cmp = PrimitiveUtils.compare(lhs1, lhs2);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = TARGET_COMP.compare(b1, s1 + h1, l1 - h1, b2, s2 + h2, l2 - h2);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = PrimitiveUtils.compare(b1[s1], b2[s2]);
                if (cmp != 0) {
                    return cmp;
                }
                return SOURCE_COMP.compare(b1, s1 + h1, l1 - h1, b2, s2 + h2, l2 - h2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static class Reduce
    extends Reducer<RuleWritable, IntWritable, RuleWritable, FeaturePair> {
        private int marginal;
        private FloatWritable prob;

        private Reduce() {
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
            Vocabulary.initialize(conf, vocabulary_path);
        }

        protected void reduce(RuleWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            if (Arrays.equals(key.target, PrimitiveArrayMarginalComparator.MARGINAL)) {
                this.marginal = 0;
                for (IntWritable x : values) {
                    this.marginal += x.get();
                }
                return;
            }
            if (Arrays.equals(key.source, PrimitiveArrayMarginalComparator.MARGINAL)) {
                int count = 0;
                for (IntWritable x : values) {
                    count += x.get();
                }
                this.prob = new FloatWritable((float)(-Math.log((float)count / (float)this.marginal)));
                return;
            }
            context.write((Object)key, (Object)new FeaturePair(Vocabulary.id(TargetPhraseGivenLHSFeature.LABEL), (Writable)this.prob));
        }
    }

    private static class Map
    extends Mapper<RuleWritable, Annotation, RuleWritable, IntWritable> {
        private Map() {
        }

        protected void map(RuleWritable key, Annotation value, Mapper.Context context) throws IOException, InterruptedException {
            RuleWritable lhs_marginal = new RuleWritable(key);
            RuleWritable lhs_target_marginal = new RuleWritable(key);
            lhs_marginal.source = PrimitiveArrayMarginalComparator.MARGINAL;
            lhs_marginal.target = PrimitiveArrayMarginalComparator.MARGINAL;
            lhs_marginal.monotone = false;
            lhs_target_marginal.source = PrimitiveArrayMarginalComparator.MARGINAL;
            lhs_target_marginal.monotone = false;
            IntWritable count = new IntWritable(value.count());
            context.write((Object)key, (Object)count);
            context.write((Object)lhs_target_marginal, (Object)count);
            context.write((Object)lhs_marginal, (Object)count);
        }
    }
}

