/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;

public abstract class NonAggregatingPivotedFeature
implements PivotedFeature {
    private static final FloatWritable ZERO = new FloatWritable(0.0f);
    private float value;

    @Override
    public void initializeAggregation() {
        this.value = Float.MAX_VALUE;
    }

    @Override
    public void aggregate(FeatureMap features) {
        FloatWritable val = (FloatWritable)features.get(this.getLabel());
        if (this.value == Float.MAX_VALUE) {
            this.value = val.get();
        } else if (this.value != val.get()) {
            throw new RuntimeException("Diverging values in pseudo-aggregation: " + this.value + " versus " + val.get());
        }
    }

    public FloatWritable finalizeAggregation() {
        return new FloatWritable(this.value);
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(this.getLabel()), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(this.getLabel()), (Writable)ZERO);
    }
}

