/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.AlignmentWritable;
import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.Writable;

public class PivotedAnnotationFeature
implements PivotedFeature {
    public static final String NAME = "annotation";
    public static final String LABEL = "Annotation";
    private Annotation aggregated = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add("alignment");
        return prereqs;
    }

    @Override
    public Annotation pivot(FeatureMap src, FeatureMap tgt) {
        AlignmentWritable src_f2e = (AlignmentWritable)src.get("Alignment");
        AlignmentWritable tgt_f2e = (AlignmentWritable)tgt.get("Alignment");
        return new Annotation(src_f2e.join(tgt_f2e));
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
    }

    @Override
    public void initializeAggregation() {
        this.aggregated = null;
    }

    @Override
    public void aggregate(FeatureMap a) {
        Annotation annotation = (Annotation)a.get(LABEL);
        if (this.aggregated == null) {
            this.aggregated = new Annotation(annotation);
        } else {
            this.aggregated.setAlignment(this.aggregated.f2e().intersect(annotation.f2e()));
            this.aggregated.merge(annotation);
        }
    }

    @Override
    public Annotation finalizeAggregation() {
        return this.aggregated;
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        return null;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

