/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedLexicalSourceGivenTargetFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedLexicalTargetGivenSourceFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedLhsGivenSourcePhraseFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedLhsGivenTargetPhraseFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedRarityPenaltyFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedSourcePhraseGivenLHSFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedSourcePhraseGivenTargetAndLHSFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedSourcePhraseGivenTargetFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedTargetPhraseGivenLHSFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedTargetPhraseGivenSourceAndLHSFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedTargetPhraseGivenSourceFeature;
import edu.jhu.thrax.util.FormatUtils;
import java.util.ArrayList;
import java.util.List;

public class PivotedFeatureFactory {
    public static PivotedFeature get(String name) {
        if (name.equals("e_given_f_phrase")) {
            return new PivotedTargetPhraseGivenSourceFeature();
        }
        if (name.equals("f_given_e_phrase")) {
            return new PivotedSourcePhraseGivenTargetFeature();
        }
        if (name.equals("rarity")) {
            return new PivotedRarityPenaltyFeature();
        }
        if (name.equals("f_given_e_lex")) {
            return new PivotedLexicalSourceGivenTargetFeature();
        }
        if (name.equals("e_given_f_lex")) {
            return new PivotedLexicalTargetGivenSourceFeature();
        }
        if (name.equals("f_given_lhs")) {
            return new PivotedSourcePhraseGivenLHSFeature();
        }
        if (name.equals("lhs_given_f")) {
            return new PivotedLhsGivenSourcePhraseFeature();
        }
        if (name.equals("f_given_e_and_lhs")) {
            return new PivotedSourcePhraseGivenTargetAndLHSFeature();
        }
        if (name.equals("e_given_lhs")) {
            return new PivotedTargetPhraseGivenLHSFeature();
        }
        if (name.equals("lhs_given_e")) {
            return new PivotedLhsGivenTargetPhraseFeature();
        }
        if (name.equals("e_given_f_and_lhs")) {
            return new PivotedTargetPhraseGivenSourceAndLHSFeature();
        }
        return null;
    }

    public static List<PivotedFeature> getAll(String names) {
        String[] feature_names = FormatUtils.P_COMMA_OR_SPACE.split(names);
        ArrayList<PivotedFeature> features = new ArrayList<PivotedFeature>();
        for (String feature_name : feature_names) {
            PivotedFeature feature = PivotedFeatureFactory.get(feature_name);
            if (feature == null) continue;
            features.add(feature);
        }
        return features;
    }
}

