/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedNegLogProbFeature;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;

public class PivotedLexicalSourceGivenTargetFeature
extends PivotedNegLogProbFeature {
    public static final String NAME = "f_given_e_lex";
    public static final String LABEL = "Lex(f|e)";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add(NAME);
        prereqs.add("e_given_f_lex");
        return prereqs;
    }

    public FloatWritable pivot(FeatureMap src, FeatureMap tgt) {
        float egf = ((FloatWritable)tgt.get("Lex(e|f)")).get();
        float fge = ((FloatWritable)src.get(LABEL)).get();
        return new FloatWritable(egf + fge);
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        HashSet<String> lower_bound_labels = new HashSet<String>();
        lower_bound_labels.add("Lex(e|f)");
        lower_bound_labels.add(LABEL);
        return lower_bound_labels;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

