/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedNegLogProbFeature;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;

public class PivotedLexicalTargetGivenSourceFeature
extends PivotedNegLogProbFeature {
    public static final String NAME = "e_given_f_lex";
    public static final String LABEL = "Lex(e|f)";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add(NAME);
        prereqs.add("f_given_e_lex");
        return prereqs;
    }

    public FloatWritable pivot(FeatureMap src, FeatureMap tgt) {
        float egf = ((FloatWritable)src.get(LABEL)).get();
        float fge = ((FloatWritable)tgt.get("Lex(f|e)")).get();
        return new FloatWritable(egf + fge);
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        HashSet<String> lower_bound_labels = new HashSet<String>();
        lower_bound_labels.add(LABEL);
        lower_bound_labels.add("Lex(f|e)");
        return lower_bound_labels;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

