/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.util.NegLogMath;
import edu.jhu.thrax.util.Vocabulary;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;

public abstract class PivotedNegLogProbFeature
implements PivotedFeature {
    private static final FloatWritable ONE_PROB = new FloatWritable(0.0f);
    private float aggregated;

    @Override
    public void initializeAggregation() {
        this.aggregated = 64.0f;
    }

    @Override
    public void aggregate(FeatureMap features) {
        FloatWritable val = (FloatWritable)features.get(this.getLabel());
        this.aggregated = NegLogMath.logAdd(this.aggregated, val.get());
    }

    public FloatWritable finalizeAggregation() {
        return new FloatWritable(this.aggregated);
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(this.getLabel()), (Writable)ONE_PROB);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(this.getLabel()), (Writable)ONE_PROB);
    }
}

