/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.util.Vocabulary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;

public class PivotedRarityPenaltyFeature
implements PivotedFeature {
    public static final String NAME = "rarity";
    public static final String LABEL = "RarityPenalty";
    private static final FloatWritable ZERO = new FloatWritable(0.0f);
    private static final float RENORMALIZE = (float)Math.exp(-1.0);
    private float aggregated_rp;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add(NAME);
        return prereqs;
    }

    public FloatWritable pivot(FeatureMap a, FeatureMap b) {
        float a_rp = ((FloatWritable)a.get(LABEL)).get();
        float b_rp = ((FloatWritable)b.get(LABEL)).get();
        return new FloatWritable(Math.max(a_rp, b_rp));
    }

    @Override
    public void unaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void binaryGlueRuleScore(int nt, Map<Integer, Writable> map) {
        map.put(Vocabulary.id(LABEL), (Writable)ZERO);
    }

    @Override
    public void initializeAggregation() {
        this.aggregated_rp = -1.0f;
    }

    @Override
    public void aggregate(FeatureMap a) {
        float rp = ((FloatWritable)a.get(LABEL)).get();
        this.aggregated_rp = this.aggregated_rp == -1.0f ? rp : (this.aggregated_rp *= rp * RENORMALIZE);
    }

    public FloatWritable finalizeAggregation() {
        return new FloatWritable(this.aggregated_rp);
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        HashSet<String> lower_bound_labels = new HashSet<String>();
        lower_bound_labels.add(LABEL);
        return lower_bound_labels;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

