/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedNegLogProbFeature;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;

public class PivotedSourcePhraseGivenTargetAndLHSFeature
extends PivotedNegLogProbFeature {
    public static final String NAME = "f_given_e_and_lhs";
    public static final String LABEL = "p(f|e,LHS)";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add(NAME);
        prereqs.add("e_given_f_and_lhs");
        return prereqs;
    }

    public FloatWritable pivot(FeatureMap src, FeatureMap tgt) {
        float fge = ((FloatWritable)src.get("p(e|f,LHS)")).get();
        float egf = ((FloatWritable)tgt.get(LABEL)).get();
        return new FloatWritable(egf + fge);
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        HashSet<String> lower_bound_labels = new HashSet<String>();
        lower_bound_labels.add("p(e|f,LHS)");
        lower_bound_labels.add(LABEL);
        return lower_bound_labels;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

