/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedNegLogProbFeature;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;

public class PivotedSourcePhraseGivenTargetFeature
extends PivotedNegLogProbFeature {
    public static final String NAME = "f_given_e_phrase";
    public static final String LABEL = "p(f|e)";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add("e_given_f_phrase");
        prereqs.add(NAME);
        return prereqs;
    }

    public FloatWritable pivot(FeatureMap src, FeatureMap tgt) {
        float src_f = ((FloatWritable)src.get("p(e|f)")).get();
        float f_tgt = ((FloatWritable)tgt.get(LABEL)).get();
        return new FloatWritable(src_f + f_tgt);
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        HashSet<String> lower_bound_labels = new HashSet<String>();
        lower_bound_labels.add("p(e|f)");
        lower_bound_labels.add(LABEL);
        return lower_bound_labels;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

