/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.features.pivot;

import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.features.pivot.PivotedNegLogProbFeature;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.io.FloatWritable;

public class PivotedTargetPhraseGivenSourceFeature
extends PivotedNegLogProbFeature {
    public static final String NAME = "e_given_f_phrase";
    public static final String LABEL = "p(e|f)";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public Set<String> getPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        prereqs.add(NAME);
        prereqs.add("f_given_e_phrase");
        return prereqs;
    }

    public FloatWritable pivot(FeatureMap src, FeatureMap tgt) {
        float tgt_f = ((FloatWritable)tgt.get(LABEL)).get();
        float f_src = ((FloatWritable)src.get("p(f|e)")).get();
        return new FloatWritable(tgt_f + f_src);
    }

    @Override
    public Set<String> getLowerBoundLabels() {
        HashSet<String> lower_bound_labels = new HashSet<String>();
        lower_bound_labels.add(LABEL);
        lower_bound_labels.add("p(f|e)");
        return lower_bound_labels;
    }

    @Override
    public Set<String> getUpperBoundLabels() {
        return null;
    }
}

