/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.jobs;

import edu.jhu.thrax.hadoop.distributional.DistributionalContextMapper;
import edu.jhu.thrax.hadoop.distributional.SignatureWritable;
import edu.jhu.thrax.hadoop.jobs.DistributionalContextExtractionJob;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

public class DistributionalContextSortingJob
implements ThraxJob {
    private static HashSet<Class<? extends ThraxJob>> prereqs = new HashSet();

    @Override
    public Job getJob(Configuration conf) throws IOException {
        Job job = new Job(conf, "sorting");
        job.setJarByClass(DistributionalContextMapper.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(Reducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(SignatureWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(1);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(conf.get("thrax.work-dir") + "signatures")});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(conf.get("thrax.outputPath", "")));
        int max_split_size = conf.getInt("thrax.max-split-size", 0);
        if (max_split_size != 0) {
            FileInputFormat.setMaxInputSplitSize((Job)job, (long)max_split_size);
        }
        return job;
    }

    @Override
    public String getName() {
        return "sorting";
    }

    @Override
    public Set<Class<? extends ThraxJob>> getPrerequisites() {
        prereqs.add(DistributionalContextExtractionJob.class);
        return prereqs;
    }

    @Override
    public String getOutputSuffix() {
        return null;
    }
}

