/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.jobs;

import edu.jhu.thrax.hadoop.datatypes.FeaturePair;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeatureFactory;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeature;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeatureFactory;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import edu.jhu.thrax.hadoop.output.OutputReducer;
import edu.jhu.thrax.util.BackwardsCompatibility;
import edu.jhu.thrax.util.FormatUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class OutputJob
implements ThraxJob {
    protected static HashSet<Class<? extends ThraxJob>> prereqs = new HashSet();

    @Override
    public Set<Class<? extends ThraxJob>> getPrerequisites() {
        return prereqs;
    }

    public static void addPrerequisite(Class<? extends ThraxJob> c) {
        prereqs.add(c);
    }

    @Override
    public Job getJob(Configuration conf) throws IOException {
        int maxSplitSize;
        Job job = new Job(conf, "collect");
        String workDir = conf.get("thrax.work-dir");
        job.setJarByClass(OutputReducer.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(OutputReducer.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapOutputKeyClass(RuleWritable.class);
        job.setMapOutputValueClass(FeaturePair.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(NullWritable.class);
        job.setSortComparatorClass(RuleWritable.YieldComparator.class);
        job.setPartitionerClass(RuleWritable.FirstWordPartitioner.class);
        int numReducers = conf.getInt("thrax.reducers", 4);
        job.setNumReduceTasks(numReducers);
        boolean annotation_features = false;
        String features = BackwardsCompatibility.equivalent(conf.get("thrax.features", ""));
        for (String feature : FormatUtils.P_SPACE.split(features)) {
            if (MapReduceFeatureFactory.get(feature) instanceof MapReduceFeature) {
                FileInputFormat.addInputPath((Job)job, (Path)new Path(workDir + feature));
            }
            if (AnnotationFeatureFactory.get(feature) == null) continue;
            annotation_features = true;
        }
        if (annotation_features) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(workDir + "annotation"));
        }
        if ((maxSplitSize = conf.getInt("thrax.max-split-size", 0)) != 0) {
            FileInputFormat.setMaxInputSplitSize((Job)job, (long)(maxSplitSize * 20));
        }
        if (FileInputFormat.getInputPaths((JobContext)job).length == 0) {
            FileInputFormat.addInputPath((Job)job, (Path)new Path(workDir + "rules"));
        } else {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path rulesPath = new Path(workDir + "rules");
            boolean recursive = true;
            fs.delete(rulesPath, true);
        }
        String outputPath = conf.get("thrax.outputPath", "");
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)job, GzipCodec.class);
        return job;
    }

    @Override
    public String getName() {
        return "collect";
    }

    @Override
    public String getOutputSuffix() {
        return null;
    }
}

