/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.jobs;

import edu.jhu.thrax.hadoop.jobs.JobState;
import edu.jhu.thrax.hadoop.jobs.SchedulerException;
import edu.jhu.thrax.hadoop.jobs.ThraxJob;
import edu.jhu.thrax.util.FormatUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;

public class Scheduler {
    private HashSet<String> faked;
    private HashMap<Class<? extends ThraxJob>, JobState> jobs = new HashMap();

    public Scheduler(Configuration config) {
        this.faked = new HashSet();
        String faked_line = config.get("thrax.fake");
        if (faked_line != null) {
            String[] faked_jobs;
            for (String faked_job : faked_jobs = FormatUtils.P_SPACE.split(faked_line)) {
                this.faked.add(faked_job);
            }
        }
    }

    public boolean schedule(Class<? extends ThraxJob> jobClass) throws SchedulerException {
        ThraxJob job;
        if (this.jobs.containsKey(jobClass)) {
            return false;
        }
        try {
            job = jobClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchedulerException(e.getMessage());
        }
        for (Class<? extends ThraxJob> c : job.getPrerequisites()) {
            this.schedule(c);
        }
        this.jobs.put(jobClass, JobState.PLANNED);
        System.err.println("[SCHED] planned job for " + jobClass);
        return true;
    }

    public boolean setState(Class<? extends ThraxJob> job_class, JobState state) throws SchedulerException {
        if (this.jobs.containsKey(job_class)) {
            this.jobs.put(job_class, state);
            System.err.println(String.format("[SCHED] %s in state %s", new Object[]{job_class, state}));
            this.updateAllStates();
            return true;
        }
        return false;
    }

    public void updateAllStates() throws SchedulerException {
        for (Class<? extends ThraxJob> c : this.jobs.keySet()) {
            JobState state = this.jobs.get(c);
            switch (state) {
                case WAITING: {
                    this.checkReady(c);
                }
                case READY: {
                    this.checkFailedPrereq(c);
                }
            }
        }
    }

    public void percolate(Class<? extends ThraxJob> job_class) throws SchedulerException {
        ThraxJob job;
        try {
            job = job_class.newInstance();
        }
        catch (Exception e) {
            throw new SchedulerException(e.getMessage());
        }
        Set<Class<? extends ThraxJob>> prereqs = job.getPrerequisites();
        if (this.faked.contains(job.getName())) {
            this.setState(job_class, JobState.SUCCESS);
        } else {
            this.setState(job_class, JobState.WAITING);
            if (prereqs != null) {
                for (Class<? extends ThraxJob> p : prereqs) {
                    this.percolate(p);
                }
            }
        }
    }

    public void checkReady(Class<? extends ThraxJob> c) throws SchedulerException {
        ThraxJob job;
        try {
            job = c.newInstance();
        }
        catch (Exception e) {
            throw new SchedulerException(e.getMessage());
        }
        for (Class<? extends ThraxJob> p : job.getPrerequisites()) {
            if (this.jobs.get(p).equals((Object)JobState.SUCCESS)) continue;
            return;
        }
        this.setState(c, JobState.READY);
    }

    public void checkFailedPrereq(Class<? extends ThraxJob> c) throws SchedulerException {
        ThraxJob job;
        try {
            job = c.newInstance();
        }
        catch (Exception e) {
            throw new SchedulerException(e.getMessage());
        }
        for (Class<? extends ThraxJob> p : job.getPrerequisites()) {
            JobState state = this.jobs.get(p);
            if (!state.equals((Object)JobState.FAILED) && !state.equals((Object)JobState.PREREQ_FAILED)) continue;
            this.setState(c, JobState.PREREQ_FAILED);
            return;
        }
    }

    public JobState getState(Class<? extends ThraxJob> jobClass) {
        return this.jobs.get(jobClass);
    }

    public boolean isScheduled(Class<? extends ThraxJob> jobClass) {
        return this.jobs.containsKey(jobClass);
    }

    public Set<Class<? extends ThraxJob>> getClassesByState(JobState state) {
        HashSet<Class<? extends ThraxJob>> result = new HashSet<Class<? extends ThraxJob>>();
        for (Class<? extends ThraxJob> c : this.jobs.keySet()) {
            if (!this.jobs.get(c).equals((Object)state)) continue;
            result.add(c);
        }
        return result;
    }

    public int numJobs() {
        return this.jobs.size();
    }

    public boolean notFinished() {
        for (Class<? extends ThraxJob> c : this.jobs.keySet()) {
            JobState state = this.jobs.get(c);
            if (!state.equals((Object)JobState.READY) && !state.equals((Object)JobState.WAITING) && !state.equals((Object)JobState.RUNNING)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Class<? extends ThraxJob> c : this.jobs.keySet()) {
            sb.append(c + "\t" + (Object)((Object)this.jobs.get(c)));
            sb.append("\n");
        }
        return sb.toString();
    }
}

