/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.hadoop.paraphrasing;

import edu.jhu.thrax.hadoop.datatypes.Annotation;
import edu.jhu.thrax.hadoop.datatypes.FeatureMap;
import edu.jhu.thrax.hadoop.datatypes.RuleWritable;
import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.hadoop.features.SimpleFeatureFactory;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeatureFactory;
import edu.jhu.thrax.hadoop.features.pivot.PivotedAnnotationFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeatureFactory;
import edu.jhu.thrax.util.BackwardsCompatibility;
import edu.jhu.thrax.util.FormatUtils;
import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;

public class AggregationReducer
extends Reducer<RuleWritable, FeatureMap, Text, NullWritable> {
    private boolean label;
    private boolean sparse;
    private List<SimpleFeature> simpleFeatures;
    private List<PivotedFeature> pivotedFeatures;
    private List<AnnotationFeature> annotationFeatures;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        String vocabulary_path = conf.getRaw("thrax.work-dir") + "vocabulary/part-*";
        Vocabulary.initialize(conf, vocabulary_path);
        this.label = conf.getBoolean("thrax.label-feature-scores", true);
        this.sparse = conf.getBoolean("thrax.sparse-feature-vectors", false);
        this.simpleFeatures = new ArrayList<SimpleFeature>();
        this.pivotedFeatures = new ArrayList<PivotedFeature>();
        this.annotationFeatures = new ArrayList<AnnotationFeature>();
        String features = BackwardsCompatibility.equivalent(conf.get("thrax.features", ""));
        for (String f_name : FormatUtils.P_COMMA_OR_SPACE.split(features)) {
            PivotedFeature pf = PivotedFeatureFactory.get(f_name);
            if (pf != null) {
                this.pivotedFeatures.add(pf);
                continue;
            }
            AnnotationFeature af = AnnotationFeatureFactory.get(f_name);
            if (af != null) {
                this.annotationFeatures.add(af);
                continue;
            }
            SimpleFeature sf = SimpleFeatureFactory.get(f_name);
            if (sf == null) continue;
            this.simpleFeatures.add(sf);
        }
        if (!this.annotationFeatures.isEmpty()) {
            this.pivotedFeatures.add(new PivotedAnnotationFeature());
        }
        for (AnnotationFeature af : this.annotationFeatures) {
            af.init(context);
        }
    }

    protected void reduce(RuleWritable key, Iterable<FeatureMap> values, Reducer.Context context) throws IOException, InterruptedException {
        RuleWritable rule = new RuleWritable(key);
        TreeMap<String, Writable> features = new TreeMap<String, Writable>();
        for (PivotedFeature pivotedFeature : this.pivotedFeatures) {
            pivotedFeature.initializeAggregation();
        }
        for (FeatureMap featureMap : values) {
            for (PivotedFeature feature : this.pivotedFeatures) {
                try {
                    feature.aggregate(featureMap);
                }
                catch (Exception e) {
                    throw new RuntimeException(rule.toString() + " on " + feature.getName() + ": " + e.getMessage());
                }
            }
        }
        for (PivotedFeature pivotedFeature : this.pivotedFeatures) {
            features.put(pivotedFeature.getLabel(), pivotedFeature.finalizeAggregation());
        }
        for (SimpleFeature simpleFeature : this.simpleFeatures) {
            features.put(simpleFeature.getLabel(), simpleFeature.score(rule));
        }
        for (AnnotationFeature annotationFeature : this.annotationFeatures) {
            features.put(annotationFeature.getLabel(), annotationFeature.score(rule, (Annotation)features.get("Annotation")));
        }
        features.remove("Annotation");
        context.write((Object)FormatUtils.ruleToText(rule, features, this.label, this.sparse), (Object)NullWritable.get());
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
    }
}

