/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.lexprob;

import edu.jhu.thrax.lexprob.SequenceFileLexprobTable;
import edu.jhu.thrax.lexprob.TableEntry;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;

public class HashMapLexprobTable
extends SequenceFileLexprobTable {
    private HashMap<Long, Float> table;

    public HashMapLexprobTable(Configuration conf, String fileGlob) throws IOException {
        super(conf, fileGlob);
        Iterable<TableEntry> entries = HashMapLexprobTable.getSequenceFileIterator(this.fs, conf, this.files);
        this.initialize(entries);
    }

    @Override
    public void initialize(Iterable<TableEntry> entries) {
        this.table = new HashMap();
        for (TableEntry te : entries) {
            this.table.put((long)te.car << 32 | (long)te.cdr, Float.valueOf(te.probability));
            if (this.table.size() % 1000 != 0) continue;
            System.err.printf("[%d]\n", this.table.size());
        }
    }

    @Override
    public float get(int car, int cdr) {
        long pair = (long)car << 32 | (long)cdr;
        if (this.table.containsKey(pair)) {
            return this.table.get(pair).floatValue();
        }
        return -1.0f;
    }

    @Override
    public boolean contains(int car, int cdr) {
        long pair = (long)car << 32 | (long)cdr;
        return this.table.containsKey(pair);
    }
}

