/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.lexprob;

import edu.jhu.thrax.lexprob.TableEntry;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public abstract class SequenceFileLexprobTable {
    protected FileSystem fs;
    protected URI uri;
    protected FileStatus[] files;

    public SequenceFileLexprobTable(Configuration conf, String fileGlob) throws IOException {
        this.uri = URI.create(fileGlob);
        this.fs = FileSystem.get((URI)this.uri, (Configuration)conf);
        this.files = this.fs.globStatus(new Path(fileGlob));
        if (this.files.length == 0) {
            throw new IOException("no files found in lexprob glob:" + fileGlob);
        }
    }

    protected abstract void initialize(Iterable<TableEntry> var1);

    public abstract float get(int var1, int var2);

    public abstract boolean contains(int var1, int var2);

    protected static Iterable<TableEntry> getSequenceFileIterator(FileSystem theFS, Configuration conf, FileStatus[] files) {
        final LongWritable pair = new LongWritable();
        final FloatWritable d = new FloatWritable(0.0f);
        final FileStatus[] theFiles = files;
        final Configuration theConf = conf;
        final FileSystem fs = theFS;
        final Iterator<TableEntry> iterator = new Iterator<TableEntry>(){
            int fileIndex = 0;
            TableEntry lookahead = null;
            SequenceFile.Reader reader = null;

            @Override
            public boolean hasNext() {
                try {
                    boolean gotNew;
                    if (this.lookahead != null) {
                        return true;
                    }
                    if (this.reader == null) {
                        this.reader = new SequenceFile.Reader(fs, theFiles[0].getPath(), theConf);
                    }
                    if (gotNew = this.reader.next((Writable)pair, (Writable)d)) {
                        this.lookahead = new TableEntry(pair, d);
                        return true;
                    }
                    ++this.fileIndex;
                    if (this.fileIndex >= theFiles.length) {
                        return false;
                    }
                    this.reader.close();
                    this.reader = new SequenceFile.Reader(fs, theFiles[this.fileIndex].getPath(), theConf);
                    gotNew = this.reader.next((Writable)pair, (Writable)d);
                    if (gotNew) {
                        this.lookahead = new TableEntry(pair, d);
                        return true;
                    }
                    return false;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public TableEntry next() {
                try {
                    if (this.lookahead != null) {
                        TableEntry val = this.lookahead;
                        this.lookahead = null;
                        return val;
                    }
                    boolean gotNew = this.reader.next((Writable)pair, (Writable)d);
                    if (gotNew) {
                        return new TableEntry(pair, d);
                    }
                    return null;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<TableEntry>(){

            @Override
            public Iterator<TableEntry> iterator() {
                return iterator;
            }
        };
    }
}

