/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.lexprob;

import edu.jhu.thrax.util.Vocabulary;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;

public class TableEntry {
    public final int car;
    public final int cdr;
    public final float probability;

    public TableEntry(LongWritable pair, FloatWritable d) {
        int first = (int)(pair.get() >> 32);
        this.car = first < 0 ? Vocabulary.getUnknownId() : first;
        this.cdr = (int)pair.get();
        this.probability = d.get();
    }

    public String toString() {
        return String.format("(%s,%s):%.4f", this.car, this.cdr, Float.valueOf(this.probability));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableEntry)) {
            return false;
        }
        TableEntry te = (TableEntry)o;
        return this.car == te.car && this.cdr == te.cdr && this.probability == te.probability;
    }
}

