/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.lexprob;

import edu.jhu.thrax.lexprob.SequenceFileLexprobTable;
import edu.jhu.thrax.lexprob.TableEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class TrieLexprobTable
extends SequenceFileLexprobTable {
    private int[] cars;
    private int[][] cdrs;
    private float[][] values;

    public TrieLexprobTable(Configuration conf, String fileGlob) throws IOException {
        super(conf, fileGlob);
        Iterable<TableEntry> entries = TrieLexprobTable.getSequenceFileIterator(this.fs, conf, this.files);
        int size = TrieLexprobTable.getNumCars(entries);
        this.cars = new int[size];
        this.cdrs = new int[size][];
        this.values = new float[size][];
        entries = TrieLexprobTable.getSequenceFileIterator(this.fs, conf, this.files);
        this.initialize(entries);
    }

    private static int getNumCars(Iterable<TableEntry> entries) {
        int result = 0;
        int prev = -1;
        for (TableEntry te : entries) {
            if (te.car == prev) continue;
            ++result;
            prev = te.car;
        }
        return result;
    }

    @Override
    protected void initialize(Iterable<TableEntry> entries) {
        int i = 0;
        int car = -1;
        ArrayList<Integer> cdrList = new ArrayList<Integer>();
        ArrayList<Float> valueList = new ArrayList<Float>();
        for (TableEntry te : entries) {
            if (car == -1) {
                this.cars[i] = car = te.car;
            }
            if (te.car != car) {
                this.cdrs[i] = TrieLexprobTable.intArray(cdrList);
                this.values[i] = TrieLexprobTable.floatArray(valueList);
                cdrList.clear();
                valueList.clear();
                if (++i % 1000 == 0) {
                    System.err.printf("[%d]\n", i);
                }
                this.cars[i] = te.car;
                car = this.cars[i];
            }
            cdrList.add(te.cdr);
            valueList.add(Float.valueOf(te.probability));
        }
        this.cdrs[i] = TrieLexprobTable.intArray(cdrList);
        this.values[i] = TrieLexprobTable.floatArray(valueList);
    }

    private static float[] floatArray(List<Float> list) {
        float[] result = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).floatValue();
        }
        return result;
    }

    private static int[] intArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    @Override
    public float get(int car, int cdr) {
        int i = Arrays.binarySearch(this.cars, car);
        if (i < 0) {
            return 0.0f;
        }
        int j = Arrays.binarySearch(this.cdrs[i], cdr);
        if (j < 0) {
            return 0.0f;
        }
        return this.values[i][j];
    }

    @Override
    public boolean contains(int car, int cdr) {
        int i = Arrays.binarySearch(this.cars, car);
        if (i < 0) {
            return false;
        }
        return Arrays.binarySearch(this.cdrs[i], cdr) >= 0;
    }
}

