/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.syntax;

import edu.jhu.thrax.syntax.ParseLattice;
import edu.jhu.thrax.util.ExternalizableToUtf8;
import edu.jhu.thrax.util.Vocabulary;
import edu.jhu.thrax.util.exceptions.MalformedParseException;
import edu.jhu.thrax.util.io.LineReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class LatticeArray
implements ParseLattice,
Externalizable,
ExternalizableToUtf8 {
    private static final long serialVersionUID = 8078L;
    private ArrayList<Integer> forwardIndex;
    private ArrayList<Integer> forwardLattice;
    private ArrayList<Integer> backwardIndex;
    private ArrayList<Integer> backwardLattice;
    private ArrayList<Integer> pre_terminals;
    private ArrayList<Integer> terminals;
    private final boolean lowercase;
    private boolean useBackwardLattice = true;
    private static final int MAX_CONCATENATIONS = 3;
    private static final int MAX_LABELS = 100;
    private String UNARY_CATEGORY_HANDLER = "all";

    public LatticeArray() {
        this.forwardIndex = null;
        this.forwardLattice = null;
        this.backwardIndex = null;
        this.backwardLattice = null;
        this.terminals = null;
        this.pre_terminals = null;
        this.lowercase = false;
    }

    public LatticeArray(String parsed_line) throws MalformedParseException {
        this(parsed_line, false);
    }

    public LatticeArray(String parsed_line, String unaryHandler) throws MalformedParseException {
        this(parsed_line, unaryHandler, false);
    }

    public LatticeArray(String parsed_line, boolean lowercase) throws MalformedParseException {
        this.lowercase = lowercase;
        this.initialize();
        this.appendFromPennFormat(parsed_line);
    }

    public LatticeArray(String parsed_line, String unaryHandler, boolean lowercase) throws MalformedParseException {
        this.UNARY_CATEGORY_HANDLER = unaryHandler;
        this.lowercase = lowercase;
        this.initialize();
        this.appendFromPennFormat(parsed_line);
    }

    public String getTerminal(int i) {
        return Vocabulary.word(this.terminals.get(i));
    }

    public String[] getTerminals() {
        return this.getTerminals(0, this.terminals.size());
    }

    public String[] getTerminals(int from, int to) {
        String[] span = new String[to - from];
        for (int i = from; i < to; ++i) {
            span[i - from] = Vocabulary.word(this.terminals.get(i));
        }
        return span;
    }

    public String getTerminalPhrase(int from, int to) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < to; ++i) {
            sb.append(Vocabulary.word(this.terminals.get(i)) + " ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getPOS(int i) {
        return Vocabulary.word(this.pre_terminals.get(i));
    }

    public String[] getPOS() {
        return this.getPOS(0, this.pre_terminals.size());
    }

    public String[] getPOS(int from, int to) {
        String[] span = new String[to - from];
        for (int i = from; i < to; ++i) {
            span[i - from] = Vocabulary.word(this.pre_terminals.get(i));
        }
        return span;
    }

    public String getPOSPhrase(int from, int to) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < to; ++i) {
            sb.append(Vocabulary.word(this.pre_terminals.get(i)) + " ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Override
    public Collection<Integer> getConstituentLabels(int from, int to) {
        HashSet<Integer> labels = new HashSet<Integer>();
        int span_length = to - from;
        for (int i = this.forwardIndex.get(from).intValue(); i < this.forwardIndex.get(from + 1); i += 2) {
            int current_span = this.forwardLattice.get(i + 1);
            if (current_span == span_length) {
                labels.add(this.forwardLattice.get(i));
                continue;
            }
            if (current_span < span_length) break;
        }
        return labels;
    }

    public int getOneConstituent(int from, int to) {
        int spanLength = to - from;
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = this.forwardIndex.get(from).intValue(); i < this.forwardIndex.get(from + 1); i += 2) {
            int currentSpan = this.forwardLattice.get(i + 1);
            if (currentSpan == spanLength) {
                if ("top".equals(this.UNARY_CATEGORY_HANDLER)) {
                    return this.forwardLattice.get(i);
                }
                stack.push(this.forwardLattice.get(i));
                continue;
            }
            if (currentSpan < spanLength) break;
        }
        if (stack.isEmpty()) {
            return -1;
        }
        if ("bottom".equals(this.UNARY_CATEGORY_HANDLER)) {
            return (Integer)stack.pop();
        }
        StringBuilder sb = new StringBuilder();
        while (!stack.isEmpty()) {
            String w = Vocabulary.word((Integer)stack.pop());
            if (sb.length() != 0) {
                sb.append(":");
            }
            sb.append(w);
        }
        String label = sb.toString();
        return Vocabulary.id(label);
    }

    public int getOneSingleConcatenation(int from, int to) {
        for (int midpt = from + 1; midpt < to; ++midpt) {
            int y;
            int x = this.getOneConstituent(from, midpt);
            if (x < 0 || (y = this.getOneConstituent(midpt, to)) < 0) continue;
            String label = Vocabulary.word(x) + "+" + Vocabulary.word(y);
            return Vocabulary.id(label);
        }
        return -1;
    }

    public int getOneDoubleConcatenation(int from, int to) {
        for (int a = from + 1; a < to - 1; ++a) {
            for (int b = a + 1; b < to; ++b) {
                int z;
                int y;
                int x = this.getOneConstituent(from, a);
                if (x < 0 || (y = this.getOneConstituent(a, b)) < 0 || (z = this.getOneConstituent(b, to)) < 0) continue;
                String label = Vocabulary.word(x) + "+" + Vocabulary.word(y) + "+" + Vocabulary.word(z);
                return Vocabulary.id(label);
            }
        }
        return -1;
    }

    public int getOneRightSideCCG(int from, int to) {
        for (int end = to + 1; end <= this.forwardLattice.size(); ++end) {
            int y;
            int x = this.getOneConstituent(from, end);
            if (x < 0 || (y = this.getOneConstituent(to, end)) < 0) continue;
            String label = Vocabulary.word(x) + "/" + Vocabulary.word(y);
            return Vocabulary.id(label);
        }
        return -1;
    }

    public int getOneLeftSideCCG(int from, int to) {
        for (int start = from - 1; start >= 0; --start) {
            int y;
            int x = this.getOneConstituent(start, to);
            if (x < 0 || (y = this.getOneConstituent(start, from)) < 0) continue;
            String label = Vocabulary.word(y) + "\\" + Vocabulary.word(x);
            return Vocabulary.id(label);
        }
        return -1;
    }

    @Override
    public Collection<Integer> getConcatenatedLabels(int from, int to) {
        HashSet<Integer> labels = new HashSet<Integer>();
        int span_length = to - from;
        Stack<Integer> nt_stack = new Stack<Integer>();
        Stack<Integer> pos_stack = new Stack<Integer>();
        Stack<Integer> depth_stack = new Stack<Integer>();
        for (int i = this.forwardIndex.get(from + 1) - 2; i >= this.forwardIndex.get(from); i -= 2) {
            int current_span = this.forwardLattice.get(i + 1);
            if (current_span < span_length) {
                nt_stack.push(this.forwardLattice.get(i));
                pos_stack.push(from + current_span);
                depth_stack.push(1);
                continue;
            }
            if (current_span >= span_length) break;
        }
        while (!nt_stack.isEmpty() && labels.size() < 100) {
            int current_span;
            int nt = (Integer)nt_stack.pop();
            int pos = (Integer)pos_stack.pop();
            int depth = (Integer)depth_stack.pop();
            if (depth == 3) continue;
            int remaining_span = to - pos;
            for (int i = this.forwardIndex.get(pos + 1) - 2; i >= this.forwardIndex.get(pos) && (current_span = this.forwardLattice.get(i + 1).intValue()) <= remaining_span; i -= 2) {
                int concatenated_nt = Vocabulary.id(Vocabulary.word(nt) + "+" + Vocabulary.word(this.forwardLattice.get(i)));
                if (current_span < remaining_span) {
                    nt_stack.push(concatenated_nt);
                    pos_stack.push(pos + current_span);
                    depth_stack.push(depth + 1);
                    continue;
                }
                if (current_span != remaining_span) continue;
                labels.add(concatenated_nt);
            }
        }
        return labels;
    }

    @Override
    public Collection<Integer> getCcgLabels(int from, int to) {
        boolean is_prefix;
        HashSet<Integer> labels = new HashSet<Integer>();
        int span_length = to - from;
        boolean bl = is_prefix = this.forwardLattice.get(this.forwardIndex.get(from) + 1) > span_length;
        if (is_prefix) {
            int current_span;
            int i;
            HashMap main_constituents = new HashMap();
            for (i = this.forwardIndex.get(from).intValue(); i < this.forwardIndex.get(from + 1) && (current_span = this.forwardLattice.get(i + 1).intValue()) > span_length; i += 2) {
                int end_pos = this.forwardLattice.get(i + 1) + from;
                Set nts = (Set)main_constituents.get(end_pos);
                if (nts == null) {
                    main_constituents.put(end_pos, new HashSet());
                }
                ((Set)main_constituents.get(end_pos)).add(this.forwardLattice.get(i));
            }
            for (i = this.forwardIndex.get(to).intValue(); i < this.forwardIndex.get(to + 1); i += 2) {
                Set main_set = (Set)main_constituents.get(to + this.forwardLattice.get(i + 1));
                if (main_set == null) continue;
                Iterator i$ = main_set.iterator();
                while (i$.hasNext()) {
                    int main = (Integer)i$.next();
                    labels.add(Vocabulary.id(Vocabulary.word(main) + "/" + Vocabulary.word(this.forwardLattice.get(i))));
                }
            }
        }
        if (!is_prefix && this.useBackwardLattice) {
            int current_span;
            int i;
            int to_end;
            int n = to_end = to == this.backwardIndex.size() - 1 ? this.backwardLattice.size() : this.backwardIndex.get(to + 1).intValue();
            if (this.backwardLattice.get(to_end - 1) <= span_length) {
                return labels;
            }
            HashMap main_constituents = new HashMap();
            for (i = to_end - 2; i >= this.backwardIndex.get(to) && (current_span = this.backwardLattice.get(i + 1).intValue()) > span_length; i -= 2) {
                int start_pos = to - this.backwardLattice.get(i + 1);
                Set nts = (Set)main_constituents.get(start_pos);
                if (nts == null) {
                    main_constituents.put(start_pos, new HashSet());
                }
                ((Set)main_constituents.get(start_pos)).add(this.backwardLattice.get(i));
            }
            for (i = this.backwardIndex.get(from).intValue(); i < this.backwardIndex.get(from + 1); i += 2) {
                Set main_set = (Set)main_constituents.get(from - this.backwardLattice.get(i + 1));
                if (main_set == null) continue;
                Iterator i$ = main_set.iterator();
                while (i$.hasNext()) {
                    int main = (Integer)i$.next();
                    labels.add(Vocabulary.id(Vocabulary.word(main) + "\\" + Vocabulary.word(this.backwardLattice.get(i))));
                }
            }
        }
        return labels;
    }

    public int size() {
        return this.terminals.size();
    }

    @Override
    public void readExternalUtf8(String file_name) throws IOException {
        LineReader reader = new LineReader(file_name);
        this.initialize();
        for (String line : reader) {
            if (line.trim().equals("")) continue;
            try {
                this.appendFromPennFormat(line);
            }
            catch (MalformedParseException e) {
                throw new IOException(line, e);
            }
        }
    }

    @Override
    public void writeExternalUtf8(String file_name) throws IOException {
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.forwardIndex.size(); ++i) {
            sb.append("FI[" + i + "] =\t" + this.forwardIndex.get(i) + "\n");
        }
        sb.append("\n");
        for (i = 0; i < this.forwardLattice.size(); i += 2) {
            sb.append("F[" + i + "] =\t" + Vocabulary.word(this.forwardLattice.get(i)) + " , " + this.forwardLattice.get(i + 1) + "\n");
        }
        if (this.useBackwardLattice) {
            sb.append("\n");
            for (i = 0; i < this.backwardIndex.size(); ++i) {
                sb.append("BI[" + i + "] =\t" + this.backwardIndex.get(i) + "\n");
            }
            sb.append("\n");
            for (i = 0; i < this.backwardLattice.size(); i += 2) {
                sb.append("B[" + i + "] =\t" + Vocabulary.word(this.backwardLattice.get(i)) + " , " + this.backwardLattice.get(i + 1) + "\n");
            }
        }
        return sb.toString();
    }

    private void initialize() {
        this.forwardIndex = new ArrayList();
        this.forwardIndex.add(0);
        this.forwardLattice = new ArrayList();
        if (this.useBackwardLattice) {
            this.backwardIndex = new ArrayList();
            this.backwardIndex.add(0);
            this.backwardLattice = new ArrayList();
        }
        this.terminals = new ArrayList();
        this.pre_terminals = new ArrayList();
    }

    private void appendFromPennFormat(String line) throws MalformedParseException {
        String[] tokens = line.replaceAll("\\(", " ( ").replaceAll("\\)", " ) ").trim().split("\\s+");
        boolean next_nt = false;
        boolean pos = false;
        int current_id = 0;
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if ("(".equals(token)) {
                next_nt = true;
                continue;
            }
            if (!(i >= tokens.length - 1 || ")".equals(token) || "(".equals(token) || ")".equals(tokens[i + 1]) || "(".equals(tokens[i + 1]))) {
                pos = true;
            }
            if (")".equals(token)) {
                try {
                    int closing_pos = (Integer)stack.pop();
                    this.forwardLattice.set(closing_pos, this.forwardIndex.size() - this.forwardLattice.get(closing_pos));
                    if (!this.useBackwardLattice) continue;
                    this.backwardLattice.add(this.forwardLattice.get(closing_pos - 1));
                    this.backwardLattice.add(this.forwardLattice.get(closing_pos));
                    continue;
                }
                catch (EmptyStackException e) {
                    throw new MalformedParseException(line);
                }
            }
            if (next_nt) {
                if (",".equals(token)) {
                    token = "COMMA";
                }
                current_id = Vocabulary.id(token);
                this.forwardLattice.add(current_id);
                stack.push(this.forwardLattice.size());
                this.forwardLattice.add(this.forwardIndex.size());
                if (pos) {
                    this.pre_terminals.add(current_id);
                }
            } else {
                current_id = Vocabulary.id(this.lowercase ? token.toLowerCase() : token);
                this.terminals.add(current_id);
                this.forwardIndex.add(this.forwardLattice.size());
                if (this.useBackwardLattice) {
                    this.backwardIndex.add(this.backwardLattice.size());
                }
            }
            next_nt = false;
            pos = false;
        }
    }

    public static void main(String[] args) {
        LatticeArray la = new LatticeArray();
        try {
            la.readExternalUtf8(args[0]);
            int from = Integer.parseInt(args[1]);
            int to = Integer.parseInt(args[2]);
            if (from < to) {
                Collection<Integer> labels = la.getConstituentLabels(from, to);
                for (int l : labels) {
                    System.err.println(Vocabulary.word(l));
                }
                labels = la.getConcatenatedLabels(from, to);
                for (int l : labels) {
                    System.err.println(Vocabulary.word(l));
                }
                labels = la.getCcgLabels(from, to);
                for (int l : labels) {
                    System.err.println(Vocabulary.word(l));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

