/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.syntax;

import edu.jhu.thrax.util.Vocabulary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;

public class ParseTree {
    private final int[] labels;
    private final int[] numChildren;
    private final int[] start;
    private final int[] end;

    private ParseTree(int[] ls, int[] cs, int[] ss, int[] es) {
        this.labels = ls;
        this.numChildren = cs;
        this.start = ss;
        this.end = es;
    }

    public static ParseTree fromPennFormat(String s) {
        ArrayList<Integer> ls = new ArrayList<Integer>();
        ArrayList<Integer> cs = new ArrayList<Integer>();
        ArrayList<Integer> ss = new ArrayList<Integer>();
        ArrayList<Integer> es = new ArrayList<Integer>();
        try {
            ParseTree.buildLists(ls, cs, ss, es, s);
        }
        catch (EmptyStackException e) {
            return null;
        }
        int size = ls.size();
        int[] labels = new int[size];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = (Integer)ls.get(i);
        }
        int[] numChildren = ParseTree.toIntArray(cs);
        int[] start = ParseTree.toIntArray(ss);
        int[] end = ParseTree.toIntArray(es);
        return new ParseTree(labels, numChildren, start, end);
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    private static void addToken(List<Integer> ls, List<Integer> cs, List<Integer> ss, List<Integer> es, int label, int start, int end) {
        ls.add(label);
        cs.add(0);
        ss.add(start);
        es.add(end);
    }

    private static void increment(List<Integer> list, int index) {
        list.set(index, list.get(index) + 1);
    }

    private static void buildLists(List<Integer> ls, List<Integer> cs, List<Integer> ss, List<Integer> es, String line) {
        String input = line.trim();
        Stack<Integer> ancestors = new Stack<Integer>();
        int count = 0;
        int from = 0;
        int to = 0;
        boolean seeking = true;
        boolean nonterminal = false;
        while (from < input.length() && to < input.length()) {
            char current;
            if (seeking) {
                current = input.charAt(from);
                if (current == '(') {
                    ++from;
                    nonterminal = true;
                    continue;
                }
                if (current == ')') {
                    ++from;
                    ancestors.pop();
                    continue;
                }
                if (current == ' ') {
                    ++from;
                    continue;
                }
                to = from + 1;
                seeking = false;
                continue;
            }
            current = input.charAt(to);
            if (current == ' ' || current == ')' || current == '(') {
                if (nonterminal) {
                    String nt = input.substring(from, to);
                    if (nt.equals(",")) {
                        nt = "COMMA";
                    }
                    int token = Vocabulary.id("[" + nt + "]");
                    nonterminal = false;
                    ParseTree.addToken(ls, cs, ss, es, token, count, count);
                    if (!ancestors.empty()) {
                        ParseTree.increment(cs, (Integer)ancestors.peek());
                    }
                    ancestors.push(ls.size() - 1);
                } else {
                    int token = Vocabulary.id(input.substring(from, to));
                    ParseTree.addToken(ls, cs, ss, es, token, count, count + 1);
                    Iterator i$ = ancestors.iterator();
                    while (i$.hasNext()) {
                        int i = (Integer)i$.next();
                        ParseTree.increment(es, i);
                    }
                    if (!ancestors.empty()) {
                        ParseTree.increment(cs, (Integer)ancestors.peek());
                    }
                    ++count;
                }
                from = to;
                seeking = true;
                continue;
            }
            ++to;
        }
    }

    public Node root() {
        return new Node(0);
    }

    public int numLeaves() {
        return this.end[0];
    }

    public int numNodes() {
        return this.labels.length;
    }

    public List<Node> internalNodesWithSpan(int from, int to) {
        int index = ParseTree.firstIndexOf(this.start, from);
        if (index < 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        while (index < this.start.length && this.start[index] == from && this.end[index] >= to) {
            if (this.end[index] == to && this.numChildren[index] > 0) {
                result.add(new Node(index));
            }
            ++index;
        }
        return result;
    }

    private static int firstIndexOf(int[] array, int key) {
        int result = Arrays.binarySearch(array, key);
        if (result < 0) {
            return result;
        }
        while (result >= 0 && array[result] == key) {
            --result;
        }
        return result + 1;
    }

    public String toString() {
        return this.root().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseTree)) {
            return false;
        }
        ParseTree other = (ParseTree)o;
        return Arrays.equals(this.labels, other.labels) && Arrays.equals(this.numChildren, other.numChildren) && Arrays.equals(this.start, other.start) && Arrays.equals(this.end, other.end);
    }

    public int hashCode() {
        int result = 163;
        result = result * 37 + Arrays.hashCode(this.labels);
        result = result * 37 + Arrays.hashCode(this.numChildren);
        result = result * 37 + Arrays.hashCode(this.start);
        result = result * 37 + Arrays.hashCode(this.end);
        return result;
    }

    public static void main(String[] argv) throws IOException {
        Scanner scanner = new Scanner(System.in);
        while (scanner.hasNextLine()) {
            ParseTree tree = ParseTree.fromPennFormat(scanner.nextLine());
            System.out.printf("%s\t%d\n", tree, tree.hashCode());
        }
        scanner.close();
    }

    private class ChildIterator
    implements Iterator<Node> {
        private final int index;
        private final int totalChildren;
        private int childrenSeen;
        private int childIndex;

        public ChildIterator(int i) {
            this.index = i;
            this.totalChildren = ParseTree.this.numChildren[this.index];
            this.childrenSeen = 0;
            this.childIndex = this.index + 1;
        }

        @Override
        public boolean hasNext() {
            return this.childrenSeen < this.totalChildren;
        }

        @Override
        public Node next() {
            Node result = new Node(this.childIndex);
            this.childIndex = this.nextSiblingIndex(this.childIndex);
            ++this.childrenSeen;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int nextSiblingIndex(int i) {
            int result = i + 1;
            int children = ParseTree.this.numChildren[i];
            for (int j = 0; j < children; ++j) {
                result = this.nextSiblingIndex(result);
            }
            return result;
        }
    }

    public class Node {
        private final int index;

        public Node(int i) {
            this.index = i;
        }

        public int label() {
            return ParseTree.this.labels[this.index];
        }

        public int numChildren() {
            return ParseTree.this.numChildren[this.index];
        }

        public int spanStart() {
            return ParseTree.this.start[this.index];
        }

        public int spanEnd() {
            return ParseTree.this.end[this.index];
        }

        public Iterator<Node> children() {
            return new ChildIterator(this.index);
        }

        public String toString() {
            if (this.isLeaf()) {
                return Vocabulary.word(this.label());
            }
            String result = String.format("(%s", this.label());
            Iterator<Node> children = this.children();
            while (children.hasNext()) {
                result = result + " " + children.next().toString();
            }
            result = result + ")";
            return result;
        }

        public boolean isLeaf() {
            return this.numChildren() == 0;
        }
    }
}

