/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.util;

import edu.jhu.thrax.util.DefaultConfigFileLoader;
import edu.jhu.thrax.util.amazon.AmazonConfigFileLoader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ConfFileParser {
    public static Map<String, String> parse(String confName) {
        Scanner scanner;
        HashMap<String, String> opts = new HashMap<String, String>();
        try {
            URI configURI = new URI(confName);
            String scheme = configURI.getScheme();
            scanner = scheme != null && (scheme.equalsIgnoreCase("s3n") || scheme.equalsIgnoreCase("s3")) ? new Scanner(AmazonConfigFileLoader.getConfigStream(configURI)) : new Scanner(DefaultConfigFileLoader.getConfigStream(configURI));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        while (scanner.hasNextLine()) {
            String[] keyVal;
            String line = scanner.nextLine();
            if (line.indexOf("#") != -1) {
                line = line.substring(0, line.indexOf("#")).trim();
            }
            if ("".equals(line) || (keyVal = line.split("\\s+", 2)).length <= 1) continue;
            opts.put(keyVal[0].trim(), keyVal[1].trim());
        }
        scanner.close();
        return opts;
    }
}

