/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class GrammarComparison {
    private static final String SEPARATOR = "|||";
    private static final String USAGE = "usage: GrammarComparison <grammar> <grammar> <prefix for output files>";

    public static void main(String[] argv) {
        if (argv.length < 3) {
            System.err.println(USAGE);
            return;
        }
        String file1 = argv[0];
        String file2 = argv[1];
        String outputBase = argv[2];
        try {
            HashSet<String> grammar1 = GrammarComparison.getRulesFromFile(file1);
            HashSet<String> alsoGrammar1 = GrammarComparison.getRulesFromFile(file1);
            HashSet<String> grammar2 = GrammarComparison.getRulesFromFile(file2);
            HashSet<String> smaller = grammar1.size() < grammar2.size() ? grammar1 : grammar2;
            HashSet<String> larger = smaller == grammar1 ? grammar2 : grammar1;
            HashSet<String> intersection = new HashSet<String>();
            for (String s : smaller) {
                if (!larger.contains(s)) continue;
                intersection.add(s);
            }
            alsoGrammar1.removeAll(grammar2);
            grammar2.removeAll(grammar1);
            GrammarComparison.printRules(alsoGrammar1, outputBase + ".1");
            GrammarComparison.printRules(grammar2, outputBase + ".2");
            GrammarComparison.printRules(intersection, outputBase + ".both");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printRules(Set<String> rules, String filename) throws FileNotFoundException, SecurityException {
        PrintStream ps = new PrintStream(new FileOutputStream(filename));
        for (String s : rules) {
            ps.println(s);
        }
        ps.close();
    }

    private static HashSet<String> getRulesFromFile(String filename) throws IOException {
        Scanner scanner = filename.endsWith(".gz") ? new Scanner((InputStream)new GZIPInputStream(new FileInputStream(new File(filename))), "UTF-8") : new Scanner(new File(filename), "UTF-8");
        HashSet<String> ret = new HashSet<String>();
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            String rule = line.substring(0, line.lastIndexOf(SEPARATOR));
            ret.add(rule);
        }
        scanner.close();
        return ret;
    }
}

