/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class Intersect {
    private static HashMap<String, ArrayList<String>> rules;
    private static boolean ignoreNTs;

    public static void main(String[] argv) throws Exception {
        String outputPrefix;
        String file2;
        String file1;
        if (argv[0].equals("-X")) {
            file1 = argv[1];
            file2 = argv[2];
            outputPrefix = argv[3];
            ignoreNTs = true;
        } else {
            file1 = argv[0];
            file2 = argv[1];
            outputPrefix = argv[2];
            ignoreNTs = false;
        }
        Intersect.getRulesFromFile(file1);
        Scanner scanner = file2.endsWith(".gz") ? new Scanner((InputStream)new GZIPInputStream(new FileInputStream(new File(file2))), "UTF-8") : new Scanner(new File(file2), "UTF-8");
        PrintStream firstGrammar = new PrintStream(new FileOutputStream(outputPrefix + ".1"));
        PrintStream secondGrammar = new PrintStream(new FileOutputStream(outputPrefix + ".2"));
        while (scanner.hasNextLine()) {
            String s = scanner.nextLine();
            String r = Intersect.repr(s);
            if (!rules.containsKey(r)) continue;
            secondGrammar.println(s);
            for (String x : rules.get(r)) {
                firstGrammar.println(x);
            }
            rules.get(r).clear();
        }
        scanner.close();
        firstGrammar.close();
        secondGrammar.close();
    }

    private static String repr(String s) {
        String r = s.substring(0, s.lastIndexOf("|||"));
        if (ignoreNTs) {
            r = r.replaceAll("\\[[^]]+?\\]", "[X]");
        }
        return r;
    }

    private static void getRulesFromFile(String filename) throws IOException {
        rules = new HashMap();
        Scanner scanner = filename.endsWith(".gz") ? new Scanner((InputStream)new GZIPInputStream(new FileInputStream(new File(filename))), "UTF-8") : new Scanner(new File(filename), "UTF-8");
        while (scanner.hasNextLine()) {
            String s = scanner.nextLine();
            String r = Intersect.repr(s);
            if (rules.containsKey(r)) {
                rules.get(r).add(s);
                continue;
            }
            ArrayList<String> al = new ArrayList<String>();
            al.add(s);
            rules.put(r, al);
        }
        scanner.close();
    }
}

