/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.util;

import edu.jhu.thrax.hadoop.features.SimpleFeature;
import edu.jhu.thrax.hadoop.features.SimpleFeatureFactory;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeature;
import edu.jhu.thrax.hadoop.features.annotation.AnnotationFeatureFactory;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeature;
import edu.jhu.thrax.hadoop.features.mapred.MapReduceFeatureFactory;
import edu.jhu.thrax.hadoop.features.pivot.PivotedAnnotationFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeature;
import edu.jhu.thrax.hadoop.features.pivot.PivotedFeatureFactory;
import edu.jhu.thrax.util.BackwardsCompatibility;
import edu.jhu.thrax.util.FormatUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class Vocabulary {
    private static final Logger logger;
    private static TreeMap<String, Integer> stringToId;
    private static ArrayList<String> idToString;
    private static int head;
    private static final Integer lock;
    private static final int UNKNOWN_ID;
    private static final String UNKNOWN_WORD;
    public static final String START_SYM = "<s>";
    public static final String STOP_SYM = "</s>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean read(String file_name) throws IOException {
        Integer n = lock;
        synchronized (n) {
            File vocab_file = new File(file_name);
            DataInputStream vocab_stream = new DataInputStream(new BufferedInputStream(new FileInputStream(vocab_file)));
            int size = vocab_stream.readInt();
            logger.info("Reading vocabulary: " + size + " tokens.");
            Vocabulary.clear();
            for (int i = 0; i < size; ++i) {
                String token;
                int id = vocab_stream.readInt();
                if (id == Math.abs(Vocabulary.id(token = vocab_stream.readUTF()))) continue;
                vocab_stream.close();
                return false;
            }
            vocab_stream.close();
            return size + 1 == idToString.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Configuration conf) {
        Integer n = lock;
        synchronized (n) {
            Vocabulary.clear();
            Vocabulary.id(FormatUtils.markup(conf.get("thrax.default-nt", "X")));
            Vocabulary.id(FormatUtils.markup(conf.get("thrax.full-sentence-nt", "_S")));
            String type = conf.get("thrax.type", "translation");
            String features = BackwardsCompatibility.equivalent(conf.get("thrax.features", ""));
            if ("translation".equals(type)) {
                for (MapReduceFeature mapReduceFeature : MapReduceFeatureFactory.getAll(features)) {
                    Vocabulary.id(mapReduceFeature.getLabel());
                }
            } else if ("paraphrasing".equals(type)) {
                HashSet<String> prereq_features = new HashSet<String>();
                for (PivotedFeature f : PivotedFeatureFactory.getAll(features)) {
                    prereq_features.addAll(f.getPrerequisites());
                    Vocabulary.id(f.getLabel());
                }
                Vocabulary.id(new PivotedAnnotationFeature().getLabel());
                for (String prereq : prereq_features) {
                    MapReduceFeature mf = MapReduceFeatureFactory.get(prereq);
                    if (mf != null) {
                        Vocabulary.id(mf.getLabel());
                        continue;
                    }
                    AnnotationFeature af = AnnotationFeatureFactory.get(prereq);
                    if (af != null) {
                        Vocabulary.id(af.getLabel());
                        continue;
                    }
                    SimpleFeature sf = SimpleFeatureFactory.get(prereq);
                    if (sf == null) continue;
                    Vocabulary.id(sf.getLabel());
                }
            }
            for (AnnotationFeature annotationFeature : AnnotationFeatureFactory.getAll(features)) {
                Vocabulary.id(annotationFeature.getLabel());
            }
            for (SimpleFeature simpleFeature : SimpleFeatureFactory.getAll(features)) {
                Vocabulary.id(simpleFeature.getLabel());
            }
            head = Vocabulary.size();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Configuration conf, String file_glob) throws IOException {
        Integer n = lock;
        synchronized (n) {
            FileSystem file_system = FileSystem.get((URI)URI.create(file_glob), (Configuration)conf);
            FileStatus[] files = file_system.globStatus(new Path(file_glob));
            if (files.length == 0) {
                throw new IOException("No files found in vocabulary glob: " + file_glob);
            }
            Vocabulary.initialize(conf);
            for (FileStatus file : files) {
                SequenceFile.Reader reader = new SequenceFile.Reader(file_system, file.getPath(), conf);
                Text h_token = new Text();
                IntWritable h_id = new IntWritable();
                while (reader.next((Writable)h_id, (Writable)h_token)) {
                    int id = h_id.get();
                    String token = h_token.toString();
                    if (Vocabulary.insert(token, id)) continue;
                    reader.close();
                    throw new RuntimeException("Error inserting: " + token + " as " + id + ". Conflict: " + id + " => " + Vocabulary.word(id) + " and " + token + " => " + stringToId.get(token));
                }
                reader.close();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String file_name) throws IOException {
        Integer n = lock;
        synchronized (n) {
            File vocab_file = new File(file_name);
            DataOutputStream vocab_stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(vocab_file)));
            vocab_stream.writeInt(idToString.size() - 1);
            logger.info("Writing vocabulary: " + (idToString.size() - 1) + " tokens.");
            for (int i = 1; i < idToString.size(); ++i) {
                vocab_stream.writeInt(i);
                vocab_stream.writeUTF(idToString.get(i));
            }
            vocab_stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int id(String token) {
        Integer n = lock;
        synchronized (n) {
            Integer id = stringToId.get(token);
            if (id != null) {
                return id;
            }
            int new_id = idToString.size() * (Vocabulary.nt(token) ? -1 : 1);
            idToString.add(token);
            stringToId.put(token, new_id);
            return new_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean insert(String token, int set_id) {
        Integer n = lock;
        synchronized (n) {
            Integer id = stringToId.get(token);
            if (id != null) {
                return Math.abs(set_id) == Math.abs(id);
            }
            if (Vocabulary.nt(token) && set_id > 0) {
                set_id = -set_id;
            }
            idToString.ensureCapacity(Math.abs(set_id) + 1);
            for (int i = idToString.size(); i <= Math.abs(set_id); ++i) {
                idToString.add(null);
            }
            idToString.set(Math.abs(set_id), token);
            stringToId.put(token, set_id);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasId(int id) {
        Integer n = lock;
        synchronized (n) {
            id = Math.abs(id);
            return id < idToString.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] addAll(String sentence) {
        Integer n = lock;
        synchronized (n) {
            String[] tokens = FormatUtils.P_SPACE.split(sentence);
            int[] ids = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                ids[i] = Vocabulary.id(tokens[i]);
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String word(int id) {
        Integer n = lock;
        synchronized (n) {
            id = Math.abs(id);
            if (id >= idToString.size()) {
                throw new UnknownSymbolException(id);
            }
            return idToString.get(id);
        }
    }

    public static String getWords(int[] ids) {
        if (ids.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.length - 1; ++i) {
            sb.append(Vocabulary.word(ids[i])).append(" ");
        }
        return sb.append(Vocabulary.word(ids[ids.length - 1])).toString();
    }

    public static String getWords(Iterable<Integer> ids) {
        StringBuilder sb = new StringBuilder();
        for (int id : ids) {
            sb.append(Vocabulary.word(id)).append(" ");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static int getUnknownId() {
        return UNKNOWN_ID;
    }

    public static String getUnknownWord() {
        return UNKNOWN_WORD;
    }

    public static boolean nt(int id) {
        return id < 0;
    }

    public static boolean idx(int id) {
        return id < 0;
    }

    public static boolean nt(String word) {
        return FormatUtils.isNonterminal(word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int size() {
        Integer n = lock;
        synchronized (n) {
            return idToString.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int head() {
        Integer n = lock;
        synchronized (n) {
            return head;
        }
    }

    public static int getTargetNonterminalIndex(int id) {
        return FormatUtils.getNonterminalIndex(Vocabulary.word(id));
    }

    private static void clear() {
        stringToId = new TreeMap();
        idToString = new ArrayList();
        idToString.add(UNKNOWN_ID, UNKNOWN_WORD);
    }

    public static Iterator<String> wordIterator() {
        return idToString.iterator();
    }

    static {
        lock = new Integer(0);
        logger = Logger.getLogger(Vocabulary.class.getName());
        UNKNOWN_ID = 0;
        UNKNOWN_WORD = "<unk>";
        Vocabulary.clear();
    }

    public static class HashCollisionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HashCollisionException(String first, String second) {
            super("MurmurHash for the following symbols collides: '" + first + "', '" + second + "'");
        }
    }

    public static class UnknownSymbolException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnknownSymbolException(int id) {
            super("Identifier " + id + " cannot be found in the symbol table");
        }

        public UnknownSymbolException(String symbol) {
            super("Symbol " + symbol + " cannot be found in the symbol table");
        }
    }
}

