/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.util.io;

import edu.jhu.thrax.datatypes.AlignedSentencePair;
import edu.jhu.thrax.datatypes.ArrayAlignment;
import edu.jhu.thrax.util.FormatUtils;
import edu.jhu.thrax.util.Vocabulary;
import edu.jhu.thrax.util.exceptions.MalformedInputException;
import java.util.ArrayList;

public class InputUtilities {
    public static int[] parseYield(String input) throws MalformedInputException {
        if (input == null || input.isEmpty()) {
            return new int[0];
        }
        if (input.charAt(0) != '(') {
            throw new MalformedInputException("malformed parse");
        }
        ArrayList<Integer> words = new ArrayList<Integer>();
        int from = 0;
        int to = 0;
        boolean seeking = true;
        boolean nonterminal = false;
        while (from < input.length() && to < input.length()) {
            char current;
            if (seeking) {
                current = input.charAt(from);
                if (current == '(' || current == ')' || current == ' ') {
                    ++from;
                    continue;
                }
                to = from + 1;
                seeking = false;
                nonterminal = input.charAt(from - 1) == '(';
                continue;
            }
            current = input.charAt(to);
            if (current == ' ' || current == ')' || current == '(') {
                if (!nonterminal) {
                    words.add(Vocabulary.id(input.substring(from, to)));
                }
                from = to + 1;
                seeking = true;
                continue;
            }
            ++to;
        }
        int[] result = new int[words.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)words.get(i);
        }
        return result;
    }

    public static int[] getWords(String input, boolean parsed) throws MalformedInputException {
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            return new int[0];
        }
        if (parsed) {
            return InputUtilities.parseYield(trimmed);
        }
        return Vocabulary.addAll(trimmed);
    }

    public static AlignedSentencePair alignedSentencePair(String source, boolean source_is_parsed, String target, boolean target_is_parsed, String al, boolean reverse) throws MalformedInputException {
        int[] source_words = InputUtilities.getWords(source, source_is_parsed);
        int[] target_words = InputUtilities.getWords(target, target_is_parsed);
        if (source_words.length == 0 || target_words.length == 0) {
            throw new MalformedInputException("empty sentence");
        }
        ArrayAlignment alignment = ArrayAlignment.fromString(al.trim(), reverse);
        if (reverse) {
            if (!alignment.consistentWith(target_words.length, source_words.length)) {
                throw new MalformedInputException("inconsistent alignment");
            }
            return new AlignedSentencePair(target_words, source_words, alignment);
        }
        if (!alignment.consistentWith(source_words.length, target_words.length)) {
            throw new MalformedInputException("inconsistent alignment");
        }
        return new AlignedSentencePair(source_words, target_words, alignment);
    }

    public static AlignedSentencePair alignedSentencePair(String line, boolean source_is_parsed, boolean target_is_parsed, boolean reverse) throws MalformedInputException {
        String[] parts = FormatUtils.P_DELIM.split(line);
        if (parts.length < 3) {
            throw new MalformedInputException("not enough fields");
        }
        return InputUtilities.alignedSentencePair(parts[0], source_is_parsed, parts[1], target_is_parsed, parts[2], reverse);
    }
}

