/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.thrax.util.io;

import edu.jhu.thrax.util.io.Reader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class LineReader
implements Reader<String> {
    private static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    private BufferedReader reader;
    private String buffer;
    private IOException error;

    public LineReader(String filename) throws IOException {
        this(LineReader.getInputStream(filename));
    }

    public LineReader(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in, FILE_ENCODING));
    }

    public LineReader(BufferedReader reader) {
        this.reader = reader;
    }

    @Deprecated
    public static final InputStream getInputStream(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        return filename.endsWith(".gz") ? new GZIPInputStream(fis) : fis;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        if (null != this.reader) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.error = null;
                throw e;
            }
            finally {
                this.reader = null;
            }
        }
        if (null != this.error) {
            IOException e = this.error;
            this.error = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public String readLine() throws IOException {
        if (this.hasNext()) {
            String line = this.buffer;
            this.buffer = null;
            return line;
        }
        if (null != this.error) {
            IOException e = this.error;
            this.error = null;
            throw e;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (null != this.buffer) {
            return true;
        }
        if (null != this.error) {
            return false;
        }
        try {
            this.buffer = this.reader.readLine();
        }
        catch (IOException e) {
            this.buffer = null;
            this.error = e;
            return false;
        }
        return null != this.buffer;
    }

    @Override
    public String next() throws NoSuchElementException {
        if (this.hasNext()) {
            String line = this.buffer;
            this.buffer = null;
            return line;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int countLines() throws IOException {
        int lines = 0;
        while (this.hasNext()) {
            this.next();
            ++lines;
        }
        this.close();
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (1 != args.length) {
            System.out.println("Usage: java LineReader filename");
            System.exit(1);
        }
        try {
            LineReader in = new LineReader(args[0]);
            try {
                for (String line : in) {
                    System.out.println(line);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

