/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.List;
import org.testng.ISuite;
import org.testng.ITestResult;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BasePanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.ResultsByClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuitePanel
extends BasePanel {
    private static final String PASSED = "passed";
    private static final String SKIPPED = "skipped";
    private static final String FAILED = "failed";

    public SuitePanel(Model model) {
        super(model);
    }

    @Override
    public void generate(XMLStringBuffer xsb) {
        for (ISuite suite : this.getSuites()) {
            this.generateSuitePanel(suite, xsb);
        }
    }

    private void generateSuitePanel(ISuite suite, XMLStringBuffer xsb) {
        String divName = SuitePanel.suiteToTag(suite);
        xsb.push("div", "class", "panel " + divName, "panel-name", "suite-" + divName);
        String[] statuses = new String[]{FAILED, SKIPPED, PASSED};
        ResultsByClass[] results = new ResultsByClass[]{this.getModel().getFailedResultsByClass(suite), this.getModel().getSkippedResultsByClass(suite), this.getModel().getPassedResultsByClass(suite)};
        for (int i = 0; i < results.length; ++i) {
            ResultsByClass byClass = results[i];
            for (Class<?> c : byClass.getClasses()) {
                this.generateClassPanel(c, byClass.getResults(c), xsb, statuses[i], suite);
            }
        }
        xsb.pop("div");
    }

    private void generateClassPanel(Class c, List<ITestResult> results, XMLStringBuffer xsb, String status, ISuite suite) {
        xsb.push("div", "class", "suite-" + SuitePanel.suiteToTag(suite) + "-class-" + status);
        xsb.push("div", "class", "main-panel-header rounded-window-top");
        xsb.addEmptyElement("img", "src", Model.getImage(status));
        xsb.addOptional("span", c.getName(), "class", "class-name");
        xsb.pop("div");
        xsb.push("div", "class", "main-panel-content rounded-window-bottom");
        for (ITestResult tr : results) {
            this.generateMethod(tr, xsb);
        }
        xsb.pop("div");
        xsb.pop("div");
    }

    private void generateMethod(ITestResult tr, XMLStringBuffer xsb) {
        xsb.push("div", "class", "method");
        xsb.push("div", "class", "method-content");
        xsb.push("a", "name", Model.getTestResultName(tr));
        xsb.pop("a");
        xsb.addOptional("span", tr.getMethod().getMethodName(), "class", "method-name");
        if (tr.getParameters().length > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object p : tr.getParameters()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(p != null ? p.toString() : "<NULL>");
            }
            xsb.addOptional("span", "(" + sb.toString() + ")", "class", "parameters");
        }
        if (tr.getStatus() != 1 && tr.getThrowable() != null) {
            StringBuilder stackTrace = new StringBuilder();
            stackTrace.append("<b>\"").append(Utils.join(Utils.stackTrace(tr.getThrowable(), true), "<br/>")).append("\"</b>").append("<br>");
            for (StackTraceElement str : tr.getThrowable().getStackTrace()) {
                stackTrace.append(str.toString()).append("<br>");
            }
            xsb.addOptional("div", stackTrace.toString() + "\n", "class", "stack-trace");
        }
        xsb.pop("div");
        xsb.pop("div");
    }
}

