package joshua.util;

import java.util.HashMap;
import java.util.Map;

public class UnicodeCharacterName {

  private final Map<Character, String> map;

  public UnicodeCharacterName() {

    int expectedSize = 21927;

    map = new HashMap<Character, String>(expectedSize);

    basicLatin(map);
    latin1Supplement(map);
    latinExtendedA(map);
    latinExtendedB(map);
    ipaExtensions(map);
    spacingModifierLetters(map);
    combiningDiacriticMarks(map);
    greekAndCoptic(map);
    cyrillic(map);
    cyrillicSupplement(map);
    armenian(map);
    hebrew(map);
    arabic(map);
    syriac(map);
    arabicSupplement(map);
    thaana(map);
    nko(map);
    samaritan(map);
    devanagari(map);
    bengali(map);
    gurmukhi(map);
    gujarati(map);
    oriya(map);
    tamil(map);
    telugu(map);
    kannada(map);
    malayalam(map);
    sinhala(map);
    thai(map);
    lao(map);
    tibetan(map);
    myanmar(map);
    georgian(map);
    hangulJamo(map);
    ethiopic(map);
    ethiopicSupplement(map);
    cherokee(map);
    canadianAboriginalSyllabics(map);
    ogham(map);
    runic(map);
    tagalog(map);
    hanunoo(map);
    buhid(map);
    tagbanwa(map);
    khmer(map);
    mongolian(map);
    canadianSyllabics(map);
    limbu(map);
    taiLe(map);
    newTaiLue(map);
    khmerSymbols(map);
    buginese(map);
    balinese(map);
    sudanese(map);
    lepcha(map);
    olChiki(map);
    vedic(map);
    phoneticExtensions(map);
    phoneticExtensionsSupplement(map);
    combiningDiacriticalMarksSupplement(map);
    latinExtendedAdditional(map);
    greekExtended(map);
    generalPunctuation(map);
    cjkSymbolsAndPunctuation(map);
    hangulSyllables(map);
  }

  public static final void basicLatin(Map<Character, String> map) {

    // C0 Controls
    map.put('\u0000', "NULL");
    map.put('\u0001', "START OF HEADING");
    map.put('\u0002', "START OF TEXT");
    map.put('\u0003', "END OF TEXT");
    map.put('\u0004', "END OF TRANSMISSION");
    map.put('\u0005', "ENQUIRY");
    map.put('\u0006', "ACKNOWLEDGE");
    map.put('\u0007', "BELL");
    map.put('\u0008', "BACKSPACE");
    map.put('\u0009', "CHARACTER TABULATION");
    map.put('\u000B', "LINE TABULATION");
    map.put('\u000C', "FORM FEED");
    map.put('\u000E', "SHIFT OUT");
    map.put('\u000F', "SHIFT IN");
    map.put('\u0010', "DATA LINK ESCAPE");
    map.put('\u0011', "DEVICE CONTROL ONE");
    map.put('\u0012', "DEVICE CONTROL TWO");
    map.put('\u0013', "DEVICE CONTROL THREE");
    map.put('\u0014', "DEVICE CONTROL FOUR");
    map.put('\u0015', "NEGATIVE ACKNOWLEDGE");
    map.put('\u0016', "SYNCHRONOUS IDLE");
    map.put('\u0017', "END OF TRANSMISSION BLOCK");
    map.put('\u0018', "CANCEL");
    map.put('\u0019', "END OF MEDIUM");
    map.put('\u001A', "SUBSTITUTE");
    map.put('\u001B', "ESCAPE");
    map.put('\u001C', "FILE SEPARATOR");
    map.put('\u001D', "GROUP SEPARATOR");
    map.put('\u001E', "RECORD SEPARATOR");
    map.put('\u001F', "UNIT SEPARATOR");

    // ASCII punctuation and symbols
    map.put('\u0020', "SPACE");
    map.put('\u0021', "EXCLAMATION MARK");
    map.put('\u0022', "QUOTATION MARK");
    map.put('\u0023', "NUMBER SIGN");
    map.put('\u0024', "DOLLAR SIGN");
    map.put('\u0025', "PERCENT SIGN");
    map.put('\u0026', "AMPERSAND");
    map.put('\'', "APOSTROPHE");
    map.put('\u0028', "LEFT PARENTHESIS");
    map.put('\u0029', "RIGHT PARENTHESIS");
    map.put('\u002A', "ASTERISK");
    map.put('\u002B', "PLUS SIGN");
    map.put('\u002C', "COMMA");
    map.put('\u002D', "HYPHEN-MINUS");
    map.put('\u002E', "FULL STOP");
    map.put('\u002F', "SOLIDUS");

    // ASCII digits
    map.put('\u0030', "DIGIT ZERO");
    map.put('\u0031', "DIGIT ONE");
    map.put('\u0032', "DIGIT TWO");
    map.put('\u0033', "DIGIT THREE");
    map.put('\u0034', "DIGIT FOUR");
    map.put('\u0035', "DIGIT FIVE");
    map.put('\u0036', "DIGIT SIX");
    map.put('\u0037', "DIGIT SEVEN");
    map.put('\u0038', "DIGIT EIGHT");
    map.put('\u0039', "DIGIT NINE");

    // ASCII punctuation and symbols
    map.put('\u003A', "COLON");
    map.put('\u003B', "SEMICOLON");
    map.put('\u003C', "LESS-THAN SIGN");
    map.put('\u003D', "EQUALS SIGN");
    map.put('\u003E', "GREATER-THAN SIGN");
    map.put('\u003F', "QUESTION MARK");
    map.put('\u0040', "COMMERCIAL AT");

    // Uppercase Latin alphabet
    map.put('\u0041', "LATIN CAPITAL LETTER A");
    map.put('\u0042', "LATIN CAPITAL LETTER B");
    map.put('\u0043', "LATIN CAPITAL LETTER C");
    map.put('\u0044', "LATIN CAPITAL LETTER D");
    map.put('\u0045', "LATIN CAPITAL LETTER E");
    map.put('\u0046', "LATIN CAPITAL LETTER F");
    map.put('\u0047', "LATIN CAPITAL LETTER G");
    map.put('\u0048', "LATIN CAPITAL LETTER H");
    map.put('\u0049', "LATIN CAPITAL LETTER I");
    map.put('\u004A', "LATIN CAPITAL LETTER J");
    map.put('\u004B', "LATIN CAPITAL LETTER K");
    map.put('\u004C', "LATIN CAPITAL LETTER L");
    map.put('\u004D', "LATIN CAPITAL LETTER M");
    map.put('\u004E', "LATIN CAPITAL LETTER N");
    map.put('\u004F', "LATIN CAPITAL LETTER O");
    map.put('\u0050', "LATIN CAPITAL LETTER P");
    map.put('\u0051', "LATIN CAPITAL LETTER Q");
    map.put('\u0052', "LATIN CAPITAL LETTER R");
    map.put('\u0053', "LATIN CAPITAL LETTER S");
    map.put('\u0054', "LATIN CAPITAL LETTER T");
    map.put('\u0055', "LATIN CAPITAL LETTER U");
    map.put('\u0056', "LATIN CAPITAL LETTER V");
    map.put('\u0057', "LATIN CAPITAL LETTER W");
    map.put('\u0058', "LATIN CAPITAL LETTER X");
    map.put('\u0059', "LATIN CAPITAL LETTER Y");
    map.put('\u005A', "LATIN CAPITAL LETTER Z");

    // ASCII punctuation and symbols
    map.put('\u005B', "LEFT SQUARE BRACKET");
    map.put('\\', "REVERSE SOLIDUS");
    map.put('\u005D', "RIGHT SQUARE BRACKET");
    map.put('\u005E', "CIRCUMFLEX ACCENT");
    map.put('\u005F', "LOW LINE");
    map.put('\u0060', "GRAVE ACCENT");

    // Lowercase Latin alphabet
    map.put('\u0061', "LATIN SMALL LETTER A");
    map.put('\u0062', "LATIN SMALL LETTER B");
    map.put('\u0063', "LATIN SMALL LETTER C");
    map.put('\u0064', "LATIN SMALL LETTER D");
    map.put('\u0065', "LATIN SMALL LETTER E");
    map.put('\u0066', "LATIN SMALL LETTER F");
    map.put('\u0067', "LATIN SMALL LETTER G");
    map.put('\u0068', "LATIN SMALL LETTER H");
    map.put('\u0069', "LATIN SMALL LETTER I");
    map.put('\u006A', "LATIN SMALL LETTER J");
    map.put('\u006B', "LATIN SMALL LETTER K");
    map.put('\u006C', "LATIN SMALL LETTER L");
    map.put('\u006D', "LATIN SMALL LETTER M");
    map.put('\u006E', "LATIN SMALL LETTER N");
    map.put('\u006F', "LATIN SMALL LETTER O");
    map.put('\u0070', "LATIN SMALL LETTER P");
    map.put('\u0071', "LATIN SMALL LETTER Q");
    map.put('\u0072', "LATIN SMALL LETTER R");
    map.put('\u0073', "LATIN SMALL LETTER S");
    map.put('\u0074', "LATIN SMALL LETTER T");
    map.put('\u0075', "LATIN SMALL LETTER U");
    map.put('\u0076', "LATIN SMALL LETTER V");
    map.put('\u0077', "LATIN SMALL LETTER W");
    map.put('\u0078', "LATIN SMALL LETTER X");
    map.put('\u0079', "LATIN SMALL LETTER Y");
    map.put('\u007A', "LATIN SMALL LETTER Z");

    // ASCII punctuation and symbols
    map.put('\u007B', "LEFT CURLY BRACKET");
    map.put('\u007C', "VERTICAL LINE");
    map.put('\u007D', "RIGHT CURLY BRACKET");
    map.put('\u007E', "TILDE");

    // Control character
    map.put('\u007F', "DELETE");

  }

  public static final void latin1Supplement(Map<Character, String> map) {

    // C1 controls
    map.put('\u0080', "<control>");
    map.put('\u0081', "<control>");
    map.put('\u0082', "BREAK PERMITTED HERE");
    map.put('\u0083', "NO BREAK HERE");
    map.put('\u0084', "<control>");
    map.put('\u0085', "NEXT LINE");
    map.put('\u0086', "START OF SELECTED AREA");
    map.put('\u0087', "END OF SELECTED AREA");
    map.put('\u0088', "CHARACTER TABULATION SET");
    map.put('\u0089', "CHARACTER TABULATION WITH JUSTIFICATION");
    map.put('\u008A', "LINE TABULATION SET");
    map.put('\u008B', "PARTIAL LINE FORWARD");
    map.put('\u008C', "PARTIAL LINE BACKWARD");
    map.put('\u008D', "REVERSE LINE FEED");
    map.put('\u008E', "SINGLE SHIFT TWO");
    map.put('\u008F', "SINGLE SHIFT THREE");
    map.put('\u0090', "DEVICE CONTROL STRING");
    map.put('\u0091', "PRIVATE USE ONE");
    map.put('\u0092', "PRIVATE USE TWO");
    map.put('\u0093', "SET TRANSMIT STATE");
    map.put('\u0094', "CANCEL CHARACTER");
    map.put('\u0095', "MESSAGE WAITING");
    map.put('\u0096', "START OF GUARDED AREA");
    map.put('\u0097', "END OF GUARDED AREA");
    map.put('\u0098', "START OF STRING");
    map.put('\u0099', "<control>");
    map.put('\u009A', "SINGLE CHARACTER INTRODUCER");
    map.put('\u009B', "CONTROL SEQUENCE INTRODUCER");
    map.put('\u009C', "STRING TERMINATOR");
    map.put('\u009D', "OPERATING SYSTEM COMMAND");
    map.put('\u009E', "PRIVACY MESSAGE");
    map.put('\u009F', "APPLICATION PROGRAM COMMAND");

    // Latin-1 punctuation and symbols
    map.put('\u00A0', "NO-BREAK SPACE");
    map.put('\u00A1', "INVERTED EXCLAMATION MARK");
    map.put('\u00A2', "CENT SIGN");
    map.put('\u00A3', "POUND SIGN");
    map.put('\u00A4', "CURRENCY SIGN");
    map.put('\u00A5', "YEN SIGN");
    map.put('\u00A6', "BROKEN BAR");
    map.put('\u00A7', "SECTION SIGN");
    map.put('\u00A8', "DIAERESIS");
    map.put('\u00A9', "COPYRIGHT SIGN");
    map.put('\u00AA', "FEMININE ORDINAL INDICATOR");
    map.put('\u00AB', "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK");
    map.put('\u00AC', "NOT SIGN");
    map.put('\u00AD', "SOFT HYPHEN");
    map.put('\u00AE', "REGISTERED SIGN");
    map.put('\u00AF', "MACRON");
    map.put('\u00B0', "DEGREE SIGN");
    map.put('\u00B1', "PLUS-MINUS SIGN");
    map.put('\u00B2', "SUPERSCRIPT TWO");
    map.put('\u00B3', "SUPERSCRIPT THREE");
    map.put('\u00B4', "ACUTE ACCENT");
    map.put('\u00B5', "MICRO SIGN");
    map.put('\u00B6', "PILCROW SIGN");
    map.put('\u00B7', "MIDDLE DOT");
    map.put('\u00B8', "CEDILLA");
    map.put('\u00B9', "SUPERSCRIPT ONE");
    map.put('\u00BA', "MASCULINE ORDINAL INDICATOR");
    map.put('\u00BB', "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK");
    map.put('\u00BC', "VULGAR FRACTION ONE QUARTER");
    map.put('\u00BD', "VULGAR FRACTION ONE HALF");
    map.put('\u00BE', "VULGAR FRACTION THREE QUARTERS");
    map.put('\u00BF', "INVERTED QUESTION MARK");

    // Letters
    map.put('\u00C0', "LATIN CAPITAL LETTER A WITH GRAVE");
    map.put('\u00C1', "LATIN CAPITAL LETTER A WITH ACUTE");
    map.put('\u00C2', "LATIN CAPITAL LETTER A WITH CIRCUMFLEX");
    map.put('\u00C3', "LATIN CAPITAL LETTER A WITH TILDE");
    map.put('\u00C4', "LATIN CAPITAL LETTER A WITH DIAERESIS");
    map.put('\u00C5', "LATIN CAPITAL LETTER A WITH RING ABOVE");
    map.put('\u00C6', "LATIN CAPITAL LETTER AE");
    map.put('\u00C7', "LATIN CAPITAL LETTER C WITH CEDILLA");
    map.put('\u00C8', "LATIN CAPITAL LETTER E WITH GRAVE");
    map.put('\u00C9', "LATIN CAPITAL LETTER E WITH ACUTE");
    map.put('\u00CA', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX");
    map.put('\u00CB', "LATIN CAPITAL LETTER E WITH DIAERESIS");
    map.put('\u00CC', "LATIN CAPITAL LETTER I WITH GRAVE");
    map.put('\u00CD', "LATIN CAPITAL LETTER I WITH ACUTE");
    map.put('\u00CE', "LATIN CAPITAL LETTER I WITH CIRCUMFLEX");
    map.put('\u00CF', "LATIN CAPITAL LETTER I WITH DIAERESIS");
    map.put('\u00D0', "LATIN CAPITAL LETTER ETH");
    map.put('\u00D1', "LATIN CAPITAL LETTER N WITH TILDE");
    map.put('\u00D2', "LATIN CAPITAL LETTER O WITH GRAVE");
    map.put('\u00D3', "LATIN CAPITAL LETTER O WITH ACUTE");
    map.put('\u00D4', "LATIN CAPITAL LETTER O WITH CIRCUMFLEX");
    map.put('\u00D5', "LATIN CAPITAL LETTER O WITH TILDE");
    map.put('\u00D6', "LATIN CAPITAL LETTER O WITH DIAERESIS");

    // Mathematical operator
    map.put('\u00D7', "MULTIPLICATION SIGN");

    // Letters
    map.put('\u00D8', "LATIN CAPITAL LETTER O WITH STROKE");
    map.put('\u00D9', "LATIN CAPITAL LETTER U WITH GRAVE");
    map.put('\u00DA', "LATIN CAPITAL LETTER U WITH ACUTE");
    map.put('\u00DB', "LATIN CAPITAL LETTER U WITH CIRCUMFLEX");
    map.put('\u00DC', "LATIN CAPITAL LETTER U WITH DIAERESIS");
    map.put('\u00DD', "LATIN CAPITAL LETTER Y WITH ACUTE");
    map.put('\u00DE', "LATIN CAPITAL LETTER THORN");
    map.put('\u00DF', "LATIN SMALL LETTER SHARP S");
    map.put('\u00E0', "LATIN SMALL LETTER A WITH GRAVE");
    map.put('\u00E1', "LATIN SMALL LETTER A WITH ACUTE");
    map.put('\u00E2', "LATIN SMALL LETTER A WITH CIRCUMFLEX");
    map.put('\u00E3', "LATIN SMALL LETTER A WITH TILDE");
    map.put('\u00E4', "LATIN SMALL LETTER A WITH DIAERESIS");
    map.put('\u00E5', "LATIN SMALL LETTER A WITH RING ABOVE");
    map.put('\u00E6', "LATIN SMALL LETTER AE");
    map.put('\u00E7', "LATIN SMALL LETTER C WITH CEDILLA");
    map.put('\u00E8', "LATIN SMALL LETTER E WITH GRAVE");
    map.put('\u00E9', "LATIN SMALL LETTER E WITH ACUTE");
    map.put('\u00EA', "LATIN SMALL LETTER E WITH CIRCUMFLEX");
    map.put('\u00EB', "LATIN SMALL LETTER E WITH DIAERESIS");
    map.put('\u00EC', "LATIN SMALL LETTER I WITH GRAVE");
    map.put('\u00ED', "LATIN SMALL LETTER I WITH ACUTE");
    map.put('\u00EE', "LATIN SMALL LETTER I WITH CIRCUMFLEX");
    map.put('\u00EF', "LATIN SMALL LETTER I WITH DIAERESIS");
    map.put('\u00F0', "LATIN SMALL LETTER ETH");
    map.put('\u00F1', "LATIN SMALL LETTER N WITH TILDE");
    map.put('\u00F2', "LATIN SMALL LETTER O WITH GRAVE");
    map.put('\u00F3', "LATIN SMALL LETTER O WITH ACUTE");
    map.put('\u00F4', "LATIN SMALL LETTER O WITH CIRCUMFLEX");
    map.put('\u00F5', "LATIN SMALL LETTER O WITH TILDE");
    map.put('\u00F6', "LATIN SMALL LETTER O WITH DIAERESIS");

    // Mathematical operator
    map.put('\u00F7', "DIVISION SIGN");

    // Letters
    map.put('\u00F8', "LATIN SMALL LETTER O WITH STROKE");
    map.put('\u00F9', "LATIN SMALL LETTER U WITH GRAVE");
    map.put('\u00FA', "LATIN SMALL LETTER U WITH ACUTE");
    map.put('\u00FB', "LATIN SMALL LETTER U WITH CIRCUMFLEX");
    map.put('\u00FC', "LATIN SMALL LETTER U WITH DIAERESIS");
    map.put('\u00FD', "LATIN SMALL LETTER Y WITH ACUTE");
    map.put('\u00FE', "LATIN SMALL LETTER THORN");
    map.put('\u00FF', "LATIN SMALL LETTER Y WITH DIAERESIS");

  }

  public static final void latinExtendedA(Map<Character, String> map) {

    // European Latin
    map.put('\u0100', "LATIN CAPITAL LETTER A WITH MACRON");
    map.put('\u0101', "LATIN SMALL LETTER A WITH MACRON");
    map.put('\u0102', "LATIN CAPITAL LETTER A WITH BREVE");
    map.put('\u0103', "LATIN SMALL LETTER A WITH BREVE");
    map.put('\u0104', "LATIN CAPITAL LETTER A WITH OGONEK");
    map.put('\u0105', "LATIN SMALL LETTER A WITH OGONEK");
    map.put('\u0106', "LATIN CAPITAL LETTER C WITH ACUTE");
    map.put('\u0107', "LATIN SMALL LETTER C WITH ACUTE");
    map.put('\u0108', "LATIN CAPITAL LETTER C WITH CIRCUMFLEX");
    map.put('\u0109', "LATIN SMALL LETTER C WITH CIRCUMFLEX");
    map.put('\u010A', "LATIN CAPITAL LETTER C WITH DOT ABOVE");
    map.put('\u010B', "LATIN SMALL LETTER C WITH DOT ABOVE");
    map.put('\u010C', "LATIN CAPITAL LETTER C WITH CARON");
    map.put('\u010D', "LATIN SMALL LETTER C WITH CARON");
    map.put('\u010E', "LATIN CAPITAL LETTER D WITH CARON");
    map.put('\u010F', "LATIN SMALL LETTER D WITH CARON");
    map.put('\u0110', "LATIN CAPITAL LETTER D WITH STROKE");
    map.put('\u0111', "LATIN SMALL LETTER D WITH STROKE");
    map.put('\u0112', "LATIN CAPITAL LETTER E WITH MACRON");
    map.put('\u0113', "LATIN SMALL LETTER E WITH MACRON");
    map.put('\u0114', "LATIN CAPITAL LETTER E WITH BREVE");
    map.put('\u0115', "LATIN SMALL LETTER E WITH BREVE");
    map.put('\u0116', "LATIN CAPITAL LETTER E WITH DOT ABOVE");
    map.put('\u0117', "LATIN SMALL LETTER E WITH DOT ABOVE");
    map.put('\u0118', "LATIN CAPITAL LETTER E WITH OGONEK");
    map.put('\u0119', "LATIN SMALL LETTER E WITH OGONEK");
    map.put('\u011A', "LATIN CAPITAL LETTER E WITH CARON");
    map.put('\u011B', "LATIN SMALL LETTER E WITH CARON");
    map.put('\u011C', "LATIN CAPITAL LETTER G WITH CIRCUMFLEX");
    map.put('\u011D', "LATIN SMALL LETTER G WITH CIRCUMFLEX");
    map.put('\u011E', "LATIN CAPITAL LETTER G WITH BREVE");
    map.put('\u011F', "LATIN SMALL LETTER G WITH BREVE");
    map.put('\u0120', "LATIN CAPITAL LETTER G WITH DOT ABOVE");
    map.put('\u0121', "LATIN SMALL LETTER G WITH DOT ABOVE");
    map.put('\u0122', "LATIN CAPITAL LETTER G WITH CEDILLA");
    map.put('\u0123', "LATIN SMALL LETTER G WITH CEDILLA");
    map.put('\u0124', "LATIN CAPITAL LETTER H WITH CIRCUMFLEX");
    map.put('\u0125', "LATIN SMALL LETTER H WITH CIRCUMFLEX");
    map.put('\u0126', "LATIN CAPITAL LETTER H WITH STROKE");
    map.put('\u0127', "LATIN SMALL LETTER H WITH STROKE");
    map.put('\u0128', "LATIN CAPITAL LETTER I WITH TILDE");
    map.put('\u0129', "LATIN SMALL LETTER I WITH TILDE");
    map.put('\u012A', "LATIN CAPITAL LETTER I WITH MACRON");
    map.put('\u012B', "LATIN SMALL LETTER I WITH MACRON");
    map.put('\u012C', "LATIN CAPITAL LETTER I WITH BREVE");
    map.put('\u012D', "LATIN SMALL LETTER I WITH BREVE");
    map.put('\u012E', "LATIN CAPITAL LETTER I WITH OGONEK");
    map.put('\u012F', "LATIN SMALL LETTER I WITH OGONEK");
    map.put('\u0130', "LATIN CAPITAL LETTER I WITH DOT ABOVE");
    map.put('\u0131', "LATIN SMALL LETTER DOTLESS I");
    map.put('\u0132', "LATIN CAPITAL LIGATURE IJ");
    map.put('\u0133', "LATIN SMALL LIGATURE IJ");
    map.put('\u0134', "LATIN CAPITAL LETTER J WITH CIRCUMFLEX");
    map.put('\u0135', "LATIN SMALL LETTER J WITH CIRCUMFLEX");
    map.put('\u0136', "LATIN CAPITAL LETTER K WITH CEDILLA");
    map.put('\u0137', "LATIN SMALL LETTER K WITH CEDILLA");
    map.put('\u0138', "LATIN SMALL LETTER KRA");
    map.put('\u0139', "LATIN CAPITAL LETTER L WITH ACUTE");
    map.put('\u013A', "LATIN SMALL LETTER L WITH ACUTE");
    map.put('\u013B', "LATIN CAPITAL LETTER L WITH CEDILLA");
    map.put('\u013C', "LATIN SMALL LETTER L WITH CEDILLA");
    map.put('\u013D', "LATIN CAPITAL LETTER L WITH CARON");
    map.put('\u013E', "LATIN SMALL LETTER L WITH CARON");
    map.put('\u013F', "LATIN CAPITAL LETTER L WITH MIDDLE DOT");
    map.put('\u0140', "LATIN SMALL LETTER L WITH MIDDLE DOT");
    map.put('\u0141', "LATIN CAPITAL LETTER L WITH STROKE");
    map.put('\u0142', "LATIN SMALL LETTER L WITH STROKE");
    map.put('\u0143', "LATIN CAPITAL LETTER N WITH ACUTE");
    map.put('\u0144', "LATIN SMALL LETTER N WITH ACUTE");
    map.put('\u0145', "LATIN CAPITAL LETTER N WITH CEDILLA");
    map.put('\u0146', "LATIN SMALL LETTER N WITH CEDILLA");
    map.put('\u0147', "LATIN CAPITAL LETTER N WITH CARON");
    map.put('\u0148', "LATIN SMALL LETTER N WITH CARON");

    // Deprecated letter
    map.put('\u0149', "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE");

    // European Latin
    map.put('\u014A', "LATIN CAPITAL LETTER ENG");
    map.put('\u014B', "LATIN SMALL LETTER ENG");
    map.put('\u014C', "LATIN CAPITAL LETTER O WITH MACRON");
    map.put('\u014D', "LATIN SMALL LETTER O WITH MACRON");
    map.put('\u014E', "LATIN CAPITAL LETTER O WITH BREVE");
    map.put('\u014F', "LATIN SMALL LETTER O WITH BREVE");
    map.put('\u0150', "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE");
    map.put('\u0151', "LATIN SMALL LETTER O WITH DOUBLE ACUTE");
    map.put('\u0152', "LATIN CAPITAL LIGATURE OE");
    map.put('\u0153', "LATIN SMALL LIGATURE OE");
    map.put('\u0154', "LATIN CAPITAL LETTER R WITH ACUTE");
    map.put('\u0155', "LATIN SMALL LETTER R WITH ACUTE");
    map.put('\u0156', "LATIN CAPITAL LETTER R WITH CEDILLA");
    map.put('\u0157', "LATIN SMALL LETTER R WITH CEDILLA");
    map.put('\u0158', "LATIN CAPITAL LETTER R WITH CARON");
    map.put('\u0159', "LATIN SMALL LETTER R WITH CARON");
    map.put('\u015A', "LATIN CAPITAL LETTER S WITH ACUTE");
    map.put('\u015B', "LATIN SMALL LETTER S WITH ACUTE");
    map.put('\u015C', "LATIN CAPITAL LETTER S WITH CIRCUMFLEX");
    map.put('\u015D', "LATIN SMALL LETTER S WITH CIRCUMFLEX");
    map.put('\u015E', "LATIN CAPITAL LETTER S WITH CEDILLA");
    map.put('\u015F', "LATIN SMALL LETTER S WITH CEDILLA");
    map.put('\u0160', "LATIN CAPITAL LETTER S WITH CARON");
    map.put('\u0161', "LATIN SMALL LETTER S WITH CARON");
    map.put('\u0162', "LATIN CAPITAL LETTER T WITH CEDILLA");
    map.put('\u0163', "LATIN SMALL LETTER T WITH CEDILLA");
    map.put('\u0164', "LATIN CAPITAL LETTER T WITH CARON");
    map.put('\u0165', "LATIN SMALL LETTER T WITH CARON");
    map.put('\u0166', "LATIN CAPITAL LETTER T WITH STROKE");
    map.put('\u0167', "LATIN SMALL LETTER T WITH STROKE");
    map.put('\u0168', "LATIN CAPITAL LETTER U WITH TILDE");
    map.put('\u0169', "LATIN SMALL LETTER U WITH TILDE");
    map.put('\u016A', "LATIN CAPITAL LETTER U WITH MACRON");
    map.put('\u016B', "LATIN SMALL LETTER U WITH MACRON");
    map.put('\u016C', "LATIN CAPITAL LETTER U WITH BREVE");
    map.put('\u016D', "LATIN SMALL LETTER U WITH BREVE");
    map.put('\u016E', "LATIN CAPITAL LETTER U WITH RING ABOVE");
    map.put('\u016F', "LATIN SMALL LETTER U WITH RING ABOVE");
    map.put('\u0170', "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE");
    map.put('\u0171', "LATIN SMALL LETTER U WITH DOUBLE ACUTE");
    map.put('\u0172', "LATIN CAPITAL LETTER U WITH OGONEK");
    map.put('\u0173', "LATIN SMALL LETTER U WITH OGONEK");
    map.put('\u0174', "LATIN CAPITAL LETTER W WITH CIRCUMFLEX");
    map.put('\u0175', "LATIN SMALL LETTER W WITH CIRCUMFLEX");
    map.put('\u0176', "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX");
    map.put('\u0177', "LATIN SMALL LETTER Y WITH CIRCUMFLEX");
    map.put('\u0178', "LATIN CAPITAL LETTER Y WITH DIAERESIS");
    map.put('\u0179', "LATIN CAPITAL LETTER Z WITH ACUTE");
    map.put('\u017A', "LATIN SMALL LETTER Z WITH ACUTE");
    map.put('\u017B', "LATIN CAPITAL LETTER Z WITH DOT ABOVE");
    map.put('\u017C', "LATIN SMALL LETTER Z WITH DOT ABOVE");
    map.put('\u017D', "LATIN CAPITAL LETTER Z WITH CARON");
    map.put('\u017E', "LATIN SMALL LETTER Z WITH CARON");
    map.put('\u017F', "LATIN SMALL LETTER LONG S");

  }

  public static final void latinExtendedB(Map<Character, String> map) {

    // Non-European and historic Latin
    map.put('\u0180', "LATIN SMALL LETTER B WITH STROKE");
    map.put('\u0181', "LATIN CAPITAL LETTER B WITH HOOK");
    map.put('\u0182', "LATIN CAPITAL LETTER B WITH TOPBAR");
    map.put('\u0183', "LATIN SMALL LETTER B WITH TOPBAR");
    map.put('\u0184', "LATIN CAPITAL LETTER TONE SIX");
    map.put('\u0185', "LATIN SMALL LETTER TONE SIX");
    map.put('\u0186', "LATIN CAPITAL LETTER OPEN O");
    map.put('\u0187', "LATIN CAPITAL LETTER C WITH HOOK");
    map.put('\u0188', "LATIN SMALL LETTER C WITH HOOK");
    map.put('\u0189', "LATIN CAPITAL LETTER AFRICAN D");
    map.put('\u018A', "LATIN CAPITAL LETTER D WITH HOOK");
    map.put('\u018B', "LATIN CAPITAL LETTER D WITH TOPBAR");
    map.put('\u018C', "LATIN SMALL LETTER D WITH TOPBAR");
    map.put('\u018D', "LATIN SMALL LETTER TURNED DELTA");
    map.put('\u018E', "LATIN CAPITAL LETTER REVERSED E");
    map.put('\u018F', "LATIN CAPITAL LETTER SCHWA");
    map.put('\u0190', "LATIN CAPITAL LETTER OPEN E");
    map.put('\u0191', "LATIN CAPITAL LETTER F WITH HOOK");
    map.put('\u0192', "LATIN SMALL LETTER F WITH HOOK");
    map.put('\u0193', "LATIN CAPITAL LETTER G WITH HOOK");
    map.put('\u0194', "LATIN CAPITAL LETTER GAMMA");
    map.put('\u0195', "LATIN SMALL LETTER HV");
    map.put('\u0196', "LATIN CAPITAL LETTER IOTA");
    map.put('\u0197', "LATIN CAPITAL LETTER I WITH STROKE");
    map.put('\u0198', "LATIN CAPITAL LETTER K WITH HOOK");
    map.put('\u0199', "LATIN SMALL LETTER K WITH HOOK");
    map.put('\u019A', "LATIN SMALL LETTER L WITH BAR");
    map.put('\u019B', "LATIN SMALL LETTER LAMBDA WITH STROKE");
    map.put('\u019C', "LATIN CAPITAL LETTER TURNED M");
    map.put('\u019D', "LATIN CAPITAL LETTER N WITH LEFT HOOK");
    map.put('\u019E', "LATIN SMALL LETTER N WITH LONG RIGHT LEG");
    map.put('\u019F', "LATIN CAPITAL LETTER O WITH MIDDLE TILDE");
    map.put('\u01A0', "LATIN CAPITAL LETTER O WITH HORN");
    map.put('\u01A1', "LATIN SMALL LETTER O WITH HORN");
    map.put('\u01A2', "LATIN CAPITAL LETTER OI");
    map.put('\u01A3', "LATIN SMALL LETTER OI");
    map.put('\u01A4', "LATIN CAPITAL LETTER P WITH HOOK");
    map.put('\u01A5', "LATIN SMALL LETTER P WITH HOOK");
    map.put('\u01A6', "LATIN LETTER YR");
    map.put('\u01A7', "LATIN CAPITAL LETTER TONE TWO");
    map.put('\u01A8', "LATIN SMALL LETTER TONE TWO");
    map.put('\u01A9', "LATIN CAPITAL LETTER ESH");
    map.put('\u01AA', "LATIN LETTER REVERSED ESH LOOP");
    map.put('\u01AB', "LATIN SMALL LETTER T WITH PALATAL HOOK");
    map.put('\u01AC', "LATIN CAPITAL LETTER T WITH HOOK");
    map.put('\u01AD', "LATIN SMALL LETTER T WITH HOOK");
    map.put('\u01AE', "LATIN CAPITAL LETTER T WITH RETROFLEX HOOK");
    map.put('\u01AF', "LATIN CAPITAL LETTER U WITH HORN");
    map.put('\u01B0', "LATIN SMALL LETTER U WITH HORN");
    map.put('\u01B1', "LATIN CAPITAL LETTER UPSILON");
    map.put('\u01B2', "LATIN CAPITAL LETTER V WITH HOOK");
    map.put('\u01B3', "LATIN CAPITAL LETTER Y WITH HOOK");
    map.put('\u01B4', "LATIN SMALL LETTER Y WITH HOOK");
    map.put('\u01B5', "LATIN CAPITAL LETTER Z WITH STROKE");
    map.put('\u01B6', "LATIN SMALL LETTER Z WITH STROKE");
    map.put('\u01B7', "LATIN CAPITAL LETTER EZH");
    map.put('\u01B8', "LATIN CAPITAL LETTER EZH REVERSED");
    map.put('\u01B9', "LATIN SMALL LETTER EZH REVERSED");
    map.put('\u01BA', "LATIN SMALL LETTER EZH WITH TAIL");
    map.put('\u01BB', "LATIN LETTER TWO WITH STROKE");
    map.put('\u01BC', "LATIN CAPITAL LETTER TONE FIVE");
    map.put('\u01BD', "LATIN SMALL LETTER TONE FIVE");
    map.put('\u01BE', "LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE");
    map.put('\u01BF', "LATIN LETTER WYNN");

    // African letters for clicks
    map.put('\u01C0', "LATIN LETTER DENTAL CLICK");
    map.put('\u01C1', "LATIN LETTER LATERAL CLICK");
    map.put('\u01C2', "LATIN LETTER ALVEOLAR CLICK");
    map.put('\u01C3', "LATIN LETTER RETROFLEX CLICK");

    // Croatian digraphs matching Serbian Cyrillic letters
    map.put('\u01C4', "LATIN CAPITAL LETTER DZ WITH CARON");
    map.put('\u01C5', "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON");
    map.put('\u01C6', "LATIN SMALL LETTER DZ WITH CARON");
    map.put('\u01C7', "LATIN CAPITAL LETTER LJ");
    map.put('\u01C8', "LATIN CAPITAL LETTER L WITH SMALL LETTER J");
    map.put('\u01C9', "LATIN SMALL LETTER LJ");
    map.put('\u01CA', "LATIN CAPITAL LETTER NJ");
    map.put('\u01CB', "LATIN CAPITAL LETTER N WITH SMALL LETTER J");
    map.put('\u01CC', "LATIN SMALL LETTER NJ");

    // Pinyin diacritic-vowel combinations
    map.put('\u01CD', "LATIN CAPITAL LETTER A WITH CARON");
    map.put('\u01CE', "LATIN SMALL LETTER A WITH CARON");
    map.put('\u01CF', "LATIN CAPITAL LETTER I WITH CARON");
    map.put('\u01D0', "LATIN SMALL LETTER I WITH CARON");
    map.put('\u01D1', "LATIN CAPITAL LETTER O WITH CARON");
    map.put('\u01D2', "LATIN SMALL LETTER O WITH CARON");
    map.put('\u01D3', "LATIN CAPITAL LETTER U WITH CARON");
    map.put('\u01D4', "LATIN SMALL LETTER U WITH CARON");
    map.put('\u01D5', "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON");
    map.put('\u01D6', "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON");
    map.put('\u01D7', "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE");
    map.put('\u01D8', "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE");
    map.put('\u01D9', "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON");
    map.put('\u01DA', "LATIN SMALL LETTER U WITH DIAERESIS AND CARON");
    map.put('\u01DB', "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE");
    map.put('\u01DC', "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE");

    // Phonetic and historic letters
    map.put('\u01DD', "LATIN SMALL LETTER TURNED E");
    map.put('\u01DE', "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON");
    map.put('\u01DF', "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON");
    map.put('\u01E0', "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON");
    map.put('\u01E1', "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON");
    map.put('\u01E2', "LATIN CAPITAL LETTER AE WITH MACRON");
    map.put('\u01E3', "LATIN SMALL LETTER AE WITH MACRON");
    map.put('\u01E4', "LATIN CAPITAL LETTER G WITH STROKE");
    map.put('\u01E5', "LATIN SMALL LETTER G WITH STROKE");
    map.put('\u01E6', "LATIN CAPITAL LETTER G WITH CARON");
    map.put('\u01E7', "LATIN SMALL LETTER G WITH CARON");
    map.put('\u01E8', "LATIN CAPITAL LETTER K WITH CARON");
    map.put('\u01E9', "LATIN SMALL LETTER K WITH CARON");
    map.put('\u01EA', "LATIN CAPITAL LETTER O WITH OGONEK");
    map.put('\u01EB', "LATIN SMALL LETTER O WITH OGONEK");
    map.put('\u01EC', "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON");
    map.put('\u01ED', "LATIN SMALL LETTER O WITH OGONEK AND MACRON");
    map.put('\u01EE', "LATIN CAPITAL LETTER EZH WITH CARON");
    map.put('\u01EF', "LATIN SMALL LETTER EZH WITH CARON");
    map.put('\u01F0', "LATIN SMALL LETTER J WITH CARON");
    map.put('\u01F1', "LATIN CAPITAL LETTER DZ");
    map.put('\u01F2', "LATIN CAPITAL LETTER D WITH SMALL LETTER Z");
    map.put('\u01F3', "LATIN SMALL LETTER DZ");
    map.put('\u01F4', "LATIN CAPITAL LETTER G WITH ACUTE");
    map.put('\u01F5', "LATIN SMALL LETTER G WITH ACUTE");
    map.put('\u01F6', "LATIN CAPITAL LETTER HWAIR");
    map.put('\u01F7', "LATIN CAPITAL LETTER WYNN");
    map.put('\u01F8', "LATIN CAPITAL LETTER N WITH GRAVE");
    map.put('\u01F9', "LATIN SMALL LETTER N WITH GRAVE");
    map.put('\u01FA', "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE");
    map.put('\u01FB', "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE");
    map.put('\u01FC', "LATIN CAPITAL LETTER AE WITH ACUTE");
    map.put('\u01FD', "LATIN SMALL LETTER AE WITH ACUTE");
    map.put('\u01FE', "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE");
    map.put('\u01FF', "LATIN SMALL LETTER O WITH STROKE AND ACUTE");

    // Additions for Slovenian and Croatian
    map.put('\u0200', "LATIN CAPITAL LETTER A WITH DOUBLE GRAVE");
    map.put('\u0201', "LATIN SMALL LETTER A WITH DOUBLE GRAVE");
    map.put('\u0202', "LATIN CAPITAL LETTER A WITH INVERTED BREVE");
    map.put('\u0203', "LATIN SMALL LETTER A WITH INVERTED BREVE");
    map.put('\u0204', "LATIN CAPITAL LETTER E WITH DOUBLE GRAVE");
    map.put('\u0205', "LATIN SMALL LETTER E WITH DOUBLE GRAVE");
    map.put('\u0206', "LATIN CAPITAL LETTER E WITH INVERTED BREVE");
    map.put('\u0207', "LATIN SMALL LETTER E WITH INVERTED BREVE");
    map.put('\u0208', "LATIN CAPITAL LETTER I WITH DOUBLE GRAVE");
    map.put('\u0209', "LATIN SMALL LETTER I WITH DOUBLE GRAVE");
    map.put('\u020A', "LATIN CAPITAL LETTER I WITH INVERTED BREVE");
    map.put('\u020B', "LATIN SMALL LETTER I WITH INVERTED BREVE");
    map.put('\u020C', "LATIN CAPITAL LETTER O WITH DOUBLE GRAVE");
    map.put('\u020D', "LATIN SMALL LETTER O WITH DOUBLE GRAVE");
    map.put('\u020E', "LATIN CAPITAL LETTER O WITH INVERTED BREVE");
    map.put('\u020F', "LATIN SMALL LETTER O WITH INVERTED BREVE");
    map.put('\u0210', "LATIN CAPITAL LETTER R WITH DOUBLE GRAVE");
    map.put('\u0211', "LATIN SMALL LETTER R WITH DOUBLE GRAVE");
    map.put('\u0212', "LATIN CAPITAL LETTER R WITH INVERTED BREVE");
    map.put('\u0213', "LATIN SMALL LETTER R WITH INVERTED BREVE");
    map.put('\u0214', "LATIN CAPITAL LETTER U WITH DOUBLE GRAVE");
    map.put('\u0215', "LATIN SMALL LETTER U WITH DOUBLE GRAVE");
    map.put('\u0216', "LATIN CAPITAL LETTER U WITH INVERTED BREVE");
    map.put('\u0217', "LATIN SMALL LETTER U WITH INVERTED BREVE");

    // Additions for Romanian
    map.put('\u0218', "LATIN CAPITAL LETTER S WITH COMMA BELOW");
    map.put('\u0219', "LATIN SMALL LETTER S WITH COMMA BELOW");
    map.put('\u021A', "LATIN CAPITAL LETTER T WITH COMMA BELOW");
    map.put('\u021B', "LATIN SMALL LETTER T WITH COMMA BELOW");

    // Miscellaneous additions
    map.put('\u021C', "LATIN CAPITAL LETTER YOGH");
    map.put('\u021D', "LATIN SMALL LETTER YOGH");
    map.put('\u021E', "LATIN CAPITAL LETTER H WITH CARON");
    map.put('\u021F', "LATIN SMALL LETTER H WITH CARON");
    map.put('\u0220', "LATIN CAPITAL LETTER N WITH LONG RIGHT LEG");
    map.put('\u0221', "LATIN SMALL LETTER D WITH CURL");
    map.put('\u0222', "LATIN CAPITAL LETTER OU");
    map.put('\u0223', "LATIN SMALL LETTER OU");
    map.put('\u0224', "LATIN CAPITAL LETTER Z WITH HOOK");
    map.put('\u0225', "LATIN SMALL LETTER Z WITH HOOK");
    map.put('\u0226', "LATIN CAPITAL LETTER A WITH DOT ABOVE");
    map.put('\u0227', "LATIN SMALL LETTER A WITH DOT ABOVE");
    map.put('\u0228', "LATIN CAPITAL LETTER E WITH CEDILLA");
    map.put('\u0229', "LATIN SMALL LETTER E WITH CEDILLA");

    // Additions for Livonian
    map.put('\u022A', "LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON");
    map.put('\u022B', "LATIN SMALL LETTER O WITH DIAERESIS AND MACRON");
    map.put('\u022C', "LATIN CAPITAL LETTER O WITH TILDE AND MACRON");
    map.put('\u022D', "LATIN SMALL LETTER O WITH TILDE AND MACRON");
    map.put('\u022E', "LATIN CAPITAL LETTER O WITH DOT ABOVE");
    map.put('\u022F', "LATIN SMALL LETTER O WITH DOT ABOVE");
    map.put('\u0230', "LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON");
    map.put('\u0231', "LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON");
    map.put('\u0232', "LATIN CAPITAL LETTER Y WITH MACRON");
    map.put('\u0233', "LATIN SMALL LETTER Y WITH MACRON");

    // Additions for Sinology
    map.put('\u0234', "LATIN SMALL LETTER L WITH CURL");
    map.put('\u0235', "LATIN SMALL LETTER N WITH CURL");
    map.put('\u0236', "LATIN SMALL LETTER T WITH CURL");

    // Miscellaneous additions
    map.put('\u0237', "LATIN SMALL LETTER DOTLESS J");
    map.put('\u0238', "LATIN SMALL LETTER DB DIGRAPH");
    map.put('\u0239', "LATIN SMALL LETTER QP DIGRAPH");
    map.put('\u023A', "LATIN CAPITAL LETTER A WITH STROKE");
    map.put('\u023B', "LATIN CAPITAL LETTER C WITH STROKE");
    map.put('\u023C', "LATIN SMALL LETTER C WITH STROKE");
    map.put('\u023D', "LATIN CAPITAL LETTER L WITH BAR");
    map.put('\u023E', "LATIN CAPITAL LETTER T WITH DIAGONAL STROKE");
    map.put('\u023F', "LATIN SMALL LETTER S WITH SWASH TAIL");
    map.put('\u0240', "LATIN SMALL LETTER Z WITH SWASH TAIL");
    map.put('\u0241', "LATIN CAPITAL LETTER GLOTTAL STOP");
    map.put('\u0242', "LATIN SMALL LETTER GLOTTAL STOP");
    map.put('\u0243', "LATIN CAPITAL LETTER B WITH STROKE");
    map.put('\u0244', "LATIN CAPITAL LETTER U BAR");
    map.put('\u0245', "LATIN CAPITAL LETTER TURNED V");
    map.put('\u0246', "LATIN CAPITAL LETTER E WITH STROKE");
    map.put('\u0247', "LATIN SMALL LETTER E WITH STROKE");
    map.put('\u0248', "LATIN CAPITAL LETTER J WITH STROKE");
    map.put('\u0249', "LATIN SMALL LETTER J WITH STROKE");
    map.put('\u024A', "LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL");
    map.put('\u024B', "LATIN SMALL LETTER Q WITH HOOK TAIL");
    map.put('\u024C', "LATIN CAPITAL LETTER R WITH STROKE");
    map.put('\u024D', "LATIN SMALL LETTER R WITH STROKE");
    map.put('\u024E', "LATIN CAPITAL LETTER Y WITH STROKE");
    map.put('\u024F', "LATIN SMALL LETTER Y WITH STROKE");

  }

  public static final void ipaExtensions(Map<Character, String> map) {

    // IPA extensions
    map.put('\u0250', "LATIN SMALL LETTER TURNED A");
    map.put('\u0251', "LATIN SMALL LETTER ALPHA");
    map.put('\u0252', "LATIN SMALL LETTER TURNED ALPHA");
    map.put('\u0253', "LATIN SMALL LETTER B WITH HOOK");
    map.put('\u0254', "LATIN SMALL LETTER OPEN O");
    map.put('\u0255', "LATIN SMALL LETTER C WITH CURL");
    map.put('\u0256', "LATIN SMALL LETTER D WITH TAIL");
    map.put('\u0257', "LATIN SMALL LETTER D WITH HOOK");
    map.put('\u0258', "LATIN SMALL LETTER REVERSED E");
    map.put('\u0259', "LATIN SMALL LETTER SCHWA");
    map.put('\u025A', "LATIN SMALL LETTER SCHWA WITH HOOK");
    map.put('\u025B', "LATIN SMALL LETTER OPEN E");
    map.put('\u025C', "LATIN SMALL LETTER REVERSED OPEN E");
    map.put('\u025D', "LATIN SMALL LETTER REVERSED OPEN E WITH HOOK");
    map.put('\u025E', "LATIN SMALL LETTER CLOSED REVERSED OPEN E");
    map.put('\u025F', "LATIN SMALL LETTER DOTLESS J WITH STROKE");
    map.put('\u0260', "LATIN SMALL LETTER G WITH HOOK");
    map.put('\u0261', "LATIN SMALL LETTER SCRIPT G");
    map.put('\u0262', "LATIN LETTER SMALL CAPITAL G");
    map.put('\u0263', "LATIN SMALL LETTER GAMMA");
    map.put('\u0264', "LATIN SMALL LETTER RAMS HORN");
    map.put('\u0265', "LATIN SMALL LETTER TURNED H");
    map.put('\u0266', "LATIN SMALL LETTER H WITH HOOK");
    map.put('\u0267', "LATIN SMALL LETTER HENG WITH HOOK");
    map.put('\u0268', "LATIN SMALL LETTER I WITH STROKE");
    map.put('\u0269', "LATIN SMALL LETTER IOTA");
    map.put('\u026A', "LATIN LETTER SMALL CAPITAL I");
    map.put('\u026B', "LATIN SMALL LETTER L WITH MIDDLE TILDE");
    map.put('\u026C', "LATIN SMALL LETTER L WITH BELT");
    map.put('\u026D', "LATIN SMALL LETTER L WITH RETROFLEX HOOK");
    map.put('\u026E', "LATIN SMALL LETTER LEZH");
    map.put('\u026F', "LATIN SMALL LETTER TURNED M");
    map.put('\u0270', "LATIN SMALL LETTER TURNED M WITH LONG LEG");
    map.put('\u0271', "LATIN SMALL LETTER M WITH HOOK");
    map.put('\u0272', "LATIN SMALL LETTER N WITH LEFT HOOK");
    map.put('\u0273', "LATIN SMALL LETTER N WITH RETROFLEX HOOK");
    map.put('\u0274', "LATIN LETTER SMALL CAPITAL N");
    map.put('\u0275', "LATIN SMALL LETTER BARRED O");
    map.put('\u0276', "LATIN LETTER SMALL CAPITAL OE");
    map.put('\u0277', "LATIN SMALL LETTER CLOSED OMEGA");
    map.put('\u0278', "LATIN SMALL LETTER PHI");
    map.put('\u0279', "LATIN SMALL LETTER TURNED R");
    map.put('\u027A', "LATIN SMALL LETTER TURNED R WITH LONG LEG");
    map.put('\u027B', "LATIN SMALL LETTER TURNED R WITH HOOK");
    map.put('\u027C', "LATIN SMALL LETTER R WITH LONG LEG");
    map.put('\u027D', "LATIN SMALL LETTER R WITH TAIL");
    map.put('\u027E', "LATIN SMALL LETTER R WITH FISHHOOK");
    map.put('\u027F', "LATIN SMALL LETTER REVERSED R WITH FISHHOOK");
    map.put('\u0280', "LATIN LETTER SMALL CAPITAL R");
    map.put('\u0281', "LATIN LETTER SMALL CAPITAL INVERTED R");
    map.put('\u0282', "LATIN SMALL LETTER S WITH HOOK");
    map.put('\u0283', "LATIN SMALL LETTER ESH");
    map.put('\u0284', "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK");
    map.put('\u0285', "LATIN SMALL LETTER SQUAT REVERSED ESH");
    map.put('\u0286', "LATIN SMALL LETTER ESH WITH CURL");
    map.put('\u0287', "LATIN SMALL LETTER TURNED T");
    map.put('\u0288', "LATIN SMALL LETTER T WITH RETROFLEX HOOK");
    map.put('\u0289', "LATIN SMALL LETTER U BAR");
    map.put('\u028A', "LATIN SMALL LETTER UPSILON");
    map.put('\u028B', "LATIN SMALL LETTER V WITH HOOK");
    map.put('\u028C', "LATIN SMALL LETTER TURNED V");
    map.put('\u028D', "LATIN SMALL LETTER TURNED W");
    map.put('\u028E', "LATIN SMALL LETTER TURNED Y");
    map.put('\u028F', "LATIN LETTER SMALL CAPITAL Y");
    map.put('\u0290', "LATIN SMALL LETTER Z WITH RETROFLEX HOOK");
    map.put('\u0291', "LATIN SMALL LETTER Z WITH CURL");
    map.put('\u0292', "LATIN SMALL LETTER EZH");
    map.put('\u0293', "LATIN SMALL LETTER EZH WITH CURL");
    map.put('\u0294', "LATIN LETTER GLOTTAL STOP");
    map.put('\u0295', "LATIN LETTER PHARYNGEAL VOICED FRICATIVE");
    map.put('\u0296', "LATIN LETTER INVERTED GLOTTAL STOP");
    map.put('\u0297', "LATIN LETTER STRETCHED C");
    map.put('\u0298', "LATIN LETTER BILABIAL CLICK");
    map.put('\u0299', "LATIN LETTER SMALL CAPITAL B");
    map.put('\u029A', "LATIN SMALL LETTER CLOSED OPEN E");
    map.put('\u029B', "LATIN LETTER SMALL CAPITAL G WITH HOOK");
    map.put('\u029C', "LATIN LETTER SMALL CAPITAL H");
    map.put('\u029D', "LATIN SMALL LETTER J WITH CROSSED-TAIL");
    map.put('\u029E', "LATIN SMALL LETTER TURNED K");
    map.put('\u029F', "LATIN LETTER SMALL CAPITAL L");
    map.put('\u02A0', "LATIN SMALL LETTER Q WITH HOOK");
    map.put('\u02A1', "LATIN LETTER GLOTTAL STOP WITH STROKE");
    map.put('\u02A2', "LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE");
    map.put('\u02A3', "LATIN SMALL LETTER DZ DIGRAPH");
    map.put('\u02A4', "LATIN SMALL LETTER DEZH DIGRAPH");
    map.put('\u02A5', "LATIN SMALL LETTER DZ DIGRAPH WITH CURL");
    map.put('\u02A6', "LATIN SMALL LETTER TS DIGRAPH");
    map.put('\u02A7', "LATIN SMALL LETTER TESH DIGRAPH");
    map.put('\u02A8', "LATIN SMALL LETTER TC DIGRAPH WITH CURL");

    // IPA characters for disordered speech
    map.put('\u02A9', "LATIN SMALL LETTER FENG DIGRAPH");
    map.put('\u02AA', "LATIN SMALL LETTER LS DIGRAPH");
    map.put('\u02AB', "LATIN SMALL LETTER LZ DIGRAPH");
    map.put('\u02AC', "LATIN LETTER BILABIAL PERCUSSIVE");
    map.put('\u02AD', "LATIN LETTER BIDENTAL PERCUSSIVE");

    // Additions for Sinology
    map.put('\u02AE', "LATIN SMALL LETTER TURNED H WITH FISHHOOK");
    map.put('\u02AF', "LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL");

  }

  public static final void spacingModifierLetters(Map<Character, String> map) {

    // Latin superscript modifier letters
    map.put('\u02B0', "MODIFIER LETTER SMALL H");
    map.put('\u02B1', "MODIFIER LETTER SMALL H WITH HOOK");
    map.put('\u02B2', "MODIFIER LETTER SMALL J");
    map.put('\u02B3', "MODIFIER LETTER SMALL R");
    map.put('\u02B4', "MODIFIER LETTER SMALL TURNED R");
    map.put('\u02B5', "MODIFIER LETTER SMALL TURNED R WITH HOOK");
    map.put('\u02B6', "MODIFIER LETTER SMALL CAPITAL INVERTED R");
    map.put('\u02B7', "MODIFIER LETTER SMALL W");
    map.put('\u02B8', "MODIFIER LETTER SMALL Y");

    // Miscellaneous phonetic modifiers
    map.put('\u02B9', "MODIFIER LETTER PRIME");
    map.put('\u02BA', "MODIFIER LETTER DOUBLE PRIME");
    map.put('\u02BB', "MODIFIER LETTER TURNED COMMA");
    map.put('\u02BC', "MODIFIER LETTER APOSTROPHE");
    map.put('\u02BD', "MODIFIER LETTER REVERSED COMMA");
    map.put('\u02BE', "MODIFIER LETTER RIGHT HALF RING");
    map.put('\u02BF', "MODIFIER LETTER LEFT HALF RING");
    map.put('\u02C0', "MODIFIER LETTER GLOTTAL STOP");
    map.put('\u02C1', "MODIFIER LETTER REVERSED GLOTTAL STOP");
    map.put('\u02C2', "MODIFIER LETTER LEFT ARROWHEAD");
    map.put('\u02C3', "MODIFIER LETTER RIGHT ARROWHEAD");
    map.put('\u02C4', "MODIFIER LETTER UP ARROWHEAD");
    map.put('\u02C5', "MODIFIER LETTER DOWN ARROWHEAD");
    map.put('\u02C6', "MODIFIER LETTER CIRCUMFLEX ACCENT");
    map.put('\u02C7', "CARON");
    map.put('\u02C8', "MODIFIER LETTER VERTICAL LINE");
    map.put('\u02C9', "MODIFIER LETTER MACRON");
    map.put('\u02CA', "MODIFIER LETTER ACUTE ACCENT");
    map.put('\u02CB', "MODIFIER LETTER GRAVE ACCENT");
    map.put('\u02CC', "MODIFIER LETTER LOW VERTICAL LINE");
    map.put('\u02CD', "MODIFIER LETTER LOW MACRON");
    map.put('\u02CE', "MODIFIER LETTER LOW GRAVE ACCENT");
    map.put('\u02CF', "MODIFIER LETTER LOW ACUTE ACCENT");
    map.put('\u02D0', "MODIFIER LETTER TRIANGULAR COLON");
    map.put('\u02D1', "MODIFIER LETTER HALF TRIANGULAR COLON");
    map.put('\u02D2', "MODIFIER LETTER CENTRED RIGHT HALF RING");
    map.put('\u02D3', "MODIFIER LETTER CENTRED LEFT HALF RING");
    map.put('\u02D4', "MODIFIER LETTER UP TACK");
    map.put('\u02D5', "MODIFIER LETTER DOWN TACK");
    map.put('\u02D6', "MODIFIER LETTER PLUS SIGN");
    map.put('\u02D7', "MODIFIER LETTER MINUS SIGN");

    // Spacing clones of diacritics
    map.put('\u02D8', "BREVE");
    map.put('\u02D9', "DOT ABOVE");
    map.put('\u02DA', "RING ABOVE");
    map.put('\u02DB', "OGONEK");
    map.put('\u02DC', "SMALL TILDE");
    map.put('\u02DD', "DOUBLE ACUTE ACCENT");

    // Additions based on 1989 IPA
    map.put('\u02DE', "MODIFIER LETTER RHOTIC HOOK");
    map.put('\u02DF', "MODIFIER LETTER CROSS ACCENT");
    map.put('\u02E0', "MODIFIER LETTER SMALL GAMMA");
    map.put('\u02E1', "MODIFIER LETTER SMALL L");
    map.put('\u02E2', "MODIFIER LETTER SMALL S");
    map.put('\u02E3', "MODIFIER LETTER SMALL X");
    map.put('\u02E4', "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP");

    // Tone letters
    map.put('\u02E5', "MODIFIER LETTER EXTRA-HIGH TONE BAR");
    map.put('\u02E6', "MODIFIER LETTER HIGH TONE BAR");
    map.put('\u02E7', "MODIFIER LETTER MID TONE BAR");
    map.put('\u02E8', "MODIFIER LETTER LOW TONE BAR");
    map.put('\u02E9', "MODIFIER LETTER EXTRA-LOW TONE BAR");

    // Extended Bopomofo tone marks
    map.put('\u02EA', "MODIFIER LETTER YIN DEPARTING TONE MARK");
    map.put('\u02EB', "MODIFIER LETTER YANG DEPARTING TONE MARK");

    // IPA modifiers
    map.put('\u02EC', "MODIFIER LETTER VOICING");
    map.put('\u02ED', "MODIFIER LETTER UNASPIRATED");

    // Other modifier letter
    map.put('\u02EE', "MODIFIER LETTER DOUBLE APOSTROPHE");

    // UPA modifiers
    map.put('\u02EF', "MODIFIER LETTER LOW DOWN ARROWHEAD");
    map.put('\u02F0', "MODIFIER LETTER LOW UP ARROWHEAD");
    map.put('\u02F1', "MODIFIER LETTER LOW LEFT ARROWHEAD");
    map.put('\u02F2', "MODIFIER LETTER LOW RIGHT ARROWHEAD");
    map.put('\u02F3', "MODIFIER LETTER LOW RING");
    map.put('\u02F4', "MODIFIER LETTER MIDDLE GRAVE ACCENT");
    map.put('\u02F5', "MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT");
    map.put('\u02F6', "MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT");
    map.put('\u02F7', "MODIFIER LETTER LOW TILDE");
    map.put('\u02F8', "MODIFIER LETTER RAISED COLON");
    map.put('\u02F9', "MODIFIER LETTER BEGIN HIGH TONE");
    map.put('\u02FA', "MODIFIER LETTER END HIGH TONE");
    map.put('\u02FB', "MODIFIER LETTER BEGIN LOW TONE");
    map.put('\u02FC', "MODIFIER LETTER END LOW TONE");
    map.put('\u02FD', "MODIFIER LETTER SHELF");
    map.put('\u02FE', "MODIFIER LETTER OPEN SHELF");
    map.put('\u02FF', "MODIFIER LETTER LOW LEFT ARROW");

  }

  public static final void combiningDiacriticMarks(Map<Character, String> map) {

    // Ordinary diacritics
    map.put('\u0300', "COMBINING GRAVE ACCENT");
    map.put('\u0301', "COMBINING ACUTE ACCENT");
    map.put('\u0302', "COMBINING CIRCUMFLEX ACCENT");
    map.put('\u0303', "COMBINING TILDE");
    map.put('\u0304', "COMBINING MACRON");
    map.put('\u0305', "COMBINING OVERLINE");
    map.put('\u0306', "COMBINING BREVE");
    map.put('\u0307', "COMBINING DOT ABOVE");
    map.put('\u0308', "COMBINING DIAERESIS");
    map.put('\u0309', "COMBINING HOOK ABOVE");
    map.put('\u030A', "COMBINING RING ABOVE");
    map.put('\u030B', "COMBINING DOUBLE ACUTE ACCENT");
    map.put('\u030C', "COMBINING CARON");
    map.put('\u030D', "COMBINING VERTICAL LINE ABOVE");
    map.put('\u030E', "COMBINING DOUBLE VERTICAL LINE ABOVE");
    map.put('\u030F', "COMBINING DOUBLE GRAVE ACCENT");
    map.put('\u0310', "COMBINING CANDRABINDU");
    map.put('\u0311', "COMBINING INVERTED BREVE");
    map.put('\u0312', "COMBINING TURNED COMMA ABOVE");
    map.put('\u0313', "COMBINING COMMA ABOVE");
    map.put('\u0314', "COMBINING REVERSED COMMA ABOVE");
    map.put('\u0315', "COMBINING COMMA ABOVE RIGHT");
    map.put('\u0316', "COMBINING GRAVE ACCENT BELOW");
    map.put('\u0317', "COMBINING ACUTE ACCENT BELOW");
    map.put('\u0318', "COMBINING LEFT TACK BELOW");
    map.put('\u0319', "COMBINING RIGHT TACK BELOW");
    map.put('\u031A', "COMBINING LEFT ANGLE ABOVE");
    map.put('\u031B', "COMBINING HORN");
    map.put('\u031C', "COMBINING LEFT HALF RING BELOW");
    map.put('\u031D', "COMBINING UP TACK BELOW");
    map.put('\u031E', "COMBINING DOWN TACK BELOW");
    map.put('\u031F', "COMBINING PLUS SIGN BELOW");
    map.put('\u0320', "COMBINING MINUS SIGN BELOW");
    map.put('\u0321', "COMBINING PALATALIZED HOOK BELOW");
    map.put('\u0322', "COMBINING RETROFLEX HOOK BELOW");
    map.put('\u0323', "COMBINING DOT BELOW");
    map.put('\u0324', "COMBINING DIAERESIS BELOW");
    map.put('\u0325', "COMBINING RING BELOW");
    map.put('\u0326', "COMBINING COMMA BELOW");
    map.put('\u0327', "COMBINING CEDILLA");
    map.put('\u0328', "COMBINING OGONEK");
    map.put('\u0329', "COMBINING VERTICAL LINE BELOW");
    map.put('\u032A', "COMBINING BRIDGE BELOW");
    map.put('\u032B', "COMBINING INVERTED DOUBLE ARCH BELOW");
    map.put('\u032C', "COMBINING CARON BELOW");
    map.put('\u032D', "COMBINING CIRCUMFLEX ACCENT BELOW");
    map.put('\u032E', "COMBINING BREVE BELOW");
    map.put('\u032F', "COMBINING INVERTED BREVE BELOW");
    map.put('\u0330', "COMBINING TILDE BELOW");
    map.put('\u0331', "COMBINING MACRON BELOW");
    map.put('\u0332', "COMBINING LOW LINE");
    map.put('\u0333', "COMBINING DOUBLE LOW LINE");

    // Overstruck diacritics
    map.put('\u0334', "COMBINING TILDE OVERLAY");
    map.put('\u0335', "COMBINING SHORT STROKE OVERLAY");
    map.put('\u0336', "COMBINING LONG STROKE OVERLAY");
    map.put('\u0337', "COMBINING SHORT SOLIDUS OVERLAY");
    map.put('\u0338', "COMBINING LONG SOLIDUS OVERLAY");

    // Additions
    map.put('\u0339', "COMBINING RIGHT HALF RING BELOW");
    map.put('\u033A', "COMBINING INVERTED BRIDGE BELOW");
    map.put('\u033B', "COMBINING SQUARE BELOW");
    map.put('\u033C', "COMBINING SEAGULL BELOW");
    map.put('\u033D', "COMBINING X ABOVE");
    map.put('\u033E', "COMBINING VERTICAL TILDE");
    map.put('\u033F', "COMBINING DOUBLE OVERLINE");

    // Vietnamese tone marks
    map.put('\u0340', "COMBINING GRAVE TONE MARK");
    map.put('\u0341', "COMBINING ACUTE TONE MARK");

    // Additions for Greek
    map.put('\u0342', "COMBINING GREEK PERISPOMENI");
    map.put('\u0343', "COMBINING GREEK KORONIS");
    map.put('\u0344', "COMBINING GREEK DIALYTIKA TONOS");
    map.put('\u0345', "COMBINING GREEK YPOGEGRAMMENI");

    // Additions for IPA
    map.put('\u0346', "COMBINING BRIDGE ABOVE");
    map.put('\u0347', "COMBINING EQUALS SIGN BELOW");
    map.put('\u0348', "COMBINING DOUBLE VERTICAL LINE BELOW");
    map.put('\u0349', "COMBINING LEFT ANGLE BELOW");
    map.put('\u034A', "COMBINING NOT TILDE ABOVE");

    // IPA diacritics for disordered speech
    map.put('\u034B', "COMBINING HOMOTHETIC ABOVE");
    map.put('\u034C', "COMBINING ALMOST EQUAL TO ABOVE");
    map.put('\u034D', "COMBINING LEFT RIGHT ARROW BELOW");
    map.put('\u034E', "COMBINING UPWARDS ARROW BELOW");

    // Grapheme joiner
    map.put('\u034F', "COMBINING GRAPHEME JOINER");

    // Additions for the Uralic Phonetic Alphabet
    map.put('\u0350', "COMBINING RIGHT ARROWHEAD ABOVE");
    map.put('\u0351', "COMBINING LEFT HALF RING ABOVE");
    map.put('\u0352', "COMBINING FERMATA");
    map.put('\u0353', "COMBINING X BELOW");
    map.put('\u0354', "COMBINING LEFT ARROWHEAD BELOW");
    map.put('\u0355', "COMBINING RIGHT ARROWHEAD BELOW");
    map.put('\u0356', "COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW");
    map.put('\u0357', "COMBINING RIGHT HALF RING ABOVE");

    // Miscellaneous additions
    map.put('\u0358', "COMBINING DOT ABOVE RIGHT");
    map.put('\u0359', "COMBINING ASTERISK BELOW");
    map.put('\u035A', "COMBINING DOUBLE RING BELOW");
    map.put('\u035B', "COMBINING ZIGZAG ABOVE");

    // Double diacritics
    map.put('\u035C', "COMBINING DOUBLE BREVE BELOW");
    map.put('\u035D', "COMBINING DOUBLE BREVE");
    map.put('\u035E', "COMBINING DOUBLE MACRON");
    map.put('\u035F', "COMBINING DOUBLE MACRON BELOW");
    map.put('\u0360', "COMBINING DOUBLE TILDE");
    map.put('\u0361', "COMBINING DOUBLE INVERTED BREVE");
    map.put('\u0362', "COMBINING DOUBLE RIGHTWARDS ARROW BELOW");

    // Medieval superscript letter diacritics
    map.put('\u0363', "COMBINING LATIN SMALL LETTER A");
    map.put('\u0364', "COMBINING LATIN SMALL LETTER E");
    map.put('\u0365', "COMBINING LATIN SMALL LETTER I");
    map.put('\u0366', "COMBINING LATIN SMALL LETTER O");
    map.put('\u0367', "COMBINING LATIN SMALL LETTER U");
    map.put('\u0368', "COMBINING LATIN SMALL LETTER C");
    map.put('\u0369', "COMBINING LATIN SMALL LETTER D");
    map.put('\u036A', "COMBINING LATIN SMALL LETTER H");
    map.put('\u036B', "COMBINING LATIN SMALL LETTER M");
    map.put('\u036C', "COMBINING LATIN SMALL LETTER R");
    map.put('\u036D', "COMBINING LATIN SMALL LETTER T");
    map.put('\u036E', "COMBINING LATIN SMALL LETTER V");
    map.put('\u036F', "COMBINING LATIN SMALL LETTER X");

  }

  public static final void greekAndCoptic(Map<Character, String> map) {

    map.put('\u0370', "GREEK CAPITAL LETTER HETA");
    map.put('\u0371', "GREEK SMALL LETTER HETA");
    map.put('\u0372', "GREEK CAPITAL LETTER ARCHAIC SAMPI");
    map.put('\u0373', "GREEK SMALL LETTER ARCHAIC SAMPI");
    map.put('\u0374', "GREEK NUMERAL SIGN");
    map.put('\u0375', "GREEK LOWER NUMERAL SIGN");
    map.put('\u0376', "GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA");
    map.put('\u0377', "GREEK SMALL LETTER PAMPHYLIAN DIGAMMA");
    map.put('\u037A', "GREEK YPOGEGRAMMENI");
    map.put('\u037B', "GREEK SMALL REVERSED LUNATE SIGMA SYMBOL");
    map.put('\u037C', "GREEK SMALL DOTTED LUNATE SIGMA SYMBOL");
    map.put('\u037D', "GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL");
    map.put('\u037E', "GREEK QUESTION MARK");
    map.put('\u0384', "GREEK TONOS");
    map.put('\u0385', "GREEK DIALYTIKA TONOS");
    map.put('\u0386', "GREEK CAPITAL LETTER ALPHA WITH TONOS");
    map.put('\u0387', "GREEK ANO TELEIA");
    map.put('\u0388', "GREEK CAPITAL LETTER EPSILON WITH TONOS");
    map.put('\u0389', "GREEK CAPITAL LETTER ETA WITH TONOS");
    map.put('\u038A', "GREEK CAPITAL LETTER IOTA WITH TONOS");
    map.put('\u038C', "GREEK CAPITAL LETTER OMICRON WITH TONOS");
    map.put('\u038E', "GREEK CAPITAL LETTER UPSILON WITH TONOS");
    map.put('\u038F', "GREEK CAPITAL LETTER OMEGA WITH TONOS");
    map.put('\u0390', "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS");
    map.put('\u0391', "GREEK CAPITAL LETTER ALPHA");
    map.put('\u0392', "GREEK CAPITAL LETTER BETA");
    map.put('\u0393', "GREEK CAPITAL LETTER GAMMA");
    map.put('\u0394', "GREEK CAPITAL LETTER DELTA");
    map.put('\u0395', "GREEK CAPITAL LETTER EPSILON");
    map.put('\u0396', "GREEK CAPITAL LETTER ZETA");
    map.put('\u0397', "GREEK CAPITAL LETTER ETA");
    map.put('\u0398', "GREEK CAPITAL LETTER THETA");
    map.put('\u0399', "GREEK CAPITAL LETTER IOTA");
    map.put('\u039A', "GREEK CAPITAL LETTER KAPPA");
    map.put('\u039B', "GREEK CAPITAL LETTER LAMDA");
    map.put('\u039C', "GREEK CAPITAL LETTER MU");
    map.put('\u039D', "GREEK CAPITAL LETTER NU");
    map.put('\u039E', "GREEK CAPITAL LETTER XI");
    map.put('\u039F', "GREEK CAPITAL LETTER OMICRON");
    map.put('\u03A0', "GREEK CAPITAL LETTER PI");
    map.put('\u03A1', "GREEK CAPITAL LETTER RHO");
    map.put('\u03A3', "GREEK CAPITAL LETTER SIGMA");
    map.put('\u03A4', "GREEK CAPITAL LETTER TAU");
    map.put('\u03A5', "GREEK CAPITAL LETTER UPSILON");
    map.put('\u03A6', "GREEK CAPITAL LETTER PHI");
    map.put('\u03A7', "GREEK CAPITAL LETTER CHI");
    map.put('\u03A8', "GREEK CAPITAL LETTER PSI");
    map.put('\u03A9', "GREEK CAPITAL LETTER OMEGA");
    map.put('\u03AA', "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA");
    map.put('\u03AB', "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA");
    map.put('\u03AC', "GREEK SMALL LETTER ALPHA WITH TONOS");
    map.put('\u03AD', "GREEK SMALL LETTER EPSILON WITH TONOS");
    map.put('\u03AE', "GREEK SMALL LETTER ETA WITH TONOS");
    map.put('\u03AF', "GREEK SMALL LETTER IOTA WITH TONOS");
    map.put('\u03B0', "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS");
    map.put('\u03B1', "GREEK SMALL LETTER ALPHA");
    map.put('\u03B2', "GREEK SMALL LETTER BETA");
    map.put('\u03B3', "GREEK SMALL LETTER GAMMA");
    map.put('\u03B4', "GREEK SMALL LETTER DELTA");
    map.put('\u03B5', "GREEK SMALL LETTER EPSILON");
    map.put('\u03B6', "GREEK SMALL LETTER ZETA");
    map.put('\u03B7', "GREEK SMALL LETTER ETA");
    map.put('\u03B8', "GREEK SMALL LETTER THETA");
    map.put('\u03B9', "GREEK SMALL LETTER IOTA");
    map.put('\u03BA', "GREEK SMALL LETTER KAPPA");
    map.put('\u03BB', "GREEK SMALL LETTER LAMDA");
    map.put('\u03BC', "GREEK SMALL LETTER MU");
    map.put('\u03BD', "GREEK SMALL LETTER NU");
    map.put('\u03BE', "GREEK SMALL LETTER XI");
    map.put('\u03BF', "GREEK SMALL LETTER OMICRON");
    map.put('\u03C0', "GREEK SMALL LETTER PI");
    map.put('\u03C1', "GREEK SMALL LETTER RHO");
    map.put('\u03C2', "GREEK SMALL LETTER FINAL SIGMA");
    map.put('\u03C3', "GREEK SMALL LETTER SIGMA");
    map.put('\u03C4', "GREEK SMALL LETTER TAU");
    map.put('\u03C5', "GREEK SMALL LETTER UPSILON");
    map.put('\u03C6', "GREEK SMALL LETTER PHI");
    map.put('\u03C7', "GREEK SMALL LETTER CHI");
    map.put('\u03C8', "GREEK SMALL LETTER PSI");
    map.put('\u03C9', "GREEK SMALL LETTER OMEGA");
    map.put('\u03CA', "GREEK SMALL LETTER IOTA WITH DIALYTIKA");
    map.put('\u03CB', "GREEK SMALL LETTER UPSILON WITH DIALYTIKA");
    map.put('\u03CC', "GREEK SMALL LETTER OMICRON WITH TONOS");
    map.put('\u03CD', "GREEK SMALL LETTER UPSILON WITH TONOS");
    map.put('\u03CE', "GREEK SMALL LETTER OMEGA WITH TONOS");
    map.put('\u03CF', "GREEK CAPITAL KAI SYMBOL");
    map.put('\u03D0', "GREEK BETA SYMBOL");
    map.put('\u03D1', "GREEK THETA SYMBOL");
    map.put('\u03D2', "GREEK UPSILON WITH HOOK SYMBOL");
    map.put('\u03D3', "GREEK UPSILON WITH ACUTE AND HOOK SYMBOL");
    map.put('\u03D4', "GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL");
    map.put('\u03D5', "GREEK PHI SYMBOL");
    map.put('\u03D6', "GREEK PI SYMBOL");
    map.put('\u03D7', "GREEK KAI SYMBOL");
    map.put('\u03D8', "GREEK LETTER ARCHAIC KOPPA");
    map.put('\u03D9', "GREEK SMALL LETTER ARCHAIC KOPPA");
    map.put('\u03DA', "GREEK LETTER STIGMA");
    map.put('\u03DB', "GREEK SMALL LETTER STIGMA");
    map.put('\u03DC', "GREEK LETTER DIGAMMA");
    map.put('\u03DD', "GREEK SMALL LETTER DIGAMMA");
    map.put('\u03DE', "GREEK LETTER KOPPA");
    map.put('\u03DF', "GREEK SMALL LETTER KOPPA");
    map.put('\u03E0', "GREEK LETTER SAMPI");
    map.put('\u03E1', "GREEK SMALL LETTER SAMPI");
    map.put('\u03E2', "COPTIC CAPITAL LETTER SHEI");
    map.put('\u03E3', "COPTIC SMALL LETTER SHEI");
    map.put('\u03E4', "COPTIC CAPITAL LETTER FEI");
    map.put('\u03E5', "COPTIC SMALL LETTER FEI");
    map.put('\u03E6', "COPTIC CAPITAL LETTER KHEI");
    map.put('\u03E7', "COPTIC SMALL LETTER KHEI");
    map.put('\u03E8', "COPTIC CAPITAL LETTER HORI");
    map.put('\u03E9', "COPTIC SMALL LETTER HORI");
    map.put('\u03EA', "COPTIC CAPITAL LETTER GANGIA");
    map.put('\u03EB', "COPTIC SMALL LETTER GANGIA");
    map.put('\u03EC', "COPTIC CAPITAL LETTER SHIMA");
    map.put('\u03ED', "COPTIC SMALL LETTER SHIMA");
    map.put('\u03EE', "COPTIC CAPITAL LETTER DEI");
    map.put('\u03EF', "COPTIC SMALL LETTER DEI");
    map.put('\u03F0', "GREEK KAPPA SYMBOL");
    map.put('\u03F1', "GREEK RHO SYMBOL");
    map.put('\u03F2', "GREEK LUNATE SIGMA SYMBOL");
    map.put('\u03F3', "GREEK LETTER YOT");
    map.put('\u03F4', "GREEK CAPITAL THETA SYMBOL");
    map.put('\u03F5', "GREEK LUNATE EPSILON SYMBOL");
    map.put('\u03F6', "GREEK REVERSED LUNATE EPSILON SYMBOL");
    map.put('\u03F7', "GREEK CAPITAL LETTER SHO");
    map.put('\u03F8', "GREEK SMALL LETTER SHO");
    map.put('\u03F9', "GREEK CAPITAL LUNATE SIGMA SYMBOL");
    map.put('\u03FA', "GREEK CAPITAL LETTER SAN");
    map.put('\u03FB', "GREEK SMALL LETTER SAN");
    map.put('\u03FC', "GREEK RHO WITH STROKE SYMBOL");
    map.put('\u03FD', "GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL");
    map.put('\u03FE', "GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL");
    map.put('\u03FF', "GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL");

  }

  public static final void cyrillic(Map<Character, String> map) {

    map.put('\u0400', "CYRILLIC CAPITAL LETTER IE WITH GRAVE");
    map.put('\u0401', "CYRILLIC CAPITAL LETTER IO");
    map.put('\u0402', "CYRILLIC CAPITAL LETTER DJE");
    map.put('\u0403', "CYRILLIC CAPITAL LETTER GJE");
    map.put('\u0404', "CYRILLIC CAPITAL LETTER UKRAINIAN IE");
    map.put('\u0405', "CYRILLIC CAPITAL LETTER DZE");
    map.put('\u0406', "CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I");
    map.put('\u0407', "CYRILLIC CAPITAL LETTER YI");
    map.put('\u0408', "CYRILLIC CAPITAL LETTER JE");
    map.put('\u0409', "CYRILLIC CAPITAL LETTER LJE");
    map.put('\u040A', "CYRILLIC CAPITAL LETTER NJE");
    map.put('\u040B', "CYRILLIC CAPITAL LETTER TSHE");
    map.put('\u040C', "CYRILLIC CAPITAL LETTER KJE");
    map.put('\u040D', "CYRILLIC CAPITAL LETTER I WITH GRAVE");
    map.put('\u040E', "CYRILLIC CAPITAL LETTER SHORT U");
    map.put('\u040F', "CYRILLIC CAPITAL LETTER DZHE");
    map.put('\u0410', "CYRILLIC CAPITAL LETTER A");
    map.put('\u0411', "CYRILLIC CAPITAL LETTER BE");
    map.put('\u0412', "CYRILLIC CAPITAL LETTER VE");
    map.put('\u0413', "CYRILLIC CAPITAL LETTER GHE");
    map.put('\u0414', "CYRILLIC CAPITAL LETTER DE");
    map.put('\u0415', "CYRILLIC CAPITAL LETTER IE");
    map.put('\u0416', "CYRILLIC CAPITAL LETTER ZHE");
    map.put('\u0417', "CYRILLIC CAPITAL LETTER ZE");
    map.put('\u0418', "CYRILLIC CAPITAL LETTER I");
    map.put('\u0419', "CYRILLIC CAPITAL LETTER SHORT I");
    map.put('\u041A', "CYRILLIC CAPITAL LETTER KA");
    map.put('\u041B', "CYRILLIC CAPITAL LETTER EL");
    map.put('\u041C', "CYRILLIC CAPITAL LETTER EM");
    map.put('\u041D', "CYRILLIC CAPITAL LETTER EN");
    map.put('\u041E', "CYRILLIC CAPITAL LETTER O");
    map.put('\u041F', "CYRILLIC CAPITAL LETTER PE");
    map.put('\u0420', "CYRILLIC CAPITAL LETTER ER");
    map.put('\u0421', "CYRILLIC CAPITAL LETTER ES");
    map.put('\u0422', "CYRILLIC CAPITAL LETTER TE");
    map.put('\u0423', "CYRILLIC CAPITAL LETTER U");
    map.put('\u0424', "CYRILLIC CAPITAL LETTER EF");
    map.put('\u0425', "CYRILLIC CAPITAL LETTER HA");
    map.put('\u0426', "CYRILLIC CAPITAL LETTER TSE");
    map.put('\u0427', "CYRILLIC CAPITAL LETTER CHE");
    map.put('\u0428', "CYRILLIC CAPITAL LETTER SHA");
    map.put('\u0429', "CYRILLIC CAPITAL LETTER SHCHA");
    map.put('\u042A', "CYRILLIC CAPITAL LETTER HARD SIGN");
    map.put('\u042B', "CYRILLIC CAPITAL LETTER YERU");
    map.put('\u042C', "CYRILLIC CAPITAL LETTER SOFT SIGN");
    map.put('\u042D', "CYRILLIC CAPITAL LETTER E");
    map.put('\u042E', "CYRILLIC CAPITAL LETTER YU");
    map.put('\u042F', "CYRILLIC CAPITAL LETTER YA");
    map.put('\u0430', "CYRILLIC SMALL LETTER A");
    map.put('\u0431', "CYRILLIC SMALL LETTER BE");
    map.put('\u0432', "CYRILLIC SMALL LETTER VE");
    map.put('\u0433', "CYRILLIC SMALL LETTER GHE");
    map.put('\u0434', "CYRILLIC SMALL LETTER DE");
    map.put('\u0435', "CYRILLIC SMALL LETTER IE");
    map.put('\u0436', "CYRILLIC SMALL LETTER ZHE");
    map.put('\u0437', "CYRILLIC SMALL LETTER ZE");
    map.put('\u0438', "CYRILLIC SMALL LETTER I");
    map.put('\u0439', "CYRILLIC SMALL LETTER SHORT I");
    map.put('\u043A', "CYRILLIC SMALL LETTER KA");
    map.put('\u043B', "CYRILLIC SMALL LETTER EL");
    map.put('\u043C', "CYRILLIC SMALL LETTER EM");
    map.put('\u043D', "CYRILLIC SMALL LETTER EN");
    map.put('\u043E', "CYRILLIC SMALL LETTER O");
    map.put('\u043F', "CYRILLIC SMALL LETTER PE");
    map.put('\u0440', "CYRILLIC SMALL LETTER ER");
    map.put('\u0441', "CYRILLIC SMALL LETTER ES");
    map.put('\u0442', "CYRILLIC SMALL LETTER TE");
    map.put('\u0443', "CYRILLIC SMALL LETTER U");
    map.put('\u0444', "CYRILLIC SMALL LETTER EF");
    map.put('\u0445', "CYRILLIC SMALL LETTER HA");
    map.put('\u0446', "CYRILLIC SMALL LETTER TSE");
    map.put('\u0447', "CYRILLIC SMALL LETTER CHE");
    map.put('\u0448', "CYRILLIC SMALL LETTER SHA");
    map.put('\u0449', "CYRILLIC SMALL LETTER SHCHA");
    map.put('\u044A', "CYRILLIC SMALL LETTER HARD SIGN");
    map.put('\u044B', "CYRILLIC SMALL LETTER YERU");
    map.put('\u044C', "CYRILLIC SMALL LETTER SOFT SIGN");
    map.put('\u044D', "CYRILLIC SMALL LETTER E");
    map.put('\u044E', "CYRILLIC SMALL LETTER YU");
    map.put('\u044F', "CYRILLIC SMALL LETTER YA");
    map.put('\u0450', "CYRILLIC SMALL LETTER IE WITH GRAVE");
    map.put('\u0451', "CYRILLIC SMALL LETTER IO");
    map.put('\u0452', "CYRILLIC SMALL LETTER DJE");
    map.put('\u0453', "CYRILLIC SMALL LETTER GJE");
    map.put('\u0454', "CYRILLIC SMALL LETTER UKRAINIAN IE");
    map.put('\u0455', "CYRILLIC SMALL LETTER DZE");
    map.put('\u0456', "CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I");
    map.put('\u0457', "CYRILLIC SMALL LETTER YI");
    map.put('\u0458', "CYRILLIC SMALL LETTER JE");
    map.put('\u0459', "CYRILLIC SMALL LETTER LJE");
    map.put('\u045A', "CYRILLIC SMALL LETTER NJE");
    map.put('\u045B', "CYRILLIC SMALL LETTER TSHE");
    map.put('\u045C', "CYRILLIC SMALL LETTER KJE");
    map.put('\u045D', "CYRILLIC SMALL LETTER I WITH GRAVE");
    map.put('\u045E', "CYRILLIC SMALL LETTER SHORT U");
    map.put('\u045F', "CYRILLIC SMALL LETTER DZHE");
    map.put('\u0460', "CYRILLIC CAPITAL LETTER OMEGA");
    map.put('\u0461', "CYRILLIC SMALL LETTER OMEGA");
    map.put('\u0462', "CYRILLIC CAPITAL LETTER YAT");
    map.put('\u0463', "CYRILLIC SMALL LETTER YAT");
    map.put('\u0464', "CYRILLIC CAPITAL LETTER IOTIFIED E");
    map.put('\u0465', "CYRILLIC SMALL LETTER IOTIFIED E");
    map.put('\u0466', "CYRILLIC CAPITAL LETTER LITTLE YUS");
    map.put('\u0467', "CYRILLIC SMALL LETTER LITTLE YUS");
    map.put('\u0468', "CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS");
    map.put('\u0469', "CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS");
    map.put('\u046A', "CYRILLIC CAPITAL LETTER BIG YUS");
    map.put('\u046B', "CYRILLIC SMALL LETTER BIG YUS");
    map.put('\u046C', "CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS");
    map.put('\u046D', "CYRILLIC SMALL LETTER IOTIFIED BIG YUS");
    map.put('\u046E', "CYRILLIC CAPITAL LETTER KSI");
    map.put('\u046F', "CYRILLIC SMALL LETTER KSI");
    map.put('\u0470', "CYRILLIC CAPITAL LETTER PSI");
    map.put('\u0471', "CYRILLIC SMALL LETTER PSI");
    map.put('\u0472', "CYRILLIC CAPITAL LETTER FITA");
    map.put('\u0473', "CYRILLIC SMALL LETTER FITA");
    map.put('\u0474', "CYRILLIC CAPITAL LETTER IZHITSA");
    map.put('\u0475', "CYRILLIC SMALL LETTER IZHITSA");
    map.put('\u0476', "CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT");
    map.put('\u0477', "CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT");
    map.put('\u0478', "CYRILLIC CAPITAL LETTER UK");
    map.put('\u0479', "CYRILLIC SMALL LETTER UK");
    map.put('\u047A', "CYRILLIC CAPITAL LETTER ROUND OMEGA");
    map.put('\u047B', "CYRILLIC SMALL LETTER ROUND OMEGA");
    map.put('\u047C', "CYRILLIC CAPITAL LETTER OMEGA WITH TITLO");
    map.put('\u047D', "CYRILLIC SMALL LETTER OMEGA WITH TITLO");
    map.put('\u047E', "CYRILLIC CAPITAL LETTER OT");
    map.put('\u047F', "CYRILLIC SMALL LETTER OT");
    map.put('\u0480', "CYRILLIC CAPITAL LETTER KOPPA");
    map.put('\u0481', "CYRILLIC SMALL LETTER KOPPA");
    map.put('\u0482', "CYRILLIC THOUSANDS SIGN");
    map.put('\u0483', "COMBINING CYRILLIC TITLO");
    map.put('\u0484', "COMBINING CYRILLIC PALATALIZATION");
    map.put('\u0485', "COMBINING CYRILLIC DASIA PNEUMATA");
    map.put('\u0486', "COMBINING CYRILLIC PSILI PNEUMATA");
    map.put('\u0487', "COMBINING CYRILLIC POKRYTIE");
    map.put('\u0488', "COMBINING CYRILLIC HUNDRED THOUSANDS SIGN");
    map.put('\u0489', "COMBINING CYRILLIC MILLIONS SIGN");
    map.put('\u048A', "CYRILLIC CAPITAL LETTER SHORT I WITH TAIL");
    map.put('\u048B', "CYRILLIC SMALL LETTER SHORT I WITH TAIL");
    map.put('\u048C', "CYRILLIC CAPITAL LETTER SEMISOFT SIGN");
    map.put('\u048D', "CYRILLIC SMALL LETTER SEMISOFT SIGN");
    map.put('\u048E', "CYRILLIC CAPITAL LETTER ER WITH TICK");
    map.put('\u048F', "CYRILLIC SMALL LETTER ER WITH TICK");
    map.put('\u0490', "CYRILLIC CAPITAL LETTER GHE WITH UPTURN");
    map.put('\u0491', "CYRILLIC SMALL LETTER GHE WITH UPTURN");
    map.put('\u0492', "CYRILLIC CAPITAL LETTER GHE WITH STROKE");
    map.put('\u0493', "CYRILLIC SMALL LETTER GHE WITH STROKE");
    map.put('\u0494', "CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK");
    map.put('\u0495', "CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK");
    map.put('\u0496', "CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER");
    map.put('\u0497', "CYRILLIC SMALL LETTER ZHE WITH DESCENDER");
    map.put('\u0498', "CYRILLIC CAPITAL LETTER ZE WITH DESCENDER");
    map.put('\u0499', "CYRILLIC SMALL LETTER ZE WITH DESCENDER");
    map.put('\u049A', "CYRILLIC CAPITAL LETTER KA WITH DESCENDER");
    map.put('\u049B', "CYRILLIC SMALL LETTER KA WITH DESCENDER");
    map.put('\u049C', "CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE");
    map.put('\u049D', "CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE");
    map.put('\u049E', "CYRILLIC CAPITAL LETTER KA WITH STROKE");
    map.put('\u049F', "CYRILLIC SMALL LETTER KA WITH STROKE");
    map.put('\u04A0', "CYRILLIC CAPITAL LETTER BASHKIR KA");
    map.put('\u04A1', "CYRILLIC SMALL LETTER BASHKIR KA");
    map.put('\u04A2', "CYRILLIC CAPITAL LETTER EN WITH DESCENDER");
    map.put('\u04A3', "CYRILLIC SMALL LETTER EN WITH DESCENDER");
    map.put('\u04A4', "CYRILLIC CAPITAL LIGATURE EN GHE");
    map.put('\u04A5', "CYRILLIC SMALL LIGATURE EN GHE");
    map.put('\u04A6', "CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK");
    map.put('\u04A7', "CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK");
    map.put('\u04A8', "CYRILLIC CAPITAL LETTER ABKHASIAN HA");
    map.put('\u04A9', "CYRILLIC SMALL LETTER ABKHASIAN HA");
    map.put('\u04AA', "CYRILLIC CAPITAL LETTER ES WITH DESCENDER");
    map.put('\u04AB', "CYRILLIC SMALL LETTER ES WITH DESCENDER");
    map.put('\u04AC', "CYRILLIC CAPITAL LETTER TE WITH DESCENDER");
    map.put('\u04AD', "CYRILLIC SMALL LETTER TE WITH DESCENDER");
    map.put('\u04AE', "CYRILLIC CAPITAL LETTER STRAIGHT U");
    map.put('\u04AF', "CYRILLIC SMALL LETTER STRAIGHT U");
    map.put('\u04B0', "CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE");
    map.put('\u04B1', "CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE");
    map.put('\u04B2', "CYRILLIC CAPITAL LETTER HA WITH DESCENDER");
    map.put('\u04B3', "CYRILLIC SMALL LETTER HA WITH DESCENDER");
    map.put('\u04B4', "CYRILLIC CAPITAL LIGATURE TE TSE");
    map.put('\u04B5', "CYRILLIC SMALL LIGATURE TE TSE");
    map.put('\u04B6', "CYRILLIC CAPITAL LETTER CHE WITH DESCENDER");
    map.put('\u04B7', "CYRILLIC SMALL LETTER CHE WITH DESCENDER");
    map.put('\u04B8', "CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE");
    map.put('\u04B9', "CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE");
    map.put('\u04BA', "CYRILLIC CAPITAL LETTER SHHA");
    map.put('\u04BB', "CYRILLIC SMALL LETTER SHHA");
    map.put('\u04BC', "CYRILLIC CAPITAL LETTER ABKHASIAN CHE");
    map.put('\u04BD', "CYRILLIC SMALL LETTER ABKHASIAN CHE");
    map.put('\u04BE', "CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER");
    map.put('\u04BF', "CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER");
    map.put('\u04C0', "CYRILLIC LETTER PALOCHKA");
    map.put('\u04C1', "CYRILLIC CAPITAL LETTER ZHE WITH BREVE");
    map.put('\u04C2', "CYRILLIC SMALL LETTER ZHE WITH BREVE");
    map.put('\u04C3', "CYRILLIC CAPITAL LETTER KA WITH HOOK");
    map.put('\u04C4', "CYRILLIC SMALL LETTER KA WITH HOOK");
    map.put('\u04C5', "CYRILLIC CAPITAL LETTER EL WITH TAIL");
    map.put('\u04C6', "CYRILLIC SMALL LETTER EL WITH TAIL");
    map.put('\u04C7', "CYRILLIC CAPITAL LETTER EN WITH HOOK");
    map.put('\u04C8', "CYRILLIC SMALL LETTER EN WITH HOOK");
    map.put('\u04C9', "CYRILLIC CAPITAL LETTER EN WITH TAIL");
    map.put('\u04CA', "CYRILLIC SMALL LETTER EN WITH TAIL");
    map.put('\u04CB', "CYRILLIC CAPITAL LETTER KHAKASSIAN CHE");
    map.put('\u04CC', "CYRILLIC SMALL LETTER KHAKASSIAN CHE");
    map.put('\u04CD', "CYRILLIC CAPITAL LETTER EM WITH TAIL");
    map.put('\u04CE', "CYRILLIC SMALL LETTER EM WITH TAIL");
    map.put('\u04CF', "CYRILLIC SMALL LETTER PALOCHKA");
    map.put('\u04D0', "CYRILLIC CAPITAL LETTER A WITH BREVE");
    map.put('\u04D1', "CYRILLIC SMALL LETTER A WITH BREVE");
    map.put('\u04D2', "CYRILLIC CAPITAL LETTER A WITH DIAERESIS");
    map.put('\u04D3', "CYRILLIC SMALL LETTER A WITH DIAERESIS");
    map.put('\u04D4', "CYRILLIC CAPITAL LIGATURE A IE");
    map.put('\u04D5', "CYRILLIC SMALL LIGATURE A IE");
    map.put('\u04D6', "CYRILLIC CAPITAL LETTER IE WITH BREVE");
    map.put('\u04D7', "CYRILLIC SMALL LETTER IE WITH BREVE");
    map.put('\u04D8', "CYRILLIC CAPITAL LETTER SCHWA");
    map.put('\u04D9', "CYRILLIC SMALL LETTER SCHWA");
    map.put('\u04DA', "CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS");
    map.put('\u04DB', "CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS");
    map.put('\u04DC', "CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS");
    map.put('\u04DD', "CYRILLIC SMALL LETTER ZHE WITH DIAERESIS");
    map.put('\u04DE', "CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS");
    map.put('\u04DF', "CYRILLIC SMALL LETTER ZE WITH DIAERESIS");
    map.put('\u04E0', "CYRILLIC CAPITAL LETTER ABKHASIAN DZE");
    map.put('\u04E1', "CYRILLIC SMALL LETTER ABKHASIAN DZE");
    map.put('\u04E2', "CYRILLIC CAPITAL LETTER I WITH MACRON");
    map.put('\u04E3', "CYRILLIC SMALL LETTER I WITH MACRON");
    map.put('\u04E4', "CYRILLIC CAPITAL LETTER I WITH DIAERESIS");
    map.put('\u04E5', "CYRILLIC SMALL LETTER I WITH DIAERESIS");
    map.put('\u04E6', "CYRILLIC CAPITAL LETTER O WITH DIAERESIS");
    map.put('\u04E7', "CYRILLIC SMALL LETTER O WITH DIAERESIS");
    map.put('\u04E8', "CYRILLIC CAPITAL LETTER BARRED O");
    map.put('\u04E9', "CYRILLIC SMALL LETTER BARRED O");
    map.put('\u04EA', "CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS");
    map.put('\u04EB', "CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS");
    map.put('\u04EC', "CYRILLIC CAPITAL LETTER E WITH DIAERESIS");
    map.put('\u04ED', "CYRILLIC SMALL LETTER E WITH DIAERESIS");
    map.put('\u04EE', "CYRILLIC CAPITAL LETTER U WITH MACRON");
    map.put('\u04EF', "CYRILLIC SMALL LETTER U WITH MACRON");
    map.put('\u04F0', "CYRILLIC CAPITAL LETTER U WITH DIAERESIS");
    map.put('\u04F1', "CYRILLIC SMALL LETTER U WITH DIAERESIS");
    map.put('\u04F2', "CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE");
    map.put('\u04F3', "CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE");
    map.put('\u04F4', "CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS");
    map.put('\u04F5', "CYRILLIC SMALL LETTER CHE WITH DIAERESIS");
    map.put('\u04F6', "CYRILLIC CAPITAL LETTER GHE WITH DESCENDER");
    map.put('\u04F7', "CYRILLIC SMALL LETTER GHE WITH DESCENDER");
    map.put('\u04F8', "CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS");
    map.put('\u04F9', "CYRILLIC SMALL LETTER YERU WITH DIAERESIS");
    map.put('\u04FA', "CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK");
    map.put('\u04FB', "CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK");
    map.put('\u04FC', "CYRILLIC CAPITAL LETTER HA WITH HOOK");
    map.put('\u04FD', "CYRILLIC SMALL LETTER HA WITH HOOK");
    map.put('\u04FE', "CYRILLIC CAPITAL LETTER HA WITH STROKE");
    map.put('\u04FF', "CYRILLIC SMALL LETTER HA WITH STROKE");

  }

  public static final void cyrillicSupplement(Map<Character, String> map) {

    map.put('\u0500', "CYRILLIC CAPITAL LETTER KOMI DE");
    map.put('\u0501', "CYRILLIC SMALL LETTER KOMI DE");
    map.put('\u0502', "CYRILLIC CAPITAL LETTER KOMI DJE");
    map.put('\u0503', "CYRILLIC SMALL LETTER KOMI DJE");
    map.put('\u0504', "CYRILLIC CAPITAL LETTER KOMI ZJE");
    map.put('\u0505', "CYRILLIC SMALL LETTER KOMI ZJE");
    map.put('\u0506', "CYRILLIC CAPITAL LETTER KOMI DZJE");
    map.put('\u0507', "CYRILLIC SMALL LETTER KOMI DZJE");
    map.put('\u0508', "CYRILLIC CAPITAL LETTER KOMI LJE");
    map.put('\u0509', "CYRILLIC SMALL LETTER KOMI LJE");
    map.put('\u050A', "CYRILLIC CAPITAL LETTER KOMI NJE");
    map.put('\u050B', "CYRILLIC SMALL LETTER KOMI NJE");
    map.put('\u050C', "CYRILLIC CAPITAL LETTER KOMI SJE");
    map.put('\u050D', "CYRILLIC SMALL LETTER KOMI SJE");
    map.put('\u050E', "CYRILLIC CAPITAL LETTER KOMI TJE");
    map.put('\u050F', "CYRILLIC SMALL LETTER KOMI TJE");
    map.put('\u0510', "CYRILLIC CAPITAL LETTER REVERSED ZE");
    map.put('\u0511', "CYRILLIC SMALL LETTER REVERSED ZE");
    map.put('\u0512', "CYRILLIC CAPITAL LETTER EL WITH HOOK");
    map.put('\u0513', "CYRILLIC SMALL LETTER EL WITH HOOK");
    map.put('\u0514', "CYRILLIC CAPITAL LETTER LHA");
    map.put('\u0515', "CYRILLIC SMALL LETTER LHA");
    map.put('\u0516', "CYRILLIC CAPITAL LETTER RHA");
    map.put('\u0517', "CYRILLIC SMALL LETTER RHA");
    map.put('\u0518', "CYRILLIC CAPITAL LETTER YAE");
    map.put('\u0519', "CYRILLIC SMALL LETTER YAE");
    map.put('\u051A', "CYRILLIC CAPITAL LETTER QA");
    map.put('\u051B', "CYRILLIC SMALL LETTER QA");
    map.put('\u051C', "CYRILLIC CAPITAL LETTER WE");
    map.put('\u051D', "CYRILLIC SMALL LETTER WE");
    map.put('\u051E', "CYRILLIC CAPITAL LETTER ALEUT KA");
    map.put('\u051F', "CYRILLIC SMALL LETTER ALEUT KA");
    map.put('\u0520', "CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK");
    map.put('\u0521', "CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK");
    map.put('\u0522', "CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK");
    map.put('\u0523', "CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK");
    map.put('\u0524', "CYRILLIC CAPITAL LETTER PE WITH DESCENDER");
    map.put('\u0525', "CYRILLIC SMALL LETTER PE WITH DESCENDER");

  }

  public static final void armenian(Map<Character, String> map) {

    map.put('\u0531', "ARMENIAN CAPITAL LETTER AYB");
    map.put('\u0532', "ARMENIAN CAPITAL LETTER BEN");
    map.put('\u0533', "ARMENIAN CAPITAL LETTER GIM");
    map.put('\u0534', "ARMENIAN CAPITAL LETTER DA");
    map.put('\u0535', "ARMENIAN CAPITAL LETTER ECH");
    map.put('\u0536', "ARMENIAN CAPITAL LETTER ZA");
    map.put('\u0537', "ARMENIAN CAPITAL LETTER EH");
    map.put('\u0538', "ARMENIAN CAPITAL LETTER ET");
    map.put('\u0539', "ARMENIAN CAPITAL LETTER TO");
    map.put('\u053A', "ARMENIAN CAPITAL LETTER ZHE");
    map.put('\u053B', "ARMENIAN CAPITAL LETTER INI");
    map.put('\u053C', "ARMENIAN CAPITAL LETTER LIWN");
    map.put('\u053D', "ARMENIAN CAPITAL LETTER XEH");
    map.put('\u053E', "ARMENIAN CAPITAL LETTER CA");
    map.put('\u053F', "ARMENIAN CAPITAL LETTER KEN");
    map.put('\u0540', "ARMENIAN CAPITAL LETTER HO");
    map.put('\u0541', "ARMENIAN CAPITAL LETTER JA");
    map.put('\u0542', "ARMENIAN CAPITAL LETTER GHAD");
    map.put('\u0543', "ARMENIAN CAPITAL LETTER CHEH");
    map.put('\u0544', "ARMENIAN CAPITAL LETTER MEN");
    map.put('\u0545', "ARMENIAN CAPITAL LETTER YI");
    map.put('\u0546', "ARMENIAN CAPITAL LETTER NOW");
    map.put('\u0547', "ARMENIAN CAPITAL LETTER SHA");
    map.put('\u0548', "ARMENIAN CAPITAL LETTER VO");
    map.put('\u0549', "ARMENIAN CAPITAL LETTER CHA");
    map.put('\u054A', "ARMENIAN CAPITAL LETTER PEH");
    map.put('\u054B', "ARMENIAN CAPITAL LETTER JHEH");
    map.put('\u054C', "ARMENIAN CAPITAL LETTER RA");
    map.put('\u054D', "ARMENIAN CAPITAL LETTER SEH");
    map.put('\u054E', "ARMENIAN CAPITAL LETTER VEW");
    map.put('\u054F', "ARMENIAN CAPITAL LETTER TIWN");
    map.put('\u0550', "ARMENIAN CAPITAL LETTER REH");
    map.put('\u0551', "ARMENIAN CAPITAL LETTER CO");
    map.put('\u0552', "ARMENIAN CAPITAL LETTER YIWN");
    map.put('\u0553', "ARMENIAN CAPITAL LETTER PIWR");
    map.put('\u0554', "ARMENIAN CAPITAL LETTER KEH");
    map.put('\u0555', "ARMENIAN CAPITAL LETTER OH");
    map.put('\u0556', "ARMENIAN CAPITAL LETTER FEH");
    map.put('\u0559', "ARMENIAN MODIFIER LETTER LEFT HALF RING");
    map.put('\u055A', "ARMENIAN APOSTROPHE");
    map.put('\u055B', "ARMENIAN EMPHASIS MARK");
    map.put('\u055C', "ARMENIAN EXCLAMATION MARK");
    map.put('\u055D', "ARMENIAN COMMA");
    map.put('\u055E', "ARMENIAN QUESTION MARK");
    map.put('\u055F', "ARMENIAN ABBREVIATION MARK");
    map.put('\u0561', "ARMENIAN SMALL LETTER AYB");
    map.put('\u0562', "ARMENIAN SMALL LETTER BEN");
    map.put('\u0563', "ARMENIAN SMALL LETTER GIM");
    map.put('\u0564', "ARMENIAN SMALL LETTER DA");
    map.put('\u0565', "ARMENIAN SMALL LETTER ECH");
    map.put('\u0566', "ARMENIAN SMALL LETTER ZA");
    map.put('\u0567', "ARMENIAN SMALL LETTER EH");
    map.put('\u0568', "ARMENIAN SMALL LETTER ET");
    map.put('\u0569', "ARMENIAN SMALL LETTER TO");
    map.put('\u056A', "ARMENIAN SMALL LETTER ZHE");
    map.put('\u056B', "ARMENIAN SMALL LETTER INI");
    map.put('\u056C', "ARMENIAN SMALL LETTER LIWN");
    map.put('\u056D', "ARMENIAN SMALL LETTER XEH");
    map.put('\u056E', "ARMENIAN SMALL LETTER CA");
    map.put('\u056F', "ARMENIAN SMALL LETTER KEN");
    map.put('\u0570', "ARMENIAN SMALL LETTER HO");
    map.put('\u0571', "ARMENIAN SMALL LETTER JA");
    map.put('\u0572', "ARMENIAN SMALL LETTER GHAD");
    map.put('\u0573', "ARMENIAN SMALL LETTER CHEH");
    map.put('\u0574', "ARMENIAN SMALL LETTER MEN");
    map.put('\u0575', "ARMENIAN SMALL LETTER YI");
    map.put('\u0576', "ARMENIAN SMALL LETTER NOW");
    map.put('\u0577', "ARMENIAN SMALL LETTER SHA");
    map.put('\u0578', "ARMENIAN SMALL LETTER VO");
    map.put('\u0579', "ARMENIAN SMALL LETTER CHA");
    map.put('\u057A', "ARMENIAN SMALL LETTER PEH");
    map.put('\u057B', "ARMENIAN SMALL LETTER JHEH");
    map.put('\u057C', "ARMENIAN SMALL LETTER RA");
    map.put('\u057D', "ARMENIAN SMALL LETTER SEH");
    map.put('\u057E', "ARMENIAN SMALL LETTER VEW");
    map.put('\u057F', "ARMENIAN SMALL LETTER TIWN");
    map.put('\u0580', "ARMENIAN SMALL LETTER REH");
    map.put('\u0581', "ARMENIAN SMALL LETTER CO");
    map.put('\u0582', "ARMENIAN SMALL LETTER YIWN");
    map.put('\u0583', "ARMENIAN SMALL LETTER PIWR");
    map.put('\u0584', "ARMENIAN SMALL LETTER KEH");
    map.put('\u0585', "ARMENIAN SMALL LETTER OH");
    map.put('\u0586', "ARMENIAN SMALL LETTER FEH");
    map.put('\u0587', "ARMENIAN SMALL LIGATURE ECH YIWN");
    map.put('\u0589', "ARMENIAN FULL STOP");
    map.put('\u058A', "ARMENIAN HYPHEN");

  }

  public static final void hebrew(Map<Character, String> map) {

    map.put('\u0591', "HEBREW ACCENT ETNAHTA");
    map.put('\u0592', "HEBREW ACCENT SEGOL");
    map.put('\u0593', "HEBREW ACCENT SHALSHELET");
    map.put('\u0594', "HEBREW ACCENT ZAQEF QATAN");
    map.put('\u0595', "HEBREW ACCENT ZAQEF GADOL");
    map.put('\u0596', "HEBREW ACCENT TIPEHA");
    map.put('\u0597', "HEBREW ACCENT REVIA");
    map.put('\u0598', "HEBREW ACCENT ZARQA");
    map.put('\u0599', "HEBREW ACCENT PASHTA");
    map.put('\u059A', "HEBREW ACCENT YETIV");
    map.put('\u059B', "HEBREW ACCENT TEVIR");
    map.put('\u059C', "HEBREW ACCENT GERESH");
    map.put('\u059D', "HEBREW ACCENT GERESH MUQDAM");
    map.put('\u059E', "HEBREW ACCENT GERSHAYIM");
    map.put('\u059F', "HEBREW ACCENT QARNEY PARA");
    map.put('\u05A0', "HEBREW ACCENT TELISHA GEDOLA");
    map.put('\u05A1', "HEBREW ACCENT PAZER");
    map.put('\u05A2', "HEBREW ACCENT ATNAH HAFUKH");
    map.put('\u05A3', "HEBREW ACCENT MUNAH");
    map.put('\u05A4', "HEBREW ACCENT MAHAPAKH");
    map.put('\u05A5', "HEBREW ACCENT MERKHA");
    map.put('\u05A6', "HEBREW ACCENT MERKHA KEFULA");
    map.put('\u05A7', "HEBREW ACCENT DARGA");
    map.put('\u05A8', "HEBREW ACCENT QADMA");
    map.put('\u05A9', "HEBREW ACCENT TELISHA QETANA");
    map.put('\u05AA', "HEBREW ACCENT YERAH BEN YOMO");
    map.put('\u05AB', "HEBREW ACCENT OLE");
    map.put('\u05AC', "HEBREW ACCENT ILUY");
    map.put('\u05AD', "HEBREW ACCENT DEHI");
    map.put('\u05AE', "HEBREW ACCENT ZINOR");
    map.put('\u05AF', "HEBREW MARK MASORA CIRCLE");
    map.put('\u05B0', "HEBREW POINT SHEVA");
    map.put('\u05B1', "HEBREW POINT HATAF SEGOL");
    map.put('\u05B2', "HEBREW POINT HATAF PATAH");
    map.put('\u05B3', "HEBREW POINT HATAF QAMATS");
    map.put('\u05B4', "HEBREW POINT HIRIQ");
    map.put('\u05B5', "HEBREW POINT TSERE");
    map.put('\u05B6', "HEBREW POINT SEGOL");
    map.put('\u05B7', "HEBREW POINT PATAH");
    map.put('\u05B8', "HEBREW POINT QAMATS");
    map.put('\u05B9', "HEBREW POINT HOLAM");
    map.put('\u05BA', "HEBREW POINT HOLAM HASER FOR VAV");
    map.put('\u05BB', "HEBREW POINT QUBUTS");
    map.put('\u05BC', "HEBREW POINT DAGESH OR MAPIQ");
    map.put('\u05BD', "HEBREW POINT METEG");
    map.put('\u05BE', "HEBREW PUNCTUATION MAQAF");
    map.put('\u05BF', "HEBREW POINT RAFE");
    map.put('\u05C0', "HEBREW PUNCTUATION PASEQ");
    map.put('\u05C1', "HEBREW POINT SHIN DOT");
    map.put('\u05C2', "HEBREW POINT SIN DOT");
    map.put('\u05C3', "HEBREW PUNCTUATION SOF PASUQ");
    map.put('\u05C4', "HEBREW MARK UPPER DOT");
    map.put('\u05C5', "HEBREW MARK LOWER DOT");
    map.put('\u05C6', "HEBREW PUNCTUATION NUN HAFUKHA");
    map.put('\u05C7', "HEBREW POINT QAMATS QATAN");
    map.put('\u05D0', "HEBREW LETTER ALEF");
    map.put('\u05D1', "HEBREW LETTER BET");
    map.put('\u05D2', "HEBREW LETTER GIMEL");
    map.put('\u05D3', "HEBREW LETTER DALET");
    map.put('\u05D4', "HEBREW LETTER HE");
    map.put('\u05D5', "HEBREW LETTER VAV");
    map.put('\u05D6', "HEBREW LETTER ZAYIN");
    map.put('\u05D7', "HEBREW LETTER HET");
    map.put('\u05D8', "HEBREW LETTER TET");
    map.put('\u05D9', "HEBREW LETTER YOD");
    map.put('\u05DA', "HEBREW LETTER FINAL KAF");
    map.put('\u05DB', "HEBREW LETTER KAF");
    map.put('\u05DC', "HEBREW LETTER LAMED");
    map.put('\u05DD', "HEBREW LETTER FINAL MEM");
    map.put('\u05DE', "HEBREW LETTER MEM");
    map.put('\u05DF', "HEBREW LETTER FINAL NUN");
    map.put('\u05E0', "HEBREW LETTER NUN");
    map.put('\u05E1', "HEBREW LETTER SAMEKH");
    map.put('\u05E2', "HEBREW LETTER AYIN");
    map.put('\u05E3', "HEBREW LETTER FINAL PE");
    map.put('\u05E4', "HEBREW LETTER PE");
    map.put('\u05E5', "HEBREW LETTER FINAL TSADI");
    map.put('\u05E6', "HEBREW LETTER TSADI");
    map.put('\u05E7', "HEBREW LETTER QOF");
    map.put('\u05E8', "HEBREW LETTER RESH");
    map.put('\u05E9', "HEBREW LETTER SHIN");
    map.put('\u05EA', "HEBREW LETTER TAV");
    map.put('\u05F0', "HEBREW LIGATURE YIDDISH DOUBLE VAV");
    map.put('\u05F1', "HEBREW LIGATURE YIDDISH VAV YOD");
    map.put('\u05F2', "HEBREW LIGATURE YIDDISH DOUBLE YOD");
    map.put('\u05F3', "HEBREW PUNCTUATION GERESH");
    map.put('\u05F4', "HEBREW PUNCTUATION GERSHAYIM");

  }

  public static final void arabic(Map<Character, String> map) {

    map.put('\u0600', "ARABIC NUMBER SIGN");
    map.put('\u0601', "ARABIC SIGN SANAH");
    map.put('\u0602', "ARABIC FOOTNOTE MARKER");
    map.put('\u0603', "ARABIC SIGN SAFHA");
    map.put('\u0606', "ARABIC-INDIC CUBE ROOT");
    map.put('\u0607', "ARABIC-INDIC FOURTH ROOT");
    map.put('\u0608', "ARABIC RAY");
    map.put('\u0609', "ARABIC-INDIC PER MILLE SIGN");
    map.put('\u060A', "ARABIC-INDIC PER TEN THOUSAND SIGN");
    map.put('\u060B', "AFGHANI SIGN");
    map.put('\u060C', "ARABIC COMMA");
    map.put('\u060D', "ARABIC DATE SEPARATOR");
    map.put('\u060E', "ARABIC POETIC VERSE SIGN");
    map.put('\u060F', "ARABIC SIGN MISRA");
    map.put('\u0610', "ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM");
    map.put('\u0611', "ARABIC SIGN ALAYHE ASSALLAM");
    map.put('\u0612', "ARABIC SIGN RAHMATULLAH ALAYHE");
    map.put('\u0613', "ARABIC SIGN RADI ALLAHOU ANHU");
    map.put('\u0614', "ARABIC SIGN TAKHALLUS");
    map.put('\u0615', "ARABIC SMALL HIGH TAH");
    map.put('\u0616', "ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH");
    map.put('\u0617', "ARABIC SMALL HIGH ZAIN");
    map.put('\u0618', "ARABIC SMALL FATHA");
    map.put('\u0619', "ARABIC SMALL DAMMA");
    map.put('\u061A', "ARABIC SMALL KASRA");
    map.put('\u061B', "ARABIC SEMICOLON");
    map.put('\u061E', "ARABIC TRIPLE DOT PUNCTUATION MARK");
    map.put('\u061F', "ARABIC QUESTION MARK");
    map.put('\u0621', "ARABIC LETTER HAMZA");
    map.put('\u0622', "ARABIC LETTER ALEF WITH MADDA ABOVE");
    map.put('\u0623', "ARABIC LETTER ALEF WITH HAMZA ABOVE");
    map.put('\u0624', "ARABIC LETTER WAW WITH HAMZA ABOVE");
    map.put('\u0625', "ARABIC LETTER ALEF WITH HAMZA BELOW");
    map.put('\u0626', "ARABIC LETTER YEH WITH HAMZA ABOVE");
    map.put('\u0627', "ARABIC LETTER ALEF");
    map.put('\u0628', "ARABIC LETTER BEH");
    map.put('\u0629', "ARABIC LETTER TEH MARBUTA");
    map.put('\u062A', "ARABIC LETTER TEH");
    map.put('\u062B', "ARABIC LETTER THEH");
    map.put('\u062C', "ARABIC LETTER JEEM");
    map.put('\u062D', "ARABIC LETTER HAH");
    map.put('\u062E', "ARABIC LETTER KHAH");
    map.put('\u062F', "ARABIC LETTER DAL");
    map.put('\u0630', "ARABIC LETTER THAL");
    map.put('\u0631', "ARABIC LETTER REH");
    map.put('\u0632', "ARABIC LETTER ZAIN");
    map.put('\u0633', "ARABIC LETTER SEEN");
    map.put('\u0634', "ARABIC LETTER SHEEN");
    map.put('\u0635', "ARABIC LETTER SAD");
    map.put('\u0636', "ARABIC LETTER DAD");
    map.put('\u0637', "ARABIC LETTER TAH");
    map.put('\u0638', "ARABIC LETTER ZAH");
    map.put('\u0639', "ARABIC LETTER AIN");
    map.put('\u063A', "ARABIC LETTER GHAIN");
    map.put('\u063B', "ARABIC LETTER KEHEH WITH TWO DOTS ABOVE");
    map.put('\u063C', "ARABIC LETTER KEHEH WITH THREE DOTS BELOW");
    map.put('\u063D', "ARABIC LETTER FARSI YEH WITH INVERTED V");
    map.put('\u063E', "ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE");
    map.put('\u063F', "ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE");
    map.put('\u0640', "ARABIC TATWEEL");
    map.put('\u0641', "ARABIC LETTER FEH");
    map.put('\u0642', "ARABIC LETTER QAF");
    map.put('\u0643', "ARABIC LETTER KAF");
    map.put('\u0644', "ARABIC LETTER LAM");
    map.put('\u0645', "ARABIC LETTER MEEM");
    map.put('\u0646', "ARABIC LETTER NOON");
    map.put('\u0647', "ARABIC LETTER HEH");
    map.put('\u0648', "ARABIC LETTER WAW");
    map.put('\u0649', "ARABIC LETTER ALEF MAKSURA");
    map.put('\u064A', "ARABIC LETTER YEH");
    map.put('\u064B', "ARABIC FATHATAN");
    map.put('\u064C', "ARABIC DAMMATAN");
    map.put('\u064D', "ARABIC KASRATAN");
    map.put('\u064E', "ARABIC FATHA");
    map.put('\u064F', "ARABIC DAMMA");
    map.put('\u0650', "ARABIC KASRA");
    map.put('\u0651', "ARABIC SHADDA");
    map.put('\u0652', "ARABIC SUKUN");
    map.put('\u0653', "ARABIC MADDAH ABOVE");
    map.put('\u0654', "ARABIC HAMZA ABOVE");
    map.put('\u0655', "ARABIC HAMZA BELOW");
    map.put('\u0656', "ARABIC SUBSCRIPT ALEF");
    map.put('\u0657', "ARABIC INVERTED DAMMA");
    map.put('\u0658', "ARABIC MARK NOON GHUNNA");
    map.put('\u0659', "ARABIC ZWARAKAY");
    map.put('\u065A', "ARABIC VOWEL SIGN SMALL V ABOVE");
    map.put('\u065B', "ARABIC VOWEL SIGN INVERTED SMALL V ABOVE");
    map.put('\u065C', "ARABIC VOWEL SIGN DOT BELOW");
    map.put('\u065D', "ARABIC REVERSED DAMMA");
    map.put('\u065E', "ARABIC FATHA WITH TWO DOTS");
    map.put('\u0660', "ARABIC-INDIC DIGIT ZERO");
    map.put('\u0661', "ARABIC-INDIC DIGIT ONE");
    map.put('\u0662', "ARABIC-INDIC DIGIT TWO");
    map.put('\u0663', "ARABIC-INDIC DIGIT THREE");
    map.put('\u0664', "ARABIC-INDIC DIGIT FOUR");
    map.put('\u0665', "ARABIC-INDIC DIGIT FIVE");
    map.put('\u0666', "ARABIC-INDIC DIGIT SIX");
    map.put('\u0667', "ARABIC-INDIC DIGIT SEVEN");
    map.put('\u0668', "ARABIC-INDIC DIGIT EIGHT");
    map.put('\u0669', "ARABIC-INDIC DIGIT NINE");
    map.put('\u066A', "ARABIC PERCENT SIGN");
    map.put('\u066B', "ARABIC DECIMAL SEPARATOR");
    map.put('\u066C', "ARABIC THOUSANDS SEPARATOR");
    map.put('\u066D', "ARABIC FIVE POINTED STAR");
    map.put('\u066E', "ARABIC LETTER DOTLESS BEH");
    map.put('\u066F', "ARABIC LETTER DOTLESS QAF");
    map.put('\u0670', "ARABIC LETTER SUPERSCRIPT ALEF");
    map.put('\u0671', "ARABIC LETTER ALEF WASLA");
    map.put('\u0672', "ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE");
    map.put('\u0673', "ARABIC LETTER ALEF WITH WAVY HAMZA BELOW");
    map.put('\u0674', "ARABIC LETTER HIGH HAMZA");
    map.put('\u0675', "ARABIC LETTER HIGH HAMZA ALEF");
    map.put('\u0676', "ARABIC LETTER HIGH HAMZA WAW");
    map.put('\u0677', "ARABIC LETTER U WITH HAMZA ABOVE");
    map.put('\u0678', "ARABIC LETTER HIGH HAMZA YEH");
    map.put('\u0679', "ARABIC LETTER TTEH");
    map.put('\u067A', "ARABIC LETTER TTEHEH");
    map.put('\u067B', "ARABIC LETTER BEEH");
    map.put('\u067C', "ARABIC LETTER TEH WITH RING");
    map.put('\u067D', "ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS");
    map.put('\u067E', "ARABIC LETTER PEH");
    map.put('\u067F', "ARABIC LETTER TEHEH");
    map.put('\u0680', "ARABIC LETTER BEHEH");
    map.put('\u0681', "ARABIC LETTER HAH WITH HAMZA ABOVE");
    map.put('\u0682', "ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE");
    map.put('\u0683', "ARABIC LETTER NYEH");
    map.put('\u0684', "ARABIC LETTER DYEH");
    map.put('\u0685', "ARABIC LETTER HAH WITH THREE DOTS ABOVE");
    map.put('\u0686', "ARABIC LETTER TCHEH");
    map.put('\u0687', "ARABIC LETTER TCHEHEH");
    map.put('\u0688', "ARABIC LETTER DDAL");
    map.put('\u0689', "ARABIC LETTER DAL WITH RING");
    map.put('\u068A', "ARABIC LETTER DAL WITH DOT BELOW");
    map.put('\u068B', "ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH");
    map.put('\u068C', "ARABIC LETTER DAHAL");
    map.put('\u068D', "ARABIC LETTER DDAHAL");
    map.put('\u068E', "ARABIC LETTER DUL");
    map.put('\u068F', "ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS");
    map.put('\u0690', "ARABIC LETTER DAL WITH FOUR DOTS ABOVE");
    map.put('\u0691', "ARABIC LETTER RREH");
    map.put('\u0692', "ARABIC LETTER REH WITH SMALL V");
    map.put('\u0693', "ARABIC LETTER REH WITH RING");
    map.put('\u0694', "ARABIC LETTER REH WITH DOT BELOW");
    map.put('\u0695', "ARABIC LETTER REH WITH SMALL V BELOW");
    map.put('\u0696', "ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE");
    map.put('\u0697', "ARABIC LETTER REH WITH TWO DOTS ABOVE");
    map.put('\u0698', "ARABIC LETTER JEH");
    map.put('\u0699', "ARABIC LETTER REH WITH FOUR DOTS ABOVE");
    map.put('\u069A', "ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE");
    map.put('\u069B', "ARABIC LETTER SEEN WITH THREE DOTS BELOW");
    map.put('\u069C', "ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE");
    map.put('\u069D', "ARABIC LETTER SAD WITH TWO DOTS BELOW");
    map.put('\u069E', "ARABIC LETTER SAD WITH THREE DOTS ABOVE");
    map.put('\u069F', "ARABIC LETTER TAH WITH THREE DOTS ABOVE");
    map.put('\u06A0', "ARABIC LETTER AIN WITH THREE DOTS ABOVE");
    map.put('\u06A1', "ARABIC LETTER DOTLESS FEH");
    map.put('\u06A2', "ARABIC LETTER FEH WITH DOT MOVED BELOW");
    map.put('\u06A3', "ARABIC LETTER FEH WITH DOT BELOW");
    map.put('\u06A4', "ARABIC LETTER VEH");
    map.put('\u06A5', "ARABIC LETTER FEH WITH THREE DOTS BELOW");
    map.put('\u06A6', "ARABIC LETTER PEHEH");
    map.put('\u06A7', "ARABIC LETTER QAF WITH DOT ABOVE");
    map.put('\u06A8', "ARABIC LETTER QAF WITH THREE DOTS ABOVE");
    map.put('\u06A9', "ARABIC LETTER KEHEH");
    map.put('\u06AA', "ARABIC LETTER SWASH KAF");
    map.put('\u06AB', "ARABIC LETTER KAF WITH RING");
    map.put('\u06AC', "ARABIC LETTER KAF WITH DOT ABOVE");
    map.put('\u06AD', "ARABIC LETTER NG");
    map.put('\u06AE', "ARABIC LETTER KAF WITH THREE DOTS BELOW");
    map.put('\u06AF', "ARABIC LETTER GAF");
    map.put('\u06B0', "ARABIC LETTER GAF WITH RING");
    map.put('\u06B1', "ARABIC LETTER NGOEH");
    map.put('\u06B2', "ARABIC LETTER GAF WITH TWO DOTS BELOW");
    map.put('\u06B3', "ARABIC LETTER GUEH");
    map.put('\u06B4', "ARABIC LETTER GAF WITH THREE DOTS ABOVE");
    map.put('\u06B5', "ARABIC LETTER LAM WITH SMALL V");
    map.put('\u06B6', "ARABIC LETTER LAM WITH DOT ABOVE");
    map.put('\u06B7', "ARABIC LETTER LAM WITH THREE DOTS ABOVE");
    map.put('\u06B8', "ARABIC LETTER LAM WITH THREE DOTS BELOW");
    map.put('\u06B9', "ARABIC LETTER NOON WITH DOT BELOW");
    map.put('\u06BA', "ARABIC LETTER NOON GHUNNA");
    map.put('\u06BB', "ARABIC LETTER RNOON");
    map.put('\u06BC', "ARABIC LETTER NOON WITH RING");
    map.put('\u06BD', "ARABIC LETTER NOON WITH THREE DOTS ABOVE");
    map.put('\u06BE', "ARABIC LETTER HEH DOACHASHMEE");
    map.put('\u06BF', "ARABIC LETTER TCHEH WITH DOT ABOVE");
    map.put('\u06C0', "ARABIC LETTER HEH WITH YEH ABOVE");
    map.put('\u06C1', "ARABIC LETTER HEH GOAL");
    map.put('\u06C2', "ARABIC LETTER HEH GOAL WITH HAMZA ABOVE");
    map.put('\u06C3', "ARABIC LETTER TEH MARBUTA GOAL");
    map.put('\u06C4', "ARABIC LETTER WAW WITH RING");
    map.put('\u06C5', "ARABIC LETTER KIRGHIZ OE");
    map.put('\u06C6', "ARABIC LETTER OE");
    map.put('\u06C7', "ARABIC LETTER U");
    map.put('\u06C8', "ARABIC LETTER YU");
    map.put('\u06C9', "ARABIC LETTER KIRGHIZ YU");
    map.put('\u06CA', "ARABIC LETTER WAW WITH TWO DOTS ABOVE");
    map.put('\u06CB', "ARABIC LETTER VE");
    map.put('\u06CC', "ARABIC LETTER FARSI YEH");
    map.put('\u06CD', "ARABIC LETTER YEH WITH TAIL");
    map.put('\u06CE', "ARABIC LETTER YEH WITH SMALL V");
    map.put('\u06CF', "ARABIC LETTER WAW WITH DOT ABOVE");
    map.put('\u06D0', "ARABIC LETTER E");
    map.put('\u06D1', "ARABIC LETTER YEH WITH THREE DOTS BELOW");
    map.put('\u06D2', "ARABIC LETTER YEH BARREE");
    map.put('\u06D3', "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE");
    map.put('\u06D4', "ARABIC FULL STOP");
    map.put('\u06D5', "ARABIC LETTER AE");
    map.put('\u06D6', "ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA");
    map.put('\u06D7', "ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA");
    map.put('\u06D8', "ARABIC SMALL HIGH MEEM INITIAL FORM");
    map.put('\u06D9', "ARABIC SMALL HIGH LAM ALEF");
    map.put('\u06DA', "ARABIC SMALL HIGH JEEM");
    map.put('\u06DB', "ARABIC SMALL HIGH THREE DOTS");
    map.put('\u06DC', "ARABIC SMALL HIGH SEEN");
    map.put('\u06DD', "ARABIC END OF AYAH");
    map.put('\u06DE', "ARABIC START OF RUB EL HIZB");
    map.put('\u06DF', "ARABIC SMALL HIGH ROUNDED ZERO");
    map.put('\u06E0', "ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO");
    map.put('\u06E1', "ARABIC SMALL HIGH DOTLESS HEAD OF KHAH");
    map.put('\u06E2', "ARABIC SMALL HIGH MEEM ISOLATED FORM");
    map.put('\u06E3', "ARABIC SMALL LOW SEEN");
    map.put('\u06E4', "ARABIC SMALL HIGH MADDA");
    map.put('\u06E5', "ARABIC SMALL WAW");
    map.put('\u06E6', "ARABIC SMALL YEH");
    map.put('\u06E7', "ARABIC SMALL HIGH YEH");
    map.put('\u06E8', "ARABIC SMALL HIGH NOON");
    map.put('\u06E9', "ARABIC PLACE OF SAJDAH");
    map.put('\u06EA', "ARABIC EMPTY CENTRE LOW STOP");
    map.put('\u06EB', "ARABIC EMPTY CENTRE HIGH STOP");
    map.put('\u06EC', "ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE");
    map.put('\u06ED', "ARABIC SMALL LOW MEEM");
    map.put('\u06EE', "ARABIC LETTER DAL WITH INVERTED V");
    map.put('\u06EF', "ARABIC LETTER REH WITH INVERTED V");
    map.put('\u06F0', "EXTENDED ARABIC-INDIC DIGIT ZERO");
    map.put('\u06F1', "EXTENDED ARABIC-INDIC DIGIT ONE");
    map.put('\u06F2', "EXTENDED ARABIC-INDIC DIGIT TWO");
    map.put('\u06F3', "EXTENDED ARABIC-INDIC DIGIT THREE");
    map.put('\u06F4', "EXTENDED ARABIC-INDIC DIGIT FOUR");
    map.put('\u06F5', "EXTENDED ARABIC-INDIC DIGIT FIVE");
    map.put('\u06F6', "EXTENDED ARABIC-INDIC DIGIT SIX");
    map.put('\u06F7', "EXTENDED ARABIC-INDIC DIGIT SEVEN");
    map.put('\u06F8', "EXTENDED ARABIC-INDIC DIGIT EIGHT");
    map.put('\u06F9', "EXTENDED ARABIC-INDIC DIGIT NINE");
    map.put('\u06FA', "ARABIC LETTER SHEEN WITH DOT BELOW");
    map.put('\u06FB', "ARABIC LETTER DAD WITH DOT BELOW");
    map.put('\u06FC', "ARABIC LETTER GHAIN WITH DOT BELOW");
    map.put('\u06FD', "ARABIC SIGN SINDHI AMPERSAND");
    map.put('\u06FE', "ARABIC SIGN SINDHI POSTPOSITION MEN");
    map.put('\u06FF', "ARABIC LETTER HEH WITH INVERTED V");

  }

  public static final void syriac(Map<Character, String> map) {

    map.put('\u0700', "SYRIAC END OF PARAGRAPH");
    map.put('\u0701', "SYRIAC SUPRALINEAR FULL STOP");
    map.put('\u0702', "SYRIAC SUBLINEAR FULL STOP");
    map.put('\u0703', "SYRIAC SUPRALINEAR COLON");
    map.put('\u0704', "SYRIAC SUBLINEAR COLON");
    map.put('\u0705', "SYRIAC HORIZONTAL COLON");
    map.put('\u0706', "SYRIAC COLON SKEWED LEFT");
    map.put('\u0707', "SYRIAC COLON SKEWED RIGHT");
    map.put('\u0708', "SYRIAC SUPRALINEAR COLON SKEWED LEFT");
    map.put('\u0709', "SYRIAC SUBLINEAR COLON SKEWED RIGHT");
    map.put('\u070A', "SYRIAC CONTRACTION");
    map.put('\u070B', "SYRIAC HARKLEAN OBELUS");
    map.put('\u070C', "SYRIAC HARKLEAN METOBELUS");
    map.put('\u070D', "SYRIAC HARKLEAN ASTERISCUS");
    map.put('\u070F', "SYRIAC ABBREVIATION MARK");
    map.put('\u0710', "SYRIAC LETTER ALAPH");
    map.put('\u0711', "SYRIAC LETTER SUPERSCRIPT ALAPH");
    map.put('\u0712', "SYRIAC LETTER BETH");
    map.put('\u0713', "SYRIAC LETTER GAMAL");
    map.put('\u0714', "SYRIAC LETTER GAMAL GARSHUNI");
    map.put('\u0715', "SYRIAC LETTER DALATH");
    map.put('\u0716', "SYRIAC LETTER DOTLESS DALATH RISH");
    map.put('\u0717', "SYRIAC LETTER HE");
    map.put('\u0718', "SYRIAC LETTER WAW");
    map.put('\u0719', "SYRIAC LETTER ZAIN");
    map.put('\u071A', "SYRIAC LETTER HETH");
    map.put('\u071B', "SYRIAC LETTER TETH");
    map.put('\u071C', "SYRIAC LETTER TETH GARSHUNI");
    map.put('\u071D', "SYRIAC LETTER YUDH");
    map.put('\u071E', "SYRIAC LETTER YUDH HE");
    map.put('\u071F', "SYRIAC LETTER KAPH");
    map.put('\u0720', "SYRIAC LETTER LAMADH");
    map.put('\u0721', "SYRIAC LETTER MIM");
    map.put('\u0722', "SYRIAC LETTER NUN");
    map.put('\u0723', "SYRIAC LETTER SEMKATH");
    map.put('\u0724', "SYRIAC LETTER FINAL SEMKATH");
    map.put('\u0725', "SYRIAC LETTER E");
    map.put('\u0726', "SYRIAC LETTER PE");
    map.put('\u0727', "SYRIAC LETTER REVERSED PE");
    map.put('\u0728', "SYRIAC LETTER SADHE");
    map.put('\u0729', "SYRIAC LETTER QAPH");
    map.put('\u072A', "SYRIAC LETTER RISH");
    map.put('\u072B', "SYRIAC LETTER SHIN");
    map.put('\u072C', "SYRIAC LETTER TAW");
    map.put('\u072D', "SYRIAC LETTER PERSIAN BHETH");
    map.put('\u072E', "SYRIAC LETTER PERSIAN GHAMAL");
    map.put('\u072F', "SYRIAC LETTER PERSIAN DHALATH");
    map.put('\u0730', "SYRIAC PTHAHA ABOVE");
    map.put('\u0731', "SYRIAC PTHAHA BELOW");
    map.put('\u0732', "SYRIAC PTHAHA DOTTED");
    map.put('\u0733', "SYRIAC ZQAPHA ABOVE");
    map.put('\u0734', "SYRIAC ZQAPHA BELOW");
    map.put('\u0735', "SYRIAC ZQAPHA DOTTED");
    map.put('\u0736', "SYRIAC RBASA ABOVE");
    map.put('\u0737', "SYRIAC RBASA BELOW");
    map.put('\u0738', "SYRIAC DOTTED ZLAMA HORIZONTAL");
    map.put('\u0739', "SYRIAC DOTTED ZLAMA ANGULAR");
    map.put('\u073A', "SYRIAC HBASA ABOVE");
    map.put('\u073B', "SYRIAC HBASA BELOW");
    map.put('\u073C', "SYRIAC HBASA-ESASA DOTTED");
    map.put('\u073D', "SYRIAC ESASA ABOVE");
    map.put('\u073E', "SYRIAC ESASA BELOW");
    map.put('\u073F', "SYRIAC RWAHA");
    map.put('\u0740', "SYRIAC FEMININE DOT");
    map.put('\u0741', "SYRIAC QUSHSHAYA");
    map.put('\u0742', "SYRIAC RUKKAKHA");
    map.put('\u0743', "SYRIAC TWO VERTICAL DOTS ABOVE");
    map.put('\u0744', "SYRIAC TWO VERTICAL DOTS BELOW");
    map.put('\u0745', "SYRIAC THREE DOTS ABOVE");
    map.put('\u0746', "SYRIAC THREE DOTS BELOW");
    map.put('\u0747', "SYRIAC OBLIQUE LINE ABOVE");
    map.put('\u0748', "SYRIAC OBLIQUE LINE BELOW");
    map.put('\u0749', "SYRIAC MUSIC");
    map.put('\u074A', "SYRIAC BARREKH");
    map.put('\u074D', "SYRIAC LETTER SOGDIAN ZHAIN");
    map.put('\u074E', "SYRIAC LETTER SOGDIAN KHAPH");
    map.put('\u074F', "SYRIAC LETTER SOGDIAN FE");

  }

  public static final void arabicSupplement(Map<Character, String> map) {

    map.put('\u0750', "ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW");
    map.put('\u0751', "ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE");
    map.put('\u0752', "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW");
    map.put('\u0753', "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE");
    map.put('\u0754', "ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE");
    map.put('\u0755', "ARABIC LETTER BEH WITH INVERTED SMALL V BELOW");
    map.put('\u0756', "ARABIC LETTER BEH WITH SMALL V");
    map.put('\u0757', "ARABIC LETTER HAH WITH TWO DOTS ABOVE");
    map.put('\u0758', "ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW");
    map.put('\u0759', "ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH");
    map.put('\u075A', "ARABIC LETTER DAL WITH INVERTED SMALL V BELOW");
    map.put('\u075B', "ARABIC LETTER REH WITH STROKE");
    map.put('\u075C', "ARABIC LETTER SEEN WITH FOUR DOTS ABOVE");
    map.put('\u075D', "ARABIC LETTER AIN WITH TWO DOTS ABOVE");
    map.put('\u075E', "ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE");
    map.put('\u075F', "ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE");
    map.put('\u0760', "ARABIC LETTER FEH WITH TWO DOTS BELOW");
    map.put('\u0761', "ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW");
    map.put('\u0762', "ARABIC LETTER KEHEH WITH DOT ABOVE");
    map.put('\u0763', "ARABIC LETTER KEHEH WITH THREE DOTS ABOVE");
    map.put('\u0764', "ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW");
    map.put('\u0765', "ARABIC LETTER MEEM WITH DOT ABOVE");
    map.put('\u0766', "ARABIC LETTER MEEM WITH DOT BELOW");
    map.put('\u0767', "ARABIC LETTER NOON WITH TWO DOTS BELOW");
    map.put('\u0768', "ARABIC LETTER NOON WITH SMALL TAH");
    map.put('\u0769', "ARABIC LETTER NOON WITH SMALL V");
    map.put('\u076A', "ARABIC LETTER LAM WITH BAR");
    map.put('\u076B', "ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE");
    map.put('\u076C', "ARABIC LETTER REH WITH HAMZA ABOVE");
    map.put('\u076D', "ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE");
    map.put('\u076E', "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW");
    map.put('\u076F', "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS");
    map.put('\u0770', "ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS");
    map.put('\u0771', "ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS");
    map.put('\u0772', "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE");
    map.put('\u0773', "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE");
    map.put('\u0774', "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE");
    map.put('\u0775', "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE");
    map.put('\u0776', "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE");
    map.put('\u0777', "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW");
    map.put('\u0778', "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE");
    map.put('\u0779', "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE");
    map.put('\u077A', "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE");
    map.put('\u077B', "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE");
    map.put('\u077C', "ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW");
    map.put('\u077D', "ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE");
    map.put('\u077E', "ARABIC LETTER SEEN WITH INVERTED V");
    map.put('\u077F', "ARABIC LETTER KAF WITH TWO DOTS ABOVE");

  }

  public static final void thaana(Map<Character, String> map) {

    map.put('\u0780', "THAANA LETTER HAA");
    map.put('\u0781', "THAANA LETTER SHAVIYANI");
    map.put('\u0782', "THAANA LETTER NOONU");
    map.put('\u0783', "THAANA LETTER RAA");
    map.put('\u0784', "THAANA LETTER BAA");
    map.put('\u0785', "THAANA LETTER LHAVIYANI");
    map.put('\u0786', "THAANA LETTER KAAFU");
    map.put('\u0787', "THAANA LETTER ALIFU");
    map.put('\u0788', "THAANA LETTER VAAVU");
    map.put('\u0789', "THAANA LETTER MEEMU");
    map.put('\u078A', "THAANA LETTER FAAFU");
    map.put('\u078B', "THAANA LETTER DHAALU");
    map.put('\u078C', "THAANA LETTER THAA");
    map.put('\u078D', "THAANA LETTER LAAMU");
    map.put('\u078E', "THAANA LETTER GAAFU");
    map.put('\u078F', "THAANA LETTER GNAVIYANI");
    map.put('\u0790', "THAANA LETTER SEENU");
    map.put('\u0791', "THAANA LETTER DAVIYANI");
    map.put('\u0792', "THAANA LETTER ZAVIYANI");
    map.put('\u0793', "THAANA LETTER TAVIYANI");
    map.put('\u0794', "THAANA LETTER YAA");
    map.put('\u0795', "THAANA LETTER PAVIYANI");
    map.put('\u0796', "THAANA LETTER JAVIYANI");
    map.put('\u0797', "THAANA LETTER CHAVIYANI");
    map.put('\u0798', "THAANA LETTER TTAA");
    map.put('\u0799', "THAANA LETTER HHAA");
    map.put('\u079A', "THAANA LETTER KHAA");
    map.put('\u079B', "THAANA LETTER THAALU");
    map.put('\u079C', "THAANA LETTER ZAA");
    map.put('\u079D', "THAANA LETTER SHEENU");
    map.put('\u079E', "THAANA LETTER SAADHU");
    map.put('\u079F', "THAANA LETTER DAADHU");
    map.put('\u07A0', "THAANA LETTER TO");
    map.put('\u07A1', "THAANA LETTER ZO");
    map.put('\u07A2', "THAANA LETTER AINU");
    map.put('\u07A3', "THAANA LETTER GHAINU");
    map.put('\u07A4', "THAANA LETTER QAAFU");
    map.put('\u07A5', "THAANA LETTER WAAVU");
    map.put('\u07A6', "THAANA ABAFILI");
    map.put('\u07A7', "THAANA AABAAFILI");
    map.put('\u07A8', "THAANA IBIFILI");
    map.put('\u07A9', "THAANA EEBEEFILI");
    map.put('\u07AA', "THAANA UBUFILI");
    map.put('\u07AB', "THAANA OOBOOFILI");
    map.put('\u07AC', "THAANA EBEFILI");
    map.put('\u07AD', "THAANA EYBEYFILI");
    map.put('\u07AE', "THAANA OBOFILI");
    map.put('\u07AF', "THAANA OABOAFILI");
    map.put('\u07B0', "THAANA SUKUN");
    map.put('\u07B1', "THAANA LETTER NAA");

  }

  public static final void nko(Map<Character, String> map) {

    map.put('\u07C0', "NKO DIGIT ZERO");
    map.put('\u07C1', "NKO DIGIT ONE");
    map.put('\u07C2', "NKO DIGIT TWO");
    map.put('\u07C3', "NKO DIGIT THREE");
    map.put('\u07C4', "NKO DIGIT FOUR");
    map.put('\u07C5', "NKO DIGIT FIVE");
    map.put('\u07C6', "NKO DIGIT SIX");
    map.put('\u07C7', "NKO DIGIT SEVEN");
    map.put('\u07C8', "NKO DIGIT EIGHT");
    map.put('\u07C9', "NKO DIGIT NINE");
    map.put('\u07CA', "NKO LETTER A");
    map.put('\u07CB', "NKO LETTER EE");
    map.put('\u07CC', "NKO LETTER I");
    map.put('\u07CD', "NKO LETTER E");
    map.put('\u07CE', "NKO LETTER U");
    map.put('\u07CF', "NKO LETTER OO");
    map.put('\u07D0', "NKO LETTER O");
    map.put('\u07D1', "NKO LETTER DAGBASINNA");
    map.put('\u07D2', "NKO LETTER N");
    map.put('\u07D3', "NKO LETTER BA");
    map.put('\u07D4', "NKO LETTER PA");
    map.put('\u07D5', "NKO LETTER TA");
    map.put('\u07D6', "NKO LETTER JA");
    map.put('\u07D7', "NKO LETTER CHA");
    map.put('\u07D8', "NKO LETTER DA");
    map.put('\u07D9', "NKO LETTER RA");
    map.put('\u07DA', "NKO LETTER RRA");
    map.put('\u07DB', "NKO LETTER SA");
    map.put('\u07DC', "NKO LETTER GBA");
    map.put('\u07DD', "NKO LETTER FA");
    map.put('\u07DE', "NKO LETTER KA");
    map.put('\u07DF', "NKO LETTER LA");
    map.put('\u07E0', "NKO LETTER NA WOLOSO");
    map.put('\u07E1', "NKO LETTER MA");
    map.put('\u07E2', "NKO LETTER NYA");
    map.put('\u07E3', "NKO LETTER NA");
    map.put('\u07E4', "NKO LETTER HA");
    map.put('\u07E5', "NKO LETTER WA");
    map.put('\u07E6', "NKO LETTER YA");
    map.put('\u07E7', "NKO LETTER NYA WOLOSO");
    map.put('\u07E8', "NKO LETTER JONA JA");
    map.put('\u07E9', "NKO LETTER JONA CHA");
    map.put('\u07EA', "NKO LETTER JONA RA");
    map.put('\u07EB', "NKO COMBINING SHORT HIGH TONE");
    map.put('\u07EC', "NKO COMBINING SHORT LOW TONE");
    map.put('\u07ED', "NKO COMBINING SHORT RISING TONE");
    map.put('\u07EE', "NKO COMBINING LONG DESCENDING TONE");
    map.put('\u07EF', "NKO COMBINING LONG HIGH TONE");
    map.put('\u07F0', "NKO COMBINING LONG LOW TONE");
    map.put('\u07F1', "NKO COMBINING LONG RISING TONE");
    map.put('\u07F2', "NKO COMBINING NASALIZATION MARK");
    map.put('\u07F3', "NKO COMBINING DOUBLE DOT ABOVE");
    map.put('\u07F4', "NKO HIGH TONE APOSTROPHE");
    map.put('\u07F5', "NKO LOW TONE APOSTROPHE");
    map.put('\u07F6', "NKO SYMBOL OO DENNEN");
    map.put('\u07F7', "NKO SYMBOL GBAKURUNEN");
    map.put('\u07F8', "NKO COMMA");
    map.put('\u07F9', "NKO EXCLAMATION MARK");
    map.put('\u07FA', "NKO LAJANYALAN");

  }

  public static final void samaritan(Map<Character, String> map) {

    map.put('\u0800', "SAMARITAN LETTER ALAF");
    map.put('\u0801', "SAMARITAN LETTER BIT");
    map.put('\u0802', "SAMARITAN LETTER GAMAN");
    map.put('\u0803', "SAMARITAN LETTER DALAT");
    map.put('\u0804', "SAMARITAN LETTER IY");
    map.put('\u0805', "SAMARITAN LETTER BAA");
    map.put('\u0806', "SAMARITAN LETTER ZEN");
    map.put('\u0807', "SAMARITAN LETTER IT");
    map.put('\u0808', "SAMARITAN LETTER TIT");
    map.put('\u0809', "SAMARITAN LETTER YUT");
    map.put('\u080A', "SAMARITAN LETTER KAAF");
    map.put('\u080B', "SAMARITAN LETTER LABAT");
    map.put('\u080C', "SAMARITAN LETTER MIM");
    map.put('\u080D', "SAMARITAN LETTER NUN");
    map.put('\u080E', "SAMARITAN LETTER SINGAAT");
    map.put('\u080F', "SAMARITAN LETTER IN");
    map.put('\u0810', "SAMARITAN LETTER FI");
    map.put('\u0811', "SAMARITAN LETTER TSAADIY");
    map.put('\u0812', "SAMARITAN LETTER QUF");
    map.put('\u0813', "SAMARITAN LETTER RISH");
    map.put('\u0814', "SAMARITAN LETTER SHAN");
    map.put('\u0815', "SAMARITAN LETTER TAAF");
    map.put('\u0816', "SAMARITAN MARK IN");
    map.put('\u0817', "SAMARITAN MARK IN-ALAF");
    map.put('\u0818', "SAMARITAN MARK OCCLUSION");
    map.put('\u0819', "SAMARITAN MARK DAGESH");
    map.put('\u081A', "SAMARITAN MODIFIER LETTER EPENTHETIC YUT");
    map.put('\u081B', "SAMARITAN MARK EPENTHETIC YUT");
    map.put('\u081C', "SAMARITAN VOWEL SIGN LONG E");
    map.put('\u081D', "SAMARITAN VOWEL SIGN E");
    map.put('\u081E', "SAMARITAN VOWEL SIGN OVERLONG AA");
    map.put('\u081F', "SAMARITAN VOWEL SIGN LONG AA");
    map.put('\u0820', "SAMARITAN VOWEL SIGN AA");
    map.put('\u0821', "SAMARITAN VOWEL SIGN OVERLONG A");
    map.put('\u0822', "SAMARITAN VOWEL SIGN LONG A");
    map.put('\u0823', "SAMARITAN VOWEL SIGN A");
    map.put('\u0824', "SAMARITAN MODIFIER LETTER SHORT A");
    map.put('\u0825', "SAMARITAN VOWEL SIGN SHORT A");
    map.put('\u0826', "SAMARITAN VOWEL SIGN LONG U");
    map.put('\u0827', "SAMARITAN VOWEL SIGN U");
    map.put('\u0828', "SAMARITAN MODIFIER LETTER I");
    map.put('\u0829', "SAMARITAN VOWEL SIGN LONG I");
    map.put('\u082A', "SAMARITAN VOWEL SIGN I");
    map.put('\u082B', "SAMARITAN VOWEL SIGN O");
    map.put('\u082C', "SAMARITAN VOWEL SIGN SUKUN");
    map.put('\u082D', "SAMARITAN MARK NEQUDAA");
    map.put('\u0830', "SAMARITAN PUNCTUATION NEQUDAA");
    map.put('\u0831', "SAMARITAN PUNCTUATION AFSAAQ");
    map.put('\u0832', "SAMARITAN PUNCTUATION ANGED");
    map.put('\u0833', "SAMARITAN PUNCTUATION BAU");
    map.put('\u0834', "SAMARITAN PUNCTUATION ATMAAU");
    map.put('\u0835', "SAMARITAN PUNCTUATION SHIYYAALAA");
    map.put('\u0836', "SAMARITAN ABBREVIATION MARK");
    map.put('\u0837', "SAMARITAN PUNCTUATION MELODIC QITSA");
    map.put('\u0838', "SAMARITAN PUNCTUATION ZIQAA");
    map.put('\u0839', "SAMARITAN PUNCTUATION QITSA");
    map.put('\u083A', "SAMARITAN PUNCTUATION ZAEF");
    map.put('\u083B', "SAMARITAN PUNCTUATION TURU");
    map.put('\u083C', "SAMARITAN PUNCTUATION ARKAANU");
    map.put('\u083D', "SAMARITAN PUNCTUATION SOF MASHFAAT");
    map.put('\u083E', "SAMARITAN PUNCTUATION ANNAAU");

  }

  public static final void devanagari(Map<Character, String> map) {

    map.put('\u0900', "DEVANAGARI SIGN INVERTED CANDRABINDU");
    map.put('\u0901', "DEVANAGARI SIGN CANDRABINDU");
    map.put('\u0902', "DEVANAGARI SIGN ANUSVARA");
    map.put('\u0903', "DEVANAGARI SIGN VISARGA");
    map.put('\u0904', "DEVANAGARI LETTER SHORT A");
    map.put('\u0905', "DEVANAGARI LETTER A");
    map.put('\u0906', "DEVANAGARI LETTER AA");
    map.put('\u0907', "DEVANAGARI LETTER I");
    map.put('\u0908', "DEVANAGARI LETTER II");
    map.put('\u0909', "DEVANAGARI LETTER U");
    map.put('\u090A', "DEVANAGARI LETTER UU");
    map.put('\u090B', "DEVANAGARI LETTER VOCALIC R");
    map.put('\u090C', "DEVANAGARI LETTER VOCALIC L");
    map.put('\u090D', "DEVANAGARI LETTER CANDRA E");
    map.put('\u090E', "DEVANAGARI LETTER SHORT E");
    map.put('\u090F', "DEVANAGARI LETTER E");
    map.put('\u0910', "DEVANAGARI LETTER AI");
    map.put('\u0911', "DEVANAGARI LETTER CANDRA O");
    map.put('\u0912', "DEVANAGARI LETTER SHORT O");
    map.put('\u0913', "DEVANAGARI LETTER O");
    map.put('\u0914', "DEVANAGARI LETTER AU");
    map.put('\u0915', "DEVANAGARI LETTER KA");
    map.put('\u0916', "DEVANAGARI LETTER KHA");
    map.put('\u0917', "DEVANAGARI LETTER GA");
    map.put('\u0918', "DEVANAGARI LETTER GHA");
    map.put('\u0919', "DEVANAGARI LETTER NGA");
    map.put('\u091A', "DEVANAGARI LETTER CA");
    map.put('\u091B', "DEVANAGARI LETTER CHA");
    map.put('\u091C', "DEVANAGARI LETTER JA");
    map.put('\u091D', "DEVANAGARI LETTER JHA");
    map.put('\u091E', "DEVANAGARI LETTER NYA");
    map.put('\u091F', "DEVANAGARI LETTER TTA");
    map.put('\u0920', "DEVANAGARI LETTER TTHA");
    map.put('\u0921', "DEVANAGARI LETTER DDA");
    map.put('\u0922', "DEVANAGARI LETTER DDHA");
    map.put('\u0923', "DEVANAGARI LETTER NNA");
    map.put('\u0924', "DEVANAGARI LETTER TA");
    map.put('\u0925', "DEVANAGARI LETTER THA");
    map.put('\u0926', "DEVANAGARI LETTER DA");
    map.put('\u0927', "DEVANAGARI LETTER DHA");
    map.put('\u0928', "DEVANAGARI LETTER NA");
    map.put('\u0929', "DEVANAGARI LETTER NNNA");
    map.put('\u092A', "DEVANAGARI LETTER PA");
    map.put('\u092B', "DEVANAGARI LETTER PHA");
    map.put('\u092C', "DEVANAGARI LETTER BA");
    map.put('\u092D', "DEVANAGARI LETTER BHA");
    map.put('\u092E', "DEVANAGARI LETTER MA");
    map.put('\u092F', "DEVANAGARI LETTER YA");
    map.put('\u0930', "DEVANAGARI LETTER RA");
    map.put('\u0931', "DEVANAGARI LETTER RRA");
    map.put('\u0932', "DEVANAGARI LETTER LA");
    map.put('\u0933', "DEVANAGARI LETTER LLA");
    map.put('\u0934', "DEVANAGARI LETTER LLLA");
    map.put('\u0935', "DEVANAGARI LETTER VA");
    map.put('\u0936', "DEVANAGARI LETTER SHA");
    map.put('\u0937', "DEVANAGARI LETTER SSA");
    map.put('\u0938', "DEVANAGARI LETTER SA");
    map.put('\u0939', "DEVANAGARI LETTER HA");
    map.put('\u093C', "DEVANAGARI SIGN NUKTA");
    map.put('\u093D', "DEVANAGARI SIGN AVAGRAHA");
    map.put('\u093E', "DEVANAGARI VOWEL SIGN AA");
    map.put('\u093F', "DEVANAGARI VOWEL SIGN I");
    map.put('\u0940', "DEVANAGARI VOWEL SIGN II");
    map.put('\u0941', "DEVANAGARI VOWEL SIGN U");
    map.put('\u0942', "DEVANAGARI VOWEL SIGN UU");
    map.put('\u0943', "DEVANAGARI VOWEL SIGN VOCALIC R");
    map.put('\u0944', "DEVANAGARI VOWEL SIGN VOCALIC RR");
    map.put('\u0945', "DEVANAGARI VOWEL SIGN CANDRA E");
    map.put('\u0946', "DEVANAGARI VOWEL SIGN SHORT E");
    map.put('\u0947', "DEVANAGARI VOWEL SIGN E");
    map.put('\u0948', "DEVANAGARI VOWEL SIGN AI");
    map.put('\u0949', "DEVANAGARI VOWEL SIGN CANDRA O");
    map.put('\u094A', "DEVANAGARI VOWEL SIGN SHORT O");
    map.put('\u094B', "DEVANAGARI VOWEL SIGN O");
    map.put('\u094C', "DEVANAGARI VOWEL SIGN AU");
    map.put('\u094D', "DEVANAGARI SIGN VIRAMA");
    map.put('\u094E', "DEVANAGARI VOWEL SIGN PRISHTHAMATRA E");
    map.put('\u0950', "DEVANAGARI OM");
    map.put('\u0951', "DEVANAGARI STRESS SIGN UDATTA");
    map.put('\u0952', "DEVANAGARI STRESS SIGN ANUDATTA");
    map.put('\u0953', "DEVANAGARI GRAVE ACCENT");
    map.put('\u0954', "DEVANAGARI ACUTE ACCENT");
    map.put('\u0955', "DEVANAGARI VOWEL SIGN CANDRA LONG E");
    map.put('\u0958', "DEVANAGARI LETTER QA");
    map.put('\u0959', "DEVANAGARI LETTER KHHA");
    map.put('\u095A', "DEVANAGARI LETTER GHHA");
    map.put('\u095B', "DEVANAGARI LETTER ZA");
    map.put('\u095C', "DEVANAGARI LETTER DDDHA");
    map.put('\u095D', "DEVANAGARI LETTER RHA");
    map.put('\u095E', "DEVANAGARI LETTER FA");
    map.put('\u095F', "DEVANAGARI LETTER YYA");
    map.put('\u0960', "DEVANAGARI LETTER VOCALIC RR");
    map.put('\u0961', "DEVANAGARI LETTER VOCALIC LL");
    map.put('\u0962', "DEVANAGARI VOWEL SIGN VOCALIC L");
    map.put('\u0963', "DEVANAGARI VOWEL SIGN VOCALIC LL");
    map.put('\u0964', "DEVANAGARI DANDA");
    map.put('\u0965', "DEVANAGARI DOUBLE DANDA");
    map.put('\u0966', "DEVANAGARI DIGIT ZERO");
    map.put('\u0967', "DEVANAGARI DIGIT ONE");
    map.put('\u0968', "DEVANAGARI DIGIT TWO");
    map.put('\u0969', "DEVANAGARI DIGIT THREE");
    map.put('\u096A', "DEVANAGARI DIGIT FOUR");
    map.put('\u096B', "DEVANAGARI DIGIT FIVE");
    map.put('\u096C', "DEVANAGARI DIGIT SIX");
    map.put('\u096D', "DEVANAGARI DIGIT SEVEN");
    map.put('\u096E', "DEVANAGARI DIGIT EIGHT");
    map.put('\u096F', "DEVANAGARI DIGIT NINE");
    map.put('\u0970', "DEVANAGARI ABBREVIATION SIGN");
    map.put('\u0971', "DEVANAGARI SIGN HIGH SPACING DOT");
    map.put('\u0972', "DEVANAGARI LETTER CANDRA A");
    map.put('\u0979', "DEVANAGARI LETTER ZHA");
    map.put('\u097A', "DEVANAGARI LETTER HEAVY YA");
    map.put('\u097B', "DEVANAGARI LETTER GGA");
    map.put('\u097C', "DEVANAGARI LETTER JJA");
    map.put('\u097D', "DEVANAGARI LETTER GLOTTAL STOP");
    map.put('\u097E', "DEVANAGARI LETTER DDDA");
    map.put('\u097F', "DEVANAGARI LETTER BBA");

  }

  public static final void bengali(Map<Character, String> map) {

    map.put('\u0981', "BENGALI SIGN CANDRABINDU");
    map.put('\u0982', "BENGALI SIGN ANUSVARA");
    map.put('\u0983', "BENGALI SIGN VISARGA");
    map.put('\u0985', "BENGALI LETTER A");
    map.put('\u0986', "BENGALI LETTER AA");
    map.put('\u0987', "BENGALI LETTER I");
    map.put('\u0988', "BENGALI LETTER II");
    map.put('\u0989', "BENGALI LETTER U");
    map.put('\u098A', "BENGALI LETTER UU");
    map.put('\u098B', "BENGALI LETTER VOCALIC R");
    map.put('\u098C', "BENGALI LETTER VOCALIC L");
    map.put('\u098F', "BENGALI LETTER E");
    map.put('\u0990', "BENGALI LETTER AI");
    map.put('\u0993', "BENGALI LETTER O");
    map.put('\u0994', "BENGALI LETTER AU");
    map.put('\u0995', "BENGALI LETTER KA");
    map.put('\u0996', "BENGALI LETTER KHA");
    map.put('\u0997', "BENGALI LETTER GA");
    map.put('\u0998', "BENGALI LETTER GHA");
    map.put('\u0999', "BENGALI LETTER NGA");
    map.put('\u099A', "BENGALI LETTER CA");
    map.put('\u099B', "BENGALI LETTER CHA");
    map.put('\u099C', "BENGALI LETTER JA");
    map.put('\u099D', "BENGALI LETTER JHA");
    map.put('\u099E', "BENGALI LETTER NYA");
    map.put('\u099F', "BENGALI LETTER TTA");
    map.put('\u09A0', "BENGALI LETTER TTHA");
    map.put('\u09A1', "BENGALI LETTER DDA");
    map.put('\u09A2', "BENGALI LETTER DDHA");
    map.put('\u09A3', "BENGALI LETTER NNA");
    map.put('\u09A4', "BENGALI LETTER TA");
    map.put('\u09A5', "BENGALI LETTER THA");
    map.put('\u09A6', "BENGALI LETTER DA");
    map.put('\u09A7', "BENGALI LETTER DHA");
    map.put('\u09A8', "BENGALI LETTER NA");
    map.put('\u09AA', "BENGALI LETTER PA");
    map.put('\u09AB', "BENGALI LETTER PHA");
    map.put('\u09AC', "BENGALI LETTER BA");
    map.put('\u09AD', "BENGALI LETTER BHA");
    map.put('\u09AE', "BENGALI LETTER MA");
    map.put('\u09AF', "BENGALI LETTER YA");
    map.put('\u09B0', "BENGALI LETTER RA");
    map.put('\u09B2', "BENGALI LETTER LA");
    map.put('\u09B6', "BENGALI LETTER SHA");
    map.put('\u09B7', "BENGALI LETTER SSA");
    map.put('\u09B8', "BENGALI LETTER SA");
    map.put('\u09B9', "BENGALI LETTER HA");
    map.put('\u09BC', "BENGALI SIGN NUKTA");
    map.put('\u09BD', "BENGALI SIGN AVAGRAHA");
    map.put('\u09BE', "BENGALI VOWEL SIGN AA");
    map.put('\u09BF', "BENGALI VOWEL SIGN I");
    map.put('\u09C0', "BENGALI VOWEL SIGN II");
    map.put('\u09C1', "BENGALI VOWEL SIGN U");
    map.put('\u09C2', "BENGALI VOWEL SIGN UU");
    map.put('\u09C3', "BENGALI VOWEL SIGN VOCALIC R");
    map.put('\u09C4', "BENGALI VOWEL SIGN VOCALIC RR");
    map.put('\u09C7', "BENGALI VOWEL SIGN E");
    map.put('\u09C8', "BENGALI VOWEL SIGN AI");
    map.put('\u09CB', "BENGALI VOWEL SIGN O");
    map.put('\u09CC', "BENGALI VOWEL SIGN AU");
    map.put('\u09CD', "BENGALI SIGN VIRAMA");
    map.put('\u09CE', "BENGALI LETTER KHANDA TA");
    map.put('\u09D7', "BENGALI AU LENGTH MARK");
    map.put('\u09DC', "BENGALI LETTER RRA");
    map.put('\u09DD', "BENGALI LETTER RHA");
    map.put('\u09DF', "BENGALI LETTER YYA");
    map.put('\u09E0', "BENGALI LETTER VOCALIC RR");
    map.put('\u09E1', "BENGALI LETTER VOCALIC LL");
    map.put('\u09E2', "BENGALI VOWEL SIGN VOCALIC L");
    map.put('\u09E3', "BENGALI VOWEL SIGN VOCALIC LL");
    map.put('\u09E4', "<reserved>");
    map.put('\u09E5', "<reserved>");
    map.put('\u09E6', "BENGALI DIGIT ZERO");
    map.put('\u09E7', "BENGALI DIGIT ONE");
    map.put('\u09E8', "BENGALI DIGIT TWO");
    map.put('\u09E9', "BENGALI DIGIT THREE");
    map.put('\u09EA', "BENGALI DIGIT FOUR");
    map.put('\u09EB', "BENGALI DIGIT FIVE");
    map.put('\u09EC', "BENGALI DIGIT SIX");
    map.put('\u09ED', "BENGALI DIGIT SEVEN");
    map.put('\u09EE', "BENGALI DIGIT EIGHT");
    map.put('\u09EF', "BENGALI DIGIT NINE");
    map.put('\u09F0', "BENGALI LETTER RA WITH MIDDLE DIAGONAL");
    map.put('\u09F1', "BENGALI LETTER RA WITH LOWER DIAGONAL");
    map.put('\u09F2', "BENGALI RUPEE MARK");
    map.put('\u09F3', "BENGALI RUPEE SIGN");
    map.put('\u09F4', "BENGALI CURRENCY NUMERATOR ONE");
    map.put('\u09F5', "BENGALI CURRENCY NUMERATOR TWO");
    map.put('\u09F6', "BENGALI CURRENCY NUMERATOR THREE");
    map.put('\u09F7', "BENGALI CURRENCY NUMERATOR FOUR");
    map.put('\u09F8', "BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR");
    map.put('\u09F9', "BENGALI CURRENCY DENOMINATOR SIXTEEN");
    map.put('\u09FA', "BENGALI ISSHAR");
    map.put('\u09FB', "BENGALI GANDA MARK");

  }

  public static final void gurmukhi(Map<Character, String> map) {

    map.put('\u0A01', "GURMUKHI SIGN ADAK BINDI");
    map.put('\u0A02', "GURMUKHI SIGN BINDI");
    map.put('\u0A03', "GURMUKHI SIGN VISARGA");
    map.put('\u0A05', "GURMUKHI LETTER A");
    map.put('\u0A06', "GURMUKHI LETTER AA");
    map.put('\u0A07', "GURMUKHI LETTER I");
    map.put('\u0A08', "GURMUKHI LETTER II");
    map.put('\u0A09', "GURMUKHI LETTER U");
    map.put('\u0A0A', "GURMUKHI LETTER UU");
    map.put('\u0A0F', "GURMUKHI LETTER EE");
    map.put('\u0A10', "GURMUKHI LETTER AI");
    map.put('\u0A13', "GURMUKHI LETTER OO");
    map.put('\u0A14', "GURMUKHI LETTER AU");
    map.put('\u0A15', "GURMUKHI LETTER KA");
    map.put('\u0A16', "GURMUKHI LETTER KHA");
    map.put('\u0A17', "GURMUKHI LETTER GA");
    map.put('\u0A18', "GURMUKHI LETTER GHA");
    map.put('\u0A19', "GURMUKHI LETTER NGA");
    map.put('\u0A1A', "GURMUKHI LETTER CA");
    map.put('\u0A1B', "GURMUKHI LETTER CHA");
    map.put('\u0A1C', "GURMUKHI LETTER JA");
    map.put('\u0A1D', "GURMUKHI LETTER JHA");
    map.put('\u0A1E', "GURMUKHI LETTER NYA");
    map.put('\u0A1F', "GURMUKHI LETTER TTA");
    map.put('\u0A20', "GURMUKHI LETTER TTHA");
    map.put('\u0A21', "GURMUKHI LETTER DDA");
    map.put('\u0A22', "GURMUKHI LETTER DDHA");
    map.put('\u0A23', "GURMUKHI LETTER NNA");
    map.put('\u0A24', "GURMUKHI LETTER TA");
    map.put('\u0A25', "GURMUKHI LETTER THA");
    map.put('\u0A26', "GURMUKHI LETTER DA");
    map.put('\u0A27', "GURMUKHI LETTER DHA");
    map.put('\u0A28', "GURMUKHI LETTER NA");
    map.put('\u0A2A', "GURMUKHI LETTER PA");
    map.put('\u0A2B', "GURMUKHI LETTER PHA");
    map.put('\u0A2C', "GURMUKHI LETTER BA");
    map.put('\u0A2D', "GURMUKHI LETTER BHA");
    map.put('\u0A2E', "GURMUKHI LETTER MA");
    map.put('\u0A2F', "GURMUKHI LETTER YA");
    map.put('\u0A30', "GURMUKHI LETTER RA");
    map.put('\u0A32', "GURMUKHI LETTER LA");
    map.put('\u0A33', "GURMUKHI LETTER LLA");
    map.put('\u0A35', "GURMUKHI LETTER VA");
    map.put('\u0A36', "GURMUKHI LETTER SHA");
    map.put('\u0A38', "GURMUKHI LETTER SA");
    map.put('\u0A39', "GURMUKHI LETTER HA");
    map.put('\u0A3C', "GURMUKHI SIGN NUKTA");
    map.put('\u0A3E', "GURMUKHI VOWEL SIGN AA");
    map.put('\u0A3F', "GURMUKHI VOWEL SIGN I");
    map.put('\u0A40', "GURMUKHI VOWEL SIGN II");
    map.put('\u0A41', "GURMUKHI VOWEL SIGN U");
    map.put('\u0A42', "GURMUKHI VOWEL SIGN UU");
    map.put('\u0A47', "GURMUKHI VOWEL SIGN EE");
    map.put('\u0A48', "GURMUKHI VOWEL SIGN AI");
    map.put('\u0A4B', "GURMUKHI VOWEL SIGN OO");
    map.put('\u0A4C', "GURMUKHI VOWEL SIGN AU");
    map.put('\u0A4D', "GURMUKHI SIGN VIRAMA");
    map.put('\u0A51', "GURMUKHI SIGN UDAAT");
    map.put('\u0A59', "GURMUKHI LETTER KHHA");
    map.put('\u0A5A', "GURMUKHI LETTER GHHA");
    map.put('\u0A5B', "GURMUKHI LETTER ZA");
    map.put('\u0A5C', "GURMUKHI LETTER RRA");
    map.put('\u0A5E', "GURMUKHI LETTER FA");
    map.put('\u0A64', "<reserved>");
    map.put('\u0A65', "<reserved>");
    map.put('\u0A66', "GURMUKHI DIGIT ZERO");
    map.put('\u0A67', "GURMUKHI DIGIT ONE");
    map.put('\u0A68', "GURMUKHI DIGIT TWO");
    map.put('\u0A69', "GURMUKHI DIGIT THREE");
    map.put('\u0A6A', "GURMUKHI DIGIT FOUR");
    map.put('\u0A6B', "GURMUKHI DIGIT FIVE");
    map.put('\u0A6C', "GURMUKHI DIGIT SIX");
    map.put('\u0A6D', "GURMUKHI DIGIT SEVEN");
    map.put('\u0A6E', "GURMUKHI DIGIT EIGHT");
    map.put('\u0A6F', "GURMUKHI DIGIT NINE");
    map.put('\u0A70', "GURMUKHI TIPPI");
    map.put('\u0A71', "GURMUKHI ADDAK");
    map.put('\u0A72', "GURMUKHI IRI");
    map.put('\u0A73', "GURMUKHI URA");
    map.put('\u0A74', "GURMUKHI EK ONKAR");
    map.put('\u0A75', "GURMUKHI SIGN YAKASH");

  }

  public static final void gujarati(Map<Character, String> map) {

    map.put('\u0A81', "GUJARATI SIGN CANDRABINDU");
    map.put('\u0A82', "GUJARATI SIGN ANUSVARA");
    map.put('\u0A83', "GUJARATI SIGN VISARGA");
    map.put('\u0A85', "GUJARATI LETTER A");
    map.put('\u0A86', "GUJARATI LETTER AA");
    map.put('\u0A87', "GUJARATI LETTER I");
    map.put('\u0A88', "GUJARATI LETTER II");
    map.put('\u0A89', "GUJARATI LETTER U");
    map.put('\u0A8A', "GUJARATI LETTER UU");
    map.put('\u0A8B', "GUJARATI LETTER VOCALIC R");
    map.put('\u0A8C', "GUJARATI LETTER VOCALIC L");
    map.put('\u0A8D', "GUJARATI VOWEL CANDRA E");
    map.put('\u0A8F', "GUJARATI LETTER E");
    map.put('\u0A90', "GUJARATI LETTER AI");
    map.put('\u0A91', "GUJARATI VOWEL CANDRA O");
    map.put('\u0A93', "GUJARATI LETTER O");
    map.put('\u0A94', "GUJARATI LETTER AU");
    map.put('\u0A95', "GUJARATI LETTER KA");
    map.put('\u0A96', "GUJARATI LETTER KHA");
    map.put('\u0A97', "GUJARATI LETTER GA");
    map.put('\u0A98', "GUJARATI LETTER GHA");
    map.put('\u0A99', "GUJARATI LETTER NGA");
    map.put('\u0A9A', "GUJARATI LETTER CA");
    map.put('\u0A9B', "GUJARATI LETTER CHA");
    map.put('\u0A9C', "GUJARATI LETTER JA");
    map.put('\u0A9D', "GUJARATI LETTER JHA");
    map.put('\u0A9E', "GUJARATI LETTER NYA");
    map.put('\u0A9F', "GUJARATI LETTER TTA");
    map.put('\u0AA0', "GUJARATI LETTER TTHA");
    map.put('\u0AA1', "GUJARATI LETTER DDA");
    map.put('\u0AA2', "GUJARATI LETTER DDHA");
    map.put('\u0AA3', "GUJARATI LETTER NNA");
    map.put('\u0AA4', "GUJARATI LETTER TA");
    map.put('\u0AA5', "GUJARATI LETTER THA");
    map.put('\u0AA6', "GUJARATI LETTER DA");
    map.put('\u0AA7', "GUJARATI LETTER DHA");
    map.put('\u0AA8', "GUJARATI LETTER NA");
    map.put('\u0AAA', "GUJARATI LETTER PA");
    map.put('\u0AAB', "GUJARATI LETTER PHA");
    map.put('\u0AAC', "GUJARATI LETTER BA");
    map.put('\u0AAD', "GUJARATI LETTER BHA");
    map.put('\u0AAE', "GUJARATI LETTER MA");
    map.put('\u0AAF', "GUJARATI LETTER YA");
    map.put('\u0AB0', "GUJARATI LETTER RA");
    map.put('\u0AB2', "GUJARATI LETTER LA");
    map.put('\u0AB3', "GUJARATI LETTER LLA");
    map.put('\u0AB5', "GUJARATI LETTER VA");
    map.put('\u0AB6', "GUJARATI LETTER SHA");
    map.put('\u0AB7', "GUJARATI LETTER SSA");
    map.put('\u0AB8', "GUJARATI LETTER SA");
    map.put('\u0AB9', "GUJARATI LETTER HA");
    map.put('\u0ABC', "GUJARATI SIGN NUKTA");
    map.put('\u0ABD', "GUJARATI SIGN AVAGRAHA");
    map.put('\u0ABE', "GUJARATI VOWEL SIGN AA");
    map.put('\u0ABF', "GUJARATI VOWEL SIGN I");
    map.put('\u0AC0', "GUJARATI VOWEL SIGN II");
    map.put('\u0AC1', "GUJARATI VOWEL SIGN U");
    map.put('\u0AC2', "GUJARATI VOWEL SIGN UU");
    map.put('\u0AC3', "GUJARATI VOWEL SIGN VOCALIC R");
    map.put('\u0AC4', "GUJARATI VOWEL SIGN VOCALIC RR");
    map.put('\u0AC5', "GUJARATI VOWEL SIGN CANDRA E");
    map.put('\u0AC7', "GUJARATI VOWEL SIGN E");
    map.put('\u0AC8', "GUJARATI VOWEL SIGN AI");
    map.put('\u0AC9', "GUJARATI VOWEL SIGN CANDRA O");
    map.put('\u0ACB', "GUJARATI VOWEL SIGN O");
    map.put('\u0ACC', "GUJARATI VOWEL SIGN AU");
    map.put('\u0ACD', "GUJARATI SIGN VIRAMA");
    map.put('\u0AD0', "GUJARATI OM");
    map.put('\u0AE0', "GUJARATI LETTER VOCALIC RR");
    map.put('\u0AE1', "GUJARATI LETTER VOCALIC LL");
    map.put('\u0AE2', "GUJARATI VOWEL SIGN VOCALIC L");
    map.put('\u0AE3', "GUJARATI VOWEL SIGN VOCALIC LL");
    map.put('\u0AE4', "<reserved>");
    map.put('\u0AE5', "<reserved>");
    map.put('\u0AE6', "GUJARATI DIGIT ZERO");
    map.put('\u0AE7', "GUJARATI DIGIT ONE");
    map.put('\u0AE8', "GUJARATI DIGIT TWO");
    map.put('\u0AE9', "GUJARATI DIGIT THREE");
    map.put('\u0AEA', "GUJARATI DIGIT FOUR");
    map.put('\u0AEB', "GUJARATI DIGIT FIVE");
    map.put('\u0AEC', "GUJARATI DIGIT SIX");
    map.put('\u0AED', "GUJARATI DIGIT SEVEN");
    map.put('\u0AEE', "GUJARATI DIGIT EIGHT");
    map.put('\u0AEF', "GUJARATI DIGIT NINE");
    map.put('\u0AF1', "GUJARATI RUPEE SIGN");

  }

  public static final void oriya(Map<Character, String> map) {

    map.put('\u0B01', "ORIYA SIGN CANDRABINDU");
    map.put('\u0B02', "ORIYA SIGN ANUSVARA");
    map.put('\u0B03', "ORIYA SIGN VISARGA");
    map.put('\u0B05', "ORIYA LETTER A");
    map.put('\u0B06', "ORIYA LETTER AA");
    map.put('\u0B07', "ORIYA LETTER I");
    map.put('\u0B08', "ORIYA LETTER II");
    map.put('\u0B09', "ORIYA LETTER U");
    map.put('\u0B0A', "ORIYA LETTER UU");
    map.put('\u0B0B', "ORIYA LETTER VOCALIC R");
    map.put('\u0B0C', "ORIYA LETTER VOCALIC L");
    map.put('\u0B0F', "ORIYA LETTER E");
    map.put('\u0B10', "ORIYA LETTER AI");
    map.put('\u0B13', "ORIYA LETTER O");
    map.put('\u0B14', "ORIYA LETTER AU");
    map.put('\u0B15', "ORIYA LETTER KA");
    map.put('\u0B16', "ORIYA LETTER KHA");
    map.put('\u0B17', "ORIYA LETTER GA");
    map.put('\u0B18', "ORIYA LETTER GHA");
    map.put('\u0B19', "ORIYA LETTER NGA");
    map.put('\u0B1A', "ORIYA LETTER CA");
    map.put('\u0B1B', "ORIYA LETTER CHA");
    map.put('\u0B1C', "ORIYA LETTER JA");
    map.put('\u0B1D', "ORIYA LETTER JHA");
    map.put('\u0B1E', "ORIYA LETTER NYA");
    map.put('\u0B1F', "ORIYA LETTER TTA");
    map.put('\u0B20', "ORIYA LETTER TTHA");
    map.put('\u0B21', "ORIYA LETTER DDA");
    map.put('\u0B22', "ORIYA LETTER DDHA");
    map.put('\u0B23', "ORIYA LETTER NNA");
    map.put('\u0B24', "ORIYA LETTER TA");
    map.put('\u0B25', "ORIYA LETTER THA");
    map.put('\u0B26', "ORIYA LETTER DA");
    map.put('\u0B27', "ORIYA LETTER DHA");
    map.put('\u0B28', "ORIYA LETTER NA");
    map.put('\u0B2A', "ORIYA LETTER PA");
    map.put('\u0B2B', "ORIYA LETTER PHA");
    map.put('\u0B2C', "ORIYA LETTER BA");
    map.put('\u0B2D', "ORIYA LETTER BHA");
    map.put('\u0B2E', "ORIYA LETTER MA");
    map.put('\u0B2F', "ORIYA LETTER YA");
    map.put('\u0B30', "ORIYA LETTER RA");
    map.put('\u0B32', "ORIYA LETTER LA");
    map.put('\u0B33', "ORIYA LETTER LLA");
    map.put('\u0B35', "ORIYA LETTER VA");
    map.put('\u0B36', "ORIYA LETTER SHA");
    map.put('\u0B37', "ORIYA LETTER SSA");
    map.put('\u0B38', "ORIYA LETTER SA");
    map.put('\u0B39', "ORIYA LETTER HA");
    map.put('\u0B3C', "ORIYA SIGN NUKTA");
    map.put('\u0B3D', "ORIYA SIGN AVAGRAHA");
    map.put('\u0B3E', "ORIYA VOWEL SIGN AA");
    map.put('\u0B3F', "ORIYA VOWEL SIGN I");
    map.put('\u0B40', "ORIYA VOWEL SIGN II");
    map.put('\u0B41', "ORIYA VOWEL SIGN U");
    map.put('\u0B42', "ORIYA VOWEL SIGN UU");
    map.put('\u0B43', "ORIYA VOWEL SIGN VOCALIC R");
    map.put('\u0B44', "ORIYA VOWEL SIGN VOCALIC RR");
    map.put('\u0B47', "ORIYA VOWEL SIGN E");
    map.put('\u0B48', "ORIYA VOWEL SIGN AI");
    map.put('\u0B4B', "ORIYA VOWEL SIGN O");
    map.put('\u0B4C', "ORIYA VOWEL SIGN AU");
    map.put('\u0B4D', "ORIYA SIGN VIRAMA");
    map.put('\u0B56', "ORIYA AI LENGTH MARK");
    map.put('\u0B57', "ORIYA AU LENGTH MARK");
    map.put('\u0B5C', "ORIYA LETTER RRA");
    map.put('\u0B5D', "ORIYA LETTER RHA");
    map.put('\u0B5F', "ORIYA LETTER YYA");
    map.put('\u0B60', "ORIYA LETTER VOCALIC RR");
    map.put('\u0B61', "ORIYA LETTER VOCALIC LL");
    map.put('\u0B62', "ORIYA VOWEL SIGN VOCALIC L");
    map.put('\u0B63', "ORIYA VOWEL SIGN VOCALIC LL");
    map.put('\u0B64', "<reserved>");
    map.put('\u0B65', "<reserved>");
    map.put('\u0B66', "ORIYA DIGIT ZERO");
    map.put('\u0B67', "ORIYA DIGIT ONE");
    map.put('\u0B68', "ORIYA DIGIT TWO");
    map.put('\u0B69', "ORIYA DIGIT THREE");
    map.put('\u0B6A', "ORIYA DIGIT FOUR");
    map.put('\u0B6B', "ORIYA DIGIT FIVE");
    map.put('\u0B6C', "ORIYA DIGIT SIX");
    map.put('\u0B6D', "ORIYA DIGIT SEVEN");
    map.put('\u0B6E', "ORIYA DIGIT EIGHT");
    map.put('\u0B6F', "ORIYA DIGIT NINE");
    map.put('\u0B70', "ORIYA ISSHAR");
    map.put('\u0B71', "ORIYA LETTER WA");

  }

  public static final void tamil(Map<Character, String> map) {

    map.put('\u0B82', "TAMIL SIGN ANUSVARA");
    map.put('\u0B83', "TAMIL SIGN VISARGA");
    map.put('\u0B85', "TAMIL LETTER A");
    map.put('\u0B86', "TAMIL LETTER AA");
    map.put('\u0B87', "TAMIL LETTER I");
    map.put('\u0B88', "TAMIL LETTER II");
    map.put('\u0B89', "TAMIL LETTER U");
    map.put('\u0B8A', "TAMIL LETTER UU");
    map.put('\u0B8E', "TAMIL LETTER E");
    map.put('\u0B8F', "TAMIL LETTER EE");
    map.put('\u0B90', "TAMIL LETTER AI");
    map.put('\u0B92', "TAMIL LETTER O");
    map.put('\u0B93', "TAMIL LETTER OO");
    map.put('\u0B94', "TAMIL LETTER AU");
    map.put('\u0B95', "TAMIL LETTER KA");
    map.put('\u0B99', "TAMIL LETTER NGA");
    map.put('\u0B9A', "TAMIL LETTER CA");
    map.put('\u0B9C', "TAMIL LETTER JA");
    map.put('\u0B9E', "TAMIL LETTER NYA");
    map.put('\u0B9F', "TAMIL LETTER TTA");
    map.put('\u0BA3', "TAMIL LETTER NNA");
    map.put('\u0BA4', "TAMIL LETTER TA");
    map.put('\u0BA8', "TAMIL LETTER NA");
    map.put('\u0BA9', "TAMIL LETTER NNNA");
    map.put('\u0BAA', "TAMIL LETTER PA");
    map.put('\u0BAE', "TAMIL LETTER MA");
    map.put('\u0BAF', "TAMIL LETTER YA");
    map.put('\u0BB0', "TAMIL LETTER RA");
    map.put('\u0BB1', "TAMIL LETTER RRA");
    map.put('\u0BB2', "TAMIL LETTER LA");
    map.put('\u0BB3', "TAMIL LETTER LLA");
    map.put('\u0BB4', "TAMIL LETTER LLLA");
    map.put('\u0BB5', "TAMIL LETTER VA");
    map.put('\u0BB6', "TAMIL LETTER SHA");
    map.put('\u0BB7', "TAMIL LETTER SSA");
    map.put('\u0BB8', "TAMIL LETTER SA");
    map.put('\u0BB9', "TAMIL LETTER HA");
    map.put('\u0BBE', "TAMIL VOWEL SIGN AA");
    map.put('\u0BBF', "TAMIL VOWEL SIGN I");
    map.put('\u0BC0', "TAMIL VOWEL SIGN II");
    map.put('\u0BC1', "TAMIL VOWEL SIGN U");
    map.put('\u0BC2', "TAMIL VOWEL SIGN UU");
    map.put('\u0BC6', "TAMIL VOWEL SIGN E");
    map.put('\u0BC7', "TAMIL VOWEL SIGN EE");
    map.put('\u0BC8', "TAMIL VOWEL SIGN AI");
    map.put('\u0BCA', "TAMIL VOWEL SIGN O");
    map.put('\u0BCB', "TAMIL VOWEL SIGN OO");
    map.put('\u0BCC', "TAMIL VOWEL SIGN AU");
    map.put('\u0BCD', "TAMIL SIGN VIRAMA");
    map.put('\u0BD0', "TAMIL OM");
    map.put('\u0BD7', "TAMIL AU LENGTH MARK");
    map.put('\u0BE4', "<reserved>");
    map.put('\u0BE5', "<reserved>");
    map.put('\u0BE6', "TAMIL DIGIT ZERO");
    map.put('\u0BE7', "TAMIL DIGIT ONE");
    map.put('\u0BE8', "TAMIL DIGIT TWO");
    map.put('\u0BE9', "TAMIL DIGIT THREE");
    map.put('\u0BEA', "TAMIL DIGIT FOUR");
    map.put('\u0BEB', "TAMIL DIGIT FIVE");
    map.put('\u0BEC', "TAMIL DIGIT SIX");
    map.put('\u0BED', "TAMIL DIGIT SEVEN");
    map.put('\u0BEE', "TAMIL DIGIT EIGHT");
    map.put('\u0BEF', "TAMIL DIGIT NINE");
    map.put('\u0BF0', "TAMIL NUMBER TEN");
    map.put('\u0BF1', "TAMIL NUMBER ONE HUNDRED");
    map.put('\u0BF2', "TAMIL NUMBER ONE THOUSAND");
    map.put('\u0BF3', "TAMIL DAY SIGN");
    map.put('\u0BF4', "TAMIL MONTH SIGN");
    map.put('\u0BF5', "TAMIL YEAR SIGN");
    map.put('\u0BF6', "TAMIL DEBIT SIGN");
    map.put('\u0BF7', "TAMIL CREDIT SIGN");
    map.put('\u0BF8', "TAMIL AS ABOVE SIGN");
    map.put('\u0BF9', "TAMIL RUPEE SIGN");
    map.put('\u0BFA', "TAMIL NUMBER SIGN");

  }

  public static final void telugu(Map<Character, String> map) {

    map.put('\u0C01', "TELUGU SIGN CANDRABINDU");
    map.put('\u0C02', "TELUGU SIGN ANUSVARA");
    map.put('\u0C03', "TELUGU SIGN VISARGA");
    map.put('\u0C05', "TELUGU LETTER A");
    map.put('\u0C06', "TELUGU LETTER AA");
    map.put('\u0C07', "TELUGU LETTER I");
    map.put('\u0C08', "TELUGU LETTER II");
    map.put('\u0C09', "TELUGU LETTER U");
    map.put('\u0C0A', "TELUGU LETTER UU");
    map.put('\u0C0B', "TELUGU LETTER VOCALIC R");
    map.put('\u0C0C', "TELUGU LETTER VOCALIC L");
    map.put('\u0C0E', "TELUGU LETTER E");
    map.put('\u0C0F', "TELUGU LETTER EE");
    map.put('\u0C10', "TELUGU LETTER AI");
    map.put('\u0C12', "TELUGU LETTER O");
    map.put('\u0C13', "TELUGU LETTER OO");
    map.put('\u0C14', "TELUGU LETTER AU");
    map.put('\u0C15', "TELUGU LETTER KA");
    map.put('\u0C16', "TELUGU LETTER KHA");
    map.put('\u0C17', "TELUGU LETTER GA");
    map.put('\u0C18', "TELUGU LETTER GHA");
    map.put('\u0C19', "TELUGU LETTER NGA");
    map.put('\u0C1A', "TELUGU LETTER CA");
    map.put('\u0C1B', "TELUGU LETTER CHA");
    map.put('\u0C1C', "TELUGU LETTER JA");
    map.put('\u0C1D', "TELUGU LETTER JHA");
    map.put('\u0C1E', "TELUGU LETTER NYA");
    map.put('\u0C1F', "TELUGU LETTER TTA");
    map.put('\u0C20', "TELUGU LETTER TTHA");
    map.put('\u0C21', "TELUGU LETTER DDA");
    map.put('\u0C22', "TELUGU LETTER DDHA");
    map.put('\u0C23', "TELUGU LETTER NNA");
    map.put('\u0C24', "TELUGU LETTER TA");
    map.put('\u0C25', "TELUGU LETTER THA");
    map.put('\u0C26', "TELUGU LETTER DA");
    map.put('\u0C27', "TELUGU LETTER DHA");
    map.put('\u0C28', "TELUGU LETTER NA");
    map.put('\u0C2A', "TELUGU LETTER PA");
    map.put('\u0C2B', "TELUGU LETTER PHA");
    map.put('\u0C2C', "TELUGU LETTER BA");
    map.put('\u0C2D', "TELUGU LETTER BHA");
    map.put('\u0C2E', "TELUGU LETTER MA");
    map.put('\u0C2F', "TELUGU LETTER YA");
    map.put('\u0C30', "TELUGU LETTER RA");
    map.put('\u0C31', "TELUGU LETTER RRA");
    map.put('\u0C32', "TELUGU LETTER LA");
    map.put('\u0C33', "TELUGU LETTER LLA");
    map.put('\u0C35', "TELUGU LETTER VA");
    map.put('\u0C36', "TELUGU LETTER SHA");
    map.put('\u0C37', "TELUGU LETTER SSA");
    map.put('\u0C38', "TELUGU LETTER SA");
    map.put('\u0C39', "TELUGU LETTER HA");
    map.put('\u0C3D', "TELUGU SIGN AVAGRAHA");
    map.put('\u0C3E', "TELUGU VOWEL SIGN AA");
    map.put('\u0C3F', "TELUGU VOWEL SIGN I");
    map.put('\u0C40', "TELUGU VOWEL SIGN II");
    map.put('\u0C41', "TELUGU VOWEL SIGN U");
    map.put('\u0C42', "TELUGU VOWEL SIGN UU");
    map.put('\u0C43', "TELUGU VOWEL SIGN VOCALIC R");
    map.put('\u0C44', "TELUGU VOWEL SIGN VOCALIC RR");
    map.put('\u0C46', "TELUGU VOWEL SIGN E");
    map.put('\u0C47', "TELUGU VOWEL SIGN EE");
    map.put('\u0C48', "TELUGU VOWEL SIGN AI");
    map.put('\u0C4A', "TELUGU VOWEL SIGN O");
    map.put('\u0C4B', "TELUGU VOWEL SIGN OO");
    map.put('\u0C4C', "TELUGU VOWEL SIGN AU");
    map.put('\u0C4D', "TELUGU SIGN VIRAMA");
    map.put('\u0C55', "TELUGU LENGTH MARK");
    map.put('\u0C56', "TELUGU AI LENGTH MARK");
    map.put('\u0C58', "TELUGU LETTER TSA");
    map.put('\u0C59', "TELUGU LETTER DZA");
    map.put('\u0C60', "TELUGU LETTER VOCALIC RR");
    map.put('\u0C61', "TELUGU LETTER VOCALIC LL");
    map.put('\u0C62', "TELUGU VOWEL SIGN VOCALIC L");
    map.put('\u0C63', "TELUGU VOWEL SIGN VOCALIC LL");
    map.put('\u0C64', "<reserved>");
    map.put('\u0C65', "<reserved>");
    map.put('\u0C66', "TELUGU DIGIT ZERO");
    map.put('\u0C67', "TELUGU DIGIT ONE");
    map.put('\u0C68', "TELUGU DIGIT TWO");
    map.put('\u0C69', "TELUGU DIGIT THREE");
    map.put('\u0C6A', "TELUGU DIGIT FOUR");
    map.put('\u0C6B', "TELUGU DIGIT FIVE");
    map.put('\u0C6C', "TELUGU DIGIT SIX");
    map.put('\u0C6D', "TELUGU DIGIT SEVEN");
    map.put('\u0C6E', "TELUGU DIGIT EIGHT");
    map.put('\u0C6F', "TELUGU DIGIT NINE");
    map.put('\u0C78', "TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR");
    map.put('\u0C79', "TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR");
    map.put('\u0C7A', "TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR");
    map.put('\u0C7B', "TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR");
    map.put('\u0C7C', "TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR");
    map.put('\u0C7D', "TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR");
    map.put('\u0C7E', "TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR");
    map.put('\u0C7F', "TELUGU SIGN TUUMU");

  }

  public static final void kannada(Map<Character, String> map) {

    map.put('\u0C82', "KANNADA SIGN ANUSVARA");
    map.put('\u0C83', "KANNADA SIGN VISARGA");
    map.put('\u0C85', "KANNADA LETTER A");
    map.put('\u0C86', "KANNADA LETTER AA");
    map.put('\u0C87', "KANNADA LETTER I");
    map.put('\u0C88', "KANNADA LETTER II");
    map.put('\u0C89', "KANNADA LETTER U");
    map.put('\u0C8A', "KANNADA LETTER UU");
    map.put('\u0C8B', "KANNADA LETTER VOCALIC R");
    map.put('\u0C8C', "KANNADA LETTER VOCALIC L");
    map.put('\u0C8E', "KANNADA LETTER E");
    map.put('\u0C8F', "KANNADA LETTER EE");
    map.put('\u0C90', "KANNADA LETTER AI");
    map.put('\u0C92', "KANNADA LETTER O");
    map.put('\u0C93', "KANNADA LETTER OO");
    map.put('\u0C94', "KANNADA LETTER AU");
    map.put('\u0C95', "KANNADA LETTER KA");
    map.put('\u0C96', "KANNADA LETTER KHA");
    map.put('\u0C97', "KANNADA LETTER GA");
    map.put('\u0C98', "KANNADA LETTER GHA");
    map.put('\u0C99', "KANNADA LETTER NGA");
    map.put('\u0C9A', "KANNADA LETTER CA");
    map.put('\u0C9B', "KANNADA LETTER CHA");
    map.put('\u0C9C', "KANNADA LETTER JA");
    map.put('\u0C9D', "KANNADA LETTER JHA");
    map.put('\u0C9E', "KANNADA LETTER NYA");
    map.put('\u0C9F', "KANNADA LETTER TTA");
    map.put('\u0CA0', "KANNADA LETTER TTHA");
    map.put('\u0CA1', "KANNADA LETTER DDA");
    map.put('\u0CA2', "KANNADA LETTER DDHA");
    map.put('\u0CA3', "KANNADA LETTER NNA");
    map.put('\u0CA4', "KANNADA LETTER TA");
    map.put('\u0CA5', "KANNADA LETTER THA");
    map.put('\u0CA6', "KANNADA LETTER DA");
    map.put('\u0CA7', "KANNADA LETTER DHA");
    map.put('\u0CA8', "KANNADA LETTER NA");
    map.put('\u0CAA', "KANNADA LETTER PA");
    map.put('\u0CAB', "KANNADA LETTER PHA");
    map.put('\u0CAC', "KANNADA LETTER BA");
    map.put('\u0CAD', "KANNADA LETTER BHA");
    map.put('\u0CAE', "KANNADA LETTER MA");
    map.put('\u0CAF', "KANNADA LETTER YA");
    map.put('\u0CB0', "KANNADA LETTER RA");
    map.put('\u0CB1', "KANNADA LETTER RRA");
    map.put('\u0CB2', "KANNADA LETTER LA");
    map.put('\u0CB3', "KANNADA LETTER LLA");
    map.put('\u0CB5', "KANNADA LETTER VA");
    map.put('\u0CB6', "KANNADA LETTER SHA");
    map.put('\u0CB7', "KANNADA LETTER SSA");
    map.put('\u0CB8', "KANNADA LETTER SA");
    map.put('\u0CB9', "KANNADA LETTER HA");
    map.put('\u0CBC', "KANNADA SIGN NUKTA");
    map.put('\u0CBD', "KANNADA SIGN AVAGRAHA");
    map.put('\u0CBE', "KANNADA VOWEL SIGN AA");
    map.put('\u0CBF', "KANNADA VOWEL SIGN I");
    map.put('\u0CC0', "KANNADA VOWEL SIGN II");
    map.put('\u0CC1', "KANNADA VOWEL SIGN U");
    map.put('\u0CC2', "KANNADA VOWEL SIGN UU");
    map.put('\u0CC3', "KANNADA VOWEL SIGN VOCALIC R");
    map.put('\u0CC4', "KANNADA VOWEL SIGN VOCALIC RR");
    map.put('\u0CC6', "KANNADA VOWEL SIGN E");
    map.put('\u0CC7', "KANNADA VOWEL SIGN EE");
    map.put('\u0CC8', "KANNADA VOWEL SIGN AI");
    map.put('\u0CCA', "KANNADA VOWEL SIGN O");
    map.put('\u0CCB', "KANNADA VOWEL SIGN OO");
    map.put('\u0CCC', "KANNADA VOWEL SIGN AU");
    map.put('\u0CCD', "KANNADA SIGN VIRAMA");
    map.put('\u0CD5', "KANNADA LENGTH MARK");
    map.put('\u0CD6', "KANNADA AI LENGTH MARK");
    map.put('\u0CDE', "KANNADA LETTER FA");
    map.put('\u0CE0', "KANNADA LETTER VOCALIC RR");
    map.put('\u0CE1', "KANNADA LETTER VOCALIC LL");
    map.put('\u0CE2', "KANNADA VOWEL SIGN VOCALIC L");
    map.put('\u0CE3', "KANNADA VOWEL SIGN VOCALIC LL");
    map.put('\u0CE4', "<reserved>");
    map.put('\u0CE5', "<reserved>");
    map.put('\u0CE6', "KANNADA DIGIT ZERO");
    map.put('\u0CE7', "KANNADA DIGIT ONE");
    map.put('\u0CE8', "KANNADA DIGIT TWO");
    map.put('\u0CE9', "KANNADA DIGIT THREE");
    map.put('\u0CEA', "KANNADA DIGIT FOUR");
    map.put('\u0CEB', "KANNADA DIGIT FIVE");
    map.put('\u0CEC', "KANNADA DIGIT SIX");
    map.put('\u0CED', "KANNADA DIGIT SEVEN");
    map.put('\u0CEE', "KANNADA DIGIT EIGHT");
    map.put('\u0CEF', "KANNADA DIGIT NINE");
    map.put('\u0CF1', "KANNADA SIGN JIHVAMULIYA");
    map.put('\u0CF2', "KANNADA SIGN UPADHMANIYA");

  }

  public static final void malayalam(Map<Character, String> map) {

    map.put('\u0D02', "MALAYALAM SIGN ANUSVARA");
    map.put('\u0D03', "MALAYALAM SIGN VISARGA");
    map.put('\u0D05', "MALAYALAM LETTER A");
    map.put('\u0D06', "MALAYALAM LETTER AA");
    map.put('\u0D07', "MALAYALAM LETTER I");
    map.put('\u0D08', "MALAYALAM LETTER II");
    map.put('\u0D09', "MALAYALAM LETTER U");
    map.put('\u0D0A', "MALAYALAM LETTER UU");
    map.put('\u0D0B', "MALAYALAM LETTER VOCALIC R");
    map.put('\u0D0C', "MALAYALAM LETTER VOCALIC L");
    map.put('\u0D0E', "MALAYALAM LETTER E");
    map.put('\u0D0F', "MALAYALAM LETTER EE");
    map.put('\u0D10', "MALAYALAM LETTER AI");
    map.put('\u0D12', "MALAYALAM LETTER O");
    map.put('\u0D13', "MALAYALAM LETTER OO");
    map.put('\u0D14', "MALAYALAM LETTER AU");
    map.put('\u0D15', "MALAYALAM LETTER KA");
    map.put('\u0D16', "MALAYALAM LETTER KHA");
    map.put('\u0D17', "MALAYALAM LETTER GA");
    map.put('\u0D18', "MALAYALAM LETTER GHA");
    map.put('\u0D19', "MALAYALAM LETTER NGA");
    map.put('\u0D1A', "MALAYALAM LETTER CA");
    map.put('\u0D1B', "MALAYALAM LETTER CHA");
    map.put('\u0D1C', "MALAYALAM LETTER JA");
    map.put('\u0D1D', "MALAYALAM LETTER JHA");
    map.put('\u0D1E', "MALAYALAM LETTER NYA");
    map.put('\u0D1F', "MALAYALAM LETTER TTA");
    map.put('\u0D20', "MALAYALAM LETTER TTHA");
    map.put('\u0D21', "MALAYALAM LETTER DDA");
    map.put('\u0D22', "MALAYALAM LETTER DDHA");
    map.put('\u0D23', "MALAYALAM LETTER NNA");
    map.put('\u0D24', "MALAYALAM LETTER TA");
    map.put('\u0D25', "MALAYALAM LETTER THA");
    map.put('\u0D26', "MALAYALAM LETTER DA");
    map.put('\u0D27', "MALAYALAM LETTER DHA");
    map.put('\u0D28', "MALAYALAM LETTER NA");
    map.put('\u0D2A', "MALAYALAM LETTER PA");
    map.put('\u0D2B', "MALAYALAM LETTER PHA");
    map.put('\u0D2C', "MALAYALAM LETTER BA");
    map.put('\u0D2D', "MALAYALAM LETTER BHA");
    map.put('\u0D2E', "MALAYALAM LETTER MA");
    map.put('\u0D2F', "MALAYALAM LETTER YA");
    map.put('\u0D30', "MALAYALAM LETTER RA");
    map.put('\u0D31', "MALAYALAM LETTER RRA");
    map.put('\u0D32', "MALAYALAM LETTER LA");
    map.put('\u0D33', "MALAYALAM LETTER LLA");
    map.put('\u0D34', "MALAYALAM LETTER LLLA");
    map.put('\u0D35', "MALAYALAM LETTER VA");
    map.put('\u0D36', "MALAYALAM LETTER SHA");
    map.put('\u0D37', "MALAYALAM LETTER SSA");
    map.put('\u0D38', "MALAYALAM LETTER SA");
    map.put('\u0D39', "MALAYALAM LETTER HA");
    map.put('\u0D3D', "MALAYALAM SIGN AVAGRAHA");
    map.put('\u0D3E', "MALAYALAM VOWEL SIGN AA");
    map.put('\u0D3F', "MALAYALAM VOWEL SIGN I");
    map.put('\u0D40', "MALAYALAM VOWEL SIGN II");
    map.put('\u0D41', "MALAYALAM VOWEL SIGN U");
    map.put('\u0D42', "MALAYALAM VOWEL SIGN UU");
    map.put('\u0D43', "MALAYALAM VOWEL SIGN VOCALIC R");
    map.put('\u0D44', "MALAYALAM VOWEL SIGN VOCALIC RR");
    map.put('\u0D46', "MALAYALAM VOWEL SIGN E");
    map.put('\u0D47', "MALAYALAM VOWEL SIGN EE");
    map.put('\u0D48', "MALAYALAM VOWEL SIGN AI");
    map.put('\u0D4A', "MALAYALAM VOWEL SIGN O");
    map.put('\u0D4B', "MALAYALAM VOWEL SIGN OO");
    map.put('\u0D4C', "MALAYALAM VOWEL SIGN AU");
    map.put('\u0D4D', "MALAYALAM SIGN VIRAMA");
    map.put('\u0D57', "MALAYALAM AU LENGTH MARK");
    map.put('\u0D60', "MALAYALAM LETTER VOCALIC RR");
    map.put('\u0D61', "MALAYALAM LETTER VOCALIC LL");
    map.put('\u0D62', "MALAYALAM VOWEL SIGN VOCALIC L");
    map.put('\u0D63', "MALAYALAM VOWEL SIGN VOCALIC LL");
    map.put('\u0D64', "<reserved>");
    map.put('\u0D65', "<reserved>");
    map.put('\u0D66', "MALAYALAM DIGIT ZERO");
    map.put('\u0D67', "MALAYALAM DIGIT ONE");
    map.put('\u0D68', "MALAYALAM DIGIT TWO");
    map.put('\u0D69', "MALAYALAM DIGIT THREE");
    map.put('\u0D6A', "MALAYALAM DIGIT FOUR");
    map.put('\u0D6B', "MALAYALAM DIGIT FIVE");
    map.put('\u0D6C', "MALAYALAM DIGIT SIX");
    map.put('\u0D6D', "MALAYALAM DIGIT SEVEN");
    map.put('\u0D6E', "MALAYALAM DIGIT EIGHT");
    map.put('\u0D6F', "MALAYALAM DIGIT NINE");
    map.put('\u0D70', "MALAYALAM NUMBER TEN");
    map.put('\u0D71', "MALAYALAM NUMBER ONE HUNDRED");
    map.put('\u0D72', "MALAYALAM NUMBER ONE THOUSAND");
    map.put('\u0D73', "MALAYALAM FRACTION ONE QUARTER");
    map.put('\u0D74', "MALAYALAM FRACTION ONE HALF");
    map.put('\u0D75', "MALAYALAM FRACTION THREE QUARTERS");
    map.put('\u0D79', "MALAYALAM DATE MARK");
    map.put('\u0D7A', "MALAYALAM LETTER CHILLU NN");
    map.put('\u0D7B', "MALAYALAM LETTER CHILLU N");
    map.put('\u0D7C', "MALAYALAM LETTER CHILLU RR");
    map.put('\u0D7D', "MALAYALAM LETTER CHILLU L");
    map.put('\u0D7E', "MALAYALAM LETTER CHILLU LL");
    map.put('\u0D7F', "MALAYALAM LETTER CHILLU K");

  }

  public static final void sinhala(Map<Character, String> map) {

    map.put('\u0D82', "SINHALA SIGN ANUSVARAYA");
    map.put('\u0D83', "SINHALA SIGN VISARGAYA");
    map.put('\u0D85', "SINHALA LETTER AYANNA");
    map.put('\u0D86', "SINHALA LETTER AAYANNA");
    map.put('\u0D87', "SINHALA LETTER AEYANNA");
    map.put('\u0D88', "SINHALA LETTER AEEYANNA");
    map.put('\u0D89', "SINHALA LETTER IYANNA");
    map.put('\u0D8A', "SINHALA LETTER IIYANNA");
    map.put('\u0D8B', "SINHALA LETTER UYANNA");
    map.put('\u0D8C', "SINHALA LETTER UUYANNA");
    map.put('\u0D8D', "SINHALA LETTER IRUYANNA");
    map.put('\u0D8E', "SINHALA LETTER IRUUYANNA");
    map.put('\u0D8F', "SINHALA LETTER ILUYANNA");
    map.put('\u0D90', "SINHALA LETTER ILUUYANNA");
    map.put('\u0D91', "SINHALA LETTER EYANNA");
    map.put('\u0D92', "SINHALA LETTER EEYANNA");
    map.put('\u0D93', "SINHALA LETTER AIYANNA");
    map.put('\u0D94', "SINHALA LETTER OYANNA");
    map.put('\u0D95', "SINHALA LETTER OOYANNA");
    map.put('\u0D96', "SINHALA LETTER AUYANNA");
    map.put('\u0D9A', "SINHALA LETTER ALPAPRAANA KAYANNA");
    map.put('\u0D9B', "SINHALA LETTER MAHAAPRAANA KAYANNA");
    map.put('\u0D9C', "SINHALA LETTER ALPAPRAANA GAYANNA");
    map.put('\u0D9D', "SINHALA LETTER MAHAAPRAANA GAYANNA");
    map.put('\u0D9E', "SINHALA LETTER KANTAJA NAASIKYAYA");
    map.put('\u0D9F', "SINHALA LETTER SANYAKA GAYANNA");
    map.put('\u0DA0', "SINHALA LETTER ALPAPRAANA CAYANNA");
    map.put('\u0DA1', "SINHALA LETTER MAHAAPRAANA CAYANNA");
    map.put('\u0DA2', "SINHALA LETTER ALPAPRAANA JAYANNA");
    map.put('\u0DA3', "SINHALA LETTER MAHAAPRAANA JAYANNA");
    map.put('\u0DA4', "SINHALA LETTER TAALUJA NAASIKYAYA");
    map.put('\u0DA5', "SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA");
    map.put('\u0DA6', "SINHALA LETTER SANYAKA JAYANNA");
    map.put('\u0DA7', "SINHALA LETTER ALPAPRAANA TTAYANNA");
    map.put('\u0DA8', "SINHALA LETTER MAHAAPRAANA TTAYANNA");
    map.put('\u0DA9', "SINHALA LETTER ALPAPRAANA DDAYANNA");
    map.put('\u0DAA', "SINHALA LETTER MAHAAPRAANA DDAYANNA");
    map.put('\u0DAB', "SINHALA LETTER MUURDHAJA NAYANNA");
    map.put('\u0DAC', "SINHALA LETTER SANYAKA DDAYANNA");
    map.put('\u0DAD', "SINHALA LETTER ALPAPRAANA TAYANNA");
    map.put('\u0DAE', "SINHALA LETTER MAHAAPRAANA TAYANNA");
    map.put('\u0DAF', "SINHALA LETTER ALPAPRAANA DAYANNA");
    map.put('\u0DB0', "SINHALA LETTER MAHAAPRAANA DAYANNA");
    map.put('\u0DB1', "SINHALA LETTER DANTAJA NAYANNA");
    map.put('\u0DB3', "SINHALA LETTER SANYAKA DAYANNA");
    map.put('\u0DB4', "SINHALA LETTER ALPAPRAANA PAYANNA");
    map.put('\u0DB5', "SINHALA LETTER MAHAAPRAANA PAYANNA");
    map.put('\u0DB6', "SINHALA LETTER ALPAPRAANA BAYANNA");
    map.put('\u0DB7', "SINHALA LETTER MAHAAPRAANA BAYANNA");
    map.put('\u0DB8', "SINHALA LETTER MAYANNA");
    map.put('\u0DB9', "SINHALA LETTER AMBA BAYANNA");
    map.put('\u0DBA', "SINHALA LETTER YAYANNA");
    map.put('\u0DBB', "SINHALA LETTER RAYANNA");
    map.put('\u0DBD', "SINHALA LETTER DANTAJA LAYANNA");
    map.put('\u0DC0', "SINHALA LETTER VAYANNA");
    map.put('\u0DC1', "SINHALA LETTER TAALUJA SAYANNA");
    map.put('\u0DC2', "SINHALA LETTER MUURDHAJA SAYANNA");
    map.put('\u0DC3', "SINHALA LETTER DANTAJA SAYANNA");
    map.put('\u0DC4', "SINHALA LETTER HAYANNA");
    map.put('\u0DC5', "SINHALA LETTER MUURDHAJA LAYANNA");
    map.put('\u0DC6', "SINHALA LETTER FAYANNA");
    map.put('\u0DCA', "SINHALA SIGN AL-LAKUNA");
    map.put('\u0DCF', "SINHALA VOWEL SIGN AELA-PILLA");
    map.put('\u0DD0', "SINHALA VOWEL SIGN KETTI AEDA-PILLA");
    map.put('\u0DD1', "SINHALA VOWEL SIGN DIGA AEDA-PILLA");
    map.put('\u0DD2', "SINHALA VOWEL SIGN KETTI IS-PILLA");
    map.put('\u0DD3', "SINHALA VOWEL SIGN DIGA IS-PILLA");
    map.put('\u0DD4', "SINHALA VOWEL SIGN KETTI PAA-PILLA");
    map.put('\u0DD6', "SINHALA VOWEL SIGN DIGA PAA-PILLA");
    map.put('\u0DD8', "SINHALA VOWEL SIGN GAETTA-PILLA");
    map.put('\u0DD9', "SINHALA VOWEL SIGN KOMBUVA");
    map.put('\u0DDA', "SINHALA VOWEL SIGN DIGA KOMBUVA");
    map.put('\u0DDB', "SINHALA VOWEL SIGN KOMBU DEKA");
    map.put('\u0DDC', "SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA");
    map.put('\u0DDD', "SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA");
    map.put('\u0DDE', "SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA");
    map.put('\u0DDF', "SINHALA VOWEL SIGN GAYANUKITTA");
    map.put('\u0DF2', "SINHALA VOWEL SIGN DIGA GAETTA-PILLA");
    map.put('\u0DF3', "SINHALA VOWEL SIGN DIGA GAYANUKITTA");
    map.put('\u0DF4', "SINHALA PUNCTUATION KUNDDALIYA");

  }

  public static final void thai(Map<Character, String> map) {

    map.put('\u0E01', "THAI CHARACTER KO KAI");
    map.put('\u0E02', "THAI CHARACTER KHO KHAI");
    map.put('\u0E03', "THAI CHARACTER KHO KHUAT");
    map.put('\u0E04', "THAI CHARACTER KHO KHWAI");
    map.put('\u0E05', "THAI CHARACTER KHO KHON");
    map.put('\u0E06', "THAI CHARACTER KHO RAKHANG");
    map.put('\u0E07', "THAI CHARACTER NGO NGU");
    map.put('\u0E08', "THAI CHARACTER CHO CHAN");
    map.put('\u0E09', "THAI CHARACTER CHO CHING");
    map.put('\u0E0A', "THAI CHARACTER CHO CHANG");
    map.put('\u0E0B', "THAI CHARACTER SO SO");
    map.put('\u0E0C', "THAI CHARACTER CHO CHOE");
    map.put('\u0E0D', "THAI CHARACTER YO YING");
    map.put('\u0E0E', "THAI CHARACTER DO CHADA");
    map.put('\u0E0F', "THAI CHARACTER TO PATAK");
    map.put('\u0E10', "THAI CHARACTER THO THAN");
    map.put('\u0E11', "THAI CHARACTER THO NANGMONTHO");
    map.put('\u0E12', "THAI CHARACTER THO PHUTHAO");
    map.put('\u0E13', "THAI CHARACTER NO NEN");
    map.put('\u0E14', "THAI CHARACTER DO DEK");
    map.put('\u0E15', "THAI CHARACTER TO TAO");
    map.put('\u0E16', "THAI CHARACTER THO THUNG");
    map.put('\u0E17', "THAI CHARACTER THO THAHAN");
    map.put('\u0E18', "THAI CHARACTER THO THONG");
    map.put('\u0E19', "THAI CHARACTER NO NU");
    map.put('\u0E1A', "THAI CHARACTER BO BAIMAI");
    map.put('\u0E1B', "THAI CHARACTER PO PLA");
    map.put('\u0E1C', "THAI CHARACTER PHO PHUNG");
    map.put('\u0E1D', "THAI CHARACTER FO FA");
    map.put('\u0E1E', "THAI CHARACTER PHO PHAN");
    map.put('\u0E1F', "THAI CHARACTER FO FAN");
    map.put('\u0E20', "THAI CHARACTER PHO SAMPHAO");
    map.put('\u0E21', "THAI CHARACTER MO MA");
    map.put('\u0E22', "THAI CHARACTER YO YAK");
    map.put('\u0E23', "THAI CHARACTER RO RUA");
    map.put('\u0E24', "THAI CHARACTER RU");
    map.put('\u0E25', "THAI CHARACTER LO LING");
    map.put('\u0E26', "THAI CHARACTER LU");
    map.put('\u0E27', "THAI CHARACTER WO WAEN");
    map.put('\u0E28', "THAI CHARACTER SO SALA");
    map.put('\u0E29', "THAI CHARACTER SO RUSI");
    map.put('\u0E2A', "THAI CHARACTER SO SUA");
    map.put('\u0E2B', "THAI CHARACTER HO HIP");
    map.put('\u0E2C', "THAI CHARACTER LO CHULA");
    map.put('\u0E2D', "THAI CHARACTER O ANG");
    map.put('\u0E2E', "THAI CHARACTER HO NOKHUK");
    map.put('\u0E2F', "THAI CHARACTER PAIYANNOI");
    map.put('\u0E30', "THAI CHARACTER SARA A");
    map.put('\u0E31', "THAI CHARACTER MAI HAN-AKAT");
    map.put('\u0E32', "THAI CHARACTER SARA AA");
    map.put('\u0E33', "THAI CHARACTER SARA AM");
    map.put('\u0E34', "THAI CHARACTER SARA I");
    map.put('\u0E35', "THAI CHARACTER SARA II");
    map.put('\u0E36', "THAI CHARACTER SARA UE");
    map.put('\u0E37', "THAI CHARACTER SARA UEE");
    map.put('\u0E38', "THAI CHARACTER SARA U");
    map.put('\u0E39', "THAI CHARACTER SARA UU");
    map.put('\u0E3A', "THAI CHARACTER PHINTHU");
    map.put('\u0E3F', "THAI CURRENCY SYMBOL BAHT");
    map.put('\u0E40', "THAI CHARACTER SARA E");
    map.put('\u0E41', "THAI CHARACTER SARA AE");
    map.put('\u0E42', "THAI CHARACTER SARA O");
    map.put('\u0E43', "THAI CHARACTER SARA AI MAIMUAN");
    map.put('\u0E44', "THAI CHARACTER SARA AI MAIMALAI");
    map.put('\u0E45', "THAI CHARACTER LAKKHANGYAO");
    map.put('\u0E46', "THAI CHARACTER MAIYAMOK");
    map.put('\u0E47', "THAI CHARACTER MAITAIKHU");
    map.put('\u0E48', "THAI CHARACTER MAI EK");
    map.put('\u0E49', "THAI CHARACTER MAI THO");
    map.put('\u0E4A', "THAI CHARACTER MAI TRI");
    map.put('\u0E4B', "THAI CHARACTER MAI CHATTAWA");
    map.put('\u0E4C', "THAI CHARACTER THANTHAKHAT");
    map.put('\u0E4D', "THAI CHARACTER NIKHAHIT");
    map.put('\u0E4E', "THAI CHARACTER YAMAKKAN");
    map.put('\u0E4F', "THAI CHARACTER FONGMAN");
    map.put('\u0E50', "THAI DIGIT ZERO");
    map.put('\u0E51', "THAI DIGIT ONE");
    map.put('\u0E52', "THAI DIGIT TWO");
    map.put('\u0E53', "THAI DIGIT THREE");
    map.put('\u0E54', "THAI DIGIT FOUR");
    map.put('\u0E55', "THAI DIGIT FIVE");
    map.put('\u0E56', "THAI DIGIT SIX");
    map.put('\u0E57', "THAI DIGIT SEVEN");
    map.put('\u0E58', "THAI DIGIT EIGHT");
    map.put('\u0E59', "THAI DIGIT NINE");
    map.put('\u0E5A', "THAI CHARACTER ANGKHANKHU");
    map.put('\u0E5B', "THAI CHARACTER KHOMUT");

  }

  public static final void lao(Map<Character, String> map) {

    map.put('\u0E81', "LAO LETTER KO");
    map.put('\u0E82', "LAO LETTER KHO SUNG");
    map.put('\u0E84', "LAO LETTER KHO TAM");
    map.put('\u0E87', "LAO LETTER NGO");
    map.put('\u0E88', "LAO LETTER CO");
    map.put('\u0E8A', "LAO LETTER SO TAM");
    map.put('\u0E8D', "LAO LETTER NYO");
    map.put('\u0E94', "LAO LETTER DO");
    map.put('\u0E95', "LAO LETTER TO");
    map.put('\u0E96', "LAO LETTER THO SUNG");
    map.put('\u0E97', "LAO LETTER THO TAM");
    map.put('\u0E99', "LAO LETTER NO");
    map.put('\u0E9A', "LAO LETTER BO");
    map.put('\u0E9B', "LAO LETTER PO");
    map.put('\u0E9C', "LAO LETTER PHO SUNG");
    map.put('\u0E9D', "LAO LETTER FO TAM");
    map.put('\u0E9E', "LAO LETTER PHO TAM");
    map.put('\u0E9F', "LAO LETTER FO SUNG");
    map.put('\u0EA1', "LAO LETTER MO");
    map.put('\u0EA2', "LAO LETTER YO");
    map.put('\u0EA3', "LAO LETTER LO LING");
    map.put('\u0EA5', "LAO LETTER LO LOOT");
    map.put('\u0EA7', "LAO LETTER WO");
    map.put('\u0EAA', "LAO LETTER SO SUNG");
    map.put('\u0EAB', "LAO LETTER HO SUNG");
    map.put('\u0EAD', "LAO LETTER O");
    map.put('\u0EAE', "LAO LETTER HO TAM");
    map.put('\u0EAF', "LAO ELLIPSIS");
    map.put('\u0EB0', "LAO VOWEL SIGN A");
    map.put('\u0EB1', "LAO VOWEL SIGN MAI KAN");
    map.put('\u0EB2', "LAO VOWEL SIGN AA");
    map.put('\u0EB3', "LAO VOWEL SIGN AM");
    map.put('\u0EB4', "LAO VOWEL SIGN I");
    map.put('\u0EB5', "LAO VOWEL SIGN II");
    map.put('\u0EB6', "LAO VOWEL SIGN Y");
    map.put('\u0EB7', "LAO VOWEL SIGN YY");
    map.put('\u0EB8', "LAO VOWEL SIGN U");
    map.put('\u0EB9', "LAO VOWEL SIGN UU");
    map.put('\u0EBB', "LAO VOWEL SIGN MAI KON");
    map.put('\u0EBC', "LAO SEMIVOWEL SIGN LO");
    map.put('\u0EBD', "LAO SEMIVOWEL SIGN NYO");
    map.put('\u0EC0', "LAO VOWEL SIGN E");
    map.put('\u0EC1', "LAO VOWEL SIGN EI");
    map.put('\u0EC2', "LAO VOWEL SIGN O");
    map.put('\u0EC3', "LAO VOWEL SIGN AY");
    map.put('\u0EC4', "LAO VOWEL SIGN AI");
    map.put('\u0EC6', "LAO KO LA");
    map.put('\u0EC8', "LAO TONE MAI EK");
    map.put('\u0EC9', "LAO TONE MAI THO");
    map.put('\u0ECA', "LAO TONE MAI TI");
    map.put('\u0ECB', "LAO TONE MAI CATAWA");
    map.put('\u0ECC', "LAO CANCELLATION MARK");
    map.put('\u0ECD', "LAO NIGGAHITA");
    map.put('\u0ED0', "LAO DIGIT ZERO");
    map.put('\u0ED1', "LAO DIGIT ONE");
    map.put('\u0ED2', "LAO DIGIT TWO");
    map.put('\u0ED3', "LAO DIGIT THREE");
    map.put('\u0ED4', "LAO DIGIT FOUR");
    map.put('\u0ED5', "LAO DIGIT FIVE");
    map.put('\u0ED6', "LAO DIGIT SIX");
    map.put('\u0ED7', "LAO DIGIT SEVEN");
    map.put('\u0ED8', "LAO DIGIT EIGHT");
    map.put('\u0ED9', "LAO DIGIT NINE");
    map.put('\u0EDC', "LAO HO NO");
    map.put('\u0EDD', "LAO HO MO");

  }

  public static final void tibetan(Map<Character, String> map) {

    map.put('\u0F00', "TIBETAN SYLLABLE OM");
    map.put('\u0F01', "TIBETAN MARK GTER YIG MGO TRUNCATED A");
    map.put('\u0F02', "TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA");
    map.put('\u0F03', "TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA");
    map.put('\u0F04', "TIBETAN MARK INITIAL YIG MGO MDUN MA");
    map.put('\u0F05', "TIBETAN MARK CLOSING YIG MGO SGAB MA");
    map.put('\u0F06', "TIBETAN MARK CARET YIG MGO PHUR SHAD MA");
    map.put('\u0F07', "TIBETAN MARK YIG MGO TSHEG SHAD MA");
    map.put('\u0F08', "TIBETAN MARK SBRUL SHAD");
    map.put('\u0F09', "TIBETAN MARK BSKUR YIG MGO");
    map.put('\u0F0A', "TIBETAN MARK BKA- SHOG YIG MGO");
    map.put('\u0F0B', "TIBETAN MARK INTERSYLLABIC TSHEG");
    map.put('\u0F0C', "TIBETAN MARK DELIMITER TSHEG BSTAR");
    map.put('\u0F0D', "TIBETAN MARK SHAD");
    map.put('\u0F0E', "TIBETAN MARK NYIS SHAD");
    map.put('\u0F0F', "TIBETAN MARK TSHEG SHAD");
    map.put('\u0F10', "TIBETAN MARK NYIS TSHEG SHAD");
    map.put('\u0F11', "TIBETAN MARK RIN CHEN SPUNGS SHAD");
    map.put('\u0F12', "TIBETAN MARK RGYA GRAM SHAD");
    map.put('\u0F13', "TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN");
    map.put('\u0F14', "TIBETAN MARK GTER TSHEG");
    map.put('\u0F15', "TIBETAN LOGOTYPE SIGN CHAD RTAGS");
    map.put('\u0F16', "TIBETAN LOGOTYPE SIGN LHAG RTAGS");
    map.put('\u0F17', "TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS");
    map.put('\u0F18', "TIBETAN ASTROLOGICAL SIGN -KHYUD PA");
    map.put('\u0F19', "TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS");
    map.put('\u0F1A', "TIBETAN SIGN RDEL DKAR GCIG");
    map.put('\u0F1B', "TIBETAN SIGN RDEL DKAR GNYIS");
    map.put('\u0F1C', "TIBETAN SIGN RDEL DKAR GSUM");
    map.put('\u0F1D', "TIBETAN SIGN RDEL NAG GCIG");
    map.put('\u0F1E', "TIBETAN SIGN RDEL NAG GNYIS");
    map.put('\u0F1F', "TIBETAN SIGN RDEL DKAR RDEL NAG");
    map.put('\u0F20', "TIBETAN DIGIT ZERO");
    map.put('\u0F21', "TIBETAN DIGIT ONE");
    map.put('\u0F22', "TIBETAN DIGIT TWO");
    map.put('\u0F23', "TIBETAN DIGIT THREE");
    map.put('\u0F24', "TIBETAN DIGIT FOUR");
    map.put('\u0F25', "TIBETAN DIGIT FIVE");
    map.put('\u0F26', "TIBETAN DIGIT SIX");
    map.put('\u0F27', "TIBETAN DIGIT SEVEN");
    map.put('\u0F28', "TIBETAN DIGIT EIGHT");
    map.put('\u0F29', "TIBETAN DIGIT NINE");
    map.put('\u0F2A', "TIBETAN DIGIT HALF ONE");
    map.put('\u0F2B', "TIBETAN DIGIT HALF TWO");
    map.put('\u0F2C', "TIBETAN DIGIT HALF THREE");
    map.put('\u0F2D', "TIBETAN DIGIT HALF FOUR");
    map.put('\u0F2E', "TIBETAN DIGIT HALF FIVE");
    map.put('\u0F2F', "TIBETAN DIGIT HALF SIX");
    map.put('\u0F30', "TIBETAN DIGIT HALF SEVEN");
    map.put('\u0F31', "TIBETAN DIGIT HALF EIGHT");
    map.put('\u0F32', "TIBETAN DIGIT HALF NINE");
    map.put('\u0F33', "TIBETAN DIGIT HALF ZERO");
    map.put('\u0F34', "TIBETAN MARK BSDUS RTAGS");
    map.put('\u0F35', "TIBETAN MARK NGAS BZUNG NYI ZLA");
    map.put('\u0F36', "TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN");
    map.put('\u0F37', "TIBETAN MARK NGAS BZUNG SGOR RTAGS");
    map.put('\u0F38', "TIBETAN MARK CHE MGO");
    map.put('\u0F39', "TIBETAN MARK TSA -PHRU");
    map.put('\u0F3A', "TIBETAN MARK GUG RTAGS GYON");
    map.put('\u0F3B', "TIBETAN MARK GUG RTAGS GYAS");
    map.put('\u0F3C', "TIBETAN MARK ANG KHANG GYON");
    map.put('\u0F3D', "TIBETAN MARK ANG KHANG GYAS");
    map.put('\u0F3E', "TIBETAN SIGN YAR TSHES");
    map.put('\u0F3F', "TIBETAN SIGN MAR TSHES");
    map.put('\u0F40', "TIBETAN LETTER KA");
    map.put('\u0F41', "TIBETAN LETTER KHA");
    map.put('\u0F42', "TIBETAN LETTER GA");
    map.put('\u0F43', "TIBETAN LETTER GHA");
    map.put('\u0F44', "TIBETAN LETTER NGA");
    map.put('\u0F45', "TIBETAN LETTER CA");
    map.put('\u0F46', "TIBETAN LETTER CHA");
    map.put('\u0F47', "TIBETAN LETTER JA");
    map.put('\u0F49', "TIBETAN LETTER NYA");
    map.put('\u0F4A', "TIBETAN LETTER TTA");
    map.put('\u0F4B', "TIBETAN LETTER TTHA");
    map.put('\u0F4C', "TIBETAN LETTER DDA");
    map.put('\u0F4D', "TIBETAN LETTER DDHA");
    map.put('\u0F4E', "TIBETAN LETTER NNA");
    map.put('\u0F4F', "TIBETAN LETTER TA");
    map.put('\u0F50', "TIBETAN LETTER THA");
    map.put('\u0F51', "TIBETAN LETTER DA");
    map.put('\u0F52', "TIBETAN LETTER DHA");
    map.put('\u0F53', "TIBETAN LETTER NA");
    map.put('\u0F54', "TIBETAN LETTER PA");
    map.put('\u0F55', "TIBETAN LETTER PHA");
    map.put('\u0F56', "TIBETAN LETTER BA");
    map.put('\u0F57', "TIBETAN LETTER BHA");
    map.put('\u0F58', "TIBETAN LETTER MA");
    map.put('\u0F59', "TIBETAN LETTER TSA");
    map.put('\u0F5A', "TIBETAN LETTER TSHA");
    map.put('\u0F5B', "TIBETAN LETTER DZA");
    map.put('\u0F5C', "TIBETAN LETTER DZHA");
    map.put('\u0F5D', "TIBETAN LETTER WA");
    map.put('\u0F5E', "TIBETAN LETTER ZHA");
    map.put('\u0F5F', "TIBETAN LETTER ZA");
    map.put('\u0F60', "TIBETAN LETTER -A");
    map.put('\u0F61', "TIBETAN LETTER YA");
    map.put('\u0F62', "TIBETAN LETTER RA");
    map.put('\u0F63', "TIBETAN LETTER LA");
    map.put('\u0F64', "TIBETAN LETTER SHA");
    map.put('\u0F65', "TIBETAN LETTER SSA");
    map.put('\u0F66', "TIBETAN LETTER SA");
    map.put('\u0F67', "TIBETAN LETTER HA");
    map.put('\u0F68', "TIBETAN LETTER A");
    map.put('\u0F69', "TIBETAN LETTER KSSA");
    map.put('\u0F6A', "TIBETAN LETTER FIXED-FORM RA");
    map.put('\u0F6B', "TIBETAN LETTER KKA");
    map.put('\u0F6C', "TIBETAN LETTER RRA");
    map.put('\u0F71', "TIBETAN VOWEL SIGN AA");
    map.put('\u0F72', "TIBETAN VOWEL SIGN I");
    map.put('\u0F73', "TIBETAN VOWEL SIGN II");
    map.put('\u0F74', "TIBETAN VOWEL SIGN U");
    map.put('\u0F75', "TIBETAN VOWEL SIGN UU");
    map.put('\u0F76', "TIBETAN VOWEL SIGN VOCALIC R");
    map.put('\u0F77', "TIBETAN VOWEL SIGN VOCALIC RR");
    map.put('\u0F78', "TIBETAN VOWEL SIGN VOCALIC L");
    map.put('\u0F79', "TIBETAN VOWEL SIGN VOCALIC LL");
    map.put('\u0F7A', "TIBETAN VOWEL SIGN E");
    map.put('\u0F7B', "TIBETAN VOWEL SIGN EE");
    map.put('\u0F7C', "TIBETAN VOWEL SIGN O");
    map.put('\u0F7D', "TIBETAN VOWEL SIGN OO");
    map.put('\u0F7E', "TIBETAN SIGN RJES SU NGA RO");
    map.put('\u0F7F', "TIBETAN SIGN RNAM BCAD");
    map.put('\u0F80', "TIBETAN VOWEL SIGN REVERSED I");
    map.put('\u0F81', "TIBETAN VOWEL SIGN REVERSED II");
    map.put('\u0F82', "TIBETAN SIGN NYI ZLA NAA DA");
    map.put('\u0F83', "TIBETAN SIGN SNA LDAN");
    map.put('\u0F84', "TIBETAN MARK HALANTA");
    map.put('\u0F85', "TIBETAN MARK PALUTA");
    map.put('\u0F86', "TIBETAN SIGN LCI RTAGS");
    map.put('\u0F87', "TIBETAN SIGN YANG RTAGS");
    map.put('\u0F88', "TIBETAN SIGN LCE TSA CAN");
    map.put('\u0F89', "TIBETAN SIGN MCHU CAN");
    map.put('\u0F8A', "TIBETAN SIGN GRU CAN RGYINGS");
    map.put('\u0F8B', "TIBETAN SIGN GRU MED RGYINGS");
    map.put('\u0F90', "TIBETAN SUBJOINED LETTER KA");
    map.put('\u0F91', "TIBETAN SUBJOINED LETTER KHA");
    map.put('\u0F92', "TIBETAN SUBJOINED LETTER GA");
    map.put('\u0F93', "TIBETAN SUBJOINED LETTER GHA");
    map.put('\u0F94', "TIBETAN SUBJOINED LETTER NGA");
    map.put('\u0F95', "TIBETAN SUBJOINED LETTER CA");
    map.put('\u0F96', "TIBETAN SUBJOINED LETTER CHA");
    map.put('\u0F97', "TIBETAN SUBJOINED LETTER JA");
    map.put('\u0F99', "TIBETAN SUBJOINED LETTER NYA");
    map.put('\u0F9A', "TIBETAN SUBJOINED LETTER TTA");
    map.put('\u0F9B', "TIBETAN SUBJOINED LETTER TTHA");
    map.put('\u0F9C', "TIBETAN SUBJOINED LETTER DDA");
    map.put('\u0F9D', "TIBETAN SUBJOINED LETTER DDHA");
    map.put('\u0F9E', "TIBETAN SUBJOINED LETTER NNA");
    map.put('\u0F9F', "TIBETAN SUBJOINED LETTER TA");
    map.put('\u0FA0', "TIBETAN SUBJOINED LETTER THA");
    map.put('\u0FA1', "TIBETAN SUBJOINED LETTER DA");
    map.put('\u0FA2', "TIBETAN SUBJOINED LETTER DHA");
    map.put('\u0FA3', "TIBETAN SUBJOINED LETTER NA");
    map.put('\u0FA4', "TIBETAN SUBJOINED LETTER PA");
    map.put('\u0FA5', "TIBETAN SUBJOINED LETTER PHA");
    map.put('\u0FA6', "TIBETAN SUBJOINED LETTER BA");
    map.put('\u0FA7', "TIBETAN SUBJOINED LETTER BHA");
    map.put('\u0FA8', "TIBETAN SUBJOINED LETTER MA");
    map.put('\u0FA9', "TIBETAN SUBJOINED LETTER TSA");
    map.put('\u0FAA', "TIBETAN SUBJOINED LETTER TSHA");
    map.put('\u0FAB', "TIBETAN SUBJOINED LETTER DZA");
    map.put('\u0FAC', "TIBETAN SUBJOINED LETTER DZHA");
    map.put('\u0FAD', "TIBETAN SUBJOINED LETTER WA");
    map.put('\u0FAE', "TIBETAN SUBJOINED LETTER ZHA");
    map.put('\u0FAF', "TIBETAN SUBJOINED LETTER ZA");
    map.put('\u0FB0', "TIBETAN SUBJOINED LETTER -A");
    map.put('\u0FB1', "TIBETAN SUBJOINED LETTER YA");
    map.put('\u0FB2', "TIBETAN SUBJOINED LETTER RA");
    map.put('\u0FB3', "TIBETAN SUBJOINED LETTER LA");
    map.put('\u0FB4', "TIBETAN SUBJOINED LETTER SHA");
    map.put('\u0FB5', "TIBETAN SUBJOINED LETTER SSA");
    map.put('\u0FB6', "TIBETAN SUBJOINED LETTER SA");
    map.put('\u0FB7', "TIBETAN SUBJOINED LETTER HA");
    map.put('\u0FB8', "TIBETAN SUBJOINED LETTER A");
    map.put('\u0FB9', "TIBETAN SUBJOINED LETTER KSSA");
    map.put('\u0FBA', "TIBETAN SUBJOINED LETTER FIXED-FORM WA");
    map.put('\u0FBB', "TIBETAN SUBJOINED LETTER FIXED-FORM YA");
    map.put('\u0FBC', "TIBETAN SUBJOINED LETTER FIXED-FORM RA");
    map.put('\u0FBE', "TIBETAN KU RU KHA");
    map.put('\u0FBF', "TIBETAN KU RU KHA BZHI MIG CAN");
    map.put('\u0FC0', "TIBETAN CANTILLATION SIGN HEAVY BEAT");
    map.put('\u0FC1', "TIBETAN CANTILLATION SIGN LIGHT BEAT");
    map.put('\u0FC2', "TIBETAN CANTILLATION SIGN CANG TE-U");
    map.put('\u0FC3', "TIBETAN CANTILLATION SIGN SBUB -CHAL");
    map.put('\u0FC4', "TIBETAN SYMBOL DRIL BU");
    map.put('\u0FC5', "TIBETAN SYMBOL RDO RJE");
    map.put('\u0FC6', "TIBETAN SYMBOL PADMA GDAN");
    map.put('\u0FC7', "TIBETAN SYMBOL RDO RJE RGYA GRAM");
    map.put('\u0FC8', "TIBETAN SYMBOL PHUR PA");
    map.put('\u0FC9', "TIBETAN SYMBOL NOR BU");
    map.put('\u0FCA', "TIBETAN SYMBOL NOR BU NYIS -KHYIL");
    map.put('\u0FCB', "TIBETAN SYMBOL NOR BU GSUM -KHYIL");
    map.put('\u0FCC', "TIBETAN SYMBOL NOR BU BZHI -KHYIL");
    map.put('\u0FCE', "TIBETAN SIGN RDEL NAG RDEL DKAR");
    map.put('\u0FCF', "TIBETAN SIGN RDEL NAG GSUM");
    map.put('\u0FD0', "TIBETAN MARK BSKA- SHOG GI MGO RGYAN");
    map.put('\u0FD1', "TIBETAN MARK MNYAM YIG GI MGO RGYAN");
    map.put('\u0FD2', "TIBETAN MARK NYIS TSHEG");
    map.put('\u0FD3', "TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA");
    map.put('\u0FD4', "TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA");
    map.put('\u0FD5', "RIGHT-FACING SVASTI SIGN");
    map.put('\u0FD6', "LEFT-FACING SVASTI SIGN");
    map.put('\u0FD7', "RIGHT-FACING SVASTI SIGN WITH DOTS");
    map.put('\u0FD8', "LEFT-FACING SVASTI SIGN WITH DOTS");

  }

  public static final void myanmar(Map<Character, String> map) {

    map.put('\u1000', "MYANMAR LETTER KA");
    map.put('\u1001', "MYANMAR LETTER KHA");
    map.put('\u1002', "MYANMAR LETTER GA");
    map.put('\u1003', "MYANMAR LETTER GHA");
    map.put('\u1004', "MYANMAR LETTER NGA");
    map.put('\u1005', "MYANMAR LETTER CA");
    map.put('\u1006', "MYANMAR LETTER CHA");
    map.put('\u1007', "MYANMAR LETTER JA");
    map.put('\u1008', "MYANMAR LETTER JHA");
    map.put('\u1009', "MYANMAR LETTER NYA");
    map.put('\u100A', "MYANMAR LETTER NNYA");
    map.put('\u100B', "MYANMAR LETTER TTA");
    map.put('\u100C', "MYANMAR LETTER TTHA");
    map.put('\u100D', "MYANMAR LETTER DDA");
    map.put('\u100E', "MYANMAR LETTER DDHA");
    map.put('\u100F', "MYANMAR LETTER NNA");
    map.put('\u1010', "MYANMAR LETTER TA");
    map.put('\u1011', "MYANMAR LETTER THA");
    map.put('\u1012', "MYANMAR LETTER DA");
    map.put('\u1013', "MYANMAR LETTER DHA");
    map.put('\u1014', "MYANMAR LETTER NA");
    map.put('\u1015', "MYANMAR LETTER PA");
    map.put('\u1016', "MYANMAR LETTER PHA");
    map.put('\u1017', "MYANMAR LETTER BA");
    map.put('\u1018', "MYANMAR LETTER BHA");
    map.put('\u1019', "MYANMAR LETTER MA");
    map.put('\u101A', "MYANMAR LETTER YA");
    map.put('\u101B', "MYANMAR LETTER RA");
    map.put('\u101C', "MYANMAR LETTER LA");
    map.put('\u101D', "MYANMAR LETTER WA");
    map.put('\u101E', "MYANMAR LETTER SA");
    map.put('\u101F', "MYANMAR LETTER HA");
    map.put('\u1020', "MYANMAR LETTER LLA");
    map.put('\u1021', "MYANMAR LETTER A");
    map.put('\u1022', "MYANMAR LETTER SHAN A");
    map.put('\u1023', "MYANMAR LETTER I");
    map.put('\u1024', "MYANMAR LETTER II");
    map.put('\u1025', "MYANMAR LETTER U");
    map.put('\u1026', "MYANMAR LETTER UU");
    map.put('\u1027', "MYANMAR LETTER E");
    map.put('\u1028', "MYANMAR LETTER MON E");
    map.put('\u1029', "MYANMAR LETTER O");
    map.put('\u102A', "MYANMAR LETTER AU");
    map.put('\u102B', "MYANMAR VOWEL SIGN TALL AA");
    map.put('\u102C', "MYANMAR VOWEL SIGN AA");
    map.put('\u102D', "MYANMAR VOWEL SIGN I");
    map.put('\u102E', "MYANMAR VOWEL SIGN II");
    map.put('\u102F', "MYANMAR VOWEL SIGN U");
    map.put('\u1030', "MYANMAR VOWEL SIGN UU");
    map.put('\u1031', "MYANMAR VOWEL SIGN E");
    map.put('\u1032', "MYANMAR VOWEL SIGN AI");
    map.put('\u1033', "MYANMAR VOWEL SIGN MON II");
    map.put('\u1034', "MYANMAR VOWEL SIGN MON O");
    map.put('\u1035', "MYANMAR VOWEL SIGN E ABOVE");
    map.put('\u1036', "MYANMAR SIGN ANUSVARA");
    map.put('\u1037', "MYANMAR SIGN DOT BELOW");
    map.put('\u1038', "MYANMAR SIGN VISARGA");
    map.put('\u1039', "MYANMAR SIGN VIRAMA");
    map.put('\u103A', "MYANMAR SIGN ASAT");
    map.put('\u103B', "MYANMAR CONSONANT SIGN MEDIAL YA");
    map.put('\u103C', "MYANMAR CONSONANT SIGN MEDIAL RA");
    map.put('\u103D', "MYANMAR CONSONANT SIGN MEDIAL WA");
    map.put('\u103E', "MYANMAR CONSONANT SIGN MEDIAL HA");
    map.put('\u103F', "MYANMAR LETTER GREAT SA");
    map.put('\u1040', "MYANMAR DIGIT ZERO");
    map.put('\u1041', "MYANMAR DIGIT ONE");
    map.put('\u1042', "MYANMAR DIGIT TWO");
    map.put('\u1043', "MYANMAR DIGIT THREE");
    map.put('\u1044', "MYANMAR DIGIT FOUR");
    map.put('\u1045', "MYANMAR DIGIT FIVE");
    map.put('\u1046', "MYANMAR DIGIT SIX");
    map.put('\u1047', "MYANMAR DIGIT SEVEN");
    map.put('\u1048', "MYANMAR DIGIT EIGHT");
    map.put('\u1049', "MYANMAR DIGIT NINE");
    map.put('\u104A', "MYANMAR SIGN LITTLE SECTION");
    map.put('\u104B', "MYANMAR SIGN SECTION");
    map.put('\u104C', "MYANMAR SYMBOL LOCATIVE");
    map.put('\u104D', "MYANMAR SYMBOL COMPLETED");
    map.put('\u104E', "MYANMAR SYMBOL AFOREMENTIONED");
    map.put('\u104F', "MYANMAR SYMBOL GENITIVE");
    map.put('\u1050', "MYANMAR LETTER SHA");
    map.put('\u1051', "MYANMAR LETTER SSA");
    map.put('\u1052', "MYANMAR LETTER VOCALIC R");
    map.put('\u1053', "MYANMAR LETTER VOCALIC RR");
    map.put('\u1054', "MYANMAR LETTER VOCALIC L");
    map.put('\u1055', "MYANMAR LETTER VOCALIC LL");
    map.put('\u1056', "MYANMAR VOWEL SIGN VOCALIC R");
    map.put('\u1057', "MYANMAR VOWEL SIGN VOCALIC RR");
    map.put('\u1058', "MYANMAR VOWEL SIGN VOCALIC L");
    map.put('\u1059', "MYANMAR VOWEL SIGN VOCALIC LL");
    map.put('\u105A', "MYANMAR LETTER MON NGA");
    map.put('\u105B', "MYANMAR LETTER MON JHA");
    map.put('\u105C', "MYANMAR LETTER MON BBA");
    map.put('\u105D', "MYANMAR LETTER MON BBE");
    map.put('\u105E', "MYANMAR CONSONANT SIGN MON MEDIAL NA");
    map.put('\u105F', "MYANMAR CONSONANT SIGN MON MEDIAL MA");
    map.put('\u1060', "MYANMAR CONSONANT SIGN MON MEDIAL LA");
    map.put('\u1061', "MYANMAR LETTER SGAW KAREN SHA");
    map.put('\u1062', "MYANMAR VOWEL SIGN SGAW KAREN EU");
    map.put('\u1063', "MYANMAR TONE MARK SGAW KAREN HATHI");
    map.put('\u1064', "MYANMAR TONE MARK SGAW KAREN KE PHO");
    map.put('\u1065', "MYANMAR LETTER WESTERN PWO KAREN THA");
    map.put('\u1066', "MYANMAR LETTER WESTERN PWO KAREN PWA");
    map.put('\u1067', "MYANMAR VOWEL SIGN WESTERN PWO KAREN EU");
    map.put('\u1068', "MYANMAR VOWEL SIGN WESTERN PWO KAREN UE");
    map.put('\u1069', "MYANMAR SIGN WESTERN PWO KAREN TONE-1");
    map.put('\u106A', "MYANMAR SIGN WESTERN PWO KAREN TONE-2");
    map.put('\u106B', "MYANMAR SIGN WESTERN PWO KAREN TONE-3");
    map.put('\u106C', "MYANMAR SIGN WESTERN PWO KAREN TONE-4");
    map.put('\u106D', "MYANMAR SIGN WESTERN PWO KAREN TONE-5");
    map.put('\u106E', "MYANMAR LETTER EASTERN PWO KAREN NNA");
    map.put('\u106F', "MYANMAR LETTER EASTERN PWO KAREN YWA");
    map.put('\u1070', "MYANMAR LETTER EASTERN PWO KAREN GHWA");
    map.put('\u1071', "MYANMAR VOWEL SIGN GEBA KAREN I");
    map.put('\u1072', "MYANMAR VOWEL SIGN KAYAH OE");
    map.put('\u1073', "MYANMAR VOWEL SIGN KAYAH U");
    map.put('\u1074', "MYANMAR VOWEL SIGN KAYAH EE");
    map.put('\u1075', "MYANMAR LETTER SHAN KA");
    map.put('\u1076', "MYANMAR LETTER SHAN KHA");
    map.put('\u1077', "MYANMAR LETTER SHAN GA");
    map.put('\u1078', "MYANMAR LETTER SHAN CA");
    map.put('\u1079', "MYANMAR LETTER SHAN ZA");
    map.put('\u107A', "MYANMAR LETTER SHAN NYA");
    map.put('\u107B', "MYANMAR LETTER SHAN DA");
    map.put('\u107C', "MYANMAR LETTER SHAN NA");
    map.put('\u107D', "MYANMAR LETTER SHAN PHA");
    map.put('\u107E', "MYANMAR LETTER SHAN FA");
    map.put('\u107F', "MYANMAR LETTER SHAN BA");
    map.put('\u1080', "MYANMAR LETTER SHAN THA");
    map.put('\u1081', "MYANMAR LETTER SHAN HA");
    map.put('\u1082', "MYANMAR CONSONANT SIGN SHAN MEDIAL WA");
    map.put('\u1083', "MYANMAR VOWEL SIGN SHAN AA");
    map.put('\u1084', "MYANMAR VOWEL SIGN SHAN E");
    map.put('\u1085', "MYANMAR VOWEL SIGN SHAN E ABOVE");
    map.put('\u1086', "MYANMAR VOWEL SIGN SHAN FINAL Y");
    map.put('\u1087', "MYANMAR SIGN SHAN TONE-2");
    map.put('\u1088', "MYANMAR SIGN SHAN TONE-3");
    map.put('\u1089', "MYANMAR SIGN SHAN TONE-5");
    map.put('\u108A', "MYANMAR SIGN SHAN TONE-6");
    map.put('\u108B', "MYANMAR SIGN SHAN COUNCIL TONE-2");
    map.put('\u108C', "MYANMAR SIGN SHAN COUNCIL TONE-3");
    map.put('\u108D', "MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE");
    map.put('\u108E', "MYANMAR LETTER RUMAI PALAUNG FA");
    map.put('\u108F', "MYANMAR SIGN RUMAI PALAUNG TONE-5");
    map.put('\u1090', "MYANMAR SHAN DIGIT ZERO");
    map.put('\u1091', "MYANMAR SHAN DIGIT ONE");
    map.put('\u1092', "MYANMAR SHAN DIGIT TWO");
    map.put('\u1093', "MYANMAR SHAN DIGIT THREE");
    map.put('\u1094', "MYANMAR SHAN DIGIT FOUR");
    map.put('\u1095', "MYANMAR SHAN DIGIT FIVE");
    map.put('\u1096', "MYANMAR SHAN DIGIT SIX");
    map.put('\u1097', "MYANMAR SHAN DIGIT SEVEN");
    map.put('\u1098', "MYANMAR SHAN DIGIT EIGHT");
    map.put('\u1099', "MYANMAR SHAN DIGIT NINE");
    map.put('\u109A', "MYANMAR SIGN KHAMTI TONE-1");
    map.put('\u109B', "MYANMAR SIGN KHAMTI TONE-3");
    map.put('\u109C', "MYANMAR VOWEL SIGN AITON A");
    map.put('\u109D', "MYANMAR VOWEL SIGN AITON AI");
    map.put('\u109E', "MYANMAR SYMBOL SHAN ONE");
    map.put('\u109F', "MYANMAR SYMBOL SHAN EXCLAMATION");

  }

  public static final void georgian(Map<Character, String> map) {

    map.put('\u10A0', "GEORGIAN CAPITAL LETTER AN");
    map.put('\u10A1', "GEORGIAN CAPITAL LETTER BAN");
    map.put('\u10A2', "GEORGIAN CAPITAL LETTER GAN");
    map.put('\u10A3', "GEORGIAN CAPITAL LETTER DON");
    map.put('\u10A4', "GEORGIAN CAPITAL LETTER EN");
    map.put('\u10A5', "GEORGIAN CAPITAL LETTER VIN");
    map.put('\u10A6', "GEORGIAN CAPITAL LETTER ZEN");
    map.put('\u10A7', "GEORGIAN CAPITAL LETTER TAN");
    map.put('\u10A8', "GEORGIAN CAPITAL LETTER IN");
    map.put('\u10A9', "GEORGIAN CAPITAL LETTER KAN");
    map.put('\u10AA', "GEORGIAN CAPITAL LETTER LAS");
    map.put('\u10AB', "GEORGIAN CAPITAL LETTER MAN");
    map.put('\u10AC', "GEORGIAN CAPITAL LETTER NAR");
    map.put('\u10AD', "GEORGIAN CAPITAL LETTER ON");
    map.put('\u10AE', "GEORGIAN CAPITAL LETTER PAR");
    map.put('\u10AF', "GEORGIAN CAPITAL LETTER ZHAR");
    map.put('\u10B0', "GEORGIAN CAPITAL LETTER RAE");
    map.put('\u10B1', "GEORGIAN CAPITAL LETTER SAN");
    map.put('\u10B2', "GEORGIAN CAPITAL LETTER TAR");
    map.put('\u10B3', "GEORGIAN CAPITAL LETTER UN");
    map.put('\u10B4', "GEORGIAN CAPITAL LETTER PHAR");
    map.put('\u10B5', "GEORGIAN CAPITAL LETTER KHAR");
    map.put('\u10B6', "GEORGIAN CAPITAL LETTER GHAN");
    map.put('\u10B7', "GEORGIAN CAPITAL LETTER QAR");
    map.put('\u10B8', "GEORGIAN CAPITAL LETTER SHIN");
    map.put('\u10B9', "GEORGIAN CAPITAL LETTER CHIN");
    map.put('\u10BA', "GEORGIAN CAPITAL LETTER CAN");
    map.put('\u10BB', "GEORGIAN CAPITAL LETTER JIL");
    map.put('\u10BC', "GEORGIAN CAPITAL LETTER CIL");
    map.put('\u10BD', "GEORGIAN CAPITAL LETTER CHAR");
    map.put('\u10BE', "GEORGIAN CAPITAL LETTER XAN");
    map.put('\u10BF', "GEORGIAN CAPITAL LETTER JHAN");
    map.put('\u10C0', "GEORGIAN CAPITAL LETTER HAE");
    map.put('\u10C1', "GEORGIAN CAPITAL LETTER HE");
    map.put('\u10C2', "GEORGIAN CAPITAL LETTER HIE");
    map.put('\u10C3', "GEORGIAN CAPITAL LETTER WE");
    map.put('\u10C4', "GEORGIAN CAPITAL LETTER HAR");
    map.put('\u10C5', "GEORGIAN CAPITAL LETTER HOE");
    map.put('\u10D0', "GEORGIAN LETTER AN");
    map.put('\u10D1', "GEORGIAN LETTER BAN");
    map.put('\u10D2', "GEORGIAN LETTER GAN");
    map.put('\u10D3', "GEORGIAN LETTER DON");
    map.put('\u10D4', "GEORGIAN LETTER EN");
    map.put('\u10D5', "GEORGIAN LETTER VIN");
    map.put('\u10D6', "GEORGIAN LETTER ZEN");
    map.put('\u10D7', "GEORGIAN LETTER TAN");
    map.put('\u10D8', "GEORGIAN LETTER IN");
    map.put('\u10D9', "GEORGIAN LETTER KAN");
    map.put('\u10DA', "GEORGIAN LETTER LAS");
    map.put('\u10DB', "GEORGIAN LETTER MAN");
    map.put('\u10DC', "GEORGIAN LETTER NAR");
    map.put('\u10DD', "GEORGIAN LETTER ON");
    map.put('\u10DE', "GEORGIAN LETTER PAR");
    map.put('\u10DF', "GEORGIAN LETTER ZHAR");
    map.put('\u10E0', "GEORGIAN LETTER RAE");
    map.put('\u10E1', "GEORGIAN LETTER SAN");
    map.put('\u10E2', "GEORGIAN LETTER TAR");
    map.put('\u10E3', "GEORGIAN LETTER UN");
    map.put('\u10E4', "GEORGIAN LETTER PHAR");
    map.put('\u10E5', "GEORGIAN LETTER KHAR");
    map.put('\u10E6', "GEORGIAN LETTER GHAN");
    map.put('\u10E7', "GEORGIAN LETTER QAR");
    map.put('\u10E8', "GEORGIAN LETTER SHIN");
    map.put('\u10E9', "GEORGIAN LETTER CHIN");
    map.put('\u10EA', "GEORGIAN LETTER CAN");
    map.put('\u10EB', "GEORGIAN LETTER JIL");
    map.put('\u10EC', "GEORGIAN LETTER CIL");
    map.put('\u10ED', "GEORGIAN LETTER CHAR");
    map.put('\u10EE', "GEORGIAN LETTER XAN");
    map.put('\u10EF', "GEORGIAN LETTER JHAN");
    map.put('\u10F0', "GEORGIAN LETTER HAE");
    map.put('\u10F1', "GEORGIAN LETTER HE");
    map.put('\u10F2', "GEORGIAN LETTER HIE");
    map.put('\u10F3', "GEORGIAN LETTER WE");
    map.put('\u10F4', "GEORGIAN LETTER HAR");
    map.put('\u10F5', "GEORGIAN LETTER HOE");
    map.put('\u10F6', "GEORGIAN LETTER FI");
    map.put('\u10F7', "GEORGIAN LETTER YN");
    map.put('\u10F8', "GEORGIAN LETTER ELIFI");
    map.put('\u10F9', "GEORGIAN LETTER TURNED GAN");
    map.put('\u10FA', "GEORGIAN LETTER AIN");
    map.put('\u10FB', "GEORGIAN PARAGRAPH SEPARATOR");
    map.put('\u10FC', "MODIFIER LETTER GEORGIAN NAR");

  }

  public static final void hangulJamo(Map<Character, String> map) {

    map.put('\u1100', "HANGUL CHOSEONG KIYEOK");
    map.put('\u1101', "HANGUL CHOSEONG SSANGKIYEOK");
    map.put('\u1102', "HANGUL CHOSEONG NIEUN");
    map.put('\u1103', "HANGUL CHOSEONG TIKEUT");
    map.put('\u1104', "HANGUL CHOSEONG SSANGTIKEUT");
    map.put('\u1105', "HANGUL CHOSEONG RIEUL");
    map.put('\u1106', "HANGUL CHOSEONG MIEUM");
    map.put('\u1107', "HANGUL CHOSEONG PIEUP");
    map.put('\u1108', "HANGUL CHOSEONG SSANGPIEUP");
    map.put('\u1109', "HANGUL CHOSEONG SIOS");
    map.put('\u110A', "HANGUL CHOSEONG SSANGSIOS");
    map.put('\u110B', "HANGUL CHOSEONG IEUNG");
    map.put('\u110C', "HANGUL CHOSEONG CIEUC");
    map.put('\u110D', "HANGUL CHOSEONG SSANGCIEUC");
    map.put('\u110E', "HANGUL CHOSEONG CHIEUCH");
    map.put('\u110F', "HANGUL CHOSEONG KHIEUKH");
    map.put('\u1110', "HANGUL CHOSEONG THIEUTH");
    map.put('\u1111', "HANGUL CHOSEONG PHIEUPH");
    map.put('\u1112', "HANGUL CHOSEONG HIEUH");
    map.put('\u1113', "HANGUL CHOSEONG NIEUN-KIYEOK");
    map.put('\u1114', "HANGUL CHOSEONG SSANGNIEUN");
    map.put('\u1115', "HANGUL CHOSEONG NIEUN-TIKEUT");
    map.put('\u1116', "HANGUL CHOSEONG NIEUN-PIEUP");
    map.put('\u1117', "HANGUL CHOSEONG TIKEUT-KIYEOK");
    map.put('\u1118', "HANGUL CHOSEONG RIEUL-NIEUN");
    map.put('\u1119', "HANGUL CHOSEONG SSANGRIEUL");
    map.put('\u111A', "HANGUL CHOSEONG RIEUL-HIEUH");
    map.put('\u111B', "HANGUL CHOSEONG KAPYEOUNRIEUL");
    map.put('\u111C', "HANGUL CHOSEONG MIEUM-PIEUP");
    map.put('\u111D', "HANGUL CHOSEONG KAPYEOUNMIEUM");
    map.put('\u111E', "HANGUL CHOSEONG PIEUP-KIYEOK");
    map.put('\u111F', "HANGUL CHOSEONG PIEUP-NIEUN");
    map.put('\u1120', "HANGUL CHOSEONG PIEUP-TIKEUT");
    map.put('\u1121', "HANGUL CHOSEONG PIEUP-SIOS");
    map.put('\u1122', "HANGUL CHOSEONG PIEUP-SIOS-KIYEOK");
    map.put('\u1123', "HANGUL CHOSEONG PIEUP-SIOS-TIKEUT");
    map.put('\u1124', "HANGUL CHOSEONG PIEUP-SIOS-PIEUP");
    map.put('\u1125', "HANGUL CHOSEONG PIEUP-SSANGSIOS");
    map.put('\u1126', "HANGUL CHOSEONG PIEUP-SIOS-CIEUC");
    map.put('\u1127', "HANGUL CHOSEONG PIEUP-CIEUC");
    map.put('\u1128', "HANGUL CHOSEONG PIEUP-CHIEUCH");
    map.put('\u1129', "HANGUL CHOSEONG PIEUP-THIEUTH");
    map.put('\u112A', "HANGUL CHOSEONG PIEUP-PHIEUPH");
    map.put('\u112B', "HANGUL CHOSEONG KAPYEOUNPIEUP");
    map.put('\u112C', "HANGUL CHOSEONG KAPYEOUNSSANGPIEUP");
    map.put('\u112D', "HANGUL CHOSEONG SIOS-KIYEOK");
    map.put('\u112E', "HANGUL CHOSEONG SIOS-NIEUN");
    map.put('\u112F', "HANGUL CHOSEONG SIOS-TIKEUT");
    map.put('\u1130', "HANGUL CHOSEONG SIOS-RIEUL");
    map.put('\u1131', "HANGUL CHOSEONG SIOS-MIEUM");
    map.put('\u1132', "HANGUL CHOSEONG SIOS-PIEUP");
    map.put('\u1133', "HANGUL CHOSEONG SIOS-PIEUP-KIYEOK");
    map.put('\u1134', "HANGUL CHOSEONG SIOS-SSANGSIOS");
    map.put('\u1135', "HANGUL CHOSEONG SIOS-IEUNG");
    map.put('\u1136', "HANGUL CHOSEONG SIOS-CIEUC");
    map.put('\u1137', "HANGUL CHOSEONG SIOS-CHIEUCH");
    map.put('\u1138', "HANGUL CHOSEONG SIOS-KHIEUKH");
    map.put('\u1139', "HANGUL CHOSEONG SIOS-THIEUTH");
    map.put('\u113A', "HANGUL CHOSEONG SIOS-PHIEUPH");
    map.put('\u113B', "HANGUL CHOSEONG SIOS-HIEUH");
    map.put('\u113C', "HANGUL CHOSEONG CHITUEUMSIOS");
    map.put('\u113D', "HANGUL CHOSEONG CHITUEUMSSANGSIOS");
    map.put('\u113E', "HANGUL CHOSEONG CEONGCHIEUMSIOS");
    map.put('\u113F', "HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS");
    map.put('\u1140', "HANGUL CHOSEONG PANSIOS");
    map.put('\u1141', "HANGUL CHOSEONG IEUNG-KIYEOK");
    map.put('\u1142', "HANGUL CHOSEONG IEUNG-TIKEUT");
    map.put('\u1143', "HANGUL CHOSEONG IEUNG-MIEUM");
    map.put('\u1144', "HANGUL CHOSEONG IEUNG-PIEUP");
    map.put('\u1145', "HANGUL CHOSEONG IEUNG-SIOS");
    map.put('\u1146', "HANGUL CHOSEONG IEUNG-PANSIOS");
    map.put('\u1147', "HANGUL CHOSEONG SSANGIEUNG");
    map.put('\u1148', "HANGUL CHOSEONG IEUNG-CIEUC");
    map.put('\u1149', "HANGUL CHOSEONG IEUNG-CHIEUCH");
    map.put('\u114A', "HANGUL CHOSEONG IEUNG-THIEUTH");
    map.put('\u114B', "HANGUL CHOSEONG IEUNG-PHIEUPH");
    map.put('\u114C', "HANGUL CHOSEONG YESIEUNG");
    map.put('\u114D', "HANGUL CHOSEONG CIEUC-IEUNG");
    map.put('\u114E', "HANGUL CHOSEONG CHITUEUMCIEUC");
    map.put('\u114F', "HANGUL CHOSEONG CHITUEUMSSANGCIEUC");
    map.put('\u1150', "HANGUL CHOSEONG CEONGCHIEUMCIEUC");
    map.put('\u1151', "HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC");
    map.put('\u1152', "HANGUL CHOSEONG CHIEUCH-KHIEUKH");
    map.put('\u1153', "HANGUL CHOSEONG CHIEUCH-HIEUH");
    map.put('\u1154', "HANGUL CHOSEONG CHITUEUMCHIEUCH");
    map.put('\u1155', "HANGUL CHOSEONG CEONGCHIEUMCHIEUCH");
    map.put('\u1156', "HANGUL CHOSEONG PHIEUPH-PIEUP");
    map.put('\u1157', "HANGUL CHOSEONG KAPYEOUNPHIEUPH");
    map.put('\u1158', "HANGUL CHOSEONG SSANGHIEUH");
    map.put('\u1159', "HANGUL CHOSEONG YEORINHIEUH");
    map.put('\u115A', "HANGUL CHOSEONG KIYEOK-TIKEUT");
    map.put('\u115B', "HANGUL CHOSEONG NIEUN-SIOS");
    map.put('\u115C', "HANGUL CHOSEONG NIEUN-CIEUC");
    map.put('\u115D', "HANGUL CHOSEONG NIEUN-HIEUH");
    map.put('\u115E', "HANGUL CHOSEONG TIKEUT-RIEUL");
    map.put('\u115F', "HANGUL CHOSEONG FILLER");
    map.put('\u1160', "HANGUL JUNGSEONG FILLER");
    map.put('\u1161', "HANGUL JUNGSEONG A");
    map.put('\u1162', "HANGUL JUNGSEONG AE");
    map.put('\u1163', "HANGUL JUNGSEONG YA");
    map.put('\u1164', "HANGUL JUNGSEONG YAE");
    map.put('\u1165', "HANGUL JUNGSEONG EO");
    map.put('\u1166', "HANGUL JUNGSEONG E");
    map.put('\u1167', "HANGUL JUNGSEONG YEO");
    map.put('\u1168', "HANGUL JUNGSEONG YE");
    map.put('\u1169', "HANGUL JUNGSEONG O");
    map.put('\u116A', "HANGUL JUNGSEONG WA");
    map.put('\u116B', "HANGUL JUNGSEONG WAE");
    map.put('\u116C', "HANGUL JUNGSEONG OE");
    map.put('\u116D', "HANGUL JUNGSEONG YO");
    map.put('\u116E', "HANGUL JUNGSEONG U");
    map.put('\u116F', "HANGUL JUNGSEONG WEO");
    map.put('\u1170', "HANGUL JUNGSEONG WE");
    map.put('\u1171', "HANGUL JUNGSEONG WI");
    map.put('\u1172', "HANGUL JUNGSEONG YU");
    map.put('\u1173', "HANGUL JUNGSEONG EU");
    map.put('\u1174', "HANGUL JUNGSEONG YI");
    map.put('\u1175', "HANGUL JUNGSEONG I");
    map.put('\u1176', "HANGUL JUNGSEONG A-O");
    map.put('\u1177', "HANGUL JUNGSEONG A-U");
    map.put('\u1178', "HANGUL JUNGSEONG YA-O");
    map.put('\u1179', "HANGUL JUNGSEONG YA-YO");
    map.put('\u117A', "HANGUL JUNGSEONG EO-O");
    map.put('\u117B', "HANGUL JUNGSEONG EO-U");
    map.put('\u117C', "HANGUL JUNGSEONG EO-EU");
    map.put('\u117D', "HANGUL JUNGSEONG YEO-O");
    map.put('\u117E', "HANGUL JUNGSEONG YEO-U");
    map.put('\u117F', "HANGUL JUNGSEONG O-EO");
    map.put('\u1180', "HANGUL JUNGSEONG O-E");
    map.put('\u1181', "HANGUL JUNGSEONG O-YE");
    map.put('\u1182', "HANGUL JUNGSEONG O-O");
    map.put('\u1183', "HANGUL JUNGSEONG O-U");
    map.put('\u1184', "HANGUL JUNGSEONG YO-YA");
    map.put('\u1185', "HANGUL JUNGSEONG YO-YAE");
    map.put('\u1186', "HANGUL JUNGSEONG YO-YEO");
    map.put('\u1187', "HANGUL JUNGSEONG YO-O");
    map.put('\u1188', "HANGUL JUNGSEONG YO-I");
    map.put('\u1189', "HANGUL JUNGSEONG U-A");
    map.put('\u118A', "HANGUL JUNGSEONG U-AE");
    map.put('\u118B', "HANGUL JUNGSEONG U-EO-EU");
    map.put('\u118C', "HANGUL JUNGSEONG U-YE");
    map.put('\u118D', "HANGUL JUNGSEONG U-U");
    map.put('\u118E', "HANGUL JUNGSEONG YU-A");
    map.put('\u118F', "HANGUL JUNGSEONG YU-EO");
    map.put('\u1190', "HANGUL JUNGSEONG YU-E");
    map.put('\u1191', "HANGUL JUNGSEONG YU-YEO");
    map.put('\u1192', "HANGUL JUNGSEONG YU-YE");
    map.put('\u1193', "HANGUL JUNGSEONG YU-U");
    map.put('\u1194', "HANGUL JUNGSEONG YU-I");
    map.put('\u1195', "HANGUL JUNGSEONG EU-U");
    map.put('\u1196', "HANGUL JUNGSEONG EU-EU");
    map.put('\u1197', "HANGUL JUNGSEONG YI-U");
    map.put('\u1198', "HANGUL JUNGSEONG I-A");
    map.put('\u1199', "HANGUL JUNGSEONG I-YA");
    map.put('\u119A', "HANGUL JUNGSEONG I-O");
    map.put('\u119B', "HANGUL JUNGSEONG I-U");
    map.put('\u119C', "HANGUL JUNGSEONG I-EU");
    map.put('\u119D', "HANGUL JUNGSEONG I-ARAEA");
    map.put('\u119E', "HANGUL JUNGSEONG ARAEA");
    map.put('\u119F', "HANGUL JUNGSEONG ARAEA-EO");
    map.put('\u11A0', "HANGUL JUNGSEONG ARAEA-U");
    map.put('\u11A1', "HANGUL JUNGSEONG ARAEA-I");
    map.put('\u11A2', "HANGUL JUNGSEONG SSANGARAEA");
    map.put('\u11A3', "HANGUL JUNGSEONG A-EU");
    map.put('\u11A4', "HANGUL JUNGSEONG YA-U");
    map.put('\u11A5', "HANGUL JUNGSEONG YEO-YA");
    map.put('\u11A6', "HANGUL JUNGSEONG O-YA");
    map.put('\u11A7', "HANGUL JUNGSEONG O-YAE");
    map.put('\u11A8', "HANGUL JONGSEONG KIYEOK");
    map.put('\u11A9', "HANGUL JONGSEONG SSANGKIYEOK");
    map.put('\u11AA', "HANGUL JONGSEONG KIYEOK-SIOS");
    map.put('\u11AB', "HANGUL JONGSEONG NIEUN");
    map.put('\u11AC', "HANGUL JONGSEONG NIEUN-CIEUC");
    map.put('\u11AD', "HANGUL JONGSEONG NIEUN-HIEUH");
    map.put('\u11AE', "HANGUL JONGSEONG TIKEUT");
    map.put('\u11AF', "HANGUL JONGSEONG RIEUL");
    map.put('\u11B0', "HANGUL JONGSEONG RIEUL-KIYEOK");
    map.put('\u11B1', "HANGUL JONGSEONG RIEUL-MIEUM");
    map.put('\u11B2', "HANGUL JONGSEONG RIEUL-PIEUP");
    map.put('\u11B3', "HANGUL JONGSEONG RIEUL-SIOS");
    map.put('\u11B4', "HANGUL JONGSEONG RIEUL-THIEUTH");
    map.put('\u11B5', "HANGUL JONGSEONG RIEUL-PHIEUPH");
    map.put('\u11B6', "HANGUL JONGSEONG RIEUL-HIEUH");
    map.put('\u11B7', "HANGUL JONGSEONG MIEUM");
    map.put('\u11B8', "HANGUL JONGSEONG PIEUP");
    map.put('\u11B9', "HANGUL JONGSEONG PIEUP-SIOS");
    map.put('\u11BA', "HANGUL JONGSEONG SIOS");
    map.put('\u11BB', "HANGUL JONGSEONG SSANGSIOS");
    map.put('\u11BC', "HANGUL JONGSEONG IEUNG");
    map.put('\u11BD', "HANGUL JONGSEONG CIEUC");
    map.put('\u11BE', "HANGUL JONGSEONG CHIEUCH");
    map.put('\u11BF', "HANGUL JONGSEONG KHIEUKH");
    map.put('\u11C0', "HANGUL JONGSEONG THIEUTH");
    map.put('\u11C1', "HANGUL JONGSEONG PHIEUPH");
    map.put('\u11C2', "HANGUL JONGSEONG HIEUH");
    map.put('\u11C3', "HANGUL JONGSEONG KIYEOK-RIEUL");
    map.put('\u11C4', "HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK");
    map.put('\u11C5', "HANGUL JONGSEONG NIEUN-KIYEOK");
    map.put('\u11C6', "HANGUL JONGSEONG NIEUN-TIKEUT");
    map.put('\u11C7', "HANGUL JONGSEONG NIEUN-SIOS");
    map.put('\u11C8', "HANGUL JONGSEONG NIEUN-PANSIOS");
    map.put('\u11C9', "HANGUL JONGSEONG NIEUN-THIEUTH");
    map.put('\u11CA', "HANGUL JONGSEONG TIKEUT-KIYEOK");
    map.put('\u11CB', "HANGUL JONGSEONG TIKEUT-RIEUL");
    map.put('\u11CC', "HANGUL JONGSEONG RIEUL-KIYEOK-SIOS");
    map.put('\u11CD', "HANGUL JONGSEONG RIEUL-NIEUN");
    map.put('\u11CE', "HANGUL JONGSEONG RIEUL-TIKEUT");
    map.put('\u11CF', "HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH");
    map.put('\u11D0', "HANGUL JONGSEONG SSANGRIEUL");
    map.put('\u11D1', "HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK");
    map.put('\u11D2', "HANGUL JONGSEONG RIEUL-MIEUM-SIOS");
    map.put('\u11D3', "HANGUL JONGSEONG RIEUL-PIEUP-SIOS");
    map.put('\u11D4', "HANGUL JONGSEONG RIEUL-PIEUP-HIEUH");
    map.put('\u11D5', "HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP");
    map.put('\u11D6', "HANGUL JONGSEONG RIEUL-SSANGSIOS");
    map.put('\u11D7', "HANGUL JONGSEONG RIEUL-PANSIOS");
    map.put('\u11D8', "HANGUL JONGSEONG RIEUL-KHIEUKH");
    map.put('\u11D9', "HANGUL JONGSEONG RIEUL-YEORINHIEUH");
    map.put('\u11DA', "HANGUL JONGSEONG MIEUM-KIYEOK");
    map.put('\u11DB', "HANGUL JONGSEONG MIEUM-RIEUL");
    map.put('\u11DC', "HANGUL JONGSEONG MIEUM-PIEUP");
    map.put('\u11DD', "HANGUL JONGSEONG MIEUM-SIOS");
    map.put('\u11DE', "HANGUL JONGSEONG MIEUM-SSANGSIOS");
    map.put('\u11DF', "HANGUL JONGSEONG MIEUM-PANSIOS");
    map.put('\u11E0', "HANGUL JONGSEONG MIEUM-CHIEUCH");
    map.put('\u11E1', "HANGUL JONGSEONG MIEUM-HIEUH");
    map.put('\u11E2', "HANGUL JONGSEONG KAPYEOUNMIEUM");
    map.put('\u11E3', "HANGUL JONGSEONG PIEUP-RIEUL");
    map.put('\u11E4', "HANGUL JONGSEONG PIEUP-PHIEUPH");
    map.put('\u11E5', "HANGUL JONGSEONG PIEUP-HIEUH");
    map.put('\u11E6', "HANGUL JONGSEONG KAPYEOUNPIEUP");
    map.put('\u11E7', "HANGUL JONGSEONG SIOS-KIYEOK");
    map.put('\u11E8', "HANGUL JONGSEONG SIOS-TIKEUT");
    map.put('\u11E9', "HANGUL JONGSEONG SIOS-RIEUL");
    map.put('\u11EA', "HANGUL JONGSEONG SIOS-PIEUP");
    map.put('\u11EB', "HANGUL JONGSEONG PANSIOS");
    map.put('\u11EC', "HANGUL JONGSEONG IEUNG-KIYEOK");
    map.put('\u11ED', "HANGUL JONGSEONG IEUNG-SSANGKIYEOK");
    map.put('\u11EE', "HANGUL JONGSEONG SSANGIEUNG");
    map.put('\u11EF', "HANGUL JONGSEONG IEUNG-KHIEUKH");
    map.put('\u11F0', "HANGUL JONGSEONG YESIEUNG");
    map.put('\u11F1', "HANGUL JONGSEONG YESIEUNG-SIOS");
    map.put('\u11F2', "HANGUL JONGSEONG YESIEUNG-PANSIOS");
    map.put('\u11F3', "HANGUL JONGSEONG PHIEUPH-PIEUP");
    map.put('\u11F4', "HANGUL JONGSEONG KAPYEOUNPHIEUPH");
    map.put('\u11F5', "HANGUL JONGSEONG HIEUH-NIEUN");
    map.put('\u11F6', "HANGUL JONGSEONG HIEUH-RIEUL");
    map.put('\u11F7', "HANGUL JONGSEONG HIEUH-MIEUM");
    map.put('\u11F8', "HANGUL JONGSEONG HIEUH-PIEUP");
    map.put('\u11F9', "HANGUL JONGSEONG YEORINHIEUH");
    map.put('\u11FA', "HANGUL JONGSEONG KIYEOK-NIEUN");
    map.put('\u11FB', "HANGUL JONGSEONG KIYEOK-PIEUP");
    map.put('\u11FC', "HANGUL JONGSEONG KIYEOK-CHIEUCH");
    map.put('\u11FD', "HANGUL JONGSEONG KIYEOK-KHIEUKH");
    map.put('\u11FE', "HANGUL JONGSEONG KIYEOK-HIEUH");
    map.put('\u11FF', "HANGUL JONGSEONG SSANGNIEUN");

  }

  public static final void ethiopic(Map<Character, String> map) {

    map.put('\u1200', "ETHIOPIC SYLLABLE HA");
    map.put('\u1201', "ETHIOPIC SYLLABLE HU");
    map.put('\u1202', "ETHIOPIC SYLLABLE HI");
    map.put('\u1203', "ETHIOPIC SYLLABLE HAA");
    map.put('\u1204', "ETHIOPIC SYLLABLE HEE");
    map.put('\u1205', "ETHIOPIC SYLLABLE HE");
    map.put('\u1206', "ETHIOPIC SYLLABLE HO");
    map.put('\u1207', "ETHIOPIC SYLLABLE HOA");
    map.put('\u1208', "ETHIOPIC SYLLABLE LA");
    map.put('\u1209', "ETHIOPIC SYLLABLE LU");
    map.put('\u120A', "ETHIOPIC SYLLABLE LI");
    map.put('\u120B', "ETHIOPIC SYLLABLE LAA");
    map.put('\u120C', "ETHIOPIC SYLLABLE LEE");
    map.put('\u120D', "ETHIOPIC SYLLABLE LE");
    map.put('\u120E', "ETHIOPIC SYLLABLE LO");
    map.put('\u120F', "ETHIOPIC SYLLABLE LWA");
    map.put('\u1210', "ETHIOPIC SYLLABLE HHA");
    map.put('\u1211', "ETHIOPIC SYLLABLE HHU");
    map.put('\u1212', "ETHIOPIC SYLLABLE HHI");
    map.put('\u1213', "ETHIOPIC SYLLABLE HHAA");
    map.put('\u1214', "ETHIOPIC SYLLABLE HHEE");
    map.put('\u1215', "ETHIOPIC SYLLABLE HHE");
    map.put('\u1216', "ETHIOPIC SYLLABLE HHO");
    map.put('\u1217', "ETHIOPIC SYLLABLE HHWA");
    map.put('\u1218', "ETHIOPIC SYLLABLE MA");
    map.put('\u1219', "ETHIOPIC SYLLABLE MU");
    map.put('\u121A', "ETHIOPIC SYLLABLE MI");
    map.put('\u121B', "ETHIOPIC SYLLABLE MAA");
    map.put('\u121C', "ETHIOPIC SYLLABLE MEE");
    map.put('\u121D', "ETHIOPIC SYLLABLE ME");
    map.put('\u121E', "ETHIOPIC SYLLABLE MO");
    map.put('\u121F', "ETHIOPIC SYLLABLE MWA");
    map.put('\u1220', "ETHIOPIC SYLLABLE SZA");
    map.put('\u1221', "ETHIOPIC SYLLABLE SZU");
    map.put('\u1222', "ETHIOPIC SYLLABLE SZI");
    map.put('\u1223', "ETHIOPIC SYLLABLE SZAA");
    map.put('\u1224', "ETHIOPIC SYLLABLE SZEE");
    map.put('\u1225', "ETHIOPIC SYLLABLE SZE");
    map.put('\u1226', "ETHIOPIC SYLLABLE SZO");
    map.put('\u1227', "ETHIOPIC SYLLABLE SZWA");
    map.put('\u1228', "ETHIOPIC SYLLABLE RA");
    map.put('\u1229', "ETHIOPIC SYLLABLE RU");
    map.put('\u122A', "ETHIOPIC SYLLABLE RI");
    map.put('\u122B', "ETHIOPIC SYLLABLE RAA");
    map.put('\u122C', "ETHIOPIC SYLLABLE REE");
    map.put('\u122D', "ETHIOPIC SYLLABLE RE");
    map.put('\u122E', "ETHIOPIC SYLLABLE RO");
    map.put('\u122F', "ETHIOPIC SYLLABLE RWA");
    map.put('\u1230', "ETHIOPIC SYLLABLE SA");
    map.put('\u1231', "ETHIOPIC SYLLABLE SU");
    map.put('\u1232', "ETHIOPIC SYLLABLE SI");
    map.put('\u1233', "ETHIOPIC SYLLABLE SAA");
    map.put('\u1234', "ETHIOPIC SYLLABLE SEE");
    map.put('\u1235', "ETHIOPIC SYLLABLE SE");
    map.put('\u1236', "ETHIOPIC SYLLABLE SO");
    map.put('\u1237', "ETHIOPIC SYLLABLE SWA");
    map.put('\u1238', "ETHIOPIC SYLLABLE SHA");
    map.put('\u1239', "ETHIOPIC SYLLABLE SHU");
    map.put('\u123A', "ETHIOPIC SYLLABLE SHI");
    map.put('\u123B', "ETHIOPIC SYLLABLE SHAA");
    map.put('\u123C', "ETHIOPIC SYLLABLE SHEE");
    map.put('\u123D', "ETHIOPIC SYLLABLE SHE");
    map.put('\u123E', "ETHIOPIC SYLLABLE SHO");
    map.put('\u123F', "ETHIOPIC SYLLABLE SHWA");
    map.put('\u1240', "ETHIOPIC SYLLABLE QA");
    map.put('\u1241', "ETHIOPIC SYLLABLE QU");
    map.put('\u1242', "ETHIOPIC SYLLABLE QI");
    map.put('\u1243', "ETHIOPIC SYLLABLE QAA");
    map.put('\u1244', "ETHIOPIC SYLLABLE QEE");
    map.put('\u1245', "ETHIOPIC SYLLABLE QE");
    map.put('\u1246', "ETHIOPIC SYLLABLE QO");
    map.put('\u1247', "ETHIOPIC SYLLABLE QOA");
    map.put('\u1248', "ETHIOPIC SYLLABLE QWA");
    map.put('\u124A', "ETHIOPIC SYLLABLE QWI");
    map.put('\u124B', "ETHIOPIC SYLLABLE QWAA");
    map.put('\u124C', "ETHIOPIC SYLLABLE QWEE");
    map.put('\u124D', "ETHIOPIC SYLLABLE QWE");
    map.put('\u1250', "ETHIOPIC SYLLABLE QHA");
    map.put('\u1251', "ETHIOPIC SYLLABLE QHU");
    map.put('\u1252', "ETHIOPIC SYLLABLE QHI");
    map.put('\u1253', "ETHIOPIC SYLLABLE QHAA");
    map.put('\u1254', "ETHIOPIC SYLLABLE QHEE");
    map.put('\u1255', "ETHIOPIC SYLLABLE QHE");
    map.put('\u1256', "ETHIOPIC SYLLABLE QHO");
    map.put('\u1258', "ETHIOPIC SYLLABLE QHWA");
    map.put('\u125A', "ETHIOPIC SYLLABLE QHWI");
    map.put('\u125B', "ETHIOPIC SYLLABLE QHWAA");
    map.put('\u125C', "ETHIOPIC SYLLABLE QHWEE");
    map.put('\u125D', "ETHIOPIC SYLLABLE QHWE");
    map.put('\u1260', "ETHIOPIC SYLLABLE BA");
    map.put('\u1261', "ETHIOPIC SYLLABLE BU");
    map.put('\u1262', "ETHIOPIC SYLLABLE BI");
    map.put('\u1263', "ETHIOPIC SYLLABLE BAA");
    map.put('\u1264', "ETHIOPIC SYLLABLE BEE");
    map.put('\u1265', "ETHIOPIC SYLLABLE BE");
    map.put('\u1266', "ETHIOPIC SYLLABLE BO");
    map.put('\u1267', "ETHIOPIC SYLLABLE BWA");
    map.put('\u1268', "ETHIOPIC SYLLABLE VA");
    map.put('\u1269', "ETHIOPIC SYLLABLE VU");
    map.put('\u126A', "ETHIOPIC SYLLABLE VI");
    map.put('\u126B', "ETHIOPIC SYLLABLE VAA");
    map.put('\u126C', "ETHIOPIC SYLLABLE VEE");
    map.put('\u126D', "ETHIOPIC SYLLABLE VE");
    map.put('\u126E', "ETHIOPIC SYLLABLE VO");
    map.put('\u126F', "ETHIOPIC SYLLABLE VWA");
    map.put('\u1270', "ETHIOPIC SYLLABLE TA");
    map.put('\u1271', "ETHIOPIC SYLLABLE TU");
    map.put('\u1272', "ETHIOPIC SYLLABLE TI");
    map.put('\u1273', "ETHIOPIC SYLLABLE TAA");
    map.put('\u1274', "ETHIOPIC SYLLABLE TEE");
    map.put('\u1275', "ETHIOPIC SYLLABLE TE");
    map.put('\u1276', "ETHIOPIC SYLLABLE TO");
    map.put('\u1277', "ETHIOPIC SYLLABLE TWA");
    map.put('\u1278', "ETHIOPIC SYLLABLE CA");
    map.put('\u1279', "ETHIOPIC SYLLABLE CU");
    map.put('\u127A', "ETHIOPIC SYLLABLE CI");
    map.put('\u127B', "ETHIOPIC SYLLABLE CAA");
    map.put('\u127C', "ETHIOPIC SYLLABLE CEE");
    map.put('\u127D', "ETHIOPIC SYLLABLE CE");
    map.put('\u127E', "ETHIOPIC SYLLABLE CO");
    map.put('\u127F', "ETHIOPIC SYLLABLE CWA");
    map.put('\u1280', "ETHIOPIC SYLLABLE XA");
    map.put('\u1281', "ETHIOPIC SYLLABLE XU");
    map.put('\u1282', "ETHIOPIC SYLLABLE XI");
    map.put('\u1283', "ETHIOPIC SYLLABLE XAA");
    map.put('\u1284', "ETHIOPIC SYLLABLE XEE");
    map.put('\u1285', "ETHIOPIC SYLLABLE XE");
    map.put('\u1286', "ETHIOPIC SYLLABLE XO");
    map.put('\u1287', "ETHIOPIC SYLLABLE XOA");
    map.put('\u1288', "ETHIOPIC SYLLABLE XWA");
    map.put('\u128A', "ETHIOPIC SYLLABLE XWI");
    map.put('\u128B', "ETHIOPIC SYLLABLE XWAA");
    map.put('\u128C', "ETHIOPIC SYLLABLE XWEE");
    map.put('\u128D', "ETHIOPIC SYLLABLE XWE");
    map.put('\u1290', "ETHIOPIC SYLLABLE NA");
    map.put('\u1291', "ETHIOPIC SYLLABLE NU");
    map.put('\u1292', "ETHIOPIC SYLLABLE NI");
    map.put('\u1293', "ETHIOPIC SYLLABLE NAA");
    map.put('\u1294', "ETHIOPIC SYLLABLE NEE");
    map.put('\u1295', "ETHIOPIC SYLLABLE NE");
    map.put('\u1296', "ETHIOPIC SYLLABLE NO");
    map.put('\u1297', "ETHIOPIC SYLLABLE NWA");
    map.put('\u1298', "ETHIOPIC SYLLABLE NYA");
    map.put('\u1299', "ETHIOPIC SYLLABLE NYU");
    map.put('\u129A', "ETHIOPIC SYLLABLE NYI");
    map.put('\u129B', "ETHIOPIC SYLLABLE NYAA");
    map.put('\u129C', "ETHIOPIC SYLLABLE NYEE");
    map.put('\u129D', "ETHIOPIC SYLLABLE NYE");
    map.put('\u129E', "ETHIOPIC SYLLABLE NYO");
    map.put('\u129F', "ETHIOPIC SYLLABLE NYWA");
    map.put('\u12A0', "ETHIOPIC SYLLABLE GLOTTAL A");
    map.put('\u12A1', "ETHIOPIC SYLLABLE GLOTTAL U");
    map.put('\u12A2', "ETHIOPIC SYLLABLE GLOTTAL I");
    map.put('\u12A3', "ETHIOPIC SYLLABLE GLOTTAL AA");
    map.put('\u12A4', "ETHIOPIC SYLLABLE GLOTTAL EE");
    map.put('\u12A5', "ETHIOPIC SYLLABLE GLOTTAL E");
    map.put('\u12A6', "ETHIOPIC SYLLABLE GLOTTAL O");
    map.put('\u12A7', "ETHIOPIC SYLLABLE GLOTTAL WA");
    map.put('\u12A8', "ETHIOPIC SYLLABLE KA");
    map.put('\u12A9', "ETHIOPIC SYLLABLE KU");
    map.put('\u12AA', "ETHIOPIC SYLLABLE KI");
    map.put('\u12AB', "ETHIOPIC SYLLABLE KAA");
    map.put('\u12AC', "ETHIOPIC SYLLABLE KEE");
    map.put('\u12AD', "ETHIOPIC SYLLABLE KE");
    map.put('\u12AE', "ETHIOPIC SYLLABLE KO");
    map.put('\u12AF', "ETHIOPIC SYLLABLE KOA");
    map.put('\u12B0', "ETHIOPIC SYLLABLE KWA");
    map.put('\u12B2', "ETHIOPIC SYLLABLE KWI");
    map.put('\u12B3', "ETHIOPIC SYLLABLE KWAA");
    map.put('\u12B4', "ETHIOPIC SYLLABLE KWEE");
    map.put('\u12B5', "ETHIOPIC SYLLABLE KWE");
    map.put('\u12B8', "ETHIOPIC SYLLABLE KXA");
    map.put('\u12B9', "ETHIOPIC SYLLABLE KXU");
    map.put('\u12BA', "ETHIOPIC SYLLABLE KXI");
    map.put('\u12BB', "ETHIOPIC SYLLABLE KXAA");
    map.put('\u12BC', "ETHIOPIC SYLLABLE KXEE");
    map.put('\u12BD', "ETHIOPIC SYLLABLE KXE");
    map.put('\u12BE', "ETHIOPIC SYLLABLE KXO");
    map.put('\u12C0', "ETHIOPIC SYLLABLE KXWA");
    map.put('\u12C2', "ETHIOPIC SYLLABLE KXWI");
    map.put('\u12C3', "ETHIOPIC SYLLABLE KXWAA");
    map.put('\u12C4', "ETHIOPIC SYLLABLE KXWEE");
    map.put('\u12C5', "ETHIOPIC SYLLABLE KXWE");
    map.put('\u12C8', "ETHIOPIC SYLLABLE WA");
    map.put('\u12C9', "ETHIOPIC SYLLABLE WU");
    map.put('\u12CA', "ETHIOPIC SYLLABLE WI");
    map.put('\u12CB', "ETHIOPIC SYLLABLE WAA");
    map.put('\u12CC', "ETHIOPIC SYLLABLE WEE");
    map.put('\u12CD', "ETHIOPIC SYLLABLE WE");
    map.put('\u12CE', "ETHIOPIC SYLLABLE WO");
    map.put('\u12CF', "ETHIOPIC SYLLABLE WOA");
    map.put('\u12D0', "ETHIOPIC SYLLABLE PHARYNGEAL A");
    map.put('\u12D1', "ETHIOPIC SYLLABLE PHARYNGEAL U");
    map.put('\u12D2', "ETHIOPIC SYLLABLE PHARYNGEAL I");
    map.put('\u12D3', "ETHIOPIC SYLLABLE PHARYNGEAL AA");
    map.put('\u12D4', "ETHIOPIC SYLLABLE PHARYNGEAL EE");
    map.put('\u12D5', "ETHIOPIC SYLLABLE PHARYNGEAL E");
    map.put('\u12D6', "ETHIOPIC SYLLABLE PHARYNGEAL O");
    map.put('\u12D8', "ETHIOPIC SYLLABLE ZA");
    map.put('\u12D9', "ETHIOPIC SYLLABLE ZU");
    map.put('\u12DA', "ETHIOPIC SYLLABLE ZI");
    map.put('\u12DB', "ETHIOPIC SYLLABLE ZAA");
    map.put('\u12DC', "ETHIOPIC SYLLABLE ZEE");
    map.put('\u12DD', "ETHIOPIC SYLLABLE ZE");
    map.put('\u12DE', "ETHIOPIC SYLLABLE ZO");
    map.put('\u12DF', "ETHIOPIC SYLLABLE ZWA");
    map.put('\u12E0', "ETHIOPIC SYLLABLE ZHA");
    map.put('\u12E1', "ETHIOPIC SYLLABLE ZHU");
    map.put('\u12E2', "ETHIOPIC SYLLABLE ZHI");
    map.put('\u12E3', "ETHIOPIC SYLLABLE ZHAA");
    map.put('\u12E4', "ETHIOPIC SYLLABLE ZHEE");
    map.put('\u12E5', "ETHIOPIC SYLLABLE ZHE");
    map.put('\u12E6', "ETHIOPIC SYLLABLE ZHO");
    map.put('\u12E7', "ETHIOPIC SYLLABLE ZHWA");
    map.put('\u12E8', "ETHIOPIC SYLLABLE YA");
    map.put('\u12E9', "ETHIOPIC SYLLABLE YU");
    map.put('\u12EA', "ETHIOPIC SYLLABLE YI");
    map.put('\u12EB', "ETHIOPIC SYLLABLE YAA");
    map.put('\u12EC', "ETHIOPIC SYLLABLE YEE");
    map.put('\u12ED', "ETHIOPIC SYLLABLE YE");
    map.put('\u12EE', "ETHIOPIC SYLLABLE YO");
    map.put('\u12EF', "ETHIOPIC SYLLABLE YOA");
    map.put('\u12F0', "ETHIOPIC SYLLABLE DA");
    map.put('\u12F1', "ETHIOPIC SYLLABLE DU");
    map.put('\u12F2', "ETHIOPIC SYLLABLE DI");
    map.put('\u12F3', "ETHIOPIC SYLLABLE DAA");
    map.put('\u12F4', "ETHIOPIC SYLLABLE DEE");
    map.put('\u12F5', "ETHIOPIC SYLLABLE DE");
    map.put('\u12F6', "ETHIOPIC SYLLABLE DO");
    map.put('\u12F7', "ETHIOPIC SYLLABLE DWA");
    map.put('\u12F8', "ETHIOPIC SYLLABLE DDA");
    map.put('\u12F9', "ETHIOPIC SYLLABLE DDU");
    map.put('\u12FA', "ETHIOPIC SYLLABLE DDI");
    map.put('\u12FB', "ETHIOPIC SYLLABLE DDAA");
    map.put('\u12FC', "ETHIOPIC SYLLABLE DDEE");
    map.put('\u12FD', "ETHIOPIC SYLLABLE DDE");
    map.put('\u12FE', "ETHIOPIC SYLLABLE DDO");
    map.put('\u12FF', "ETHIOPIC SYLLABLE DDWA");
    map.put('\u1300', "ETHIOPIC SYLLABLE JA");
    map.put('\u1301', "ETHIOPIC SYLLABLE JU");
    map.put('\u1302', "ETHIOPIC SYLLABLE JI");
    map.put('\u1303', "ETHIOPIC SYLLABLE JAA");
    map.put('\u1304', "ETHIOPIC SYLLABLE JEE");
    map.put('\u1305', "ETHIOPIC SYLLABLE JE");
    map.put('\u1306', "ETHIOPIC SYLLABLE JO");
    map.put('\u1307', "ETHIOPIC SYLLABLE JWA");
    map.put('\u1308', "ETHIOPIC SYLLABLE GA");
    map.put('\u1309', "ETHIOPIC SYLLABLE GU");
    map.put('\u130A', "ETHIOPIC SYLLABLE GI");
    map.put('\u130B', "ETHIOPIC SYLLABLE GAA");
    map.put('\u130C', "ETHIOPIC SYLLABLE GEE");
    map.put('\u130D', "ETHIOPIC SYLLABLE GE");
    map.put('\u130E', "ETHIOPIC SYLLABLE GO");
    map.put('\u130F', "ETHIOPIC SYLLABLE GOA");
    map.put('\u1310', "ETHIOPIC SYLLABLE GWA");
    map.put('\u1312', "ETHIOPIC SYLLABLE GWI");
    map.put('\u1313', "ETHIOPIC SYLLABLE GWAA");
    map.put('\u1314', "ETHIOPIC SYLLABLE GWEE");
    map.put('\u1315', "ETHIOPIC SYLLABLE GWE");
    map.put('\u1318', "ETHIOPIC SYLLABLE GGA");
    map.put('\u1319', "ETHIOPIC SYLLABLE GGU");
    map.put('\u131A', "ETHIOPIC SYLLABLE GGI");
    map.put('\u131B', "ETHIOPIC SYLLABLE GGAA");
    map.put('\u131C', "ETHIOPIC SYLLABLE GGEE");
    map.put('\u131D', "ETHIOPIC SYLLABLE GGE");
    map.put('\u131E', "ETHIOPIC SYLLABLE GGO");
    map.put('\u131F', "ETHIOPIC SYLLABLE GGWAA");
    map.put('\u1320', "ETHIOPIC SYLLABLE THA");
    map.put('\u1321', "ETHIOPIC SYLLABLE THU");
    map.put('\u1322', "ETHIOPIC SYLLABLE THI");
    map.put('\u1323', "ETHIOPIC SYLLABLE THAA");
    map.put('\u1324', "ETHIOPIC SYLLABLE THEE");
    map.put('\u1325', "ETHIOPIC SYLLABLE THE");
    map.put('\u1326', "ETHIOPIC SYLLABLE THO");
    map.put('\u1327', "ETHIOPIC SYLLABLE THWA");
    map.put('\u1328', "ETHIOPIC SYLLABLE CHA");
    map.put('\u1329', "ETHIOPIC SYLLABLE CHU");
    map.put('\u132A', "ETHIOPIC SYLLABLE CHI");
    map.put('\u132B', "ETHIOPIC SYLLABLE CHAA");
    map.put('\u132C', "ETHIOPIC SYLLABLE CHEE");
    map.put('\u132D', "ETHIOPIC SYLLABLE CHE");
    map.put('\u132E', "ETHIOPIC SYLLABLE CHO");
    map.put('\u132F', "ETHIOPIC SYLLABLE CHWA");
    map.put('\u1330', "ETHIOPIC SYLLABLE PHA");
    map.put('\u1331', "ETHIOPIC SYLLABLE PHU");
    map.put('\u1332', "ETHIOPIC SYLLABLE PHI");
    map.put('\u1333', "ETHIOPIC SYLLABLE PHAA");
    map.put('\u1334', "ETHIOPIC SYLLABLE PHEE");
    map.put('\u1335', "ETHIOPIC SYLLABLE PHE");
    map.put('\u1336', "ETHIOPIC SYLLABLE PHO");
    map.put('\u1337', "ETHIOPIC SYLLABLE PHWA");
    map.put('\u1338', "ETHIOPIC SYLLABLE TSA");
    map.put('\u1339', "ETHIOPIC SYLLABLE TSU");
    map.put('\u133A', "ETHIOPIC SYLLABLE TSI");
    map.put('\u133B', "ETHIOPIC SYLLABLE TSAA");
    map.put('\u133C', "ETHIOPIC SYLLABLE TSEE");
    map.put('\u133D', "ETHIOPIC SYLLABLE TSE");
    map.put('\u133E', "ETHIOPIC SYLLABLE TSO");
    map.put('\u133F', "ETHIOPIC SYLLABLE TSWA");
    map.put('\u1340', "ETHIOPIC SYLLABLE TZA");
    map.put('\u1341', "ETHIOPIC SYLLABLE TZU");
    map.put('\u1342', "ETHIOPIC SYLLABLE TZI");
    map.put('\u1343', "ETHIOPIC SYLLABLE TZAA");
    map.put('\u1344', "ETHIOPIC SYLLABLE TZEE");
    map.put('\u1345', "ETHIOPIC SYLLABLE TZE");
    map.put('\u1346', "ETHIOPIC SYLLABLE TZO");
    map.put('\u1347', "ETHIOPIC SYLLABLE TZOA");
    map.put('\u1348', "ETHIOPIC SYLLABLE FA");
    map.put('\u1349', "ETHIOPIC SYLLABLE FU");
    map.put('\u134A', "ETHIOPIC SYLLABLE FI");
    map.put('\u134B', "ETHIOPIC SYLLABLE FAA");
    map.put('\u134C', "ETHIOPIC SYLLABLE FEE");
    map.put('\u134D', "ETHIOPIC SYLLABLE FE");
    map.put('\u134E', "ETHIOPIC SYLLABLE FO");
    map.put('\u134F', "ETHIOPIC SYLLABLE FWA");
    map.put('\u1350', "ETHIOPIC SYLLABLE PA");
    map.put('\u1351', "ETHIOPIC SYLLABLE PU");
    map.put('\u1352', "ETHIOPIC SYLLABLE PI");
    map.put('\u1353', "ETHIOPIC SYLLABLE PAA");
    map.put('\u1354', "ETHIOPIC SYLLABLE PEE");
    map.put('\u1355', "ETHIOPIC SYLLABLE PE");
    map.put('\u1356', "ETHIOPIC SYLLABLE PO");
    map.put('\u1357', "ETHIOPIC SYLLABLE PWA");
    map.put('\u1358', "ETHIOPIC SYLLABLE RYA");
    map.put('\u1359', "ETHIOPIC SYLLABLE MYA");
    map.put('\u135A', "ETHIOPIC SYLLABLE FYA");
    map.put('\u135F', "ETHIOPIC COMBINING GEMINATION MARK");
    map.put('\u1360', "ETHIOPIC SECTION MARK");
    map.put('\u1361', "ETHIOPIC WORDSPACE");
    map.put('\u1362', "ETHIOPIC FULL STOP");
    map.put('\u1363', "ETHIOPIC COMMA");
    map.put('\u1364', "ETHIOPIC SEMICOLON");
    map.put('\u1365', "ETHIOPIC COLON");
    map.put('\u1366', "ETHIOPIC PREFACE COLON");
    map.put('\u1367', "ETHIOPIC QUESTION MARK");
    map.put('\u1368', "ETHIOPIC PARAGRAPH SEPARATOR");
    map.put('\u1369', "ETHIOPIC DIGIT ONE");
    map.put('\u136A', "ETHIOPIC DIGIT TWO");
    map.put('\u136B', "ETHIOPIC DIGIT THREE");
    map.put('\u136C', "ETHIOPIC DIGIT FOUR");
    map.put('\u136D', "ETHIOPIC DIGIT FIVE");
    map.put('\u136E', "ETHIOPIC DIGIT SIX");
    map.put('\u136F', "ETHIOPIC DIGIT SEVEN");
    map.put('\u1370', "ETHIOPIC DIGIT EIGHT");
    map.put('\u1371', "ETHIOPIC DIGIT NINE");
    map.put('\u1372', "ETHIOPIC NUMBER TEN");
    map.put('\u1373', "ETHIOPIC NUMBER TWENTY");
    map.put('\u1374', "ETHIOPIC NUMBER THIRTY");
    map.put('\u1375', "ETHIOPIC NUMBER FORTY");
    map.put('\u1376', "ETHIOPIC NUMBER FIFTY");
    map.put('\u1377', "ETHIOPIC NUMBER SIXTY");
    map.put('\u1378', "ETHIOPIC NUMBER SEVENTY");
    map.put('\u1379', "ETHIOPIC NUMBER EIGHTY");
    map.put('\u137A', "ETHIOPIC NUMBER NINETY");
    map.put('\u137B', "ETHIOPIC NUMBER HUNDRED");
    map.put('\u137C', "ETHIOPIC NUMBER TEN THOUSAND");

  }

  public static final void ethiopicSupplement(Map<Character, String> map) {

    map.put('\u1380', "ETHIOPIC SYLLABLE SEBATBEIT MWA");
    map.put('\u1381', "ETHIOPIC SYLLABLE MWI");
    map.put('\u1382', "ETHIOPIC SYLLABLE MWEE");
    map.put('\u1383', "ETHIOPIC SYLLABLE MWE");
    map.put('\u1384', "ETHIOPIC SYLLABLE SEBATBEIT BWA");
    map.put('\u1385', "ETHIOPIC SYLLABLE BWI");
    map.put('\u1386', "ETHIOPIC SYLLABLE BWEE");
    map.put('\u1387', "ETHIOPIC SYLLABLE BWE");
    map.put('\u1388', "ETHIOPIC SYLLABLE SEBATBEIT FWA");
    map.put('\u1389', "ETHIOPIC SYLLABLE FWI");
    map.put('\u138A', "ETHIOPIC SYLLABLE FWEE");
    map.put('\u138B', "ETHIOPIC SYLLABLE FWE");
    map.put('\u138C', "ETHIOPIC SYLLABLE SEBATBEIT PWA");
    map.put('\u138D', "ETHIOPIC SYLLABLE PWI");
    map.put('\u138E', "ETHIOPIC SYLLABLE PWEE");
    map.put('\u138F', "ETHIOPIC SYLLABLE PWE");
    map.put('\u1390', "ETHIOPIC TONAL MARK YIZET");
    map.put('\u1391', "ETHIOPIC TONAL MARK DERET");
    map.put('\u1392', "ETHIOPIC TONAL MARK RIKRIK");
    map.put('\u1393', "ETHIOPIC TONAL MARK SHORT RIKRIK");
    map.put('\u1394', "ETHIOPIC TONAL MARK DIFAT");
    map.put('\u1395', "ETHIOPIC TONAL MARK KENAT");
    map.put('\u1396', "ETHIOPIC TONAL MARK CHIRET");
    map.put('\u1397', "ETHIOPIC TONAL MARK HIDET");
    map.put('\u1398', "ETHIOPIC TONAL MARK DERET-HIDET");
    map.put('\u1399', "ETHIOPIC TONAL MARK KURT");

  }

  public static final void cherokee(Map<Character, String> map) {

    map.put('\u13A0', "CHEROKEE LETTER A");
    map.put('\u13A1', "CHEROKEE LETTER E");
    map.put('\u13A2', "CHEROKEE LETTER I");
    map.put('\u13A3', "CHEROKEE LETTER O");
    map.put('\u13A4', "CHEROKEE LETTER U");
    map.put('\u13A5', "CHEROKEE LETTER V");
    map.put('\u13A6', "CHEROKEE LETTER GA");
    map.put('\u13A7', "CHEROKEE LETTER KA");
    map.put('\u13A8', "CHEROKEE LETTER GE");
    map.put('\u13A9', "CHEROKEE LETTER GI");
    map.put('\u13AA', "CHEROKEE LETTER GO");
    map.put('\u13AB', "CHEROKEE LETTER GU");
    map.put('\u13AC', "CHEROKEE LETTER GV");
    map.put('\u13AD', "CHEROKEE LETTER HA");
    map.put('\u13AE', "CHEROKEE LETTER HE");
    map.put('\u13AF', "CHEROKEE LETTER HI");
    map.put('\u13B0', "CHEROKEE LETTER HO");
    map.put('\u13B1', "CHEROKEE LETTER HU");
    map.put('\u13B2', "CHEROKEE LETTER HV");
    map.put('\u13B3', "CHEROKEE LETTER LA");
    map.put('\u13B4', "CHEROKEE LETTER LE");
    map.put('\u13B5', "CHEROKEE LETTER LI");
    map.put('\u13B6', "CHEROKEE LETTER LO");
    map.put('\u13B7', "CHEROKEE LETTER LU");
    map.put('\u13B8', "CHEROKEE LETTER LV");
    map.put('\u13B9', "CHEROKEE LETTER MA");
    map.put('\u13BA', "CHEROKEE LETTER ME");
    map.put('\u13BB', "CHEROKEE LETTER MI");
    map.put('\u13BC', "CHEROKEE LETTER MO");
    map.put('\u13BD', "CHEROKEE LETTER MU");
    map.put('\u13BE', "CHEROKEE LETTER NA");
    map.put('\u13BF', "CHEROKEE LETTER HNA");
    map.put('\u13C0', "CHEROKEE LETTER NAH");
    map.put('\u13C1', "CHEROKEE LETTER NE");
    map.put('\u13C2', "CHEROKEE LETTER NI");
    map.put('\u13C3', "CHEROKEE LETTER NO");
    map.put('\u13C4', "CHEROKEE LETTER NU");
    map.put('\u13C5', "CHEROKEE LETTER NV");
    map.put('\u13C6', "CHEROKEE LETTER QUA");
    map.put('\u13C7', "CHEROKEE LETTER QUE");
    map.put('\u13C8', "CHEROKEE LETTER QUI");
    map.put('\u13C9', "CHEROKEE LETTER QUO");
    map.put('\u13CA', "CHEROKEE LETTER QUU");
    map.put('\u13CB', "CHEROKEE LETTER QUV");
    map.put('\u13CC', "CHEROKEE LETTER SA");
    map.put('\u13CD', "CHEROKEE LETTER S");
    map.put('\u13CE', "CHEROKEE LETTER SE");
    map.put('\u13CF', "CHEROKEE LETTER SI");
    map.put('\u13D0', "CHEROKEE LETTER SO");
    map.put('\u13D1', "CHEROKEE LETTER SU");
    map.put('\u13D2', "CHEROKEE LETTER SV");
    map.put('\u13D3', "CHEROKEE LETTER DA");
    map.put('\u13D4', "CHEROKEE LETTER TA");
    map.put('\u13D5', "CHEROKEE LETTER DE");
    map.put('\u13D6', "CHEROKEE LETTER TE");
    map.put('\u13D7', "CHEROKEE LETTER DI");
    map.put('\u13D8', "CHEROKEE LETTER TI");
    map.put('\u13D9', "CHEROKEE LETTER DO");
    map.put('\u13DA', "CHEROKEE LETTER DU");
    map.put('\u13DB', "CHEROKEE LETTER DV");
    map.put('\u13DC', "CHEROKEE LETTER DLA");
    map.put('\u13DD', "CHEROKEE LETTER TLA");
    map.put('\u13DE', "CHEROKEE LETTER TLE");
    map.put('\u13DF', "CHEROKEE LETTER TLI");
    map.put('\u13E0', "CHEROKEE LETTER TLO");
    map.put('\u13E1', "CHEROKEE LETTER TLU");
    map.put('\u13E2', "CHEROKEE LETTER TLV");
    map.put('\u13E3', "CHEROKEE LETTER TSA");
    map.put('\u13E4', "CHEROKEE LETTER TSE");
    map.put('\u13E5', "CHEROKEE LETTER TSI");
    map.put('\u13E6', "CHEROKEE LETTER TSO");
    map.put('\u13E7', "CHEROKEE LETTER TSU");
    map.put('\u13E8', "CHEROKEE LETTER TSV");
    map.put('\u13E9', "CHEROKEE LETTER WA");
    map.put('\u13EA', "CHEROKEE LETTER WE");
    map.put('\u13EB', "CHEROKEE LETTER WI");
    map.put('\u13EC', "CHEROKEE LETTER WO");
    map.put('\u13ED', "CHEROKEE LETTER WU");
    map.put('\u13EE', "CHEROKEE LETTER WV");
    map.put('\u13EF', "CHEROKEE LETTER YA");
    map.put('\u13F0', "CHEROKEE LETTER YE");
    map.put('\u13F1', "CHEROKEE LETTER YI");
    map.put('\u13F2', "CHEROKEE LETTER YO");
    map.put('\u13F3', "CHEROKEE LETTER YU");
    map.put('\u13F4', "CHEROKEE LETTER YV");

  }

  public static final void canadianAboriginalSyllabics(Map<Character, String> map) {

    map.put('\u1400', "CANADIAN SYLLABICS HYPHEN");
    map.put('\u1401', "CANADIAN SYLLABICS E");
    map.put('\u1402', "CANADIAN SYLLABICS AAI");
    map.put('\u1403', "CANADIAN SYLLABICS I");
    map.put('\u1404', "CANADIAN SYLLABICS II");
    map.put('\u1405', "CANADIAN SYLLABICS O");
    map.put('\u1406', "CANADIAN SYLLABICS OO");
    map.put('\u1407', "CANADIAN SYLLABICS Y-CREE OO");
    map.put('\u1408', "CANADIAN SYLLABICS CARRIER EE");
    map.put('\u1409', "CANADIAN SYLLABICS CARRIER I");
    map.put('\u140A', "CANADIAN SYLLABICS A");
    map.put('\u140B', "CANADIAN SYLLABICS AA");
    map.put('\u140C', "CANADIAN SYLLABICS WE");
    map.put('\u140D', "CANADIAN SYLLABICS WEST-CREE WE");
    map.put('\u140E', "CANADIAN SYLLABICS WI");
    map.put('\u140F', "CANADIAN SYLLABICS WEST-CREE WI");
    map.put('\u1410', "CANADIAN SYLLABICS WII");
    map.put('\u1411', "CANADIAN SYLLABICS WEST-CREE WII");
    map.put('\u1412', "CANADIAN SYLLABICS WO");
    map.put('\u1413', "CANADIAN SYLLABICS WEST-CREE WO");
    map.put('\u1414', "CANADIAN SYLLABICS WOO");
    map.put('\u1415', "CANADIAN SYLLABICS WEST-CREE WOO");
    map.put('\u1416', "CANADIAN SYLLABICS NASKAPI WOO");
    map.put('\u1417', "CANADIAN SYLLABICS WA");
    map.put('\u1418', "CANADIAN SYLLABICS WEST-CREE WA");
    map.put('\u1419', "CANADIAN SYLLABICS WAA");
    map.put('\u141A', "CANADIAN SYLLABICS WEST-CREE WAA");
    map.put('\u141B', "CANADIAN SYLLABICS NASKAPI WAA");
    map.put('\u141C', "CANADIAN SYLLABICS AI");
    map.put('\u141D', "CANADIAN SYLLABICS Y-CREE W");
    map.put('\u141E', "CANADIAN SYLLABICS GLOTTAL STOP");
    map.put('\u141F', "CANADIAN SYLLABICS FINAL ACUTE");
    map.put('\u1420', "CANADIAN SYLLABICS FINAL GRAVE");
    map.put('\u1421', "CANADIAN SYLLABICS FINAL BOTTOM HALF RING");
    map.put('\u1422', "CANADIAN SYLLABICS FINAL TOP HALF RING");
    map.put('\u1423', "CANADIAN SYLLABICS FINAL RIGHT HALF RING");
    map.put('\u1424', "CANADIAN SYLLABICS FINAL RING");
    map.put('\u1425', "CANADIAN SYLLABICS FINAL DOUBLE ACUTE");
    map.put('\u1426', "CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES");
    map.put('\u1427', "CANADIAN SYLLABICS FINAL MIDDLE DOT");
    map.put('\u1428', "CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE");
    map.put('\u1429', "CANADIAN SYLLABICS FINAL PLUS");
    map.put('\u142A', "CANADIAN SYLLABICS FINAL DOWN TACK");
    map.put('\u142B', "CANADIAN SYLLABICS EN");
    map.put('\u142C', "CANADIAN SYLLABICS IN");
    map.put('\u142D', "CANADIAN SYLLABICS ON");
    map.put('\u142E', "CANADIAN SYLLABICS AN");
    map.put('\u142F', "CANADIAN SYLLABICS PE");
    map.put('\u1430', "CANADIAN SYLLABICS PAAI");
    map.put('\u1431', "CANADIAN SYLLABICS PI");
    map.put('\u1432', "CANADIAN SYLLABICS PII");
    map.put('\u1433', "CANADIAN SYLLABICS PO");
    map.put('\u1434', "CANADIAN SYLLABICS POO");
    map.put('\u1435', "CANADIAN SYLLABICS Y-CREE POO");
    map.put('\u1436', "CANADIAN SYLLABICS CARRIER HEE");
    map.put('\u1437', "CANADIAN SYLLABICS CARRIER HI");
    map.put('\u1438', "CANADIAN SYLLABICS PA");
    map.put('\u1439', "CANADIAN SYLLABICS PAA");
    map.put('\u143A', "CANADIAN SYLLABICS PWE");
    map.put('\u143B', "CANADIAN SYLLABICS WEST-CREE PWE");
    map.put('\u143C', "CANADIAN SYLLABICS PWI");
    map.put('\u143D', "CANADIAN SYLLABICS WEST-CREE PWI");
    map.put('\u143E', "CANADIAN SYLLABICS PWII");
    map.put('\u143F', "CANADIAN SYLLABICS WEST-CREE PWII");
    map.put('\u1440', "CANADIAN SYLLABICS PWO");
    map.put('\u1441', "CANADIAN SYLLABICS WEST-CREE PWO");
    map.put('\u1442', "CANADIAN SYLLABICS PWOO");
    map.put('\u1443', "CANADIAN SYLLABICS WEST-CREE PWOO");
    map.put('\u1444', "CANADIAN SYLLABICS PWA");
    map.put('\u1445', "CANADIAN SYLLABICS WEST-CREE PWA");
    map.put('\u1446', "CANADIAN SYLLABICS PWAA");
    map.put('\u1447', "CANADIAN SYLLABICS WEST-CREE PWAA");
    map.put('\u1448', "CANADIAN SYLLABICS Y-CREE PWAA");
    map.put('\u1449', "CANADIAN SYLLABICS P");
    map.put('\u144A', "CANADIAN SYLLABICS WEST-CREE P");
    map.put('\u144B', "CANADIAN SYLLABICS CARRIER H");
    map.put('\u144C', "CANADIAN SYLLABICS TE");
    map.put('\u144D', "CANADIAN SYLLABICS TAAI");
    map.put('\u144E', "CANADIAN SYLLABICS TI");
    map.put('\u144F', "CANADIAN SYLLABICS TII");
    map.put('\u1450', "CANADIAN SYLLABICS TO");
    map.put('\u1451', "CANADIAN SYLLABICS TOO");
    map.put('\u1452', "CANADIAN SYLLABICS Y-CREE TOO");
    map.put('\u1453', "CANADIAN SYLLABICS CARRIER DEE");
    map.put('\u1454', "CANADIAN SYLLABICS CARRIER DI");
    map.put('\u1455', "CANADIAN SYLLABICS TA");
    map.put('\u1456', "CANADIAN SYLLABICS TAA");
    map.put('\u1457', "CANADIAN SYLLABICS TWE");
    map.put('\u1458', "CANADIAN SYLLABICS WEST-CREE TWE");
    map.put('\u1459', "CANADIAN SYLLABICS TWI");
    map.put('\u145A', "CANADIAN SYLLABICS WEST-CREE TWI");
    map.put('\u145B', "CANADIAN SYLLABICS TWII");
    map.put('\u145C', "CANADIAN SYLLABICS WEST-CREE TWII");
    map.put('\u145D', "CANADIAN SYLLABICS TWO");
    map.put('\u145E', "CANADIAN SYLLABICS WEST-CREE TWO");
    map.put('\u145F', "CANADIAN SYLLABICS TWOO");
    map.put('\u1460', "CANADIAN SYLLABICS WEST-CREE TWOO");
    map.put('\u1461', "CANADIAN SYLLABICS TWA");
    map.put('\u1462', "CANADIAN SYLLABICS WEST-CREE TWA");
    map.put('\u1463', "CANADIAN SYLLABICS TWAA");
    map.put('\u1464', "CANADIAN SYLLABICS WEST-CREE TWAA");
    map.put('\u1465', "CANADIAN SYLLABICS NASKAPI TWAA");
    map.put('\u1466', "CANADIAN SYLLABICS T");
    map.put('\u1467', "CANADIAN SYLLABICS TTE");
    map.put('\u1468', "CANADIAN SYLLABICS TTI");
    map.put('\u1469', "CANADIAN SYLLABICS TTO");
    map.put('\u146A', "CANADIAN SYLLABICS TTA");
    map.put('\u146B', "CANADIAN SYLLABICS KE");
    map.put('\u146C', "CANADIAN SYLLABICS KAAI");
    map.put('\u146D', "CANADIAN SYLLABICS KI");
    map.put('\u146E', "CANADIAN SYLLABICS KII");
    map.put('\u146F', "CANADIAN SYLLABICS KO");
    map.put('\u1470', "CANADIAN SYLLABICS KOO");
    map.put('\u1471', "CANADIAN SYLLABICS Y-CREE KOO");
    map.put('\u1472', "CANADIAN SYLLABICS KA");
    map.put('\u1473', "CANADIAN SYLLABICS KAA");
    map.put('\u1474', "CANADIAN SYLLABICS KWE");
    map.put('\u1475', "CANADIAN SYLLABICS WEST-CREE KWE");
    map.put('\u1476', "CANADIAN SYLLABICS KWI");
    map.put('\u1477', "CANADIAN SYLLABICS WEST-CREE KWI");
    map.put('\u1478', "CANADIAN SYLLABICS KWII");
    map.put('\u1479', "CANADIAN SYLLABICS WEST-CREE KWII");
    map.put('\u147A', "CANADIAN SYLLABICS KWO");
    map.put('\u147B', "CANADIAN SYLLABICS WEST-CREE KWO");
    map.put('\u147C', "CANADIAN SYLLABICS KWOO");
    map.put('\u147D', "CANADIAN SYLLABICS WEST-CREE KWOO");
    map.put('\u147E', "CANADIAN SYLLABICS KWA");
    map.put('\u147F', "CANADIAN SYLLABICS WEST-CREE KWA");
    map.put('\u1480', "CANADIAN SYLLABICS KWAA");
    map.put('\u1481', "CANADIAN SYLLABICS WEST-CREE KWAA");
    map.put('\u1482', "CANADIAN SYLLABICS NASKAPI KWAA");
    map.put('\u1483', "CANADIAN SYLLABICS K");
    map.put('\u1484', "CANADIAN SYLLABICS KW");
    map.put('\u1485', "CANADIAN SYLLABICS SOUTH-SLAVEY KEH");
    map.put('\u1486', "CANADIAN SYLLABICS SOUTH-SLAVEY KIH");
    map.put('\u1487', "CANADIAN SYLLABICS SOUTH-SLAVEY KOH");
    map.put('\u1488', "CANADIAN SYLLABICS SOUTH-SLAVEY KAH");
    map.put('\u1489', "CANADIAN SYLLABICS CE");
    map.put('\u148A', "CANADIAN SYLLABICS CAAI");
    map.put('\u148B', "CANADIAN SYLLABICS CI");
    map.put('\u148C', "CANADIAN SYLLABICS CII");
    map.put('\u148D', "CANADIAN SYLLABICS CO");
    map.put('\u148E', "CANADIAN SYLLABICS COO");
    map.put('\u148F', "CANADIAN SYLLABICS Y-CREE COO");
    map.put('\u1490', "CANADIAN SYLLABICS CA");
    map.put('\u1491', "CANADIAN SYLLABICS CAA");
    map.put('\u1492', "CANADIAN SYLLABICS CWE");
    map.put('\u1493', "CANADIAN SYLLABICS WEST-CREE CWE");
    map.put('\u1494', "CANADIAN SYLLABICS CWI");
    map.put('\u1495', "CANADIAN SYLLABICS WEST-CREE CWI");
    map.put('\u1496', "CANADIAN SYLLABICS CWII");
    map.put('\u1497', "CANADIAN SYLLABICS WEST-CREE CWII");
    map.put('\u1498', "CANADIAN SYLLABICS CWO");
    map.put('\u1499', "CANADIAN SYLLABICS WEST-CREE CWO");
    map.put('\u149A', "CANADIAN SYLLABICS CWOO");
    map.put('\u149B', "CANADIAN SYLLABICS WEST-CREE CWOO");
    map.put('\u149C', "CANADIAN SYLLABICS CWA");
    map.put('\u149D', "CANADIAN SYLLABICS WEST-CREE CWA");
    map.put('\u149E', "CANADIAN SYLLABICS CWAA");
    map.put('\u149F', "CANADIAN SYLLABICS WEST-CREE CWAA");
    map.put('\u14A0', "CANADIAN SYLLABICS NASKAPI CWAA");
    map.put('\u14A1', "CANADIAN SYLLABICS C");
    map.put('\u14A2', "CANADIAN SYLLABICS SAYISI TH");
    map.put('\u14A3', "CANADIAN SYLLABICS ME");
    map.put('\u14A4', "CANADIAN SYLLABICS MAAI");
    map.put('\u14A5', "CANADIAN SYLLABICS MI");
    map.put('\u14A6', "CANADIAN SYLLABICS MII");
    map.put('\u14A7', "CANADIAN SYLLABICS MO");
    map.put('\u14A8', "CANADIAN SYLLABICS MOO");
    map.put('\u14A9', "CANADIAN SYLLABICS Y-CREE MOO");
    map.put('\u14AA', "CANADIAN SYLLABICS MA");
    map.put('\u14AB', "CANADIAN SYLLABICS MAA");
    map.put('\u14AC', "CANADIAN SYLLABICS MWE");
    map.put('\u14AD', "CANADIAN SYLLABICS WEST-CREE MWE");
    map.put('\u14AE', "CANADIAN SYLLABICS MWI");
    map.put('\u14AF', "CANADIAN SYLLABICS WEST-CREE MWI");
    map.put('\u14B0', "CANADIAN SYLLABICS MWII");
    map.put('\u14B1', "CANADIAN SYLLABICS WEST-CREE MWII");
    map.put('\u14B2', "CANADIAN SYLLABICS MWO");
    map.put('\u14B3', "CANADIAN SYLLABICS WEST-CREE MWO");
    map.put('\u14B4', "CANADIAN SYLLABICS MWOO");
    map.put('\u14B5', "CANADIAN SYLLABICS WEST-CREE MWOO");
    map.put('\u14B6', "CANADIAN SYLLABICS MWA");
    map.put('\u14B7', "CANADIAN SYLLABICS WEST-CREE MWA");
    map.put('\u14B8', "CANADIAN SYLLABICS MWAA");
    map.put('\u14B9', "CANADIAN SYLLABICS WEST-CREE MWAA");
    map.put('\u14BA', "CANADIAN SYLLABICS NASKAPI MWAA");
    map.put('\u14BB', "CANADIAN SYLLABICS M");
    map.put('\u14BC', "CANADIAN SYLLABICS WEST-CREE M");
    map.put('\u14BD', "CANADIAN SYLLABICS MH");
    map.put('\u14BE', "CANADIAN SYLLABICS ATHAPASCAN M");
    map.put('\u14BF', "CANADIAN SYLLABICS SAYISI M");
    map.put('\u14C0', "CANADIAN SYLLABICS NE");
    map.put('\u14C1', "CANADIAN SYLLABICS NAAI");
    map.put('\u14C2', "CANADIAN SYLLABICS NI");
    map.put('\u14C3', "CANADIAN SYLLABICS NII");
    map.put('\u14C4', "CANADIAN SYLLABICS NO");
    map.put('\u14C5', "CANADIAN SYLLABICS NOO");
    map.put('\u14C6', "CANADIAN SYLLABICS Y-CREE NOO");
    map.put('\u14C7', "CANADIAN SYLLABICS NA");
    map.put('\u14C8', "CANADIAN SYLLABICS NAA");
    map.put('\u14C9', "CANADIAN SYLLABICS NWE");
    map.put('\u14CA', "CANADIAN SYLLABICS WEST-CREE NWE");
    map.put('\u14CB', "CANADIAN SYLLABICS NWA");
    map.put('\u14CC', "CANADIAN SYLLABICS WEST-CREE NWA");
    map.put('\u14CD', "CANADIAN SYLLABICS NWAA");
    map.put('\u14CE', "CANADIAN SYLLABICS WEST-CREE NWAA");
    map.put('\u14CF', "CANADIAN SYLLABICS NASKAPI NWAA");
    map.put('\u14D0', "CANADIAN SYLLABICS N");
    map.put('\u14D1', "CANADIAN SYLLABICS CARRIER NG");
    map.put('\u14D2', "CANADIAN SYLLABICS NH");
    map.put('\u14D3', "CANADIAN SYLLABICS LE");
    map.put('\u14D4', "CANADIAN SYLLABICS LAAI");
    map.put('\u14D5', "CANADIAN SYLLABICS LI");
    map.put('\u14D6', "CANADIAN SYLLABICS LII");
    map.put('\u14D7', "CANADIAN SYLLABICS LO");
    map.put('\u14D8', "CANADIAN SYLLABICS LOO");
    map.put('\u14D9', "CANADIAN SYLLABICS Y-CREE LOO");
    map.put('\u14DA', "CANADIAN SYLLABICS LA");
    map.put('\u14DB', "CANADIAN SYLLABICS LAA");
    map.put('\u14DC', "CANADIAN SYLLABICS LWE");
    map.put('\u14DD', "CANADIAN SYLLABICS WEST-CREE LWE");
    map.put('\u14DE', "CANADIAN SYLLABICS LWI");
    map.put('\u14DF', "CANADIAN SYLLABICS WEST-CREE LWI");
    map.put('\u14E0', "CANADIAN SYLLABICS LWII");
    map.put('\u14E1', "CANADIAN SYLLABICS WEST-CREE LWII");
    map.put('\u14E2', "CANADIAN SYLLABICS LWO");
    map.put('\u14E3', "CANADIAN SYLLABICS WEST-CREE LWO");
    map.put('\u14E4', "CANADIAN SYLLABICS LWOO");
    map.put('\u14E5', "CANADIAN SYLLABICS WEST-CREE LWOO");
    map.put('\u14E6', "CANADIAN SYLLABICS LWA");
    map.put('\u14E7', "CANADIAN SYLLABICS WEST-CREE LWA");
    map.put('\u14E8', "CANADIAN SYLLABICS LWAA");
    map.put('\u14E9', "CANADIAN SYLLABICS WEST-CREE LWAA");
    map.put('\u14EA', "CANADIAN SYLLABICS L");
    map.put('\u14EB', "CANADIAN SYLLABICS WEST-CREE L");
    map.put('\u14EC', "CANADIAN SYLLABICS MEDIAL L");
    map.put('\u14ED', "CANADIAN SYLLABICS SE");
    map.put('\u14EE', "CANADIAN SYLLABICS SAAI");
    map.put('\u14EF', "CANADIAN SYLLABICS SI");
    map.put('\u14F0', "CANADIAN SYLLABICS SII");
    map.put('\u14F1', "CANADIAN SYLLABICS SO");
    map.put('\u14F2', "CANADIAN SYLLABICS SOO");
    map.put('\u14F3', "CANADIAN SYLLABICS Y-CREE SOO");
    map.put('\u14F4', "CANADIAN SYLLABICS SA");
    map.put('\u14F5', "CANADIAN SYLLABICS SAA");
    map.put('\u14F6', "CANADIAN SYLLABICS SWE");
    map.put('\u14F7', "CANADIAN SYLLABICS WEST-CREE SWE");
    map.put('\u14F8', "CANADIAN SYLLABICS SWI");
    map.put('\u14F9', "CANADIAN SYLLABICS WEST-CREE SWI");
    map.put('\u14FA', "CANADIAN SYLLABICS SWII");
    map.put('\u14FB', "CANADIAN SYLLABICS WEST-CREE SWII");
    map.put('\u14FC', "CANADIAN SYLLABICS SWO");
    map.put('\u14FD', "CANADIAN SYLLABICS WEST-CREE SWO");
    map.put('\u14FE', "CANADIAN SYLLABICS SWOO");
    map.put('\u14FF', "CANADIAN SYLLABICS WEST-CREE SWOO");
    map.put('\u1500', "CANADIAN SYLLABICS SWA");
    map.put('\u1501', "CANADIAN SYLLABICS WEST-CREE SWA");
    map.put('\u1502', "CANADIAN SYLLABICS SWAA");
    map.put('\u1503', "CANADIAN SYLLABICS WEST-CREE SWAA");
    map.put('\u1504', "CANADIAN SYLLABICS NASKAPI SWAA");
    map.put('\u1505', "CANADIAN SYLLABICS S");
    map.put('\u1506', "CANADIAN SYLLABICS ATHAPASCAN S");
    map.put('\u1507', "CANADIAN SYLLABICS SW");
    map.put('\u1508', "CANADIAN SYLLABICS BLACKFOOT S");
    map.put('\u1509', "CANADIAN SYLLABICS MOOSE-CREE SK");
    map.put('\u150A', "CANADIAN SYLLABICS NASKAPI SKW");
    map.put('\u150B', "CANADIAN SYLLABICS NASKAPI S-W");
    map.put('\u150C', "CANADIAN SYLLABICS NASKAPI SPWA");
    map.put('\u150D', "CANADIAN SYLLABICS NASKAPI STWA");
    map.put('\u150E', "CANADIAN SYLLABICS NASKAPI SKWA");
    map.put('\u150F', "CANADIAN SYLLABICS NASKAPI SCWA");
    map.put('\u1510', "CANADIAN SYLLABICS SHE");
    map.put('\u1511', "CANADIAN SYLLABICS SHI");
    map.put('\u1512', "CANADIAN SYLLABICS SHII");
    map.put('\u1513', "CANADIAN SYLLABICS SHO");
    map.put('\u1514', "CANADIAN SYLLABICS SHOO");
    map.put('\u1515', "CANADIAN SYLLABICS SHA");
    map.put('\u1516', "CANADIAN SYLLABICS SHAA");
    map.put('\u1517', "CANADIAN SYLLABICS SHWE");
    map.put('\u1518', "CANADIAN SYLLABICS WEST-CREE SHWE");
    map.put('\u1519', "CANADIAN SYLLABICS SHWI");
    map.put('\u151A', "CANADIAN SYLLABICS WEST-CREE SHWI");
    map.put('\u151B', "CANADIAN SYLLABICS SHWII");
    map.put('\u151C', "CANADIAN SYLLABICS WEST-CREE SHWII");
    map.put('\u151D', "CANADIAN SYLLABICS SHWO");
    map.put('\u151E', "CANADIAN SYLLABICS WEST-CREE SHWO");
    map.put('\u151F', "CANADIAN SYLLABICS SHWOO");
    map.put('\u1520', "CANADIAN SYLLABICS WEST-CREE SHWOO");
    map.put('\u1521', "CANADIAN SYLLABICS SHWA");
    map.put('\u1522', "CANADIAN SYLLABICS WEST-CREE SHWA");
    map.put('\u1523', "CANADIAN SYLLABICS SHWAA");
    map.put('\u1524', "CANADIAN SYLLABICS WEST-CREE SHWAA");
    map.put('\u1525', "CANADIAN SYLLABICS SH");
    map.put('\u1526', "CANADIAN SYLLABICS YE");
    map.put('\u1527', "CANADIAN SYLLABICS YAAI");
    map.put('\u1528', "CANADIAN SYLLABICS YI");
    map.put('\u1529', "CANADIAN SYLLABICS YII");
    map.put('\u152A', "CANADIAN SYLLABICS YO");
    map.put('\u152B', "CANADIAN SYLLABICS YOO");
    map.put('\u152C', "CANADIAN SYLLABICS Y-CREE YOO");
    map.put('\u152D', "CANADIAN SYLLABICS YA");
    map.put('\u152E', "CANADIAN SYLLABICS YAA");
    map.put('\u152F', "CANADIAN SYLLABICS YWE");
    map.put('\u1530', "CANADIAN SYLLABICS WEST-CREE YWE");
    map.put('\u1531', "CANADIAN SYLLABICS YWI");
    map.put('\u1532', "CANADIAN SYLLABICS WEST-CREE YWI");
    map.put('\u1533', "CANADIAN SYLLABICS YWII");
    map.put('\u1534', "CANADIAN SYLLABICS WEST-CREE YWII");
    map.put('\u1535', "CANADIAN SYLLABICS YWO");
    map.put('\u1536', "CANADIAN SYLLABICS WEST-CREE YWO");
    map.put('\u1537', "CANADIAN SYLLABICS YWOO");
    map.put('\u1538', "CANADIAN SYLLABICS WEST-CREE YWOO");
    map.put('\u1539', "CANADIAN SYLLABICS YWA");
    map.put('\u153A', "CANADIAN SYLLABICS WEST-CREE YWA");
    map.put('\u153B', "CANADIAN SYLLABICS YWAA");
    map.put('\u153C', "CANADIAN SYLLABICS WEST-CREE YWAA");
    map.put('\u153D', "CANADIAN SYLLABICS NASKAPI YWAA");
    map.put('\u153E', "CANADIAN SYLLABICS Y");
    map.put('\u153F', "CANADIAN SYLLABICS BIBLE-CREE Y");
    map.put('\u1540', "CANADIAN SYLLABICS WEST-CREE Y");
    map.put('\u1541', "CANADIAN SYLLABICS SAYISI YI");
    map.put('\u1542', "CANADIAN SYLLABICS RE");
    map.put('\u1543', "CANADIAN SYLLABICS R-CREE RE");
    map.put('\u1544', "CANADIAN SYLLABICS WEST-CREE LE");
    map.put('\u1545', "CANADIAN SYLLABICS RAAI");
    map.put('\u1546', "CANADIAN SYLLABICS RI");
    map.put('\u1547', "CANADIAN SYLLABICS RII");
    map.put('\u1548', "CANADIAN SYLLABICS RO");
    map.put('\u1549', "CANADIAN SYLLABICS ROO");
    map.put('\u154A', "CANADIAN SYLLABICS WEST-CREE LO");
    map.put('\u154B', "CANADIAN SYLLABICS RA");
    map.put('\u154C', "CANADIAN SYLLABICS RAA");
    map.put('\u154D', "CANADIAN SYLLABICS WEST-CREE LA");
    map.put('\u154E', "CANADIAN SYLLABICS RWAA");
    map.put('\u154F', "CANADIAN SYLLABICS WEST-CREE RWAA");
    map.put('\u1550', "CANADIAN SYLLABICS R");
    map.put('\u1551', "CANADIAN SYLLABICS WEST-CREE R");
    map.put('\u1552', "CANADIAN SYLLABICS MEDIAL R");
    map.put('\u1553', "CANADIAN SYLLABICS FE");
    map.put('\u1554', "CANADIAN SYLLABICS FAAI");
    map.put('\u1555', "CANADIAN SYLLABICS FI");
    map.put('\u1556', "CANADIAN SYLLABICS FII");
    map.put('\u1557', "CANADIAN SYLLABICS FO");
    map.put('\u1558', "CANADIAN SYLLABICS FOO");
    map.put('\u1559', "CANADIAN SYLLABICS FA");
    map.put('\u155A', "CANADIAN SYLLABICS FAA");
    map.put('\u155B', "CANADIAN SYLLABICS FWAA");
    map.put('\u155C', "CANADIAN SYLLABICS WEST-CREE FWAA");
    map.put('\u155D', "CANADIAN SYLLABICS F");
    map.put('\u155E', "CANADIAN SYLLABICS THE");
    map.put('\u155F', "CANADIAN SYLLABICS N-CREE THE");
    map.put('\u1560', "CANADIAN SYLLABICS THI");
    map.put('\u1561', "CANADIAN SYLLABICS N-CREE THI");
    map.put('\u1562', "CANADIAN SYLLABICS THII");
    map.put('\u1563', "CANADIAN SYLLABICS N-CREE THII");
    map.put('\u1564', "CANADIAN SYLLABICS THO");
    map.put('\u1565', "CANADIAN SYLLABICS THOO");
    map.put('\u1566', "CANADIAN SYLLABICS THA");
    map.put('\u1567', "CANADIAN SYLLABICS THAA");
    map.put('\u1568', "CANADIAN SYLLABICS THWAA");
    map.put('\u1569', "CANADIAN SYLLABICS WEST-CREE THWAA");
    map.put('\u156A', "CANADIAN SYLLABICS TH");
    map.put('\u156B', "CANADIAN SYLLABICS TTHE");
    map.put('\u156C', "CANADIAN SYLLABICS TTHI");
    map.put('\u156D', "CANADIAN SYLLABICS TTHO");
    map.put('\u156E', "CANADIAN SYLLABICS TTHA");
    map.put('\u156F', "CANADIAN SYLLABICS TTH");
    map.put('\u1570', "CANADIAN SYLLABICS TYE");
    map.put('\u1571', "CANADIAN SYLLABICS TYI");
    map.put('\u1572', "CANADIAN SYLLABICS TYO");
    map.put('\u1573', "CANADIAN SYLLABICS TYA");
    map.put('\u1574', "CANADIAN SYLLABICS NUNAVIK HE");
    map.put('\u1575', "CANADIAN SYLLABICS NUNAVIK HI");
    map.put('\u1576', "CANADIAN SYLLABICS NUNAVIK HII");
    map.put('\u1577', "CANADIAN SYLLABICS NUNAVIK HO");
    map.put('\u1578', "CANADIAN SYLLABICS NUNAVIK HOO");
    map.put('\u1579', "CANADIAN SYLLABICS NUNAVIK HA");
    map.put('\u157A', "CANADIAN SYLLABICS NUNAVIK HAA");
    map.put('\u157B', "CANADIAN SYLLABICS NUNAVIK H");
    map.put('\u157C', "CANADIAN SYLLABICS NUNAVUT H");
    map.put('\u157D', "CANADIAN SYLLABICS HK");
    map.put('\u157E', "CANADIAN SYLLABICS QAAI");
    map.put('\u157F', "CANADIAN SYLLABICS QI");
    map.put('\u1580', "CANADIAN SYLLABICS QII");
    map.put('\u1581', "CANADIAN SYLLABICS QO");
    map.put('\u1582', "CANADIAN SYLLABICS QOO");
    map.put('\u1583', "CANADIAN SYLLABICS QA");
    map.put('\u1584', "CANADIAN SYLLABICS QAA");
    map.put('\u1585', "CANADIAN SYLLABICS Q");
    map.put('\u1586', "CANADIAN SYLLABICS TLHE");
    map.put('\u1587', "CANADIAN SYLLABICS TLHI");
    map.put('\u1588', "CANADIAN SYLLABICS TLHO");
    map.put('\u1589', "CANADIAN SYLLABICS TLHA");
    map.put('\u158A', "CANADIAN SYLLABICS WEST-CREE RE");
    map.put('\u158B', "CANADIAN SYLLABICS WEST-CREE RI");
    map.put('\u158C', "CANADIAN SYLLABICS WEST-CREE RO");
    map.put('\u158D', "CANADIAN SYLLABICS WEST-CREE RA");
    map.put('\u158E', "CANADIAN SYLLABICS NGAAI");
    map.put('\u158F', "CANADIAN SYLLABICS NGI");
    map.put('\u1590', "CANADIAN SYLLABICS NGII");
    map.put('\u1591', "CANADIAN SYLLABICS NGO");
    map.put('\u1592', "CANADIAN SYLLABICS NGOO");
    map.put('\u1593', "CANADIAN SYLLABICS NGA");
    map.put('\u1594', "CANADIAN SYLLABICS NGAA");
    map.put('\u1595', "CANADIAN SYLLABICS NG");
    map.put('\u1596', "CANADIAN SYLLABICS NNG");
    map.put('\u1597', "CANADIAN SYLLABICS SAYISI SHE");
    map.put('\u1598', "CANADIAN SYLLABICS SAYISI SHI");
    map.put('\u1599', "CANADIAN SYLLABICS SAYISI SHO");
    map.put('\u159A', "CANADIAN SYLLABICS SAYISI SHA");
    map.put('\u159B', "CANADIAN SYLLABICS WOODS-CREE THE");
    map.put('\u159C', "CANADIAN SYLLABICS WOODS-CREE THI");
    map.put('\u159D', "CANADIAN SYLLABICS WOODS-CREE THO");
    map.put('\u159E', "CANADIAN SYLLABICS WOODS-CREE THA");
    map.put('\u159F', "CANADIAN SYLLABICS WOODS-CREE TH");
    map.put('\u15A0', "CANADIAN SYLLABICS LHI");
    map.put('\u15A1', "CANADIAN SYLLABICS LHII");
    map.put('\u15A2', "CANADIAN SYLLABICS LHO");
    map.put('\u15A3', "CANADIAN SYLLABICS LHOO");
    map.put('\u15A4', "CANADIAN SYLLABICS LHA");
    map.put('\u15A5', "CANADIAN SYLLABICS LHAA");
    map.put('\u15A6', "CANADIAN SYLLABICS LH");
    map.put('\u15A7', "CANADIAN SYLLABICS TH-CREE THE");
    map.put('\u15A8', "CANADIAN SYLLABICS TH-CREE THI");
    map.put('\u15A9', "CANADIAN SYLLABICS TH-CREE THII");
    map.put('\u15AA', "CANADIAN SYLLABICS TH-CREE THO");
    map.put('\u15AB', "CANADIAN SYLLABICS TH-CREE THOO");
    map.put('\u15AC', "CANADIAN SYLLABICS TH-CREE THA");
    map.put('\u15AD', "CANADIAN SYLLABICS TH-CREE THAA");
    map.put('\u15AE', "CANADIAN SYLLABICS TH-CREE TH");
    map.put('\u15AF', "CANADIAN SYLLABICS AIVILIK B");
    map.put('\u15B0', "CANADIAN SYLLABICS BLACKFOOT E");
    map.put('\u15B1', "CANADIAN SYLLABICS BLACKFOOT I");
    map.put('\u15B2', "CANADIAN SYLLABICS BLACKFOOT O");
    map.put('\u15B3', "CANADIAN SYLLABICS BLACKFOOT A");
    map.put('\u15B4', "CANADIAN SYLLABICS BLACKFOOT WE");
    map.put('\u15B5', "CANADIAN SYLLABICS BLACKFOOT WI");
    map.put('\u15B6', "CANADIAN SYLLABICS BLACKFOOT WO");
    map.put('\u15B7', "CANADIAN SYLLABICS BLACKFOOT WA");
    map.put('\u15B8', "CANADIAN SYLLABICS BLACKFOOT NE");
    map.put('\u15B9', "CANADIAN SYLLABICS BLACKFOOT NI");
    map.put('\u15BA', "CANADIAN SYLLABICS BLACKFOOT NO");
    map.put('\u15BB', "CANADIAN SYLLABICS BLACKFOOT NA");
    map.put('\u15BC', "CANADIAN SYLLABICS BLACKFOOT KE");
    map.put('\u15BD', "CANADIAN SYLLABICS BLACKFOOT KI");
    map.put('\u15BE', "CANADIAN SYLLABICS BLACKFOOT KO");
    map.put('\u15BF', "CANADIAN SYLLABICS BLACKFOOT KA");
    map.put('\u15C0', "CANADIAN SYLLABICS SAYISI HE");
    map.put('\u15C1', "CANADIAN SYLLABICS SAYISI HI");
    map.put('\u15C2', "CANADIAN SYLLABICS SAYISI HO");
    map.put('\u15C3', "CANADIAN SYLLABICS SAYISI HA");
    map.put('\u15C4', "CANADIAN SYLLABICS CARRIER GHU");
    map.put('\u15C5', "CANADIAN SYLLABICS CARRIER GHO");
    map.put('\u15C6', "CANADIAN SYLLABICS CARRIER GHE");
    map.put('\u15C7', "CANADIAN SYLLABICS CARRIER GHEE");
    map.put('\u15C8', "CANADIAN SYLLABICS CARRIER GHI");
    map.put('\u15C9', "CANADIAN SYLLABICS CARRIER GHA");
    map.put('\u15CA', "CANADIAN SYLLABICS CARRIER RU");
    map.put('\u15CB', "CANADIAN SYLLABICS CARRIER RO");
    map.put('\u15CC', "CANADIAN SYLLABICS CARRIER RE");
    map.put('\u15CD', "CANADIAN SYLLABICS CARRIER REE");
    map.put('\u15CE', "CANADIAN SYLLABICS CARRIER RI");
    map.put('\u15CF', "CANADIAN SYLLABICS CARRIER RA");
    map.put('\u15D0', "CANADIAN SYLLABICS CARRIER WU");
    map.put('\u15D1', "CANADIAN SYLLABICS CARRIER WO");
    map.put('\u15D2', "CANADIAN SYLLABICS CARRIER WE");
    map.put('\u15D3', "CANADIAN SYLLABICS CARRIER WEE");
    map.put('\u15D4', "CANADIAN SYLLABICS CARRIER WI");
    map.put('\u15D5', "CANADIAN SYLLABICS CARRIER WA");
    map.put('\u15D6', "CANADIAN SYLLABICS CARRIER HWU");
    map.put('\u15D7', "CANADIAN SYLLABICS CARRIER HWO");
    map.put('\u15D8', "CANADIAN SYLLABICS CARRIER HWE");
    map.put('\u15D9', "CANADIAN SYLLABICS CARRIER HWEE");
    map.put('\u15DA', "CANADIAN SYLLABICS CARRIER HWI");
    map.put('\u15DB', "CANADIAN SYLLABICS CARRIER HWA");
    map.put('\u15DC', "CANADIAN SYLLABICS CARRIER THU");
    map.put('\u15DD', "CANADIAN SYLLABICS CARRIER THO");
    map.put('\u15DE', "CANADIAN SYLLABICS CARRIER THE");
    map.put('\u15DF', "CANADIAN SYLLABICS CARRIER THEE");
    map.put('\u15E0', "CANADIAN SYLLABICS CARRIER THI");
    map.put('\u15E1', "CANADIAN SYLLABICS CARRIER THA");
    map.put('\u15E2', "CANADIAN SYLLABICS CARRIER TTU");
    map.put('\u15E3', "CANADIAN SYLLABICS CARRIER TTO");
    map.put('\u15E4', "CANADIAN SYLLABICS CARRIER TTE");
    map.put('\u15E5', "CANADIAN SYLLABICS CARRIER TTEE");
    map.put('\u15E6', "CANADIAN SYLLABICS CARRIER TTI");
    map.put('\u15E7', "CANADIAN SYLLABICS CARRIER TTA");
    map.put('\u15E8', "CANADIAN SYLLABICS CARRIER PU");
    map.put('\u15E9', "CANADIAN SYLLABICS CARRIER PO");
    map.put('\u15EA', "CANADIAN SYLLABICS CARRIER PE");
    map.put('\u15EB', "CANADIAN SYLLABICS CARRIER PEE");
    map.put('\u15EC', "CANADIAN SYLLABICS CARRIER PI");
    map.put('\u15ED', "CANADIAN SYLLABICS CARRIER PA");
    map.put('\u15EE', "CANADIAN SYLLABICS CARRIER P");
    map.put('\u15EF', "CANADIAN SYLLABICS CARRIER GU");
    map.put('\u15F0', "CANADIAN SYLLABICS CARRIER GO");
    map.put('\u15F1', "CANADIAN SYLLABICS CARRIER GE");
    map.put('\u15F2', "CANADIAN SYLLABICS CARRIER GEE");
    map.put('\u15F3', "CANADIAN SYLLABICS CARRIER GI");
    map.put('\u15F4', "CANADIAN SYLLABICS CARRIER GA");
    map.put('\u15F5', "CANADIAN SYLLABICS CARRIER KHU");
    map.put('\u15F6', "CANADIAN SYLLABICS CARRIER KHO");
    map.put('\u15F7', "CANADIAN SYLLABICS CARRIER KHE");
    map.put('\u15F8', "CANADIAN SYLLABICS CARRIER KHEE");
    map.put('\u15F9', "CANADIAN SYLLABICS CARRIER KHI");
    map.put('\u15FA', "CANADIAN SYLLABICS CARRIER KHA");
    map.put('\u15FB', "CANADIAN SYLLABICS CARRIER KKU");
    map.put('\u15FC', "CANADIAN SYLLABICS CARRIER KKO");
    map.put('\u15FD', "CANADIAN SYLLABICS CARRIER KKE");
    map.put('\u15FE', "CANADIAN SYLLABICS CARRIER KKEE");
    map.put('\u15FF', "CANADIAN SYLLABICS CARRIER KKI");
    map.put('\u1600', "CANADIAN SYLLABICS CARRIER KKA");
    map.put('\u1601', "CANADIAN SYLLABICS CARRIER KK");
    map.put('\u1602', "CANADIAN SYLLABICS CARRIER NU");
    map.put('\u1603', "CANADIAN SYLLABICS CARRIER NO");
    map.put('\u1604', "CANADIAN SYLLABICS CARRIER NE");
    map.put('\u1605', "CANADIAN SYLLABICS CARRIER NEE");
    map.put('\u1606', "CANADIAN SYLLABICS CARRIER NI");
    map.put('\u1607', "CANADIAN SYLLABICS CARRIER NA");
    map.put('\u1608', "CANADIAN SYLLABICS CARRIER MU");
    map.put('\u1609', "CANADIAN SYLLABICS CARRIER MO");
    map.put('\u160A', "CANADIAN SYLLABICS CARRIER ME");
    map.put('\u160B', "CANADIAN SYLLABICS CARRIER MEE");
    map.put('\u160C', "CANADIAN SYLLABICS CARRIER MI");
    map.put('\u160D', "CANADIAN SYLLABICS CARRIER MA");
    map.put('\u160E', "CANADIAN SYLLABICS CARRIER YU");
    map.put('\u160F', "CANADIAN SYLLABICS CARRIER YO");
    map.put('\u1610', "CANADIAN SYLLABICS CARRIER YE");
    map.put('\u1611', "CANADIAN SYLLABICS CARRIER YEE");
    map.put('\u1612', "CANADIAN SYLLABICS CARRIER YI");
    map.put('\u1613', "CANADIAN SYLLABICS CARRIER YA");
    map.put('\u1614', "CANADIAN SYLLABICS CARRIER JU");
    map.put('\u1615', "CANADIAN SYLLABICS SAYISI JU");
    map.put('\u1616', "CANADIAN SYLLABICS CARRIER JO");
    map.put('\u1617', "CANADIAN SYLLABICS CARRIER JE");
    map.put('\u1618', "CANADIAN SYLLABICS CARRIER JEE");
    map.put('\u1619', "CANADIAN SYLLABICS CARRIER JI");
    map.put('\u161A', "CANADIAN SYLLABICS SAYISI JI");
    map.put('\u161B', "CANADIAN SYLLABICS CARRIER JA");
    map.put('\u161C', "CANADIAN SYLLABICS CARRIER JJU");
    map.put('\u161D', "CANADIAN SYLLABICS CARRIER JJO");
    map.put('\u161E', "CANADIAN SYLLABICS CARRIER JJE");
    map.put('\u161F', "CANADIAN SYLLABICS CARRIER JJEE");
    map.put('\u1620', "CANADIAN SYLLABICS CARRIER JJI");
    map.put('\u1621', "CANADIAN SYLLABICS CARRIER JJA");
    map.put('\u1622', "CANADIAN SYLLABICS CARRIER LU");
    map.put('\u1623', "CANADIAN SYLLABICS CARRIER LO");
    map.put('\u1624', "CANADIAN SYLLABICS CARRIER LE");
    map.put('\u1625', "CANADIAN SYLLABICS CARRIER LEE");
    map.put('\u1626', "CANADIAN SYLLABICS CARRIER LI");
    map.put('\u1627', "CANADIAN SYLLABICS CARRIER LA");
    map.put('\u1628', "CANADIAN SYLLABICS CARRIER DLU");
    map.put('\u1629', "CANADIAN SYLLABICS CARRIER DLO");
    map.put('\u162A', "CANADIAN SYLLABICS CARRIER DLE");
    map.put('\u162B', "CANADIAN SYLLABICS CARRIER DLEE");
    map.put('\u162C', "CANADIAN SYLLABICS CARRIER DLI");
    map.put('\u162D', "CANADIAN SYLLABICS CARRIER DLA");
    map.put('\u162E', "CANADIAN SYLLABICS CARRIER LHU");
    map.put('\u162F', "CANADIAN SYLLABICS CARRIER LHO");
    map.put('\u1630', "CANADIAN SYLLABICS CARRIER LHE");
    map.put('\u1631', "CANADIAN SYLLABICS CARRIER LHEE");
    map.put('\u1632', "CANADIAN SYLLABICS CARRIER LHI");
    map.put('\u1633', "CANADIAN SYLLABICS CARRIER LHA");
    map.put('\u1634', "CANADIAN SYLLABICS CARRIER TLHU");
    map.put('\u1635', "CANADIAN SYLLABICS CARRIER TLHO");
    map.put('\u1636', "CANADIAN SYLLABICS CARRIER TLHE");
    map.put('\u1637', "CANADIAN SYLLABICS CARRIER TLHEE");
    map.put('\u1638', "CANADIAN SYLLABICS CARRIER TLHI");
    map.put('\u1639', "CANADIAN SYLLABICS CARRIER TLHA");
    map.put('\u163A', "CANADIAN SYLLABICS CARRIER TLU");
    map.put('\u163B', "CANADIAN SYLLABICS CARRIER TLO");
    map.put('\u163C', "CANADIAN SYLLABICS CARRIER TLE");
    map.put('\u163D', "CANADIAN SYLLABICS CARRIER TLEE");
    map.put('\u163E', "CANADIAN SYLLABICS CARRIER TLI");
    map.put('\u163F', "CANADIAN SYLLABICS CARRIER TLA");
    map.put('\u1640', "CANADIAN SYLLABICS CARRIER ZU");
    map.put('\u1641', "CANADIAN SYLLABICS CARRIER ZO");
    map.put('\u1642', "CANADIAN SYLLABICS CARRIER ZE");
    map.put('\u1643', "CANADIAN SYLLABICS CARRIER ZEE");
    map.put('\u1644', "CANADIAN SYLLABICS CARRIER ZI");
    map.put('\u1645', "CANADIAN SYLLABICS CARRIER ZA");
    map.put('\u1646', "CANADIAN SYLLABICS CARRIER Z");
    map.put('\u1647', "CANADIAN SYLLABICS CARRIER INITIAL Z");
    map.put('\u1648', "CANADIAN SYLLABICS CARRIER DZU");
    map.put('\u1649', "CANADIAN SYLLABICS CARRIER DZO");
    map.put('\u164A', "CANADIAN SYLLABICS CARRIER DZE");
    map.put('\u164B', "CANADIAN SYLLABICS CARRIER DZEE");
    map.put('\u164C', "CANADIAN SYLLABICS CARRIER DZI");
    map.put('\u164D', "CANADIAN SYLLABICS CARRIER DZA");
    map.put('\u164E', "CANADIAN SYLLABICS CARRIER SU");
    map.put('\u164F', "CANADIAN SYLLABICS CARRIER SO");
    map.put('\u1650', "CANADIAN SYLLABICS CARRIER SE");
    map.put('\u1651', "CANADIAN SYLLABICS CARRIER SEE");
    map.put('\u1652', "CANADIAN SYLLABICS CARRIER SI");
    map.put('\u1653', "CANADIAN SYLLABICS CARRIER SA");
    map.put('\u1654', "CANADIAN SYLLABICS CARRIER SHU");
    map.put('\u1655', "CANADIAN SYLLABICS CARRIER SHO");
    map.put('\u1656', "CANADIAN SYLLABICS CARRIER SHE");
    map.put('\u1657', "CANADIAN SYLLABICS CARRIER SHEE");
    map.put('\u1658', "CANADIAN SYLLABICS CARRIER SHI");
    map.put('\u1659', "CANADIAN SYLLABICS CARRIER SHA");
    map.put('\u165A', "CANADIAN SYLLABICS CARRIER SH");
    map.put('\u165B', "CANADIAN SYLLABICS CARRIER TSU");
    map.put('\u165C', "CANADIAN SYLLABICS CARRIER TSO");
    map.put('\u165D', "CANADIAN SYLLABICS CARRIER TSE");
    map.put('\u165E', "CANADIAN SYLLABICS CARRIER TSEE");
    map.put('\u165F', "CANADIAN SYLLABICS CARRIER TSI");
    map.put('\u1660', "CANADIAN SYLLABICS CARRIER TSA");
    map.put('\u1661', "CANADIAN SYLLABICS CARRIER CHU");
    map.put('\u1662', "CANADIAN SYLLABICS CARRIER CHO");
    map.put('\u1663', "CANADIAN SYLLABICS CARRIER CHE");
    map.put('\u1664', "CANADIAN SYLLABICS CARRIER CHEE");
    map.put('\u1665', "CANADIAN SYLLABICS CARRIER CHI");
    map.put('\u1666', "CANADIAN SYLLABICS CARRIER CHA");
    map.put('\u1667', "CANADIAN SYLLABICS CARRIER TTSU");
    map.put('\u1668', "CANADIAN SYLLABICS CARRIER TTSO");
    map.put('\u1669', "CANADIAN SYLLABICS CARRIER TTSE");
    map.put('\u166A', "CANADIAN SYLLABICS CARRIER TTSEE");
    map.put('\u166B', "CANADIAN SYLLABICS CARRIER TTSI");
    map.put('\u166C', "CANADIAN SYLLABICS CARRIER TTSA");
    map.put('\u166D', "CANADIAN SYLLABICS CHI SIGN");
    map.put('\u166E', "CANADIAN SYLLABICS FULL STOP");
    map.put('\u166F', "CANADIAN SYLLABICS QAI");
    map.put('\u1670', "CANADIAN SYLLABICS NGAI");
    map.put('\u1671', "CANADIAN SYLLABICS NNGI");
    map.put('\u1672', "CANADIAN SYLLABICS NNGII");
    map.put('\u1673', "CANADIAN SYLLABICS NNGO");
    map.put('\u1674', "CANADIAN SYLLABICS NNGOO");
    map.put('\u1675', "CANADIAN SYLLABICS NNGA");
    map.put('\u1676', "CANADIAN SYLLABICS NNGAA");
    map.put('\u1677', "CANADIAN SYLLABICS WOODS-CREE THWEE");
    map.put('\u1678', "CANADIAN SYLLABICS WOODS-CREE THWI");
    map.put('\u1679', "CANADIAN SYLLABICS WOODS-CREE THWII");
    map.put('\u167A', "CANADIAN SYLLABICS WOODS-CREE THWO");
    map.put('\u167B', "CANADIAN SYLLABICS WOODS-CREE THWOO");
    map.put('\u167C', "CANADIAN SYLLABICS WOODS-CREE THWA");
    map.put('\u167D', "CANADIAN SYLLABICS WOODS-CREE THWAA");
    map.put('\u167E', "CANADIAN SYLLABICS WOODS-CREE FINAL TH");
    map.put('\u167F', "CANADIAN SYLLABICS BLACKFOOT W");

  }

  public static final void ogham(Map<Character, String> map) {

    map.put('\u1680', "OGHAM SPACE MARK");
    map.put('\u1681', "OGHAM LETTER BEITH");
    map.put('\u1682', "OGHAM LETTER LUIS");
    map.put('\u1683', "OGHAM LETTER FEARN");
    map.put('\u1684', "OGHAM LETTER SAIL");
    map.put('\u1685', "OGHAM LETTER NION");
    map.put('\u1686', "OGHAM LETTER UATH");
    map.put('\u1687', "OGHAM LETTER DAIR");
    map.put('\u1688', "OGHAM LETTER TINNE");
    map.put('\u1689', "OGHAM LETTER COLL");
    map.put('\u168A', "OGHAM LETTER CEIRT");
    map.put('\u168B', "OGHAM LETTER MUIN");
    map.put('\u168C', "OGHAM LETTER GORT");
    map.put('\u168D', "OGHAM LETTER NGEADAL");
    map.put('\u168E', "OGHAM LETTER STRAIF");
    map.put('\u168F', "OGHAM LETTER RUIS");
    map.put('\u1690', "OGHAM LETTER AILM");
    map.put('\u1691', "OGHAM LETTER ONN");
    map.put('\u1692', "OGHAM LETTER UR");
    map.put('\u1693', "OGHAM LETTER EADHADH");
    map.put('\u1694', "OGHAM LETTER IODHADH");
    map.put('\u1695', "OGHAM LETTER EABHADH");
    map.put('\u1696', "OGHAM LETTER OR");
    map.put('\u1697', "OGHAM LETTER UILLEANN");
    map.put('\u1698', "OGHAM LETTER IFIN");
    map.put('\u1699', "OGHAM LETTER EAMHANCHOLL");
    map.put('\u169A', "OGHAM LETTER PEITH");
    map.put('\u169B', "OGHAM FEATHER MARK");
    map.put('\u169C', "OGHAM REVERSED FEATHER MARK");

  }

  public static final void runic(Map<Character, String> map) {

    map.put('\u16A0', "RUNIC LETTER FEHU FEOH FE F");
    map.put('\u16A1', "RUNIC LETTER V");
    map.put('\u16A2', "RUNIC LETTER URUZ UR U");
    map.put('\u16A3', "RUNIC LETTER YR");
    map.put('\u16A4', "RUNIC LETTER Y");
    map.put('\u16A5', "RUNIC LETTER W");
    map.put('\u16A6', "RUNIC LETTER THURISAZ THURS THORN");
    map.put('\u16A7', "RUNIC LETTER ETH");
    map.put('\u16A8', "RUNIC LETTER ANSUZ A");
    map.put('\u16A9', "RUNIC LETTER OS O");
    map.put('\u16AA', "RUNIC LETTER AC A");
    map.put('\u16AB', "RUNIC LETTER AESC");
    map.put('\u16AC', "RUNIC LETTER LONG-BRANCH-OSS O");
    map.put('\u16AD', "RUNIC LETTER SHORT-TWIG-OSS O");
    map.put('\u16AE', "RUNIC LETTER O");
    map.put('\u16AF', "RUNIC LETTER OE");
    map.put('\u16B0', "RUNIC LETTER ON");
    map.put('\u16B1', "RUNIC LETTER RAIDO RAD REID R");
    map.put('\u16B2', "RUNIC LETTER KAUNA");
    map.put('\u16B3', "RUNIC LETTER CEN");
    map.put('\u16B4', "RUNIC LETTER KAUN K");
    map.put('\u16B5', "RUNIC LETTER G");
    map.put('\u16B6', "RUNIC LETTER ENG");
    map.put('\u16B7', "RUNIC LETTER GEBO GYFU G");
    map.put('\u16B8', "RUNIC LETTER GAR");
    map.put('\u16B9', "RUNIC LETTER WUNJO WYNN W");
    map.put('\u16BA', "RUNIC LETTER HAGLAZ H");
    map.put('\u16BB', "RUNIC LETTER HAEGL H");
    map.put('\u16BC', "RUNIC LETTER LONG-BRANCH-HAGALL H");
    map.put('\u16BD', "RUNIC LETTER SHORT-TWIG-HAGALL H");
    map.put('\u16BE', "RUNIC LETTER NAUDIZ NYD NAUD N");
    map.put('\u16BF', "RUNIC LETTER SHORT-TWIG-NAUD N");
    map.put('\u16C0', "RUNIC LETTER DOTTED-N");
    map.put('\u16C1', "RUNIC LETTER ISAZ IS ISS I");
    map.put('\u16C2', "RUNIC LETTER E");
    map.put('\u16C3', "RUNIC LETTER JERAN J");
    map.put('\u16C4', "RUNIC LETTER GER");
    map.put('\u16C5', "RUNIC LETTER LONG-BRANCH-AR AE");
    map.put('\u16C6', "RUNIC LETTER SHORT-TWIG-AR A");
    map.put('\u16C7', "RUNIC LETTER IWAZ EOH");
    map.put('\u16C8', "RUNIC LETTER PERTHO PEORTH P");
    map.put('\u16C9', "RUNIC LETTER ALGIZ EOLHX");
    map.put('\u16CA', "RUNIC LETTER SOWILO S");
    map.put('\u16CB', "RUNIC LETTER SIGEL LONG-BRANCH-SOL S");
    map.put('\u16CC', "RUNIC LETTER SHORT-TWIG-SOL S");
    map.put('\u16CD', "RUNIC LETTER C");
    map.put('\u16CE', "RUNIC LETTER Z");
    map.put('\u16CF', "RUNIC LETTER TIWAZ TIR TYR T");
    map.put('\u16D0', "RUNIC LETTER SHORT-TWIG-TYR T");
    map.put('\u16D1', "RUNIC LETTER D");
    map.put('\u16D2', "RUNIC LETTER BERKANAN BEORC BJARKAN B");
    map.put('\u16D3', "RUNIC LETTER SHORT-TWIG-BJARKAN B");
    map.put('\u16D4', "RUNIC LETTER DOTTED-P");
    map.put('\u16D5', "RUNIC LETTER OPEN-P");
    map.put('\u16D6', "RUNIC LETTER EHWAZ EH E");
    map.put('\u16D7', "RUNIC LETTER MANNAZ MAN M");
    map.put('\u16D8', "RUNIC LETTER LONG-BRANCH-MADR M");
    map.put('\u16D9', "RUNIC LETTER SHORT-TWIG-MADR M");
    map.put('\u16DA', "RUNIC LETTER LAUKAZ LAGU LOGR L");
    map.put('\u16DB', "RUNIC LETTER DOTTED-L");
    map.put('\u16DC', "RUNIC LETTER INGWAZ");
    map.put('\u16DD', "RUNIC LETTER ING");
    map.put('\u16DE', "RUNIC LETTER DAGAZ DAEG D");
    map.put('\u16DF', "RUNIC LETTER OTHALAN ETHEL O");
    map.put('\u16E0', "RUNIC LETTER EAR");
    map.put('\u16E1', "RUNIC LETTER IOR");
    map.put('\u16E2', "RUNIC LETTER CWEORTH");
    map.put('\u16E3', "RUNIC LETTER CALC");
    map.put('\u16E4', "RUNIC LETTER CEALC");
    map.put('\u16E5', "RUNIC LETTER STAN");
    map.put('\u16E6', "RUNIC LETTER LONG-BRANCH-YR");
    map.put('\u16E7', "RUNIC LETTER SHORT-TWIG-YR");
    map.put('\u16E8', "RUNIC LETTER ICELANDIC-YR");
    map.put('\u16E9', "RUNIC LETTER Q");
    map.put('\u16EA', "RUNIC LETTER X");
    map.put('\u16EB', "RUNIC SINGLE PUNCTUATION");
    map.put('\u16EC', "RUNIC MULTIPLE PUNCTUATION");
    map.put('\u16ED', "RUNIC CROSS PUNCTUATION");
    map.put('\u16EE', "RUNIC ARLAUG SYMBOL");
    map.put('\u16EF', "RUNIC TVIMADUR SYMBOL");
    map.put('\u16F0', "RUNIC BELGTHOR SYMBOL");

  }

  public static final void tagalog(Map<Character, String> map) {

    map.put('\u1700', "TAGALOG LETTER A");
    map.put('\u1701', "TAGALOG LETTER I");
    map.put('\u1702', "TAGALOG LETTER U");
    map.put('\u1703', "TAGALOG LETTER KA");
    map.put('\u1704', "TAGALOG LETTER GA");
    map.put('\u1705', "TAGALOG LETTER NGA");
    map.put('\u1706', "TAGALOG LETTER TA");
    map.put('\u1707', "TAGALOG LETTER DA");
    map.put('\u1708', "TAGALOG LETTER NA");
    map.put('\u1709', "TAGALOG LETTER PA");
    map.put('\u170A', "TAGALOG LETTER BA");
    map.put('\u170B', "TAGALOG LETTER MA");
    map.put('\u170C', "TAGALOG LETTER YA");
    map.put('\u170E', "TAGALOG LETTER LA");
    map.put('\u170F', "TAGALOG LETTER WA");
    map.put('\u1710', "TAGALOG LETTER SA");
    map.put('\u1711', "TAGALOG LETTER HA");
    map.put('\u1712', "TAGALOG VOWEL SIGN I");
    map.put('\u1713', "TAGALOG VOWEL SIGN U");
    map.put('\u1714', "TAGALOG SIGN VIRAMA");

  }

  public static final void hanunoo(Map<Character, String> map) {

    map.put('\u1720', "HANUNOO LETTER A");
    map.put('\u1721', "HANUNOO LETTER I");
    map.put('\u1722', "HANUNOO LETTER U");
    map.put('\u1723', "HANUNOO LETTER KA");
    map.put('\u1724', "HANUNOO LETTER GA");
    map.put('\u1725', "HANUNOO LETTER NGA");
    map.put('\u1726', "HANUNOO LETTER TA");
    map.put('\u1727', "HANUNOO LETTER DA");
    map.put('\u1728', "HANUNOO LETTER NA");
    map.put('\u1729', "HANUNOO LETTER PA");
    map.put('\u172A', "HANUNOO LETTER BA");
    map.put('\u172B', "HANUNOO LETTER MA");
    map.put('\u172C', "HANUNOO LETTER YA");
    map.put('\u172D', "HANUNOO LETTER RA");
    map.put('\u172E', "HANUNOO LETTER LA");
    map.put('\u172F', "HANUNOO LETTER WA");
    map.put('\u1730', "HANUNOO LETTER SA");
    map.put('\u1731', "HANUNOO LETTER HA");
    map.put('\u1732', "HANUNOO VOWEL SIGN I");
    map.put('\u1733', "HANUNOO VOWEL SIGN U");
    map.put('\u1734', "HANUNOO SIGN PAMUDPOD");
    map.put('\u1735', "PHILIPPINE SINGLE PUNCTUATION");
    map.put('\u1736', "PHILIPPINE DOUBLE PUNCTUATION");

  }

  public static final void buhid(Map<Character, String> map) {

    map.put('\u1740', "BUHID LETTER A");
    map.put('\u1741', "BUHID LETTER I");
    map.put('\u1742', "BUHID LETTER U");
    map.put('\u1743', "BUHID LETTER KA");
    map.put('\u1744', "BUHID LETTER GA");
    map.put('\u1745', "BUHID LETTER NGA");
    map.put('\u1746', "BUHID LETTER TA");
    map.put('\u1747', "BUHID LETTER DA");
    map.put('\u1748', "BUHID LETTER NA");
    map.put('\u1749', "BUHID LETTER PA");
    map.put('\u174A', "BUHID LETTER BA");
    map.put('\u174B', "BUHID LETTER MA");
    map.put('\u174C', "BUHID LETTER YA");
    map.put('\u174D', "BUHID LETTER RA");
    map.put('\u174E', "BUHID LETTER LA");
    map.put('\u174F', "BUHID LETTER WA");
    map.put('\u1750', "BUHID LETTER SA");
    map.put('\u1751', "BUHID LETTER HA");
    map.put('\u1752', "BUHID VOWEL SIGN I");
    map.put('\u1753', "BUHID VOWEL SIGN U");

  }

  public static final void tagbanwa(Map<Character, String> map) {

    map.put('\u1760', "TAGBANWA LETTER A");
    map.put('\u1761', "TAGBANWA LETTER I");
    map.put('\u1762', "TAGBANWA LETTER U");
    map.put('\u1763', "TAGBANWA LETTER KA");
    map.put('\u1764', "TAGBANWA LETTER GA");
    map.put('\u1765', "TAGBANWA LETTER NGA");
    map.put('\u1766', "TAGBANWA LETTER TA");
    map.put('\u1767', "TAGBANWA LETTER DA");
    map.put('\u1768', "TAGBANWA LETTER NA");
    map.put('\u1769', "TAGBANWA LETTER PA");
    map.put('\u176A', "TAGBANWA LETTER BA");
    map.put('\u176B', "TAGBANWA LETTER MA");
    map.put('\u176C', "TAGBANWA LETTER YA");
    map.put('\u176E', "TAGBANWA LETTER LA");
    map.put('\u176F', "TAGBANWA LETTER WA");
    map.put('\u1770', "TAGBANWA LETTER SA");
    map.put('\u1772', "TAGBANWA VOWEL SIGN I");
    map.put('\u1773', "TAGBANWA VOWEL SIGN U");

  }

  public static final void khmer(Map<Character, String> map) {

    map.put('\u1780', "KHMER LETTER KA");
    map.put('\u1781', "KHMER LETTER KHA");
    map.put('\u1782', "KHMER LETTER KO");
    map.put('\u1783', "KHMER LETTER KHO");
    map.put('\u1784', "KHMER LETTER NGO");
    map.put('\u1785', "KHMER LETTER CA");
    map.put('\u1786', "KHMER LETTER CHA");
    map.put('\u1787', "KHMER LETTER CO");
    map.put('\u1788', "KHMER LETTER CHO");
    map.put('\u1789', "KHMER LETTER NYO");
    map.put('\u178A', "KHMER LETTER DA");
    map.put('\u178B', "KHMER LETTER TTHA");
    map.put('\u178C', "KHMER LETTER DO");
    map.put('\u178D', "KHMER LETTER TTHO");
    map.put('\u178E', "KHMER LETTER NNO");
    map.put('\u178F', "KHMER LETTER TA");
    map.put('\u1790', "KHMER LETTER THA");
    map.put('\u1791', "KHMER LETTER TO");
    map.put('\u1792', "KHMER LETTER THO");
    map.put('\u1793', "KHMER LETTER NO");
    map.put('\u1794', "KHMER LETTER BA");
    map.put('\u1795', "KHMER LETTER PHA");
    map.put('\u1796', "KHMER LETTER PO");
    map.put('\u1797', "KHMER LETTER PHO");
    map.put('\u1798', "KHMER LETTER MO");
    map.put('\u1799', "KHMER LETTER YO");
    map.put('\u179A', "KHMER LETTER RO");
    map.put('\u179B', "KHMER LETTER LO");
    map.put('\u179C', "KHMER LETTER VO");
    map.put('\u179D', "KHMER LETTER SHA");
    map.put('\u179E', "KHMER LETTER SSO");
    map.put('\u179F', "KHMER LETTER SA");
    map.put('\u17A0', "KHMER LETTER HA");
    map.put('\u17A1', "KHMER LETTER LA");
    map.put('\u17A2', "KHMER LETTER QA");
    map.put('\u17A3', "KHMER INDEPENDENT VOWEL QAQ");
    map.put('\u17A4', "KHMER INDEPENDENT VOWEL QAA");
    map.put('\u17A5', "KHMER INDEPENDENT VOWEL QI");
    map.put('\u17A6', "KHMER INDEPENDENT VOWEL QII");
    map.put('\u17A7', "KHMER INDEPENDENT VOWEL QU");
    map.put('\u17A8', "KHMER INDEPENDENT VOWEL QUK");
    map.put('\u17A9', "KHMER INDEPENDENT VOWEL QUU");
    map.put('\u17AA', "KHMER INDEPENDENT VOWEL QUUV");
    map.put('\u17AB', "KHMER INDEPENDENT VOWEL RY");
    map.put('\u17AC', "KHMER INDEPENDENT VOWEL RYY");
    map.put('\u17AD', "KHMER INDEPENDENT VOWEL LY");
    map.put('\u17AE', "KHMER INDEPENDENT VOWEL LYY");
    map.put('\u17AF', "KHMER INDEPENDENT VOWEL QE");
    map.put('\u17B0', "KHMER INDEPENDENT VOWEL QAI");
    map.put('\u17B1', "KHMER INDEPENDENT VOWEL QOO TYPE ONE");
    map.put('\u17B2', "KHMER INDEPENDENT VOWEL QOO TYPE TWO");
    map.put('\u17B3', "KHMER INDEPENDENT VOWEL QAU");
    map.put('\u17B4', "KHMER VOWEL INHERENT AQ");
    map.put('\u17B5', "KHMER VOWEL INHERENT AA");
    map.put('\u17B6', "KHMER VOWEL SIGN AA");
    map.put('\u17B7', "KHMER VOWEL SIGN I");
    map.put('\u17B8', "KHMER VOWEL SIGN II");
    map.put('\u17B9', "KHMER VOWEL SIGN Y");
    map.put('\u17BA', "KHMER VOWEL SIGN YY");
    map.put('\u17BB', "KHMER VOWEL SIGN U");
    map.put('\u17BC', "KHMER VOWEL SIGN UU");
    map.put('\u17BD', "KHMER VOWEL SIGN UA");
    map.put('\u17BE', "KHMER VOWEL SIGN OE");
    map.put('\u17BF', "KHMER VOWEL SIGN YA");
    map.put('\u17C0', "KHMER VOWEL SIGN IE");
    map.put('\u17C1', "KHMER VOWEL SIGN E");
    map.put('\u17C2', "KHMER VOWEL SIGN AE");
    map.put('\u17C3', "KHMER VOWEL SIGN AI");
    map.put('\u17C4', "KHMER VOWEL SIGN OO");
    map.put('\u17C5', "KHMER VOWEL SIGN AU");
    map.put('\u17C6', "KHMER SIGN NIKAHIT");
    map.put('\u17C7', "KHMER SIGN REAHMUK");
    map.put('\u17C8', "KHMER SIGN YUUKALEAPINTU");
    map.put('\u17C9', "KHMER SIGN MUUSIKATOAN");
    map.put('\u17CA', "KHMER SIGN TRIISAP");
    map.put('\u17CB', "KHMER SIGN BANTOC");
    map.put('\u17CC', "KHMER SIGN ROBAT");
    map.put('\u17CD', "KHMER SIGN TOANDAKHIAT");
    map.put('\u17CE', "KHMER SIGN KAKABAT");
    map.put('\u17CF', "KHMER SIGN AHSDA");
    map.put('\u17D0', "KHMER SIGN SAMYOK SANNYA");
    map.put('\u17D1', "KHMER SIGN VIRIAM");
    map.put('\u17D2', "KHMER SIGN COENG");
    map.put('\u17D3', "KHMER SIGN BATHAMASAT");
    map.put('\u17D4', "KHMER SIGN KHAN");
    map.put('\u17D5', "KHMER SIGN BARIYOOSAN");
    map.put('\u17D6', "KHMER SIGN CAMNUC PII KUUH");
    map.put('\u17D7', "KHMER SIGN LEK TOO");
    map.put('\u17D8', "KHMER SIGN BEYYAL");
    map.put('\u17D9', "KHMER SIGN PHNAEK MUAN");
    map.put('\u17DA', "KHMER SIGN KOOMUUT");
    map.put('\u17DB', "KHMER CURRENCY SYMBOL RIEL");
    map.put('\u17DC', "KHMER SIGN AVAKRAHASANYA");
    map.put('\u17DD', "KHMER SIGN ATTHACAN");
    map.put('\u17E0', "KHMER DIGIT ZERO");
    map.put('\u17E1', "KHMER DIGIT ONE");
    map.put('\u17E2', "KHMER DIGIT TWO");
    map.put('\u17E3', "KHMER DIGIT THREE");
    map.put('\u17E4', "KHMER DIGIT FOUR");
    map.put('\u17E5', "KHMER DIGIT FIVE");
    map.put('\u17E6', "KHMER DIGIT SIX");
    map.put('\u17E7', "KHMER DIGIT SEVEN");
    map.put('\u17E8', "KHMER DIGIT EIGHT");
    map.put('\u17E9', "KHMER DIGIT NINE");
    map.put('\u17F0', "KHMER SYMBOL LEK ATTAK SON");
    map.put('\u17F1', "KHMER SYMBOL LEK ATTAK MUOY");
    map.put('\u17F2', "KHMER SYMBOL LEK ATTAK PII");
    map.put('\u17F3', "KHMER SYMBOL LEK ATTAK BEI");
    map.put('\u17F4', "KHMER SYMBOL LEK ATTAK BUON");
    map.put('\u17F5', "KHMER SYMBOL LEK ATTAK PRAM");
    map.put('\u17F6', "KHMER SYMBOL LEK ATTAK PRAM-MUOY");
    map.put('\u17F7', "KHMER SYMBOL LEK ATTAK PRAM-PII");
    map.put('\u17F8', "KHMER SYMBOL LEK ATTAK PRAM-BEI");
    map.put('\u17F9', "KHMER SYMBOL LEK ATTAK PRAM-BUON");

  }

  public static final void mongolian(Map<Character, String> map) {

    map.put('\u1800', "MONGOLIAN BIRGA");
    map.put('\u1801', "MONGOLIAN ELLIPSIS");
    map.put('\u1802', "MONGOLIAN COMMA");
    map.put('\u1803', "MONGOLIAN FULL STOP");
    map.put('\u1804', "MONGOLIAN COLON");
    map.put('\u1805', "MONGOLIAN FOUR DOTS");
    map.put('\u1806', "MONGOLIAN TODO SOFT HYPHEN");
    map.put('\u1807', "MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER");
    map.put('\u1808', "MONGOLIAN MANCHU COMMA");
    map.put('\u1809', "MONGOLIAN MANCHU FULL STOP");
    map.put('\u180A', "MONGOLIAN NIRUGU");
    map.put('\u180B', "MONGOLIAN FREE VARIATION SELECTOR ONE");
    map.put('\u180C', "MONGOLIAN FREE VARIATION SELECTOR TWO");
    map.put('\u180D', "MONGOLIAN FREE VARIATION SELECTOR THREE");
    map.put('\u180E', "MONGOLIAN VOWEL SEPARATOR");
    map.put('\u1810', "MONGOLIAN DIGIT ZERO");
    map.put('\u1811', "MONGOLIAN DIGIT ONE");
    map.put('\u1812', "MONGOLIAN DIGIT TWO");
    map.put('\u1813', "MONGOLIAN DIGIT THREE");
    map.put('\u1814', "MONGOLIAN DIGIT FOUR");
    map.put('\u1815', "MONGOLIAN DIGIT FIVE");
    map.put('\u1816', "MONGOLIAN DIGIT SIX");
    map.put('\u1817', "MONGOLIAN DIGIT SEVEN");
    map.put('\u1818', "MONGOLIAN DIGIT EIGHT");
    map.put('\u1819', "MONGOLIAN DIGIT NINE");
    map.put('\u1820', "MONGOLIAN LETTER A");
    map.put('\u1821', "MONGOLIAN LETTER E");
    map.put('\u1822', "MONGOLIAN LETTER I");
    map.put('\u1823', "MONGOLIAN LETTER O");
    map.put('\u1824', "MONGOLIAN LETTER U");
    map.put('\u1825', "MONGOLIAN LETTER OE");
    map.put('\u1826', "MONGOLIAN LETTER UE");
    map.put('\u1827', "MONGOLIAN LETTER EE");
    map.put('\u1828', "MONGOLIAN LETTER NA");
    map.put('\u1829', "MONGOLIAN LETTER ANG");
    map.put('\u182A', "MONGOLIAN LETTER BA");
    map.put('\u182B', "MONGOLIAN LETTER PA");
    map.put('\u182C', "MONGOLIAN LETTER QA");
    map.put('\u182D', "MONGOLIAN LETTER GA");
    map.put('\u182E', "MONGOLIAN LETTER MA");
    map.put('\u182F', "MONGOLIAN LETTER LA");
    map.put('\u1830', "MONGOLIAN LETTER SA");
    map.put('\u1831', "MONGOLIAN LETTER SHA");
    map.put('\u1832', "MONGOLIAN LETTER TA");
    map.put('\u1833', "MONGOLIAN LETTER DA");
    map.put('\u1834', "MONGOLIAN LETTER CHA");
    map.put('\u1835', "MONGOLIAN LETTER JA");
    map.put('\u1836', "MONGOLIAN LETTER YA");
    map.put('\u1837', "MONGOLIAN LETTER RA");
    map.put('\u1838', "MONGOLIAN LETTER WA");
    map.put('\u1839', "MONGOLIAN LETTER FA");
    map.put('\u183A', "MONGOLIAN LETTER KA");
    map.put('\u183B', "MONGOLIAN LETTER KHA");
    map.put('\u183C', "MONGOLIAN LETTER TSA");
    map.put('\u183D', "MONGOLIAN LETTER ZA");
    map.put('\u183E', "MONGOLIAN LETTER HAA");
    map.put('\u183F', "MONGOLIAN LETTER ZRA");
    map.put('\u1840', "MONGOLIAN LETTER LHA");
    map.put('\u1841', "MONGOLIAN LETTER ZHI");
    map.put('\u1842', "MONGOLIAN LETTER CHI");
    map.put('\u1843', "MONGOLIAN LETTER TODO LONG VOWEL SIGN");
    map.put('\u1844', "MONGOLIAN LETTER TODO E");
    map.put('\u1845', "MONGOLIAN LETTER TODO I");
    map.put('\u1846', "MONGOLIAN LETTER TODO O");
    map.put('\u1847', "MONGOLIAN LETTER TODO U");
    map.put('\u1848', "MONGOLIAN LETTER TODO OE");
    map.put('\u1849', "MONGOLIAN LETTER TODO UE");
    map.put('\u184A', "MONGOLIAN LETTER TODO ANG");
    map.put('\u184B', "MONGOLIAN LETTER TODO BA");
    map.put('\u184C', "MONGOLIAN LETTER TODO PA");
    map.put('\u184D', "MONGOLIAN LETTER TODO QA");
    map.put('\u184E', "MONGOLIAN LETTER TODO GA");
    map.put('\u184F', "MONGOLIAN LETTER TODO MA");
    map.put('\u1850', "MONGOLIAN LETTER TODO TA");
    map.put('\u1851', "MONGOLIAN LETTER TODO DA");
    map.put('\u1852', "MONGOLIAN LETTER TODO CHA");
    map.put('\u1853', "MONGOLIAN LETTER TODO JA");
    map.put('\u1854', "MONGOLIAN LETTER TODO TSA");
    map.put('\u1855', "MONGOLIAN LETTER TODO YA");
    map.put('\u1856', "MONGOLIAN LETTER TODO WA");
    map.put('\u1857', "MONGOLIAN LETTER TODO KA");
    map.put('\u1858', "MONGOLIAN LETTER TODO GAA");
    map.put('\u1859', "MONGOLIAN LETTER TODO HAA");
    map.put('\u185A', "MONGOLIAN LETTER TODO JIA");
    map.put('\u185B', "MONGOLIAN LETTER TODO NIA");
    map.put('\u185C', "MONGOLIAN LETTER TODO DZA");
    map.put('\u185D', "MONGOLIAN LETTER SIBE E");
    map.put('\u185E', "MONGOLIAN LETTER SIBE I");
    map.put('\u185F', "MONGOLIAN LETTER SIBE IY");
    map.put('\u1860', "MONGOLIAN LETTER SIBE UE");
    map.put('\u1861', "MONGOLIAN LETTER SIBE U");
    map.put('\u1862', "MONGOLIAN LETTER SIBE ANG");
    map.put('\u1863', "MONGOLIAN LETTER SIBE KA");
    map.put('\u1864', "MONGOLIAN LETTER SIBE GA");
    map.put('\u1865', "MONGOLIAN LETTER SIBE HA");
    map.put('\u1866', "MONGOLIAN LETTER SIBE PA");
    map.put('\u1867', "MONGOLIAN LETTER SIBE SHA");
    map.put('\u1868', "MONGOLIAN LETTER SIBE TA");
    map.put('\u1869', "MONGOLIAN LETTER SIBE DA");
    map.put('\u186A', "MONGOLIAN LETTER SIBE JA");
    map.put('\u186B', "MONGOLIAN LETTER SIBE FA");
    map.put('\u186C', "MONGOLIAN LETTER SIBE GAA");
    map.put('\u186D', "MONGOLIAN LETTER SIBE HAA");
    map.put('\u186E', "MONGOLIAN LETTER SIBE TSA");
    map.put('\u186F', "MONGOLIAN LETTER SIBE ZA");
    map.put('\u1870', "MONGOLIAN LETTER SIBE RAA");
    map.put('\u1871', "MONGOLIAN LETTER SIBE CHA");
    map.put('\u1872', "MONGOLIAN LETTER SIBE ZHA");
    map.put('\u1873', "MONGOLIAN LETTER MANCHU I");
    map.put('\u1874', "MONGOLIAN LETTER MANCHU KA");
    map.put('\u1875', "MONGOLIAN LETTER MANCHU RA");
    map.put('\u1876', "MONGOLIAN LETTER MANCHU FA");
    map.put('\u1877', "MONGOLIAN LETTER MANCHU ZHA");
    map.put('\u1880', "MONGOLIAN LETTER ALI GALI ANUSVARA ONE");
    map.put('\u1881', "MONGOLIAN LETTER ALI GALI VISARGA ONE");
    map.put('\u1882', "MONGOLIAN LETTER ALI GALI DAMARU");
    map.put('\u1883', "MONGOLIAN LETTER ALI GALI UBADAMA");
    map.put('\u1884', "MONGOLIAN LETTER ALI GALI INVERTED UBADAMA");
    map.put('\u1885', "MONGOLIAN LETTER ALI GALI BALUDA");
    map.put('\u1886', "MONGOLIAN LETTER ALI GALI THREE BALUDA");
    map.put('\u1887', "MONGOLIAN LETTER ALI GALI A");
    map.put('\u1888', "MONGOLIAN LETTER ALI GALI I");
    map.put('\u1889', "MONGOLIAN LETTER ALI GALI KA");
    map.put('\u188A', "MONGOLIAN LETTER ALI GALI NGA");
    map.put('\u188B', "MONGOLIAN LETTER ALI GALI CA");
    map.put('\u188C', "MONGOLIAN LETTER ALI GALI TTA");
    map.put('\u188D', "MONGOLIAN LETTER ALI GALI TTHA");
    map.put('\u188E', "MONGOLIAN LETTER ALI GALI DDA");
    map.put('\u188F', "MONGOLIAN LETTER ALI GALI NNA");
    map.put('\u1890', "MONGOLIAN LETTER ALI GALI TA");
    map.put('\u1891', "MONGOLIAN LETTER ALI GALI DA");
    map.put('\u1892', "MONGOLIAN LETTER ALI GALI PA");
    map.put('\u1893', "MONGOLIAN LETTER ALI GALI PHA");
    map.put('\u1894', "MONGOLIAN LETTER ALI GALI SSA");
    map.put('\u1895', "MONGOLIAN LETTER ALI GALI ZHA");
    map.put('\u1896', "MONGOLIAN LETTER ALI GALI ZA");
    map.put('\u1897', "MONGOLIAN LETTER ALI GALI AH");
    map.put('\u1898', "MONGOLIAN LETTER TODO ALI GALI TA");
    map.put('\u1899', "MONGOLIAN LETTER TODO ALI GALI ZHA");
    map.put('\u189A', "MONGOLIAN LETTER MANCHU ALI GALI GHA");
    map.put('\u189B', "MONGOLIAN LETTER MANCHU ALI GALI NGA");
    map.put('\u189C', "MONGOLIAN LETTER MANCHU ALI GALI CA");
    map.put('\u189D', "MONGOLIAN LETTER MANCHU ALI GALI JHA");
    map.put('\u189E', "MONGOLIAN LETTER MANCHU ALI GALI TTA");
    map.put('\u189F', "MONGOLIAN LETTER MANCHU ALI GALI DDHA");
    map.put('\u18A0', "MONGOLIAN LETTER MANCHU ALI GALI TA");
    map.put('\u18A1', "MONGOLIAN LETTER MANCHU ALI GALI DHA");
    map.put('\u18A2', "MONGOLIAN LETTER MANCHU ALI GALI SSA");
    map.put('\u18A3', "MONGOLIAN LETTER MANCHU ALI GALI CYA");
    map.put('\u18A4', "MONGOLIAN LETTER MANCHU ALI GALI ZHA");
    map.put('\u18A5', "MONGOLIAN LETTER MANCHU ALI GALI ZA");
    map.put('\u18A6', "MONGOLIAN LETTER ALI GALI HALF U");
    map.put('\u18A7', "MONGOLIAN LETTER ALI GALI HALF YA");
    map.put('\u18A8', "MONGOLIAN LETTER MANCHU ALI GALI BHA");
    map.put('\u18A9', "MONGOLIAN LETTER ALI GALI DAGALGA");
    map.put('\u18AA', "MONGOLIAN LETTER MANCHU ALI GALI LHA");

  }

  public static final void canadianSyllabics(Map<Character, String> map) {

    map.put('\u18B0', "CANADIAN SYLLABICS OY");
    map.put('\u18B1', "CANADIAN SYLLABICS AY");
    map.put('\u18B2', "CANADIAN SYLLABICS AAY");
    map.put('\u18B3', "CANADIAN SYLLABICS WAY");
    map.put('\u18B4', "CANADIAN SYLLABICS POY");
    map.put('\u18B5', "CANADIAN SYLLABICS PAY");
    map.put('\u18B6', "CANADIAN SYLLABICS PWOY");
    map.put('\u18B7', "CANADIAN SYLLABICS TAY");
    map.put('\u18B8', "CANADIAN SYLLABICS KAY");
    map.put('\u18B9', "CANADIAN SYLLABICS KWAY");
    map.put('\u18BA', "CANADIAN SYLLABICS MAY");
    map.put('\u18BB', "CANADIAN SYLLABICS NOY");
    map.put('\u18BC', "CANADIAN SYLLABICS NAY");
    map.put('\u18BD', "CANADIAN SYLLABICS LAY");
    map.put('\u18BE', "CANADIAN SYLLABICS SOY");
    map.put('\u18BF', "CANADIAN SYLLABICS SAY");
    map.put('\u18C0', "CANADIAN SYLLABICS SHOY");
    map.put('\u18C1', "CANADIAN SYLLABICS SHAY");
    map.put('\u18C2', "CANADIAN SYLLABICS SHWOY");
    map.put('\u18C3', "CANADIAN SYLLABICS YOY");
    map.put('\u18C4', "CANADIAN SYLLABICS YAY");
    map.put('\u18C5', "CANADIAN SYLLABICS RAY");
    map.put('\u18C6', "CANADIAN SYLLABICS NWI");
    map.put('\u18C7', "CANADIAN SYLLABICS OJIBWAY NWI");
    map.put('\u18C8', "CANADIAN SYLLABICS NWII");
    map.put('\u18C9', "CANADIAN SYLLABICS OJIBWAY NWII");
    map.put('\u18CA', "CANADIAN SYLLABICS NWO");
    map.put('\u18CB', "CANADIAN SYLLABICS OJIBWAY NWO");
    map.put('\u18CC', "CANADIAN SYLLABICS NWOO");
    map.put('\u18CD', "CANADIAN SYLLABICS OJIBWAY NWOO");
    map.put('\u18CE', "CANADIAN SYLLABICS RWEE");
    map.put('\u18CF', "CANADIAN SYLLABICS RWI");
    map.put('\u18D0', "CANADIAN SYLLABICS RWII");
    map.put('\u18D1', "CANADIAN SYLLABICS RWO");
    map.put('\u18D2', "CANADIAN SYLLABICS RWOO");
    map.put('\u18D3', "CANADIAN SYLLABICS RWA");
    map.put('\u18D4', "CANADIAN SYLLABICS OJIBWAY P");
    map.put('\u18D5', "CANADIAN SYLLABICS OJIBWAY T");
    map.put('\u18D6', "CANADIAN SYLLABICS OJIBWAY K");
    map.put('\u18D7', "CANADIAN SYLLABICS OJIBWAY C");
    map.put('\u18D8', "CANADIAN SYLLABICS OJIBWAY M");
    map.put('\u18D9', "CANADIAN SYLLABICS OJIBWAY N");
    map.put('\u18DA', "CANADIAN SYLLABICS OJIBWAY S");
    map.put('\u18DB', "CANADIAN SYLLABICS OJIBWAY SH");
    map.put('\u18DC', "CANADIAN SYLLABICS EASTERN W");
    map.put('\u18DD', "CANADIAN SYLLABICS WESTERN W");
    map.put('\u18DE', "CANADIAN SYLLABICS FINAL SMALL RING");
    map.put('\u18DF', "CANADIAN SYLLABICS FINAL RAISED DOT");
    map.put('\u18E0', "CANADIAN SYLLABICS R-CREE RWE");
    map.put('\u18E1', "CANADIAN SYLLABICS WEST-CREE LOO");
    map.put('\u18E2', "CANADIAN SYLLABICS WEST-CREE LAA");
    map.put('\u18E3', "CANADIAN SYLLABICS THWE");
    map.put('\u18E4', "CANADIAN SYLLABICS THWA");
    map.put('\u18E5', "CANADIAN SYLLABICS TTHWE");
    map.put('\u18E6', "CANADIAN SYLLABICS TTHOO");
    map.put('\u18E7', "CANADIAN SYLLABICS TTHAA");
    map.put('\u18E8', "CANADIAN SYLLABICS TLHWE");
    map.put('\u18E9', "CANADIAN SYLLABICS TLHOO");
    map.put('\u18EA', "CANADIAN SYLLABICS SAYISI SHWE");
    map.put('\u18EB', "CANADIAN SYLLABICS SAYISI SHOO");
    map.put('\u18EC', "CANADIAN SYLLABICS SAYISI HOO");
    map.put('\u18ED', "CANADIAN SYLLABICS CARRIER GWU");
    map.put('\u18EE', "CANADIAN SYLLABICS CARRIER DENE GEE");
    map.put('\u18EF', "CANADIAN SYLLABICS CARRIER GAA");
    map.put('\u18F0', "CANADIAN SYLLABICS CARRIER GWA");
    map.put('\u18F1', "CANADIAN SYLLABICS SAYISI JUU");
    map.put('\u18F2', "CANADIAN SYLLABICS CARRIER JWA");
    map.put('\u18F3', "CANADIAN SYLLABICS BEAVER DENE L");
    map.put('\u18F4', "CANADIAN SYLLABICS BEAVER DENE R");
    map.put('\u18F5', "CANADIAN SYLLABICS CARRIER DENTAL S");

  }

  public static final void limbu(Map<Character, String> map) {

    map.put('\u1900', "LIMBU VOWEL-CARRIER LETTER");
    map.put('\u1901', "LIMBU LETTER KA");
    map.put('\u1902', "LIMBU LETTER KHA");
    map.put('\u1903', "LIMBU LETTER GA");
    map.put('\u1904', "LIMBU LETTER GHA");
    map.put('\u1905', "LIMBU LETTER NGA");
    map.put('\u1906', "LIMBU LETTER CA");
    map.put('\u1907', "LIMBU LETTER CHA");
    map.put('\u1908', "LIMBU LETTER JA");
    map.put('\u1909', "LIMBU LETTER JHA");
    map.put('\u190A', "LIMBU LETTER YAN");
    map.put('\u190B', "LIMBU LETTER TA");
    map.put('\u190C', "LIMBU LETTER THA");
    map.put('\u190D', "LIMBU LETTER DA");
    map.put('\u190E', "LIMBU LETTER DHA");
    map.put('\u190F', "LIMBU LETTER NA");
    map.put('\u1910', "LIMBU LETTER PA");
    map.put('\u1911', "LIMBU LETTER PHA");
    map.put('\u1912', "LIMBU LETTER BA");
    map.put('\u1913', "LIMBU LETTER BHA");
    map.put('\u1914', "LIMBU LETTER MA");
    map.put('\u1915', "LIMBU LETTER YA");
    map.put('\u1916', "LIMBU LETTER RA");
    map.put('\u1917', "LIMBU LETTER LA");
    map.put('\u1918', "LIMBU LETTER WA");
    map.put('\u1919', "LIMBU LETTER SHA");
    map.put('\u191A', "LIMBU LETTER SSA");
    map.put('\u191B', "LIMBU LETTER SA");
    map.put('\u191C', "LIMBU LETTER HA");
    map.put('\u1920', "LIMBU VOWEL SIGN A");
    map.put('\u1921', "LIMBU VOWEL SIGN I");
    map.put('\u1922', "LIMBU VOWEL SIGN U");
    map.put('\u1923', "LIMBU VOWEL SIGN EE");
    map.put('\u1924', "LIMBU VOWEL SIGN AI");
    map.put('\u1925', "LIMBU VOWEL SIGN OO");
    map.put('\u1926', "LIMBU VOWEL SIGN AU");
    map.put('\u1927', "LIMBU VOWEL SIGN E");
    map.put('\u1928', "LIMBU VOWEL SIGN O");
    map.put('\u1929', "LIMBU SUBJOINED LETTER YA");
    map.put('\u192A', "LIMBU SUBJOINED LETTER RA");
    map.put('\u192B', "LIMBU SUBJOINED LETTER WA");
    map.put('\u1930', "LIMBU SMALL LETTER KA");
    map.put('\u1931', "LIMBU SMALL LETTER NGA");
    map.put('\u1932', "LIMBU SMALL LETTER ANUSVARA");
    map.put('\u1933', "LIMBU SMALL LETTER TA");
    map.put('\u1934', "LIMBU SMALL LETTER NA");
    map.put('\u1935', "LIMBU SMALL LETTER PA");
    map.put('\u1936', "LIMBU SMALL LETTER MA");
    map.put('\u1937', "LIMBU SMALL LETTER RA");
    map.put('\u1938', "LIMBU SMALL LETTER LA");
    map.put('\u1939', "LIMBU SIGN MUKPHRENG");
    map.put('\u193A', "LIMBU SIGN KEMPHRENG");
    map.put('\u193B', "LIMBU SIGN SA-I");
    map.put('\u1940', "LIMBU SIGN LOO");
    map.put('\u1944', "LIMBU EXCLAMATION MARK");
    map.put('\u1945', "LIMBU QUESTION MARK");
    map.put('\u1946', "LIMBU DIGIT ZERO");
    map.put('\u1947', "LIMBU DIGIT ONE");
    map.put('\u1948', "LIMBU DIGIT TWO");
    map.put('\u1949', "LIMBU DIGIT THREE");
    map.put('\u194A', "LIMBU DIGIT FOUR");
    map.put('\u194B', "LIMBU DIGIT FIVE");
    map.put('\u194C', "LIMBU DIGIT SIX");
    map.put('\u194D', "LIMBU DIGIT SEVEN");
    map.put('\u194E', "LIMBU DIGIT EIGHT");
    map.put('\u194F', "LIMBU DIGIT NINE");

  }

  public static final void taiLe(Map<Character, String> map) {

    map.put('\u1950', "TAI LE LETTER KA");
    map.put('\u1951', "TAI LE LETTER XA");
    map.put('\u1952', "TAI LE LETTER NGA");
    map.put('\u1953', "TAI LE LETTER TSA");
    map.put('\u1954', "TAI LE LETTER SA");
    map.put('\u1955', "TAI LE LETTER YA");
    map.put('\u1956', "TAI LE LETTER TA");
    map.put('\u1957', "TAI LE LETTER THA");
    map.put('\u1958', "TAI LE LETTER LA");
    map.put('\u1959', "TAI LE LETTER PA");
    map.put('\u195A', "TAI LE LETTER PHA");
    map.put('\u195B', "TAI LE LETTER MA");
    map.put('\u195C', "TAI LE LETTER FA");
    map.put('\u195D', "TAI LE LETTER VA");
    map.put('\u195E', "TAI LE LETTER HA");
    map.put('\u195F', "TAI LE LETTER QA");
    map.put('\u1960', "TAI LE LETTER KHA");
    map.put('\u1961', "TAI LE LETTER TSHA");
    map.put('\u1962', "TAI LE LETTER NA");
    map.put('\u1963', "TAI LE LETTER A");
    map.put('\u1964', "TAI LE LETTER I");
    map.put('\u1965', "TAI LE LETTER EE");
    map.put('\u1966', "TAI LE LETTER EH");
    map.put('\u1967', "TAI LE LETTER U");
    map.put('\u1968', "TAI LE LETTER OO");
    map.put('\u1969', "TAI LE LETTER O");
    map.put('\u196A', "TAI LE LETTER UE");
    map.put('\u196B', "TAI LE LETTER E");
    map.put('\u196C', "TAI LE LETTER AUE");
    map.put('\u196D', "TAI LE LETTER AI");
    map.put('\u1970', "TAI LE LETTER TONE-2");
    map.put('\u1971', "TAI LE LETTER TONE-3");
    map.put('\u1972', "TAI LE LETTER TONE-4");
    map.put('\u1973', "TAI LE LETTER TONE-5");
    map.put('\u1974', "TAI LE LETTER TONE-6");

  }

  public static final void newTaiLue(Map<Character, String> map) {

    map.put('\u1980', "NEW TAI LUE LETTER HIGH QA");
    map.put('\u1981', "NEW TAI LUE LETTER LOW QA");
    map.put('\u1982', "NEW TAI LUE LETTER HIGH KA");
    map.put('\u1983', "NEW TAI LUE LETTER HIGH XA");
    map.put('\u1984', "NEW TAI LUE LETTER HIGH NGA");
    map.put('\u1985', "NEW TAI LUE LETTER LOW KA");
    map.put('\u1986', "NEW TAI LUE LETTER LOW XA");
    map.put('\u1987', "NEW TAI LUE LETTER LOW NGA");
    map.put('\u1988', "NEW TAI LUE LETTER HIGH TSA");
    map.put('\u1989', "NEW TAI LUE LETTER HIGH SA");
    map.put('\u198A', "NEW TAI LUE LETTER HIGH YA");
    map.put('\u198B', "NEW TAI LUE LETTER LOW TSA");
    map.put('\u198C', "NEW TAI LUE LETTER LOW SA");
    map.put('\u198D', "NEW TAI LUE LETTER LOW YA");
    map.put('\u198E', "NEW TAI LUE LETTER HIGH TA");
    map.put('\u198F', "NEW TAI LUE LETTER HIGH THA");
    map.put('\u1990', "NEW TAI LUE LETTER HIGH NA");
    map.put('\u1991', "NEW TAI LUE LETTER LOW TA");
    map.put('\u1992', "NEW TAI LUE LETTER LOW THA");
    map.put('\u1993', "NEW TAI LUE LETTER LOW NA");
    map.put('\u1994', "NEW TAI LUE LETTER HIGH PA");
    map.put('\u1995', "NEW TAI LUE LETTER HIGH PHA");
    map.put('\u1996', "NEW TAI LUE LETTER HIGH MA");
    map.put('\u1997', "NEW TAI LUE LETTER LOW PA");
    map.put('\u1998', "NEW TAI LUE LETTER LOW PHA");
    map.put('\u1999', "NEW TAI LUE LETTER LOW MA");
    map.put('\u199A', "NEW TAI LUE LETTER HIGH FA");
    map.put('\u199B', "NEW TAI LUE LETTER HIGH VA");
    map.put('\u199C', "NEW TAI LUE LETTER HIGH LA");
    map.put('\u199D', "NEW TAI LUE LETTER LOW FA");
    map.put('\u199E', "NEW TAI LUE LETTER LOW VA");
    map.put('\u199F', "NEW TAI LUE LETTER LOW LA");
    map.put('\u19A0', "NEW TAI LUE LETTER HIGH HA");
    map.put('\u19A1', "NEW TAI LUE LETTER HIGH DA");
    map.put('\u19A2', "NEW TAI LUE LETTER HIGH BA");
    map.put('\u19A3', "NEW TAI LUE LETTER LOW HA");
    map.put('\u19A4', "NEW TAI LUE LETTER LOW DA");
    map.put('\u19A5', "NEW TAI LUE LETTER LOW BA");
    map.put('\u19A6', "NEW TAI LUE LETTER HIGH KVA");
    map.put('\u19A7', "NEW TAI LUE LETTER HIGH XVA");
    map.put('\u19A8', "NEW TAI LUE LETTER LOW KVA");
    map.put('\u19A9', "NEW TAI LUE LETTER LOW XVA");
    map.put('\u19AA', "NEW TAI LUE LETTER HIGH SUA");
    map.put('\u19AB', "NEW TAI LUE LETTER LOW SUA");
    map.put('\u19B0', "NEW TAI LUE VOWEL SIGN VOWEL SHORTENER");
    map.put('\u19B1', "NEW TAI LUE VOWEL SIGN AA");
    map.put('\u19B2', "NEW TAI LUE VOWEL SIGN II");
    map.put('\u19B3', "NEW TAI LUE VOWEL SIGN U");
    map.put('\u19B4', "NEW TAI LUE VOWEL SIGN UU");
    map.put('\u19B5', "NEW TAI LUE VOWEL SIGN E");
    map.put('\u19B6', "NEW TAI LUE VOWEL SIGN AE");
    map.put('\u19B7', "NEW TAI LUE VOWEL SIGN O");
    map.put('\u19B8', "NEW TAI LUE VOWEL SIGN OA");
    map.put('\u19B9', "NEW TAI LUE VOWEL SIGN UE");
    map.put('\u19BA', "NEW TAI LUE VOWEL SIGN AY");
    map.put('\u19BB', "NEW TAI LUE VOWEL SIGN AAY");
    map.put('\u19BC', "NEW TAI LUE VOWEL SIGN UY");
    map.put('\u19BD', "NEW TAI LUE VOWEL SIGN OY");
    map.put('\u19BE', "NEW TAI LUE VOWEL SIGN OAY");
    map.put('\u19BF', "NEW TAI LUE VOWEL SIGN UEY");
    map.put('\u19C0', "NEW TAI LUE VOWEL SIGN IY");
    map.put('\u19C1', "NEW TAI LUE LETTER FINAL V");
    map.put('\u19C2', "NEW TAI LUE LETTER FINAL NG");
    map.put('\u19C3', "NEW TAI LUE LETTER FINAL N");
    map.put('\u19C4', "NEW TAI LUE LETTER FINAL M");
    map.put('\u19C5', "NEW TAI LUE LETTER FINAL K");
    map.put('\u19C6', "NEW TAI LUE LETTER FINAL D");
    map.put('\u19C7', "NEW TAI LUE LETTER FINAL B");
    map.put('\u19C8', "NEW TAI LUE TONE MARK-1");
    map.put('\u19C9', "NEW TAI LUE TONE MARK-2");
    map.put('\u19D0', "NEW TAI LUE DIGIT ZERO");
    map.put('\u19D1', "NEW TAI LUE DIGIT ONE");
    map.put('\u19D2', "NEW TAI LUE DIGIT TWO");
    map.put('\u19D3', "NEW TAI LUE DIGIT THREE");
    map.put('\u19D4', "NEW TAI LUE DIGIT FOUR");
    map.put('\u19D5', "NEW TAI LUE DIGIT FIVE");
    map.put('\u19D6', "NEW TAI LUE DIGIT SIX");
    map.put('\u19D7', "NEW TAI LUE DIGIT SEVEN");
    map.put('\u19D8', "NEW TAI LUE DIGIT EIGHT");
    map.put('\u19D9', "NEW TAI LUE DIGIT NINE");
    map.put('\u19DA', "NEW TAI LUE THAM DIGIT ONE");
    map.put('\u19DE', "NEW TAI LUE SIGN LAE");
    map.put('\u19DF', "NEW TAI LUE SIGN LAEV");

  }

  public static final void khmerSymbols(Map<Character, String> map) {

    map.put('\u19E0', "KHMER SYMBOL PATHAMASAT");
    map.put('\u19E1', "KHMER SYMBOL MUOY KOET");
    map.put('\u19E2', "KHMER SYMBOL PII KOET");
    map.put('\u19E3', "KHMER SYMBOL BEI KOET");
    map.put('\u19E4', "KHMER SYMBOL BUON KOET");
    map.put('\u19E5', "KHMER SYMBOL PRAM KOET");
    map.put('\u19E6', "KHMER SYMBOL PRAM-MUOY KOET");
    map.put('\u19E7', "KHMER SYMBOL PRAM-PII KOET");
    map.put('\u19E8', "KHMER SYMBOL PRAM-BEI KOET");
    map.put('\u19E9', "KHMER SYMBOL PRAM-BUON KOET");
    map.put('\u19EA', "KHMER SYMBOL DAP KOET");
    map.put('\u19EB', "KHMER SYMBOL DAP-MUOY KOET");
    map.put('\u19EC', "KHMER SYMBOL DAP-PII KOET");
    map.put('\u19ED', "KHMER SYMBOL DAP-BEI KOET");
    map.put('\u19EE', "KHMER SYMBOL DAP-BUON KOET");
    map.put('\u19EF', "KHMER SYMBOL DAP-PRAM KOET");
    map.put('\u19F0', "KHMER SYMBOL TUTEYASAT");
    map.put('\u19F1', "KHMER SYMBOL MUOY ROC");
    map.put('\u19F2', "KHMER SYMBOL PII ROC");
    map.put('\u19F3', "KHMER SYMBOL BEI ROC");
    map.put('\u19F4', "KHMER SYMBOL BUON ROC");
    map.put('\u19F5', "KHMER SYMBOL PRAM ROC");
    map.put('\u19F6', "KHMER SYMBOL PRAM-MUOY ROC");
    map.put('\u19F7', "KHMER SYMBOL PRAM-PII ROC");
    map.put('\u19F8', "KHMER SYMBOL PRAM-BEI ROC");
    map.put('\u19F9', "KHMER SYMBOL PRAM-BUON ROC");
    map.put('\u19FA', "KHMER SYMBOL DAP ROC");
    map.put('\u19FB', "KHMER SYMBOL DAP-MUOY ROC");
    map.put('\u19FC', "KHMER SYMBOL DAP-PII ROC");
    map.put('\u19FD', "KHMER SYMBOL DAP-BEI ROC");
    map.put('\u19FE', "KHMER SYMBOL DAP-BUON ROC");
    map.put('\u19FF', "KHMER SYMBOL DAP-PRAM ROC");

  }

  public static final void buginese(Map<Character, String> map) {

    map.put('\u1A00', "BUGINESE LETTER KA");
    map.put('\u1A01', "BUGINESE LETTER GA");
    map.put('\u1A02', "BUGINESE LETTER NGA");
    map.put('\u1A03', "BUGINESE LETTER NGKA");
    map.put('\u1A04', "BUGINESE LETTER PA");
    map.put('\u1A05', "BUGINESE LETTER BA");
    map.put('\u1A06', "BUGINESE LETTER MA");
    map.put('\u1A07', "BUGINESE LETTER MPA");
    map.put('\u1A08', "BUGINESE LETTER TA");
    map.put('\u1A09', "BUGINESE LETTER DA");
    map.put('\u1A0A', "BUGINESE LETTER NA");
    map.put('\u1A0B', "BUGINESE LETTER NRA");
    map.put('\u1A0C', "BUGINESE LETTER CA");
    map.put('\u1A0D', "BUGINESE LETTER JA");
    map.put('\u1A0E', "BUGINESE LETTER NYA");
    map.put('\u1A0F', "BUGINESE LETTER NYCA");
    map.put('\u1A10', "BUGINESE LETTER YA");
    map.put('\u1A11', "BUGINESE LETTER RA");
    map.put('\u1A12', "BUGINESE LETTER LA");
    map.put('\u1A13', "BUGINESE LETTER VA");
    map.put('\u1A14', "BUGINESE LETTER SA");
    map.put('\u1A15', "BUGINESE LETTER A");
    map.put('\u1A16', "BUGINESE LETTER HA");
    map.put('\u1A17', "BUGINESE VOWEL SIGN I");
    map.put('\u1A18', "BUGINESE VOWEL SIGN U");
    map.put('\u1A19', "BUGINESE VOWEL SIGN E");
    map.put('\u1A1A', "BUGINESE VOWEL SIGN O");
    map.put('\u1A1B', "BUGINESE VOWEL SIGN AE");
    map.put('\u1A1E', "BUGINESE PALLAWA");
    map.put('\u1A1F', "BUGINESE END OF SECTION");
    map.put('\u1A20', "TAI THAM LETTER HIGH KA");
    map.put('\u1A21', "TAI THAM LETTER HIGH KHA");
    map.put('\u1A22', "TAI THAM LETTER HIGH KXA");
    map.put('\u1A23', "TAI THAM LETTER LOW KA");
    map.put('\u1A24', "TAI THAM LETTER LOW KXA");
    map.put('\u1A25', "TAI THAM LETTER LOW KHA");
    map.put('\u1A26', "TAI THAM LETTER NGA");
    map.put('\u1A27', "TAI THAM LETTER HIGH CA");
    map.put('\u1A28', "TAI THAM LETTER HIGH CHA");
    map.put('\u1A29', "TAI THAM LETTER LOW CA");
    map.put('\u1A2A', "TAI THAM LETTER LOW SA");
    map.put('\u1A2B', "TAI THAM LETTER LOW CHA");
    map.put('\u1A2C', "TAI THAM LETTER NYA");
    map.put('\u1A2D', "TAI THAM LETTER RATA");
    map.put('\u1A2E', "TAI THAM LETTER HIGH RATHA");
    map.put('\u1A2F', "TAI THAM LETTER DA");
    map.put('\u1A30', "TAI THAM LETTER LOW RATHA");
    map.put('\u1A31', "TAI THAM LETTER RANA");
    map.put('\u1A32', "TAI THAM LETTER HIGH TA");
    map.put('\u1A33', "TAI THAM LETTER HIGH THA");
    map.put('\u1A34', "TAI THAM LETTER LOW TA");
    map.put('\u1A35', "TAI THAM LETTER LOW THA");
    map.put('\u1A36', "TAI THAM LETTER NA");
    map.put('\u1A37', "TAI THAM LETTER BA");
    map.put('\u1A38', "TAI THAM LETTER HIGH PA");
    map.put('\u1A39', "TAI THAM LETTER HIGH PHA");
    map.put('\u1A3A', "TAI THAM LETTER HIGH FA");
    map.put('\u1A3B', "TAI THAM LETTER LOW PA");
    map.put('\u1A3C', "TAI THAM LETTER LOW FA");
    map.put('\u1A3D', "TAI THAM LETTER LOW PHA");
    map.put('\u1A3E', "TAI THAM LETTER MA");
    map.put('\u1A3F', "TAI THAM LETTER LOW YA");
    map.put('\u1A40', "TAI THAM LETTER HIGH YA");
    map.put('\u1A41', "TAI THAM LETTER RA");
    map.put('\u1A42', "TAI THAM LETTER RUE");
    map.put('\u1A43', "TAI THAM LETTER LA");
    map.put('\u1A44', "TAI THAM LETTER LUE");
    map.put('\u1A45', "TAI THAM LETTER WA");
    map.put('\u1A46', "TAI THAM LETTER HIGH SHA");
    map.put('\u1A47', "TAI THAM LETTER HIGH SSA");
    map.put('\u1A48', "TAI THAM LETTER HIGH SA");
    map.put('\u1A49', "TAI THAM LETTER HIGH HA");
    map.put('\u1A4A', "TAI THAM LETTER LLA");
    map.put('\u1A4B', "TAI THAM LETTER A");
    map.put('\u1A4C', "TAI THAM LETTER LOW HA");
    map.put('\u1A4D', "TAI THAM LETTER I");
    map.put('\u1A4E', "TAI THAM LETTER II");
    map.put('\u1A4F', "TAI THAM LETTER U");
    map.put('\u1A50', "TAI THAM LETTER UU");
    map.put('\u1A51', "TAI THAM LETTER EE");
    map.put('\u1A52', "TAI THAM LETTER OO");
    map.put('\u1A53', "TAI THAM LETTER LAE");
    map.put('\u1A54', "TAI THAM LETTER GREAT SA");
    map.put('\u1A55', "TAI THAM CONSONANT SIGN MEDIAL RA");
    map.put('\u1A56', "TAI THAM CONSONANT SIGN MEDIAL LA");
    map.put('\u1A57', "TAI THAM CONSONANT SIGN LA TANG LAI");
    map.put('\u1A58', "TAI THAM SIGN MAI KANG LAI");
    map.put('\u1A59', "TAI THAM CONSONANT SIGN FINAL NGA");
    map.put('\u1A5A', "TAI THAM CONSONANT SIGN LOW PA");
    map.put('\u1A5B', "TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA");
    map.put('\u1A5C', "TAI THAM CONSONANT SIGN MA");
    map.put('\u1A5D', "TAI THAM CONSONANT SIGN BA");
    map.put('\u1A5E', "TAI THAM CONSONANT SIGN SA");
    map.put('\u1A60', "TAI THAM SIGN SAKOT");
    map.put('\u1A61', "TAI THAM VOWEL SIGN A");
    map.put('\u1A62', "TAI THAM VOWEL SIGN MAI SAT");
    map.put('\u1A63', "TAI THAM VOWEL SIGN AA");
    map.put('\u1A64', "TAI THAM VOWEL SIGN TALL AA");
    map.put('\u1A65', "TAI THAM VOWEL SIGN I");
    map.put('\u1A66', "TAI THAM VOWEL SIGN II");
    map.put('\u1A67', "TAI THAM VOWEL SIGN UE");
    map.put('\u1A68', "TAI THAM VOWEL SIGN UUE");
    map.put('\u1A69', "TAI THAM VOWEL SIGN U");
    map.put('\u1A6A', "TAI THAM VOWEL SIGN UU");
    map.put('\u1A6B', "TAI THAM VOWEL SIGN O");
    map.put('\u1A6C', "TAI THAM VOWEL SIGN OA BELOW");
    map.put('\u1A6D', "TAI THAM VOWEL SIGN OY");
    map.put('\u1A6E', "TAI THAM VOWEL SIGN E");
    map.put('\u1A6F', "TAI THAM VOWEL SIGN AE");
    map.put('\u1A70', "TAI THAM VOWEL SIGN OO");
    map.put('\u1A71', "TAI THAM VOWEL SIGN AI");
    map.put('\u1A72', "TAI THAM VOWEL SIGN THAM AI");
    map.put('\u1A73', "TAI THAM VOWEL SIGN OA ABOVE");
    map.put('\u1A74', "TAI THAM SIGN MAI KANG");
    map.put('\u1A75', "TAI THAM SIGN TONE-1");
    map.put('\u1A76', "TAI THAM SIGN TONE-2");
    map.put('\u1A77', "TAI THAM SIGN KHUEN TONE-3");
    map.put('\u1A78', "TAI THAM SIGN KHUEN TONE-4");
    map.put('\u1A79', "TAI THAM SIGN KHUEN TONE-5");
    map.put('\u1A7A', "TAI THAM SIGN RA HAAM");
    map.put('\u1A7B', "TAI THAM SIGN MAI SAM");
    map.put('\u1A7C', "TAI THAM SIGN KHUEN-LUE KARAN");
    map.put('\u1A7F', "TAI THAM COMBINING CRYPTOGRAMMIC DOT");
    map.put('\u1A80', "TAI THAM HORA DIGIT ZERO");
    map.put('\u1A81', "TAI THAM HORA DIGIT ONE");
    map.put('\u1A82', "TAI THAM HORA DIGIT TWO");
    map.put('\u1A83', "TAI THAM HORA DIGIT THREE");
    map.put('\u1A84', "TAI THAM HORA DIGIT FOUR");
    map.put('\u1A85', "TAI THAM HORA DIGIT FIVE");
    map.put('\u1A86', "TAI THAM HORA DIGIT SIX");
    map.put('\u1A87', "TAI THAM HORA DIGIT SEVEN");
    map.put('\u1A88', "TAI THAM HORA DIGIT EIGHT");
    map.put('\u1A89', "TAI THAM HORA DIGIT NINE");
    map.put('\u1A90', "TAI THAM THAM DIGIT ZERO");
    map.put('\u1A91', "TAI THAM THAM DIGIT ONE");
    map.put('\u1A92', "TAI THAM THAM DIGIT TWO");
    map.put('\u1A93', "TAI THAM THAM DIGIT THREE");
    map.put('\u1A94', "TAI THAM THAM DIGIT FOUR");
    map.put('\u1A95', "TAI THAM THAM DIGIT FIVE");
    map.put('\u1A96', "TAI THAM THAM DIGIT SIX");
    map.put('\u1A97', "TAI THAM THAM DIGIT SEVEN");
    map.put('\u1A98', "TAI THAM THAM DIGIT EIGHT");
    map.put('\u1A99', "TAI THAM THAM DIGIT NINE");
    map.put('\u1AA0', "TAI THAM SIGN WIANG");
    map.put('\u1AA1', "TAI THAM SIGN WIANGWAAK");
    map.put('\u1AA2', "TAI THAM SIGN SAWAN");
    map.put('\u1AA3', "TAI THAM SIGN KEOW");
    map.put('\u1AA4', "TAI THAM SIGN HOY");
    map.put('\u1AA5', "TAI THAM SIGN DOKMAI");
    map.put('\u1AA6', "TAI THAM SIGN REVERSED ROTATED RANA");
    map.put('\u1AA7', "TAI THAM SIGN MAI YAMOK");
    map.put('\u1AA8', "TAI THAM SIGN KAAN");
    map.put('\u1AA9', "TAI THAM SIGN KAANKUU");
    map.put('\u1AAA', "TAI THAM SIGN SATKAAN");
    map.put('\u1AAB', "TAI THAM SIGN SATKAANKUU");
    map.put('\u1AAC', "TAI THAM SIGN HANG");
    map.put('\u1AAD', "TAI THAM SIGN CAANG");

  }

  public static final void balinese(Map<Character, String> map) {

    map.put('\u1B00', "BALINESE SIGN ULU RICEM");
    map.put('\u1B01', "BALINESE SIGN ULU CANDRA");
    map.put('\u1B02', "BALINESE SIGN CECEK");
    map.put('\u1B03', "BALINESE SIGN SURANG");
    map.put('\u1B04', "BALINESE SIGN BISAH");
    map.put('\u1B05', "BALINESE LETTER AKARA");
    map.put('\u1B06', "BALINESE LETTER AKARA TEDUNG");
    map.put('\u1B07', "BALINESE LETTER IKARA");
    map.put('\u1B08', "BALINESE LETTER IKARA TEDUNG");
    map.put('\u1B09', "BALINESE LETTER UKARA");
    map.put('\u1B0A', "BALINESE LETTER UKARA TEDUNG");
    map.put('\u1B0B', "BALINESE LETTER RA REPA");
    map.put('\u1B0C', "BALINESE LETTER RA REPA TEDUNG");
    map.put('\u1B0D', "BALINESE LETTER LA LENGA");
    map.put('\u1B0E', "BALINESE LETTER LA LENGA TEDUNG");
    map.put('\u1B0F', "BALINESE LETTER EKARA");
    map.put('\u1B10', "BALINESE LETTER AIKARA");
    map.put('\u1B11', "BALINESE LETTER OKARA");
    map.put('\u1B12', "BALINESE LETTER OKARA TEDUNG");
    map.put('\u1B13', "BALINESE LETTER KA");
    map.put('\u1B14', "BALINESE LETTER KA MAHAPRANA");
    map.put('\u1B15', "BALINESE LETTER GA");
    map.put('\u1B16', "BALINESE LETTER GA GORA");
    map.put('\u1B17', "BALINESE LETTER NGA");
    map.put('\u1B18', "BALINESE LETTER CA");
    map.put('\u1B19', "BALINESE LETTER CA LACA");
    map.put('\u1B1A', "BALINESE LETTER JA");
    map.put('\u1B1B', "BALINESE LETTER JA JERA");
    map.put('\u1B1C', "BALINESE LETTER NYA");
    map.put('\u1B1D', "BALINESE LETTER TA LATIK");
    map.put('\u1B1E', "BALINESE LETTER TA MURDA MAHAPRANA");
    map.put('\u1B1F', "BALINESE LETTER DA MURDA ALPAPRANA");
    map.put('\u1B20', "BALINESE LETTER DA MURDA MAHAPRANA");
    map.put('\u1B21', "BALINESE LETTER NA RAMBAT");
    map.put('\u1B22', "BALINESE LETTER TA");
    map.put('\u1B23', "BALINESE LETTER TA TAWA");
    map.put('\u1B24', "BALINESE LETTER DA");
    map.put('\u1B25', "BALINESE LETTER DA MADU");
    map.put('\u1B26', "BALINESE LETTER NA");
    map.put('\u1B27', "BALINESE LETTER PA");
    map.put('\u1B28', "BALINESE LETTER PA KAPAL");
    map.put('\u1B29', "BALINESE LETTER BA");
    map.put('\u1B2A', "BALINESE LETTER BA KEMBANG");
    map.put('\u1B2B', "BALINESE LETTER MA");
    map.put('\u1B2C', "BALINESE LETTER YA");
    map.put('\u1B2D', "BALINESE LETTER RA");
    map.put('\u1B2E', "BALINESE LETTER LA");
    map.put('\u1B2F', "BALINESE LETTER WA");
    map.put('\u1B30', "BALINESE LETTER SA SAGA");
    map.put('\u1B31', "BALINESE LETTER SA SAPA");
    map.put('\u1B32', "BALINESE LETTER SA");
    map.put('\u1B33', "BALINESE LETTER HA");
    map.put('\u1B34', "BALINESE SIGN REREKAN");
    map.put('\u1B35', "BALINESE VOWEL SIGN TEDUNG");
    map.put('\u1B36', "BALINESE VOWEL SIGN ULU");
    map.put('\u1B37', "BALINESE VOWEL SIGN ULU SARI");
    map.put('\u1B38', "BALINESE VOWEL SIGN SUKU");
    map.put('\u1B39', "BALINESE VOWEL SIGN SUKU ILUT");
    map.put('\u1B3A', "BALINESE VOWEL SIGN RA REPA");
    map.put('\u1B3B', "BALINESE VOWEL SIGN RA REPA TEDUNG");
    map.put('\u1B3C', "BALINESE VOWEL SIGN LA LENGA");
    map.put('\u1B3D', "BALINESE VOWEL SIGN LA LENGA TEDUNG");
    map.put('\u1B3E', "BALINESE VOWEL SIGN TALING");
    map.put('\u1B3F', "BALINESE VOWEL SIGN TALING REPA");
    map.put('\u1B40', "BALINESE VOWEL SIGN TALING TEDUNG");
    map.put('\u1B41', "BALINESE VOWEL SIGN TALING REPA TEDUNG");
    map.put('\u1B42', "BALINESE VOWEL SIGN PEPET");
    map.put('\u1B43', "BALINESE VOWEL SIGN PEPET TEDUNG");
    map.put('\u1B44', "BALINESE ADEG ADEG");
    map.put('\u1B45', "BALINESE LETTER KAF SASAK");
    map.put('\u1B46', "BALINESE LETTER KHOT SASAK");
    map.put('\u1B47', "BALINESE LETTER TZIR SASAK");
    map.put('\u1B48', "BALINESE LETTER EF SASAK");
    map.put('\u1B49', "BALINESE LETTER VE SASAK");
    map.put('\u1B4A', "BALINESE LETTER ZAL SASAK");
    map.put('\u1B4B', "BALINESE LETTER ASYURA SASAK");
    map.put('\u1B50', "BALINESE DIGIT ZERO");
    map.put('\u1B51', "BALINESE DIGIT ONE");
    map.put('\u1B52', "BALINESE DIGIT TWO");
    map.put('\u1B53', "BALINESE DIGIT THREE");
    map.put('\u1B54', "BALINESE DIGIT FOUR");
    map.put('\u1B55', "BALINESE DIGIT FIVE");
    map.put('\u1B56', "BALINESE DIGIT SIX");
    map.put('\u1B57', "BALINESE DIGIT SEVEN");
    map.put('\u1B58', "BALINESE DIGIT EIGHT");
    map.put('\u1B59', "BALINESE DIGIT NINE");
    map.put('\u1B5A', "BALINESE PANTI");
    map.put('\u1B5B', "BALINESE PAMADA");
    map.put('\u1B5C', "BALINESE WINDU");
    map.put('\u1B5D', "BALINESE CARIK PAMUNGKAH");
    map.put('\u1B5E', "BALINESE CARIK SIKI");
    map.put('\u1B5F', "BALINESE CARIK PAREREN");
    map.put('\u1B60', "BALINESE PAMENENG");
    map.put('\u1B61', "BALINESE MUSICAL SYMBOL DONG");
    map.put('\u1B62', "BALINESE MUSICAL SYMBOL DENG");
    map.put('\u1B63', "BALINESE MUSICAL SYMBOL DUNG");
    map.put('\u1B64', "BALINESE MUSICAL SYMBOL DANG");
    map.put('\u1B65', "BALINESE MUSICAL SYMBOL DANG SURANG");
    map.put('\u1B66', "BALINESE MUSICAL SYMBOL DING");
    map.put('\u1B67', "BALINESE MUSICAL SYMBOL DAENG");
    map.put('\u1B68', "BALINESE MUSICAL SYMBOL DEUNG");
    map.put('\u1B69', "BALINESE MUSICAL SYMBOL DAING");
    map.put('\u1B6A', "BALINESE MUSICAL SYMBOL DANG GEDE");
    map.put('\u1B6B', "BALINESE MUSICAL SYMBOL COMBINING TEGEH");
    map.put('\u1B6C', "BALINESE MUSICAL SYMBOL COMBINING ENDEP");
    map.put('\u1B6D', "BALINESE MUSICAL SYMBOL COMBINING KEMPUL");
    map.put('\u1B6E', "BALINESE MUSICAL SYMBOL COMBINING KEMPLI");
    map.put('\u1B6F', "BALINESE MUSICAL SYMBOL COMBINING JEGOGAN");
    map.put('\u1B70', "BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN");
    map.put('\u1B71', "BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN");
    map.put('\u1B72', "BALINESE MUSICAL SYMBOL COMBINING BENDE");
    map.put('\u1B73', "BALINESE MUSICAL SYMBOL COMBINING GONG");
    map.put('\u1B74', "BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG");
    map.put('\u1B75', "BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG");
    map.put('\u1B76', "BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK");
    map.put('\u1B77', "BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK");
    map.put('\u1B78', "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG");
    map.put('\u1B79', "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG");
    map.put('\u1B7A', "BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK");
    map.put('\u1B7B', "BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK");
    map.put('\u1B7C', "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING");

  }

  public static final void sudanese(Map<Character, String> map) {

    map.put('\u1B80', "SUNDANESE SIGN PANYECEK");
    map.put('\u1B81', "SUNDANESE SIGN PANGLAYAR");
    map.put('\u1B82', "SUNDANESE SIGN PANGWISAD");
    map.put('\u1B83', "SUNDANESE LETTER A");
    map.put('\u1B84', "SUNDANESE LETTER I");
    map.put('\u1B85', "SUNDANESE LETTER U");
    map.put('\u1B86', "SUNDANESE LETTER AE");
    map.put('\u1B87', "SUNDANESE LETTER O");
    map.put('\u1B88', "SUNDANESE LETTER E");
    map.put('\u1B89', "SUNDANESE LETTER EU");
    map.put('\u1B8A', "SUNDANESE LETTER KA");
    map.put('\u1B8B', "SUNDANESE LETTER QA");
    map.put('\u1B8C', "SUNDANESE LETTER GA");
    map.put('\u1B8D', "SUNDANESE LETTER NGA");
    map.put('\u1B8E', "SUNDANESE LETTER CA");
    map.put('\u1B8F', "SUNDANESE LETTER JA");
    map.put('\u1B90', "SUNDANESE LETTER ZA");
    map.put('\u1B91', "SUNDANESE LETTER NYA");
    map.put('\u1B92', "SUNDANESE LETTER TA");
    map.put('\u1B93', "SUNDANESE LETTER DA");
    map.put('\u1B94', "SUNDANESE LETTER NA");
    map.put('\u1B95', "SUNDANESE LETTER PA");
    map.put('\u1B96', "SUNDANESE LETTER FA");
    map.put('\u1B97', "SUNDANESE LETTER VA");
    map.put('\u1B98', "SUNDANESE LETTER BA");
    map.put('\u1B99', "SUNDANESE LETTER MA");
    map.put('\u1B9A', "SUNDANESE LETTER YA");
    map.put('\u1B9B', "SUNDANESE LETTER RA");
    map.put('\u1B9C', "SUNDANESE LETTER LA");
    map.put('\u1B9D', "SUNDANESE LETTER WA");
    map.put('\u1B9E', "SUNDANESE LETTER SA");
    map.put('\u1B9F', "SUNDANESE LETTER XA");
    map.put('\u1BA0', "SUNDANESE LETTER HA");
    map.put('\u1BA1', "SUNDANESE CONSONANT SIGN PAMINGKAL");
    map.put('\u1BA2', "SUNDANESE CONSONANT SIGN PANYAKRA");
    map.put('\u1BA3', "SUNDANESE CONSONANT SIGN PANYIKU");
    map.put('\u1BA4', "SUNDANESE VOWEL SIGN PANGHULU");
    map.put('\u1BA5', "SUNDANESE VOWEL SIGN PANYUKU");
    map.put('\u1BA6', "SUNDANESE VOWEL SIGN PANAELAENG");
    map.put('\u1BA7', "SUNDANESE VOWEL SIGN PANOLONG");
    map.put('\u1BA8', "SUNDANESE VOWEL SIGN PAMEPET");
    map.put('\u1BA9', "SUNDANESE VOWEL SIGN PANEULEUNG");
    map.put('\u1BAA', "SUNDANESE SIGN PAMAAEH");
    map.put('\u1BAE', "SUNDANESE LETTER KHA");
    map.put('\u1BAF', "SUNDANESE LETTER SYA");
    map.put('\u1BB0', "SUNDANESE DIGIT ZERO");
    map.put('\u1BB1', "SUNDANESE DIGIT ONE");
    map.put('\u1BB2', "SUNDANESE DIGIT TWO");
    map.put('\u1BB3', "SUNDANESE DIGIT THREE");
    map.put('\u1BB4', "SUNDANESE DIGIT FOUR");
    map.put('\u1BB5', "SUNDANESE DIGIT FIVE");
    map.put('\u1BB6', "SUNDANESE DIGIT SIX");
    map.put('\u1BB7', "SUNDANESE DIGIT SEVEN");
    map.put('\u1BB8', "SUNDANESE DIGIT EIGHT");
    map.put('\u1BB9', "SUNDANESE DIGIT NINE");

  }

  public static final void lepcha(Map<Character, String> map) {

    map.put('\u1C00', "LEPCHA LETTER KA");
    map.put('\u1C01', "LEPCHA LETTER KLA");
    map.put('\u1C02', "LEPCHA LETTER KHA");
    map.put('\u1C03', "LEPCHA LETTER GA");
    map.put('\u1C04', "LEPCHA LETTER GLA");
    map.put('\u1C05', "LEPCHA LETTER NGA");
    map.put('\u1C06', "LEPCHA LETTER CA");
    map.put('\u1C07', "LEPCHA LETTER CHA");
    map.put('\u1C08', "LEPCHA LETTER JA");
    map.put('\u1C09', "LEPCHA LETTER NYA");
    map.put('\u1C0A', "LEPCHA LETTER TA");
    map.put('\u1C0B', "LEPCHA LETTER THA");
    map.put('\u1C0C', "LEPCHA LETTER DA");
    map.put('\u1C0D', "LEPCHA LETTER NA");
    map.put('\u1C0E', "LEPCHA LETTER PA");
    map.put('\u1C0F', "LEPCHA LETTER PLA");
    map.put('\u1C10', "LEPCHA LETTER PHA");
    map.put('\u1C11', "LEPCHA LETTER FA");
    map.put('\u1C12', "LEPCHA LETTER FLA");
    map.put('\u1C13', "LEPCHA LETTER BA");
    map.put('\u1C14', "LEPCHA LETTER BLA");
    map.put('\u1C15', "LEPCHA LETTER MA");
    map.put('\u1C16', "LEPCHA LETTER MLA");
    map.put('\u1C17', "LEPCHA LETTER TSA");
    map.put('\u1C18', "LEPCHA LETTER TSHA");
    map.put('\u1C19', "LEPCHA LETTER DZA");
    map.put('\u1C1A', "LEPCHA LETTER YA");
    map.put('\u1C1B', "LEPCHA LETTER RA");
    map.put('\u1C1C', "LEPCHA LETTER LA");
    map.put('\u1C1D', "LEPCHA LETTER HA");
    map.put('\u1C1E', "LEPCHA LETTER HLA");
    map.put('\u1C1F', "LEPCHA LETTER VA");
    map.put('\u1C20', "LEPCHA LETTER SA");
    map.put('\u1C21', "LEPCHA LETTER SHA");
    map.put('\u1C22', "LEPCHA LETTER WA");
    map.put('\u1C23', "LEPCHA LETTER A");
    map.put('\u1C24', "LEPCHA SUBJOINED LETTER YA");
    map.put('\u1C25', "LEPCHA SUBJOINED LETTER RA");
    map.put('\u1C26', "LEPCHA VOWEL SIGN AA");
    map.put('\u1C27', "LEPCHA VOWEL SIGN I");
    map.put('\u1C28', "LEPCHA VOWEL SIGN O");
    map.put('\u1C29', "LEPCHA VOWEL SIGN OO");
    map.put('\u1C2A', "LEPCHA VOWEL SIGN U");
    map.put('\u1C2B', "LEPCHA VOWEL SIGN UU");
    map.put('\u1C2C', "LEPCHA VOWEL SIGN E");
    map.put('\u1C2D', "LEPCHA CONSONANT SIGN K");
    map.put('\u1C2E', "LEPCHA CONSONANT SIGN M");
    map.put('\u1C2F', "LEPCHA CONSONANT SIGN L");
    map.put('\u1C30', "LEPCHA CONSONANT SIGN N");
    map.put('\u1C31', "LEPCHA CONSONANT SIGN P");
    map.put('\u1C32', "LEPCHA CONSONANT SIGN R");
    map.put('\u1C33', "LEPCHA CONSONANT SIGN T");
    map.put('\u1C34', "LEPCHA CONSONANT SIGN NYIN-DO");
    map.put('\u1C35', "LEPCHA CONSONANT SIGN KANG");
    map.put('\u1C36', "LEPCHA SIGN RAN");
    map.put('\u1C37', "LEPCHA SIGN NUKTA");
    map.put('\u1C3B', "LEPCHA PUNCTUATION TA-ROL");
    map.put('\u1C3C', "LEPCHA PUNCTUATION NYET THYOOM TA-ROL");
    map.put('\u1C3D', "LEPCHA PUNCTUATION CER-WA");
    map.put('\u1C3E', "LEPCHA PUNCTUATION TSHOOK CER-WA");
    map.put('\u1C3F', "LEPCHA PUNCTUATION TSHOOK");
    map.put('\u1C40', "LEPCHA DIGIT ZERO");
    map.put('\u1C41', "LEPCHA DIGIT ONE");
    map.put('\u1C42', "LEPCHA DIGIT TWO");
    map.put('\u1C43', "LEPCHA DIGIT THREE");
    map.put('\u1C44', "LEPCHA DIGIT FOUR");
    map.put('\u1C45', "LEPCHA DIGIT FIVE");
    map.put('\u1C46', "LEPCHA DIGIT SIX");
    map.put('\u1C47', "LEPCHA DIGIT SEVEN");
    map.put('\u1C48', "LEPCHA DIGIT EIGHT");
    map.put('\u1C49', "LEPCHA DIGIT NINE");
    map.put('\u1C4D', "LEPCHA LETTER TTA");
    map.put('\u1C4E', "LEPCHA LETTER TTHA");
    map.put('\u1C4F', "LEPCHA LETTER DDA");

  }

  public static final void olChiki(Map<Character, String> map) {

    map.put('\u1C50', "OL CHIKI DIGIT ZERO");
    map.put('\u1C51', "OL CHIKI DIGIT ONE");
    map.put('\u1C52', "OL CHIKI DIGIT TWO");
    map.put('\u1C53', "OL CHIKI DIGIT THREE");
    map.put('\u1C54', "OL CHIKI DIGIT FOUR");
    map.put('\u1C55', "OL CHIKI DIGIT FIVE");
    map.put('\u1C56', "OL CHIKI DIGIT SIX");
    map.put('\u1C57', "OL CHIKI DIGIT SEVEN");
    map.put('\u1C58', "OL CHIKI DIGIT EIGHT");
    map.put('\u1C59', "OL CHIKI DIGIT NINE");
    map.put('\u1C5A', "OL CHIKI LETTER LA");
    map.put('\u1C5B', "OL CHIKI LETTER AT");
    map.put('\u1C5C', "OL CHIKI LETTER AG");
    map.put('\u1C5D', "OL CHIKI LETTER ANG");
    map.put('\u1C5E', "OL CHIKI LETTER AL");
    map.put('\u1C5F', "OL CHIKI LETTER LAA");
    map.put('\u1C60', "OL CHIKI LETTER AAK");
    map.put('\u1C61', "OL CHIKI LETTER AAJ");
    map.put('\u1C62', "OL CHIKI LETTER AAM");
    map.put('\u1C63', "OL CHIKI LETTER AAW");
    map.put('\u1C64', "OL CHIKI LETTER LI");
    map.put('\u1C65', "OL CHIKI LETTER IS");
    map.put('\u1C66', "OL CHIKI LETTER IH");
    map.put('\u1C67', "OL CHIKI LETTER INY");
    map.put('\u1C68', "OL CHIKI LETTER IR");
    map.put('\u1C69', "OL CHIKI LETTER LU");
    map.put('\u1C6A', "OL CHIKI LETTER UC");
    map.put('\u1C6B', "OL CHIKI LETTER UD");
    map.put('\u1C6C', "OL CHIKI LETTER UNN");
    map.put('\u1C6D', "OL CHIKI LETTER UY");
    map.put('\u1C6E', "OL CHIKI LETTER LE");
    map.put('\u1C6F', "OL CHIKI LETTER EP");
    map.put('\u1C70', "OL CHIKI LETTER EDD");
    map.put('\u1C71', "OL CHIKI LETTER EN");
    map.put('\u1C72', "OL CHIKI LETTER ERR");
    map.put('\u1C73', "OL CHIKI LETTER LO");
    map.put('\u1C74', "OL CHIKI LETTER OTT");
    map.put('\u1C75', "OL CHIKI LETTER OB");
    map.put('\u1C76', "OL CHIKI LETTER OV");
    map.put('\u1C77', "OL CHIKI LETTER OH");
    map.put('\u1C78', "OL CHIKI MU TTUDDAG");
    map.put('\u1C79', "OL CHIKI GAAHLAA TTUDDAAG");
    map.put('\u1C7A', "OL CHIKI MU-GAAHLAA TTUDDAAG");
    map.put('\u1C7B', "OL CHIKI RELAA");
    map.put('\u1C7C', "OL CHIKI PHAARKAA");
    map.put('\u1C7D', "OL CHIKI AHAD");
    map.put('\u1C7E', "OL CHIKI PUNCTUATION MUCAAD");
    map.put('\u1C7F', "OL CHIKI PUNCTUATION DOUBLE MUCAAD");

  }

  public static final void vedic(Map<Character, String> map) {

    map.put('\u1CD0', "VEDIC TONE KARSHANA");
    map.put('\u1CD1', "VEDIC TONE SHARA");
    map.put('\u1CD2', "VEDIC TONE PRENKHA");
    map.put('\u1CD3', "VEDIC SIGN NIHSHVASA");
    map.put('\u1CD4', "VEDIC SIGN YAJURVEDIC MIDLINE SVARITA");
    map.put('\u1CD5', "VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA");
    map.put('\u1CD6', "VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA");
    map.put('\u1CD7', "VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA");
    map.put('\u1CD8', "VEDIC TONE CANDRA BELOW");
    map.put('\u1CD9', "VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER");
    map.put('\u1CDA', "VEDIC TONE DOUBLE SVARITA");
    map.put('\u1CDB', "VEDIC TONE TRIPLE SVARITA");
    map.put('\u1CDC', "VEDIC TONE KATHAKA ANUDATTA");
    map.put('\u1CDD', "VEDIC TONE DOT BELOW");
    map.put('\u1CDE', "VEDIC TONE TWO DOTS BELOW");
    map.put('\u1CDF', "VEDIC TONE THREE DOTS BELOW");
    map.put('\u1CE0', "VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA");
    map.put('\u1CE1', "VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA");
    map.put('\u1CE2', "VEDIC SIGN VISARGA SVARITA");
    map.put('\u1CE3', "VEDIC SIGN VISARGA UDATTA");
    map.put('\u1CE4', "VEDIC SIGN REVERSED VISARGA UDATTA");
    map.put('\u1CE5', "VEDIC SIGN VISARGA ANUDATTA");
    map.put('\u1CE6', "VEDIC SIGN REVERSED VISARGA ANUDATTA");
    map.put('\u1CE7', "VEDIC SIGN VISARGA UDATTA WITH TAIL");
    map.put('\u1CE8', "VEDIC SIGN VISARGA ANUDATTA WITH TAIL");
    map.put('\u1CE9', "VEDIC SIGN ANUSVARA ANTARGOMUKHA");
    map.put('\u1CEA', "VEDIC SIGN ANUSVARA BAHIRGOMUKHA");
    map.put('\u1CEB', "VEDIC SIGN ANUSVARA VAMAGOMUKHA");
    map.put('\u1CEC', "VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL");
    map.put('\u1CED', "VEDIC SIGN TIRYAK");
    map.put('\u1CEE', "VEDIC SIGN HEXIFORM LONG ANUSVARA");
    map.put('\u1CEF', "VEDIC SIGN LONG ANUSVARA");
    map.put('\u1CF0', "VEDIC SIGN RTHANG LONG ANUSVARA");
    map.put('\u1CF1', "VEDIC SIGN ANUSVARA UBHAYATO MUKHA");
    map.put('\u1CF2', "VEDIC SIGN ARDHAVISARGA");

  }

  public static final void phoneticExtensions(Map<Character, String> map) {

    map.put('\u1D00', "LATIN LETTER SMALL CAPITAL A");
    map.put('\u1D01', "LATIN LETTER SMALL CAPITAL AE");
    map.put('\u1D02', "LATIN SMALL LETTER TURNED AE");
    map.put('\u1D03', "LATIN LETTER SMALL CAPITAL BARRED B");
    map.put('\u1D04', "LATIN LETTER SMALL CAPITAL C");
    map.put('\u1D05', "LATIN LETTER SMALL CAPITAL D");
    map.put('\u1D06', "LATIN LETTER SMALL CAPITAL ETH");
    map.put('\u1D07', "LATIN LETTER SMALL CAPITAL E");
    map.put('\u1D08', "LATIN SMALL LETTER TURNED OPEN E");
    map.put('\u1D09', "LATIN SMALL LETTER TURNED I");
    map.put('\u1D0A', "LATIN LETTER SMALL CAPITAL J");
    map.put('\u1D0B', "LATIN LETTER SMALL CAPITAL K");
    map.put('\u1D0C', "LATIN LETTER SMALL CAPITAL L WITH STROKE");
    map.put('\u1D0D', "LATIN LETTER SMALL CAPITAL M");
    map.put('\u1D0E', "LATIN LETTER SMALL CAPITAL REVERSED N");
    map.put('\u1D0F', "LATIN LETTER SMALL CAPITAL O");
    map.put('\u1D10', "LATIN LETTER SMALL CAPITAL OPEN O");
    map.put('\u1D11', "LATIN SMALL LETTER SIDEWAYS O");
    map.put('\u1D12', "LATIN SMALL LETTER SIDEWAYS OPEN O");
    map.put('\u1D13', "LATIN SMALL LETTER SIDEWAYS O WITH STROKE");
    map.put('\u1D14', "LATIN SMALL LETTER TURNED OE");
    map.put('\u1D15', "LATIN LETTER SMALL CAPITAL OU");
    map.put('\u1D16', "LATIN SMALL LETTER TOP HALF O");
    map.put('\u1D17', "LATIN SMALL LETTER BOTTOM HALF O");
    map.put('\u1D18', "LATIN LETTER SMALL CAPITAL P");
    map.put('\u1D19', "LATIN LETTER SMALL CAPITAL REVERSED R");
    map.put('\u1D1A', "LATIN LETTER SMALL CAPITAL TURNED R");
    map.put('\u1D1B', "LATIN LETTER SMALL CAPITAL T");
    map.put('\u1D1C', "LATIN LETTER SMALL CAPITAL U");
    map.put('\u1D1D', "LATIN SMALL LETTER SIDEWAYS U");
    map.put('\u1D1E', "LATIN SMALL LETTER SIDEWAYS DIAERESIZED U");
    map.put('\u1D1F', "LATIN SMALL LETTER SIDEWAYS TURNED M");
    map.put('\u1D20', "LATIN LETTER SMALL CAPITAL V");
    map.put('\u1D21', "LATIN LETTER SMALL CAPITAL W");
    map.put('\u1D22', "LATIN LETTER SMALL CAPITAL Z");
    map.put('\u1D23', "LATIN LETTER SMALL CAPITAL EZH");
    map.put('\u1D24', "LATIN LETTER VOICED LARYNGEAL SPIRANT");
    map.put('\u1D25', "LATIN LETTER AIN");
    map.put('\u1D26', "GREEK LETTER SMALL CAPITAL GAMMA");
    map.put('\u1D27', "GREEK LETTER SMALL CAPITAL LAMDA");
    map.put('\u1D28', "GREEK LETTER SMALL CAPITAL PI");
    map.put('\u1D29', "GREEK LETTER SMALL CAPITAL RHO");
    map.put('\u1D2A', "GREEK LETTER SMALL CAPITAL PSI");
    map.put('\u1D2B', "CYRILLIC LETTER SMALL CAPITAL EL");
    map.put('\u1D2C', "MODIFIER LETTER CAPITAL A");
    map.put('\u1D2D', "MODIFIER LETTER CAPITAL AE");
    map.put('\u1D2E', "MODIFIER LETTER CAPITAL B");
    map.put('\u1D2F', "MODIFIER LETTER CAPITAL BARRED B");
    map.put('\u1D30', "MODIFIER LETTER CAPITAL D");
    map.put('\u1D31', "MODIFIER LETTER CAPITAL E");
    map.put('\u1D32', "MODIFIER LETTER CAPITAL REVERSED E");
    map.put('\u1D33', "MODIFIER LETTER CAPITAL G");
    map.put('\u1D34', "MODIFIER LETTER CAPITAL H");
    map.put('\u1D35', "MODIFIER LETTER CAPITAL I");
    map.put('\u1D36', "MODIFIER LETTER CAPITAL J");
    map.put('\u1D37', "MODIFIER LETTER CAPITAL K");
    map.put('\u1D38', "MODIFIER LETTER CAPITAL L");
    map.put('\u1D39', "MODIFIER LETTER CAPITAL M");
    map.put('\u1D3A', "MODIFIER LETTER CAPITAL N");
    map.put('\u1D3B', "MODIFIER LETTER CAPITAL REVERSED N");
    map.put('\u1D3C', "MODIFIER LETTER CAPITAL O");
    map.put('\u1D3D', "MODIFIER LETTER CAPITAL OU");
    map.put('\u1D3E', "MODIFIER LETTER CAPITAL P");
    map.put('\u1D3F', "MODIFIER LETTER CAPITAL R");
    map.put('\u1D40', "MODIFIER LETTER CAPITAL T");
    map.put('\u1D41', "MODIFIER LETTER CAPITAL U");
    map.put('\u1D42', "MODIFIER LETTER CAPITAL W");
    map.put('\u1D43', "MODIFIER LETTER SMALL A");
    map.put('\u1D44', "MODIFIER LETTER SMALL TURNED A");
    map.put('\u1D45', "MODIFIER LETTER SMALL ALPHA");
    map.put('\u1D46', "MODIFIER LETTER SMALL TURNED AE");
    map.put('\u1D47', "MODIFIER LETTER SMALL B");
    map.put('\u1D48', "MODIFIER LETTER SMALL D");
    map.put('\u1D49', "MODIFIER LETTER SMALL E");
    map.put('\u1D4A', "MODIFIER LETTER SMALL SCHWA");
    map.put('\u1D4B', "MODIFIER LETTER SMALL OPEN E");
    map.put('\u1D4C', "MODIFIER LETTER SMALL TURNED OPEN E");
    map.put('\u1D4D', "MODIFIER LETTER SMALL G");
    map.put('\u1D4E', "MODIFIER LETTER SMALL TURNED I");
    map.put('\u1D4F', "MODIFIER LETTER SMALL K");
    map.put('\u1D50', "MODIFIER LETTER SMALL M");
    map.put('\u1D51', "MODIFIER LETTER SMALL ENG");
    map.put('\u1D52', "MODIFIER LETTER SMALL O");
    map.put('\u1D53', "MODIFIER LETTER SMALL OPEN O");
    map.put('\u1D54', "MODIFIER LETTER SMALL TOP HALF O");
    map.put('\u1D55', "MODIFIER LETTER SMALL BOTTOM HALF O");
    map.put('\u1D56', "MODIFIER LETTER SMALL P");
    map.put('\u1D57', "MODIFIER LETTER SMALL T");
    map.put('\u1D58', "MODIFIER LETTER SMALL U");
    map.put('\u1D59', "MODIFIER LETTER SMALL SIDEWAYS U");
    map.put('\u1D5A', "MODIFIER LETTER SMALL TURNED M");
    map.put('\u1D5B', "MODIFIER LETTER SMALL V");
    map.put('\u1D5C', "MODIFIER LETTER SMALL AIN");
    map.put('\u1D5D', "MODIFIER LETTER SMALL BETA");
    map.put('\u1D5E', "MODIFIER LETTER SMALL GREEK GAMMA");
    map.put('\u1D5F', "MODIFIER LETTER SMALL DELTA");
    map.put('\u1D60', "MODIFIER LETTER SMALL GREEK PHI");
    map.put('\u1D61', "MODIFIER LETTER SMALL CHI");
    map.put('\u1D62', "LATIN SUBSCRIPT SMALL LETTER I");
    map.put('\u1D63', "LATIN SUBSCRIPT SMALL LETTER R");
    map.put('\u1D64', "LATIN SUBSCRIPT SMALL LETTER U");
    map.put('\u1D65', "LATIN SUBSCRIPT SMALL LETTER V");
    map.put('\u1D66', "GREEK SUBSCRIPT SMALL LETTER BETA");
    map.put('\u1D67', "GREEK SUBSCRIPT SMALL LETTER GAMMA");
    map.put('\u1D68', "GREEK SUBSCRIPT SMALL LETTER RHO");
    map.put('\u1D69', "GREEK SUBSCRIPT SMALL LETTER PHI");
    map.put('\u1D6A', "GREEK SUBSCRIPT SMALL LETTER CHI");
    map.put('\u1D6B', "LATIN SMALL LETTER UE");
    map.put('\u1D6C', "LATIN SMALL LETTER B WITH MIDDLE TILDE");
    map.put('\u1D6D', "LATIN SMALL LETTER D WITH MIDDLE TILDE");
    map.put('\u1D6E', "LATIN SMALL LETTER F WITH MIDDLE TILDE");
    map.put('\u1D6F', "LATIN SMALL LETTER M WITH MIDDLE TILDE");
    map.put('\u1D70', "LATIN SMALL LETTER N WITH MIDDLE TILDE");
    map.put('\u1D71', "LATIN SMALL LETTER P WITH MIDDLE TILDE");
    map.put('\u1D72', "LATIN SMALL LETTER R WITH MIDDLE TILDE");
    map.put('\u1D73', "LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE");
    map.put('\u1D74', "LATIN SMALL LETTER S WITH MIDDLE TILDE");
    map.put('\u1D75', "LATIN SMALL LETTER T WITH MIDDLE TILDE");
    map.put('\u1D76', "LATIN SMALL LETTER Z WITH MIDDLE TILDE");
    map.put('\u1D77', "LATIN SMALL LETTER TURNED G");
    map.put('\u1D78', "MODIFIER LETTER CYRILLIC EN");
    map.put('\u1D79', "LATIN SMALL LETTER INSULAR G");
    map.put('\u1D7A', "LATIN SMALL LETTER TH WITH STRIKETHROUGH");
    map.put('\u1D7B', "LATIN SMALL CAPITAL LETTER I WITH STROKE");
    map.put('\u1D7C', "LATIN SMALL LETTER IOTA WITH STROKE");
    map.put('\u1D7D', "LATIN SMALL LETTER P WITH STROKE");
    map.put('\u1D7E', "LATIN SMALL CAPITAL LETTER U WITH STROKE");
    map.put('\u1D7F', "LATIN SMALL LETTER UPSILON WITH STROKE");

  }

  public static final void phoneticExtensionsSupplement(Map<Character, String> map) {

    map.put('\u1D80', "LATIN SMALL LETTER B WITH PALATAL HOOK");
    map.put('\u1D81', "LATIN SMALL LETTER D WITH PALATAL HOOK");
    map.put('\u1D82', "LATIN SMALL LETTER F WITH PALATAL HOOK");
    map.put('\u1D83', "LATIN SMALL LETTER G WITH PALATAL HOOK");
    map.put('\u1D84', "LATIN SMALL LETTER K WITH PALATAL HOOK");
    map.put('\u1D85', "LATIN SMALL LETTER L WITH PALATAL HOOK");
    map.put('\u1D86', "LATIN SMALL LETTER M WITH PALATAL HOOK");
    map.put('\u1D87', "LATIN SMALL LETTER N WITH PALATAL HOOK");
    map.put('\u1D88', "LATIN SMALL LETTER P WITH PALATAL HOOK");
    map.put('\u1D89', "LATIN SMALL LETTER R WITH PALATAL HOOK");
    map.put('\u1D8A', "LATIN SMALL LETTER S WITH PALATAL HOOK");
    map.put('\u1D8B', "LATIN SMALL LETTER ESH WITH PALATAL HOOK");
    map.put('\u1D8C', "LATIN SMALL LETTER V WITH PALATAL HOOK");
    map.put('\u1D8D', "LATIN SMALL LETTER X WITH PALATAL HOOK");
    map.put('\u1D8E', "LATIN SMALL LETTER Z WITH PALATAL HOOK");
    map.put('\u1D8F', "LATIN SMALL LETTER A WITH RETROFLEX HOOK");
    map.put('\u1D90', "LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK");
    map.put('\u1D91', "LATIN SMALL LETTER D WITH HOOK AND TAIL");
    map.put('\u1D92', "LATIN SMALL LETTER E WITH RETROFLEX HOOK");
    map.put('\u1D93', "LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK");
    map.put('\u1D94', "LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK");
    map.put('\u1D95', "LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK");
    map.put('\u1D96', "LATIN SMALL LETTER I WITH RETROFLEX HOOK");
    map.put('\u1D97', "LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK");
    map.put('\u1D98', "LATIN SMALL LETTER ESH WITH RETROFLEX HOOK");
    map.put('\u1D99', "LATIN SMALL LETTER U WITH RETROFLEX HOOK");
    map.put('\u1D9A', "LATIN SMALL LETTER EZH WITH RETROFLEX HOOK");
    map.put('\u1D9B', "MODIFIER LETTER SMALL TURNED ALPHA");
    map.put('\u1D9C', "MODIFIER LETTER SMALL C");
    map.put('\u1D9D', "MODIFIER LETTER SMALL C WITH CURL");
    map.put('\u1D9E', "MODIFIER LETTER SMALL ETH");
    map.put('\u1D9F', "MODIFIER LETTER SMALL REVERSED OPEN E");
    map.put('\u1DA0', "MODIFIER LETTER SMALL F");
    map.put('\u1DA1', "MODIFIER LETTER SMALL DOTLESS J WITH STROKE");
    map.put('\u1DA2', "MODIFIER LETTER SMALL SCRIPT G");
    map.put('\u1DA3', "MODIFIER LETTER SMALL TURNED H");
    map.put('\u1DA4', "MODIFIER LETTER SMALL I WITH STROKE");
    map.put('\u1DA5', "MODIFIER LETTER SMALL IOTA");
    map.put('\u1DA6', "MODIFIER LETTER SMALL CAPITAL I");
    map.put('\u1DA7', "MODIFIER LETTER SMALL CAPITAL I WITH STROKE");
    map.put('\u1DA8', "MODIFIER LETTER SMALL J WITH CROSSED-TAIL");
    map.put('\u1DA9', "MODIFIER LETTER SMALL L WITH RETROFLEX HOOK");
    map.put('\u1DAA', "MODIFIER LETTER SMALL L WITH PALATAL HOOK");
    map.put('\u1DAB', "MODIFIER LETTER SMALL CAPITAL L");
    map.put('\u1DAC', "MODIFIER LETTER SMALL M WITH HOOK");
    map.put('\u1DAD', "MODIFIER LETTER SMALL TURNED M WITH LONG LEG");
    map.put('\u1DAE', "MODIFIER LETTER SMALL N WITH LEFT HOOK");
    map.put('\u1DAF', "MODIFIER LETTER SMALL N WITH RETROFLEX HOOK");
    map.put('\u1DB0', "MODIFIER LETTER SMALL CAPITAL N");
    map.put('\u1DB1', "MODIFIER LETTER SMALL BARRED O");
    map.put('\u1DB2', "MODIFIER LETTER SMALL PHI");
    map.put('\u1DB3', "MODIFIER LETTER SMALL S WITH HOOK");
    map.put('\u1DB4', "MODIFIER LETTER SMALL ESH");
    map.put('\u1DB5', "MODIFIER LETTER SMALL T WITH PALATAL HOOK");
    map.put('\u1DB6', "MODIFIER LETTER SMALL U BAR");
    map.put('\u1DB7', "MODIFIER LETTER SMALL UPSILON");
    map.put('\u1DB8', "MODIFIER LETTER SMALL CAPITAL U");
    map.put('\u1DB9', "MODIFIER LETTER SMALL V WITH HOOK");
    map.put('\u1DBA', "MODIFIER LETTER SMALL TURNED V");
    map.put('\u1DBB', "MODIFIER LETTER SMALL Z");
    map.put('\u1DBC', "MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK");
    map.put('\u1DBD', "MODIFIER LETTER SMALL Z WITH CURL");
    map.put('\u1DBE', "MODIFIER LETTER SMALL EZH");
    map.put('\u1DBF', "MODIFIER LETTER SMALL THETA");

  }

  public static final void combiningDiacriticalMarksSupplement(Map<Character, String> map) {

    map.put('\u1DC0', "COMBINING DOTTED GRAVE ACCENT");
    map.put('\u1DC1', "COMBINING DOTTED ACUTE ACCENT");
    map.put('\u1DC2', "COMBINING SNAKE BELOW");
    map.put('\u1DC3', "COMBINING SUSPENSION MARK");
    map.put('\u1DC4', "COMBINING MACRON-ACUTE");
    map.put('\u1DC5', "COMBINING GRAVE-MACRON");
    map.put('\u1DC6', "COMBINING MACRON-GRAVE");
    map.put('\u1DC7', "COMBINING ACUTE-MACRON");
    map.put('\u1DC8', "COMBINING GRAVE-ACUTE-GRAVE");
    map.put('\u1DC9', "COMBINING ACUTE-GRAVE-ACUTE");
    map.put('\u1DCA', "COMBINING LATIN SMALL LETTER R BELOW");
    map.put('\u1DCB', "COMBINING BREVE-MACRON");
    map.put('\u1DCC', "COMBINING MACRON-BREVE");
    map.put('\u1DCD', "COMBINING DOUBLE CIRCUMFLEX ABOVE");
    map.put('\u1DCE', "COMBINING OGONEK ABOVE");
    map.put('\u1DCF', "COMBINING ZIGZAG BELOW");
    map.put('\u1DD0', "COMBINING IS BELOW");
    map.put('\u1DD1', "COMBINING UR ABOVE");
    map.put('\u1DD2', "COMBINING US ABOVE");
    map.put('\u1DD3', "COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE");
    map.put('\u1DD4', "COMBINING LATIN SMALL LETTER AE");
    map.put('\u1DD5', "COMBINING LATIN SMALL LETTER AO");
    map.put('\u1DD6', "COMBINING LATIN SMALL LETTER AV");
    map.put('\u1DD7', "COMBINING LATIN SMALL LETTER C CEDILLA");
    map.put('\u1DD8', "COMBINING LATIN SMALL LETTER INSULAR D");
    map.put('\u1DD9', "COMBINING LATIN SMALL LETTER ETH");
    map.put('\u1DDA', "COMBINING LATIN SMALL LETTER G");
    map.put('\u1DDB', "COMBINING LATIN LETTER SMALL CAPITAL G");
    map.put('\u1DDC', "COMBINING LATIN SMALL LETTER K");
    map.put('\u1DDD', "COMBINING LATIN SMALL LETTER L");
    map.put('\u1DDE', "COMBINING LATIN LETTER SMALL CAPITAL L");
    map.put('\u1DDF', "COMBINING LATIN LETTER SMALL CAPITAL M");
    map.put('\u1DE0', "COMBINING LATIN SMALL LETTER N");
    map.put('\u1DE1', "COMBINING LATIN LETTER SMALL CAPITAL N");
    map.put('\u1DE2', "COMBINING LATIN LETTER SMALL CAPITAL R");
    map.put('\u1DE3', "COMBINING LATIN SMALL LETTER R ROTUNDA");
    map.put('\u1DE4', "COMBINING LATIN SMALL LETTER S");
    map.put('\u1DE5', "COMBINING LATIN SMALL LETTER LONG S");
    map.put('\u1DE6', "COMBINING LATIN SMALL LETTER Z");
    map.put('\u1DFD', "COMBINING ALMOST EQUAL TO BELOW");
    map.put('\u1DFE', "COMBINING LEFT ARROWHEAD ABOVE");
    map.put('\u1DFF', "COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW");

  }

  public static final void latinExtendedAdditional(Map<Character, String> map) {

    map.put('\u1E00', "LATIN CAPITAL LETTER A WITH RING BELOW");
    map.put('\u1E01', "LATIN SMALL LETTER A WITH RING BELOW");
    map.put('\u1E02', "LATIN CAPITAL LETTER B WITH DOT ABOVE");
    map.put('\u1E03', "LATIN SMALL LETTER B WITH DOT ABOVE");
    map.put('\u1E04', "LATIN CAPITAL LETTER B WITH DOT BELOW");
    map.put('\u1E05', "LATIN SMALL LETTER B WITH DOT BELOW");
    map.put('\u1E06', "LATIN CAPITAL LETTER B WITH LINE BELOW");
    map.put('\u1E07', "LATIN SMALL LETTER B WITH LINE BELOW");
    map.put('\u1E08', "LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE");
    map.put('\u1E09', "LATIN SMALL LETTER C WITH CEDILLA AND ACUTE");
    map.put('\u1E0A', "LATIN CAPITAL LETTER D WITH DOT ABOVE");
    map.put('\u1E0B', "LATIN SMALL LETTER D WITH DOT ABOVE");
    map.put('\u1E0C', "LATIN CAPITAL LETTER D WITH DOT BELOW");
    map.put('\u1E0D', "LATIN SMALL LETTER D WITH DOT BELOW");
    map.put('\u1E0E', "LATIN CAPITAL LETTER D WITH LINE BELOW");
    map.put('\u1E0F', "LATIN SMALL LETTER D WITH LINE BELOW");
    map.put('\u1E10', "LATIN CAPITAL LETTER D WITH CEDILLA");
    map.put('\u1E11', "LATIN SMALL LETTER D WITH CEDILLA");
    map.put('\u1E12', "LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW");
    map.put('\u1E13', "LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW");
    map.put('\u1E14', "LATIN CAPITAL LETTER E WITH MACRON AND GRAVE");
    map.put('\u1E15', "LATIN SMALL LETTER E WITH MACRON AND GRAVE");
    map.put('\u1E16', "LATIN CAPITAL LETTER E WITH MACRON AND ACUTE");
    map.put('\u1E17', "LATIN SMALL LETTER E WITH MACRON AND ACUTE");
    map.put('\u1E18', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW");
    map.put('\u1E19', "LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW");
    map.put('\u1E1A', "LATIN CAPITAL LETTER E WITH TILDE BELOW");
    map.put('\u1E1B', "LATIN SMALL LETTER E WITH TILDE BELOW");
    map.put('\u1E1C', "LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE");
    map.put('\u1E1D', "LATIN SMALL LETTER E WITH CEDILLA AND BREVE");
    map.put('\u1E1E', "LATIN CAPITAL LETTER F WITH DOT ABOVE");
    map.put('\u1E1F', "LATIN SMALL LETTER F WITH DOT ABOVE");
    map.put('\u1E20', "LATIN CAPITAL LETTER G WITH MACRON");
    map.put('\u1E21', "LATIN SMALL LETTER G WITH MACRON");
    map.put('\u1E22', "LATIN CAPITAL LETTER H WITH DOT ABOVE");
    map.put('\u1E23', "LATIN SMALL LETTER H WITH DOT ABOVE");
    map.put('\u1E24', "LATIN CAPITAL LETTER H WITH DOT BELOW");
    map.put('\u1E25', "LATIN SMALL LETTER H WITH DOT BELOW");
    map.put('\u1E26', "LATIN CAPITAL LETTER H WITH DIAERESIS");
    map.put('\u1E27', "LATIN SMALL LETTER H WITH DIAERESIS");
    map.put('\u1E28', "LATIN CAPITAL LETTER H WITH CEDILLA");
    map.put('\u1E29', "LATIN SMALL LETTER H WITH CEDILLA");
    map.put('\u1E2A', "LATIN CAPITAL LETTER H WITH BREVE BELOW");
    map.put('\u1E2B', "LATIN SMALL LETTER H WITH BREVE BELOW");
    map.put('\u1E2C', "LATIN CAPITAL LETTER I WITH TILDE BELOW");
    map.put('\u1E2D', "LATIN SMALL LETTER I WITH TILDE BELOW");
    map.put('\u1E2E', "LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE");
    map.put('\u1E2F', "LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE");
    map.put('\u1E30', "LATIN CAPITAL LETTER K WITH ACUTE");
    map.put('\u1E31', "LATIN SMALL LETTER K WITH ACUTE");
    map.put('\u1E32', "LATIN CAPITAL LETTER K WITH DOT BELOW");
    map.put('\u1E33', "LATIN SMALL LETTER K WITH DOT BELOW");
    map.put('\u1E34', "LATIN CAPITAL LETTER K WITH LINE BELOW");
    map.put('\u1E35', "LATIN SMALL LETTER K WITH LINE BELOW");
    map.put('\u1E36', "LATIN CAPITAL LETTER L WITH DOT BELOW");
    map.put('\u1E37', "LATIN SMALL LETTER L WITH DOT BELOW");
    map.put('\u1E38', "LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON");
    map.put('\u1E39', "LATIN SMALL LETTER L WITH DOT BELOW AND MACRON");
    map.put('\u1E3A', "LATIN CAPITAL LETTER L WITH LINE BELOW");
    map.put('\u1E3B', "LATIN SMALL LETTER L WITH LINE BELOW");
    map.put('\u1E3C', "LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW");
    map.put('\u1E3D', "LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW");
    map.put('\u1E3E', "LATIN CAPITAL LETTER M WITH ACUTE");
    map.put('\u1E3F', "LATIN SMALL LETTER M WITH ACUTE");
    map.put('\u1E40', "LATIN CAPITAL LETTER M WITH DOT ABOVE");
    map.put('\u1E41', "LATIN SMALL LETTER M WITH DOT ABOVE");
    map.put('\u1E42', "LATIN CAPITAL LETTER M WITH DOT BELOW");
    map.put('\u1E43', "LATIN SMALL LETTER M WITH DOT BELOW");
    map.put('\u1E44', "LATIN CAPITAL LETTER N WITH DOT ABOVE");
    map.put('\u1E45', "LATIN SMALL LETTER N WITH DOT ABOVE");
    map.put('\u1E46', "LATIN CAPITAL LETTER N WITH DOT BELOW");
    map.put('\u1E47', "LATIN SMALL LETTER N WITH DOT BELOW");
    map.put('\u1E48', "LATIN CAPITAL LETTER N WITH LINE BELOW");
    map.put('\u1E49', "LATIN SMALL LETTER N WITH LINE BELOW");
    map.put('\u1E4A', "LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW");
    map.put('\u1E4B', "LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW");
    map.put('\u1E4C', "LATIN CAPITAL LETTER O WITH TILDE AND ACUTE");
    map.put('\u1E4D', "LATIN SMALL LETTER O WITH TILDE AND ACUTE");
    map.put('\u1E4E', "LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS");
    map.put('\u1E4F', "LATIN SMALL LETTER O WITH TILDE AND DIAERESIS");
    map.put('\u1E50', "LATIN CAPITAL LETTER O WITH MACRON AND GRAVE");
    map.put('\u1E51', "LATIN SMALL LETTER O WITH MACRON AND GRAVE");
    map.put('\u1E52', "LATIN CAPITAL LETTER O WITH MACRON AND ACUTE");
    map.put('\u1E53', "LATIN SMALL LETTER O WITH MACRON AND ACUTE");
    map.put('\u1E54', "LATIN CAPITAL LETTER P WITH ACUTE");
    map.put('\u1E55', "LATIN SMALL LETTER P WITH ACUTE");
    map.put('\u1E56', "LATIN CAPITAL LETTER P WITH DOT ABOVE");
    map.put('\u1E57', "LATIN SMALL LETTER P WITH DOT ABOVE");
    map.put('\u1E58', "LATIN CAPITAL LETTER R WITH DOT ABOVE");
    map.put('\u1E59', "LATIN SMALL LETTER R WITH DOT ABOVE");
    map.put('\u1E5A', "LATIN CAPITAL LETTER R WITH DOT BELOW");
    map.put('\u1E5B', "LATIN SMALL LETTER R WITH DOT BELOW");
    map.put('\u1E5C', "LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON");
    map.put('\u1E5D', "LATIN SMALL LETTER R WITH DOT BELOW AND MACRON");
    map.put('\u1E5E', "LATIN CAPITAL LETTER R WITH LINE BELOW");
    map.put('\u1E5F', "LATIN SMALL LETTER R WITH LINE BELOW");
    map.put('\u1E60', "LATIN CAPITAL LETTER S WITH DOT ABOVE");
    map.put('\u1E61', "LATIN SMALL LETTER S WITH DOT ABOVE");
    map.put('\u1E62', "LATIN CAPITAL LETTER S WITH DOT BELOW");
    map.put('\u1E63', "LATIN SMALL LETTER S WITH DOT BELOW");
    map.put('\u1E64', "LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE");
    map.put('\u1E65', "LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE");
    map.put('\u1E66', "LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE");
    map.put('\u1E67', "LATIN SMALL LETTER S WITH CARON AND DOT ABOVE");
    map.put('\u1E68', "LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE");
    map.put('\u1E69', "LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE");
    map.put('\u1E6A', "LATIN CAPITAL LETTER T WITH DOT ABOVE");
    map.put('\u1E6B', "LATIN SMALL LETTER T WITH DOT ABOVE");
    map.put('\u1E6C', "LATIN CAPITAL LETTER T WITH DOT BELOW");
    map.put('\u1E6D', "LATIN SMALL LETTER T WITH DOT BELOW");
    map.put('\u1E6E', "LATIN CAPITAL LETTER T WITH LINE BELOW");
    map.put('\u1E6F', "LATIN SMALL LETTER T WITH LINE BELOW");
    map.put('\u1E70', "LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW");
    map.put('\u1E71', "LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW");
    map.put('\u1E72', "LATIN CAPITAL LETTER U WITH DIAERESIS BELOW");
    map.put('\u1E73', "LATIN SMALL LETTER U WITH DIAERESIS BELOW");
    map.put('\u1E74', "LATIN CAPITAL LETTER U WITH TILDE BELOW");
    map.put('\u1E75', "LATIN SMALL LETTER U WITH TILDE BELOW");
    map.put('\u1E76', "LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW");
    map.put('\u1E77', "LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW");
    map.put('\u1E78', "LATIN CAPITAL LETTER U WITH TILDE AND ACUTE");
    map.put('\u1E79', "LATIN SMALL LETTER U WITH TILDE AND ACUTE");
    map.put('\u1E7A', "LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS");
    map.put('\u1E7B', "LATIN SMALL LETTER U WITH MACRON AND DIAERESIS");
    map.put('\u1E7C', "LATIN CAPITAL LETTER V WITH TILDE");
    map.put('\u1E7D', "LATIN SMALL LETTER V WITH TILDE");
    map.put('\u1E7E', "LATIN CAPITAL LETTER V WITH DOT BELOW");
    map.put('\u1E7F', "LATIN SMALL LETTER V WITH DOT BELOW");
    map.put('\u1E80', "LATIN CAPITAL LETTER W WITH GRAVE");
    map.put('\u1E81', "LATIN SMALL LETTER W WITH GRAVE");
    map.put('\u1E82', "LATIN CAPITAL LETTER W WITH ACUTE");
    map.put('\u1E83', "LATIN SMALL LETTER W WITH ACUTE");
    map.put('\u1E84', "LATIN CAPITAL LETTER W WITH DIAERESIS");
    map.put('\u1E85', "LATIN SMALL LETTER W WITH DIAERESIS");
    map.put('\u1E86', "LATIN CAPITAL LETTER W WITH DOT ABOVE");
    map.put('\u1E87', "LATIN SMALL LETTER W WITH DOT ABOVE");
    map.put('\u1E88', "LATIN CAPITAL LETTER W WITH DOT BELOW");
    map.put('\u1E89', "LATIN SMALL LETTER W WITH DOT BELOW");
    map.put('\u1E8A', "LATIN CAPITAL LETTER X WITH DOT ABOVE");
    map.put('\u1E8B', "LATIN SMALL LETTER X WITH DOT ABOVE");
    map.put('\u1E8C', "LATIN CAPITAL LETTER X WITH DIAERESIS");
    map.put('\u1E8D', "LATIN SMALL LETTER X WITH DIAERESIS");
    map.put('\u1E8E', "LATIN CAPITAL LETTER Y WITH DOT ABOVE");
    map.put('\u1E8F', "LATIN SMALL LETTER Y WITH DOT ABOVE");
    map.put('\u1E90', "LATIN CAPITAL LETTER Z WITH CIRCUMFLEX");
    map.put('\u1E91', "LATIN SMALL LETTER Z WITH CIRCUMFLEX");
    map.put('\u1E92', "LATIN CAPITAL LETTER Z WITH DOT BELOW");
    map.put('\u1E93', "LATIN SMALL LETTER Z WITH DOT BELOW");
    map.put('\u1E94', "LATIN CAPITAL LETTER Z WITH LINE BELOW");
    map.put('\u1E95', "LATIN SMALL LETTER Z WITH LINE BELOW");
    map.put('\u1E96', "LATIN SMALL LETTER H WITH LINE BELOW");
    map.put('\u1E97', "LATIN SMALL LETTER T WITH DIAERESIS");
    map.put('\u1E98', "LATIN SMALL LETTER W WITH RING ABOVE");
    map.put('\u1E99', "LATIN SMALL LETTER Y WITH RING ABOVE");
    map.put('\u1E9A', "LATIN SMALL LETTER A WITH RIGHT HALF RING");
    map.put('\u1E9B', "LATIN SMALL LETTER LONG S WITH DOT ABOVE");
    map.put('\u1E9C', "LATIN SMALL LETTER LONG S WITH DIAGONAL STROKE");
    map.put('\u1E9D', "LATIN SMALL LETTER LONG S WITH HIGH STROKE");
    map.put('\u1E9E', "LATIN CAPITAL LETTER SHARP S");
    map.put('\u1E9F', "LATIN SMALL LETTER DELTA");
    map.put('\u1EA0', "LATIN CAPITAL LETTER A WITH DOT BELOW");
    map.put('\u1EA1', "LATIN SMALL LETTER A WITH DOT BELOW");
    map.put('\u1EA2', "LATIN CAPITAL LETTER A WITH HOOK ABOVE");
    map.put('\u1EA3', "LATIN SMALL LETTER A WITH HOOK ABOVE");
    map.put('\u1EA4', "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE");
    map.put('\u1EA5', "LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE");
    map.put('\u1EA6', "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE");
    map.put('\u1EA7', "LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE");
    map.put('\u1EA8', "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE");
    map.put('\u1EA9', "LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE");
    map.put('\u1EAA', "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE");
    map.put('\u1EAB', "LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE");
    map.put('\u1EAC', "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW");
    map.put('\u1EAD', "LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW");
    map.put('\u1EAE', "LATIN CAPITAL LETTER A WITH BREVE AND ACUTE");
    map.put('\u1EAF', "LATIN SMALL LETTER A WITH BREVE AND ACUTE");
    map.put('\u1EB0', "LATIN CAPITAL LETTER A WITH BREVE AND GRAVE");
    map.put('\u1EB1', "LATIN SMALL LETTER A WITH BREVE AND GRAVE");
    map.put('\u1EB2', "LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE");
    map.put('\u1EB3', "LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE");
    map.put('\u1EB4', "LATIN CAPITAL LETTER A WITH BREVE AND TILDE");
    map.put('\u1EB5', "LATIN SMALL LETTER A WITH BREVE AND TILDE");
    map.put('\u1EB6', "LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW");
    map.put('\u1EB7', "LATIN SMALL LETTER A WITH BREVE AND DOT BELOW");
    map.put('\u1EB8', "LATIN CAPITAL LETTER E WITH DOT BELOW");
    map.put('\u1EB9', "LATIN SMALL LETTER E WITH DOT BELOW");
    map.put('\u1EBA', "LATIN CAPITAL LETTER E WITH HOOK ABOVE");
    map.put('\u1EBB', "LATIN SMALL LETTER E WITH HOOK ABOVE");
    map.put('\u1EBC', "LATIN CAPITAL LETTER E WITH TILDE");
    map.put('\u1EBD', "LATIN SMALL LETTER E WITH TILDE");
    map.put('\u1EBE', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE");
    map.put('\u1EBF', "LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE");
    map.put('\u1EC0', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE");
    map.put('\u1EC1', "LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE");
    map.put('\u1EC2', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE");
    map.put('\u1EC3', "LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE");
    map.put('\u1EC4', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE");
    map.put('\u1EC5', "LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE");
    map.put('\u1EC6', "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW");
    map.put('\u1EC7', "LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW");
    map.put('\u1EC8', "LATIN CAPITAL LETTER I WITH HOOK ABOVE");
    map.put('\u1EC9', "LATIN SMALL LETTER I WITH HOOK ABOVE");
    map.put('\u1ECA', "LATIN CAPITAL LETTER I WITH DOT BELOW");
    map.put('\u1ECB', "LATIN SMALL LETTER I WITH DOT BELOW");
    map.put('\u1ECC', "LATIN CAPITAL LETTER O WITH DOT BELOW");
    map.put('\u1ECD', "LATIN SMALL LETTER O WITH DOT BELOW");
    map.put('\u1ECE', "LATIN CAPITAL LETTER O WITH HOOK ABOVE");
    map.put('\u1ECF', "LATIN SMALL LETTER O WITH HOOK ABOVE");
    map.put('\u1ED0', "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE");
    map.put('\u1ED1', "LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE");
    map.put('\u1ED2', "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE");
    map.put('\u1ED3', "LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE");
    map.put('\u1ED4', "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE");
    map.put('\u1ED5', "LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE");
    map.put('\u1ED6', "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE");
    map.put('\u1ED7', "LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE");
    map.put('\u1ED8', "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW");
    map.put('\u1ED9', "LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW");
    map.put('\u1EDA', "LATIN CAPITAL LETTER O WITH HORN AND ACUTE");
    map.put('\u1EDB', "LATIN SMALL LETTER O WITH HORN AND ACUTE");
    map.put('\u1EDC', "LATIN CAPITAL LETTER O WITH HORN AND GRAVE");
    map.put('\u1EDD', "LATIN SMALL LETTER O WITH HORN AND GRAVE");
    map.put('\u1EDE', "LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE");
    map.put('\u1EDF', "LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE");
    map.put('\u1EE0', "LATIN CAPITAL LETTER O WITH HORN AND TILDE");
    map.put('\u1EE1', "LATIN SMALL LETTER O WITH HORN AND TILDE");
    map.put('\u1EE2', "LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW");
    map.put('\u1EE3', "LATIN SMALL LETTER O WITH HORN AND DOT BELOW");
    map.put('\u1EE4', "LATIN CAPITAL LETTER U WITH DOT BELOW");
    map.put('\u1EE5', "LATIN SMALL LETTER U WITH DOT BELOW");
    map.put('\u1EE6', "LATIN CAPITAL LETTER U WITH HOOK ABOVE");
    map.put('\u1EE7', "LATIN SMALL LETTER U WITH HOOK ABOVE");
    map.put('\u1EE8', "LATIN CAPITAL LETTER U WITH HORN AND ACUTE");
    map.put('\u1EE9', "LATIN SMALL LETTER U WITH HORN AND ACUTE");
    map.put('\u1EEA', "LATIN CAPITAL LETTER U WITH HORN AND GRAVE");
    map.put('\u1EEB', "LATIN SMALL LETTER U WITH HORN AND GRAVE");
    map.put('\u1EEC', "LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE");
    map.put('\u1EED', "LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE");
    map.put('\u1EEE', "LATIN CAPITAL LETTER U WITH HORN AND TILDE");
    map.put('\u1EEF', "LATIN SMALL LETTER U WITH HORN AND TILDE");
    map.put('\u1EF0', "LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW");
    map.put('\u1EF1', "LATIN SMALL LETTER U WITH HORN AND DOT BELOW");
    map.put('\u1EF2', "LATIN CAPITAL LETTER Y WITH GRAVE");
    map.put('\u1EF3', "LATIN SMALL LETTER Y WITH GRAVE");
    map.put('\u1EF4', "LATIN CAPITAL LETTER Y WITH DOT BELOW");
    map.put('\u1EF5', "LATIN SMALL LETTER Y WITH DOT BELOW");
    map.put('\u1EF6', "LATIN CAPITAL LETTER Y WITH HOOK ABOVE");
    map.put('\u1EF7', "LATIN SMALL LETTER Y WITH HOOK ABOVE");
    map.put('\u1EF8', "LATIN CAPITAL LETTER Y WITH TILDE");
    map.put('\u1EF9', "LATIN SMALL LETTER Y WITH TILDE");
    map.put('\u1EFA', "LATIN CAPITAL LETTER MIDDLE-WELSH LL");
    map.put('\u1EFB', "LATIN SMALL LETTER MIDDLE-WELSH LL");
    map.put('\u1EFC', "LATIN CAPITAL LETTER MIDDLE-WELSH V");
    map.put('\u1EFD', "LATIN SMALL LETTER MIDDLE-WELSH V");
    map.put('\u1EFE', "LATIN CAPITAL LETTER Y WITH LOOP");
    map.put('\u1EFF', "LATIN SMALL LETTER Y WITH LOOP");

  }

  public static final void greekExtended(Map<Character, String> map) {

    map.put('\u1F00', "GREEK SMALL LETTER ALPHA WITH PSILI");
    map.put('\u1F01', "GREEK SMALL LETTER ALPHA WITH DASIA");
    map.put('\u1F02', "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA");
    map.put('\u1F03', "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA");
    map.put('\u1F04', "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA");
    map.put('\u1F05', "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA");
    map.put('\u1F06', "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI");
    map.put('\u1F07', "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI");
    map.put('\u1F08', "GREEK CAPITAL LETTER ALPHA WITH PSILI");
    map.put('\u1F09', "GREEK CAPITAL LETTER ALPHA WITH DASIA");
    map.put('\u1F0A', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA");
    map.put('\u1F0B', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA");
    map.put('\u1F0C', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA");
    map.put('\u1F0D', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA");
    map.put('\u1F0E', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI");
    map.put('\u1F0F', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI");
    map.put('\u1F10', "GREEK SMALL LETTER EPSILON WITH PSILI");
    map.put('\u1F11', "GREEK SMALL LETTER EPSILON WITH DASIA");
    map.put('\u1F12', "GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA");
    map.put('\u1F13', "GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA");
    map.put('\u1F14', "GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA");
    map.put('\u1F15', "GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA");
    map.put('\u1F18', "GREEK CAPITAL LETTER EPSILON WITH PSILI");
    map.put('\u1F19', "GREEK CAPITAL LETTER EPSILON WITH DASIA");
    map.put('\u1F1A', "GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA");
    map.put('\u1F1B', "GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA");
    map.put('\u1F1C', "GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA");
    map.put('\u1F1D', "GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA");
    map.put('\u1F20', "GREEK SMALL LETTER ETA WITH PSILI");
    map.put('\u1F21', "GREEK SMALL LETTER ETA WITH DASIA");
    map.put('\u1F22', "GREEK SMALL LETTER ETA WITH PSILI AND VARIA");
    map.put('\u1F23', "GREEK SMALL LETTER ETA WITH DASIA AND VARIA");
    map.put('\u1F24', "GREEK SMALL LETTER ETA WITH PSILI AND OXIA");
    map.put('\u1F25', "GREEK SMALL LETTER ETA WITH DASIA AND OXIA");
    map.put('\u1F26', "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI");
    map.put('\u1F27', "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI");
    map.put('\u1F28', "GREEK CAPITAL LETTER ETA WITH PSILI");
    map.put('\u1F29', "GREEK CAPITAL LETTER ETA WITH DASIA");
    map.put('\u1F2A', "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA");
    map.put('\u1F2B', "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA");
    map.put('\u1F2C', "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA");
    map.put('\u1F2D', "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA");
    map.put('\u1F2E', "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI");
    map.put('\u1F2F', "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI");
    map.put('\u1F30', "GREEK SMALL LETTER IOTA WITH PSILI");
    map.put('\u1F31', "GREEK SMALL LETTER IOTA WITH DASIA");
    map.put('\u1F32', "GREEK SMALL LETTER IOTA WITH PSILI AND VARIA");
    map.put('\u1F33', "GREEK SMALL LETTER IOTA WITH DASIA AND VARIA");
    map.put('\u1F34', "GREEK SMALL LETTER IOTA WITH PSILI AND OXIA");
    map.put('\u1F35', "GREEK SMALL LETTER IOTA WITH DASIA AND OXIA");
    map.put('\u1F36', "GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI");
    map.put('\u1F37', "GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI");
    map.put('\u1F38', "GREEK CAPITAL LETTER IOTA WITH PSILI");
    map.put('\u1F39', "GREEK CAPITAL LETTER IOTA WITH DASIA");
    map.put('\u1F3A', "GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA");
    map.put('\u1F3B', "GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA");
    map.put('\u1F3C', "GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA");
    map.put('\u1F3D', "GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA");
    map.put('\u1F3E', "GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI");
    map.put('\u1F3F', "GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI");
    map.put('\u1F40', "GREEK SMALL LETTER OMICRON WITH PSILI");
    map.put('\u1F41', "GREEK SMALL LETTER OMICRON WITH DASIA");
    map.put('\u1F42', "GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA");
    map.put('\u1F43', "GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA");
    map.put('\u1F44', "GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA");
    map.put('\u1F45', "GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA");
    map.put('\u1F48', "GREEK CAPITAL LETTER OMICRON WITH PSILI");
    map.put('\u1F49', "GREEK CAPITAL LETTER OMICRON WITH DASIA");
    map.put('\u1F4A', "GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA");
    map.put('\u1F4B', "GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA");
    map.put('\u1F4C', "GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA");
    map.put('\u1F4D', "GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA");
    map.put('\u1F50', "GREEK SMALL LETTER UPSILON WITH PSILI");
    map.put('\u1F51', "GREEK SMALL LETTER UPSILON WITH DASIA");
    map.put('\u1F52', "GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA");
    map.put('\u1F53', "GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA");
    map.put('\u1F54', "GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA");
    map.put('\u1F55', "GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA");
    map.put('\u1F56', "GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI");
    map.put('\u1F57', "GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI");
    map.put('\u1F59', "GREEK CAPITAL LETTER UPSILON WITH DASIA");
    map.put('\u1F5B', "GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA");
    map.put('\u1F5D', "GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA");
    map.put('\u1F5F', "GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI");
    map.put('\u1F60', "GREEK SMALL LETTER OMEGA WITH PSILI");
    map.put('\u1F61', "GREEK SMALL LETTER OMEGA WITH DASIA");
    map.put('\u1F62', "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA");
    map.put('\u1F63', "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA");
    map.put('\u1F64', "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA");
    map.put('\u1F65', "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA");
    map.put('\u1F66', "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI");
    map.put('\u1F67', "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI");
    map.put('\u1F68', "GREEK CAPITAL LETTER OMEGA WITH PSILI");
    map.put('\u1F69', "GREEK CAPITAL LETTER OMEGA WITH DASIA");
    map.put('\u1F6A', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA");
    map.put('\u1F6B', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA");
    map.put('\u1F6C', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA");
    map.put('\u1F6D', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA");
    map.put('\u1F6E', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI");
    map.put('\u1F6F', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI");
    map.put('\u1F70', "GREEK SMALL LETTER ALPHA WITH VARIA");
    map.put('\u1F71', "GREEK SMALL LETTER ALPHA WITH OXIA");
    map.put('\u1F72', "GREEK SMALL LETTER EPSILON WITH VARIA");
    map.put('\u1F73', "GREEK SMALL LETTER EPSILON WITH OXIA");
    map.put('\u1F74', "GREEK SMALL LETTER ETA WITH VARIA");
    map.put('\u1F75', "GREEK SMALL LETTER ETA WITH OXIA");
    map.put('\u1F76', "GREEK SMALL LETTER IOTA WITH VARIA");
    map.put('\u1F77', "GREEK SMALL LETTER IOTA WITH OXIA");
    map.put('\u1F78', "GREEK SMALL LETTER OMICRON WITH VARIA");
    map.put('\u1F79', "GREEK SMALL LETTER OMICRON WITH OXIA");
    map.put('\u1F7A', "GREEK SMALL LETTER UPSILON WITH VARIA");
    map.put('\u1F7B', "GREEK SMALL LETTER UPSILON WITH OXIA");
    map.put('\u1F7C', "GREEK SMALL LETTER OMEGA WITH VARIA");
    map.put('\u1F7D', "GREEK SMALL LETTER OMEGA WITH OXIA");
    map.put('\u1F80', "GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI");
    map.put('\u1F81', "GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI");
    map.put('\u1F82', "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI");
    map.put('\u1F83', "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI");
    map.put('\u1F84', "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI");
    map.put('\u1F85', "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI");
    map.put('\u1F86', "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1F87', "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1F88', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI");
    map.put('\u1F89', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI");
    map.put('\u1F8A', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI");
    map.put('\u1F8B', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI");
    map.put('\u1F8C', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI");
    map.put('\u1F8D', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI");
    map.put('\u1F8E', "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI");
    map.put('\u1F8F', "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI");
    map.put('\u1F90', "GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI");
    map.put('\u1F91', "GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI");
    map.put('\u1F92', "GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI");
    map.put('\u1F93', "GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI");
    map.put('\u1F94', "GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI");
    map.put('\u1F95', "GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI");
    map.put('\u1F96', "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1F97', "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1F98', "GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI");
    map.put('\u1F99', "GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI");
    map.put('\u1F9A', "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI");
    map.put('\u1F9B', "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI");
    map.put('\u1F9C', "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI");
    map.put('\u1F9D', "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI");
    map.put('\u1F9E', "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI");
    map.put('\u1F9F', "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI");
    map.put('\u1FA0', "GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI");
    map.put('\u1FA1', "GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI");
    map.put('\u1FA2', "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI");
    map.put('\u1FA3', "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI");
    map.put('\u1FA4', "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI");
    map.put('\u1FA5', "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI");
    map.put('\u1FA6', "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1FA7', "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1FA8', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI");
    map.put('\u1FA9', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI");
    map.put('\u1FAA', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI");
    map.put('\u1FAB', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI");
    map.put('\u1FAC', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI");
    map.put('\u1FAD', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI");
    map.put('\u1FAE', "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI");
    map.put('\u1FAF', "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI");
    map.put('\u1FB0', "GREEK SMALL LETTER ALPHA WITH VRACHY");
    map.put('\u1FB1', "GREEK SMALL LETTER ALPHA WITH MACRON");
    map.put('\u1FB2', "GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI");
    map.put('\u1FB3', "GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI");
    map.put('\u1FB4', "GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI");
    map.put('\u1FB6', "GREEK SMALL LETTER ALPHA WITH PERISPOMENI");
    map.put('\u1FB7', "GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1FB8', "GREEK CAPITAL LETTER ALPHA WITH VRACHY");
    map.put('\u1FB9', "GREEK CAPITAL LETTER ALPHA WITH MACRON");
    map.put('\u1FBA', "GREEK CAPITAL LETTER ALPHA WITH VARIA");
    map.put('\u1FBB', "GREEK CAPITAL LETTER ALPHA WITH OXIA");
    map.put('\u1FBC', "GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI");
    map.put('\u1FBD', "GREEK KORONIS");
    map.put('\u1FBE', "GREEK PROSGEGRAMMENI");
    map.put('\u1FBF', "GREEK PSILI");
    map.put('\u1FC0', "GREEK PERISPOMENI");
    map.put('\u1FC1', "GREEK DIALYTIKA AND PERISPOMENI");
    map.put('\u1FC2', "GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI");
    map.put('\u1FC3', "GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI");
    map.put('\u1FC4', "GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI");
    map.put('\u1FC6', "GREEK SMALL LETTER ETA WITH PERISPOMENI");
    map.put('\u1FC7', "GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1FC8', "GREEK CAPITAL LETTER EPSILON WITH VARIA");
    map.put('\u1FC9', "GREEK CAPITAL LETTER EPSILON WITH OXIA");
    map.put('\u1FCA', "GREEK CAPITAL LETTER ETA WITH VARIA");
    map.put('\u1FCB', "GREEK CAPITAL LETTER ETA WITH OXIA");
    map.put('\u1FCC', "GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI");
    map.put('\u1FCD', "GREEK PSILI AND VARIA");
    map.put('\u1FCE', "GREEK PSILI AND OXIA");
    map.put('\u1FCF', "GREEK PSILI AND PERISPOMENI");
    map.put('\u1FD0', "GREEK SMALL LETTER IOTA WITH VRACHY");
    map.put('\u1FD1', "GREEK SMALL LETTER IOTA WITH MACRON");
    map.put('\u1FD2', "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA");
    map.put('\u1FD3', "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA");
    map.put('\u1FD6', "GREEK SMALL LETTER IOTA WITH PERISPOMENI");
    map.put('\u1FD7', "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI");
    map.put('\u1FD8', "GREEK CAPITAL LETTER IOTA WITH VRACHY");
    map.put('\u1FD9', "GREEK CAPITAL LETTER IOTA WITH MACRON");
    map.put('\u1FDA', "GREEK CAPITAL LETTER IOTA WITH VARIA");
    map.put('\u1FDB', "GREEK CAPITAL LETTER IOTA WITH OXIA");
    map.put('\u1FDD', "GREEK DASIA AND VARIA");
    map.put('\u1FDE', "GREEK DASIA AND OXIA");
    map.put('\u1FDF', "GREEK DASIA AND PERISPOMENI");
    map.put('\u1FE0', "GREEK SMALL LETTER UPSILON WITH VRACHY");
    map.put('\u1FE1', "GREEK SMALL LETTER UPSILON WITH MACRON");
    map.put('\u1FE2', "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA");
    map.put('\u1FE3', "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA");
    map.put('\u1FE4', "GREEK SMALL LETTER RHO WITH PSILI");
    map.put('\u1FE5', "GREEK SMALL LETTER RHO WITH DASIA");
    map.put('\u1FE6', "GREEK SMALL LETTER UPSILON WITH PERISPOMENI");
    map.put('\u1FE7', "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI");
    map.put('\u1FE8', "GREEK CAPITAL LETTER UPSILON WITH VRACHY");
    map.put('\u1FE9', "GREEK CAPITAL LETTER UPSILON WITH MACRON");
    map.put('\u1FEA', "GREEK CAPITAL LETTER UPSILON WITH VARIA");
    map.put('\u1FEB', "GREEK CAPITAL LETTER UPSILON WITH OXIA");
    map.put('\u1FEC', "GREEK CAPITAL LETTER RHO WITH DASIA");
    map.put('\u1FED', "GREEK DIALYTIKA AND VARIA");
    map.put('\u1FEE', "GREEK DIALYTIKA AND OXIA");
    map.put('\u1FEF', "GREEK VARIA");
    map.put('\u1FF2', "GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI");
    map.put('\u1FF3', "GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI");
    map.put('\u1FF4', "GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI");
    map.put('\u1FF6', "GREEK SMALL LETTER OMEGA WITH PERISPOMENI");
    map.put('\u1FF7', "GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI");
    map.put('\u1FF8', "GREEK CAPITAL LETTER OMICRON WITH VARIA");
    map.put('\u1FF9', "GREEK CAPITAL LETTER OMICRON WITH OXIA");
    map.put('\u1FFA', "GREEK CAPITAL LETTER OMEGA WITH VARIA");
    map.put('\u1FFB', "GREEK CAPITAL LETTER OMEGA WITH OXIA");
    map.put('\u1FFC', "GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI");
    map.put('\u1FFD', "GREEK OXIA");
    map.put('\u1FFE', "GREEK DASIA");

  }

  public static final void generalPunctuation(Map<Character, String> map) {

    map.put('\u2000', "EN QUAD");
    map.put('\u2001', "EM QUAD");
    map.put('\u2002', "EN SPACE");
    map.put('\u2003', "EM SPACE");
    map.put('\u2004', "THREE-PER-EM SPACE");
    map.put('\u2005', "FOUR-PER-EM SPACE");
    map.put('\u2006', "SIX-PER-EM SPACE");
    map.put('\u2007', "FIGURE SPACE");
    map.put('\u2008', "PUNCTUATION SPACE");
    map.put('\u2009', "THIN SPACE");
    map.put('\u200A', "HAIR SPACE");
    map.put('\u200B', "ZERO WIDTH SPACE");
    map.put('\u200C', "ZERO WIDTH NON-JOINER");
    map.put('\u200D', "ZERO WIDTH JOINER");
    map.put('\u200E', "LEFT-TO-RIGHT MARK");
    map.put('\u200F', "RIGHT-TO-LEFT MARK");
    map.put('\u2010', "HYPHEN");
    map.put('\u2011', "NON-BREAKING HYPHEN");
    map.put('\u2012', "FIGURE DASH");
    map.put('\u2013', "EN DASH");
    map.put('\u2014', "EM DASH");
    map.put('\u2015', "HORIZONTAL BAR");
    map.put('\u2016', "DOUBLE VERTICAL LINE");
    map.put('\u2017', "DOUBLE LOW LINE");
    map.put('\u2018', "LEFT SINGLE QUOTATION MARK");
    map.put('\u2019', "RIGHT SINGLE QUOTATION MARK");
    map.put('\u201A', "SINGLE LOW-9 QUOTATION MARK");
    map.put('\u201B', "SINGLE HIGH-REVERSED-9 QUOTATION MARK");
    map.put('\u201C', "LEFT DOUBLE QUOTATION MARK");
    map.put('\u201D', "RIGHT DOUBLE QUOTATION MARK");
    map.put('\u201E', "DOUBLE LOW-9 QUOTATION MARK");
    map.put('\u201F', "DOUBLE HIGH-REVERSED-9 QUOTATION MARK");
    map.put('\u2020', "DAGGER");
    map.put('\u2021', "DOUBLE DAGGER");
    map.put('\u2022', "BULLET");
    map.put('\u2023', "TRIANGULAR BULLET");
    map.put('\u2024', "ONE DOT LEADER");
    map.put('\u2025', "TWO DOT LEADER");
    map.put('\u2026', "HORIZONTAL ELLIPSIS");
    map.put('\u2027', "HYPHENATION POINT");
    map.put('\u2028', "LINE SEPARATOR");
    map.put('\u2029', "PARAGRAPH SEPARATOR");
    map.put('\u202A', "LEFT-TO-RIGHT EMBEDDING");
    map.put('\u202B', "RIGHT-TO-LEFT EMBEDDING");
    map.put('\u202C', "POP DIRECTIONAL FORMATTING");
    map.put('\u202D', "LEFT-TO-RIGHT OVERRIDE");
    map.put('\u202E', "RIGHT-TO-LEFT OVERRIDE");
    map.put('\u202F', "NARROW NO-BREAK SPACE");
    map.put('\u2030', "PER MILLE SIGN");
    map.put('\u2031', "PER TEN THOUSAND SIGN");
    map.put('\u2032', "PRIME");
    map.put('\u2033', "DOUBLE PRIME");
    map.put('\u2034', "TRIPLE PRIME");
    map.put('\u2035', "REVERSED PRIME");
    map.put('\u2036', "REVERSED DOUBLE PRIME");
    map.put('\u2037', "REVERSED TRIPLE PRIME");
    map.put('\u2038', "CARET");
    map.put('\u2039', "SINGLE LEFT-POINTING ANGLE QUOTATION MARK");
    map.put('\u203A', "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK");
    map.put('\u203B', "REFERENCE MARK");
    map.put('\u203C', "DOUBLE EXCLAMATION MARK");
    map.put('\u203D', "INTERROBANG");
    map.put('\u203E', "OVERLINE");
    map.put('\u203F', "UNDERTIE");
    map.put('\u2040', "CHARACTER TIE");
    map.put('\u2041', "CARET INSERTION POINT");
    map.put('\u2042', "ASTERISM");
    map.put('\u2043', "HYPHEN BULLET");
    map.put('\u2044', "FRACTION SLASH");
    map.put('\u2045', "LEFT SQUARE BRACKET WITH QUILL");
    map.put('\u2046', "RIGHT SQUARE BRACKET WITH QUILL");
    map.put('\u2047', "DOUBLE QUESTION MARK");
    map.put('\u2048', "QUESTION EXCLAMATION MARK");
    map.put('\u2049', "EXCLAMATION QUESTION MARK");
    map.put('\u204A', "TIRONIAN SIGN ET");
    map.put('\u204B', "REVERSED PILCROW SIGN");
    map.put('\u204C', "BLACK LEFTWARDS BULLET");
    map.put('\u204D', "BLACK RIGHTWARDS BULLET");
    map.put('\u204E', "LOW ASTERISK");
    map.put('\u204F', "REVERSED SEMICOLON");
    map.put('\u2050', "CLOSE UP");
    map.put('\u2051', "TWO ASTERISKS ALIGNED VERTICALLY");
    map.put('\u2052', "COMMERCIAL MINUS SIGN");
    map.put('\u2053', "SWUNG DASH");
    map.put('\u2054', "INVERTED UNDERTIE");
    map.put('\u2055', "FLOWER PUNCTUATION MARK");
    map.put('\u2056', "THREE DOT PUNCTUATION");
    map.put('\u2057', "QUADRUPLE PRIME");
    map.put('\u2058', "FOUR DOT PUNCTUATION");
    map.put('\u2059', "FIVE DOT PUNCTUATION");
    map.put('\u205A', "TWO DOT PUNCTUATION");
    map.put('\u205B', "FOUR DOT MARK");
    map.put('\u205C', "DOTTED CROSS");
    map.put('\u205D', "TRICOLON");
    map.put('\u205E', "VERTICAL FOUR DOTS");
    map.put('\u205F', "MEDIUM MATHEMATICAL SPACE");
    map.put('\u2060', "WORD JOINER");
    map.put('\u2061', "FUNCTION APPLICATION");
    map.put('\u2062', "INVISIBLE TIMES");
    map.put('\u2063', "INVISIBLE SEPARATOR");
    map.put('\u2064', "INVISIBLE PLUS");
    map.put('\u206A', "INHIBIT SYMMETRIC SWAPPING");
    map.put('\u206B', "ACTIVATE SYMMETRIC SWAPPING");
    map.put('\u206C', "INHIBIT ARABIC FORM SHAPING");
    map.put('\u206D', "ACTIVATE ARABIC FORM SHAPING");
    map.put('\u206E', "NATIONAL DIGIT SHAPES");
    map.put('\u206F', "NOMINAL DIGIT SHAPES");
    map.put('\u2070', "SUPERSCRIPT ZERO");
    map.put('\u2071', "SUPERSCRIPT LATIN SMALL LETTER I");
    map.put('\u2072', "<reserved>");
    map.put('\u2073', "<reserved>");
    map.put('\u2074', "SUPERSCRIPT FOUR");
    map.put('\u2075', "SUPERSCRIPT FIVE");
    map.put('\u2076', "SUPERSCRIPT SIX");
    map.put('\u2077', "SUPERSCRIPT SEVEN");
    map.put('\u2078', "SUPERSCRIPT EIGHT");
    map.put('\u2079', "SUPERSCRIPT NINE");
    map.put('\u207A', "SUPERSCRIPT PLUS SIGN");
    map.put('\u207B', "SUPERSCRIPT MINUS");
    map.put('\u207C', "SUPERSCRIPT EQUALS SIGN");
    map.put('\u207D', "SUPERSCRIPT LEFT PARENTHESIS");
    map.put('\u207E', "SUPERSCRIPT RIGHT PARENTHESIS");
    map.put('\u207F', "SUPERSCRIPT LATIN SMALL LETTER N");
    map.put('\u2080', "SUBSCRIPT ZERO");
    map.put('\u2081', "SUBSCRIPT ONE");
    map.put('\u2082', "SUBSCRIPT TWO");
    map.put('\u2083', "SUBSCRIPT THREE");
    map.put('\u2084', "SUBSCRIPT FOUR");
    map.put('\u2085', "SUBSCRIPT FIVE");
    map.put('\u2086', "SUBSCRIPT SIX");
    map.put('\u2087', "SUBSCRIPT SEVEN");
    map.put('\u2088', "SUBSCRIPT EIGHT");
    map.put('\u2089', "SUBSCRIPT NINE");
    map.put('\u208A', "SUBSCRIPT PLUS SIGN");
    map.put('\u208B', "SUBSCRIPT MINUS");
    map.put('\u208C', "SUBSCRIPT EQUALS SIGN");
    map.put('\u208D', "SUBSCRIPT LEFT PARENTHESIS");
    map.put('\u208E', "SUBSCRIPT RIGHT PARENTHESIS");
    map.put('\u2090', "LATIN SUBSCRIPT SMALL LETTER A");
    map.put('\u2091', "LATIN SUBSCRIPT SMALL LETTER E");
    map.put('\u2092', "LATIN SUBSCRIPT SMALL LETTER O");
    map.put('\u2093', "LATIN SUBSCRIPT SMALL LETTER X");
    map.put('\u2094', "LATIN SUBSCRIPT SMALL LETTER SCHWA");
    map.put('\u20A0', "EURO-CURRENCY SIGN");
    map.put('\u20A1', "COLON SIGN");
    map.put('\u20A2', "CRUZEIRO SIGN");
    map.put('\u20A3', "FRENCH FRANC SIGN");
    map.put('\u20A4', "LIRA SIGN");
    map.put('\u20A5', "MILL SIGN");
    map.put('\u20A6', "NAIRA SIGN");
    map.put('\u20A7', "PESETA SIGN");
    map.put('\u20A8', "RUPEE SIGN");
    map.put('\u20A9', "WON SIGN");
    map.put('\u20AA', "NEW SHEQEL SIGN");
    map.put('\u20AB', "DONG SIGN");
    map.put('\u20AC', "EURO SIGN");
    map.put('\u20AD', "KIP SIGN");
    map.put('\u20AE', "TUGRIK SIGN");
    map.put('\u20AF', "DRACHMA SIGN");
    map.put('\u20B0', "GERMAN PENNY SIGN");
    map.put('\u20B1', "PESO SIGN");
    map.put('\u20B2', "GUARANI SIGN");
    map.put('\u20B3', "AUSTRAL SIGN");
    map.put('\u20B4', "HRYVNIA SIGN");
    map.put('\u20B5', "CEDI SIGN");
    map.put('\u20B6', "LIVRE TOURNOIS SIGN");
    map.put('\u20B7', "SPESMILO SIGN");
    map.put('\u20B8', "TENGE SIGN");
    map.put('\u20D0', "COMBINING LEFT HARPOON ABOVE");
    map.put('\u20D1', "COMBINING RIGHT HARPOON ABOVE");
    map.put('\u20D2', "COMBINING LONG VERTICAL LINE OVERLAY");
    map.put('\u20D3', "COMBINING SHORT VERTICAL LINE OVERLAY");
    map.put('\u20D4', "COMBINING ANTICLOCKWISE ARROW ABOVE");
    map.put('\u20D5', "COMBINING CLOCKWISE ARROW ABOVE");
    map.put('\u20D6', "COMBINING LEFT ARROW ABOVE");
    map.put('\u20D7', "COMBINING RIGHT ARROW ABOVE");
    map.put('\u20D8', "COMBINING RING OVERLAY");
    map.put('\u20D9', "COMBINING CLOCKWISE RING OVERLAY");
    map.put('\u20DA', "COMBINING ANTICLOCKWISE RING OVERLAY");
    map.put('\u20DB', "COMBINING THREE DOTS ABOVE");
    map.put('\u20DC', "COMBINING FOUR DOTS ABOVE");
    map.put('\u20DD', "COMBINING ENCLOSING CIRCLE");
    map.put('\u20DE', "COMBINING ENCLOSING SQUARE");
    map.put('\u20DF', "COMBINING ENCLOSING DIAMOND");
    map.put('\u20E0', "COMBINING ENCLOSING CIRCLE BACKSLASH");
    map.put('\u20E1', "COMBINING LEFT RIGHT ARROW ABOVE");
    map.put('\u20E2', "COMBINING ENCLOSING SCREEN");
    map.put('\u20E3', "COMBINING ENCLOSING KEYCAP");
    map.put('\u20E4', "COMBINING ENCLOSING UPWARD POINTING TRIANGLE");
    map.put('\u20E5', "COMBINING REVERSE SOLIDUS OVERLAY");
    map.put('\u20E6', "COMBINING DOUBLE VERTICAL STROKE OVERLAY");
    map.put('\u20E7', "COMBINING ANNUITY SYMBOL");
    map.put('\u20E8', "COMBINING TRIPLE UNDERDOT");
    map.put('\u20E9', "COMBINING WIDE BRIDGE ABOVE");
    map.put('\u20EA', "COMBINING LEFTWARDS ARROW OVERLAY");
    map.put('\u20EB', "COMBINING LONG DOUBLE SOLIDUS OVERLAY");
    map.put('\u20EC', "COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS");
    map.put('\u20ED', "COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS");
    map.put('\u20EE', "COMBINING LEFT ARROW BELOW");
    map.put('\u20EF', "COMBINING RIGHT ARROW BELOW");
    map.put('\u20F0', "COMBINING ASTERISK ABOVE");
    map.put('\u2100', "ACCOUNT OF");
    map.put('\u2101', "ADDRESSED TO THE SUBJECT");
    map.put('\u2102', "DOUBLE-STRUCK CAPITAL C");
    map.put('\u2103', "DEGREE CELSIUS");
    map.put('\u2104', "CENTRE LINE SYMBOL");
    map.put('\u2105', "CARE OF");
    map.put('\u2106', "CADA UNA");
    map.put('\u2107', "EULER CONSTANT");
    map.put('\u2108', "SCRUPLE");
    map.put('\u2109', "DEGREE FAHRENHEIT");
    map.put('\u210A', "SCRIPT SMALL G");
    map.put('\u210B', "SCRIPT CAPITAL H");
    map.put('\u210C', "BLACK-LETTER CAPITAL H");
    map.put('\u210D', "DOUBLE-STRUCK CAPITAL H");
    map.put('\u210E', "PLANCK CONSTANT");
    map.put('\u210F', "PLANCK CONSTANT OVER TWO PI");
    map.put('\u2110', "SCRIPT CAPITAL I");
    map.put('\u2111', "BLACK-LETTER CAPITAL I");
    map.put('\u2112', "SCRIPT CAPITAL L");
    map.put('\u2113', "SCRIPT SMALL L");
    map.put('\u2114', "L B BAR SYMBOL");
    map.put('\u2115', "DOUBLE-STRUCK CAPITAL N");
    map.put('\u2116', "NUMERO SIGN");
    map.put('\u2117', "SOUND RECORDING COPYRIGHT");
    map.put('\u2118', "SCRIPT CAPITAL P");
    map.put('\u2119', "DOUBLE-STRUCK CAPITAL P");
    map.put('\u211A', "DOUBLE-STRUCK CAPITAL Q");
    map.put('\u211B', "SCRIPT CAPITAL R");
    map.put('\u211C', "BLACK-LETTER CAPITAL R");
    map.put('\u211D', "DOUBLE-STRUCK CAPITAL R");
    map.put('\u211E', "PRESCRIPTION TAKE");
    map.put('\u211F', "RESPONSE");
    map.put('\u2120', "SERVICE MARK");
    map.put('\u2121', "TELEPHONE SIGN");
    map.put('\u2122', "TRADE MARK SIGN");
    map.put('\u2123', "VERSICLE");
    map.put('\u2124', "DOUBLE-STRUCK CAPITAL Z");
    map.put('\u2125', "OUNCE SIGN");
    map.put('\u2126', "OHM SIGN");
    map.put('\u2127', "INVERTED OHM SIGN");
    map.put('\u2128', "BLACK-LETTER CAPITAL Z");
    map.put('\u2129', "TURNED GREEK SMALL LETTER IOTA");
    map.put('\u212A', "KELVIN SIGN");
    map.put('\u212B', "ANGSTROM SIGN");
    map.put('\u212C', "SCRIPT CAPITAL B");
    map.put('\u212D', "BLACK-LETTER CAPITAL C");
    map.put('\u212E', "ESTIMATED SYMBOL");
    map.put('\u212F', "SCRIPT SMALL E");
    map.put('\u2130', "SCRIPT CAPITAL E");
    map.put('\u2131', "SCRIPT CAPITAL F");
    map.put('\u2132', "TURNED CAPITAL F");
    map.put('\u2133', "SCRIPT CAPITAL M");
    map.put('\u2134', "SCRIPT SMALL O");
    map.put('\u2135', "ALEF SYMBOL");
    map.put('\u2136', "BET SYMBOL");
    map.put('\u2137', "GIMEL SYMBOL");
    map.put('\u2138', "DALET SYMBOL");
    map.put('\u2139', "INFORMATION SOURCE");
    map.put('\u213A', "ROTATED CAPITAL Q");
    map.put('\u213B', "FACSIMILE SIGN");
    map.put('\u213C', "DOUBLE-STRUCK SMALL PI");
    map.put('\u213D', "DOUBLE-STRUCK SMALL GAMMA");
    map.put('\u213E', "DOUBLE-STRUCK CAPITAL GAMMA");
    map.put('\u213F', "DOUBLE-STRUCK CAPITAL PI");
    map.put('\u2140', "DOUBLE-STRUCK N-ARY SUMMATION");
    map.put('\u2141', "TURNED SANS-SERIF CAPITAL G");
    map.put('\u2142', "TURNED SANS-SERIF CAPITAL L");
    map.put('\u2143', "REVERSED SANS-SERIF CAPITAL L");
    map.put('\u2144', "TURNED SANS-SERIF CAPITAL Y");
    map.put('\u2145', "DOUBLE-STRUCK ITALIC CAPITAL D");
    map.put('\u2146', "DOUBLE-STRUCK ITALIC SMALL D");
    map.put('\u2147', "DOUBLE-STRUCK ITALIC SMALL E");
    map.put('\u2148', "DOUBLE-STRUCK ITALIC SMALL I");
    map.put('\u2149', "DOUBLE-STRUCK ITALIC SMALL J");
    map.put('\u214A', "PROPERTY LINE");
    map.put('\u214B', "TURNED AMPERSAND");
    map.put('\u214C', "PER SIGN");
    map.put('\u214D', "AKTIESELSKAB");
    map.put('\u214E', "TURNED SMALL F");
    map.put('\u214F', "SYMBOL FOR SAMARITAN SOURCE");
    map.put('\u2150', "VULGAR FRACTION ONE SEVENTH");
    map.put('\u2151', "VULGAR FRACTION ONE NINTH");
    map.put('\u2152', "VULGAR FRACTION ONE TENTH");
    map.put('\u2153', "VULGAR FRACTION ONE THIRD");
    map.put('\u2154', "VULGAR FRACTION TWO THIRDS");
    map.put('\u2155', "VULGAR FRACTION ONE FIFTH");
    map.put('\u2156', "VULGAR FRACTION TWO FIFTHS");
    map.put('\u2157', "VULGAR FRACTION THREE FIFTHS");
    map.put('\u2158', "VULGAR FRACTION FOUR FIFTHS");
    map.put('\u2159', "VULGAR FRACTION ONE SIXTH");
    map.put('\u215A', "VULGAR FRACTION FIVE SIXTHS");
    map.put('\u215B', "VULGAR FRACTION ONE EIGHTH");
    map.put('\u215C', "VULGAR FRACTION THREE EIGHTHS");
    map.put('\u215D', "VULGAR FRACTION FIVE EIGHTHS");
    map.put('\u215E', "VULGAR FRACTION SEVEN EIGHTHS");
    map.put('\u215F', "FRACTION NUMERATOR ONE");
    map.put('\u2160', "ROMAN NUMERAL ONE");
    map.put('\u2161', "ROMAN NUMERAL TWO");
    map.put('\u2162', "ROMAN NUMERAL THREE");
    map.put('\u2163', "ROMAN NUMERAL FOUR");
    map.put('\u2164', "ROMAN NUMERAL FIVE");
    map.put('\u2165', "ROMAN NUMERAL SIX");
    map.put('\u2166', "ROMAN NUMERAL SEVEN");
    map.put('\u2167', "ROMAN NUMERAL EIGHT");
    map.put('\u2168', "ROMAN NUMERAL NINE");
    map.put('\u2169', "ROMAN NUMERAL TEN");
    map.put('\u216A', "ROMAN NUMERAL ELEVEN");
    map.put('\u216B', "ROMAN NUMERAL TWELVE");
    map.put('\u216C', "ROMAN NUMERAL FIFTY");
    map.put('\u216D', "ROMAN NUMERAL ONE HUNDRED");
    map.put('\u216E', "ROMAN NUMERAL FIVE HUNDRED");
    map.put('\u216F', "ROMAN NUMERAL ONE THOUSAND");
    map.put('\u2170', "SMALL ROMAN NUMERAL ONE");
    map.put('\u2171', "SMALL ROMAN NUMERAL TWO");
    map.put('\u2172', "SMALL ROMAN NUMERAL THREE");
    map.put('\u2173', "SMALL ROMAN NUMERAL FOUR");
    map.put('\u2174', "SMALL ROMAN NUMERAL FIVE");
    map.put('\u2175', "SMALL ROMAN NUMERAL SIX");
    map.put('\u2176', "SMALL ROMAN NUMERAL SEVEN");
    map.put('\u2177', "SMALL ROMAN NUMERAL EIGHT");
    map.put('\u2178', "SMALL ROMAN NUMERAL NINE");
    map.put('\u2179', "SMALL ROMAN NUMERAL TEN");
    map.put('\u217A', "SMALL ROMAN NUMERAL ELEVEN");
    map.put('\u217B', "SMALL ROMAN NUMERAL TWELVE");
    map.put('\u217C', "SMALL ROMAN NUMERAL FIFTY");
    map.put('\u217D', "SMALL ROMAN NUMERAL ONE HUNDRED");
    map.put('\u217E', "SMALL ROMAN NUMERAL FIVE HUNDRED");
    map.put('\u217F', "SMALL ROMAN NUMERAL ONE THOUSAND");
    map.put('\u2180', "ROMAN NUMERAL ONE THOUSAND C D");
    map.put('\u2181', "ROMAN NUMERAL FIVE THOUSAND");
    map.put('\u2182', "ROMAN NUMERAL TEN THOUSAND");
    map.put('\u2183', "ROMAN NUMERAL REVERSED ONE HUNDRED");
    map.put('\u2184', "LATIN SMALL LETTER REVERSED C");
    map.put('\u2185', "ROMAN NUMERAL SIX LATE FORM");
    map.put('\u2186', "ROMAN NUMERAL FIFTY EARLY FORM");
    map.put('\u2187', "ROMAN NUMERAL FIFTY THOUSAND");
    map.put('\u2188', "ROMAN NUMERAL ONE HUNDRED THOUSAND");
    map.put('\u2189', "VULGAR FRACTION ZERO THIRDS");
    map.put('\u2190', "LEFTWARDS ARROW");
    map.put('\u2191', "UPWARDS ARROW");
    map.put('\u2192', "RIGHTWARDS ARROW");
    map.put('\u2193', "DOWNWARDS ARROW");
    map.put('\u2194', "LEFT RIGHT ARROW");
    map.put('\u2195', "UP DOWN ARROW");
    map.put('\u2196', "NORTH WEST ARROW");
    map.put('\u2197', "NORTH EAST ARROW");
    map.put('\u2198', "SOUTH EAST ARROW");
    map.put('\u2199', "SOUTH WEST ARROW");
    map.put('\u219A', "LEFTWARDS ARROW WITH STROKE");
    map.put('\u219B', "RIGHTWARDS ARROW WITH STROKE");
    map.put('\u219C', "LEFTWARDS WAVE ARROW");
    map.put('\u219D', "RIGHTWARDS WAVE ARROW");
    map.put('\u219E', "LEFTWARDS TWO HEADED ARROW");
    map.put('\u219F', "UPWARDS TWO HEADED ARROW");
    map.put('\u21A0', "RIGHTWARDS TWO HEADED ARROW");
    map.put('\u21A1', "DOWNWARDS TWO HEADED ARROW");
    map.put('\u21A2', "LEFTWARDS ARROW WITH TAIL");
    map.put('\u21A3', "RIGHTWARDS ARROW WITH TAIL");
    map.put('\u21A4', "LEFTWARDS ARROW FROM BAR");
    map.put('\u21A5', "UPWARDS ARROW FROM BAR");
    map.put('\u21A6', "RIGHTWARDS ARROW FROM BAR");
    map.put('\u21A7', "DOWNWARDS ARROW FROM BAR");
    map.put('\u21A8', "UP DOWN ARROW WITH BASE");
    map.put('\u21A9', "LEFTWARDS ARROW WITH HOOK");
    map.put('\u21AA', "RIGHTWARDS ARROW WITH HOOK");
    map.put('\u21AB', "LEFTWARDS ARROW WITH LOOP");
    map.put('\u21AC', "RIGHTWARDS ARROW WITH LOOP");
    map.put('\u21AD', "LEFT RIGHT WAVE ARROW");
    map.put('\u21AE', "LEFT RIGHT ARROW WITH STROKE");
    map.put('\u21AF', "DOWNWARDS ZIGZAG ARROW");
    map.put('\u21B0', "UPWARDS ARROW WITH TIP LEFTWARDS");
    map.put('\u21B1', "UPWARDS ARROW WITH TIP RIGHTWARDS");
    map.put('\u21B2', "DOWNWARDS ARROW WITH TIP LEFTWARDS");
    map.put('\u21B3', "DOWNWARDS ARROW WITH TIP RIGHTWARDS");
    map.put('\u21B4', "RIGHTWARDS ARROW WITH CORNER DOWNWARDS");
    map.put('\u21B5', "DOWNWARDS ARROW WITH CORNER LEFTWARDS");
    map.put('\u21B6', "ANTICLOCKWISE TOP SEMICIRCLE ARROW");
    map.put('\u21B7', "CLOCKWISE TOP SEMICIRCLE ARROW");
    map.put('\u21B8', "NORTH WEST ARROW TO LONG BAR");
    map.put('\u21B9', "LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR");
    map.put('\u21BA', "ANTICLOCKWISE OPEN CIRCLE ARROW");
    map.put('\u21BB', "CLOCKWISE OPEN CIRCLE ARROW");
    map.put('\u21BC', "LEFTWARDS HARPOON WITH BARB UPWARDS");
    map.put('\u21BD', "LEFTWARDS HARPOON WITH BARB DOWNWARDS");
    map.put('\u21BE', "UPWARDS HARPOON WITH BARB RIGHTWARDS");
    map.put('\u21BF', "UPWARDS HARPOON WITH BARB LEFTWARDS");
    map.put('\u21C0', "RIGHTWARDS HARPOON WITH BARB UPWARDS");
    map.put('\u21C1', "RIGHTWARDS HARPOON WITH BARB DOWNWARDS");
    map.put('\u21C2', "DOWNWARDS HARPOON WITH BARB RIGHTWARDS");
    map.put('\u21C3', "DOWNWARDS HARPOON WITH BARB LEFTWARDS");
    map.put('\u21C4', "RIGHTWARDS ARROW OVER LEFTWARDS ARROW");
    map.put('\u21C5', "UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW");
    map.put('\u21C6', "LEFTWARDS ARROW OVER RIGHTWARDS ARROW");
    map.put('\u21C7', "LEFTWARDS PAIRED ARROWS");
    map.put('\u21C8', "UPWARDS PAIRED ARROWS");
    map.put('\u21C9', "RIGHTWARDS PAIRED ARROWS");
    map.put('\u21CA', "DOWNWARDS PAIRED ARROWS");
    map.put('\u21CB', "LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON");
    map.put('\u21CC', "RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON");
    map.put('\u21CD', "LEFTWARDS DOUBLE ARROW WITH STROKE");
    map.put('\u21CE', "LEFT RIGHT DOUBLE ARROW WITH STROKE");
    map.put('\u21CF', "RIGHTWARDS DOUBLE ARROW WITH STROKE");
    map.put('\u21D0', "LEFTWARDS DOUBLE ARROW");
    map.put('\u21D1', "UPWARDS DOUBLE ARROW");
    map.put('\u21D2', "RIGHTWARDS DOUBLE ARROW");
    map.put('\u21D3', "DOWNWARDS DOUBLE ARROW");
    map.put('\u21D4', "LEFT RIGHT DOUBLE ARROW");
    map.put('\u21D5', "UP DOWN DOUBLE ARROW");
    map.put('\u21D6', "NORTH WEST DOUBLE ARROW");
    map.put('\u21D7', "NORTH EAST DOUBLE ARROW");
    map.put('\u21D8', "SOUTH EAST DOUBLE ARROW");
    map.put('\u21D9', "SOUTH WEST DOUBLE ARROW");
    map.put('\u21DA', "LEFTWARDS TRIPLE ARROW");
    map.put('\u21DB', "RIGHTWARDS TRIPLE ARROW");
    map.put('\u21DC', "LEFTWARDS SQUIGGLE ARROW");
    map.put('\u21DD', "RIGHTWARDS SQUIGGLE ARROW");
    map.put('\u21DE', "UPWARDS ARROW WITH DOUBLE STROKE");
    map.put('\u21DF', "DOWNWARDS ARROW WITH DOUBLE STROKE");
    map.put('\u21E0', "LEFTWARDS DASHED ARROW");
    map.put('\u21E1', "UPWARDS DASHED ARROW");
    map.put('\u21E2', "RIGHTWARDS DASHED ARROW");
    map.put('\u21E3', "DOWNWARDS DASHED ARROW");
    map.put('\u21E4', "LEFTWARDS ARROW TO BAR");
    map.put('\u21E5', "RIGHTWARDS ARROW TO BAR");
    map.put('\u21E6', "LEFTWARDS WHITE ARROW");
    map.put('\u21E7', "UPWARDS WHITE ARROW");
    map.put('\u21E8', "RIGHTWARDS WHITE ARROW");
    map.put('\u21E9', "DOWNWARDS WHITE ARROW");
    map.put('\u21EA', "UPWARDS WHITE ARROW FROM BAR");
    map.put('\u21EB', "UPWARDS WHITE ARROW ON PEDESTAL");
    map.put('\u21EC', "UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR");
    map.put('\u21ED', "UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR");
    map.put('\u21EE', "UPWARDS WHITE DOUBLE ARROW");
    map.put('\u21EF', "UPWARDS WHITE DOUBLE ARROW ON PEDESTAL");
    map.put('\u21F0', "RIGHTWARDS WHITE ARROW FROM WALL");
    map.put('\u21F1', "NORTH WEST ARROW TO CORNER");
    map.put('\u21F2', "SOUTH EAST ARROW TO CORNER");
    map.put('\u21F3', "UP DOWN WHITE ARROW");
    map.put('\u21F4', "RIGHT ARROW WITH SMALL CIRCLE");
    map.put('\u21F5', "DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW");
    map.put('\u21F6', "THREE RIGHTWARDS ARROWS");
    map.put('\u21F7', "LEFTWARDS ARROW WITH VERTICAL STROKE");
    map.put('\u21F8', "RIGHTWARDS ARROW WITH VERTICAL STROKE");
    map.put('\u21F9', "LEFT RIGHT ARROW WITH VERTICAL STROKE");
    map.put('\u21FA', "LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE");
    map.put('\u21FB', "RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE");
    map.put('\u21FC', "LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE");
    map.put('\u21FD', "LEFTWARDS OPEN-HEADED ARROW");
    map.put('\u21FE', "RIGHTWARDS OPEN-HEADED ARROW");
    map.put('\u21FF', "LEFT RIGHT OPEN-HEADED ARROW");
    map.put('\u2200', "FOR ALL");
    map.put('\u2201', "COMPLEMENT");
    map.put('\u2202', "PARTIAL DIFFERENTIAL");
    map.put('\u2203', "THERE EXISTS");
    map.put('\u2204', "THERE DOES NOT EXIST");
    map.put('\u2205', "EMPTY SET");
    map.put('\u2206', "INCREMENT");
    map.put('\u2207', "NABLA");
    map.put('\u2208', "ELEMENT OF");
    map.put('\u2209', "NOT AN ELEMENT OF");
    map.put('\u220A', "SMALL ELEMENT OF");
    map.put('\u220B', "CONTAINS AS MEMBER");
    map.put('\u220C', "DOES NOT CONTAIN AS MEMBER");
    map.put('\u220D', "SMALL CONTAINS AS MEMBER");
    map.put('\u220E', "END OF PROOF");
    map.put('\u220F', "N-ARY PRODUCT");
    map.put('\u2210', "N-ARY COPRODUCT");
    map.put('\u2211', "N-ARY SUMMATION");
    map.put('\u2212', "MINUS SIGN");
    map.put('\u2213', "MINUS-OR-PLUS SIGN");
    map.put('\u2214', "DOT PLUS");
    map.put('\u2215', "DIVISION SLASH");
    map.put('\u2216', "SET MINUS");
    map.put('\u2217', "ASTERISK OPERATOR");
    map.put('\u2218', "RING OPERATOR");
    map.put('\u2219', "BULLET OPERATOR");
    map.put('\u221A', "SQUARE ROOT");
    map.put('\u221B', "CUBE ROOT");
    map.put('\u221C', "FOURTH ROOT");
    map.put('\u221D', "PROPORTIONAL TO");
    map.put('\u221E', "INFINITY");
    map.put('\u221F', "RIGHT ANGLE");
    map.put('\u2220', "ANGLE");
    map.put('\u2221', "MEASURED ANGLE");
    map.put('\u2222', "SPHERICAL ANGLE");
    map.put('\u2223', "DIVIDES");
    map.put('\u2224', "DOES NOT DIVIDE");
    map.put('\u2225', "PARALLEL TO");
    map.put('\u2226', "NOT PARALLEL TO");
    map.put('\u2227', "LOGICAL AND");
    map.put('\u2228', "LOGICAL OR");
    map.put('\u2229', "INTERSECTION");
    map.put('\u222A', "UNION");
    map.put('\u222B', "INTEGRAL");
    map.put('\u222C', "DOUBLE INTEGRAL");
    map.put('\u222D', "TRIPLE INTEGRAL");
    map.put('\u222E', "CONTOUR INTEGRAL");
    map.put('\u222F', "SURFACE INTEGRAL");
    map.put('\u2230', "VOLUME INTEGRAL");
    map.put('\u2231', "CLOCKWISE INTEGRAL");
    map.put('\u2232', "CLOCKWISE CONTOUR INTEGRAL");
    map.put('\u2233', "ANTICLOCKWISE CONTOUR INTEGRAL");
    map.put('\u2234', "THEREFORE");
    map.put('\u2235', "BECAUSE");
    map.put('\u2236', "RATIO");
    map.put('\u2237', "PROPORTION");
    map.put('\u2238', "DOT MINUS");
    map.put('\u2239', "EXCESS");
    map.put('\u223A', "GEOMETRIC PROPORTION");
    map.put('\u223B', "HOMOTHETIC");
    map.put('\u223C', "TILDE OPERATOR");
    map.put('\u223D', "REVERSED TILDE");
    map.put('\u223E', "INVERTED LAZY S");
    map.put('\u223F', "SINE WAVE");
    map.put('\u2240', "WREATH PRODUCT");
    map.put('\u2241', "NOT TILDE");
    map.put('\u2242', "MINUS TILDE");
    map.put('\u2243', "ASYMPTOTICALLY EQUAL TO");
    map.put('\u2244', "NOT ASYMPTOTICALLY EQUAL TO");
    map.put('\u2245', "APPROXIMATELY EQUAL TO");
    map.put('\u2246', "APPROXIMATELY BUT NOT ACTUALLY EQUAL TO");
    map.put('\u2247', "NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO");
    map.put('\u2248', "ALMOST EQUAL TO");
    map.put('\u2249', "NOT ALMOST EQUAL TO");
    map.put('\u224A', "ALMOST EQUAL OR EQUAL TO");
    map.put('\u224B', "TRIPLE TILDE");
    map.put('\u224C', "ALL EQUAL TO");
    map.put('\u224D', "EQUIVALENT TO");
    map.put('\u224E', "GEOMETRICALLY EQUIVALENT TO");
    map.put('\u224F', "DIFFERENCE BETWEEN");
    map.put('\u2250', "APPROACHES THE LIMIT");
    map.put('\u2251', "GEOMETRICALLY EQUAL TO");
    map.put('\u2252', "APPROXIMATELY EQUAL TO OR THE IMAGE OF");
    map.put('\u2253', "IMAGE OF OR APPROXIMATELY EQUAL TO");
    map.put('\u2254', "COLON EQUALS");
    map.put('\u2255', "EQUALS COLON");
    map.put('\u2256', "RING IN EQUAL TO");
    map.put('\u2257', "RING EQUAL TO");
    map.put('\u2258', "CORRESPONDS TO");
    map.put('\u2259', "ESTIMATES");
    map.put('\u225A', "EQUIANGULAR TO");
    map.put('\u225B', "STAR EQUALS");
    map.put('\u225C', "DELTA EQUAL TO");
    map.put('\u225D', "EQUAL TO BY DEFINITION");
    map.put('\u225E', "MEASURED BY");
    map.put('\u225F', "QUESTIONED EQUAL TO");
    map.put('\u2260', "NOT EQUAL TO");
    map.put('\u2261', "IDENTICAL TO");
    map.put('\u2262', "NOT IDENTICAL TO");
    map.put('\u2263', "STRICTLY EQUIVALENT TO");
    map.put('\u2264', "LESS-THAN OR EQUAL TO");
    map.put('\u2265', "GREATER-THAN OR EQUAL TO");
    map.put('\u2266', "LESS-THAN OVER EQUAL TO");
    map.put('\u2267', "GREATER-THAN OVER EQUAL TO");
    map.put('\u2268', "LESS-THAN BUT NOT EQUAL TO");
    map.put('\u2269', "GREATER-THAN BUT NOT EQUAL TO");
    map.put('\u226A', "MUCH LESS-THAN");
    map.put('\u226B', "MUCH GREATER-THAN");
    map.put('\u226C', "BETWEEN");
    map.put('\u226D', "NOT EQUIVALENT TO");
    map.put('\u226E', "NOT LESS-THAN");
    map.put('\u226F', "NOT GREATER-THAN");
    map.put('\u2270', "NEITHER LESS-THAN NOR EQUAL TO");
    map.put('\u2271', "NEITHER GREATER-THAN NOR EQUAL TO");
    map.put('\u2272', "LESS-THAN OR EQUIVALENT TO");
    map.put('\u2273', "GREATER-THAN OR EQUIVALENT TO");
    map.put('\u2274', "NEITHER LESS-THAN NOR EQUIVALENT TO");
    map.put('\u2275', "NEITHER GREATER-THAN NOR EQUIVALENT TO");
    map.put('\u2276', "LESS-THAN OR GREATER-THAN");
    map.put('\u2277', "GREATER-THAN OR LESS-THAN");
    map.put('\u2278', "NEITHER LESS-THAN NOR GREATER-THAN");
    map.put('\u2279', "NEITHER GREATER-THAN NOR LESS-THAN");
    map.put('\u227A', "PRECEDES");
    map.put('\u227B', "SUCCEEDS");
    map.put('\u227C', "PRECEDES OR EQUAL TO");
    map.put('\u227D', "SUCCEEDS OR EQUAL TO");
    map.put('\u227E', "PRECEDES OR EQUIVALENT TO");
    map.put('\u227F', "SUCCEEDS OR EQUIVALENT TO");
    map.put('\u2280', "DOES NOT PRECEDE");
    map.put('\u2281', "DOES NOT SUCCEED");
    map.put('\u2282', "SUBSET OF");
    map.put('\u2283', "SUPERSET OF");
    map.put('\u2284', "NOT A SUBSET OF");
    map.put('\u2285', "NOT A SUPERSET OF");
    map.put('\u2286', "SUBSET OF OR EQUAL TO");
    map.put('\u2287', "SUPERSET OF OR EQUAL TO");
    map.put('\u2288', "NEITHER A SUBSET OF NOR EQUAL TO");
    map.put('\u2289', "NEITHER A SUPERSET OF NOR EQUAL TO");
    map.put('\u228A', "SUBSET OF WITH NOT EQUAL TO");
    map.put('\u228B', "SUPERSET OF WITH NOT EQUAL TO");
    map.put('\u228C', "MULTISET");
    map.put('\u228D', "MULTISET MULTIPLICATION");
    map.put('\u228E', "MULTISET UNION");
    map.put('\u228F', "SQUARE IMAGE OF");
    map.put('\u2290', "SQUARE ORIGINAL OF");
    map.put('\u2291', "SQUARE IMAGE OF OR EQUAL TO");
    map.put('\u2292', "SQUARE ORIGINAL OF OR EQUAL TO");
    map.put('\u2293', "SQUARE CAP");
    map.put('\u2294', "SQUARE CUP");
    map.put('\u2295', "CIRCLED PLUS");
    map.put('\u2296', "CIRCLED MINUS");
    map.put('\u2297', "CIRCLED TIMES");
    map.put('\u2298', "CIRCLED DIVISION SLASH");
    map.put('\u2299', "CIRCLED DOT OPERATOR");
    map.put('\u229A', "CIRCLED RING OPERATOR");
    map.put('\u229B', "CIRCLED ASTERISK OPERATOR");
    map.put('\u229C', "CIRCLED EQUALS");
    map.put('\u229D', "CIRCLED DASH");
    map.put('\u229E', "SQUARED PLUS");
    map.put('\u229F', "SQUARED MINUS");
    map.put('\u22A0', "SQUARED TIMES");
    map.put('\u22A1', "SQUARED DOT OPERATOR");
    map.put('\u22A2', "RIGHT TACK");
    map.put('\u22A3', "LEFT TACK");
    map.put('\u22A4', "DOWN TACK");
    map.put('\u22A5', "UP TACK");
    map.put('\u22A6', "ASSERTION");
    map.put('\u22A7', "MODELS");
    map.put('\u22A8', "TRUE");
    map.put('\u22A9', "FORCES");
    map.put('\u22AA', "TRIPLE VERTICAL BAR RIGHT TURNSTILE");
    map.put('\u22AB', "DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE");
    map.put('\u22AC', "DOES NOT PROVE");
    map.put('\u22AD', "NOT TRUE");
    map.put('\u22AE', "DOES NOT FORCE");
    map.put('\u22AF', "NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE");
    map.put('\u22B0', "PRECEDES UNDER RELATION");
    map.put('\u22B1', "SUCCEEDS UNDER RELATION");
    map.put('\u22B2', "NORMAL SUBGROUP OF");
    map.put('\u22B3', "CONTAINS AS NORMAL SUBGROUP");
    map.put('\u22B4', "NORMAL SUBGROUP OF OR EQUAL TO");
    map.put('\u22B5', "CONTAINS AS NORMAL SUBGROUP OR EQUAL TO");
    map.put('\u22B6', "ORIGINAL OF");
    map.put('\u22B7', "IMAGE OF");
    map.put('\u22B8', "MULTIMAP");
    map.put('\u22B9', "HERMITIAN CONJUGATE MATRIX");
    map.put('\u22BA', "INTERCALATE");
    map.put('\u22BB', "XOR");
    map.put('\u22BC', "NAND");
    map.put('\u22BD', "NOR");
    map.put('\u22BE', "RIGHT ANGLE WITH ARC");
    map.put('\u22BF', "RIGHT TRIANGLE");
    map.put('\u22C0', "N-ARY LOGICAL AND");
    map.put('\u22C1', "N-ARY LOGICAL OR");
    map.put('\u22C2', "N-ARY INTERSECTION");
    map.put('\u22C3', "N-ARY UNION");
    map.put('\u22C4', "DIAMOND OPERATOR");
    map.put('\u22C5', "DOT OPERATOR");
    map.put('\u22C6', "STAR OPERATOR");
    map.put('\u22C7', "DIVISION TIMES");
    map.put('\u22C8', "BOWTIE");
    map.put('\u22C9', "LEFT NORMAL FACTOR SEMIDIRECT PRODUCT");
    map.put('\u22CA', "RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT");
    map.put('\u22CB', "LEFT SEMIDIRECT PRODUCT");
    map.put('\u22CC', "RIGHT SEMIDIRECT PRODUCT");
    map.put('\u22CD', "REVERSED TILDE EQUALS");
    map.put('\u22CE', "CURLY LOGICAL OR");
    map.put('\u22CF', "CURLY LOGICAL AND");
    map.put('\u22D0', "DOUBLE SUBSET");
    map.put('\u22D1', "DOUBLE SUPERSET");
    map.put('\u22D2', "DOUBLE INTERSECTION");
    map.put('\u22D3', "DOUBLE UNION");
    map.put('\u22D4', "PITCHFORK");
    map.put('\u22D5', "EQUAL AND PARALLEL TO");
    map.put('\u22D6', "LESS-THAN WITH DOT");
    map.put('\u22D7', "GREATER-THAN WITH DOT");
    map.put('\u22D8', "VERY MUCH LESS-THAN");
    map.put('\u22D9', "VERY MUCH GREATER-THAN");
    map.put('\u22DA', "LESS-THAN EQUAL TO OR GREATER-THAN");
    map.put('\u22DB', "GREATER-THAN EQUAL TO OR LESS-THAN");
    map.put('\u22DC', "EQUAL TO OR LESS-THAN");
    map.put('\u22DD', "EQUAL TO OR GREATER-THAN");
    map.put('\u22DE', "EQUAL TO OR PRECEDES");
    map.put('\u22DF', "EQUAL TO OR SUCCEEDS");
    map.put('\u22E0', "DOES NOT PRECEDE OR EQUAL");
    map.put('\u22E1', "DOES NOT SUCCEED OR EQUAL");
    map.put('\u22E2', "NOT SQUARE IMAGE OF OR EQUAL TO");
    map.put('\u22E3', "NOT SQUARE ORIGINAL OF OR EQUAL TO");
    map.put('\u22E4', "SQUARE IMAGE OF OR NOT EQUAL TO");
    map.put('\u22E5', "SQUARE ORIGINAL OF OR NOT EQUAL TO");
    map.put('\u22E6', "LESS-THAN BUT NOT EQUIVALENT TO");
    map.put('\u22E7', "GREATER-THAN BUT NOT EQUIVALENT TO");
    map.put('\u22E8', "PRECEDES BUT NOT EQUIVALENT TO");
    map.put('\u22E9', "SUCCEEDS BUT NOT EQUIVALENT TO");
    map.put('\u22EA', "NOT NORMAL SUBGROUP OF");
    map.put('\u22EB', "DOES NOT CONTAIN AS NORMAL SUBGROUP");
    map.put('\u22EC', "NOT NORMAL SUBGROUP OF OR EQUAL TO");
    map.put('\u22ED', "DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL");
    map.put('\u22EE', "VERTICAL ELLIPSIS");
    map.put('\u22EF', "MIDLINE HORIZONTAL ELLIPSIS");
    map.put('\u22F0', "UP RIGHT DIAGONAL ELLIPSIS");
    map.put('\u22F1', "DOWN RIGHT DIAGONAL ELLIPSIS");
    map.put('\u22F2', "ELEMENT OF WITH LONG HORIZONTAL STROKE");
    map.put('\u22F3', "ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE");
    map.put('\u22F4', "SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE");
    map.put('\u22F5', "ELEMENT OF WITH DOT ABOVE");
    map.put('\u22F6', "ELEMENT OF WITH OVERBAR");
    map.put('\u22F7', "SMALL ELEMENT OF WITH OVERBAR");
    map.put('\u22F8', "ELEMENT OF WITH UNDERBAR");
    map.put('\u22F9', "ELEMENT OF WITH TWO HORIZONTAL STROKES");
    map.put('\u22FA', "CONTAINS WITH LONG HORIZONTAL STROKE");
    map.put('\u22FB', "CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE");
    map.put('\u22FC', "SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE");
    map.put('\u22FD', "CONTAINS WITH OVERBAR");
    map.put('\u22FE', "SMALL CONTAINS WITH OVERBAR");
    map.put('\u22FF', "Z NOTATION BAG MEMBERSHIP");
    map.put('\u2300', "DIAMETER SIGN");
    map.put('\u2301', "ELECTRIC ARROW");
    map.put('\u2302', "HOUSE");
    map.put('\u2303', "UP ARROWHEAD");
    map.put('\u2304', "DOWN ARROWHEAD");
    map.put('\u2305', "PROJECTIVE");
    map.put('\u2306', "PERSPECTIVE");
    map.put('\u2307', "WAVY LINE");
    map.put('\u2308', "LEFT CEILING");
    map.put('\u2309', "RIGHT CEILING");
    map.put('\u230A', "LEFT FLOOR");
    map.put('\u230B', "RIGHT FLOOR");
    map.put('\u230C', "BOTTOM RIGHT CROP");
    map.put('\u230D', "BOTTOM LEFT CROP");
    map.put('\u230E', "TOP RIGHT CROP");
    map.put('\u230F', "TOP LEFT CROP");
    map.put('\u2310', "REVERSED NOT SIGN");
    map.put('\u2311', "SQUARE LOZENGE");
    map.put('\u2312', "ARC");
    map.put('\u2313', "SEGMENT");
    map.put('\u2314', "SECTOR");
    map.put('\u2315', "TELEPHONE RECORDER");
    map.put('\u2316', "POSITION INDICATOR");
    map.put('\u2317', "VIEWDATA SQUARE");
    map.put('\u2318', "PLACE OF INTEREST SIGN");
    map.put('\u2319', "TURNED NOT SIGN");
    map.put('\u231A', "WATCH");
    map.put('\u231B', "HOURGLASS");
    map.put('\u231C', "TOP LEFT CORNER");
    map.put('\u231D', "TOP RIGHT CORNER");
    map.put('\u231E', "BOTTOM LEFT CORNER");
    map.put('\u231F', "BOTTOM RIGHT CORNER");
    map.put('\u2320', "TOP HALF INTEGRAL");
    map.put('\u2321', "BOTTOM HALF INTEGRAL");
    map.put('\u2322', "FROWN");
    map.put('\u2323', "SMILE");
    map.put('\u2324', "UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS");
    map.put('\u2325', "OPTION KEY");
    map.put('\u2326', "ERASE TO THE RIGHT");
    map.put('\u2327', "X IN A RECTANGLE BOX");
    map.put('\u2328', "KEYBOARD");
    map.put('\u2329', "LEFT-POINTING ANGLE BRACKET");
    map.put('\u232A', "RIGHT-POINTING ANGLE BRACKET");
    map.put('\u232B', "ERASE TO THE LEFT");
    map.put('\u232C', "BENZENE RING");
    map.put('\u232D', "CYLINDRICITY");
    map.put('\u232E', "ALL AROUND-PROFILE");
    map.put('\u232F', "SYMMETRY");
    map.put('\u2330', "TOTAL RUNOUT");
    map.put('\u2331', "DIMENSION ORIGIN");
    map.put('\u2332', "CONICAL TAPER");
    map.put('\u2333', "SLOPE");
    map.put('\u2334', "COUNTERBORE");
    map.put('\u2335', "COUNTERSINK");
    map.put('\u2336', "APL FUNCTIONAL SYMBOL I-BEAM");
    map.put('\u2337', "APL FUNCTIONAL SYMBOL SQUISH QUAD");
    map.put('\u2338', "APL FUNCTIONAL SYMBOL QUAD EQUAL");
    map.put('\u2339', "APL FUNCTIONAL SYMBOL QUAD DIVIDE");
    map.put('\u233A', "APL FUNCTIONAL SYMBOL QUAD DIAMOND");
    map.put('\u233B', "APL FUNCTIONAL SYMBOL QUAD JOT");
    map.put('\u233C', "APL FUNCTIONAL SYMBOL QUAD CIRCLE");
    map.put('\u233D', "APL FUNCTIONAL SYMBOL CIRCLE STILE");
    map.put('\u233E', "APL FUNCTIONAL SYMBOL CIRCLE JOT");
    map.put('\u233F', "APL FUNCTIONAL SYMBOL SLASH BAR");
    map.put('\u2340', "APL FUNCTIONAL SYMBOL BACKSLASH BAR");
    map.put('\u2341', "APL FUNCTIONAL SYMBOL QUAD SLASH");
    map.put('\u2342', "APL FUNCTIONAL SYMBOL QUAD BACKSLASH");
    map.put('\u2343', "APL FUNCTIONAL SYMBOL QUAD LESS-THAN");
    map.put('\u2344', "APL FUNCTIONAL SYMBOL QUAD GREATER-THAN");
    map.put('\u2345', "APL FUNCTIONAL SYMBOL LEFTWARDS VANE");
    map.put('\u2346', "APL FUNCTIONAL SYMBOL RIGHTWARDS VANE");
    map.put('\u2347', "APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW");
    map.put('\u2348', "APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW");
    map.put('\u2349', "APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH");
    map.put('\u234A', "APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR");
    map.put('\u234B', "APL FUNCTIONAL SYMBOL DELTA STILE");
    map.put('\u234C', "APL FUNCTIONAL SYMBOL QUAD DOWN CARET");
    map.put('\u234D', "APL FUNCTIONAL SYMBOL QUAD DELTA");
    map.put('\u234E', "APL FUNCTIONAL SYMBOL DOWN TACK JOT");
    map.put('\u234F', "APL FUNCTIONAL SYMBOL UPWARDS VANE");
    map.put('\u2350', "APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW");
    map.put('\u2351', "APL FUNCTIONAL SYMBOL UP TACK OVERBAR");
    map.put('\u2352', "APL FUNCTIONAL SYMBOL DEL STILE");
    map.put('\u2353', "APL FUNCTIONAL SYMBOL QUAD UP CARET");
    map.put('\u2354', "APL FUNCTIONAL SYMBOL QUAD DEL");
    map.put('\u2355', "APL FUNCTIONAL SYMBOL UP TACK JOT");
    map.put('\u2356', "APL FUNCTIONAL SYMBOL DOWNWARDS VANE");
    map.put('\u2357', "APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW");
    map.put('\u2358', "APL FUNCTIONAL SYMBOL QUOTE UNDERBAR");
    map.put('\u2359', "APL FUNCTIONAL SYMBOL DELTA UNDERBAR");
    map.put('\u235A', "APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR");
    map.put('\u235B', "APL FUNCTIONAL SYMBOL JOT UNDERBAR");
    map.put('\u235C', "APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR");
    map.put('\u235D', "APL FUNCTIONAL SYMBOL UP SHOE JOT");
    map.put('\u235E', "APL FUNCTIONAL SYMBOL QUOTE QUAD");
    map.put('\u235F', "APL FUNCTIONAL SYMBOL CIRCLE STAR");
    map.put('\u2360', "APL FUNCTIONAL SYMBOL QUAD COLON");
    map.put('\u2361', "APL FUNCTIONAL SYMBOL UP TACK DIAERESIS");
    map.put('\u2362', "APL FUNCTIONAL SYMBOL DEL DIAERESIS");
    map.put('\u2363', "APL FUNCTIONAL SYMBOL STAR DIAERESIS");
    map.put('\u2364', "APL FUNCTIONAL SYMBOL JOT DIAERESIS");
    map.put('\u2365', "APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS");
    map.put('\u2366', "APL FUNCTIONAL SYMBOL DOWN SHOE STILE");
    map.put('\u2367', "APL FUNCTIONAL SYMBOL LEFT SHOE STILE");
    map.put('\u2368', "APL FUNCTIONAL SYMBOL TILDE DIAERESIS");
    map.put('\u2369', "APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS");
    map.put('\u236A', "APL FUNCTIONAL SYMBOL COMMA BAR");
    map.put('\u236B', "APL FUNCTIONAL SYMBOL DEL TILDE");
    map.put('\u236C', "APL FUNCTIONAL SYMBOL ZILDE");
    map.put('\u236D', "APL FUNCTIONAL SYMBOL STILE TILDE");
    map.put('\u236E', "APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR");
    map.put('\u236F', "APL FUNCTIONAL SYMBOL QUAD NOT EQUAL");
    map.put('\u2370', "APL FUNCTIONAL SYMBOL QUAD QUESTION");
    map.put('\u2371', "APL FUNCTIONAL SYMBOL DOWN CARET TILDE");
    map.put('\u2372', "APL FUNCTIONAL SYMBOL UP CARET TILDE");
    map.put('\u2373', "APL FUNCTIONAL SYMBOL IOTA");
    map.put('\u2374', "APL FUNCTIONAL SYMBOL RHO");
    map.put('\u2375', "APL FUNCTIONAL SYMBOL OMEGA");
    map.put('\u2376', "APL FUNCTIONAL SYMBOL ALPHA UNDERBAR");
    map.put('\u2377', "APL FUNCTIONAL SYMBOL EPSILON UNDERBAR");
    map.put('\u2378', "APL FUNCTIONAL SYMBOL IOTA UNDERBAR");
    map.put('\u2379', "APL FUNCTIONAL SYMBOL OMEGA UNDERBAR");
    map.put('\u237A', "APL FUNCTIONAL SYMBOL ALPHA");
    map.put('\u237B', "NOT CHECK MARK");
    map.put('\u237C', "RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW");
    map.put('\u237D', "SHOULDERED OPEN BOX");
    map.put('\u237E', "BELL SYMBOL");
    map.put('\u237F', "VERTICAL LINE WITH MIDDLE DOT");
    map.put('\u2380', "INSERTION SYMBOL");
    map.put('\u2381', "CONTINUOUS UNDERLINE SYMBOL");
    map.put('\u2382', "DISCONTINUOUS UNDERLINE SYMBOL");
    map.put('\u2383', "EMPHASIS SYMBOL");
    map.put('\u2384', "COMPOSITION SYMBOL");
    map.put('\u2385', "WHITE SQUARE WITH CENTRE VERTICAL LINE");
    map.put('\u2386', "ENTER SYMBOL");
    map.put('\u2387', "ALTERNATIVE KEY SYMBOL");
    map.put('\u2388', "HELM SYMBOL");
    map.put('\u2389', "CIRCLED HORIZONTAL BAR WITH NOTCH");
    map.put('\u238A', "CIRCLED TRIANGLE DOWN");
    map.put('\u238B', "BROKEN CIRCLE WITH NORTHWEST ARROW");
    map.put('\u238C', "UNDO SYMBOL");
    map.put('\u238D', "MONOSTABLE SYMBOL");
    map.put('\u238E', "HYSTERESIS SYMBOL");
    map.put('\u238F', "OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL");
    map.put('\u2390', "OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL");
    map.put('\u2391', "PASSIVE-PULL-DOWN-OUTPUT SYMBOL");
    map.put('\u2392', "PASSIVE-PULL-UP-OUTPUT SYMBOL");
    map.put('\u2393', "DIRECT CURRENT SYMBOL FORM TWO");
    map.put('\u2394', "SOFTWARE-FUNCTION SYMBOL");
    map.put('\u2395', "APL FUNCTIONAL SYMBOL QUAD");
    map.put('\u2396', "DECIMAL SEPARATOR KEY SYMBOL");
    map.put('\u2397', "PREVIOUS PAGE");
    map.put('\u2398', "NEXT PAGE");
    map.put('\u2399', "PRINT SCREEN SYMBOL");
    map.put('\u239A', "CLEAR SCREEN SYMBOL");
    map.put('\u239B', "LEFT PARENTHESIS UPPER HOOK");
    map.put('\u239C', "LEFT PARENTHESIS EXTENSION");
    map.put('\u239D', "LEFT PARENTHESIS LOWER HOOK");
    map.put('\u239E', "RIGHT PARENTHESIS UPPER HOOK");
    map.put('\u239F', "RIGHT PARENTHESIS EXTENSION");
    map.put('\u23A0', "RIGHT PARENTHESIS LOWER HOOK");
    map.put('\u23A1', "LEFT SQUARE BRACKET UPPER CORNER");
    map.put('\u23A2', "LEFT SQUARE BRACKET EXTENSION");
    map.put('\u23A3', "LEFT SQUARE BRACKET LOWER CORNER");
    map.put('\u23A4', "RIGHT SQUARE BRACKET UPPER CORNER");
    map.put('\u23A5', "RIGHT SQUARE BRACKET EXTENSION");
    map.put('\u23A6', "RIGHT SQUARE BRACKET LOWER CORNER");
    map.put('\u23A7', "LEFT CURLY BRACKET UPPER HOOK");
    map.put('\u23A8', "LEFT CURLY BRACKET MIDDLE PIECE");
    map.put('\u23A9', "LEFT CURLY BRACKET LOWER HOOK");
    map.put('\u23AA', "CURLY BRACKET EXTENSION");
    map.put('\u23AB', "RIGHT CURLY BRACKET UPPER HOOK");
    map.put('\u23AC', "RIGHT CURLY BRACKET MIDDLE PIECE");
    map.put('\u23AD', "RIGHT CURLY BRACKET LOWER HOOK");
    map.put('\u23AE', "INTEGRAL EXTENSION");
    map.put('\u23AF', "HORIZONTAL LINE EXTENSION");
    map.put('\u23B0', "UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION");
    map.put('\u23B1', "UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION");
    map.put('\u23B2', "SUMMATION TOP");
    map.put('\u23B3', "SUMMATION BOTTOM");
    map.put('\u23B4', "TOP SQUARE BRACKET");
    map.put('\u23B5', "BOTTOM SQUARE BRACKET");
    map.put('\u23B6', "BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET");
    map.put('\u23B7', "RADICAL SYMBOL BOTTOM");
    map.put('\u23B8', "LEFT VERTICAL BOX LINE");
    map.put('\u23B9', "RIGHT VERTICAL BOX LINE");
    map.put('\u23BA', "HORIZONTAL SCAN LINE-1");
    map.put('\u23BB', "HORIZONTAL SCAN LINE-3");
    map.put('\u23BC', "HORIZONTAL SCAN LINE-7");
    map.put('\u23BD', "HORIZONTAL SCAN LINE-9");
    map.put('\u23BE', "DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT");
    map.put('\u23BF', "DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT");
    map.put('\u23C0', "DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE");
    map.put('\u23C1', "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE");
    map.put('\u23C2', "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE");
    map.put('\u23C3', "DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE");
    map.put('\u23C4', "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE");
    map.put('\u23C5', "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE");
    map.put('\u23C6', "DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE");
    map.put('\u23C7', "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE");
    map.put('\u23C8', "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE");
    map.put('\u23C9', "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL");
    map.put('\u23CA', "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL");
    map.put('\u23CB', "DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT");
    map.put('\u23CC', "DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT");
    map.put('\u23CD', "SQUARE FOOT");
    map.put('\u23CE', "RETURN SYMBOL");
    map.put('\u23CF', "EJECT SYMBOL");
    map.put('\u23D0', "VERTICAL LINE EXTENSION");
    map.put('\u23D1', "METRICAL BREVE");
    map.put('\u23D2', "METRICAL LONG OVER SHORT");
    map.put('\u23D3', "METRICAL SHORT OVER LONG");
    map.put('\u23D4', "METRICAL LONG OVER TWO SHORTS");
    map.put('\u23D5', "METRICAL TWO SHORTS OVER LONG");
    map.put('\u23D6', "METRICAL TWO SHORTS JOINED");
    map.put('\u23D7', "METRICAL TRISEME");
    map.put('\u23D8', "METRICAL TETRASEME");
    map.put('\u23D9', "METRICAL PENTASEME");
    map.put('\u23DA', "EARTH GROUND");
    map.put('\u23DB', "FUSE");
    map.put('\u23DC', "TOP PARENTHESIS");
    map.put('\u23DD', "BOTTOM PARENTHESIS");
    map.put('\u23DE', "TOP CURLY BRACKET");
    map.put('\u23DF', "BOTTOM CURLY BRACKET");
    map.put('\u23E0', "TOP TORTOISE SHELL BRACKET");
    map.put('\u23E1', "BOTTOM TORTOISE SHELL BRACKET");
    map.put('\u23E2', "WHITE TRAPEZIUM");
    map.put('\u23E3', "BENZENE RING WITH CIRCLE");
    map.put('\u23E4', "STRAIGHTNESS");
    map.put('\u23E5', "FLATNESS");
    map.put('\u23E6', "AC CURRENT");
    map.put('\u23E7', "ELECTRICAL INTERSECTION");
    map.put('\u23E8', "DECIMAL EXPONENT SYMBOL");
    map.put('\u2400', "SYMBOL FOR NULL");
    map.put('\u2401', "SYMBOL FOR START OF HEADING");
    map.put('\u2402', "SYMBOL FOR START OF TEXT");
    map.put('\u2403', "SYMBOL FOR END OF TEXT");
    map.put('\u2404', "SYMBOL FOR END OF TRANSMISSION");
    map.put('\u2405', "SYMBOL FOR ENQUIRY");
    map.put('\u2406', "SYMBOL FOR ACKNOWLEDGE");
    map.put('\u2407', "SYMBOL FOR BELL");
    map.put('\u2408', "SYMBOL FOR BACKSPACE");
    map.put('\u2409', "SYMBOL FOR HORIZONTAL TABULATION");
    map.put('\u240A', "SYMBOL FOR LINE FEED");
    map.put('\u240B', "SYMBOL FOR VERTICAL TABULATION");
    map.put('\u240C', "SYMBOL FOR FORM FEED");
    map.put('\u240D', "SYMBOL FOR CARRIAGE RETURN");
    map.put('\u240E', "SYMBOL FOR SHIFT OUT");
    map.put('\u240F', "SYMBOL FOR SHIFT IN");
    map.put('\u2410', "SYMBOL FOR DATA LINK ESCAPE");
    map.put('\u2411', "SYMBOL FOR DEVICE CONTROL ONE");
    map.put('\u2412', "SYMBOL FOR DEVICE CONTROL TWO");
    map.put('\u2413', "SYMBOL FOR DEVICE CONTROL THREE");
    map.put('\u2414', "SYMBOL FOR DEVICE CONTROL FOUR");
    map.put('\u2415', "SYMBOL FOR NEGATIVE ACKNOWLEDGE");
    map.put('\u2416', "SYMBOL FOR SYNCHRONOUS IDLE");
    map.put('\u2417', "SYMBOL FOR END OF TRANSMISSION BLOCK");
    map.put('\u2418', "SYMBOL FOR CANCEL");
    map.put('\u2419', "SYMBOL FOR END OF MEDIUM");
    map.put('\u241A', "SYMBOL FOR SUBSTITUTE");
    map.put('\u241B', "SYMBOL FOR ESCAPE");
    map.put('\u241C', "SYMBOL FOR FILE SEPARATOR");
    map.put('\u241D', "SYMBOL FOR GROUP SEPARATOR");
    map.put('\u241E', "SYMBOL FOR RECORD SEPARATOR");
    map.put('\u241F', "SYMBOL FOR UNIT SEPARATOR");
    map.put('\u2420', "SYMBOL FOR SPACE");
    map.put('\u2421', "SYMBOL FOR DELETE");
    map.put('\u2422', "BLANK SYMBOL");
    map.put('\u2423', "OPEN BOX");
    map.put('\u2424', "SYMBOL FOR NEWLINE");
    map.put('\u2425', "SYMBOL FOR DELETE FORM TWO");
    map.put('\u2426', "SYMBOL FOR SUBSTITUTE FORM TWO");
    map.put('\u2440', "OCR HOOK");
    map.put('\u2441', "OCR CHAIR");
    map.put('\u2442', "OCR FORK");
    map.put('\u2443', "OCR INVERTED FORK");
    map.put('\u2444', "OCR BELT BUCKLE");
    map.put('\u2445', "OCR BOW TIE");
    map.put('\u2446', "OCR BRANCH BANK IDENTIFICATION");
    map.put('\u2447', "OCR AMOUNT OF CHECK");
    map.put('\u2448', "OCR DASH");
    map.put('\u2449', "OCR CUSTOMER ACCOUNT NUMBER");
    map.put('\u244A', "OCR DOUBLE BACKSLASH");
    map.put('\u2460', "CIRCLED DIGIT ONE");
    map.put('\u2461', "CIRCLED DIGIT TWO");
    map.put('\u2462', "CIRCLED DIGIT THREE");
    map.put('\u2463', "CIRCLED DIGIT FOUR");
    map.put('\u2464', "CIRCLED DIGIT FIVE");
    map.put('\u2465', "CIRCLED DIGIT SIX");
    map.put('\u2466', "CIRCLED DIGIT SEVEN");
    map.put('\u2467', "CIRCLED DIGIT EIGHT");
    map.put('\u2468', "CIRCLED DIGIT NINE");
    map.put('\u2469', "CIRCLED NUMBER TEN");
    map.put('\u246A', "CIRCLED NUMBER ELEVEN");
    map.put('\u246B', "CIRCLED NUMBER TWELVE");
    map.put('\u246C', "CIRCLED NUMBER THIRTEEN");
    map.put('\u246D', "CIRCLED NUMBER FOURTEEN");
    map.put('\u246E', "CIRCLED NUMBER FIFTEEN");
    map.put('\u246F', "CIRCLED NUMBER SIXTEEN");
    map.put('\u2470', "CIRCLED NUMBER SEVENTEEN");
    map.put('\u2471', "CIRCLED NUMBER EIGHTEEN");
    map.put('\u2472', "CIRCLED NUMBER NINETEEN");
    map.put('\u2473', "CIRCLED NUMBER TWENTY");
    map.put('\u2474', "PARENTHESIZED DIGIT ONE");
    map.put('\u2475', "PARENTHESIZED DIGIT TWO");
    map.put('\u2476', "PARENTHESIZED DIGIT THREE");
    map.put('\u2477', "PARENTHESIZED DIGIT FOUR");
    map.put('\u2478', "PARENTHESIZED DIGIT FIVE");
    map.put('\u2479', "PARENTHESIZED DIGIT SIX");
    map.put('\u247A', "PARENTHESIZED DIGIT SEVEN");
    map.put('\u247B', "PARENTHESIZED DIGIT EIGHT");
    map.put('\u247C', "PARENTHESIZED DIGIT NINE");
    map.put('\u247D', "PARENTHESIZED NUMBER TEN");
    map.put('\u247E', "PARENTHESIZED NUMBER ELEVEN");
    map.put('\u247F', "PARENTHESIZED NUMBER TWELVE");
    map.put('\u2480', "PARENTHESIZED NUMBER THIRTEEN");
    map.put('\u2481', "PARENTHESIZED NUMBER FOURTEEN");
    map.put('\u2482', "PARENTHESIZED NUMBER FIFTEEN");
    map.put('\u2483', "PARENTHESIZED NUMBER SIXTEEN");
    map.put('\u2484', "PARENTHESIZED NUMBER SEVENTEEN");
    map.put('\u2485', "PARENTHESIZED NUMBER EIGHTEEN");
    map.put('\u2486', "PARENTHESIZED NUMBER NINETEEN");
    map.put('\u2487', "PARENTHESIZED NUMBER TWENTY");
    map.put('\u2488', "DIGIT ONE FULL STOP");
    map.put('\u2489', "DIGIT TWO FULL STOP");
    map.put('\u248A', "DIGIT THREE FULL STOP");
    map.put('\u248B', "DIGIT FOUR FULL STOP");
    map.put('\u248C', "DIGIT FIVE FULL STOP");
    map.put('\u248D', "DIGIT SIX FULL STOP");
    map.put('\u248E', "DIGIT SEVEN FULL STOP");
    map.put('\u248F', "DIGIT EIGHT FULL STOP");
    map.put('\u2490', "DIGIT NINE FULL STOP");
    map.put('\u2491', "NUMBER TEN FULL STOP");
    map.put('\u2492', "NUMBER ELEVEN FULL STOP");
    map.put('\u2493', "NUMBER TWELVE FULL STOP");
    map.put('\u2494', "NUMBER THIRTEEN FULL STOP");
    map.put('\u2495', "NUMBER FOURTEEN FULL STOP");
    map.put('\u2496', "NUMBER FIFTEEN FULL STOP");
    map.put('\u2497', "NUMBER SIXTEEN FULL STOP");
    map.put('\u2498', "NUMBER SEVENTEEN FULL STOP");
    map.put('\u2499', "NUMBER EIGHTEEN FULL STOP");
    map.put('\u249A', "NUMBER NINETEEN FULL STOP");
    map.put('\u249B', "NUMBER TWENTY FULL STOP");
    map.put('\u249C', "PARENTHESIZED LATIN SMALL LETTER A");
    map.put('\u249D', "PARENTHESIZED LATIN SMALL LETTER B");
    map.put('\u249E', "PARENTHESIZED LATIN SMALL LETTER C");
    map.put('\u249F', "PARENTHESIZED LATIN SMALL LETTER D");
    map.put('\u24A0', "PARENTHESIZED LATIN SMALL LETTER E");
    map.put('\u24A1', "PARENTHESIZED LATIN SMALL LETTER F");
    map.put('\u24A2', "PARENTHESIZED LATIN SMALL LETTER G");
    map.put('\u24A3', "PARENTHESIZED LATIN SMALL LETTER H");
    map.put('\u24A4', "PARENTHESIZED LATIN SMALL LETTER I");
    map.put('\u24A5', "PARENTHESIZED LATIN SMALL LETTER J");
    map.put('\u24A6', "PARENTHESIZED LATIN SMALL LETTER K");
    map.put('\u24A7', "PARENTHESIZED LATIN SMALL LETTER L");
    map.put('\u24A8', "PARENTHESIZED LATIN SMALL LETTER M");
    map.put('\u24A9', "PARENTHESIZED LATIN SMALL LETTER N");
    map.put('\u24AA', "PARENTHESIZED LATIN SMALL LETTER O");
    map.put('\u24AB', "PARENTHESIZED LATIN SMALL LETTER P");
    map.put('\u24AC', "PARENTHESIZED LATIN SMALL LETTER Q");
    map.put('\u24AD', "PARENTHESIZED LATIN SMALL LETTER R");
    map.put('\u24AE', "PARENTHESIZED LATIN SMALL LETTER S");
    map.put('\u24AF', "PARENTHESIZED LATIN SMALL LETTER T");
    map.put('\u24B0', "PARENTHESIZED LATIN SMALL LETTER U");
    map.put('\u24B1', "PARENTHESIZED LATIN SMALL LETTER V");
    map.put('\u24B2', "PARENTHESIZED LATIN SMALL LETTER W");
    map.put('\u24B3', "PARENTHESIZED LATIN SMALL LETTER X");
    map.put('\u24B4', "PARENTHESIZED LATIN SMALL LETTER Y");
    map.put('\u24B5', "PARENTHESIZED LATIN SMALL LETTER Z");
    map.put('\u24B6', "CIRCLED LATIN CAPITAL LETTER A");
    map.put('\u24B7', "CIRCLED LATIN CAPITAL LETTER B");
    map.put('\u24B8', "CIRCLED LATIN CAPITAL LETTER C");
    map.put('\u24B9', "CIRCLED LATIN CAPITAL LETTER D");
    map.put('\u24BA', "CIRCLED LATIN CAPITAL LETTER E");
    map.put('\u24BB', "CIRCLED LATIN CAPITAL LETTER F");
    map.put('\u24BC', "CIRCLED LATIN CAPITAL LETTER G");
    map.put('\u24BD', "CIRCLED LATIN CAPITAL LETTER H");
    map.put('\u24BE', "CIRCLED LATIN CAPITAL LETTER I");
    map.put('\u24BF', "CIRCLED LATIN CAPITAL LETTER J");
    map.put('\u24C0', "CIRCLED LATIN CAPITAL LETTER K");
    map.put('\u24C1', "CIRCLED LATIN CAPITAL LETTER L");
    map.put('\u24C2', "CIRCLED LATIN CAPITAL LETTER M");
    map.put('\u24C3', "CIRCLED LATIN CAPITAL LETTER N");
    map.put('\u24C4', "CIRCLED LATIN CAPITAL LETTER O");
    map.put('\u24C5', "CIRCLED LATIN CAPITAL LETTER P");
    map.put('\u24C6', "CIRCLED LATIN CAPITAL LETTER Q");
    map.put('\u24C7', "CIRCLED LATIN CAPITAL LETTER R");
    map.put('\u24C8', "CIRCLED LATIN CAPITAL LETTER S");
    map.put('\u24C9', "CIRCLED LATIN CAPITAL LETTER T");
    map.put('\u24CA', "CIRCLED LATIN CAPITAL LETTER U");
    map.put('\u24CB', "CIRCLED LATIN CAPITAL LETTER V");
    map.put('\u24CC', "CIRCLED LATIN CAPITAL LETTER W");
    map.put('\u24CD', "CIRCLED LATIN CAPITAL LETTER X");
    map.put('\u24CE', "CIRCLED LATIN CAPITAL LETTER Y");
    map.put('\u24CF', "CIRCLED LATIN CAPITAL LETTER Z");
    map.put('\u24D0', "CIRCLED LATIN SMALL LETTER A");
    map.put('\u24D1', "CIRCLED LATIN SMALL LETTER B");
    map.put('\u24D2', "CIRCLED LATIN SMALL LETTER C");
    map.put('\u24D3', "CIRCLED LATIN SMALL LETTER D");
    map.put('\u24D4', "CIRCLED LATIN SMALL LETTER E");
    map.put('\u24D5', "CIRCLED LATIN SMALL LETTER F");
    map.put('\u24D6', "CIRCLED LATIN SMALL LETTER G");
    map.put('\u24D7', "CIRCLED LATIN SMALL LETTER H");
    map.put('\u24D8', "CIRCLED LATIN SMALL LETTER I");
    map.put('\u24D9', "CIRCLED LATIN SMALL LETTER J");
    map.put('\u24DA', "CIRCLED LATIN SMALL LETTER K");
    map.put('\u24DB', "CIRCLED LATIN SMALL LETTER L");
    map.put('\u24DC', "CIRCLED LATIN SMALL LETTER M");
    map.put('\u24DD', "CIRCLED LATIN SMALL LETTER N");
    map.put('\u24DE', "CIRCLED LATIN SMALL LETTER O");
    map.put('\u24DF', "CIRCLED LATIN SMALL LETTER P");
    map.put('\u24E0', "CIRCLED LATIN SMALL LETTER Q");
    map.put('\u24E1', "CIRCLED LATIN SMALL LETTER R");
    map.put('\u24E2', "CIRCLED LATIN SMALL LETTER S");
    map.put('\u24E3', "CIRCLED LATIN SMALL LETTER T");
    map.put('\u24E4', "CIRCLED LATIN SMALL LETTER U");
    map.put('\u24E5', "CIRCLED LATIN SMALL LETTER V");
    map.put('\u24E6', "CIRCLED LATIN SMALL LETTER W");
    map.put('\u24E7', "CIRCLED LATIN SMALL LETTER X");
    map.put('\u24E8', "CIRCLED LATIN SMALL LETTER Y");
    map.put('\u24E9', "CIRCLED LATIN SMALL LETTER Z");
    map.put('\u24EA', "CIRCLED DIGIT ZERO");
    map.put('\u24EB', "NEGATIVE CIRCLED NUMBER ELEVEN");
    map.put('\u24EC', "NEGATIVE CIRCLED NUMBER TWELVE");
    map.put('\u24ED', "NEGATIVE CIRCLED NUMBER THIRTEEN");
    map.put('\u24EE', "NEGATIVE CIRCLED NUMBER FOURTEEN");
    map.put('\u24EF', "NEGATIVE CIRCLED NUMBER FIFTEEN");
    map.put('\u24F0', "NEGATIVE CIRCLED NUMBER SIXTEEN");
    map.put('\u24F1', "NEGATIVE CIRCLED NUMBER SEVENTEEN");
    map.put('\u24F2', "NEGATIVE CIRCLED NUMBER EIGHTEEN");
    map.put('\u24F3', "NEGATIVE CIRCLED NUMBER NINETEEN");
    map.put('\u24F4', "NEGATIVE CIRCLED NUMBER TWENTY");
    map.put('\u24F5', "DOUBLE CIRCLED DIGIT ONE");
    map.put('\u24F6', "DOUBLE CIRCLED DIGIT TWO");
    map.put('\u24F7', "DOUBLE CIRCLED DIGIT THREE");
    map.put('\u24F8', "DOUBLE CIRCLED DIGIT FOUR");
    map.put('\u24F9', "DOUBLE CIRCLED DIGIT FIVE");
    map.put('\u24FA', "DOUBLE CIRCLED DIGIT SIX");
    map.put('\u24FB', "DOUBLE CIRCLED DIGIT SEVEN");
    map.put('\u24FC', "DOUBLE CIRCLED DIGIT EIGHT");
    map.put('\u24FD', "DOUBLE CIRCLED DIGIT NINE");
    map.put('\u24FE', "DOUBLE CIRCLED NUMBER TEN");
    map.put('\u24FF', "NEGATIVE CIRCLED DIGIT ZERO");
    map.put('\u2500', "BOX DRAWINGS LIGHT HORIZONTAL");
    map.put('\u2501', "BOX DRAWINGS HEAVY HORIZONTAL");
    map.put('\u2502', "BOX DRAWINGS LIGHT VERTICAL");
    map.put('\u2503', "BOX DRAWINGS HEAVY VERTICAL");
    map.put('\u2504', "BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL");
    map.put('\u2505', "BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL");
    map.put('\u2506', "BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL");
    map.put('\u2507', "BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL");
    map.put('\u2508', "BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL");
    map.put('\u2509', "BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL");
    map.put('\u250A', "BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL");
    map.put('\u250B', "BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL");
    map.put('\u250C', "BOX DRAWINGS LIGHT DOWN AND RIGHT");
    map.put('\u250D', "BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY");
    map.put('\u250E', "BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT");
    map.put('\u250F', "BOX DRAWINGS HEAVY DOWN AND RIGHT");
    map.put('\u2510', "BOX DRAWINGS LIGHT DOWN AND LEFT");
    map.put('\u2511', "BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY");
    map.put('\u2512', "BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT");
    map.put('\u2513', "BOX DRAWINGS HEAVY DOWN AND LEFT");
    map.put('\u2514', "BOX DRAWINGS LIGHT UP AND RIGHT");
    map.put('\u2515', "BOX DRAWINGS UP LIGHT AND RIGHT HEAVY");
    map.put('\u2516', "BOX DRAWINGS UP HEAVY AND RIGHT LIGHT");
    map.put('\u2517', "BOX DRAWINGS HEAVY UP AND RIGHT");
    map.put('\u2518', "BOX DRAWINGS LIGHT UP AND LEFT");
    map.put('\u2519', "BOX DRAWINGS UP LIGHT AND LEFT HEAVY");
    map.put('\u251A', "BOX DRAWINGS UP HEAVY AND LEFT LIGHT");
    map.put('\u251B', "BOX DRAWINGS HEAVY UP AND LEFT");
    map.put('\u251C', "BOX DRAWINGS LIGHT VERTICAL AND RIGHT");
    map.put('\u251D', "BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY");
    map.put('\u251E', "BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT");
    map.put('\u251F', "BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT");
    map.put('\u2520', "BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT");
    map.put('\u2521', "BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY");
    map.put('\u2522', "BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY");
    map.put('\u2523', "BOX DRAWINGS HEAVY VERTICAL AND RIGHT");
    map.put('\u2524', "BOX DRAWINGS LIGHT VERTICAL AND LEFT");
    map.put('\u2525', "BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY");
    map.put('\u2526', "BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT");
    map.put('\u2527', "BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT");
    map.put('\u2528', "BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT");
    map.put('\u2529', "BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY");
    map.put('\u252A', "BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY");
    map.put('\u252B', "BOX DRAWINGS HEAVY VERTICAL AND LEFT");
    map.put('\u252C', "BOX DRAWINGS LIGHT DOWN AND HORIZONTAL");
    map.put('\u252D', "BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT");
    map.put('\u252E', "BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT");
    map.put('\u252F', "BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY");
    map.put('\u2530', "BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT");
    map.put('\u2531', "BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY");
    map.put('\u2532', "BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY");
    map.put('\u2533', "BOX DRAWINGS HEAVY DOWN AND HORIZONTAL");
    map.put('\u2534', "BOX DRAWINGS LIGHT UP AND HORIZONTAL");
    map.put('\u2535', "BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT");
    map.put('\u2536', "BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT");
    map.put('\u2537', "BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY");
    map.put('\u2538', "BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT");
    map.put('\u2539', "BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY");
    map.put('\u253A', "BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY");
    map.put('\u253B', "BOX DRAWINGS HEAVY UP AND HORIZONTAL");
    map.put('\u253C', "BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL");
    map.put('\u253D', "BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT");
    map.put('\u253E', "BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT");
    map.put('\u253F', "BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY");
    map.put('\u2540', "BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT");
    map.put('\u2541', "BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT");
    map.put('\u2542', "BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT");
    map.put('\u2543', "BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT");
    map.put('\u2544', "BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT");
    map.put('\u2545', "BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT");
    map.put('\u2546', "BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT");
    map.put('\u2547', "BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY");
    map.put('\u2548', "BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY");
    map.put('\u2549', "BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY");
    map.put('\u254A', "BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY");
    map.put('\u254B', "BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL");
    map.put('\u254C', "BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL");
    map.put('\u254D', "BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL");
    map.put('\u254E', "BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL");
    map.put('\u254F', "BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL");
    map.put('\u2550', "BOX DRAWINGS DOUBLE HORIZONTAL");
    map.put('\u2551', "BOX DRAWINGS DOUBLE VERTICAL");
    map.put('\u2552', "BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE");
    map.put('\u2553', "BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE");
    map.put('\u2554', "BOX DRAWINGS DOUBLE DOWN AND RIGHT");
    map.put('\u2555', "BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE");
    map.put('\u2556', "BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE");
    map.put('\u2557', "BOX DRAWINGS DOUBLE DOWN AND LEFT");
    map.put('\u2558', "BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE");
    map.put('\u2559', "BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE");
    map.put('\u255A', "BOX DRAWINGS DOUBLE UP AND RIGHT");
    map.put('\u255B', "BOX DRAWINGS UP SINGLE AND LEFT DOUBLE");
    map.put('\u255C', "BOX DRAWINGS UP DOUBLE AND LEFT SINGLE");
    map.put('\u255D', "BOX DRAWINGS DOUBLE UP AND LEFT");
    map.put('\u255E', "BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE");
    map.put('\u255F', "BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE");
    map.put('\u2560', "BOX DRAWINGS DOUBLE VERTICAL AND RIGHT");
    map.put('\u2561', "BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE");
    map.put('\u2562', "BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE");
    map.put('\u2563', "BOX DRAWINGS DOUBLE VERTICAL AND LEFT");
    map.put('\u2564', "BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE");
    map.put('\u2565', "BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE");
    map.put('\u2566', "BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL");
    map.put('\u2567', "BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE");
    map.put('\u2568', "BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE");
    map.put('\u2569', "BOX DRAWINGS DOUBLE UP AND HORIZONTAL");
    map.put('\u256A', "BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE");
    map.put('\u256B', "BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE");
    map.put('\u256C', "BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL");
    map.put('\u256D', "BOX DRAWINGS LIGHT ARC DOWN AND RIGHT");
    map.put('\u256E', "BOX DRAWINGS LIGHT ARC DOWN AND LEFT");
    map.put('\u256F', "BOX DRAWINGS LIGHT ARC UP AND LEFT");
    map.put('\u2570', "BOX DRAWINGS LIGHT ARC UP AND RIGHT");
    map.put('\u2571', "BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT");
    map.put('\u2572', "BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT");
    map.put('\u2573', "BOX DRAWINGS LIGHT DIAGONAL CROSS");
    map.put('\u2574', "BOX DRAWINGS LIGHT LEFT");
    map.put('\u2575', "BOX DRAWINGS LIGHT UP");
    map.put('\u2576', "BOX DRAWINGS LIGHT RIGHT");
    map.put('\u2577', "BOX DRAWINGS LIGHT DOWN");
    map.put('\u2578', "BOX DRAWINGS HEAVY LEFT");
    map.put('\u2579', "BOX DRAWINGS HEAVY UP");
    map.put('\u257A', "BOX DRAWINGS HEAVY RIGHT");
    map.put('\u257B', "BOX DRAWINGS HEAVY DOWN");
    map.put('\u257C', "BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT");
    map.put('\u257D', "BOX DRAWINGS LIGHT UP AND HEAVY DOWN");
    map.put('\u257E', "BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT");
    map.put('\u257F', "BOX DRAWINGS HEAVY UP AND LIGHT DOWN");
    map.put('\u2580', "UPPER HALF BLOCK");
    map.put('\u2581', "LOWER ONE EIGHTH BLOCK");
    map.put('\u2582', "LOWER ONE QUARTER BLOCK");
    map.put('\u2583', "LOWER THREE EIGHTHS BLOCK");
    map.put('\u2584', "LOWER HALF BLOCK");
    map.put('\u2585', "LOWER FIVE EIGHTHS BLOCK");
    map.put('\u2586', "LOWER THREE QUARTERS BLOCK");
    map.put('\u2587', "LOWER SEVEN EIGHTHS BLOCK");
    map.put('\u2588', "FULL BLOCK");
    map.put('\u2589', "LEFT SEVEN EIGHTHS BLOCK");
    map.put('\u258A', "LEFT THREE QUARTERS BLOCK");
    map.put('\u258B', "LEFT FIVE EIGHTHS BLOCK");
    map.put('\u258C', "LEFT HALF BLOCK");
    map.put('\u258D', "LEFT THREE EIGHTHS BLOCK");
    map.put('\u258E', "LEFT ONE QUARTER BLOCK");
    map.put('\u258F', "LEFT ONE EIGHTH BLOCK");
    map.put('\u2590', "RIGHT HALF BLOCK");
    map.put('\u2591', "LIGHT SHADE");
    map.put('\u2592', "MEDIUM SHADE");
    map.put('\u2593', "DARK SHADE");
    map.put('\u2594', "UPPER ONE EIGHTH BLOCK");
    map.put('\u2595', "RIGHT ONE EIGHTH BLOCK");
    map.put('\u2596', "QUADRANT LOWER LEFT");
    map.put('\u2597', "QUADRANT LOWER RIGHT");
    map.put('\u2598', "QUADRANT UPPER LEFT");
    map.put('\u2599', "QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT");
    map.put('\u259A', "QUADRANT UPPER LEFT AND LOWER RIGHT");
    map.put('\u259B', "QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT");
    map.put('\u259C', "QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT");
    map.put('\u259D', "QUADRANT UPPER RIGHT");
    map.put('\u259E', "QUADRANT UPPER RIGHT AND LOWER LEFT");
    map.put('\u259F', "QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT");
    map.put('\u25A0', "BLACK SQUARE");
    map.put('\u25A1', "WHITE SQUARE");
    map.put('\u25A2', "WHITE SQUARE WITH ROUNDED CORNERS");
    map.put('\u25A3', "WHITE SQUARE CONTAINING BLACK SMALL SQUARE");
    map.put('\u25A4', "SQUARE WITH HORIZONTAL FILL");
    map.put('\u25A5', "SQUARE WITH VERTICAL FILL");
    map.put('\u25A6', "SQUARE WITH ORTHOGONAL CROSSHATCH FILL");
    map.put('\u25A7', "SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL");
    map.put('\u25A8', "SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL");
    map.put('\u25A9', "SQUARE WITH DIAGONAL CROSSHATCH FILL");
    map.put('\u25AA', "BLACK SMALL SQUARE");
    map.put('\u25AB', "WHITE SMALL SQUARE");
    map.put('\u25AC', "BLACK RECTANGLE");
    map.put('\u25AD', "WHITE RECTANGLE");
    map.put('\u25AE', "BLACK VERTICAL RECTANGLE");
    map.put('\u25AF', "WHITE VERTICAL RECTANGLE");
    map.put('\u25B0', "BLACK PARALLELOGRAM");
    map.put('\u25B1', "WHITE PARALLELOGRAM");
    map.put('\u25B2', "BLACK UP-POINTING TRIANGLE");
    map.put('\u25B3', "WHITE UP-POINTING TRIANGLE");
    map.put('\u25B4', "BLACK UP-POINTING SMALL TRIANGLE");
    map.put('\u25B5', "WHITE UP-POINTING SMALL TRIANGLE");
    map.put('\u25B6', "BLACK RIGHT-POINTING TRIANGLE");
    map.put('\u25B7', "WHITE RIGHT-POINTING TRIANGLE");
    map.put('\u25B8', "BLACK RIGHT-POINTING SMALL TRIANGLE");
    map.put('\u25B9', "WHITE RIGHT-POINTING SMALL TRIANGLE");
    map.put('\u25BA', "BLACK RIGHT-POINTING POINTER");
    map.put('\u25BB', "WHITE RIGHT-POINTING POINTER");
    map.put('\u25BC', "BLACK DOWN-POINTING TRIANGLE");
    map.put('\u25BD', "WHITE DOWN-POINTING TRIANGLE");
    map.put('\u25BE', "BLACK DOWN-POINTING SMALL TRIANGLE");
    map.put('\u25BF', "WHITE DOWN-POINTING SMALL TRIANGLE");
    map.put('\u25C0', "BLACK LEFT-POINTING TRIANGLE");
    map.put('\u25C1', "WHITE LEFT-POINTING TRIANGLE");
    map.put('\u25C2', "BLACK LEFT-POINTING SMALL TRIANGLE");
    map.put('\u25C3', "WHITE LEFT-POINTING SMALL TRIANGLE");
    map.put('\u25C4', "BLACK LEFT-POINTING POINTER");
    map.put('\u25C5', "WHITE LEFT-POINTING POINTER");
    map.put('\u25C6', "BLACK DIAMOND");
    map.put('\u25C7', "WHITE DIAMOND");
    map.put('\u25C8', "WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND");
    map.put('\u25C9', "FISHEYE");
    map.put('\u25CA', "LOZENGE");
    map.put('\u25CB', "WHITE CIRCLE");
    map.put('\u25CC', "DOTTED CIRCLE");
    map.put('\u25CD', "CIRCLE WITH VERTICAL FILL");
    map.put('\u25CE', "BULLSEYE");
    map.put('\u25CF', "BLACK CIRCLE");
    map.put('\u25D0', "CIRCLE WITH LEFT HALF BLACK");
    map.put('\u25D1', "CIRCLE WITH RIGHT HALF BLACK");
    map.put('\u25D2', "CIRCLE WITH LOWER HALF BLACK");
    map.put('\u25D3', "CIRCLE WITH UPPER HALF BLACK");
    map.put('\u25D4', "CIRCLE WITH UPPER RIGHT QUADRANT BLACK");
    map.put('\u25D5', "CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK");
    map.put('\u25D6', "LEFT HALF BLACK CIRCLE");
    map.put('\u25D7', "RIGHT HALF BLACK CIRCLE");
    map.put('\u25D8', "INVERSE BULLET");
    map.put('\u25D9', "INVERSE WHITE CIRCLE");
    map.put('\u25DA', "UPPER HALF INVERSE WHITE CIRCLE");
    map.put('\u25DB', "LOWER HALF INVERSE WHITE CIRCLE");
    map.put('\u25DC', "UPPER LEFT QUADRANT CIRCULAR ARC");
    map.put('\u25DD', "UPPER RIGHT QUADRANT CIRCULAR ARC");
    map.put('\u25DE', "LOWER RIGHT QUADRANT CIRCULAR ARC");
    map.put('\u25DF', "LOWER LEFT QUADRANT CIRCULAR ARC");
    map.put('\u25E0', "UPPER HALF CIRCLE");
    map.put('\u25E1', "LOWER HALF CIRCLE");
    map.put('\u25E2', "BLACK LOWER RIGHT TRIANGLE");
    map.put('\u25E3', "BLACK LOWER LEFT TRIANGLE");
    map.put('\u25E4', "BLACK UPPER LEFT TRIANGLE");
    map.put('\u25E5', "BLACK UPPER RIGHT TRIANGLE");
    map.put('\u25E6', "WHITE BULLET");
    map.put('\u25E7', "SQUARE WITH LEFT HALF BLACK");
    map.put('\u25E8', "SQUARE WITH RIGHT HALF BLACK");
    map.put('\u25E9', "SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK");
    map.put('\u25EA', "SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK");
    map.put('\u25EB', "WHITE SQUARE WITH VERTICAL BISECTING LINE");
    map.put('\u25EC', "WHITE UP-POINTING TRIANGLE WITH DOT");
    map.put('\u25ED', "UP-POINTING TRIANGLE WITH LEFT HALF BLACK");
    map.put('\u25EE', "UP-POINTING TRIANGLE WITH RIGHT HALF BLACK");
    map.put('\u25EF', "LARGE CIRCLE");
    map.put('\u25F0', "WHITE SQUARE WITH UPPER LEFT QUADRANT");
    map.put('\u25F1', "WHITE SQUARE WITH LOWER LEFT QUADRANT");
    map.put('\u25F2', "WHITE SQUARE WITH LOWER RIGHT QUADRANT");
    map.put('\u25F3', "WHITE SQUARE WITH UPPER RIGHT QUADRANT");
    map.put('\u25F4', "WHITE CIRCLE WITH UPPER LEFT QUADRANT");
    map.put('\u25F5', "WHITE CIRCLE WITH LOWER LEFT QUADRANT");
    map.put('\u25F6', "WHITE CIRCLE WITH LOWER RIGHT QUADRANT");
    map.put('\u25F7', "WHITE CIRCLE WITH UPPER RIGHT QUADRANT");
    map.put('\u25F8', "UPPER LEFT TRIANGLE");
    map.put('\u25F9', "UPPER RIGHT TRIANGLE");
    map.put('\u25FA', "LOWER LEFT TRIANGLE");
    map.put('\u25FB', "WHITE MEDIUM SQUARE");
    map.put('\u25FC', "BLACK MEDIUM SQUARE");
    map.put('\u25FD', "WHITE MEDIUM SMALL SQUARE");
    map.put('\u25FE', "BLACK MEDIUM SMALL SQUARE");
    map.put('\u25FF', "LOWER RIGHT TRIANGLE");
    map.put('\u2600', "BLACK SUN WITH RAYS");
    map.put('\u2601', "CLOUD");
    map.put('\u2602', "UMBRELLA");
    map.put('\u2603', "SNOWMAN");
    map.put('\u2604', "COMET");
    map.put('\u2605', "BLACK STAR");
    map.put('\u2606', "WHITE STAR");
    map.put('\u2607', "LIGHTNING");
    map.put('\u2608', "THUNDERSTORM");
    map.put('\u2609', "SUN");
    map.put('\u260A', "ASCENDING NODE");
    map.put('\u260B', "DESCENDING NODE");
    map.put('\u260C', "CONJUNCTION");
    map.put('\u260D', "OPPOSITION");
    map.put('\u260E', "BLACK TELEPHONE");
    map.put('\u260F', "WHITE TELEPHONE");
    map.put('\u2610', "BALLOT BOX");
    map.put('\u2611', "BALLOT BOX WITH CHECK");
    map.put('\u2612', "BALLOT BOX WITH X");
    map.put('\u2613', "SALTIRE");
    map.put('\u2614', "UMBRELLA WITH RAIN DROPS");
    map.put('\u2615', "HOT BEVERAGE");
    map.put('\u2616', "WHITE SHOGI PIECE");
    map.put('\u2617', "BLACK SHOGI PIECE");
    map.put('\u2618', "SHAMROCK");
    map.put('\u2619', "REVERSED ROTATED FLORAL HEART BULLET");
    map.put('\u261A', "BLACK LEFT POINTING INDEX");
    map.put('\u261B', "BLACK RIGHT POINTING INDEX");
    map.put('\u261C', "WHITE LEFT POINTING INDEX");
    map.put('\u261D', "WHITE UP POINTING INDEX");
    map.put('\u261E', "WHITE RIGHT POINTING INDEX");
    map.put('\u261F', "WHITE DOWN POINTING INDEX");
    map.put('\u2620', "SKULL AND CROSSBONES");
    map.put('\u2621', "CAUTION SIGN");
    map.put('\u2622', "RADIOACTIVE SIGN");
    map.put('\u2623', "BIOHAZARD SIGN");
    map.put('\u2624', "CADUCEUS");
    map.put('\u2625', "ANKH");
    map.put('\u2626', "ORTHODOX CROSS");
    map.put('\u2627', "CHI RHO");
    map.put('\u2628', "CROSS OF LORRAINE");
    map.put('\u2629', "CROSS OF JERUSALEM");
    map.put('\u262A', "STAR AND CRESCENT");
    map.put('\u262B', "FARSI SYMBOL");
    map.put('\u262C', "ADI SHAKTI");
    map.put('\u262D', "HAMMER AND SICKLE");
    map.put('\u262E', "PEACE SYMBOL");
    map.put('\u262F', "YIN YANG");
    map.put('\u2630', "TRIGRAM FOR HEAVEN");
    map.put('\u2631', "TRIGRAM FOR LAKE");
    map.put('\u2632', "TRIGRAM FOR FIRE");
    map.put('\u2633', "TRIGRAM FOR THUNDER");
    map.put('\u2634', "TRIGRAM FOR WIND");
    map.put('\u2635', "TRIGRAM FOR WATER");
    map.put('\u2636', "TRIGRAM FOR MOUNTAIN");
    map.put('\u2637', "TRIGRAM FOR EARTH");
    map.put('\u2638', "WHEEL OF DHARMA");
    map.put('\u2639', "WHITE FROWNING FACE");
    map.put('\u263A', "WHITE SMILING FACE");
    map.put('\u263B', "BLACK SMILING FACE");
    map.put('\u263C', "WHITE SUN WITH RAYS");
    map.put('\u263D', "FIRST QUARTER MOON");
    map.put('\u263E', "LAST QUARTER MOON");
    map.put('\u263F', "MERCURY");
    map.put('\u2640', "FEMALE SIGN");
    map.put('\u2641', "EARTH");
    map.put('\u2642', "MALE SIGN");
    map.put('\u2643', "JUPITER");
    map.put('\u2644', "SATURN");
    map.put('\u2645', "URANUS");
    map.put('\u2646', "NEPTUNE");
    map.put('\u2647', "PLUTO");
    map.put('\u2648', "ARIES");
    map.put('\u2649', "TAURUS");
    map.put('\u264A', "GEMINI");
    map.put('\u264B', "CANCER");
    map.put('\u264C', "LEO");
    map.put('\u264D', "VIRGO");
    map.put('\u264E', "LIBRA");
    map.put('\u264F', "SCORPIUS");
    map.put('\u2650', "SAGITTARIUS");
    map.put('\u2651', "CAPRICORN");
    map.put('\u2652', "AQUARIUS");
    map.put('\u2653', "PISCES");
    map.put('\u2654', "WHITE CHESS KING");
    map.put('\u2655', "WHITE CHESS QUEEN");
    map.put('\u2656', "WHITE CHESS ROOK");
    map.put('\u2657', "WHITE CHESS BISHOP");
    map.put('\u2658', "WHITE CHESS KNIGHT");
    map.put('\u2659', "WHITE CHESS PAWN");
    map.put('\u265A', "BLACK CHESS KING");
    map.put('\u265B', "BLACK CHESS QUEEN");
    map.put('\u265C', "BLACK CHESS ROOK");
    map.put('\u265D', "BLACK CHESS BISHOP");
    map.put('\u265E', "BLACK CHESS KNIGHT");
    map.put('\u265F', "BLACK CHESS PAWN");
    map.put('\u2660', "BLACK SPADE SUIT");
    map.put('\u2661', "WHITE HEART SUIT");
    map.put('\u2662', "WHITE DIAMOND SUIT");
    map.put('\u2663', "BLACK CLUB SUIT");
    map.put('\u2664', "WHITE SPADE SUIT");
    map.put('\u2665', "BLACK HEART SUIT");
    map.put('\u2666', "BLACK DIAMOND SUIT");
    map.put('\u2667', "WHITE CLUB SUIT");
    map.put('\u2668', "HOT SPRINGS");
    map.put('\u2669', "QUARTER NOTE");
    map.put('\u266A', "EIGHTH NOTE");
    map.put('\u266B', "BEAMED EIGHTH NOTES");
    map.put('\u266C', "BEAMED SIXTEENTH NOTES");
    map.put('\u266D', "MUSIC FLAT SIGN");
    map.put('\u266E', "MUSIC NATURAL SIGN");
    map.put('\u266F', "MUSIC SHARP SIGN");
    map.put('\u2670', "WEST SYRIAC CROSS");
    map.put('\u2671', "EAST SYRIAC CROSS");
    map.put('\u2672', "UNIVERSAL RECYCLING SYMBOL");
    map.put('\u2673', "RECYCLING SYMBOL FOR TYPE-1 PLASTICS");
    map.put('\u2674', "RECYCLING SYMBOL FOR TYPE-2 PLASTICS");
    map.put('\u2675', "RECYCLING SYMBOL FOR TYPE-3 PLASTICS");
    map.put('\u2676', "RECYCLING SYMBOL FOR TYPE-4 PLASTICS");
    map.put('\u2677', "RECYCLING SYMBOL FOR TYPE-5 PLASTICS");
    map.put('\u2678', "RECYCLING SYMBOL FOR TYPE-6 PLASTICS");
    map.put('\u2679', "RECYCLING SYMBOL FOR TYPE-7 PLASTICS");
    map.put('\u267A', "RECYCLING SYMBOL FOR GENERIC MATERIALS");
    map.put('\u267B', "BLACK UNIVERSAL RECYCLING SYMBOL");
    map.put('\u267C', "RECYCLED PAPER SYMBOL");
    map.put('\u267D', "PARTIALLY-RECYCLED PAPER SYMBOL");
    map.put('\u267E', "PERMANENT PAPER SIGN");
    map.put('\u267F', "WHEELCHAIR SYMBOL");
    map.put('\u2680', "DIE FACE-1");
    map.put('\u2681', "DIE FACE-2");
    map.put('\u2682', "DIE FACE-3");
    map.put('\u2683', "DIE FACE-4");
    map.put('\u2684', "DIE FACE-5");
    map.put('\u2685', "DIE FACE-6");
    map.put('\u2686', "WHITE CIRCLE WITH DOT RIGHT");
    map.put('\u2687', "WHITE CIRCLE WITH TWO DOTS");
    map.put('\u2688', "BLACK CIRCLE WITH WHITE DOT RIGHT");
    map.put('\u2689', "BLACK CIRCLE WITH TWO WHITE DOTS");
    map.put('\u268A', "MONOGRAM FOR YANG");
    map.put('\u268B', "MONOGRAM FOR YIN");
    map.put('\u268C', "DIGRAM FOR GREATER YANG");
    map.put('\u268D', "DIGRAM FOR LESSER YIN");
    map.put('\u268E', "DIGRAM FOR LESSER YANG");
    map.put('\u268F', "DIGRAM FOR GREATER YIN");
    map.put('\u2690', "WHITE FLAG");
    map.put('\u2691', "BLACK FLAG");
    map.put('\u2692', "HAMMER AND PICK");
    map.put('\u2693', "ANCHOR");
    map.put('\u2694', "CROSSED SWORDS");
    map.put('\u2695', "STAFF OF AESCULAPIUS");
    map.put('\u2696', "SCALES");
    map.put('\u2697', "ALEMBIC");
    map.put('\u2698', "FLOWER");
    map.put('\u2699', "GEAR");
    map.put('\u269A', "STAFF OF HERMES");
    map.put('\u269B', "ATOM SYMBOL");
    map.put('\u269C', "FLEUR-DE-LIS");
    map.put('\u269D', "OUTLINED WHITE STAR");
    map.put('\u269E', "THREE LINES CONVERGING RIGHT");
    map.put('\u269F', "THREE LINES CONVERGING LEFT");
    map.put('\u26A0', "WARNING SIGN");
    map.put('\u26A1', "HIGH VOLTAGE SIGN");
    map.put('\u26A2', "DOUBLED FEMALE SIGN");
    map.put('\u26A3', "DOUBLED MALE SIGN");
    map.put('\u26A4', "INTERLOCKED FEMALE AND MALE SIGN");
    map.put('\u26A5', "MALE AND FEMALE SIGN");
    map.put('\u26A6', "MALE WITH STROKE SIGN");
    map.put('\u26A7', "MALE WITH STROKE AND MALE AND FEMALE SIGN");
    map.put('\u26A8', "VERTICAL MALE WITH STROKE SIGN");
    map.put('\u26A9', "HORIZONTAL MALE WITH STROKE SIGN");
    map.put('\u26AA', "MEDIUM WHITE CIRCLE");
    map.put('\u26AB', "MEDIUM BLACK CIRCLE");
    map.put('\u26AC', "MEDIUM SMALL WHITE CIRCLE");
    map.put('\u26AD', "MARRIAGE SYMBOL");
    map.put('\u26AE', "DIVORCE SYMBOL");
    map.put('\u26AF', "UNMARRIED PARTNERSHIP SYMBOL");
    map.put('\u26B0', "COFFIN");
    map.put('\u26B1', "FUNERAL URN");
    map.put('\u26B2', "NEUTER");
    map.put('\u26B3', "CERES");
    map.put('\u26B4', "PALLAS");
    map.put('\u26B5', "JUNO");
    map.put('\u26B6', "VESTA");
    map.put('\u26B7', "CHIRON");
    map.put('\u26B8', "BLACK MOON LILITH");
    map.put('\u26B9', "SEXTILE");
    map.put('\u26BA', "SEMISEXTILE");
    map.put('\u26BB', "QUINCUNX");
    map.put('\u26BC', "SESQUIQUADRATE");
    map.put('\u26BD', "SOCCER BALL");
    map.put('\u26BE', "BASEBALL");
    map.put('\u26BF', "SQUARED KEY");
    map.put('\u26C0', "WHITE DRAUGHTS MAN");
    map.put('\u26C1', "WHITE DRAUGHTS KING");
    map.put('\u26C2', "BLACK DRAUGHTS MAN");
    map.put('\u26C3', "BLACK DRAUGHTS KING");
    map.put('\u26C4', "SNOWMAN WITHOUT SNOW");
    map.put('\u26C5', "SUN BEHIND CLOUD");
    map.put('\u26C6', "RAIN");
    map.put('\u26C7', "BLACK SNOWMAN");
    map.put('\u26C8', "THUNDER CLOUD AND RAIN");
    map.put('\u26C9', "TURNED WHITE SHOGI PIECE");
    map.put('\u26CA', "TURNED BLACK SHOGI PIECE");
    map.put('\u26CB', "WHITE DIAMOND IN SQUARE");
    map.put('\u26CC', "CROSSING LANES");
    map.put('\u26CD', "DISABLED CAR");
    map.put('\u26CF', "PICK");
    map.put('\u26D0', "CAR SLIDING");
    map.put('\u26D1', "HELMET WITH WHITE CROSS");
    map.put('\u26D2', "CIRCLED CROSSING LANES");
    map.put('\u26D3', "CHAINS");
    map.put('\u26D4', "NO ENTRY");
    map.put('\u26D5', "ALTERNATE ONE-WAY LEFT WAY TRAFFIC");
    map.put('\u26D6', "BLACK TWO-WAY LEFT WAY TRAFFIC");
    map.put('\u26D7', "WHITE TWO-WAY LEFT WAY TRAFFIC");
    map.put('\u26D8', "BLACK LEFT LANE MERGE");
    map.put('\u26D9', "WHITE LEFT LANE MERGE");
    map.put('\u26DA', "DRIVE SLOW SIGN");
    map.put('\u26DB', "HEAVY WHITE DOWN-POINTING TRIANGLE");
    map.put('\u26DC', "LEFT CLOSED ENTRY");
    map.put('\u26DD', "SQUARED SALTIRE");
    map.put('\u26DE', "FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE");
    map.put('\u26DF', "BLACK TRUCK");
    map.put('\u26E0', "RESTRICTED LEFT ENTRY-1");
    map.put('\u26E1', "RESTRICTED LEFT ENTRY-2");
    map.put('\u26E3', "HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE");
    map.put('\u26E8', "BLACK CROSS ON SHIELD");
    map.put('\u26E9', "SHINTO SHRINE");
    map.put('\u26EA', "CHURCH");
    map.put('\u26EB', "CASTLE");
    map.put('\u26EC', "HISTORIC SITE");
    map.put('\u26ED', "GEAR WITHOUT HUB");
    map.put('\u26EE', "GEAR WITH HANDLES");
    map.put('\u26EF', "MAP SYMBOL FOR LIGHTHOUSE");
    map.put('\u26F0', "MOUNTAIN");
    map.put('\u26F1', "UMBRELLA ON GROUND");
    map.put('\u26F2', "FOUNTAIN");
    map.put('\u26F3', "FLAG IN HOLE");
    map.put('\u26F4', "FERRY");
    map.put('\u26F5', "SAILBOAT");
    map.put('\u26F6', "SQUARE FOUR CORNERS");
    map.put('\u26F7', "SKIER");
    map.put('\u26F8', "ICE SKATE");
    map.put('\u26F9', "PERSON WITH BALL");
    map.put('\u26FA', "TENT");
    map.put('\u26FB', "JAPANESE BANK SYMBOL");
    map.put('\u26FC', "HEADSTONE GRAVEYARD SYMBOL");
    map.put('\u26FD', "FUEL PUMP");
    map.put('\u26FE', "CUP ON BLACK SQUARE");
    map.put('\u26FF', "WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE");
    map.put('\u2701', "UPPER BLADE SCISSORS");
    map.put('\u2702', "BLACK SCISSORS");
    map.put('\u2703', "LOWER BLADE SCISSORS");
    map.put('\u2704', "WHITE SCISSORS");
    map.put('\u2705', "<reserved>");
    map.put('\u2706', "TELEPHONE LOCATION SIGN");
    map.put('\u2707', "TAPE DRIVE");
    map.put('\u2708', "AIRPLANE");
    map.put('\u2709', "ENVELOPE");
    map.put('\u270A', "<reserved>");
    map.put('\u270B', "<reserved>");
    map.put('\u270C', "VICTORY HAND");
    map.put('\u270D', "WRITING HAND");
    map.put('\u270E', "LOWER RIGHT PENCIL");
    map.put('\u270F', "PENCIL");
    map.put('\u2710', "UPPER RIGHT PENCIL");
    map.put('\u2711', "WHITE NIB");
    map.put('\u2712', "BLACK NIB");
    map.put('\u2713', "CHECK MARK");
    map.put('\u2714', "HEAVY CHECK MARK");
    map.put('\u2715', "MULTIPLICATION X");
    map.put('\u2716', "HEAVY MULTIPLICATION X");
    map.put('\u2717', "BALLOT X");
    map.put('\u2718', "HEAVY BALLOT X");
    map.put('\u2719', "OUTLINED GREEK CROSS");
    map.put('\u271A', "HEAVY GREEK CROSS");
    map.put('\u271B', "OPEN CENTRE CROSS");
    map.put('\u271C', "HEAVY OPEN CENTRE CROSS");
    map.put('\u271D', "LATIN CROSS");
    map.put('\u271E', "SHADOWED WHITE LATIN CROSS");
    map.put('\u271F', "OUTLINED LATIN CROSS");
    map.put('\u2720', "MALTESE CROSS");
    map.put('\u2721', "STAR OF DAVID");
    map.put('\u2722', "FOUR TEARDROP-SPOKED ASTERISK");
    map.put('\u2723', "FOUR BALLOON-SPOKED ASTERISK");
    map.put('\u2724', "HEAVY FOUR BALLOON-SPOKED ASTERISK");
    map.put('\u2725', "FOUR CLUB-SPOKED ASTERISK");
    map.put('\u2726', "BLACK FOUR POINTED STAR");
    map.put('\u2727', "WHITE FOUR POINTED STAR");
    map.put('\u2728', "<reserved>");
    map.put('\u2729', "STRESS OUTLINED WHITE STAR");
    map.put('\u272A', "CIRCLED WHITE STAR");
    map.put('\u272B', "OPEN CENTRE BLACK STAR");
    map.put('\u272C', "BLACK CENTRE WHITE STAR");
    map.put('\u272D', "OUTLINED BLACK STAR");
    map.put('\u272E', "HEAVY OUTLINED BLACK STAR");
    map.put('\u272F', "PINWHEEL STAR");
    map.put('\u2730', "SHADOWED WHITE STAR");
    map.put('\u2731', "HEAVY ASTERISK");
    map.put('\u2732', "OPEN CENTRE ASTERISK");
    map.put('\u2733', "EIGHT SPOKED ASTERISK");
    map.put('\u2734', "EIGHT POINTED BLACK STAR");
    map.put('\u2735', "EIGHT POINTED PINWHEEL STAR");
    map.put('\u2736', "SIX POINTED BLACK STAR");
    map.put('\u2737', "EIGHT POINTED RECTILINEAR BLACK STAR");
    map.put('\u2738', "HEAVY EIGHT POINTED RECTILINEAR BLACK STAR");
    map.put('\u2739', "TWELVE POINTED BLACK STAR");
    map.put('\u273A', "SIXTEEN POINTED ASTERISK");
    map.put('\u273B', "TEARDROP-SPOKED ASTERISK");
    map.put('\u273C', "OPEN CENTRE TEARDROP-SPOKED ASTERISK");
    map.put('\u273D', "HEAVY TEARDROP-SPOKED ASTERISK");
    map.put('\u273E', "SIX PETALLED BLACK AND WHITE FLORETTE");
    map.put('\u273F', "BLACK FLORETTE");
    map.put('\u2740', "WHITE FLORETTE");
    map.put('\u2741', "EIGHT PETALLED OUTLINED BLACK FLORETTE");
    map.put('\u2742', "CIRCLED OPEN CENTRE EIGHT POINTED STAR");
    map.put('\u2743', "HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK");
    map.put('\u2744', "SNOWFLAKE");
    map.put('\u2745', "TIGHT TRIFOLIATE SNOWFLAKE");
    map.put('\u2746', "HEAVY CHEVRON SNOWFLAKE");
    map.put('\u2747', "SPARKLE");
    map.put('\u2748', "HEAVY SPARKLE");
    map.put('\u2749', "BALLOON-SPOKED ASTERISK");
    map.put('\u274A', "EIGHT TEARDROP-SPOKED PROPELLER ASTERISK");
    map.put('\u274B', "HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK");
    map.put('\u274C', "<reserved>");
    map.put('\u274D', "SHADOWED WHITE CIRCLE");
    map.put('\u274E', "<reserved>");
    map.put('\u274F', "LOWER RIGHT DROP-SHADOWED WHITE SQUARE");
    map.put('\u2750', "UPPER RIGHT DROP-SHADOWED WHITE SQUARE");
    map.put('\u2751', "LOWER RIGHT SHADOWED WHITE SQUARE");
    map.put('\u2752', "UPPER RIGHT SHADOWED WHITE SQUARE");
    map.put('\u2753', "<reserved>");
    map.put('\u2754', "<reserved>");
    map.put('\u2755', "<reserved>");
    map.put('\u2756', "BLACK DIAMOND MINUS WHITE X");
    map.put('\u2757', "HEAVY EXCLAMATION MARK SYMBOL");
    map.put('\u2758', "LIGHT VERTICAL BAR");
    map.put('\u2759', "MEDIUM VERTICAL BAR");
    map.put('\u275A', "HEAVY VERTICAL BAR");
    map.put('\u275B', "HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT");
    map.put('\u275C', "HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT");
    map.put('\u275D', "HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT");
    map.put('\u275E', "HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT");
    map.put('\u2761', "CURVED STEM PARAGRAPH SIGN ORNAMENT");
    map.put('\u2762', "HEAVY EXCLAMATION MARK ORNAMENT");
    map.put('\u2763', "HEAVY HEART EXCLAMATION MARK ORNAMENT");
    map.put('\u2764', "HEAVY BLACK HEART");
    map.put('\u2765', "ROTATED HEAVY BLACK HEART BULLET");
    map.put('\u2766', "FLORAL HEART");
    map.put('\u2767', "ROTATED FLORAL HEART BULLET");
    map.put('\u2768', "MEDIUM LEFT PARENTHESIS ORNAMENT");
    map.put('\u2769', "MEDIUM RIGHT PARENTHESIS ORNAMENT");
    map.put('\u276A', "MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT");
    map.put('\u276B', "MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT");
    map.put('\u276C', "MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT");
    map.put('\u276D', "MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT");
    map.put('\u276E', "HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT");
    map.put('\u276F', "HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT");
    map.put('\u2770', "HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT");
    map.put('\u2771', "HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT");
    map.put('\u2772', "LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT");
    map.put('\u2773', "LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT");
    map.put('\u2774', "MEDIUM LEFT CURLY BRACKET ORNAMENT");
    map.put('\u2775', "MEDIUM RIGHT CURLY BRACKET ORNAMENT");
    map.put('\u2776', "DINGBAT NEGATIVE CIRCLED DIGIT ONE");
    map.put('\u2777', "DINGBAT NEGATIVE CIRCLED DIGIT TWO");
    map.put('\u2778', "DINGBAT NEGATIVE CIRCLED DIGIT THREE");
    map.put('\u2779', "DINGBAT NEGATIVE CIRCLED DIGIT FOUR");
    map.put('\u277A', "DINGBAT NEGATIVE CIRCLED DIGIT FIVE");
    map.put('\u277B', "DINGBAT NEGATIVE CIRCLED DIGIT SIX");
    map.put('\u277C', "DINGBAT NEGATIVE CIRCLED DIGIT SEVEN");
    map.put('\u277D', "DINGBAT NEGATIVE CIRCLED DIGIT EIGHT");
    map.put('\u277E', "DINGBAT NEGATIVE CIRCLED DIGIT NINE");
    map.put('\u277F', "DINGBAT NEGATIVE CIRCLED NUMBER TEN");
    map.put('\u2780', "DINGBAT CIRCLED SANS-SERIF DIGIT ONE");
    map.put('\u2781', "DINGBAT CIRCLED SANS-SERIF DIGIT TWO");
    map.put('\u2782', "DINGBAT CIRCLED SANS-SERIF DIGIT THREE");
    map.put('\u2783', "DINGBAT CIRCLED SANS-SERIF DIGIT FOUR");
    map.put('\u2784', "DINGBAT CIRCLED SANS-SERIF DIGIT FIVE");
    map.put('\u2785', "DINGBAT CIRCLED SANS-SERIF DIGIT SIX");
    map.put('\u2786', "DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN");
    map.put('\u2787', "DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT");
    map.put('\u2788', "DINGBAT CIRCLED SANS-SERIF DIGIT NINE");
    map.put('\u2789', "DINGBAT CIRCLED SANS-SERIF NUMBER TEN");
    map.put('\u278A', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE");
    map.put('\u278B', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO");
    map.put('\u278C', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE");
    map.put('\u278D', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR");
    map.put('\u278E', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE");
    map.put('\u278F', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX");
    map.put('\u2790', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN");
    map.put('\u2791', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT");
    map.put('\u2792', "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE");
    map.put('\u2793', "DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN");
    map.put('\u2794', "HEAVY WIDE-HEADED RIGHTWARDS ARROW");
    map.put('\u2795', "<reserved>");
    map.put('\u2796', "<reserved>");
    map.put('\u2797', "<reserved>");
    map.put('\u2798', "HEAVY SOUTH EAST ARROW");
    map.put('\u2799', "HEAVY RIGHTWARDS ARROW");
    map.put('\u279A', "HEAVY NORTH EAST ARROW");
    map.put('\u279B', "DRAFTING POINT RIGHTWARDS ARROW");
    map.put('\u279C', "HEAVY ROUND-TIPPED RIGHTWARDS ARROW");
    map.put('\u279D', "TRIANGLE-HEADED RIGHTWARDS ARROW");
    map.put('\u279E', "HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW");
    map.put('\u279F', "DASHED TRIANGLE-HEADED RIGHTWARDS ARROW");
    map.put('\u27A0', "HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW");
    map.put('\u27A1', "BLACK RIGHTWARDS ARROW");
    map.put('\u27A2', "THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD");
    map.put('\u27A3', "THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD");
    map.put('\u27A4', "BLACK RIGHTWARDS ARROWHEAD");
    map.put('\u27A5', "HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW");
    map.put('\u27A6', "HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW");
    map.put('\u27A7', "SQUAT BLACK RIGHTWARDS ARROW");
    map.put('\u27A8', "HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW");
    map.put('\u27A9', "RIGHT-SHADED WHITE RIGHTWARDS ARROW");
    map.put('\u27AA', "LEFT-SHADED WHITE RIGHTWARDS ARROW");
    map.put('\u27AB', "BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW");
    map.put('\u27AC', "FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW");
    map.put('\u27AD', "HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW");
    map.put('\u27AE', "HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW");
    map.put('\u27AF', "NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW");
    map.put('\u27B1', "NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW");
    map.put('\u27B2', "CIRCLED HEAVY WHITE RIGHTWARDS ARROW");
    map.put('\u27B3', "WHITE-FEATHERED RIGHTWARDS ARROW");
    map.put('\u27B4', "BLACK-FEATHERED SOUTH EAST ARROW");
    map.put('\u27B5', "BLACK-FEATHERED RIGHTWARDS ARROW");
    map.put('\u27B6', "BLACK-FEATHERED NORTH EAST ARROW");
    map.put('\u27B7', "HEAVY BLACK-FEATHERED SOUTH EAST ARROW");
    map.put('\u27B8', "HEAVY BLACK-FEATHERED RIGHTWARDS ARROW");
    map.put('\u27B9', "HEAVY BLACK-FEATHERED NORTH EAST ARROW");
    map.put('\u27BA', "TEARDROP-BARBED RIGHTWARDS ARROW");
    map.put('\u27BB', "HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW");
    map.put('\u27BC', "WEDGE-TAILED RIGHTWARDS ARROW");
    map.put('\u27BD', "HEAVY WEDGE-TAILED RIGHTWARDS ARROW");
    map.put('\u27BE', "OPEN-OUTLINED RIGHTWARDS ARROW");
    map.put('\u27C0', "THREE DIMENSIONAL ANGLE");
    map.put('\u27C1', "WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE");
    map.put('\u27C2', "PERPENDICULAR");
    map.put('\u27C3', "OPEN SUBSET");
    map.put('\u27C4', "OPEN SUPERSET");
    map.put('\u27C5', "LEFT S-SHAPED BAG DELIMITER");
    map.put('\u27C6', "RIGHT S-SHAPED BAG DELIMITER");
    map.put('\u27C7', "OR WITH DOT INSIDE");
    map.put('\u27C8', "REVERSE SOLIDUS PRECEDING SUBSET");
    map.put('\u27C9', "SUPERSET PRECEDING SOLIDUS");
    map.put('\u27CA', "VERTICAL BAR WITH HORIZONTAL STROKE");
    map.put('\u27CC', "LONG DIVISION");
    map.put('\u27D0', "WHITE DIAMOND WITH CENTRED DOT");
    map.put('\u27D1', "AND WITH DOT");
    map.put('\u27D2', "ELEMENT OF OPENING UPWARDS");
    map.put('\u27D3', "LOWER RIGHT CORNER WITH DOT");
    map.put('\u27D4', "UPPER LEFT CORNER WITH DOT");
    map.put('\u27D5', "LEFT OUTER JOIN");
    map.put('\u27D6', "RIGHT OUTER JOIN");
    map.put('\u27D7', "FULL OUTER JOIN");
    map.put('\u27D8', "LARGE UP TACK");
    map.put('\u27D9', "LARGE DOWN TACK");
    map.put('\u27DA', "LEFT AND RIGHT DOUBLE TURNSTILE");
    map.put('\u27DB', "LEFT AND RIGHT TACK");
    map.put('\u27DC', "LEFT MULTIMAP");
    map.put('\u27DD', "LONG RIGHT TACK");
    map.put('\u27DE', "LONG LEFT TACK");
    map.put('\u27DF', "UP TACK WITH CIRCLE ABOVE");
    map.put('\u27E0', "LOZENGE DIVIDED BY HORIZONTAL RULE");
    map.put('\u27E1', "WHITE CONCAVE-SIDED DIAMOND");
    map.put('\u27E2', "WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK");
    map.put('\u27E3', "WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK");
    map.put('\u27E4', "WHITE SQUARE WITH LEFTWARDS TICK");
    map.put('\u27E5', "WHITE SQUARE WITH RIGHTWARDS TICK");
    map.put('\u27E6', "MATHEMATICAL LEFT WHITE SQUARE BRACKET");
    map.put('\u27E7', "MATHEMATICAL RIGHT WHITE SQUARE BRACKET");
    map.put('\u27E8', "MATHEMATICAL LEFT ANGLE BRACKET");
    map.put('\u27E9', "MATHEMATICAL RIGHT ANGLE BRACKET");
    map.put('\u27EA', "MATHEMATICAL LEFT DOUBLE ANGLE BRACKET");
    map.put('\u27EB', "MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET");
    map.put('\u27EC', "MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET");
    map.put('\u27ED', "MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET");
    map.put('\u27EE', "MATHEMATICAL LEFT FLATTENED PARENTHESIS");
    map.put('\u27EF', "MATHEMATICAL RIGHT FLATTENED PARENTHESIS");
    map.put('\u27F0', "UPWARDS QUADRUPLE ARROW");
    map.put('\u27F1', "DOWNWARDS QUADRUPLE ARROW");
    map.put('\u27F2', "ANTICLOCKWISE GAPPED CIRCLE ARROW");
    map.put('\u27F3', "CLOCKWISE GAPPED CIRCLE ARROW");
    map.put('\u27F4', "RIGHT ARROW WITH CIRCLED PLUS");
    map.put('\u27F5', "LONG LEFTWARDS ARROW");
    map.put('\u27F6', "LONG RIGHTWARDS ARROW");
    map.put('\u27F7', "LONG LEFT RIGHT ARROW");
    map.put('\u27F8', "LONG LEFTWARDS DOUBLE ARROW");
    map.put('\u27F9', "LONG RIGHTWARDS DOUBLE ARROW");
    map.put('\u27FA', "LONG LEFT RIGHT DOUBLE ARROW");
    map.put('\u27FB', "LONG LEFTWARDS ARROW FROM BAR");
    map.put('\u27FC', "LONG RIGHTWARDS ARROW FROM BAR");
    map.put('\u27FD', "LONG LEFTWARDS DOUBLE ARROW FROM BAR");
    map.put('\u27FE', "LONG RIGHTWARDS DOUBLE ARROW FROM BAR");
    map.put('\u27FF', "LONG RIGHTWARDS SQUIGGLE ARROW");
    map.put('\u2800', "BRAILLE PATTERN BLANK");
    map.put('\u2801', "BRAILLE PATTERN DOTS-1");
    map.put('\u2802', "BRAILLE PATTERN DOTS-2");
    map.put('\u2803', "BRAILLE PATTERN DOTS-12");
    map.put('\u2804', "BRAILLE PATTERN DOTS-3");
    map.put('\u2805', "BRAILLE PATTERN DOTS-13");
    map.put('\u2806', "BRAILLE PATTERN DOTS-23");
    map.put('\u2807', "BRAILLE PATTERN DOTS-123");
    map.put('\u2808', "BRAILLE PATTERN DOTS-4");
    map.put('\u2809', "BRAILLE PATTERN DOTS-14");
    map.put('\u280A', "BRAILLE PATTERN DOTS-24");
    map.put('\u280B', "BRAILLE PATTERN DOTS-124");
    map.put('\u280C', "BRAILLE PATTERN DOTS-34");
    map.put('\u280D', "BRAILLE PATTERN DOTS-134");
    map.put('\u280E', "BRAILLE PATTERN DOTS-234");
    map.put('\u280F', "BRAILLE PATTERN DOTS-1234");
    map.put('\u2810', "BRAILLE PATTERN DOTS-5");
    map.put('\u2811', "BRAILLE PATTERN DOTS-15");
    map.put('\u2812', "BRAILLE PATTERN DOTS-25");
    map.put('\u2813', "BRAILLE PATTERN DOTS-125");
    map.put('\u2814', "BRAILLE PATTERN DOTS-35");
    map.put('\u2815', "BRAILLE PATTERN DOTS-135");
    map.put('\u2816', "BRAILLE PATTERN DOTS-235");
    map.put('\u2817', "BRAILLE PATTERN DOTS-1235");
    map.put('\u2818', "BRAILLE PATTERN DOTS-45");
    map.put('\u2819', "BRAILLE PATTERN DOTS-145");
    map.put('\u281A', "BRAILLE PATTERN DOTS-245");
    map.put('\u281B', "BRAILLE PATTERN DOTS-1245");
    map.put('\u281C', "BRAILLE PATTERN DOTS-345");
    map.put('\u281D', "BRAILLE PATTERN DOTS-1345");
    map.put('\u281E', "BRAILLE PATTERN DOTS-2345");
    map.put('\u281F', "BRAILLE PATTERN DOTS-12345");
    map.put('\u2820', "BRAILLE PATTERN DOTS-6");
    map.put('\u2821', "BRAILLE PATTERN DOTS-16");
    map.put('\u2822', "BRAILLE PATTERN DOTS-26");
    map.put('\u2823', "BRAILLE PATTERN DOTS-126");
    map.put('\u2824', "BRAILLE PATTERN DOTS-36");
    map.put('\u2825', "BRAILLE PATTERN DOTS-136");
    map.put('\u2826', "BRAILLE PATTERN DOTS-236");
    map.put('\u2827', "BRAILLE PATTERN DOTS-1236");
    map.put('\u2828', "BRAILLE PATTERN DOTS-46");
    map.put('\u2829', "BRAILLE PATTERN DOTS-146");
    map.put('\u282A', "BRAILLE PATTERN DOTS-246");
    map.put('\u282B', "BRAILLE PATTERN DOTS-1246");
    map.put('\u282C', "BRAILLE PATTERN DOTS-346");
    map.put('\u282D', "BRAILLE PATTERN DOTS-1346");
    map.put('\u282E', "BRAILLE PATTERN DOTS-2346");
    map.put('\u282F', "BRAILLE PATTERN DOTS-12346");
    map.put('\u2830', "BRAILLE PATTERN DOTS-56");
    map.put('\u2831', "BRAILLE PATTERN DOTS-156");
    map.put('\u2832', "BRAILLE PATTERN DOTS-256");
    map.put('\u2833', "BRAILLE PATTERN DOTS-1256");
    map.put('\u2834', "BRAILLE PATTERN DOTS-356");
    map.put('\u2835', "BRAILLE PATTERN DOTS-1356");
    map.put('\u2836', "BRAILLE PATTERN DOTS-2356");
    map.put('\u2837', "BRAILLE PATTERN DOTS-12356");
    map.put('\u2838', "BRAILLE PATTERN DOTS-456");
    map.put('\u2839', "BRAILLE PATTERN DOTS-1456");
    map.put('\u283A', "BRAILLE PATTERN DOTS-2456");
    map.put('\u283B', "BRAILLE PATTERN DOTS-12456");
    map.put('\u283C', "BRAILLE PATTERN DOTS-3456");
    map.put('\u283D', "BRAILLE PATTERN DOTS-13456");
    map.put('\u283E', "BRAILLE PATTERN DOTS-23456");
    map.put('\u283F', "BRAILLE PATTERN DOTS-123456");
    map.put('\u2840', "BRAILLE PATTERN DOTS-7");
    map.put('\u2841', "BRAILLE PATTERN DOTS-17");
    map.put('\u2842', "BRAILLE PATTERN DOTS-27");
    map.put('\u2843', "BRAILLE PATTERN DOTS-127");
    map.put('\u2844', "BRAILLE PATTERN DOTS-37");
    map.put('\u2845', "BRAILLE PATTERN DOTS-137");
    map.put('\u2846', "BRAILLE PATTERN DOTS-237");
    map.put('\u2847', "BRAILLE PATTERN DOTS-1237");
    map.put('\u2848', "BRAILLE PATTERN DOTS-47");
    map.put('\u2849', "BRAILLE PATTERN DOTS-147");
    map.put('\u284A', "BRAILLE PATTERN DOTS-247");
    map.put('\u284B', "BRAILLE PATTERN DOTS-1247");
    map.put('\u284C', "BRAILLE PATTERN DOTS-347");
    map.put('\u284D', "BRAILLE PATTERN DOTS-1347");
    map.put('\u284E', "BRAILLE PATTERN DOTS-2347");
    map.put('\u284F', "BRAILLE PATTERN DOTS-12347");
    map.put('\u2850', "BRAILLE PATTERN DOTS-57");
    map.put('\u2851', "BRAILLE PATTERN DOTS-157");
    map.put('\u2852', "BRAILLE PATTERN DOTS-257");
    map.put('\u2853', "BRAILLE PATTERN DOTS-1257");
    map.put('\u2854', "BRAILLE PATTERN DOTS-357");
    map.put('\u2855', "BRAILLE PATTERN DOTS-1357");
    map.put('\u2856', "BRAILLE PATTERN DOTS-2357");
    map.put('\u2857', "BRAILLE PATTERN DOTS-12357");
    map.put('\u2858', "BRAILLE PATTERN DOTS-457");
    map.put('\u2859', "BRAILLE PATTERN DOTS-1457");
    map.put('\u285A', "BRAILLE PATTERN DOTS-2457");
    map.put('\u285B', "BRAILLE PATTERN DOTS-12457");
    map.put('\u285C', "BRAILLE PATTERN DOTS-3457");
    map.put('\u285D', "BRAILLE PATTERN DOTS-13457");
    map.put('\u285E', "BRAILLE PATTERN DOTS-23457");
    map.put('\u285F', "BRAILLE PATTERN DOTS-123457");
    map.put('\u2860', "BRAILLE PATTERN DOTS-67");
    map.put('\u2861', "BRAILLE PATTERN DOTS-167");
    map.put('\u2862', "BRAILLE PATTERN DOTS-267");
    map.put('\u2863', "BRAILLE PATTERN DOTS-1267");
    map.put('\u2864', "BRAILLE PATTERN DOTS-367");
    map.put('\u2865', "BRAILLE PATTERN DOTS-1367");
    map.put('\u2866', "BRAILLE PATTERN DOTS-2367");
    map.put('\u2867', "BRAILLE PATTERN DOTS-12367");
    map.put('\u2868', "BRAILLE PATTERN DOTS-467");
    map.put('\u2869', "BRAILLE PATTERN DOTS-1467");
    map.put('\u286A', "BRAILLE PATTERN DOTS-2467");
    map.put('\u286B', "BRAILLE PATTERN DOTS-12467");
    map.put('\u286C', "BRAILLE PATTERN DOTS-3467");
    map.put('\u286D', "BRAILLE PATTERN DOTS-13467");
    map.put('\u286E', "BRAILLE PATTERN DOTS-23467");
    map.put('\u286F', "BRAILLE PATTERN DOTS-123467");
    map.put('\u2870', "BRAILLE PATTERN DOTS-567");
    map.put('\u2871', "BRAILLE PATTERN DOTS-1567");
    map.put('\u2872', "BRAILLE PATTERN DOTS-2567");
    map.put('\u2873', "BRAILLE PATTERN DOTS-12567");
    map.put('\u2874', "BRAILLE PATTERN DOTS-3567");
    map.put('\u2875', "BRAILLE PATTERN DOTS-13567");
    map.put('\u2876', "BRAILLE PATTERN DOTS-23567");
    map.put('\u2877', "BRAILLE PATTERN DOTS-123567");
    map.put('\u2878', "BRAILLE PATTERN DOTS-4567");
    map.put('\u2879', "BRAILLE PATTERN DOTS-14567");
    map.put('\u287A', "BRAILLE PATTERN DOTS-24567");
    map.put('\u287B', "BRAILLE PATTERN DOTS-124567");
    map.put('\u287C', "BRAILLE PATTERN DOTS-34567");
    map.put('\u287D', "BRAILLE PATTERN DOTS-134567");
    map.put('\u287E', "BRAILLE PATTERN DOTS-234567");
    map.put('\u287F', "BRAILLE PATTERN DOTS-1234567");
    map.put('\u2880', "BRAILLE PATTERN DOTS-8");
    map.put('\u2881', "BRAILLE PATTERN DOTS-18");
    map.put('\u2882', "BRAILLE PATTERN DOTS-28");
    map.put('\u2883', "BRAILLE PATTERN DOTS-128");
    map.put('\u2884', "BRAILLE PATTERN DOTS-38");
    map.put('\u2885', "BRAILLE PATTERN DOTS-138");
    map.put('\u2886', "BRAILLE PATTERN DOTS-238");
    map.put('\u2887', "BRAILLE PATTERN DOTS-1238");
    map.put('\u2888', "BRAILLE PATTERN DOTS-48");
    map.put('\u2889', "BRAILLE PATTERN DOTS-148");
    map.put('\u288A', "BRAILLE PATTERN DOTS-248");
    map.put('\u288B', "BRAILLE PATTERN DOTS-1248");
    map.put('\u288C', "BRAILLE PATTERN DOTS-348");
    map.put('\u288D', "BRAILLE PATTERN DOTS-1348");
    map.put('\u288E', "BRAILLE PATTERN DOTS-2348");
    map.put('\u288F', "BRAILLE PATTERN DOTS-12348");
    map.put('\u2890', "BRAILLE PATTERN DOTS-58");
    map.put('\u2891', "BRAILLE PATTERN DOTS-158");
    map.put('\u2892', "BRAILLE PATTERN DOTS-258");
    map.put('\u2893', "BRAILLE PATTERN DOTS-1258");
    map.put('\u2894', "BRAILLE PATTERN DOTS-358");
    map.put('\u2895', "BRAILLE PATTERN DOTS-1358");
    map.put('\u2896', "BRAILLE PATTERN DOTS-2358");
    map.put('\u2897', "BRAILLE PATTERN DOTS-12358");
    map.put('\u2898', "BRAILLE PATTERN DOTS-458");
    map.put('\u2899', "BRAILLE PATTERN DOTS-1458");
    map.put('\u289A', "BRAILLE PATTERN DOTS-2458");
    map.put('\u289B', "BRAILLE PATTERN DOTS-12458");
    map.put('\u289C', "BRAILLE PATTERN DOTS-3458");
    map.put('\u289D', "BRAILLE PATTERN DOTS-13458");
    map.put('\u289E', "BRAILLE PATTERN DOTS-23458");
    map.put('\u289F', "BRAILLE PATTERN DOTS-123458");
    map.put('\u28A0', "BRAILLE PATTERN DOTS-68");
    map.put('\u28A1', "BRAILLE PATTERN DOTS-168");
    map.put('\u28A2', "BRAILLE PATTERN DOTS-268");
    map.put('\u28A3', "BRAILLE PATTERN DOTS-1268");
    map.put('\u28A4', "BRAILLE PATTERN DOTS-368");
    map.put('\u28A5', "BRAILLE PATTERN DOTS-1368");
    map.put('\u28A6', "BRAILLE PATTERN DOTS-2368");
    map.put('\u28A7', "BRAILLE PATTERN DOTS-12368");
    map.put('\u28A8', "BRAILLE PATTERN DOTS-468");
    map.put('\u28A9', "BRAILLE PATTERN DOTS-1468");
    map.put('\u28AA', "BRAILLE PATTERN DOTS-2468");
    map.put('\u28AB', "BRAILLE PATTERN DOTS-12468");
    map.put('\u28AC', "BRAILLE PATTERN DOTS-3468");
    map.put('\u28AD', "BRAILLE PATTERN DOTS-13468");
    map.put('\u28AE', "BRAILLE PATTERN DOTS-23468");
    map.put('\u28AF', "BRAILLE PATTERN DOTS-123468");
    map.put('\u28B0', "BRAILLE PATTERN DOTS-568");
    map.put('\u28B1', "BRAILLE PATTERN DOTS-1568");
    map.put('\u28B2', "BRAILLE PATTERN DOTS-2568");
    map.put('\u28B3', "BRAILLE PATTERN DOTS-12568");
    map.put('\u28B4', "BRAILLE PATTERN DOTS-3568");
    map.put('\u28B5', "BRAILLE PATTERN DOTS-13568");
    map.put('\u28B6', "BRAILLE PATTERN DOTS-23568");
    map.put('\u28B7', "BRAILLE PATTERN DOTS-123568");
    map.put('\u28B8', "BRAILLE PATTERN DOTS-4568");
    map.put('\u28B9', "BRAILLE PATTERN DOTS-14568");
    map.put('\u28BA', "BRAILLE PATTERN DOTS-24568");
    map.put('\u28BB', "BRAILLE PATTERN DOTS-124568");
    map.put('\u28BC', "BRAILLE PATTERN DOTS-34568");
    map.put('\u28BD', "BRAILLE PATTERN DOTS-134568");
    map.put('\u28BE', "BRAILLE PATTERN DOTS-234568");
    map.put('\u28BF', "BRAILLE PATTERN DOTS-1234568");
    map.put('\u28C0', "BRAILLE PATTERN DOTS-78");
    map.put('\u28C1', "BRAILLE PATTERN DOTS-178");
    map.put('\u28C2', "BRAILLE PATTERN DOTS-278");
    map.put('\u28C3', "BRAILLE PATTERN DOTS-1278");
    map.put('\u28C4', "BRAILLE PATTERN DOTS-378");
    map.put('\u28C5', "BRAILLE PATTERN DOTS-1378");
    map.put('\u28C6', "BRAILLE PATTERN DOTS-2378");
    map.put('\u28C7', "BRAILLE PATTERN DOTS-12378");
    map.put('\u28C8', "BRAILLE PATTERN DOTS-478");
    map.put('\u28C9', "BRAILLE PATTERN DOTS-1478");
    map.put('\u28CA', "BRAILLE PATTERN DOTS-2478");
    map.put('\u28CB', "BRAILLE PATTERN DOTS-12478");
    map.put('\u28CC', "BRAILLE PATTERN DOTS-3478");
    map.put('\u28CD', "BRAILLE PATTERN DOTS-13478");
    map.put('\u28CE', "BRAILLE PATTERN DOTS-23478");
    map.put('\u28CF', "BRAILLE PATTERN DOTS-123478");
    map.put('\u28D0', "BRAILLE PATTERN DOTS-578");
    map.put('\u28D1', "BRAILLE PATTERN DOTS-1578");
    map.put('\u28D2', "BRAILLE PATTERN DOTS-2578");
    map.put('\u28D3', "BRAILLE PATTERN DOTS-12578");
    map.put('\u28D4', "BRAILLE PATTERN DOTS-3578");
    map.put('\u28D5', "BRAILLE PATTERN DOTS-13578");
    map.put('\u28D6', "BRAILLE PATTERN DOTS-23578");
    map.put('\u28D7', "BRAILLE PATTERN DOTS-123578");
    map.put('\u28D8', "BRAILLE PATTERN DOTS-4578");
    map.put('\u28D9', "BRAILLE PATTERN DOTS-14578");
    map.put('\u28DA', "BRAILLE PATTERN DOTS-24578");
    map.put('\u28DB', "BRAILLE PATTERN DOTS-124578");
    map.put('\u28DC', "BRAILLE PATTERN DOTS-34578");
    map.put('\u28DD', "BRAILLE PATTERN DOTS-134578");
    map.put('\u28DE', "BRAILLE PATTERN DOTS-234578");
    map.put('\u28DF', "BRAILLE PATTERN DOTS-1234578");
    map.put('\u28E0', "BRAILLE PATTERN DOTS-678");
    map.put('\u28E1', "BRAILLE PATTERN DOTS-1678");
    map.put('\u28E2', "BRAILLE PATTERN DOTS-2678");
    map.put('\u28E3', "BRAILLE PATTERN DOTS-12678");
    map.put('\u28E4', "BRAILLE PATTERN DOTS-3678");
    map.put('\u28E5', "BRAILLE PATTERN DOTS-13678");
    map.put('\u28E6', "BRAILLE PATTERN DOTS-23678");
    map.put('\u28E7', "BRAILLE PATTERN DOTS-123678");
    map.put('\u28E8', "BRAILLE PATTERN DOTS-4678");
    map.put('\u28E9', "BRAILLE PATTERN DOTS-14678");
    map.put('\u28EA', "BRAILLE PATTERN DOTS-24678");
    map.put('\u28EB', "BRAILLE PATTERN DOTS-124678");
    map.put('\u28EC', "BRAILLE PATTERN DOTS-34678");
    map.put('\u28ED', "BRAILLE PATTERN DOTS-134678");
    map.put('\u28EE', "BRAILLE PATTERN DOTS-234678");
    map.put('\u28EF', "BRAILLE PATTERN DOTS-1234678");
    map.put('\u28F0', "BRAILLE PATTERN DOTS-5678");
    map.put('\u28F1', "BRAILLE PATTERN DOTS-15678");
    map.put('\u28F2', "BRAILLE PATTERN DOTS-25678");
    map.put('\u28F3', "BRAILLE PATTERN DOTS-125678");
    map.put('\u28F4', "BRAILLE PATTERN DOTS-35678");
    map.put('\u28F5', "BRAILLE PATTERN DOTS-135678");
    map.put('\u28F6', "BRAILLE PATTERN DOTS-235678");
    map.put('\u28F7', "BRAILLE PATTERN DOTS-1235678");
    map.put('\u28F8', "BRAILLE PATTERN DOTS-45678");
    map.put('\u28F9', "BRAILLE PATTERN DOTS-145678");
    map.put('\u28FA', "BRAILLE PATTERN DOTS-245678");
    map.put('\u28FB', "BRAILLE PATTERN DOTS-1245678");
    map.put('\u28FC', "BRAILLE PATTERN DOTS-345678");
    map.put('\u28FD', "BRAILLE PATTERN DOTS-1345678");
    map.put('\u28FE', "BRAILLE PATTERN DOTS-2345678");
    map.put('\u28FF', "BRAILLE PATTERN DOTS-12345678");
    map.put('\u2900', "RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE");
    map.put('\u2901', "RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE");
    map.put('\u2902', "LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE");
    map.put('\u2903', "RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE");
    map.put('\u2904', "LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE");
    map.put('\u2905', "RIGHTWARDS TWO-HEADED ARROW FROM BAR");
    map.put('\u2906', "LEFTWARDS DOUBLE ARROW FROM BAR");
    map.put('\u2907', "RIGHTWARDS DOUBLE ARROW FROM BAR");
    map.put('\u2908', "DOWNWARDS ARROW WITH HORIZONTAL STROKE");
    map.put('\u2909', "UPWARDS ARROW WITH HORIZONTAL STROKE");
    map.put('\u290A', "UPWARDS TRIPLE ARROW");
    map.put('\u290B', "DOWNWARDS TRIPLE ARROW");
    map.put('\u290C', "LEFTWARDS DOUBLE DASH ARROW");
    map.put('\u290D', "RIGHTWARDS DOUBLE DASH ARROW");
    map.put('\u290E', "LEFTWARDS TRIPLE DASH ARROW");
    map.put('\u290F', "RIGHTWARDS TRIPLE DASH ARROW");
    map.put('\u2910', "RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW");
    map.put('\u2911', "RIGHTWARDS ARROW WITH DOTTED STEM");
    map.put('\u2912', "UPWARDS ARROW TO BAR");
    map.put('\u2913', "DOWNWARDS ARROW TO BAR");
    map.put('\u2914', "RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE");
    map.put('\u2915', "RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE");
    map.put('\u2916', "RIGHTWARDS TWO-HEADED ARROW WITH TAIL");
    map.put('\u2917', "RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE");
    map.put('\u2918', "RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE");
    map.put('\u2919', "LEFTWARDS ARROW-TAIL");
    map.put('\u291A', "RIGHTWARDS ARROW-TAIL");
    map.put('\u291B', "LEFTWARDS DOUBLE ARROW-TAIL");
    map.put('\u291C', "RIGHTWARDS DOUBLE ARROW-TAIL");
    map.put('\u291D', "LEFTWARDS ARROW TO BLACK DIAMOND");
    map.put('\u291E', "RIGHTWARDS ARROW TO BLACK DIAMOND");
    map.put('\u291F', "LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND");
    map.put('\u2920', "RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND");
    map.put('\u2921', "NORTH WEST AND SOUTH EAST ARROW");
    map.put('\u2922', "NORTH EAST AND SOUTH WEST ARROW");
    map.put('\u2923', "NORTH WEST ARROW WITH HOOK");
    map.put('\u2924', "NORTH EAST ARROW WITH HOOK");
    map.put('\u2925', "SOUTH EAST ARROW WITH HOOK");
    map.put('\u2926', "SOUTH WEST ARROW WITH HOOK");
    map.put('\u2927', "NORTH WEST ARROW AND NORTH EAST ARROW");
    map.put('\u2928', "NORTH EAST ARROW AND SOUTH EAST ARROW");
    map.put('\u2929', "SOUTH EAST ARROW AND SOUTH WEST ARROW");
    map.put('\u292A', "SOUTH WEST ARROW AND NORTH WEST ARROW");
    map.put('\u292B', "RISING DIAGONAL CROSSING FALLING DIAGONAL");
    map.put('\u292C', "FALLING DIAGONAL CROSSING RISING DIAGONAL");
    map.put('\u292D', "SOUTH EAST ARROW CROSSING NORTH EAST ARROW");
    map.put('\u292E', "NORTH EAST ARROW CROSSING SOUTH EAST ARROW");
    map.put('\u292F', "FALLING DIAGONAL CROSSING NORTH EAST ARROW");
    map.put('\u2930', "RISING DIAGONAL CROSSING SOUTH EAST ARROW");
    map.put('\u2931', "NORTH EAST ARROW CROSSING NORTH WEST ARROW");
    map.put('\u2932', "NORTH WEST ARROW CROSSING NORTH EAST ARROW");
    map.put('\u2933', "WAVE ARROW POINTING DIRECTLY RIGHT");
    map.put('\u2934', "ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS");
    map.put('\u2935', "ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS");
    map.put('\u2936', "ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS");
    map.put('\u2937', "ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS");
    map.put('\u2938', "RIGHT-SIDE ARC CLOCKWISE ARROW");
    map.put('\u2939', "LEFT-SIDE ARC ANTICLOCKWISE ARROW");
    map.put('\u293A', "TOP ARC ANTICLOCKWISE ARROW");
    map.put('\u293B', "BOTTOM ARC ANTICLOCKWISE ARROW");
    map.put('\u293C', "TOP ARC CLOCKWISE ARROW WITH MINUS");
    map.put('\u293D', "TOP ARC ANTICLOCKWISE ARROW WITH PLUS");
    map.put('\u293E', "LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW");
    map.put('\u293F', "LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW");
    map.put('\u2940', "ANTICLOCKWISE CLOSED CIRCLE ARROW");
    map.put('\u2941', "CLOCKWISE CLOSED CIRCLE ARROW");
    map.put('\u2942', "RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW");
    map.put('\u2943', "LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW");
    map.put('\u2944', "SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW");
    map.put('\u2945', "RIGHTWARDS ARROW WITH PLUS BELOW");
    map.put('\u2946', "LEFTWARDS ARROW WITH PLUS BELOW");
    map.put('\u2947', "RIGHTWARDS ARROW THROUGH X");
    map.put('\u2948', "LEFT RIGHT ARROW THROUGH SMALL CIRCLE");
    map.put('\u2949', "UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE");
    map.put('\u294A', "LEFT BARB UP RIGHT BARB DOWN HARPOON");
    map.put('\u294B', "LEFT BARB DOWN RIGHT BARB UP HARPOON");
    map.put('\u294C', "UP BARB RIGHT DOWN BARB LEFT HARPOON");
    map.put('\u294D', "UP BARB LEFT DOWN BARB RIGHT HARPOON");
    map.put('\u294E', "LEFT BARB UP RIGHT BARB UP HARPOON");
    map.put('\u294F', "UP BARB RIGHT DOWN BARB RIGHT HARPOON");
    map.put('\u2950', "LEFT BARB DOWN RIGHT BARB DOWN HARPOON");
    map.put('\u2951', "UP BARB LEFT DOWN BARB LEFT HARPOON");
    map.put('\u2952', "LEFTWARDS HARPOON WITH BARB UP TO BAR");
    map.put('\u2953', "RIGHTWARDS HARPOON WITH BARB UP TO BAR");
    map.put('\u2954', "UPWARDS HARPOON WITH BARB RIGHT TO BAR");
    map.put('\u2955', "DOWNWARDS HARPOON WITH BARB RIGHT TO BAR");
    map.put('\u2956', "LEFTWARDS HARPOON WITH BARB DOWN TO BAR");
    map.put('\u2957', "RIGHTWARDS HARPOON WITH BARB DOWN TO BAR");
    map.put('\u2958', "UPWARDS HARPOON WITH BARB LEFT TO BAR");
    map.put('\u2959', "DOWNWARDS HARPOON WITH BARB LEFT TO BAR");
    map.put('\u295A', "LEFTWARDS HARPOON WITH BARB UP FROM BAR");
    map.put('\u295B', "RIGHTWARDS HARPOON WITH BARB UP FROM BAR");
    map.put('\u295C', "UPWARDS HARPOON WITH BARB RIGHT FROM BAR");
    map.put('\u295D', "DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR");
    map.put('\u295E', "LEFTWARDS HARPOON WITH BARB DOWN FROM BAR");
    map.put('\u295F', "RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR");
    map.put('\u2960', "UPWARDS HARPOON WITH BARB LEFT FROM BAR");
    map.put('\u2961', "DOWNWARDS HARPOON WITH BARB LEFT FROM BAR");
    map.put('\u2962', "LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN");
    map.put('\u2963', "UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT");
    map.put('\u2964', "RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN");
    map.put('\u2965', "DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT");
    map.put('\u2966', "LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP");
    map.put('\u2967', "LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN");
    map.put('\u2968', "RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP");
    map.put('\u2969', "RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN");
    map.put('\u296A', "LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH");
    map.put('\u296B', "LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH");
    map.put('\u296C', "RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH");
    map.put('\u296D', "RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH");
    map.put('\u296E', "UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT");
    map.put('\u296F', "DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT");
    map.put('\u2970', "RIGHT DOUBLE ARROW WITH ROUNDED HEAD");
    map.put('\u2971', "EQUALS SIGN ABOVE RIGHTWARDS ARROW");
    map.put('\u2972', "TILDE OPERATOR ABOVE RIGHTWARDS ARROW");
    map.put('\u2973', "LEFTWARDS ARROW ABOVE TILDE OPERATOR");
    map.put('\u2974', "RIGHTWARDS ARROW ABOVE TILDE OPERATOR");
    map.put('\u2975', "RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO");
    map.put('\u2976', "LESS-THAN ABOVE LEFTWARDS ARROW");
    map.put('\u2977', "LEFTWARDS ARROW THROUGH LESS-THAN");
    map.put('\u2978', "GREATER-THAN ABOVE RIGHTWARDS ARROW");
    map.put('\u2979', "SUBSET ABOVE RIGHTWARDS ARROW");
    map.put('\u297A', "LEFTWARDS ARROW THROUGH SUBSET");
    map.put('\u297B', "SUPERSET ABOVE LEFTWARDS ARROW");
    map.put('\u297C', "LEFT FISH TAIL");
    map.put('\u297D', "RIGHT FISH TAIL");
    map.put('\u297E', "UP FISH TAIL");
    map.put('\u297F', "DOWN FISH TAIL");
    map.put('\u2980', "TRIPLE VERTICAL BAR DELIMITER");
    map.put('\u2981', "Z NOTATION SPOT");
    map.put('\u2982', "Z NOTATION TYPE COLON");
    map.put('\u2983', "LEFT WHITE CURLY BRACKET");
    map.put('\u2984', "RIGHT WHITE CURLY BRACKET");
    map.put('\u2985', "LEFT WHITE PARENTHESIS");
    map.put('\u2986', "RIGHT WHITE PARENTHESIS");
    map.put('\u2987', "Z NOTATION LEFT IMAGE BRACKET");
    map.put('\u2988', "Z NOTATION RIGHT IMAGE BRACKET");
    map.put('\u2989', "Z NOTATION LEFT BINDING BRACKET");
    map.put('\u298A', "Z NOTATION RIGHT BINDING BRACKET");
    map.put('\u298B', "LEFT SQUARE BRACKET WITH UNDERBAR");
    map.put('\u298C', "RIGHT SQUARE BRACKET WITH UNDERBAR");
    map.put('\u298D', "LEFT SQUARE BRACKET WITH TICK IN TOP CORNER");
    map.put('\u298E', "RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER");
    map.put('\u298F', "LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER");
    map.put('\u2990', "RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER");
    map.put('\u2991', "LEFT ANGLE BRACKET WITH DOT");
    map.put('\u2992', "RIGHT ANGLE BRACKET WITH DOT");
    map.put('\u2993', "LEFT ARC LESS-THAN BRACKET");
    map.put('\u2994', "RIGHT ARC GREATER-THAN BRACKET");
    map.put('\u2995', "DOUBLE LEFT ARC GREATER-THAN BRACKET");
    map.put('\u2996', "DOUBLE RIGHT ARC LESS-THAN BRACKET");
    map.put('\u2997', "LEFT BLACK TORTOISE SHELL BRACKET");
    map.put('\u2998', "RIGHT BLACK TORTOISE SHELL BRACKET");
    map.put('\u2999', "DOTTED FENCE");
    map.put('\u299A', "VERTICAL ZIGZAG LINE");
    map.put('\u299B', "MEASURED ANGLE OPENING LEFT");
    map.put('\u299C', "RIGHT ANGLE VARIANT WITH SQUARE");
    map.put('\u299D', "MEASURED RIGHT ANGLE WITH DOT");
    map.put('\u299E', "ANGLE WITH S INSIDE");
    map.put('\u299F', "ACUTE ANGLE");
    map.put('\u29A0', "SPHERICAL ANGLE OPENING LEFT");
    map.put('\u29A1', "SPHERICAL ANGLE OPENING UP");
    map.put('\u29A2', "TURNED ANGLE");
    map.put('\u29A3', "REVERSED ANGLE");
    map.put('\u29A4', "ANGLE WITH UNDERBAR");
    map.put('\u29A5', "REVERSED ANGLE WITH UNDERBAR");
    map.put('\u29A6', "OBLIQUE ANGLE OPENING UP");
    map.put('\u29A7', "OBLIQUE ANGLE OPENING DOWN");
    map.put('\u29A8', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT");
    map.put('\u29A9', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT");
    map.put('\u29AA', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT");
    map.put('\u29AB', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT");
    map.put('\u29AC', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP");
    map.put('\u29AD', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP");
    map.put('\u29AE', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN");
    map.put('\u29AF', "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN");
    map.put('\u29B0', "REVERSED EMPTY SET");
    map.put('\u29B1', "EMPTY SET WITH OVERBAR");
    map.put('\u29B2', "EMPTY SET WITH SMALL CIRCLE ABOVE");
    map.put('\u29B3', "EMPTY SET WITH RIGHT ARROW ABOVE");
    map.put('\u29B4', "EMPTY SET WITH LEFT ARROW ABOVE");
    map.put('\u29B5', "CIRCLE WITH HORIZONTAL BAR");
    map.put('\u29B6', "CIRCLED VERTICAL BAR");
    map.put('\u29B7', "CIRCLED PARALLEL");
    map.put('\u29B8', "CIRCLED REVERSE SOLIDUS");
    map.put('\u29B9', "CIRCLED PERPENDICULAR");
    map.put('\u29BA', "CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR");
    map.put('\u29BB', "CIRCLE WITH SUPERIMPOSED X");
    map.put('\u29BC', "CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN");
    map.put('\u29BD', "UP ARROW THROUGH CIRCLE");
    map.put('\u29BE', "CIRCLED WHITE BULLET");
    map.put('\u29BF', "CIRCLED BULLET");
    map.put('\u29C0', "CIRCLED LESS-THAN");
    map.put('\u29C1', "CIRCLED GREATER-THAN");
    map.put('\u29C2', "CIRCLE WITH SMALL CIRCLE TO THE RIGHT");
    map.put('\u29C3', "CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT");
    map.put('\u29C4', "SQUARED RISING DIAGONAL SLASH");
    map.put('\u29C5', "SQUARED FALLING DIAGONAL SLASH");
    map.put('\u29C6', "SQUARED ASTERISK");
    map.put('\u29C7', "SQUARED SMALL CIRCLE");
    map.put('\u29C8', "SQUARED SQUARE");
    map.put('\u29C9', "TWO JOINED SQUARES");
    map.put('\u29CA', "TRIANGLE WITH DOT ABOVE");
    map.put('\u29CB', "TRIANGLE WITH UNDERBAR");
    map.put('\u29CC', "S IN TRIANGLE");
    map.put('\u29CD', "TRIANGLE WITH SERIFS AT BOTTOM");
    map.put('\u29CE', "RIGHT TRIANGLE ABOVE LEFT TRIANGLE");
    map.put('\u29CF', "LEFT TRIANGLE BESIDE VERTICAL BAR");
    map.put('\u29D0', "VERTICAL BAR BESIDE RIGHT TRIANGLE");
    map.put('\u29D1', "BOWTIE WITH LEFT HALF BLACK");
    map.put('\u29D2', "BOWTIE WITH RIGHT HALF BLACK");
    map.put('\u29D3', "BLACK BOWTIE");
    map.put('\u29D4', "TIMES WITH LEFT HALF BLACK");
    map.put('\u29D5', "TIMES WITH RIGHT HALF BLACK");
    map.put('\u29D6', "WHITE HOURGLASS");
    map.put('\u29D7', "BLACK HOURGLASS");
    map.put('\u29D8', "LEFT WIGGLY FENCE");
    map.put('\u29D9', "RIGHT WIGGLY FENCE");
    map.put('\u29DA', "LEFT DOUBLE WIGGLY FENCE");
    map.put('\u29DB', "RIGHT DOUBLE WIGGLY FENCE");
    map.put('\u29DC', "INCOMPLETE INFINITY");
    map.put('\u29DD', "TIE OVER INFINITY");
    map.put('\u29DE', "INFINITY NEGATED WITH VERTICAL BAR");
    map.put('\u29DF', "DOUBLE-ENDED MULTIMAP");
    map.put('\u29E0', "SQUARE WITH CONTOURED OUTLINE");
    map.put('\u29E1', "INCREASES AS");
    map.put('\u29E2', "SHUFFLE PRODUCT");
    map.put('\u29E3', "EQUALS SIGN AND SLANTED PARALLEL");
    map.put('\u29E4', "EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE");
    map.put('\u29E5', "IDENTICAL TO AND SLANTED PARALLEL");
    map.put('\u29E6', "GLEICH STARK");
    map.put('\u29E7', "THERMODYNAMIC");
    map.put('\u29E8', "DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK");
    map.put('\u29E9', "DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK");
    map.put('\u29EA', "BLACK DIAMOND WITH DOWN ARROW");
    map.put('\u29EB', "BLACK LOZENGE");
    map.put('\u29EC', "WHITE CIRCLE WITH DOWN ARROW");
    map.put('\u29ED', "BLACK CIRCLE WITH DOWN ARROW");
    map.put('\u29EE', "ERROR-BARRED WHITE SQUARE");
    map.put('\u29EF', "ERROR-BARRED BLACK SQUARE");
    map.put('\u29F0', "ERROR-BARRED WHITE DIAMOND");
    map.put('\u29F1', "ERROR-BARRED BLACK DIAMOND");
    map.put('\u29F2', "ERROR-BARRED WHITE CIRCLE");
    map.put('\u29F3', "ERROR-BARRED BLACK CIRCLE");
    map.put('\u29F4', "RULE-DELAYED");
    map.put('\u29F5', "REVERSE SOLIDUS OPERATOR");
    map.put('\u29F6', "SOLIDUS WITH OVERBAR");
    map.put('\u29F7', "REVERSE SOLIDUS WITH HORIZONTAL STROKE");
    map.put('\u29F8', "BIG SOLIDUS");
    map.put('\u29F9', "BIG REVERSE SOLIDUS");
    map.put('\u29FA', "DOUBLE PLUS");
    map.put('\u29FB', "TRIPLE PLUS");
    map.put('\u29FC', "LEFT-POINTING CURVED ANGLE BRACKET");
    map.put('\u29FD', "RIGHT-POINTING CURVED ANGLE BRACKET");
    map.put('\u29FE', "TINY");
    map.put('\u29FF', "MINY");
    map.put('\u2A00', "N-ARY CIRCLED DOT OPERATOR");
    map.put('\u2A01', "N-ARY CIRCLED PLUS OPERATOR");
    map.put('\u2A02', "N-ARY CIRCLED TIMES OPERATOR");
    map.put('\u2A03', "N-ARY UNION OPERATOR WITH DOT");
    map.put('\u2A04', "N-ARY UNION OPERATOR WITH PLUS");
    map.put('\u2A05', "N-ARY SQUARE INTERSECTION OPERATOR");
    map.put('\u2A06', "N-ARY SQUARE UNION OPERATOR");
    map.put('\u2A07', "TWO LOGICAL AND OPERATOR");
    map.put('\u2A08', "TWO LOGICAL OR OPERATOR");
    map.put('\u2A09', "N-ARY TIMES OPERATOR");
    map.put('\u2A0A', "MODULO TWO SUM");
    map.put('\u2A0B', "SUMMATION WITH INTEGRAL");
    map.put('\u2A0C', "QUADRUPLE INTEGRAL OPERATOR");
    map.put('\u2A0D', "FINITE PART INTEGRAL");
    map.put('\u2A0E', "INTEGRAL WITH DOUBLE STROKE");
    map.put('\u2A0F', "INTEGRAL AVERAGE WITH SLASH");
    map.put('\u2A10', "CIRCULATION FUNCTION");
    map.put('\u2A11', "ANTICLOCKWISE INTEGRATION");
    map.put('\u2A12', "LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE");
    map.put('\u2A13', "LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE");
    map.put('\u2A14', "LINE INTEGRATION NOT INCLUDING THE POLE");
    map.put('\u2A15', "INTEGRAL AROUND A POINT OPERATOR");
    map.put('\u2A16', "QUATERNION INTEGRAL OPERATOR");
    map.put('\u2A17', "INTEGRAL WITH LEFTWARDS ARROW WITH HOOK");
    map.put('\u2A18', "INTEGRAL WITH TIMES SIGN");
    map.put('\u2A19', "INTEGRAL WITH INTERSECTION");
    map.put('\u2A1A', "INTEGRAL WITH UNION");
    map.put('\u2A1B', "INTEGRAL WITH OVERBAR");
    map.put('\u2A1C', "INTEGRAL WITH UNDERBAR");
    map.put('\u2A1D', "JOIN");
    map.put('\u2A1E', "LARGE LEFT TRIANGLE OPERATOR");
    map.put('\u2A1F', "Z NOTATION SCHEMA COMPOSITION");
    map.put('\u2A20', "Z NOTATION SCHEMA PIPING");
    map.put('\u2A21', "Z NOTATION SCHEMA PROJECTION");
    map.put('\u2A22', "PLUS SIGN WITH SMALL CIRCLE ABOVE");
    map.put('\u2A23', "PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE");
    map.put('\u2A24', "PLUS SIGN WITH TILDE ABOVE");
    map.put('\u2A25', "PLUS SIGN WITH DOT BELOW");
    map.put('\u2A26', "PLUS SIGN WITH TILDE BELOW");
    map.put('\u2A27', "PLUS SIGN WITH SUBSCRIPT TWO");
    map.put('\u2A28', "PLUS SIGN WITH BLACK TRIANGLE");
    map.put('\u2A29', "MINUS SIGN WITH COMMA ABOVE");
    map.put('\u2A2A', "MINUS SIGN WITH DOT BELOW");
    map.put('\u2A2B', "MINUS SIGN WITH FALLING DOTS");
    map.put('\u2A2C', "MINUS SIGN WITH RISING DOTS");
    map.put('\u2A2D', "PLUS SIGN IN LEFT HALF CIRCLE");
    map.put('\u2A2E', "PLUS SIGN IN RIGHT HALF CIRCLE");
    map.put('\u2A2F', "VECTOR OR CROSS PRODUCT");
    map.put('\u2A30', "MULTIPLICATION SIGN WITH DOT ABOVE");
    map.put('\u2A31', "MULTIPLICATION SIGN WITH UNDERBAR");
    map.put('\u2A32', "SEMIDIRECT PRODUCT WITH BOTTOM CLOSED");
    map.put('\u2A33', "SMASH PRODUCT");
    map.put('\u2A34', "MULTIPLICATION SIGN IN LEFT HALF CIRCLE");
    map.put('\u2A35', "MULTIPLICATION SIGN IN RIGHT HALF CIRCLE");
    map.put('\u2A36', "CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT");
    map.put('\u2A37', "MULTIPLICATION SIGN IN DOUBLE CIRCLE");
    map.put('\u2A38', "CIRCLED DIVISION SIGN");
    map.put('\u2A39', "PLUS SIGN IN TRIANGLE");
    map.put('\u2A3A', "MINUS SIGN IN TRIANGLE");
    map.put('\u2A3B', "MULTIPLICATION SIGN IN TRIANGLE");
    map.put('\u2A3C', "INTERIOR PRODUCT");
    map.put('\u2A3D', "RIGHTHAND INTERIOR PRODUCT");
    map.put('\u2A3E', "Z NOTATION RELATIONAL COMPOSITION");
    map.put('\u2A3F', "AMALGAMATION OR COPRODUCT");
    map.put('\u2A40', "INTERSECTION WITH DOT");
    map.put('\u2A41', "UNION WITH MINUS SIGN");
    map.put('\u2A42', "UNION WITH OVERBAR");
    map.put('\u2A43', "INTERSECTION WITH OVERBAR");
    map.put('\u2A44', "INTERSECTION WITH LOGICAL AND");
    map.put('\u2A45', "UNION WITH LOGICAL OR");
    map.put('\u2A46', "UNION ABOVE INTERSECTION");
    map.put('\u2A47', "INTERSECTION ABOVE UNION");
    map.put('\u2A48', "UNION ABOVE BAR ABOVE INTERSECTION");
    map.put('\u2A49', "INTERSECTION ABOVE BAR ABOVE UNION");
    map.put('\u2A4A', "UNION BESIDE AND JOINED WITH UNION");
    map.put('\u2A4B', "INTERSECTION BESIDE AND JOINED WITH INTERSECTION");
    map.put('\u2A4C', "CLOSED UNION WITH SERIFS");
    map.put('\u2A4D', "CLOSED INTERSECTION WITH SERIFS");
    map.put('\u2A4E', "DOUBLE SQUARE INTERSECTION");
    map.put('\u2A4F', "DOUBLE SQUARE UNION");
    map.put('\u2A50', "CLOSED UNION WITH SERIFS AND SMASH PRODUCT");
    map.put('\u2A51', "LOGICAL AND WITH DOT ABOVE");
    map.put('\u2A52', "LOGICAL OR WITH DOT ABOVE");
    map.put('\u2A53', "DOUBLE LOGICAL AND");
    map.put('\u2A54', "DOUBLE LOGICAL OR");
    map.put('\u2A55', "TWO INTERSECTING LOGICAL AND");
    map.put('\u2A56', "TWO INTERSECTING LOGICAL OR");
    map.put('\u2A57', "SLOPING LARGE OR");
    map.put('\u2A58', "SLOPING LARGE AND");
    map.put('\u2A59', "LOGICAL OR OVERLAPPING LOGICAL AND");
    map.put('\u2A5A', "LOGICAL AND WITH MIDDLE STEM");
    map.put('\u2A5B', "LOGICAL OR WITH MIDDLE STEM");
    map.put('\u2A5C', "LOGICAL AND WITH HORIZONTAL DASH");
    map.put('\u2A5D', "LOGICAL OR WITH HORIZONTAL DASH");
    map.put('\u2A5E', "LOGICAL AND WITH DOUBLE OVERBAR");
    map.put('\u2A5F', "LOGICAL AND WITH UNDERBAR");
    map.put('\u2A60', "LOGICAL AND WITH DOUBLE UNDERBAR");
    map.put('\u2A61', "SMALL VEE WITH UNDERBAR");
    map.put('\u2A62', "LOGICAL OR WITH DOUBLE OVERBAR");
    map.put('\u2A63', "LOGICAL OR WITH DOUBLE UNDERBAR");
    map.put('\u2A64', "Z NOTATION DOMAIN ANTIRESTRICTION");
    map.put('\u2A65', "Z NOTATION RANGE ANTIRESTRICTION");
    map.put('\u2A66', "EQUALS SIGN WITH DOT BELOW");
    map.put('\u2A67', "IDENTICAL WITH DOT ABOVE");
    map.put('\u2A68', "TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE");
    map.put('\u2A69', "TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE");
    map.put('\u2A6A', "TILDE OPERATOR WITH DOT ABOVE");
    map.put('\u2A6B', "TILDE OPERATOR WITH RISING DOTS");
    map.put('\u2A6C', "SIMILAR MINUS SIMILAR");
    map.put('\u2A6D', "CONGRUENT WITH DOT ABOVE");
    map.put('\u2A6E', "EQUALS WITH ASTERISK");
    map.put('\u2A6F', "ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT");
    map.put('\u2A70', "APPROXIMATELY EQUAL OR EQUAL TO");
    map.put('\u2A71', "EQUALS SIGN ABOVE PLUS SIGN");
    map.put('\u2A72', "PLUS SIGN ABOVE EQUALS SIGN");
    map.put('\u2A73', "EQUALS SIGN ABOVE TILDE OPERATOR");
    map.put('\u2A74', "DOUBLE COLON EQUAL");
    map.put('\u2A75', "TWO CONSECUTIVE EQUALS SIGNS");
    map.put('\u2A76', "THREE CONSECUTIVE EQUALS SIGNS");
    map.put('\u2A77', "EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW");
    map.put('\u2A78', "EQUIVALENT WITH FOUR DOTS ABOVE");
    map.put('\u2A79', "LESS-THAN WITH CIRCLE INSIDE");
    map.put('\u2A7A', "GREATER-THAN WITH CIRCLE INSIDE");
    map.put('\u2A7B', "LESS-THAN WITH QUESTION MARK ABOVE");
    map.put('\u2A7C', "GREATER-THAN WITH QUESTION MARK ABOVE");
    map.put('\u2A7D', "LESS-THAN OR SLANTED EQUAL TO");
    map.put('\u2A7E', "GREATER-THAN OR SLANTED EQUAL TO");
    map.put('\u2A7F', "LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE");
    map.put('\u2A80', "GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE");
    map.put('\u2A81', "LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE");
    map.put('\u2A82', "GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE");
    map.put('\u2A83', "LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT");
    map.put('\u2A84', "GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT");
    map.put('\u2A85', "LESS-THAN OR APPROXIMATE");
    map.put('\u2A86', "GREATER-THAN OR APPROXIMATE");
    map.put('\u2A87', "LESS-THAN AND SINGLE-LINE NOT EQUAL TO");
    map.put('\u2A88', "GREATER-THAN AND SINGLE-LINE NOT EQUAL TO");
    map.put('\u2A89', "LESS-THAN AND NOT APPROXIMATE");
    map.put('\u2A8A', "GREATER-THAN AND NOT APPROXIMATE");
    map.put('\u2A8B', "LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN");
    map.put('\u2A8C', "GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN");
    map.put('\u2A8D', "LESS-THAN ABOVE SIMILAR OR EQUAL");
    map.put('\u2A8E', "GREATER-THAN ABOVE SIMILAR OR EQUAL");
    map.put('\u2A8F', "LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN");
    map.put('\u2A90', "GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN");
    map.put('\u2A91', "LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL");
    map.put('\u2A92', "GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL");
    map.put('\u2A93', "LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL");
    map.put('\u2A94', "GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL");
    map.put('\u2A95', "SLANTED EQUAL TO OR LESS-THAN");
    map.put('\u2A96', "SLANTED EQUAL TO OR GREATER-THAN");
    map.put('\u2A97', "SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE");
    map.put('\u2A98', "SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE");
    map.put('\u2A99', "DOUBLE-LINE EQUAL TO OR LESS-THAN");
    map.put('\u2A9A', "DOUBLE-LINE EQUAL TO OR GREATER-THAN");
    map.put('\u2A9B', "DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN");
    map.put('\u2A9C', "DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN");
    map.put('\u2A9D', "SIMILAR OR LESS-THAN");
    map.put('\u2A9E', "SIMILAR OR GREATER-THAN");
    map.put('\u2A9F', "SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN");
    map.put('\u2AA0', "SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN");
    map.put('\u2AA1', "DOUBLE NESTED LESS-THAN");
    map.put('\u2AA2', "DOUBLE NESTED GREATER-THAN");
    map.put('\u2AA3', "DOUBLE NESTED LESS-THAN WITH UNDERBAR");
    map.put('\u2AA4', "GREATER-THAN OVERLAPPING LESS-THAN");
    map.put('\u2AA5', "GREATER-THAN BESIDE LESS-THAN");
    map.put('\u2AA6', "LESS-THAN CLOSED BY CURVE");
    map.put('\u2AA7', "GREATER-THAN CLOSED BY CURVE");
    map.put('\u2AA8', "LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL");
    map.put('\u2AA9', "GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL");
    map.put('\u2AAA', "SMALLER THAN");
    map.put('\u2AAB', "LARGER THAN");
    map.put('\u2AAC', "SMALLER THAN OR EQUAL TO");
    map.put('\u2AAD', "LARGER THAN OR EQUAL TO");
    map.put('\u2AAE', "EQUALS SIGN WITH BUMPY ABOVE");
    map.put('\u2AAF', "PRECEDES ABOVE SINGLE-LINE EQUALS SIGN");
    map.put('\u2AB0', "SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN");
    map.put('\u2AB1', "PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO");
    map.put('\u2AB2', "SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO");
    map.put('\u2AB3', "PRECEDES ABOVE EQUALS SIGN");
    map.put('\u2AB4', "SUCCEEDS ABOVE EQUALS SIGN");
    map.put('\u2AB5', "PRECEDES ABOVE NOT EQUAL TO");
    map.put('\u2AB6', "SUCCEEDS ABOVE NOT EQUAL TO");
    map.put('\u2AB7', "PRECEDES ABOVE ALMOST EQUAL TO");
    map.put('\u2AB8', "SUCCEEDS ABOVE ALMOST EQUAL TO");
    map.put('\u2AB9', "PRECEDES ABOVE NOT ALMOST EQUAL TO");
    map.put('\u2ABA', "SUCCEEDS ABOVE NOT ALMOST EQUAL TO");
    map.put('\u2ABB', "DOUBLE PRECEDES");
    map.put('\u2ABC', "DOUBLE SUCCEEDS");
    map.put('\u2ABD', "SUBSET WITH DOT");
    map.put('\u2ABE', "SUPERSET WITH DOT");
    map.put('\u2ABF', "SUBSET WITH PLUS SIGN BELOW");
    map.put('\u2AC0', "SUPERSET WITH PLUS SIGN BELOW");
    map.put('\u2AC1', "SUBSET WITH MULTIPLICATION SIGN BELOW");
    map.put('\u2AC2', "SUPERSET WITH MULTIPLICATION SIGN BELOW");
    map.put('\u2AC3', "SUBSET OF OR EQUAL TO WITH DOT ABOVE");
    map.put('\u2AC4', "SUPERSET OF OR EQUAL TO WITH DOT ABOVE");
    map.put('\u2AC5', "SUBSET OF ABOVE EQUALS SIGN");
    map.put('\u2AC6', "SUPERSET OF ABOVE EQUALS SIGN");
    map.put('\u2AC7', "SUBSET OF ABOVE TILDE OPERATOR");
    map.put('\u2AC8', "SUPERSET OF ABOVE TILDE OPERATOR");
    map.put('\u2AC9', "SUBSET OF ABOVE ALMOST EQUAL TO");
    map.put('\u2ACA', "SUPERSET OF ABOVE ALMOST EQUAL TO");
    map.put('\u2ACB', "SUBSET OF ABOVE NOT EQUAL TO");
    map.put('\u2ACC', "SUPERSET OF ABOVE NOT EQUAL TO");
    map.put('\u2ACD', "SQUARE LEFT OPEN BOX OPERATOR");
    map.put('\u2ACE', "SQUARE RIGHT OPEN BOX OPERATOR");
    map.put('\u2ACF', "CLOSED SUBSET");
    map.put('\u2AD0', "CLOSED SUPERSET");
    map.put('\u2AD1', "CLOSED SUBSET OR EQUAL TO");
    map.put('\u2AD2', "CLOSED SUPERSET OR EQUAL TO");
    map.put('\u2AD3', "SUBSET ABOVE SUPERSET");
    map.put('\u2AD4', "SUPERSET ABOVE SUBSET");
    map.put('\u2AD5', "SUBSET ABOVE SUBSET");
    map.put('\u2AD6', "SUPERSET ABOVE SUPERSET");
    map.put('\u2AD7', "SUPERSET BESIDE SUBSET");
    map.put('\u2AD8', "SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET");
    map.put('\u2AD9', "ELEMENT OF OPENING DOWNWARDS");
    map.put('\u2ADA', "PITCHFORK WITH TEE TOP");
    map.put('\u2ADB', "TRANSVERSAL INTERSECTION");
    map.put('\u2ADC', "FORKING");
    map.put('\u2ADD', "NONFORKING");
    map.put('\u2ADE', "SHORT LEFT TACK");
    map.put('\u2ADF', "SHORT DOWN TACK");
    map.put('\u2AE0', "SHORT UP TACK");
    map.put('\u2AE1', "PERPENDICULAR WITH S");
    map.put('\u2AE2', "VERTICAL BAR TRIPLE RIGHT TURNSTILE");
    map.put('\u2AE3', "DOUBLE VERTICAL BAR LEFT TURNSTILE");
    map.put('\u2AE4', "VERTICAL BAR DOUBLE LEFT TURNSTILE");
    map.put('\u2AE5', "DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE");
    map.put('\u2AE6', "LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL");
    map.put('\u2AE7', "SHORT DOWN TACK WITH OVERBAR");
    map.put('\u2AE8', "SHORT UP TACK WITH UNDERBAR");
    map.put('\u2AE9', "SHORT UP TACK ABOVE SHORT DOWN TACK");
    map.put('\u2AEA', "DOUBLE DOWN TACK");
    map.put('\u2AEB', "DOUBLE UP TACK");
    map.put('\u2AEC', "DOUBLE STROKE NOT SIGN");
    map.put('\u2AED', "REVERSED DOUBLE STROKE NOT SIGN");
    map.put('\u2AEE', "DOES NOT DIVIDE WITH REVERSED NEGATION SLASH");
    map.put('\u2AEF', "VERTICAL LINE WITH CIRCLE ABOVE");
    map.put('\u2AF0', "VERTICAL LINE WITH CIRCLE BELOW");
    map.put('\u2AF1', "DOWN TACK WITH CIRCLE BELOW");
    map.put('\u2AF2', "PARALLEL WITH HORIZONTAL STROKE");
    map.put('\u2AF3', "PARALLEL WITH TILDE OPERATOR");
    map.put('\u2AF4', "TRIPLE VERTICAL BAR BINARY RELATION");
    map.put('\u2AF5', "TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE");
    map.put('\u2AF6', "TRIPLE COLON OPERATOR");
    map.put('\u2AF7', "TRIPLE NESTED LESS-THAN");
    map.put('\u2AF8', "TRIPLE NESTED GREATER-THAN");
    map.put('\u2AF9', "DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO");
    map.put('\u2AFA', "DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO");
    map.put('\u2AFB', "TRIPLE SOLIDUS BINARY RELATION");
    map.put('\u2AFC', "LARGE TRIPLE VERTICAL BAR OPERATOR");
    map.put('\u2AFD', "DOUBLE SOLIDUS OPERATOR");
    map.put('\u2AFE', "WHITE VERTICAL BAR");
    map.put('\u2AFF', "N-ARY WHITE VERTICAL BAR");
    map.put('\u2B00', "NORTH EAST WHITE ARROW");
    map.put('\u2B01', "NORTH WEST WHITE ARROW");
    map.put('\u2B02', "SOUTH EAST WHITE ARROW");
    map.put('\u2B03', "SOUTH WEST WHITE ARROW");
    map.put('\u2B04', "LEFT RIGHT WHITE ARROW");
    map.put('\u2B05', "LEFTWARDS BLACK ARROW");
    map.put('\u2B06', "UPWARDS BLACK ARROW");
    map.put('\u2B07', "DOWNWARDS BLACK ARROW");
    map.put('\u2B08', "NORTH EAST BLACK ARROW");
    map.put('\u2B09', "NORTH WEST BLACK ARROW");
    map.put('\u2B0A', "SOUTH EAST BLACK ARROW");
    map.put('\u2B0B', "SOUTH WEST BLACK ARROW");
    map.put('\u2B0C', "LEFT RIGHT BLACK ARROW");
    map.put('\u2B0D', "UP DOWN BLACK ARROW");
    map.put('\u2B0E', "RIGHTWARDS ARROW WITH TIP DOWNWARDS");
    map.put('\u2B0F', "RIGHTWARDS ARROW WITH TIP UPWARDS");
    map.put('\u2B10', "LEFTWARDS ARROW WITH TIP DOWNWARDS");
    map.put('\u2B11', "LEFTWARDS ARROW WITH TIP UPWARDS");
    map.put('\u2B12', "SQUARE WITH TOP HALF BLACK");
    map.put('\u2B13', "SQUARE WITH BOTTOM HALF BLACK");
    map.put('\u2B14', "SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK");
    map.put('\u2B15', "SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK");
    map.put('\u2B16', "DIAMOND WITH LEFT HALF BLACK");
    map.put('\u2B17', "DIAMOND WITH RIGHT HALF BLACK");
    map.put('\u2B18', "DIAMOND WITH TOP HALF BLACK");
    map.put('\u2B19', "DIAMOND WITH BOTTOM HALF BLACK");
    map.put('\u2B1A', "DOTTED SQUARE");
    map.put('\u2B1B', "BLACK LARGE SQUARE");
    map.put('\u2B1C', "WHITE LARGE SQUARE");
    map.put('\u2B1D', "BLACK VERY SMALL SQUARE");
    map.put('\u2B1E', "WHITE VERY SMALL SQUARE");
    map.put('\u2B1F', "BLACK PENTAGON");
    map.put('\u2B20', "WHITE PENTAGON");
    map.put('\u2B21', "WHITE HEXAGON");
    map.put('\u2B22', "BLACK HEXAGON");
    map.put('\u2B23', "HORIZONTAL BLACK HEXAGON");
    map.put('\u2B24', "BLACK LARGE CIRCLE");
    map.put('\u2B25', "BLACK MEDIUM DIAMOND");
    map.put('\u2B26', "WHITE MEDIUM DIAMOND");
    map.put('\u2B27', "BLACK MEDIUM LOZENGE");
    map.put('\u2B28', "WHITE MEDIUM LOZENGE");
    map.put('\u2B29', "BLACK SMALL DIAMOND");
    map.put('\u2B2A', "BLACK SMALL LOZENGE");
    map.put('\u2B2B', "WHITE SMALL LOZENGE");
    map.put('\u2B2C', "BLACK HORIZONTAL ELLIPSE");
    map.put('\u2B2D', "WHITE HORIZONTAL ELLIPSE");
    map.put('\u2B2E', "BLACK VERTICAL ELLIPSE");
    map.put('\u2B2F', "WHITE VERTICAL ELLIPSE");
    map.put('\u2B30', "LEFT ARROW WITH SMALL CIRCLE");
    map.put('\u2B31', "THREE LEFTWARDS ARROWS");
    map.put('\u2B32', "LEFT ARROW WITH CIRCLED PLUS");
    map.put('\u2B33', "LONG LEFTWARDS SQUIGGLE ARROW");
    map.put('\u2B34', "LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE");
    map.put('\u2B35', "LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE");
    map.put('\u2B36', "LEFTWARDS TWO-HEADED ARROW FROM BAR");
    map.put('\u2B37', "LEFTWARDS TWO-HEADED TRIPLE DASH ARROW");
    map.put('\u2B38', "LEFTWARDS ARROW WITH DOTTED STEM");
    map.put('\u2B39', "LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE");
    map.put('\u2B3A', "LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE");
    map.put('\u2B3B', "LEFTWARDS TWO-HEADED ARROW WITH TAIL");
    map.put('\u2B3C', "LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE");
    map.put('\u2B3D', "LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE");
    map.put('\u2B3E', "LEFTWARDS ARROW THROUGH X");
    map.put('\u2B3F', "WAVE ARROW POINTING DIRECTLY LEFT");
    map.put('\u2B40', "EQUALS SIGN ABOVE LEFTWARDS ARROW");
    map.put('\u2B41', "REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW");
    map.put('\u2B42', "LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO");
    map.put('\u2B43', "RIGHTWARDS ARROW THROUGH GREATER-THAN");
    map.put('\u2B44', "RIGHTWARDS ARROW THROUGH SUPERSET");
    map.put('\u2B45', "LEFTWARDS QUADRUPLE ARROW");
    map.put('\u2B46', "RIGHTWARDS QUADRUPLE ARROW");
    map.put('\u2B47', "REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW");
    map.put('\u2B48', "RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO");
    map.put('\u2B49', "TILDE OPERATOR ABOVE LEFTWARDS ARROW");
    map.put('\u2B4A', "LEFTWARDS ARROW ABOVE ALMOST EQUAL TO");
    map.put('\u2B4B', "LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR");
    map.put('\u2B4C', "RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR");
    map.put('\u2B50', "WHITE MEDIUM STAR");
    map.put('\u2B51', "BLACK SMALL STAR");
    map.put('\u2B52', "WHITE SMALL STAR");
    map.put('\u2B53', "BLACK RIGHT-POINTING PENTAGON");
    map.put('\u2B54', "WHITE RIGHT-POINTING PENTAGON");
    map.put('\u2B55', "HEAVY LARGE CIRCLE");
    map.put('\u2B56', "HEAVY OVAL WITH OVAL INSIDE");
    map.put('\u2B57', "HEAVY CIRCLE WITH CIRCLE INSIDE");
    map.put('\u2B58', "HEAVY CIRCLE");
    map.put('\u2B59', "HEAVY CIRCLED SALTIRE");
    map.put('\u2C00', "GLAGOLITIC CAPITAL LETTER AZU");
    map.put('\u2C01', "GLAGOLITIC CAPITAL LETTER BUKY");
    map.put('\u2C02', "GLAGOLITIC CAPITAL LETTER VEDE");
    map.put('\u2C03', "GLAGOLITIC CAPITAL LETTER GLAGOLI");
    map.put('\u2C04', "GLAGOLITIC CAPITAL LETTER DOBRO");
    map.put('\u2C05', "GLAGOLITIC CAPITAL LETTER YESTU");
    map.put('\u2C06', "GLAGOLITIC CAPITAL LETTER ZHIVETE");
    map.put('\u2C07', "GLAGOLITIC CAPITAL LETTER DZELO");
    map.put('\u2C08', "GLAGOLITIC CAPITAL LETTER ZEMLJA");
    map.put('\u2C09', "GLAGOLITIC CAPITAL LETTER IZHE");
    map.put('\u2C0A', "GLAGOLITIC CAPITAL LETTER INITIAL IZHE");
    map.put('\u2C0B', "GLAGOLITIC CAPITAL LETTER I");
    map.put('\u2C0C', "GLAGOLITIC CAPITAL LETTER DJERVI");
    map.put('\u2C0D', "GLAGOLITIC CAPITAL LETTER KAKO");
    map.put('\u2C0E', "GLAGOLITIC CAPITAL LETTER LJUDIJE");
    map.put('\u2C0F', "GLAGOLITIC CAPITAL LETTER MYSLITE");
    map.put('\u2C10', "GLAGOLITIC CAPITAL LETTER NASHI");
    map.put('\u2C11', "GLAGOLITIC CAPITAL LETTER ONU");
    map.put('\u2C12', "GLAGOLITIC CAPITAL LETTER POKOJI");
    map.put('\u2C13', "GLAGOLITIC CAPITAL LETTER RITSI");
    map.put('\u2C14', "GLAGOLITIC CAPITAL LETTER SLOVO");
    map.put('\u2C15', "GLAGOLITIC CAPITAL LETTER TVRIDO");
    map.put('\u2C16', "GLAGOLITIC CAPITAL LETTER UKU");
    map.put('\u2C17', "GLAGOLITIC CAPITAL LETTER FRITU");
    map.put('\u2C18', "GLAGOLITIC CAPITAL LETTER HERU");
    map.put('\u2C19', "GLAGOLITIC CAPITAL LETTER OTU");
    map.put('\u2C1A', "GLAGOLITIC CAPITAL LETTER PE");
    map.put('\u2C1B', "GLAGOLITIC CAPITAL LETTER SHTA");
    map.put('\u2C1C', "GLAGOLITIC CAPITAL LETTER TSI");
    map.put('\u2C1D', "GLAGOLITIC CAPITAL LETTER CHRIVI");
    map.put('\u2C1E', "GLAGOLITIC CAPITAL LETTER SHA");
    map.put('\u2C1F', "GLAGOLITIC CAPITAL LETTER YERU");
    map.put('\u2C20', "GLAGOLITIC CAPITAL LETTER YERI");
    map.put('\u2C21', "GLAGOLITIC CAPITAL LETTER YATI");
    map.put('\u2C22', "GLAGOLITIC CAPITAL LETTER SPIDERY HA");
    map.put('\u2C23', "GLAGOLITIC CAPITAL LETTER YU");
    map.put('\u2C24', "GLAGOLITIC CAPITAL LETTER SMALL YUS");
    map.put('\u2C25', "GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL");
    map.put('\u2C26', "GLAGOLITIC CAPITAL LETTER YO");
    map.put('\u2C27', "GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS");
    map.put('\u2C28', "GLAGOLITIC CAPITAL LETTER BIG YUS");
    map.put('\u2C29', "GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS");
    map.put('\u2C2A', "GLAGOLITIC CAPITAL LETTER FITA");
    map.put('\u2C2B', "GLAGOLITIC CAPITAL LETTER IZHITSA");
    map.put('\u2C2C', "GLAGOLITIC CAPITAL LETTER SHTAPIC");
    map.put('\u2C2D', "GLAGOLITIC CAPITAL LETTER TROKUTASTI A");
    map.put('\u2C2E', "GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE");
    map.put('\u2C30', "GLAGOLITIC SMALL LETTER AZU");
    map.put('\u2C31', "GLAGOLITIC SMALL LETTER BUKY");
    map.put('\u2C32', "GLAGOLITIC SMALL LETTER VEDE");
    map.put('\u2C33', "GLAGOLITIC SMALL LETTER GLAGOLI");
    map.put('\u2C34', "GLAGOLITIC SMALL LETTER DOBRO");
    map.put('\u2C35', "GLAGOLITIC SMALL LETTER YESTU");
    map.put('\u2C36', "GLAGOLITIC SMALL LETTER ZHIVETE");
    map.put('\u2C37', "GLAGOLITIC SMALL LETTER DZELO");
    map.put('\u2C38', "GLAGOLITIC SMALL LETTER ZEMLJA");
    map.put('\u2C39', "GLAGOLITIC SMALL LETTER IZHE");
    map.put('\u2C3A', "GLAGOLITIC SMALL LETTER INITIAL IZHE");
    map.put('\u2C3B', "GLAGOLITIC SMALL LETTER I");
    map.put('\u2C3C', "GLAGOLITIC SMALL LETTER DJERVI");
    map.put('\u2C3D', "GLAGOLITIC SMALL LETTER KAKO");
    map.put('\u2C3E', "GLAGOLITIC SMALL LETTER LJUDIJE");
    map.put('\u2C3F', "GLAGOLITIC SMALL LETTER MYSLITE");
    map.put('\u2C40', "GLAGOLITIC SMALL LETTER NASHI");
    map.put('\u2C41', "GLAGOLITIC SMALL LETTER ONU");
    map.put('\u2C42', "GLAGOLITIC SMALL LETTER POKOJI");
    map.put('\u2C43', "GLAGOLITIC SMALL LETTER RITSI");
    map.put('\u2C44', "GLAGOLITIC SMALL LETTER SLOVO");
    map.put('\u2C45', "GLAGOLITIC SMALL LETTER TVRIDO");
    map.put('\u2C46', "GLAGOLITIC SMALL LETTER UKU");
    map.put('\u2C47', "GLAGOLITIC SMALL LETTER FRITU");
    map.put('\u2C48', "GLAGOLITIC SMALL LETTER HERU");
    map.put('\u2C49', "GLAGOLITIC SMALL LETTER OTU");
    map.put('\u2C4A', "GLAGOLITIC SMALL LETTER PE");
    map.put('\u2C4B', "GLAGOLITIC SMALL LETTER SHTA");
    map.put('\u2C4C', "GLAGOLITIC SMALL LETTER TSI");
    map.put('\u2C4D', "GLAGOLITIC SMALL LETTER CHRIVI");
    map.put('\u2C4E', "GLAGOLITIC SMALL LETTER SHA");
    map.put('\u2C4F', "GLAGOLITIC SMALL LETTER YERU");
    map.put('\u2C50', "GLAGOLITIC SMALL LETTER YERI");
    map.put('\u2C51', "GLAGOLITIC SMALL LETTER YATI");
    map.put('\u2C52', "GLAGOLITIC SMALL LETTER SPIDERY HA");
    map.put('\u2C53', "GLAGOLITIC SMALL LETTER YU");
    map.put('\u2C54', "GLAGOLITIC SMALL LETTER SMALL YUS");
    map.put('\u2C55', "GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL");
    map.put('\u2C56', "GLAGOLITIC SMALL LETTER YO");
    map.put('\u2C57', "GLAGOLITIC SMALL LETTER IOTATED SMALL YUS");
    map.put('\u2C58', "GLAGOLITIC SMALL LETTER BIG YUS");
    map.put('\u2C59', "GLAGOLITIC SMALL LETTER IOTATED BIG YUS");
    map.put('\u2C5A', "GLAGOLITIC SMALL LETTER FITA");
    map.put('\u2C5B', "GLAGOLITIC SMALL LETTER IZHITSA");
    map.put('\u2C5C', "GLAGOLITIC SMALL LETTER SHTAPIC");
    map.put('\u2C5D', "GLAGOLITIC SMALL LETTER TROKUTASTI A");
    map.put('\u2C5E', "GLAGOLITIC SMALL LETTER LATINATE MYSLITE");
    map.put('\u2C60', "LATIN CAPITAL LETTER L WITH DOUBLE BAR");
    map.put('\u2C61', "LATIN SMALL LETTER L WITH DOUBLE BAR");
    map.put('\u2C62', "LATIN CAPITAL LETTER L WITH MIDDLE TILDE");
    map.put('\u2C63', "LATIN CAPITAL LETTER P WITH STROKE");
    map.put('\u2C64', "LATIN CAPITAL LETTER R WITH TAIL");
    map.put('\u2C65', "LATIN SMALL LETTER A WITH STROKE");
    map.put('\u2C66', "LATIN SMALL LETTER T WITH DIAGONAL STROKE");
    map.put('\u2C67', "LATIN CAPITAL LETTER H WITH DESCENDER");
    map.put('\u2C68', "LATIN SMALL LETTER H WITH DESCENDER");
    map.put('\u2C69', "LATIN CAPITAL LETTER K WITH DESCENDER");
    map.put('\u2C6A', "LATIN SMALL LETTER K WITH DESCENDER");
    map.put('\u2C6B', "LATIN CAPITAL LETTER Z WITH DESCENDER");
    map.put('\u2C6C', "LATIN SMALL LETTER Z WITH DESCENDER");
    map.put('\u2C6D', "LATIN CAPITAL LETTER ALPHA");
    map.put('\u2C6E', "LATIN CAPITAL LETTER M WITH HOOK");
    map.put('\u2C6F', "LATIN CAPITAL LETTER TURNED A");
    map.put('\u2C70', "LATIN CAPITAL LETTER TURNED ALPHA");
    map.put('\u2C71', "LATIN SMALL LETTER V WITH RIGHT HOOK");
    map.put('\u2C72', "LATIN CAPITAL LETTER W WITH HOOK");
    map.put('\u2C73', "LATIN SMALL LETTER W WITH HOOK");
    map.put('\u2C74', "LATIN SMALL LETTER V WITH CURL");
    map.put('\u2C75', "LATIN CAPITAL LETTER HALF H");
    map.put('\u2C76', "LATIN SMALL LETTER HALF H");
    map.put('\u2C77', "LATIN SMALL LETTER TAILLESS PHI");
    map.put('\u2C78', "LATIN SMALL LETTER E WITH NOTCH");
    map.put('\u2C79', "LATIN SMALL LETTER TURNED R WITH TAIL");
    map.put('\u2C7A', "LATIN SMALL LETTER O WITH LOW RING INSIDE");
    map.put('\u2C7B', "LATIN LETTER SMALL CAPITAL TURNED E");
    map.put('\u2C7C', "LATIN SUBSCRIPT SMALL LETTER J");
    map.put('\u2C7D', "MODIFIER LETTER CAPITAL V");
    map.put('\u2C7E', "LATIN CAPITAL LETTER S WITH SWASH TAIL");
    map.put('\u2C7F', "LATIN CAPITAL LETTER Z WITH SWASH TAIL");
    map.put('\u2C80', "COPTIC CAPITAL LETTER ALFA");
    map.put('\u2C81', "COPTIC SMALL LETTER ALFA");
    map.put('\u2C82', "COPTIC CAPITAL LETTER VIDA");
    map.put('\u2C83', "COPTIC SMALL LETTER VIDA");
    map.put('\u2C84', "COPTIC CAPITAL LETTER GAMMA");
    map.put('\u2C85', "COPTIC SMALL LETTER GAMMA");
    map.put('\u2C86', "COPTIC CAPITAL LETTER DALDA");
    map.put('\u2C87', "COPTIC SMALL LETTER DALDA");
    map.put('\u2C88', "COPTIC CAPITAL LETTER EIE");
    map.put('\u2C89', "COPTIC SMALL LETTER EIE");
    map.put('\u2C8A', "COPTIC CAPITAL LETTER SOU");
    map.put('\u2C8B', "COPTIC SMALL LETTER SOU");
    map.put('\u2C8C', "COPTIC CAPITAL LETTER ZATA");
    map.put('\u2C8D', "COPTIC SMALL LETTER ZATA");
    map.put('\u2C8E', "COPTIC CAPITAL LETTER HATE");
    map.put('\u2C8F', "COPTIC SMALL LETTER HATE");
    map.put('\u2C90', "COPTIC CAPITAL LETTER THETHE");
    map.put('\u2C91', "COPTIC SMALL LETTER THETHE");
    map.put('\u2C92', "COPTIC CAPITAL LETTER IAUDA");
    map.put('\u2C93', "COPTIC SMALL LETTER IAUDA");
    map.put('\u2C94', "COPTIC CAPITAL LETTER KAPA");
    map.put('\u2C95', "COPTIC SMALL LETTER KAPA");
    map.put('\u2C96', "COPTIC CAPITAL LETTER LAULA");
    map.put('\u2C97', "COPTIC SMALL LETTER LAULA");
    map.put('\u2C98', "COPTIC CAPITAL LETTER MI");
    map.put('\u2C99', "COPTIC SMALL LETTER MI");
    map.put('\u2C9A', "COPTIC CAPITAL LETTER NI");
    map.put('\u2C9B', "COPTIC SMALL LETTER NI");
    map.put('\u2C9C', "COPTIC CAPITAL LETTER KSI");
    map.put('\u2C9D', "COPTIC SMALL LETTER KSI");
    map.put('\u2C9E', "COPTIC CAPITAL LETTER O");
    map.put('\u2C9F', "COPTIC SMALL LETTER O");
    map.put('\u2CA0', "COPTIC CAPITAL LETTER PI");
    map.put('\u2CA1', "COPTIC SMALL LETTER PI");
    map.put('\u2CA2', "COPTIC CAPITAL LETTER RO");
    map.put('\u2CA3', "COPTIC SMALL LETTER RO");
    map.put('\u2CA4', "COPTIC CAPITAL LETTER SIMA");
    map.put('\u2CA5', "COPTIC SMALL LETTER SIMA");
    map.put('\u2CA6', "COPTIC CAPITAL LETTER TAU");
    map.put('\u2CA7', "COPTIC SMALL LETTER TAU");
    map.put('\u2CA8', "COPTIC CAPITAL LETTER UA");
    map.put('\u2CA9', "COPTIC SMALL LETTER UA");
    map.put('\u2CAA', "COPTIC CAPITAL LETTER FI");
    map.put('\u2CAB', "COPTIC SMALL LETTER FI");
    map.put('\u2CAC', "COPTIC CAPITAL LETTER KHI");
    map.put('\u2CAD', "COPTIC SMALL LETTER KHI");
    map.put('\u2CAE', "COPTIC CAPITAL LETTER PSI");
    map.put('\u2CAF', "COPTIC SMALL LETTER PSI");
    map.put('\u2CB0', "COPTIC CAPITAL LETTER OOU");
    map.put('\u2CB1', "COPTIC SMALL LETTER OOU");
    map.put('\u2CB2', "COPTIC CAPITAL LETTER DIALECT-P ALEF");
    map.put('\u2CB3', "COPTIC SMALL LETTER DIALECT-P ALEF");
    map.put('\u2CB4', "COPTIC CAPITAL LETTER OLD COPTIC AIN");
    map.put('\u2CB5', "COPTIC SMALL LETTER OLD COPTIC AIN");
    map.put('\u2CB6', "COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE");
    map.put('\u2CB7', "COPTIC SMALL LETTER CRYPTOGRAMMIC EIE");
    map.put('\u2CB8', "COPTIC CAPITAL LETTER DIALECT-P KAPA");
    map.put('\u2CB9', "COPTIC SMALL LETTER DIALECT-P KAPA");
    map.put('\u2CBA', "COPTIC CAPITAL LETTER DIALECT-P NI");
    map.put('\u2CBB', "COPTIC SMALL LETTER DIALECT-P NI");
    map.put('\u2CBC', "COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI");
    map.put('\u2CBD', "COPTIC SMALL LETTER CRYPTOGRAMMIC NI");
    map.put('\u2CBE', "COPTIC CAPITAL LETTER OLD COPTIC OOU");
    map.put('\u2CBF', "COPTIC SMALL LETTER OLD COPTIC OOU");
    map.put('\u2CC0', "COPTIC CAPITAL LETTER SAMPI");
    map.put('\u2CC1', "COPTIC SMALL LETTER SAMPI");
    map.put('\u2CC2', "COPTIC CAPITAL LETTER CROSSED SHEI");
    map.put('\u2CC3', "COPTIC SMALL LETTER CROSSED SHEI");
    map.put('\u2CC4', "COPTIC CAPITAL LETTER OLD COPTIC SHEI");
    map.put('\u2CC5', "COPTIC SMALL LETTER OLD COPTIC SHEI");
    map.put('\u2CC6', "COPTIC CAPITAL LETTER OLD COPTIC ESH");
    map.put('\u2CC7', "COPTIC SMALL LETTER OLD COPTIC ESH");
    map.put('\u2CC8', "COPTIC CAPITAL LETTER AKHMIMIC KHEI");
    map.put('\u2CC9', "COPTIC SMALL LETTER AKHMIMIC KHEI");
    map.put('\u2CCA', "COPTIC CAPITAL LETTER DIALECT-P HORI");
    map.put('\u2CCB', "COPTIC SMALL LETTER DIALECT-P HORI");
    map.put('\u2CCC', "COPTIC CAPITAL LETTER OLD COPTIC HORI");
    map.put('\u2CCD', "COPTIC SMALL LETTER OLD COPTIC HORI");
    map.put('\u2CCE', "COPTIC CAPITAL LETTER OLD COPTIC HA");
    map.put('\u2CCF', "COPTIC SMALL LETTER OLD COPTIC HA");
    map.put('\u2CD0', "COPTIC CAPITAL LETTER L-SHAPED HA");
    map.put('\u2CD1', "COPTIC SMALL LETTER L-SHAPED HA");
    map.put('\u2CD2', "COPTIC CAPITAL LETTER OLD COPTIC HEI");
    map.put('\u2CD3', "COPTIC SMALL LETTER OLD COPTIC HEI");
    map.put('\u2CD4', "COPTIC CAPITAL LETTER OLD COPTIC HAT");
    map.put('\u2CD5', "COPTIC SMALL LETTER OLD COPTIC HAT");
    map.put('\u2CD6', "COPTIC CAPITAL LETTER OLD COPTIC GANGIA");
    map.put('\u2CD7', "COPTIC SMALL LETTER OLD COPTIC GANGIA");
    map.put('\u2CD8', "COPTIC CAPITAL LETTER OLD COPTIC DJA");
    map.put('\u2CD9', "COPTIC SMALL LETTER OLD COPTIC DJA");
    map.put('\u2CDA', "COPTIC CAPITAL LETTER OLD COPTIC SHIMA");
    map.put('\u2CDB', "COPTIC SMALL LETTER OLD COPTIC SHIMA");
    map.put('\u2CDC', "COPTIC CAPITAL LETTER OLD NUBIAN SHIMA");
    map.put('\u2CDD', "COPTIC SMALL LETTER OLD NUBIAN SHIMA");
    map.put('\u2CDE', "COPTIC CAPITAL LETTER OLD NUBIAN NGI");
    map.put('\u2CDF', "COPTIC SMALL LETTER OLD NUBIAN NGI");
    map.put('\u2CE0', "COPTIC CAPITAL LETTER OLD NUBIAN NYI");
    map.put('\u2CE1', "COPTIC SMALL LETTER OLD NUBIAN NYI");
    map.put('\u2CE2', "COPTIC CAPITAL LETTER OLD NUBIAN WAU");
    map.put('\u2CE3', "COPTIC SMALL LETTER OLD NUBIAN WAU");
    map.put('\u2CE4', "COPTIC SYMBOL KAI");
    map.put('\u2CE5', "COPTIC SYMBOL MI RO");
    map.put('\u2CE6', "COPTIC SYMBOL PI RO");
    map.put('\u2CE7', "COPTIC SYMBOL STAUROS");
    map.put('\u2CE8', "COPTIC SYMBOL TAU RO");
    map.put('\u2CE9', "COPTIC SYMBOL KHI RO");
    map.put('\u2CEA', "COPTIC SYMBOL SHIMA SIMA");
    map.put('\u2CEB', "COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI");
    map.put('\u2CEC', "COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI");
    map.put('\u2CED', "COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA");
    map.put('\u2CEE', "COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA");
    map.put('\u2CEF', "COPTIC COMBINING NI ABOVE");
    map.put('\u2CF0', "COPTIC COMBINING SPIRITUS ASPER");
    map.put('\u2CF1', "COPTIC COMBINING SPIRITUS LENIS");
    map.put('\u2CF9', "COPTIC OLD NUBIAN FULL STOP");
    map.put('\u2CFA', "COPTIC OLD NUBIAN DIRECT QUESTION MARK");
    map.put('\u2CFB', "COPTIC OLD NUBIAN INDIRECT QUESTION MARK");
    map.put('\u2CFC', "COPTIC OLD NUBIAN VERSE DIVIDER");
    map.put('\u2CFD', "COPTIC FRACTION ONE HALF");
    map.put('\u2CFE', "COPTIC FULL STOP");
    map.put('\u2CFF', "COPTIC MORPHOLOGICAL DIVIDER");
    map.put('\u2D00', "GEORGIAN SMALL LETTER AN");
    map.put('\u2D01', "GEORGIAN SMALL LETTER BAN");
    map.put('\u2D02', "GEORGIAN SMALL LETTER GAN");
    map.put('\u2D03', "GEORGIAN SMALL LETTER DON");
    map.put('\u2D04', "GEORGIAN SMALL LETTER EN");
    map.put('\u2D05', "GEORGIAN SMALL LETTER VIN");
    map.put('\u2D06', "GEORGIAN SMALL LETTER ZEN");
    map.put('\u2D07', "GEORGIAN SMALL LETTER TAN");
    map.put('\u2D08', "GEORGIAN SMALL LETTER IN");
    map.put('\u2D09', "GEORGIAN SMALL LETTER KAN");
    map.put('\u2D0A', "GEORGIAN SMALL LETTER LAS");
    map.put('\u2D0B', "GEORGIAN SMALL LETTER MAN");
    map.put('\u2D0C', "GEORGIAN SMALL LETTER NAR");
    map.put('\u2D0D', "GEORGIAN SMALL LETTER ON");
    map.put('\u2D0E', "GEORGIAN SMALL LETTER PAR");
    map.put('\u2D0F', "GEORGIAN SMALL LETTER ZHAR");
    map.put('\u2D10', "GEORGIAN SMALL LETTER RAE");
    map.put('\u2D11', "GEORGIAN SMALL LETTER SAN");
    map.put('\u2D12', "GEORGIAN SMALL LETTER TAR");
    map.put('\u2D13', "GEORGIAN SMALL LETTER UN");
    map.put('\u2D14', "GEORGIAN SMALL LETTER PHAR");
    map.put('\u2D15', "GEORGIAN SMALL LETTER KHAR");
    map.put('\u2D16', "GEORGIAN SMALL LETTER GHAN");
    map.put('\u2D17', "GEORGIAN SMALL LETTER QAR");
    map.put('\u2D18', "GEORGIAN SMALL LETTER SHIN");
    map.put('\u2D19', "GEORGIAN SMALL LETTER CHIN");
    map.put('\u2D1A', "GEORGIAN SMALL LETTER CAN");
    map.put('\u2D1B', "GEORGIAN SMALL LETTER JIL");
    map.put('\u2D1C', "GEORGIAN SMALL LETTER CIL");
    map.put('\u2D1D', "GEORGIAN SMALL LETTER CHAR");
    map.put('\u2D1E', "GEORGIAN SMALL LETTER XAN");
    map.put('\u2D1F', "GEORGIAN SMALL LETTER JHAN");
    map.put('\u2D20', "GEORGIAN SMALL LETTER HAE");
    map.put('\u2D21', "GEORGIAN SMALL LETTER HE");
    map.put('\u2D22', "GEORGIAN SMALL LETTER HIE");
    map.put('\u2D23', "GEORGIAN SMALL LETTER WE");
    map.put('\u2D24', "GEORGIAN SMALL LETTER HAR");
    map.put('\u2D25', "GEORGIAN SMALL LETTER HOE");
    map.put('\u2D30', "TIFINAGH LETTER YA");
    map.put('\u2D31', "TIFINAGH LETTER YAB");
    map.put('\u2D32', "TIFINAGH LETTER YABH");
    map.put('\u2D33', "TIFINAGH LETTER YAG");
    map.put('\u2D34', "TIFINAGH LETTER YAGHH");
    map.put('\u2D35', "TIFINAGH LETTER BERBER ACADEMY YAJ");
    map.put('\u2D36', "TIFINAGH LETTER YAJ");
    map.put('\u2D37', "TIFINAGH LETTER YAD");
    map.put('\u2D38', "TIFINAGH LETTER YADH");
    map.put('\u2D39', "TIFINAGH LETTER YADD");
    map.put('\u2D3A', "TIFINAGH LETTER YADDH");
    map.put('\u2D3B', "TIFINAGH LETTER YEY");
    map.put('\u2D3C', "TIFINAGH LETTER YAF");
    map.put('\u2D3D', "TIFINAGH LETTER YAK");
    map.put('\u2D3E', "TIFINAGH LETTER TUAREG YAK");
    map.put('\u2D3F', "TIFINAGH LETTER YAKHH");
    map.put('\u2D40', "TIFINAGH LETTER YAH");
    map.put('\u2D41', "TIFINAGH LETTER BERBER ACADEMY YAH");
    map.put('\u2D42', "TIFINAGH LETTER TUAREG YAH");
    map.put('\u2D43', "TIFINAGH LETTER YAHH");
    map.put('\u2D44', "TIFINAGH LETTER YAA");
    map.put('\u2D45', "TIFINAGH LETTER YAKH");
    map.put('\u2D46', "TIFINAGH LETTER TUAREG YAKH");
    map.put('\u2D47', "TIFINAGH LETTER YAQ");
    map.put('\u2D48', "TIFINAGH LETTER TUAREG YAQ");
    map.put('\u2D49', "TIFINAGH LETTER YI");
    map.put('\u2D4A', "TIFINAGH LETTER YAZH");
    map.put('\u2D4B', "TIFINAGH LETTER AHAGGAR YAZH");
    map.put('\u2D4C', "TIFINAGH LETTER TUAREG YAZH");
    map.put('\u2D4D', "TIFINAGH LETTER YAL");
    map.put('\u2D4E', "TIFINAGH LETTER YAM");
    map.put('\u2D4F', "TIFINAGH LETTER YAN");
    map.put('\u2D50', "TIFINAGH LETTER TUAREG YAGN");
    map.put('\u2D51', "TIFINAGH LETTER TUAREG YANG");
    map.put('\u2D52', "TIFINAGH LETTER YAP");
    map.put('\u2D53', "TIFINAGH LETTER YU");
    map.put('\u2D54', "TIFINAGH LETTER YAR");
    map.put('\u2D55', "TIFINAGH LETTER YARR");
    map.put('\u2D56', "TIFINAGH LETTER YAGH");
    map.put('\u2D57', "TIFINAGH LETTER TUAREG YAGH");
    map.put('\u2D58', "TIFINAGH LETTER AYER YAGH");
    map.put('\u2D59', "TIFINAGH LETTER YAS");
    map.put('\u2D5A', "TIFINAGH LETTER YASS");
    map.put('\u2D5B', "TIFINAGH LETTER YASH");
    map.put('\u2D5C', "TIFINAGH LETTER YAT");
    map.put('\u2D5D', "TIFINAGH LETTER YATH");
    map.put('\u2D5E', "TIFINAGH LETTER YACH");
    map.put('\u2D5F', "TIFINAGH LETTER YATT");
    map.put('\u2D60', "TIFINAGH LETTER YAV");
    map.put('\u2D61', "TIFINAGH LETTER YAW");
    map.put('\u2D62', "TIFINAGH LETTER YAY");
    map.put('\u2D63', "TIFINAGH LETTER YAZ");
    map.put('\u2D64', "TIFINAGH LETTER TAWELLEMET YAZ");
    map.put('\u2D65', "TIFINAGH LETTER YAZZ");
    map.put('\u2D6F', "TIFINAGH MODIFIER LETTER LABIALIZATION MARK");
    map.put('\u2D80', "ETHIOPIC SYLLABLE LOA");
    map.put('\u2D81', "ETHIOPIC SYLLABLE MOA");
    map.put('\u2D82', "ETHIOPIC SYLLABLE ROA");
    map.put('\u2D83', "ETHIOPIC SYLLABLE SOA");
    map.put('\u2D84', "ETHIOPIC SYLLABLE SHOA");
    map.put('\u2D85', "ETHIOPIC SYLLABLE BOA");
    map.put('\u2D86', "ETHIOPIC SYLLABLE TOA");
    map.put('\u2D87', "ETHIOPIC SYLLABLE COA");
    map.put('\u2D88', "ETHIOPIC SYLLABLE NOA");
    map.put('\u2D89', "ETHIOPIC SYLLABLE NYOA");
    map.put('\u2D8A', "ETHIOPIC SYLLABLE GLOTTAL OA");
    map.put('\u2D8B', "ETHIOPIC SYLLABLE ZOA");
    map.put('\u2D8C', "ETHIOPIC SYLLABLE DOA");
    map.put('\u2D8D', "ETHIOPIC SYLLABLE DDOA");
    map.put('\u2D8E', "ETHIOPIC SYLLABLE JOA");
    map.put('\u2D8F', "ETHIOPIC SYLLABLE THOA");
    map.put('\u2D90', "ETHIOPIC SYLLABLE CHOA");
    map.put('\u2D91', "ETHIOPIC SYLLABLE PHOA");
    map.put('\u2D92', "ETHIOPIC SYLLABLE POA");
    map.put('\u2D93', "ETHIOPIC SYLLABLE GGWA");
    map.put('\u2D94', "ETHIOPIC SYLLABLE GGWI");
    map.put('\u2D95', "ETHIOPIC SYLLABLE GGWEE");
    map.put('\u2D96', "ETHIOPIC SYLLABLE GGWE");
    map.put('\u2DA0', "ETHIOPIC SYLLABLE SSA");
    map.put('\u2DA1', "ETHIOPIC SYLLABLE SSU");
    map.put('\u2DA2', "ETHIOPIC SYLLABLE SSI");
    map.put('\u2DA3', "ETHIOPIC SYLLABLE SSAA");
    map.put('\u2DA4', "ETHIOPIC SYLLABLE SSEE");
    map.put('\u2DA5', "ETHIOPIC SYLLABLE SSE");
    map.put('\u2DA6', "ETHIOPIC SYLLABLE SSO");
    map.put('\u2DA8', "ETHIOPIC SYLLABLE CCA");
    map.put('\u2DA9', "ETHIOPIC SYLLABLE CCU");
    map.put('\u2DAA', "ETHIOPIC SYLLABLE CCI");
    map.put('\u2DAB', "ETHIOPIC SYLLABLE CCAA");
    map.put('\u2DAC', "ETHIOPIC SYLLABLE CCEE");
    map.put('\u2DAD', "ETHIOPIC SYLLABLE CCE");
    map.put('\u2DAE', "ETHIOPIC SYLLABLE CCO");
    map.put('\u2DB0', "ETHIOPIC SYLLABLE ZZA");
    map.put('\u2DB1', "ETHIOPIC SYLLABLE ZZU");
    map.put('\u2DB2', "ETHIOPIC SYLLABLE ZZI");
    map.put('\u2DB3', "ETHIOPIC SYLLABLE ZZAA");
    map.put('\u2DB4', "ETHIOPIC SYLLABLE ZZEE");
    map.put('\u2DB5', "ETHIOPIC SYLLABLE ZZE");
    map.put('\u2DB6', "ETHIOPIC SYLLABLE ZZO");
    map.put('\u2DB8', "ETHIOPIC SYLLABLE CCHA");
    map.put('\u2DB9', "ETHIOPIC SYLLABLE CCHU");
    map.put('\u2DBA', "ETHIOPIC SYLLABLE CCHI");
    map.put('\u2DBB', "ETHIOPIC SYLLABLE CCHAA");
    map.put('\u2DBC', "ETHIOPIC SYLLABLE CCHEE");
    map.put('\u2DBD', "ETHIOPIC SYLLABLE CCHE");
    map.put('\u2DBE', "ETHIOPIC SYLLABLE CCHO");
    map.put('\u2DC0', "ETHIOPIC SYLLABLE QYA");
    map.put('\u2DC1', "ETHIOPIC SYLLABLE QYU");
    map.put('\u2DC2', "ETHIOPIC SYLLABLE QYI");
    map.put('\u2DC3', "ETHIOPIC SYLLABLE QYAA");
    map.put('\u2DC4', "ETHIOPIC SYLLABLE QYEE");
    map.put('\u2DC5', "ETHIOPIC SYLLABLE QYE");
    map.put('\u2DC6', "ETHIOPIC SYLLABLE QYO");
    map.put('\u2DC8', "ETHIOPIC SYLLABLE KYA");
    map.put('\u2DC9', "ETHIOPIC SYLLABLE KYU");
    map.put('\u2DCA', "ETHIOPIC SYLLABLE KYI");
    map.put('\u2DCB', "ETHIOPIC SYLLABLE KYAA");
    map.put('\u2DCC', "ETHIOPIC SYLLABLE KYEE");
    map.put('\u2DCD', "ETHIOPIC SYLLABLE KYE");
    map.put('\u2DCE', "ETHIOPIC SYLLABLE KYO");
    map.put('\u2DD0', "ETHIOPIC SYLLABLE XYA");
    map.put('\u2DD1', "ETHIOPIC SYLLABLE XYU");
    map.put('\u2DD2', "ETHIOPIC SYLLABLE XYI");
    map.put('\u2DD3', "ETHIOPIC SYLLABLE XYAA");
    map.put('\u2DD4', "ETHIOPIC SYLLABLE XYEE");
    map.put('\u2DD5', "ETHIOPIC SYLLABLE XYE");
    map.put('\u2DD6', "ETHIOPIC SYLLABLE XYO");
    map.put('\u2DD8', "ETHIOPIC SYLLABLE GYA");
    map.put('\u2DD9', "ETHIOPIC SYLLABLE GYU");
    map.put('\u2DDA', "ETHIOPIC SYLLABLE GYI");
    map.put('\u2DDB', "ETHIOPIC SYLLABLE GYAA");
    map.put('\u2DDC', "ETHIOPIC SYLLABLE GYEE");
    map.put('\u2DDD', "ETHIOPIC SYLLABLE GYE");
    map.put('\u2DDE', "ETHIOPIC SYLLABLE GYO");
    map.put('\u2DE0', "COMBINING CYRILLIC LETTER BE");
    map.put('\u2DE1', "COMBINING CYRILLIC LETTER VE");
    map.put('\u2DE2', "COMBINING CYRILLIC LETTER GHE");
    map.put('\u2DE3', "COMBINING CYRILLIC LETTER DE");
    map.put('\u2DE4', "COMBINING CYRILLIC LETTER ZHE");
    map.put('\u2DE5', "COMBINING CYRILLIC LETTER ZE");
    map.put('\u2DE6', "COMBINING CYRILLIC LETTER KA");
    map.put('\u2DE7', "COMBINING CYRILLIC LETTER EL");
    map.put('\u2DE8', "COMBINING CYRILLIC LETTER EM");
    map.put('\u2DE9', "COMBINING CYRILLIC LETTER EN");
    map.put('\u2DEA', "COMBINING CYRILLIC LETTER O");
    map.put('\u2DEB', "COMBINING CYRILLIC LETTER PE");
    map.put('\u2DEC', "COMBINING CYRILLIC LETTER ER");
    map.put('\u2DED', "COMBINING CYRILLIC LETTER ES");
    map.put('\u2DEE', "COMBINING CYRILLIC LETTER TE");
    map.put('\u2DEF', "COMBINING CYRILLIC LETTER HA");
    map.put('\u2DF0', "COMBINING CYRILLIC LETTER TSE");
    map.put('\u2DF1', "COMBINING CYRILLIC LETTER CHE");
    map.put('\u2DF2', "COMBINING CYRILLIC LETTER SHA");
    map.put('\u2DF3', "COMBINING CYRILLIC LETTER SHCHA");
    map.put('\u2DF4', "COMBINING CYRILLIC LETTER FITA");
    map.put('\u2DF5', "COMBINING CYRILLIC LETTER ES-TE");
    map.put('\u2DF6', "COMBINING CYRILLIC LETTER A");
    map.put('\u2DF7', "COMBINING CYRILLIC LETTER IE");
    map.put('\u2DF8', "COMBINING CYRILLIC LETTER DJERV");
    map.put('\u2DF9', "COMBINING CYRILLIC LETTER MONOGRAPH UK");
    map.put('\u2DFA', "COMBINING CYRILLIC LETTER YAT");
    map.put('\u2DFB', "COMBINING CYRILLIC LETTER YU");
    map.put('\u2DFC', "COMBINING CYRILLIC LETTER IOTIFIED A");
    map.put('\u2DFD', "COMBINING CYRILLIC LETTER LITTLE YUS");
    map.put('\u2DFE', "COMBINING CYRILLIC LETTER BIG YUS");
    map.put('\u2DFF', "COMBINING CYRILLIC LETTER IOTIFIED BIG YUS");
    map.put('\u2E00', "RIGHT ANGLE SUBSTITUTION MARKER");
    map.put('\u2E01', "RIGHT ANGLE DOTTED SUBSTITUTION MARKER");
    map.put('\u2E02', "LEFT SUBSTITUTION BRACKET");
    map.put('\u2E03', "RIGHT SUBSTITUTION BRACKET");
    map.put('\u2E04', "LEFT DOTTED SUBSTITUTION BRACKET");
    map.put('\u2E05', "RIGHT DOTTED SUBSTITUTION BRACKET");
    map.put('\u2E06', "RAISED INTERPOLATION MARKER");
    map.put('\u2E07', "RAISED DOTTED INTERPOLATION MARKER");
    map.put('\u2E08', "DOTTED TRANSPOSITION MARKER");
    map.put('\u2E09', "LEFT TRANSPOSITION BRACKET");
    map.put('\u2E0A', "RIGHT TRANSPOSITION BRACKET");
    map.put('\u2E0B', "RAISED SQUARE");
    map.put('\u2E0C', "LEFT RAISED OMISSION BRACKET");
    map.put('\u2E0D', "RIGHT RAISED OMISSION BRACKET");
    map.put('\u2E0E', "EDITORIAL CORONIS");
    map.put('\u2E0F', "PARAGRAPHOS");
    map.put('\u2E10', "FORKED PARAGRAPHOS");
    map.put('\u2E11', "REVERSED FORKED PARAGRAPHOS");
    map.put('\u2E12', "HYPODIASTOLE");
    map.put('\u2E13', "DOTTED OBELOS");
    map.put('\u2E14', "DOWNWARDS ANCORA");
    map.put('\u2E15', "UPWARDS ANCORA");
    map.put('\u2E16', "DOTTED RIGHT-POINTING ANGLE");
    map.put('\u2E17', "DOUBLE OBLIQUE HYPHEN");
    map.put('\u2E18', "INVERTED INTERROBANG");
    map.put('\u2E19', "PALM BRANCH");
    map.put('\u2E1A', "HYPHEN WITH DIAERESIS");
    map.put('\u2E1B', "TILDE WITH RING ABOVE");
    map.put('\u2E1C', "LEFT LOW PARAPHRASE BRACKET");
    map.put('\u2E1D', "RIGHT LOW PARAPHRASE BRACKET");
    map.put('\u2E1E', "TILDE WITH DOT ABOVE");
    map.put('\u2E1F', "TILDE WITH DOT BELOW");
    map.put('\u2E20', "LEFT VERTICAL BAR WITH QUILL");
    map.put('\u2E21', "RIGHT VERTICAL BAR WITH QUILL");
    map.put('\u2E22', "TOP LEFT HALF BRACKET");
    map.put('\u2E23', "TOP RIGHT HALF BRACKET");
    map.put('\u2E24', "BOTTOM LEFT HALF BRACKET");
    map.put('\u2E25', "BOTTOM RIGHT HALF BRACKET");
    map.put('\u2E26', "LEFT SIDEWAYS U BRACKET");
    map.put('\u2E27', "RIGHT SIDEWAYS U BRACKET");
    map.put('\u2E28', "LEFT DOUBLE PARENTHESIS");
    map.put('\u2E29', "RIGHT DOUBLE PARENTHESIS");
    map.put('\u2E2A', "TWO DOTS OVER ONE DOT PUNCTUATION");
    map.put('\u2E2B', "ONE DOT OVER TWO DOTS PUNCTUATION");
    map.put('\u2E2C', "SQUARED FOUR DOT PUNCTUATION");
    map.put('\u2E2D', "FIVE DOT MARK");
    map.put('\u2E2E', "REVERSED QUESTION MARK");
    map.put('\u2E2F', "VERTICAL TILDE");
    map.put('\u2E30', "RING POINT");
    map.put('\u2E31', "WORD SEPARATOR MIDDLE DOT");
    map.put('\u2E80', "CJK RADICAL REPEAT");
    map.put('\u2E81', "CJK RADICAL CLIFF");
    map.put('\u2E82', "CJK RADICAL SECOND ONE");
    map.put('\u2E83', "CJK RADICAL SECOND TWO");
    map.put('\u2E84', "CJK RADICAL SECOND THREE");
    map.put('\u2E85', "CJK RADICAL PERSON");
    map.put('\u2E86', "CJK RADICAL BOX");
    map.put('\u2E87', "CJK RADICAL TABLE");
    map.put('\u2E88', "CJK RADICAL KNIFE ONE");
    map.put('\u2E89', "CJK RADICAL KNIFE TWO");
    map.put('\u2E8A', "CJK RADICAL DIVINATION");
    map.put('\u2E8B', "CJK RADICAL SEAL");
    map.put('\u2E8C', "CJK RADICAL SMALL ONE");
    map.put('\u2E8D', "CJK RADICAL SMALL TWO");
    map.put('\u2E8E', "CJK RADICAL LAME ONE");
    map.put('\u2E8F', "CJK RADICAL LAME TWO");
    map.put('\u2E90', "CJK RADICAL LAME THREE");
    map.put('\u2E91', "CJK RADICAL LAME FOUR");
    map.put('\u2E92', "CJK RADICAL SNAKE");
    map.put('\u2E93', "CJK RADICAL THREAD");
    map.put('\u2E94', "CJK RADICAL SNOUT ONE");
    map.put('\u2E95', "CJK RADICAL SNOUT TWO");
    map.put('\u2E96', "CJK RADICAL HEART ONE");
    map.put('\u2E97', "CJK RADICAL HEART TWO");
    map.put('\u2E98', "CJK RADICAL HAND");
    map.put('\u2E99', "CJK RADICAL RAP");
    map.put('\u2E9B', "CJK RADICAL CHOKE");
    map.put('\u2E9C', "CJK RADICAL SUN");
    map.put('\u2E9D', "CJK RADICAL MOON");
    map.put('\u2E9E', "CJK RADICAL DEATH");
    map.put('\u2E9F', "CJK RADICAL MOTHER");
    map.put('\u2EA0', "CJK RADICAL CIVILIAN");
    map.put('\u2EA1', "CJK RADICAL WATER ONE");
    map.put('\u2EA2', "CJK RADICAL WATER TWO");
    map.put('\u2EA3', "CJK RADICAL FIRE");
    map.put('\u2EA4', "CJK RADICAL PAW ONE");
    map.put('\u2EA5', "CJK RADICAL PAW TWO");
    map.put('\u2EA6', "CJK RADICAL SIMPLIFIED HALF TREE TRUNK");
    map.put('\u2EA7', "CJK RADICAL COW");
    map.put('\u2EA8', "CJK RADICAL DOG");
    map.put('\u2EA9', "CJK RADICAL JADE");
    map.put('\u2EAA', "CJK RADICAL BOLT OF CLOTH");
    map.put('\u2EAB', "CJK RADICAL EYE");
    map.put('\u2EAC', "CJK RADICAL SPIRIT ONE");
    map.put('\u2EAD', "CJK RADICAL SPIRIT TWO");
    map.put('\u2EAE', "CJK RADICAL BAMBOO");
    map.put('\u2EAF', "CJK RADICAL SILK");
    map.put('\u2EB0', "CJK RADICAL C-SIMPLIFIED SILK");
    map.put('\u2EB1', "CJK RADICAL NET ONE");
    map.put('\u2EB2', "CJK RADICAL NET TWO");
    map.put('\u2EB3', "CJK RADICAL NET THREE");
    map.put('\u2EB4', "CJK RADICAL NET FOUR");
    map.put('\u2EB5', "CJK RADICAL MESH");
    map.put('\u2EB6', "CJK RADICAL SHEEP");
    map.put('\u2EB7', "CJK RADICAL RAM");
    map.put('\u2EB8', "CJK RADICAL EWE");
    map.put('\u2EB9', "CJK RADICAL OLD");
    map.put('\u2EBA', "CJK RADICAL BRUSH ONE");
    map.put('\u2EBB', "CJK RADICAL BRUSH TWO");
    map.put('\u2EBC', "CJK RADICAL MEAT");
    map.put('\u2EBD', "CJK RADICAL MORTAR");
    map.put('\u2EBE', "CJK RADICAL GRASS ONE");
    map.put('\u2EBF', "CJK RADICAL GRASS TWO");
    map.put('\u2EC0', "CJK RADICAL GRASS THREE");
    map.put('\u2EC1', "CJK RADICAL TIGER");
    map.put('\u2EC2', "CJK RADICAL CLOTHES");
    map.put('\u2EC3', "CJK RADICAL WEST ONE");
    map.put('\u2EC4', "CJK RADICAL WEST TWO");
    map.put('\u2EC5', "CJK RADICAL C-SIMPLIFIED SEE");
    map.put('\u2EC6', "CJK RADICAL SIMPLIFIED HORN");
    map.put('\u2EC7', "CJK RADICAL HORN");
    map.put('\u2EC8', "CJK RADICAL C-SIMPLIFIED SPEECH");
    map.put('\u2EC9', "CJK RADICAL C-SIMPLIFIED SHELL");
    map.put('\u2ECA', "CJK RADICAL FOOT");
    map.put('\u2ECB', "CJK RADICAL C-SIMPLIFIED CART");
    map.put('\u2ECC', "CJK RADICAL SIMPLIFIED WALK");
    map.put('\u2ECD', "CJK RADICAL WALK ONE");
    map.put('\u2ECE', "CJK RADICAL WALK TWO");
    map.put('\u2ECF', "CJK RADICAL CITY");
    map.put('\u2ED0', "CJK RADICAL C-SIMPLIFIED GOLD");
    map.put('\u2ED1', "CJK RADICAL LONG ONE");
    map.put('\u2ED2', "CJK RADICAL LONG TWO");
    map.put('\u2ED3', "CJK RADICAL C-SIMPLIFIED LONG");
    map.put('\u2ED4', "CJK RADICAL C-SIMPLIFIED GATE");
    map.put('\u2ED5', "CJK RADICAL MOUND ONE");
    map.put('\u2ED6', "CJK RADICAL MOUND TWO");
    map.put('\u2ED7', "CJK RADICAL RAIN");
    map.put('\u2ED8', "CJK RADICAL BLUE");
    map.put('\u2ED9', "CJK RADICAL C-SIMPLIFIED TANNED LEATHER");
    map.put('\u2EDA', "CJK RADICAL C-SIMPLIFIED LEAF");
    map.put('\u2EDB', "CJK RADICAL C-SIMPLIFIED WIND");
    map.put('\u2EDC', "CJK RADICAL C-SIMPLIFIED FLY");
    map.put('\u2EDD', "CJK RADICAL EAT ONE");
    map.put('\u2EDE', "CJK RADICAL EAT TWO");
    map.put('\u2EDF', "CJK RADICAL EAT THREE");
    map.put('\u2EE0', "CJK RADICAL C-SIMPLIFIED EAT");
    map.put('\u2EE1', "CJK RADICAL HEAD");
    map.put('\u2EE2', "CJK RADICAL C-SIMPLIFIED HORSE");
    map.put('\u2EE3', "CJK RADICAL BONE");
    map.put('\u2EE4', "CJK RADICAL GHOST");
    map.put('\u2EE5', "CJK RADICAL C-SIMPLIFIED FISH");
    map.put('\u2EE6', "CJK RADICAL C-SIMPLIFIED BIRD");
    map.put('\u2EE7', "CJK RADICAL C-SIMPLIFIED SALT");
    map.put('\u2EE8', "CJK RADICAL SIMPLIFIED WHEAT");
    map.put('\u2EE9', "CJK RADICAL SIMPLIFIED YELLOW");
    map.put('\u2EEA', "CJK RADICAL C-SIMPLIFIED FROG");
    map.put('\u2EEB', "CJK RADICAL J-SIMPLIFIED EVEN");
    map.put('\u2EEC', "CJK RADICAL C-SIMPLIFIED EVEN");
    map.put('\u2EED', "CJK RADICAL J-SIMPLIFIED TOOTH");
    map.put('\u2EEE', "CJK RADICAL C-SIMPLIFIED TOOTH");
    map.put('\u2EEF', "CJK RADICAL J-SIMPLIFIED DRAGON");
    map.put('\u2EF0', "CJK RADICAL C-SIMPLIFIED DRAGON");
    map.put('\u2EF1', "CJK RADICAL TURTLE");
    map.put('\u2EF2', "CJK RADICAL J-SIMPLIFIED TURTLE");
    map.put('\u2EF3', "CJK RADICAL C-SIMPLIFIED TURTLE");
    map.put('\u2F00', "KANGXI RADICAL ONE");
    map.put('\u2F01', "KANGXI RADICAL LINE");
    map.put('\u2F02', "KANGXI RADICAL DOT");
    map.put('\u2F03', "KANGXI RADICAL SLASH");
    map.put('\u2F04', "KANGXI RADICAL SECOND");
    map.put('\u2F05', "KANGXI RADICAL HOOK");
    map.put('\u2F06', "KANGXI RADICAL TWO");
    map.put('\u2F07', "KANGXI RADICAL LID");
    map.put('\u2F08', "KANGXI RADICAL MAN");
    map.put('\u2F09', "KANGXI RADICAL LEGS");
    map.put('\u2F0A', "KANGXI RADICAL ENTER");
    map.put('\u2F0B', "KANGXI RADICAL EIGHT");
    map.put('\u2F0C', "KANGXI RADICAL DOWN BOX");
    map.put('\u2F0D', "KANGXI RADICAL COVER");
    map.put('\u2F0E', "KANGXI RADICAL ICE");
    map.put('\u2F0F', "KANGXI RADICAL TABLE");
    map.put('\u2F10', "KANGXI RADICAL OPEN BOX");
    map.put('\u2F11', "KANGXI RADICAL KNIFE");
    map.put('\u2F12', "KANGXI RADICAL POWER");
    map.put('\u2F13', "KANGXI RADICAL WRAP");
    map.put('\u2F14', "KANGXI RADICAL SPOON");
    map.put('\u2F15', "KANGXI RADICAL RIGHT OPEN BOX");
    map.put('\u2F16', "KANGXI RADICAL HIDING ENCLOSURE");
    map.put('\u2F17', "KANGXI RADICAL TEN");
    map.put('\u2F18', "KANGXI RADICAL DIVINATION");
    map.put('\u2F19', "KANGXI RADICAL SEAL");
    map.put('\u2F1A', "KANGXI RADICAL CLIFF");
    map.put('\u2F1B', "KANGXI RADICAL PRIVATE");
    map.put('\u2F1C', "KANGXI RADICAL AGAIN");
    map.put('\u2F1D', "KANGXI RADICAL MOUTH");
    map.put('\u2F1E', "KANGXI RADICAL ENCLOSURE");
    map.put('\u2F1F', "KANGXI RADICAL EARTH");
    map.put('\u2F20', "KANGXI RADICAL SCHOLAR");
    map.put('\u2F21', "KANGXI RADICAL GO");
    map.put('\u2F22', "KANGXI RADICAL GO SLOWLY");
    map.put('\u2F23', "KANGXI RADICAL EVENING");
    map.put('\u2F24', "KANGXI RADICAL BIG");
    map.put('\u2F25', "KANGXI RADICAL WOMAN");
    map.put('\u2F26', "KANGXI RADICAL CHILD");
    map.put('\u2F27', "KANGXI RADICAL ROOF");
    map.put('\u2F28', "KANGXI RADICAL INCH");
    map.put('\u2F29', "KANGXI RADICAL SMALL");
    map.put('\u2F2A', "KANGXI RADICAL LAME");
    map.put('\u2F2B', "KANGXI RADICAL CORPSE");
    map.put('\u2F2C', "KANGXI RADICAL SPROUT");
    map.put('\u2F2D', "KANGXI RADICAL MOUNTAIN");
    map.put('\u2F2E', "KANGXI RADICAL RIVER");
    map.put('\u2F2F', "KANGXI RADICAL WORK");
    map.put('\u2F30', "KANGXI RADICAL ONESELF");
    map.put('\u2F31', "KANGXI RADICAL TURBAN");
    map.put('\u2F32', "KANGXI RADICAL DRY");
    map.put('\u2F33', "KANGXI RADICAL SHORT THREAD");
    map.put('\u2F34', "KANGXI RADICAL DOTTED CLIFF");
    map.put('\u2F35', "KANGXI RADICAL LONG STRIDE");
    map.put('\u2F36', "KANGXI RADICAL TWO HANDS");
    map.put('\u2F37', "KANGXI RADICAL SHOOT");
    map.put('\u2F38', "KANGXI RADICAL BOW");
    map.put('\u2F39', "KANGXI RADICAL SNOUT");
    map.put('\u2F3A', "KANGXI RADICAL BRISTLE");
    map.put('\u2F3B', "KANGXI RADICAL STEP");
    map.put('\u2F3C', "KANGXI RADICAL HEART");
    map.put('\u2F3D', "KANGXI RADICAL HALBERD");
    map.put('\u2F3E', "KANGXI RADICAL DOOR");
    map.put('\u2F3F', "KANGXI RADICAL HAND");
    map.put('\u2F40', "KANGXI RADICAL BRANCH");
    map.put('\u2F41', "KANGXI RADICAL RAP");
    map.put('\u2F42', "KANGXI RADICAL SCRIPT");
    map.put('\u2F43', "KANGXI RADICAL DIPPER");
    map.put('\u2F44', "KANGXI RADICAL AXE");
    map.put('\u2F45', "KANGXI RADICAL SQUARE");
    map.put('\u2F46', "KANGXI RADICAL NOT");
    map.put('\u2F47', "KANGXI RADICAL SUN");
    map.put('\u2F48', "KANGXI RADICAL SAY");
    map.put('\u2F49', "KANGXI RADICAL MOON");
    map.put('\u2F4A', "KANGXI RADICAL TREE");
    map.put('\u2F4B', "KANGXI RADICAL LACK");
    map.put('\u2F4C', "KANGXI RADICAL STOP");
    map.put('\u2F4D', "KANGXI RADICAL DEATH");
    map.put('\u2F4E', "KANGXI RADICAL WEAPON");
    map.put('\u2F4F', "KANGXI RADICAL DO NOT");
    map.put('\u2F50', "KANGXI RADICAL COMPARE");
    map.put('\u2F51', "KANGXI RADICAL FUR");
    map.put('\u2F52', "KANGXI RADICAL CLAN");
    map.put('\u2F53', "KANGXI RADICAL STEAM");
    map.put('\u2F54', "KANGXI RADICAL WATER");
    map.put('\u2F55', "KANGXI RADICAL FIRE");
    map.put('\u2F56', "KANGXI RADICAL CLAW");
    map.put('\u2F57', "KANGXI RADICAL FATHER");
    map.put('\u2F58', "KANGXI RADICAL DOUBLE X");
    map.put('\u2F59', "KANGXI RADICAL HALF TREE TRUNK");
    map.put('\u2F5A', "KANGXI RADICAL SLICE");
    map.put('\u2F5B', "KANGXI RADICAL FANG");
    map.put('\u2F5C', "KANGXI RADICAL COW");
    map.put('\u2F5D', "KANGXI RADICAL DOG");
    map.put('\u2F5E', "KANGXI RADICAL PROFOUND");
    map.put('\u2F5F', "KANGXI RADICAL JADE");
    map.put('\u2F60', "KANGXI RADICAL MELON");
    map.put('\u2F61', "KANGXI RADICAL TILE");
    map.put('\u2F62', "KANGXI RADICAL SWEET");
    map.put('\u2F63', "KANGXI RADICAL LIFE");
    map.put('\u2F64', "KANGXI RADICAL USE");
    map.put('\u2F65', "KANGXI RADICAL FIELD");
    map.put('\u2F66', "KANGXI RADICAL BOLT OF CLOTH");
    map.put('\u2F67', "KANGXI RADICAL SICKNESS");
    map.put('\u2F68', "KANGXI RADICAL DOTTED TENT");
    map.put('\u2F69', "KANGXI RADICAL WHITE");
    map.put('\u2F6A', "KANGXI RADICAL SKIN");
    map.put('\u2F6B', "KANGXI RADICAL DISH");
    map.put('\u2F6C', "KANGXI RADICAL EYE");
    map.put('\u2F6D', "KANGXI RADICAL SPEAR");
    map.put('\u2F6E', "KANGXI RADICAL ARROW");
    map.put('\u2F6F', "KANGXI RADICAL STONE");
    map.put('\u2F70', "KANGXI RADICAL SPIRIT");
    map.put('\u2F71', "KANGXI RADICAL TRACK");
    map.put('\u2F72', "KANGXI RADICAL GRAIN");
    map.put('\u2F73', "KANGXI RADICAL CAVE");
    map.put('\u2F74', "KANGXI RADICAL STAND");
    map.put('\u2F75', "KANGXI RADICAL BAMBOO");
    map.put('\u2F76', "KANGXI RADICAL RICE");
    map.put('\u2F77', "KANGXI RADICAL SILK");
    map.put('\u2F78', "KANGXI RADICAL JAR");
    map.put('\u2F79', "KANGXI RADICAL NET");
    map.put('\u2F7A', "KANGXI RADICAL SHEEP");
    map.put('\u2F7B', "KANGXI RADICAL FEATHER");
    map.put('\u2F7C', "KANGXI RADICAL OLD");
    map.put('\u2F7D', "KANGXI RADICAL AND");
    map.put('\u2F7E', "KANGXI RADICAL PLOW");
    map.put('\u2F7F', "KANGXI RADICAL EAR");
    map.put('\u2F80', "KANGXI RADICAL BRUSH");
    map.put('\u2F81', "KANGXI RADICAL MEAT");
    map.put('\u2F82', "KANGXI RADICAL MINISTER");
    map.put('\u2F83', "KANGXI RADICAL SELF");
    map.put('\u2F84', "KANGXI RADICAL ARRIVE");
    map.put('\u2F85', "KANGXI RADICAL MORTAR");
    map.put('\u2F86', "KANGXI RADICAL TONGUE");
    map.put('\u2F87', "KANGXI RADICAL OPPOSE");
    map.put('\u2F88', "KANGXI RADICAL BOAT");
    map.put('\u2F89', "KANGXI RADICAL STOPPING");
    map.put('\u2F8A', "KANGXI RADICAL COLOR");
    map.put('\u2F8B', "KANGXI RADICAL GRASS");
    map.put('\u2F8C', "KANGXI RADICAL TIGER");
    map.put('\u2F8D', "KANGXI RADICAL INSECT");
    map.put('\u2F8E', "KANGXI RADICAL BLOOD");
    map.put('\u2F8F', "KANGXI RADICAL WALK ENCLOSURE");
    map.put('\u2F90', "KANGXI RADICAL CLOTHES");
    map.put('\u2F91', "KANGXI RADICAL WEST");
    map.put('\u2F92', "KANGXI RADICAL SEE");
    map.put('\u2F93', "KANGXI RADICAL HORN");
    map.put('\u2F94', "KANGXI RADICAL SPEECH");
    map.put('\u2F95', "KANGXI RADICAL VALLEY");
    map.put('\u2F96', "KANGXI RADICAL BEAN");
    map.put('\u2F97', "KANGXI RADICAL PIG");
    map.put('\u2F98', "KANGXI RADICAL BADGER");
    map.put('\u2F99', "KANGXI RADICAL SHELL");
    map.put('\u2F9A', "KANGXI RADICAL RED");
    map.put('\u2F9B', "KANGXI RADICAL RUN");
    map.put('\u2F9C', "KANGXI RADICAL FOOT");
    map.put('\u2F9D', "KANGXI RADICAL BODY");
    map.put('\u2F9E', "KANGXI RADICAL CART");
    map.put('\u2F9F', "KANGXI RADICAL BITTER");
    map.put('\u2FA0', "KANGXI RADICAL MORNING");
    map.put('\u2FA1', "KANGXI RADICAL WALK");
    map.put('\u2FA2', "KANGXI RADICAL CITY");
    map.put('\u2FA3', "KANGXI RADICAL WINE");
    map.put('\u2FA4', "KANGXI RADICAL DISTINGUISH");
    map.put('\u2FA5', "KANGXI RADICAL VILLAGE");
    map.put('\u2FA6', "KANGXI RADICAL GOLD");
    map.put('\u2FA7', "KANGXI RADICAL LONG");
    map.put('\u2FA8', "KANGXI RADICAL GATE");
    map.put('\u2FA9', "KANGXI RADICAL MOUND");
    map.put('\u2FAA', "KANGXI RADICAL SLAVE");
    map.put('\u2FAB', "KANGXI RADICAL SHORT TAILED BIRD");
    map.put('\u2FAC', "KANGXI RADICAL RAIN");
    map.put('\u2FAD', "KANGXI RADICAL BLUE");
    map.put('\u2FAE', "KANGXI RADICAL WRONG");
    map.put('\u2FAF', "KANGXI RADICAL FACE");
    map.put('\u2FB0', "KANGXI RADICAL LEATHER");
    map.put('\u2FB1', "KANGXI RADICAL TANNED LEATHER");
    map.put('\u2FB2', "KANGXI RADICAL LEEK");
    map.put('\u2FB3', "KANGXI RADICAL SOUND");
    map.put('\u2FB4', "KANGXI RADICAL LEAF");
    map.put('\u2FB5', "KANGXI RADICAL WIND");
    map.put('\u2FB6', "KANGXI RADICAL FLY");
    map.put('\u2FB7', "KANGXI RADICAL EAT");
    map.put('\u2FB8', "KANGXI RADICAL HEAD");
    map.put('\u2FB9', "KANGXI RADICAL FRAGRANT");
    map.put('\u2FBA', "KANGXI RADICAL HORSE");
    map.put('\u2FBB', "KANGXI RADICAL BONE");
    map.put('\u2FBC', "KANGXI RADICAL TALL");
    map.put('\u2FBD', "KANGXI RADICAL HAIR");
    map.put('\u2FBE', "KANGXI RADICAL FIGHT");
    map.put('\u2FBF', "KANGXI RADICAL SACRIFICIAL WINE");
    map.put('\u2FC0', "KANGXI RADICAL CAULDRON");
    map.put('\u2FC1', "KANGXI RADICAL GHOST");
    map.put('\u2FC2', "KANGXI RADICAL FISH");
    map.put('\u2FC3', "KANGXI RADICAL BIRD");
    map.put('\u2FC4', "KANGXI RADICAL SALT");
    map.put('\u2FC5', "KANGXI RADICAL DEER");
    map.put('\u2FC6', "KANGXI RADICAL WHEAT");
    map.put('\u2FC7', "KANGXI RADICAL HEMP");
    map.put('\u2FC8', "KANGXI RADICAL YELLOW");
    map.put('\u2FC9', "KANGXI RADICAL MILLET");
    map.put('\u2FCA', "KANGXI RADICAL BLACK");
    map.put('\u2FCB', "KANGXI RADICAL EMBROIDERY");
    map.put('\u2FCC', "KANGXI RADICAL FROG");
    map.put('\u2FCD', "KANGXI RADICAL TRIPOD");
    map.put('\u2FCE', "KANGXI RADICAL DRUM");
    map.put('\u2FCF', "KANGXI RADICAL RAT");
    map.put('\u2FD0', "KANGXI RADICAL NOSE");
    map.put('\u2FD1', "KANGXI RADICAL EVEN");
    map.put('\u2FD2', "KANGXI RADICAL TOOTH");
    map.put('\u2FD3', "KANGXI RADICAL DRAGON");
    map.put('\u2FD4', "KANGXI RADICAL TURTLE");
    map.put('\u2FD5', "KANGXI RADICAL FLUTE");
    map.put('\u2FF0', "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT");
    map.put('\u2FF1', "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW");
    map.put('\u2FF2', "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT");
    map.put('\u2FF3', "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW");
    map.put('\u2FF4', "IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND");
    map.put('\u2FF5', "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE");
    map.put('\u2FF6', "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW");
    map.put('\u2FF7', "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT");
    map.put('\u2FF8', "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT");
    map.put('\u2FF9', "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT");
    map.put('\u2FFA', "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT");
    map.put('\u2FFB', "IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID");

  }

  public static final void cjkSymbolsAndPunctuation(Map<Character, String> map) {

    map.put('\u3000', "IDEOGRAPHIC SPACE");
    map.put('\u3001', "IDEOGRAPHIC COMMA");
    map.put('\u3002', "IDEOGRAPHIC FULL STOP");
    map.put('\u3003', "DITTO MARK");
    map.put('\u3004', "JAPANESE INDUSTRIAL STANDARD SYMBOL");
    map.put('\u3005', "IDEOGRAPHIC ITERATION MARK");
    map.put('\u3006', "IDEOGRAPHIC CLOSING MARK");
    map.put('\u3007', "IDEOGRAPHIC NUMBER ZERO");
    map.put('\u3008', "LEFT ANGLE BRACKET");
    map.put('\u3009', "RIGHT ANGLE BRACKET");
    map.put('\u300A', "LEFT DOUBLE ANGLE BRACKET");
    map.put('\u300B', "RIGHT DOUBLE ANGLE BRACKET");
    map.put('\u300C', "LEFT CORNER BRACKET");
    map.put('\u300D', "RIGHT CORNER BRACKET");
    map.put('\u300E', "LEFT WHITE CORNER BRACKET");
    map.put('\u300F', "RIGHT WHITE CORNER BRACKET");
    map.put('\u3010', "LEFT BLACK LENTICULAR BRACKET");
    map.put('\u3011', "RIGHT BLACK LENTICULAR BRACKET");
    map.put('\u3012', "POSTAL MARK");
    map.put('\u3013', "GETA MARK");
    map.put('\u3014', "LEFT TORTOISE SHELL BRACKET");
    map.put('\u3015', "RIGHT TORTOISE SHELL BRACKET");
    map.put('\u3016', "LEFT WHITE LENTICULAR BRACKET");
    map.put('\u3017', "RIGHT WHITE LENTICULAR BRACKET");
    map.put('\u3018', "LEFT WHITE TORTOISE SHELL BRACKET");
    map.put('\u3019', "RIGHT WHITE TORTOISE SHELL BRACKET");
    map.put('\u301A', "LEFT WHITE SQUARE BRACKET");
    map.put('\u301B', "RIGHT WHITE SQUARE BRACKET");
    map.put('\u301C', "WAVE DASH");
    map.put('\u301D', "REVERSED DOUBLE PRIME QUOTATION MARK");
    map.put('\u301E', "DOUBLE PRIME QUOTATION MARK");
    map.put('\u301F', "LOW DOUBLE PRIME QUOTATION MARK");
    map.put('\u3020', "POSTAL MARK FACE");
    map.put('\u3021', "HANGZHOU NUMERAL ONE");
    map.put('\u3022', "HANGZHOU NUMERAL TWO");
    map.put('\u3023', "HANGZHOU NUMERAL THREE");
    map.put('\u3024', "HANGZHOU NUMERAL FOUR");
    map.put('\u3025', "HANGZHOU NUMERAL FIVE");
    map.put('\u3026', "HANGZHOU NUMERAL SIX");
    map.put('\u3027', "HANGZHOU NUMERAL SEVEN");
    map.put('\u3028', "HANGZHOU NUMERAL EIGHT");
    map.put('\u3029', "HANGZHOU NUMERAL NINE");
    map.put('\u302A', "IDEOGRAPHIC LEVEL TONE MARK");
    map.put('\u302B', "IDEOGRAPHIC RISING TONE MARK");
    map.put('\u302C', "IDEOGRAPHIC DEPARTING TONE MARK");
    map.put('\u302D', "IDEOGRAPHIC ENTERING TONE MARK");
    map.put('\u302E', "HANGUL SINGLE DOT TONE MARK");
    map.put('\u302F', "HANGUL DOUBLE DOT TONE MARK");
    map.put('\u3030', "WAVY DASH");
    map.put('\u3031', "VERTICAL KANA REPEAT MARK");
    map.put('\u3032', "VERTICAL KANA REPEAT WITH VOICED SOUND MARK");
    map.put('\u3033', "VERTICAL KANA REPEAT MARK UPPER HALF");
    map.put('\u3034', "VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF");
    map.put('\u3035', "VERTICAL KANA REPEAT MARK LOWER HALF");
    map.put('\u3036', "CIRCLED POSTAL MARK");
    map.put('\u3037', "IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL");
    map.put('\u3038', "HANGZHOU NUMERAL TEN");
    map.put('\u3039', "HANGZHOU NUMERAL TWENTY");
    map.put('\u303A', "HANGZHOU NUMERAL THIRTY");
    map.put('\u303B', "VERTICAL IDEOGRAPHIC ITERATION MARK");
    map.put('\u303C', "MASU MARK");
    map.put('\u303D', "PART ALTERNATION MARK");
    map.put('\u303E', "IDEOGRAPHIC VARIATION INDICATOR");
    map.put('\u303F', "IDEOGRAPHIC HALF FILL SPACE");
    map.put('\u3041', "HIRAGANA LETTER SMALL A");
    map.put('\u3042', "HIRAGANA LETTER A");
    map.put('\u3043', "HIRAGANA LETTER SMALL I");
    map.put('\u3044', "HIRAGANA LETTER I");
    map.put('\u3045', "HIRAGANA LETTER SMALL U");
    map.put('\u3046', "HIRAGANA LETTER U");
    map.put('\u3047', "HIRAGANA LETTER SMALL E");
    map.put('\u3048', "HIRAGANA LETTER E");
    map.put('\u3049', "HIRAGANA LETTER SMALL O");
    map.put('\u304A', "HIRAGANA LETTER O");
    map.put('\u304B', "HIRAGANA LETTER KA");
    map.put('\u304C', "HIRAGANA LETTER GA");
    map.put('\u304D', "HIRAGANA LETTER KI");
    map.put('\u304E', "HIRAGANA LETTER GI");
    map.put('\u304F', "HIRAGANA LETTER KU");
    map.put('\u3050', "HIRAGANA LETTER GU");
    map.put('\u3051', "HIRAGANA LETTER KE");
    map.put('\u3052', "HIRAGANA LETTER GE");
    map.put('\u3053', "HIRAGANA LETTER KO");
    map.put('\u3054', "HIRAGANA LETTER GO");
    map.put('\u3055', "HIRAGANA LETTER SA");
    map.put('\u3056', "HIRAGANA LETTER ZA");
    map.put('\u3057', "HIRAGANA LETTER SI");
    map.put('\u3058', "HIRAGANA LETTER ZI");
    map.put('\u3059', "HIRAGANA LETTER SU");
    map.put('\u305A', "HIRAGANA LETTER ZU");
    map.put('\u305B', "HIRAGANA LETTER SE");
    map.put('\u305C', "HIRAGANA LETTER ZE");
    map.put('\u305D', "HIRAGANA LETTER SO");
    map.put('\u305E', "HIRAGANA LETTER ZO");
    map.put('\u305F', "HIRAGANA LETTER TA");
    map.put('\u3060', "HIRAGANA LETTER DA");
    map.put('\u3061', "HIRAGANA LETTER TI");
    map.put('\u3062', "HIRAGANA LETTER DI");
    map.put('\u3063', "HIRAGANA LETTER SMALL TU");
    map.put('\u3064', "HIRAGANA LETTER TU");
    map.put('\u3065', "HIRAGANA LETTER DU");
    map.put('\u3066', "HIRAGANA LETTER TE");
    map.put('\u3067', "HIRAGANA LETTER DE");
    map.put('\u3068', "HIRAGANA LETTER TO");
    map.put('\u3069', "HIRAGANA LETTER DO");
    map.put('\u306A', "HIRAGANA LETTER NA");
    map.put('\u306B', "HIRAGANA LETTER NI");
    map.put('\u306C', "HIRAGANA LETTER NU");
    map.put('\u306D', "HIRAGANA LETTER NE");
    map.put('\u306E', "HIRAGANA LETTER NO");
    map.put('\u306F', "HIRAGANA LETTER HA");
    map.put('\u3070', "HIRAGANA LETTER BA");
    map.put('\u3071', "HIRAGANA LETTER PA");
    map.put('\u3072', "HIRAGANA LETTER HI");
    map.put('\u3073', "HIRAGANA LETTER BI");
    map.put('\u3074', "HIRAGANA LETTER PI");
    map.put('\u3075', "HIRAGANA LETTER HU");
    map.put('\u3076', "HIRAGANA LETTER BU");
    map.put('\u3077', "HIRAGANA LETTER PU");
    map.put('\u3078', "HIRAGANA LETTER HE");
    map.put('\u3079', "HIRAGANA LETTER BE");
    map.put('\u307A', "HIRAGANA LETTER PE");
    map.put('\u307B', "HIRAGANA LETTER HO");
    map.put('\u307C', "HIRAGANA LETTER BO");
    map.put('\u307D', "HIRAGANA LETTER PO");
    map.put('\u307E', "HIRAGANA LETTER MA");
    map.put('\u307F', "HIRAGANA LETTER MI");
    map.put('\u3080', "HIRAGANA LETTER MU");
    map.put('\u3081', "HIRAGANA LETTER ME");
    map.put('\u3082', "HIRAGANA LETTER MO");
    map.put('\u3083', "HIRAGANA LETTER SMALL YA");
    map.put('\u3084', "HIRAGANA LETTER YA");
    map.put('\u3085', "HIRAGANA LETTER SMALL YU");
    map.put('\u3086', "HIRAGANA LETTER YU");
    map.put('\u3087', "HIRAGANA LETTER SMALL YO");
    map.put('\u3088', "HIRAGANA LETTER YO");
    map.put('\u3089', "HIRAGANA LETTER RA");
    map.put('\u308A', "HIRAGANA LETTER RI");
    map.put('\u308B', "HIRAGANA LETTER RU");
    map.put('\u308C', "HIRAGANA LETTER RE");
    map.put('\u308D', "HIRAGANA LETTER RO");
    map.put('\u308E', "HIRAGANA LETTER SMALL WA");
    map.put('\u308F', "HIRAGANA LETTER WA");
    map.put('\u3090', "HIRAGANA LETTER WI");
    map.put('\u3091', "HIRAGANA LETTER WE");
    map.put('\u3092', "HIRAGANA LETTER WO");
    map.put('\u3093', "HIRAGANA LETTER N");
    map.put('\u3094', "HIRAGANA LETTER VU");
    map.put('\u3095', "HIRAGANA LETTER SMALL KA");
    map.put('\u3096', "HIRAGANA LETTER SMALL KE");
    map.put('\u3099', "COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK");
    map.put('\u309A', "COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK");
    map.put('\u309B', "KATAKANA-HIRAGANA VOICED SOUND MARK");
    map.put('\u309C', "KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK");
    map.put('\u309D', "HIRAGANA ITERATION MARK");
    map.put('\u309E', "HIRAGANA VOICED ITERATION MARK");
    map.put('\u309F', "HIRAGANA DIGRAPH YORI");
    map.put('\u30A0', "KATAKANA-HIRAGANA DOUBLE HYPHEN");
    map.put('\u30A1', "KATAKANA LETTER SMALL A");
    map.put('\u30A2', "KATAKANA LETTER A");
    map.put('\u30A3', "KATAKANA LETTER SMALL I");
    map.put('\u30A4', "KATAKANA LETTER I");
    map.put('\u30A5', "KATAKANA LETTER SMALL U");
    map.put('\u30A6', "KATAKANA LETTER U");
    map.put('\u30A7', "KATAKANA LETTER SMALL E");
    map.put('\u30A8', "KATAKANA LETTER E");
    map.put('\u30A9', "KATAKANA LETTER SMALL O");
    map.put('\u30AA', "KATAKANA LETTER O");
    map.put('\u30AB', "KATAKANA LETTER KA");
    map.put('\u30AC', "KATAKANA LETTER GA");
    map.put('\u30AD', "KATAKANA LETTER KI");
    map.put('\u30AE', "KATAKANA LETTER GI");
    map.put('\u30AF', "KATAKANA LETTER KU");
    map.put('\u30B0', "KATAKANA LETTER GU");
    map.put('\u30B1', "KATAKANA LETTER KE");
    map.put('\u30B2', "KATAKANA LETTER GE");
    map.put('\u30B3', "KATAKANA LETTER KO");
    map.put('\u30B4', "KATAKANA LETTER GO");
    map.put('\u30B5', "KATAKANA LETTER SA");
    map.put('\u30B6', "KATAKANA LETTER ZA");
    map.put('\u30B7', "KATAKANA LETTER SI");
    map.put('\u30B8', "KATAKANA LETTER ZI");
    map.put('\u30B9', "KATAKANA LETTER SU");
    map.put('\u30BA', "KATAKANA LETTER ZU");
    map.put('\u30BB', "KATAKANA LETTER SE");
    map.put('\u30BC', "KATAKANA LETTER ZE");
    map.put('\u30BD', "KATAKANA LETTER SO");
    map.put('\u30BE', "KATAKANA LETTER ZO");
    map.put('\u30BF', "KATAKANA LETTER TA");
    map.put('\u30C0', "KATAKANA LETTER DA");
    map.put('\u30C1', "KATAKANA LETTER TI");
    map.put('\u30C2', "KATAKANA LETTER DI");
    map.put('\u30C3', "KATAKANA LETTER SMALL TU");
    map.put('\u30C4', "KATAKANA LETTER TU");
    map.put('\u30C5', "KATAKANA LETTER DU");
    map.put('\u30C6', "KATAKANA LETTER TE");
    map.put('\u30C7', "KATAKANA LETTER DE");
    map.put('\u30C8', "KATAKANA LETTER TO");
    map.put('\u30C9', "KATAKANA LETTER DO");
    map.put('\u30CA', "KATAKANA LETTER NA");
    map.put('\u30CB', "KATAKANA LETTER NI");
    map.put('\u30CC', "KATAKANA LETTER NU");
    map.put('\u30CD', "KATAKANA LETTER NE");
    map.put('\u30CE', "KATAKANA LETTER NO");
    map.put('\u30CF', "KATAKANA LETTER HA");
    map.put('\u30D0', "KATAKANA LETTER BA");
    map.put('\u30D1', "KATAKANA LETTER PA");
    map.put('\u30D2', "KATAKANA LETTER HI");
    map.put('\u30D3', "KATAKANA LETTER BI");
    map.put('\u30D4', "KATAKANA LETTER PI");
    map.put('\u30D5', "KATAKANA LETTER HU");
    map.put('\u30D6', "KATAKANA LETTER BU");
    map.put('\u30D7', "KATAKANA LETTER PU");
    map.put('\u30D8', "KATAKANA LETTER HE");
    map.put('\u30D9', "KATAKANA LETTER BE");
    map.put('\u30DA', "KATAKANA LETTER PE");
    map.put('\u30DB', "KATAKANA LETTER HO");
    map.put('\u30DC', "KATAKANA LETTER BO");
    map.put('\u30DD', "KATAKANA LETTER PO");
    map.put('\u30DE', "KATAKANA LETTER MA");
    map.put('\u30DF', "KATAKANA LETTER MI");
    map.put('\u30E0', "KATAKANA LETTER MU");
    map.put('\u30E1', "KATAKANA LETTER ME");
    map.put('\u30E2', "KATAKANA LETTER MO");
    map.put('\u30E3', "KATAKANA LETTER SMALL YA");
    map.put('\u30E4', "KATAKANA LETTER YA");
    map.put('\u30E5', "KATAKANA LETTER SMALL YU");
    map.put('\u30E6', "KATAKANA LETTER YU");
    map.put('\u30E7', "KATAKANA LETTER SMALL YO");
    map.put('\u30E8', "KATAKANA LETTER YO");
    map.put('\u30E9', "KATAKANA LETTER RA");
    map.put('\u30EA', "KATAKANA LETTER RI");
    map.put('\u30EB', "KATAKANA LETTER RU");
    map.put('\u30EC', "KATAKANA LETTER RE");
    map.put('\u30ED', "KATAKANA LETTER RO");
    map.put('\u30EE', "KATAKANA LETTER SMALL WA");
    map.put('\u30EF', "KATAKANA LETTER WA");
    map.put('\u30F0', "KATAKANA LETTER WI");
    map.put('\u30F1', "KATAKANA LETTER WE");
    map.put('\u30F2', "KATAKANA LETTER WO");
    map.put('\u30F3', "KATAKANA LETTER N");
    map.put('\u30F4', "KATAKANA LETTER VU");
    map.put('\u30F5', "KATAKANA LETTER SMALL KA");
    map.put('\u30F6', "KATAKANA LETTER SMALL KE");
    map.put('\u30F7', "KATAKANA LETTER VA");
    map.put('\u30F8', "KATAKANA LETTER VI");
    map.put('\u30F9', "KATAKANA LETTER VE");
    map.put('\u30FA', "KATAKANA LETTER VO");
    map.put('\u30FB', "KATAKANA MIDDLE DOT");
    map.put('\u30FC', "KATAKANA-HIRAGANA PROLONGED SOUND MARK");
    map.put('\u30FD', "KATAKANA ITERATION MARK");
    map.put('\u30FE', "KATAKANA VOICED ITERATION MARK");
    map.put('\u30FF', "KATAKANA DIGRAPH KOTO");
    map.put('\u3105', "BOPOMOFO LETTER B");
    map.put('\u3106', "BOPOMOFO LETTER P");
    map.put('\u3107', "BOPOMOFO LETTER M");
    map.put('\u3108', "BOPOMOFO LETTER F");
    map.put('\u3109', "BOPOMOFO LETTER D");
    map.put('\u310A', "BOPOMOFO LETTER T");
    map.put('\u310B', "BOPOMOFO LETTER N");
    map.put('\u310C', "BOPOMOFO LETTER L");
    map.put('\u310D', "BOPOMOFO LETTER G");
    map.put('\u310E', "BOPOMOFO LETTER K");
    map.put('\u310F', "BOPOMOFO LETTER H");
    map.put('\u3110', "BOPOMOFO LETTER J");
    map.put('\u3111', "BOPOMOFO LETTER Q");
    map.put('\u3112', "BOPOMOFO LETTER X");
    map.put('\u3113', "BOPOMOFO LETTER ZH");
    map.put('\u3114', "BOPOMOFO LETTER CH");
    map.put('\u3115', "BOPOMOFO LETTER SH");
    map.put('\u3116', "BOPOMOFO LETTER R");
    map.put('\u3117', "BOPOMOFO LETTER Z");
    map.put('\u3118', "BOPOMOFO LETTER C");
    map.put('\u3119', "BOPOMOFO LETTER S");
    map.put('\u311A', "BOPOMOFO LETTER A");
    map.put('\u311B', "BOPOMOFO LETTER O");
    map.put('\u311C', "BOPOMOFO LETTER E");
    map.put('\u311D', "BOPOMOFO LETTER EH");
    map.put('\u311E', "BOPOMOFO LETTER AI");
    map.put('\u311F', "BOPOMOFO LETTER EI");
    map.put('\u3120', "BOPOMOFO LETTER AU");
    map.put('\u3121', "BOPOMOFO LETTER OU");
    map.put('\u3122', "BOPOMOFO LETTER AN");
    map.put('\u3123', "BOPOMOFO LETTER EN");
    map.put('\u3124', "BOPOMOFO LETTER ANG");
    map.put('\u3125', "BOPOMOFO LETTER ENG");
    map.put('\u3126', "BOPOMOFO LETTER ER");
    map.put('\u3127', "BOPOMOFO LETTER I");
    map.put('\u3128', "BOPOMOFO LETTER U");
    map.put('\u3129', "BOPOMOFO LETTER IU");
    map.put('\u312A', "BOPOMOFO LETTER V");
    map.put('\u312B', "BOPOMOFO LETTER NG");
    map.put('\u312C', "BOPOMOFO LETTER GN");
    map.put('\u312D', "BOPOMOFO LETTER IH");
    map.put('\u3131', "HANGUL LETTER KIYEOK");
    map.put('\u3132', "HANGUL LETTER SSANGKIYEOK");
    map.put('\u3133', "HANGUL LETTER KIYEOK-SIOS");
    map.put('\u3134', "HANGUL LETTER NIEUN");
    map.put('\u3135', "HANGUL LETTER NIEUN-CIEUC");
    map.put('\u3136', "HANGUL LETTER NIEUN-HIEUH");
    map.put('\u3137', "HANGUL LETTER TIKEUT");
    map.put('\u3138', "HANGUL LETTER SSANGTIKEUT");
    map.put('\u3139', "HANGUL LETTER RIEUL");
    map.put('\u313A', "HANGUL LETTER RIEUL-KIYEOK");
    map.put('\u313B', "HANGUL LETTER RIEUL-MIEUM");
    map.put('\u313C', "HANGUL LETTER RIEUL-PIEUP");
    map.put('\u313D', "HANGUL LETTER RIEUL-SIOS");
    map.put('\u313E', "HANGUL LETTER RIEUL-THIEUTH");
    map.put('\u313F', "HANGUL LETTER RIEUL-PHIEUPH");
    map.put('\u3140', "HANGUL LETTER RIEUL-HIEUH");
    map.put('\u3141', "HANGUL LETTER MIEUM");
    map.put('\u3142', "HANGUL LETTER PIEUP");
    map.put('\u3143', "HANGUL LETTER SSANGPIEUP");
    map.put('\u3144', "HANGUL LETTER PIEUP-SIOS");
    map.put('\u3145', "HANGUL LETTER SIOS");
    map.put('\u3146', "HANGUL LETTER SSANGSIOS");
    map.put('\u3147', "HANGUL LETTER IEUNG");
    map.put('\u3148', "HANGUL LETTER CIEUC");
    map.put('\u3149', "HANGUL LETTER SSANGCIEUC");
    map.put('\u314A', "HANGUL LETTER CHIEUCH");
    map.put('\u314B', "HANGUL LETTER KHIEUKH");
    map.put('\u314C', "HANGUL LETTER THIEUTH");
    map.put('\u314D', "HANGUL LETTER PHIEUPH");
    map.put('\u314E', "HANGUL LETTER HIEUH");
    map.put('\u314F', "HANGUL LETTER A");
    map.put('\u3150', "HANGUL LETTER AE");
    map.put('\u3151', "HANGUL LETTER YA");
    map.put('\u3152', "HANGUL LETTER YAE");
    map.put('\u3153', "HANGUL LETTER EO");
    map.put('\u3154', "HANGUL LETTER E");
    map.put('\u3155', "HANGUL LETTER YEO");
    map.put('\u3156', "HANGUL LETTER YE");
    map.put('\u3157', "HANGUL LETTER O");
    map.put('\u3158', "HANGUL LETTER WA");
    map.put('\u3159', "HANGUL LETTER WAE");
    map.put('\u315A', "HANGUL LETTER OE");
    map.put('\u315B', "HANGUL LETTER YO");
    map.put('\u315C', "HANGUL LETTER U");
    map.put('\u315D', "HANGUL LETTER WEO");
    map.put('\u315E', "HANGUL LETTER WE");
    map.put('\u315F', "HANGUL LETTER WI");
    map.put('\u3160', "HANGUL LETTER YU");
    map.put('\u3161', "HANGUL LETTER EU");
    map.put('\u3162', "HANGUL LETTER YI");
    map.put('\u3163', "HANGUL LETTER I");
    map.put('\u3164', "HANGUL FILLER");
    map.put('\u3165', "HANGUL LETTER SSANGNIEUN");
    map.put('\u3166', "HANGUL LETTER NIEUN-TIKEUT");
    map.put('\u3167', "HANGUL LETTER NIEUN-SIOS");
    map.put('\u3168', "HANGUL LETTER NIEUN-PANSIOS");
    map.put('\u3169', "HANGUL LETTER RIEUL-KIYEOK-SIOS");
    map.put('\u316A', "HANGUL LETTER RIEUL-TIKEUT");
    map.put('\u316B', "HANGUL LETTER RIEUL-PIEUP-SIOS");
    map.put('\u316C', "HANGUL LETTER RIEUL-PANSIOS");
    map.put('\u316D', "HANGUL LETTER RIEUL-YEORINHIEUH");
    map.put('\u316E', "HANGUL LETTER MIEUM-PIEUP");
    map.put('\u316F', "HANGUL LETTER MIEUM-SIOS");
    map.put('\u3170', "HANGUL LETTER MIEUM-PANSIOS");
    map.put('\u3171', "HANGUL LETTER KAPYEOUNMIEUM");
    map.put('\u3172', "HANGUL LETTER PIEUP-KIYEOK");
    map.put('\u3173', "HANGUL LETTER PIEUP-TIKEUT");
    map.put('\u3174', "HANGUL LETTER PIEUP-SIOS-KIYEOK");
    map.put('\u3175', "HANGUL LETTER PIEUP-SIOS-TIKEUT");
    map.put('\u3176', "HANGUL LETTER PIEUP-CIEUC");
    map.put('\u3177', "HANGUL LETTER PIEUP-THIEUTH");
    map.put('\u3178', "HANGUL LETTER KAPYEOUNPIEUP");
    map.put('\u3179', "HANGUL LETTER KAPYEOUNSSANGPIEUP");
    map.put('\u317A', "HANGUL LETTER SIOS-KIYEOK");
    map.put('\u317B', "HANGUL LETTER SIOS-NIEUN");
    map.put('\u317C', "HANGUL LETTER SIOS-TIKEUT");
    map.put('\u317D', "HANGUL LETTER SIOS-PIEUP");
    map.put('\u317E', "HANGUL LETTER SIOS-CIEUC");
    map.put('\u317F', "HANGUL LETTER PANSIOS");
    map.put('\u3180', "HANGUL LETTER SSANGIEUNG");
    map.put('\u3181', "HANGUL LETTER YESIEUNG");
    map.put('\u3182', "HANGUL LETTER YESIEUNG-SIOS");
    map.put('\u3183', "HANGUL LETTER YESIEUNG-PANSIOS");
    map.put('\u3184', "HANGUL LETTER KAPYEOUNPHIEUPH");
    map.put('\u3185', "HANGUL LETTER SSANGHIEUH");
    map.put('\u3186', "HANGUL LETTER YEORINHIEUH");
    map.put('\u3187', "HANGUL LETTER YO-YA");
    map.put('\u3188', "HANGUL LETTER YO-YAE");
    map.put('\u3189', "HANGUL LETTER YO-I");
    map.put('\u318A', "HANGUL LETTER YU-YEO");
    map.put('\u318B', "HANGUL LETTER YU-YE");
    map.put('\u318C', "HANGUL LETTER YU-I");
    map.put('\u318D', "HANGUL LETTER ARAEA");
    map.put('\u318E', "HANGUL LETTER ARAEAE");
    map.put('\u3190', "IDEOGRAPHIC ANNOTATION LINKING MARK");
    map.put('\u3191', "IDEOGRAPHIC ANNOTATION REVERSE MARK");
    map.put('\u3192', "IDEOGRAPHIC ANNOTATION ONE MARK");
    map.put('\u3193', "IDEOGRAPHIC ANNOTATION TWO MARK");
    map.put('\u3194', "IDEOGRAPHIC ANNOTATION THREE MARK");
    map.put('\u3195', "IDEOGRAPHIC ANNOTATION FOUR MARK");
    map.put('\u3196', "IDEOGRAPHIC ANNOTATION TOP MARK");
    map.put('\u3197', "IDEOGRAPHIC ANNOTATION MIDDLE MARK");
    map.put('\u3198', "IDEOGRAPHIC ANNOTATION BOTTOM MARK");
    map.put('\u3199', "IDEOGRAPHIC ANNOTATION FIRST MARK");
    map.put('\u319A', "IDEOGRAPHIC ANNOTATION SECOND MARK");
    map.put('\u319B', "IDEOGRAPHIC ANNOTATION THIRD MARK");
    map.put('\u319C', "IDEOGRAPHIC ANNOTATION FOURTH MARK");
    map.put('\u319D', "IDEOGRAPHIC ANNOTATION HEAVEN MARK");
    map.put('\u319E', "IDEOGRAPHIC ANNOTATION EARTH MARK");
    map.put('\u319F', "IDEOGRAPHIC ANNOTATION MAN MARK");
    map.put('\u31A0', "BOPOMOFO LETTER BU");
    map.put('\u31A1', "BOPOMOFO LETTER ZI");
    map.put('\u31A2', "BOPOMOFO LETTER JI");
    map.put('\u31A3', "BOPOMOFO LETTER GU");
    map.put('\u31A4', "BOPOMOFO LETTER EE");
    map.put('\u31A5', "BOPOMOFO LETTER ENN");
    map.put('\u31A6', "BOPOMOFO LETTER OO");
    map.put('\u31A7', "BOPOMOFO LETTER ONN");
    map.put('\u31A8', "BOPOMOFO LETTER IR");
    map.put('\u31A9', "BOPOMOFO LETTER ANN");
    map.put('\u31AA', "BOPOMOFO LETTER INN");
    map.put('\u31AB', "BOPOMOFO LETTER UNN");
    map.put('\u31AC', "BOPOMOFO LETTER IM");
    map.put('\u31AD', "BOPOMOFO LETTER NGG");
    map.put('\u31AE', "BOPOMOFO LETTER AINN");
    map.put('\u31AF', "BOPOMOFO LETTER AUNN");
    map.put('\u31B0', "BOPOMOFO LETTER AM");
    map.put('\u31B1', "BOPOMOFO LETTER OM");
    map.put('\u31B2', "BOPOMOFO LETTER ONG");
    map.put('\u31B3', "BOPOMOFO LETTER INNN");
    map.put('\u31B4', "BOPOMOFO FINAL LETTER P");
    map.put('\u31B5', "BOPOMOFO FINAL LETTER T");
    map.put('\u31B6', "BOPOMOFO FINAL LETTER K");
    map.put('\u31B7', "BOPOMOFO FINAL LETTER H");
    map.put('\u31C0', "CJK STROKE T");
    map.put('\u31C1', "CJK STROKE WG");
    map.put('\u31C2', "CJK STROKE XG");
    map.put('\u31C3', "CJK STROKE BXG");
    map.put('\u31C4', "CJK STROKE SW");
    map.put('\u31C5', "CJK STROKE HZZ");
    map.put('\u31C6', "CJK STROKE HZG");
    map.put('\u31C7', "CJK STROKE HP");
    map.put('\u31C8', "CJK STROKE HZWG");
    map.put('\u31C9', "CJK STROKE SZWG");
    map.put('\u31CA', "CJK STROKE HZT");
    map.put('\u31CB', "CJK STROKE HZZP");
    map.put('\u31CC', "CJK STROKE HPWG");
    map.put('\u31CD', "CJK STROKE HZW");
    map.put('\u31CE', "CJK STROKE HZZZ");
    map.put('\u31CF', "CJK STROKE N");
    map.put('\u31D0', "CJK STROKE H");
    map.put('\u31D1', "CJK STROKE S");
    map.put('\u31D2', "CJK STROKE P");
    map.put('\u31D3', "CJK STROKE SP");
    map.put('\u31D4', "CJK STROKE D");
    map.put('\u31D5', "CJK STROKE HZ");
    map.put('\u31D6', "CJK STROKE HG");
    map.put('\u31D7', "CJK STROKE SZ");
    map.put('\u31D8', "CJK STROKE SWZ");
    map.put('\u31D9', "CJK STROKE ST");
    map.put('\u31DA', "CJK STROKE SG");
    map.put('\u31DB', "CJK STROKE PD");
    map.put('\u31DC', "CJK STROKE PZ");
    map.put('\u31DD', "CJK STROKE TN");
    map.put('\u31DE', "CJK STROKE SZZ");
    map.put('\u31DF', "CJK STROKE SWG");
    map.put('\u31E0', "CJK STROKE HXWG");
    map.put('\u31E1', "CJK STROKE HZZZG");
    map.put('\u31E2', "CJK STROKE PG");
    map.put('\u31E3', "CJK STROKE Q");
    map.put('\u31F0', "KATAKANA LETTER SMALL KU");
    map.put('\u31F1', "KATAKANA LETTER SMALL SI");
    map.put('\u31F2', "KATAKANA LETTER SMALL SU");
    map.put('\u31F3', "KATAKANA LETTER SMALL TO");
    map.put('\u31F4', "KATAKANA LETTER SMALL NU");
    map.put('\u31F5', "KATAKANA LETTER SMALL HA");
    map.put('\u31F6', "KATAKANA LETTER SMALL HI");
    map.put('\u31F7', "KATAKANA LETTER SMALL HU");
    map.put('\u31F8', "KATAKANA LETTER SMALL HE");
    map.put('\u31F9', "KATAKANA LETTER SMALL HO");
    map.put('\u31FA', "KATAKANA LETTER SMALL MU");
    map.put('\u31FB', "KATAKANA LETTER SMALL RA");
    map.put('\u31FC', "KATAKANA LETTER SMALL RI");
    map.put('\u31FD', "KATAKANA LETTER SMALL RU");
    map.put('\u31FE', "KATAKANA LETTER SMALL RE");
    map.put('\u31FF', "KATAKANA LETTER SMALL RO");
    map.put('\u3200', "PARENTHESIZED HANGUL KIYEOK");
    map.put('\u3201', "PARENTHESIZED HANGUL NIEUN");
    map.put('\u3202', "PARENTHESIZED HANGUL TIKEUT");
    map.put('\u3203', "PARENTHESIZED HANGUL RIEUL");
    map.put('\u3204', "PARENTHESIZED HANGUL MIEUM");
    map.put('\u3205', "PARENTHESIZED HANGUL PIEUP");
    map.put('\u3206', "PARENTHESIZED HANGUL SIOS");
    map.put('\u3207', "PARENTHESIZED HANGUL IEUNG");
    map.put('\u3208', "PARENTHESIZED HANGUL CIEUC");
    map.put('\u3209', "PARENTHESIZED HANGUL CHIEUCH");
    map.put('\u320A', "PARENTHESIZED HANGUL KHIEUKH");
    map.put('\u320B', "PARENTHESIZED HANGUL THIEUTH");
    map.put('\u320C', "PARENTHESIZED HANGUL PHIEUPH");
    map.put('\u320D', "PARENTHESIZED HANGUL HIEUH");
    map.put('\u320E', "PARENTHESIZED HANGUL KIYEOK A");
    map.put('\u320F', "PARENTHESIZED HANGUL NIEUN A");
    map.put('\u3210', "PARENTHESIZED HANGUL TIKEUT A");
    map.put('\u3211', "PARENTHESIZED HANGUL RIEUL A");
    map.put('\u3212', "PARENTHESIZED HANGUL MIEUM A");
    map.put('\u3213', "PARENTHESIZED HANGUL PIEUP A");
    map.put('\u3214', "PARENTHESIZED HANGUL SIOS A");
    map.put('\u3215', "PARENTHESIZED HANGUL IEUNG A");
    map.put('\u3216', "PARENTHESIZED HANGUL CIEUC A");
    map.put('\u3217', "PARENTHESIZED HANGUL CHIEUCH A");
    map.put('\u3218', "PARENTHESIZED HANGUL KHIEUKH A");
    map.put('\u3219', "PARENTHESIZED HANGUL THIEUTH A");
    map.put('\u321A', "PARENTHESIZED HANGUL PHIEUPH A");
    map.put('\u321B', "PARENTHESIZED HANGUL HIEUH A");
    map.put('\u321C', "PARENTHESIZED HANGUL CIEUC U");
    map.put('\u321D', "PARENTHESIZED KOREAN CHARACTER OJEON");
    map.put('\u321E', "PARENTHESIZED KOREAN CHARACTER O HU");
    map.put('\u3220', "PARENTHESIZED IDEOGRAPH ONE");
    map.put('\u3221', "PARENTHESIZED IDEOGRAPH TWO");
    map.put('\u3222', "PARENTHESIZED IDEOGRAPH THREE");
    map.put('\u3223', "PARENTHESIZED IDEOGRAPH FOUR");
    map.put('\u3224', "PARENTHESIZED IDEOGRAPH FIVE");
    map.put('\u3225', "PARENTHESIZED IDEOGRAPH SIX");
    map.put('\u3226', "PARENTHESIZED IDEOGRAPH SEVEN");
    map.put('\u3227', "PARENTHESIZED IDEOGRAPH EIGHT");
    map.put('\u3228', "PARENTHESIZED IDEOGRAPH NINE");
    map.put('\u3229', "PARENTHESIZED IDEOGRAPH TEN");
    map.put('\u322A', "PARENTHESIZED IDEOGRAPH MOON");
    map.put('\u322B', "PARENTHESIZED IDEOGRAPH FIRE");
    map.put('\u322C', "PARENTHESIZED IDEOGRAPH WATER");
    map.put('\u322D', "PARENTHESIZED IDEOGRAPH WOOD");
    map.put('\u322E', "PARENTHESIZED IDEOGRAPH METAL");
    map.put('\u322F', "PARENTHESIZED IDEOGRAPH EARTH");
    map.put('\u3230', "PARENTHESIZED IDEOGRAPH SUN");
    map.put('\u3231', "PARENTHESIZED IDEOGRAPH STOCK");
    map.put('\u3232', "PARENTHESIZED IDEOGRAPH HAVE");
    map.put('\u3233', "PARENTHESIZED IDEOGRAPH SOCIETY");
    map.put('\u3234', "PARENTHESIZED IDEOGRAPH NAME");
    map.put('\u3235', "PARENTHESIZED IDEOGRAPH SPECIAL");
    map.put('\u3236', "PARENTHESIZED IDEOGRAPH FINANCIAL");
    map.put('\u3237', "PARENTHESIZED IDEOGRAPH CONGRATULATION");
    map.put('\u3238', "PARENTHESIZED IDEOGRAPH LABOR");
    map.put('\u3239', "PARENTHESIZED IDEOGRAPH REPRESENT");
    map.put('\u323A', "PARENTHESIZED IDEOGRAPH CALL");
    map.put('\u323B', "PARENTHESIZED IDEOGRAPH STUDY");
    map.put('\u323C', "PARENTHESIZED IDEOGRAPH SUPERVISE");
    map.put('\u323D', "PARENTHESIZED IDEOGRAPH ENTERPRISE");
    map.put('\u323E', "PARENTHESIZED IDEOGRAPH RESOURCE");
    map.put('\u323F', "PARENTHESIZED IDEOGRAPH ALLIANCE");
    map.put('\u3240', "PARENTHESIZED IDEOGRAPH FESTIVAL");
    map.put('\u3241', "PARENTHESIZED IDEOGRAPH REST");
    map.put('\u3242', "PARENTHESIZED IDEOGRAPH SELF");
    map.put('\u3243', "PARENTHESIZED IDEOGRAPH REACH");
    map.put('\u3244', "CIRCLED IDEOGRAPH QUESTION");
    map.put('\u3245', "CIRCLED IDEOGRAPH KINDERGARTEN");
    map.put('\u3246', "CIRCLED IDEOGRAPH SCHOOL");
    map.put('\u3247', "CIRCLED IDEOGRAPH KOTO");
    map.put('\u3248', "CIRCLED NUMBER TEN ON BLACK SQUARE");
    map.put('\u3249', "CIRCLED NUMBER TWENTY ON BLACK SQUARE");
    map.put('\u324A', "CIRCLED NUMBER THIRTY ON BLACK SQUARE");
    map.put('\u324B', "CIRCLED NUMBER FORTY ON BLACK SQUARE");
    map.put('\u324C', "CIRCLED NUMBER FIFTY ON BLACK SQUARE");
    map.put('\u324D', "CIRCLED NUMBER SIXTY ON BLACK SQUARE");
    map.put('\u324E', "CIRCLED NUMBER SEVENTY ON BLACK SQUARE");
    map.put('\u324F', "CIRCLED NUMBER EIGHTY ON BLACK SQUARE");
    map.put('\u3250', "PARTNERSHIP SIGN");
    map.put('\u3251', "CIRCLED NUMBER TWENTY ONE");
    map.put('\u3252', "CIRCLED NUMBER TWENTY TWO");
    map.put('\u3253', "CIRCLED NUMBER TWENTY THREE");
    map.put('\u3254', "CIRCLED NUMBER TWENTY FOUR");
    map.put('\u3255', "CIRCLED NUMBER TWENTY FIVE");
    map.put('\u3256', "CIRCLED NUMBER TWENTY SIX");
    map.put('\u3257', "CIRCLED NUMBER TWENTY SEVEN");
    map.put('\u3258', "CIRCLED NUMBER TWENTY EIGHT");
    map.put('\u3259', "CIRCLED NUMBER TWENTY NINE");
    map.put('\u325A', "CIRCLED NUMBER THIRTY");
    map.put('\u325B', "CIRCLED NUMBER THIRTY ONE");
    map.put('\u325C', "CIRCLED NUMBER THIRTY TWO");
    map.put('\u325D', "CIRCLED NUMBER THIRTY THREE");
    map.put('\u325E', "CIRCLED NUMBER THIRTY FOUR");
    map.put('\u325F', "CIRCLED NUMBER THIRTY FIVE");
    map.put('\u3260', "CIRCLED HANGUL KIYEOK");
    map.put('\u3261', "CIRCLED HANGUL NIEUN");
    map.put('\u3262', "CIRCLED HANGUL TIKEUT");
    map.put('\u3263', "CIRCLED HANGUL RIEUL");
    map.put('\u3264', "CIRCLED HANGUL MIEUM");
    map.put('\u3265', "CIRCLED HANGUL PIEUP");
    map.put('\u3266', "CIRCLED HANGUL SIOS");
    map.put('\u3267', "CIRCLED HANGUL IEUNG");
    map.put('\u3268', "CIRCLED HANGUL CIEUC");
    map.put('\u3269', "CIRCLED HANGUL CHIEUCH");
    map.put('\u326A', "CIRCLED HANGUL KHIEUKH");
    map.put('\u326B', "CIRCLED HANGUL THIEUTH");
    map.put('\u326C', "CIRCLED HANGUL PHIEUPH");
    map.put('\u326D', "CIRCLED HANGUL HIEUH");
    map.put('\u326E', "CIRCLED HANGUL KIYEOK A");
    map.put('\u326F', "CIRCLED HANGUL NIEUN A");
    map.put('\u3270', "CIRCLED HANGUL TIKEUT A");
    map.put('\u3271', "CIRCLED HANGUL RIEUL A");
    map.put('\u3272', "CIRCLED HANGUL MIEUM A");
    map.put('\u3273', "CIRCLED HANGUL PIEUP A");
    map.put('\u3274', "CIRCLED HANGUL SIOS A");
    map.put('\u3275', "CIRCLED HANGUL IEUNG A");
    map.put('\u3276', "CIRCLED HANGUL CIEUC A");
    map.put('\u3277', "CIRCLED HANGUL CHIEUCH A");
    map.put('\u3278', "CIRCLED HANGUL KHIEUKH A");
    map.put('\u3279', "CIRCLED HANGUL THIEUTH A");
    map.put('\u327A', "CIRCLED HANGUL PHIEUPH A");
    map.put('\u327B', "CIRCLED HANGUL HIEUH A");
    map.put('\u327C', "CIRCLED KOREAN CHARACTER CHAMKO");
    map.put('\u327D', "CIRCLED KOREAN CHARACTER JUEUI");
    map.put('\u327E', "CIRCLED HANGUL IEUNG U");
    map.put('\u327F', "KOREAN STANDARD SYMBOL");
    map.put('\u3280', "CIRCLED IDEOGRAPH ONE");
    map.put('\u3281', "CIRCLED IDEOGRAPH TWO");
    map.put('\u3282', "CIRCLED IDEOGRAPH THREE");
    map.put('\u3283', "CIRCLED IDEOGRAPH FOUR");
    map.put('\u3284', "CIRCLED IDEOGRAPH FIVE");
    map.put('\u3285', "CIRCLED IDEOGRAPH SIX");
    map.put('\u3286', "CIRCLED IDEOGRAPH SEVEN");
    map.put('\u3287', "CIRCLED IDEOGRAPH EIGHT");
    map.put('\u3288', "CIRCLED IDEOGRAPH NINE");
    map.put('\u3289', "CIRCLED IDEOGRAPH TEN");
    map.put('\u328A', "CIRCLED IDEOGRAPH MOON");
    map.put('\u328B', "CIRCLED IDEOGRAPH FIRE");
    map.put('\u328C', "CIRCLED IDEOGRAPH WATER");
    map.put('\u328D', "CIRCLED IDEOGRAPH WOOD");
    map.put('\u328E', "CIRCLED IDEOGRAPH METAL");
    map.put('\u328F', "CIRCLED IDEOGRAPH EARTH");
    map.put('\u3290', "CIRCLED IDEOGRAPH SUN");
    map.put('\u3291', "CIRCLED IDEOGRAPH STOCK");
    map.put('\u3292', "CIRCLED IDEOGRAPH HAVE");
    map.put('\u3293', "CIRCLED IDEOGRAPH SOCIETY");
    map.put('\u3294', "CIRCLED IDEOGRAPH NAME");
    map.put('\u3295', "CIRCLED IDEOGRAPH SPECIAL");
    map.put('\u3296', "CIRCLED IDEOGRAPH FINANCIAL");
    map.put('\u3297', "CIRCLED IDEOGRAPH CONGRATULATION");
    map.put('\u3298', "CIRCLED IDEOGRAPH LABOR");
    map.put('\u3299', "CIRCLED IDEOGRAPH SECRET");
    map.put('\u329A', "CIRCLED IDEOGRAPH MALE");
    map.put('\u329B', "CIRCLED IDEOGRAPH FEMALE");
    map.put('\u329C', "CIRCLED IDEOGRAPH SUITABLE");
    map.put('\u329D', "CIRCLED IDEOGRAPH EXCELLENT");
    map.put('\u329E', "CIRCLED IDEOGRAPH PRINT");
    map.put('\u329F', "CIRCLED IDEOGRAPH ATTENTION");
    map.put('\u32A0', "CIRCLED IDEOGRAPH ITEM");
    map.put('\u32A1', "CIRCLED IDEOGRAPH REST");
    map.put('\u32A2', "CIRCLED IDEOGRAPH COPY");
    map.put('\u32A3', "CIRCLED IDEOGRAPH CORRECT");
    map.put('\u32A4', "CIRCLED IDEOGRAPH HIGH");
    map.put('\u32A5', "CIRCLED IDEOGRAPH CENTRE");
    map.put('\u32A6', "CIRCLED IDEOGRAPH LOW");
    map.put('\u32A7', "CIRCLED IDEOGRAPH LEFT");
    map.put('\u32A8', "CIRCLED IDEOGRAPH RIGHT");
    map.put('\u32A9', "CIRCLED IDEOGRAPH MEDICINE");
    map.put('\u32AA', "CIRCLED IDEOGRAPH RELIGION");
    map.put('\u32AB', "CIRCLED IDEOGRAPH STUDY");
    map.put('\u32AC', "CIRCLED IDEOGRAPH SUPERVISE");
    map.put('\u32AD', "CIRCLED IDEOGRAPH ENTERPRISE");
    map.put('\u32AE', "CIRCLED IDEOGRAPH RESOURCE");
    map.put('\u32AF', "CIRCLED IDEOGRAPH ALLIANCE");
    map.put('\u32B0', "CIRCLED IDEOGRAPH NIGHT");
    map.put('\u32B1', "CIRCLED NUMBER THIRTY SIX");
    map.put('\u32B2', "CIRCLED NUMBER THIRTY SEVEN");
    map.put('\u32B3', "CIRCLED NUMBER THIRTY EIGHT");
    map.put('\u32B4', "CIRCLED NUMBER THIRTY NINE");
    map.put('\u32B5', "CIRCLED NUMBER FORTY");
    map.put('\u32B6', "CIRCLED NUMBER FORTY ONE");
    map.put('\u32B7', "CIRCLED NUMBER FORTY TWO");
    map.put('\u32B8', "CIRCLED NUMBER FORTY THREE");
    map.put('\u32B9', "CIRCLED NUMBER FORTY FOUR");
    map.put('\u32BA', "CIRCLED NUMBER FORTY FIVE");
    map.put('\u32BB', "CIRCLED NUMBER FORTY SIX");
    map.put('\u32BC', "CIRCLED NUMBER FORTY SEVEN");
    map.put('\u32BD', "CIRCLED NUMBER FORTY EIGHT");
    map.put('\u32BE', "CIRCLED NUMBER FORTY NINE");
    map.put('\u32BF', "CIRCLED NUMBER FIFTY");
    map.put('\u32C0', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY");
    map.put('\u32C1', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY");
    map.put('\u32C2', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH");
    map.put('\u32C3', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL");
    map.put('\u32C4', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY");
    map.put('\u32C5', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE");
    map.put('\u32C6', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY");
    map.put('\u32C7', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST");
    map.put('\u32C8', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER");
    map.put('\u32C9', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER");
    map.put('\u32CA', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER");
    map.put('\u32CB', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER");
    map.put('\u32CC', "SQUARE HG");
    map.put('\u32CD', "SQUARE ERG");
    map.put('\u32CE', "SQUARE EV");
    map.put('\u32CF', "LIMITED LIABILITY SIGN");
    map.put('\u32D0', "CIRCLED KATAKANA A");
    map.put('\u32D1', "CIRCLED KATAKANA I");
    map.put('\u32D2', "CIRCLED KATAKANA U");
    map.put('\u32D3', "CIRCLED KATAKANA E");
    map.put('\u32D4', "CIRCLED KATAKANA O");
    map.put('\u32D5', "CIRCLED KATAKANA KA");
    map.put('\u32D6', "CIRCLED KATAKANA KI");
    map.put('\u32D7', "CIRCLED KATAKANA KU");
    map.put('\u32D8', "CIRCLED KATAKANA KE");
    map.put('\u32D9', "CIRCLED KATAKANA KO");
    map.put('\u32DA', "CIRCLED KATAKANA SA");
    map.put('\u32DB', "CIRCLED KATAKANA SI");
    map.put('\u32DC', "CIRCLED KATAKANA SU");
    map.put('\u32DD', "CIRCLED KATAKANA SE");
    map.put('\u32DE', "CIRCLED KATAKANA SO");
    map.put('\u32DF', "CIRCLED KATAKANA TA");
    map.put('\u32E0', "CIRCLED KATAKANA TI");
    map.put('\u32E1', "CIRCLED KATAKANA TU");
    map.put('\u32E2', "CIRCLED KATAKANA TE");
    map.put('\u32E3', "CIRCLED KATAKANA TO");
    map.put('\u32E4', "CIRCLED KATAKANA NA");
    map.put('\u32E5', "CIRCLED KATAKANA NI");
    map.put('\u32E6', "CIRCLED KATAKANA NU");
    map.put('\u32E7', "CIRCLED KATAKANA NE");
    map.put('\u32E8', "CIRCLED KATAKANA NO");
    map.put('\u32E9', "CIRCLED KATAKANA HA");
    map.put('\u32EA', "CIRCLED KATAKANA HI");
    map.put('\u32EB', "CIRCLED KATAKANA HU");
    map.put('\u32EC', "CIRCLED KATAKANA HE");
    map.put('\u32ED', "CIRCLED KATAKANA HO");
    map.put('\u32EE', "CIRCLED KATAKANA MA");
    map.put('\u32EF', "CIRCLED KATAKANA MI");
    map.put('\u32F0', "CIRCLED KATAKANA MU");
    map.put('\u32F1', "CIRCLED KATAKANA ME");
    map.put('\u32F2', "CIRCLED KATAKANA MO");
    map.put('\u32F3', "CIRCLED KATAKANA YA");
    map.put('\u32F4', "CIRCLED KATAKANA YU");
    map.put('\u32F5', "CIRCLED KATAKANA YO");
    map.put('\u32F6', "CIRCLED KATAKANA RA");
    map.put('\u32F7', "CIRCLED KATAKANA RI");
    map.put('\u32F8', "CIRCLED KATAKANA RU");
    map.put('\u32F9', "CIRCLED KATAKANA RE");
    map.put('\u32FA', "CIRCLED KATAKANA RO");
    map.put('\u32FB', "CIRCLED KATAKANA WA");
    map.put('\u32FC', "CIRCLED KATAKANA WI");
    map.put('\u32FD', "CIRCLED KATAKANA WE");
    map.put('\u32FE', "CIRCLED KATAKANA WO");
    map.put('\u3300', "SQUARE APAATO");
    map.put('\u3301', "SQUARE ARUHUA");
    map.put('\u3302', "SQUARE ANPEA");
    map.put('\u3303', "SQUARE AARU");
    map.put('\u3304', "SQUARE ININGU");
    map.put('\u3305', "SQUARE INTI");
    map.put('\u3306', "SQUARE UON");
    map.put('\u3307', "SQUARE ESUKUUDO");
    map.put('\u3308', "SQUARE EEKAA");
    map.put('\u3309', "SQUARE ONSU");
    map.put('\u330A', "SQUARE OOMU");
    map.put('\u330B', "SQUARE KAIRI");
    map.put('\u330C', "SQUARE KARATTO");
    map.put('\u330D', "SQUARE KARORII");
    map.put('\u330E', "SQUARE GARON");
    map.put('\u330F', "SQUARE GANMA");
    map.put('\u3310', "SQUARE GIGA");
    map.put('\u3311', "SQUARE GINII");
    map.put('\u3312', "SQUARE KYURII");
    map.put('\u3313', "SQUARE GIRUDAA");
    map.put('\u3314', "SQUARE KIRO");
    map.put('\u3315', "SQUARE KIROGURAMU");
    map.put('\u3316', "SQUARE KIROMEETORU");
    map.put('\u3317', "SQUARE KIROWATTO");
    map.put('\u3318', "SQUARE GURAMU");
    map.put('\u3319', "SQUARE GURAMUTON");
    map.put('\u331A', "SQUARE KURUZEIRO");
    map.put('\u331B', "SQUARE KUROONE");
    map.put('\u331C', "SQUARE KEESU");
    map.put('\u331D', "SQUARE KORUNA");
    map.put('\u331E', "SQUARE KOOPO");
    map.put('\u331F', "SQUARE SAIKURU");
    map.put('\u3320', "SQUARE SANTIIMU");
    map.put('\u3321', "SQUARE SIRINGU");
    map.put('\u3322', "SQUARE SENTI");
    map.put('\u3323', "SQUARE SENTO");
    map.put('\u3324', "SQUARE DAASU");
    map.put('\u3325', "SQUARE DESI");
    map.put('\u3326', "SQUARE DORU");
    map.put('\u3327', "SQUARE TON");
    map.put('\u3328', "SQUARE NANO");
    map.put('\u3329', "SQUARE NOTTO");
    map.put('\u332A', "SQUARE HAITU");
    map.put('\u332B', "SQUARE PAASENTO");
    map.put('\u332C', "SQUARE PAATU");
    map.put('\u332D', "SQUARE BAARERU");
    map.put('\u332E', "SQUARE PIASUTORU");
    map.put('\u332F', "SQUARE PIKURU");
    map.put('\u3330', "SQUARE PIKO");
    map.put('\u3331', "SQUARE BIRU");
    map.put('\u3332', "SQUARE HUARADDO");
    map.put('\u3333', "SQUARE HUIITO");
    map.put('\u3334', "SQUARE BUSSYERU");
    map.put('\u3335', "SQUARE HURAN");
    map.put('\u3336', "SQUARE HEKUTAARU");
    map.put('\u3337', "SQUARE PESO");
    map.put('\u3338', "SQUARE PENIHI");
    map.put('\u3339', "SQUARE HERUTU");
    map.put('\u333A', "SQUARE PENSU");
    map.put('\u333B', "SQUARE PEEZI");
    map.put('\u333C', "SQUARE BEETA");
    map.put('\u333D', "SQUARE POINTO");
    map.put('\u333E', "SQUARE BORUTO");
    map.put('\u333F', "SQUARE HON");
    map.put('\u3340', "SQUARE PONDO");
    map.put('\u3341', "SQUARE HOORU");
    map.put('\u3342', "SQUARE HOON");
    map.put('\u3343', "SQUARE MAIKURO");
    map.put('\u3344', "SQUARE MAIRU");
    map.put('\u3345', "SQUARE MAHHA");
    map.put('\u3346', "SQUARE MARUKU");
    map.put('\u3347', "SQUARE MANSYON");
    map.put('\u3348', "SQUARE MIKURON");
    map.put('\u3349', "SQUARE MIRI");
    map.put('\u334A', "SQUARE MIRIBAARU");
    map.put('\u334B', "SQUARE MEGA");
    map.put('\u334C', "SQUARE MEGATON");
    map.put('\u334D', "SQUARE MEETORU");
    map.put('\u334E', "SQUARE YAADO");
    map.put('\u334F', "SQUARE YAARU");
    map.put('\u3350', "SQUARE YUAN");
    map.put('\u3351', "SQUARE RITTORU");
    map.put('\u3352', "SQUARE RIRA");
    map.put('\u3353', "SQUARE RUPII");
    map.put('\u3354', "SQUARE RUUBURU");
    map.put('\u3355', "SQUARE REMU");
    map.put('\u3356', "SQUARE RENTOGEN");
    map.put('\u3357', "SQUARE WATTO");
    map.put('\u3358', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO");
    map.put('\u3359', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE");
    map.put('\u335A', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO");
    map.put('\u335B', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE");
    map.put('\u335C', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR");
    map.put('\u335D', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE");
    map.put('\u335E', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX");
    map.put('\u335F', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN");
    map.put('\u3360', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT");
    map.put('\u3361', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE");
    map.put('\u3362', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN");
    map.put('\u3363', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN");
    map.put('\u3364', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE");
    map.put('\u3365', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN");
    map.put('\u3366', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN");
    map.put('\u3367', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN");
    map.put('\u3368', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN");
    map.put('\u3369', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN");
    map.put('\u336A', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN");
    map.put('\u336B', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN");
    map.put('\u336C', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY");
    map.put('\u336D', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE");
    map.put('\u336E', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO");
    map.put('\u336F', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE");
    map.put('\u3370', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR");
    map.put('\u3371', "SQUARE HPA");
    map.put('\u3372', "SQUARE DA");
    map.put('\u3373', "SQUARE AU");
    map.put('\u3374', "SQUARE BAR");
    map.put('\u3375', "SQUARE OV");
    map.put('\u3376', "SQUARE PC");
    map.put('\u3377', "SQUARE DM");
    map.put('\u3378', "SQUARE DM SQUARED");
    map.put('\u3379', "SQUARE DM CUBED");
    map.put('\u337A', "SQUARE IU");
    map.put('\u337B', "SQUARE ERA NAME HEISEI");
    map.put('\u337C', "SQUARE ERA NAME SYOUWA");
    map.put('\u337D', "SQUARE ERA NAME TAISYOU");
    map.put('\u337E', "SQUARE ERA NAME MEIZI");
    map.put('\u337F', "SQUARE CORPORATION");
    map.put('\u3380', "SQUARE PA AMPS");
    map.put('\u3381', "SQUARE NA");
    map.put('\u3382', "SQUARE MU A");
    map.put('\u3383', "SQUARE MA");
    map.put('\u3384', "SQUARE KA");
    map.put('\u3385', "SQUARE KB");
    map.put('\u3386', "SQUARE MB");
    map.put('\u3387', "SQUARE GB");
    map.put('\u3388', "SQUARE CAL");
    map.put('\u3389', "SQUARE KCAL");
    map.put('\u338A', "SQUARE PF");
    map.put('\u338B', "SQUARE NF");
    map.put('\u338C', "SQUARE MU F");
    map.put('\u338D', "SQUARE MU G");
    map.put('\u338E', "SQUARE MG");
    map.put('\u338F', "SQUARE KG");
    map.put('\u3390', "SQUARE HZ");
    map.put('\u3391', "SQUARE KHZ");
    map.put('\u3392', "SQUARE MHZ");
    map.put('\u3393', "SQUARE GHZ");
    map.put('\u3394', "SQUARE THZ");
    map.put('\u3395', "SQUARE MU L");
    map.put('\u3396', "SQUARE ML");
    map.put('\u3397', "SQUARE DL");
    map.put('\u3398', "SQUARE KL");
    map.put('\u3399', "SQUARE FM");
    map.put('\u339A', "SQUARE NM");
    map.put('\u339B', "SQUARE MU M");
    map.put('\u339C', "SQUARE MM");
    map.put('\u339D', "SQUARE CM");
    map.put('\u339E', "SQUARE KM");
    map.put('\u339F', "SQUARE MM SQUARED");
    map.put('\u33A0', "SQUARE CM SQUARED");
    map.put('\u33A1', "SQUARE M SQUARED");
    map.put('\u33A2', "SQUARE KM SQUARED");
    map.put('\u33A3', "SQUARE MM CUBED");
    map.put('\u33A4', "SQUARE CM CUBED");
    map.put('\u33A5', "SQUARE M CUBED");
    map.put('\u33A6', "SQUARE KM CUBED");
    map.put('\u33A7', "SQUARE M OVER S");
    map.put('\u33A8', "SQUARE M OVER S SQUARED");
    map.put('\u33A9', "SQUARE PA");
    map.put('\u33AA', "SQUARE KPA");
    map.put('\u33AB', "SQUARE MPA");
    map.put('\u33AC', "SQUARE GPA");
    map.put('\u33AD', "SQUARE RAD");
    map.put('\u33AE', "SQUARE RAD OVER S");
    map.put('\u33AF', "SQUARE RAD OVER S SQUARED");
    map.put('\u33B0', "SQUARE PS");
    map.put('\u33B1', "SQUARE NS");
    map.put('\u33B2', "SQUARE MU S");
    map.put('\u33B3', "SQUARE MS");
    map.put('\u33B4', "SQUARE PV");
    map.put('\u33B5', "SQUARE NV");
    map.put('\u33B6', "SQUARE MU V");
    map.put('\u33B7', "SQUARE MV");
    map.put('\u33B8', "SQUARE KV");
    map.put('\u33B9', "SQUARE MV MEGA");
    map.put('\u33BA', "SQUARE PW");
    map.put('\u33BB', "SQUARE NW");
    map.put('\u33BC', "SQUARE MU W");
    map.put('\u33BD', "SQUARE MW");
    map.put('\u33BE', "SQUARE KW");
    map.put('\u33BF', "SQUARE MW MEGA");
    map.put('\u33C0', "SQUARE K OHM");
    map.put('\u33C1', "SQUARE M OHM");
    map.put('\u33C2', "SQUARE AM");
    map.put('\u33C3', "SQUARE BQ");
    map.put('\u33C4', "SQUARE CC");
    map.put('\u33C5', "SQUARE CD");
    map.put('\u33C6', "SQUARE C OVER KG");
    map.put('\u33C7', "SQUARE CO");
    map.put('\u33C8', "SQUARE DB");
    map.put('\u33C9', "SQUARE GY");
    map.put('\u33CA', "SQUARE HA");
    map.put('\u33CB', "SQUARE HP");
    map.put('\u33CC', "SQUARE IN");
    map.put('\u33CD', "SQUARE KK");
    map.put('\u33CE', "SQUARE KM CAPITAL");
    map.put('\u33CF', "SQUARE KT");
    map.put('\u33D0', "SQUARE LM");
    map.put('\u33D1', "SQUARE LN");
    map.put('\u33D2', "SQUARE LOG");
    map.put('\u33D3', "SQUARE LX");
    map.put('\u33D4', "SQUARE MB SMALL");
    map.put('\u33D5', "SQUARE MIL");
    map.put('\u33D6', "SQUARE MOL");
    map.put('\u33D7', "SQUARE PH");
    map.put('\u33D8', "SQUARE PM");
    map.put('\u33D9', "SQUARE PPM");
    map.put('\u33DA', "SQUARE PR");
    map.put('\u33DB', "SQUARE SR");
    map.put('\u33DC', "SQUARE SV");
    map.put('\u33DD', "SQUARE WB");
    map.put('\u33DE', "SQUARE V OVER M");
    map.put('\u33DF', "SQUARE A OVER M");
    map.put('\u33E0', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE");
    map.put('\u33E1', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO");
    map.put('\u33E2', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE");
    map.put('\u33E3', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR");
    map.put('\u33E4', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE");
    map.put('\u33E5', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX");
    map.put('\u33E6', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN");
    map.put('\u33E7', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT");
    map.put('\u33E8', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE");
    map.put('\u33E9', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN");
    map.put('\u33EA', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN");
    map.put('\u33EB', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE");
    map.put('\u33EC', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN");
    map.put('\u33ED', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN");
    map.put('\u33EE', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN");
    map.put('\u33EF', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN");
    map.put('\u33F0', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN");
    map.put('\u33F1', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN");
    map.put('\u33F2', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN");
    map.put('\u33F3', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY");
    map.put('\u33F4', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE");
    map.put('\u33F5', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO");
    map.put('\u33F6', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE");
    map.put('\u33F7', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR");
    map.put('\u33F8', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE");
    map.put('\u33F9', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX");
    map.put('\u33FA', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN");
    map.put('\u33FB', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT");
    map.put('\u33FC', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE");
    map.put('\u33FD', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY");
    map.put('\u33FE', "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE");
    map.put('\u33FF', "SQUARE GAL");
    map.put('\u4DC0', "HEXAGRAM FOR THE CREATIVE HEAVEN");
    map.put('\u4DC1', "HEXAGRAM FOR THE RECEPTIVE EARTH");
    map.put('\u4DC2', "HEXAGRAM FOR DIFFICULTY AT THE BEGINNING");
    map.put('\u4DC3', "HEXAGRAM FOR YOUTHFUL FOLLY");
    map.put('\u4DC4', "HEXAGRAM FOR WAITING");
    map.put('\u4DC5', "HEXAGRAM FOR CONFLICT");
    map.put('\u4DC6', "HEXAGRAM FOR THE ARMY");
    map.put('\u4DC7', "HEXAGRAM FOR HOLDING TOGETHER");
    map.put('\u4DC8', "HEXAGRAM FOR SMALL TAMING");
    map.put('\u4DC9', "HEXAGRAM FOR TREADING");
    map.put('\u4DCA', "HEXAGRAM FOR PEACE");
    map.put('\u4DCB', "HEXAGRAM FOR STANDSTILL");
    map.put('\u4DCC', "HEXAGRAM FOR FELLOWSHIP");
    map.put('\u4DCD', "HEXAGRAM FOR GREAT POSSESSION");
    map.put('\u4DCE', "HEXAGRAM FOR MODESTY");
    map.put('\u4DCF', "HEXAGRAM FOR ENTHUSIASM");
    map.put('\u4DD0', "HEXAGRAM FOR FOLLOWING");
    map.put('\u4DD1', "HEXAGRAM FOR WORK ON THE DECAYED");
    map.put('\u4DD2', "HEXAGRAM FOR APPROACH");
    map.put('\u4DD3', "HEXAGRAM FOR CONTEMPLATION");
    map.put('\u4DD4', "HEXAGRAM FOR BITING THROUGH");
    map.put('\u4DD5', "HEXAGRAM FOR GRACE");
    map.put('\u4DD6', "HEXAGRAM FOR SPLITTING APART");
    map.put('\u4DD7', "HEXAGRAM FOR RETURN");
    map.put('\u4DD8', "HEXAGRAM FOR INNOCENCE");
    map.put('\u4DD9', "HEXAGRAM FOR GREAT TAMING");
    map.put('\u4DDA', "HEXAGRAM FOR MOUTH CORNERS");
    map.put('\u4DDB', "HEXAGRAM FOR GREAT PREPONDERANCE");
    map.put('\u4DDC', "HEXAGRAM FOR THE ABYSMAL WATER");
    map.put('\u4DDD', "HEXAGRAM FOR THE CLINGING FIRE");
    map.put('\u4DDE', "HEXAGRAM FOR INFLUENCE");
    map.put('\u4DDF', "HEXAGRAM FOR DURATION");
    map.put('\u4DE0', "HEXAGRAM FOR RETREAT");
    map.put('\u4DE1', "HEXAGRAM FOR GREAT POWER");
    map.put('\u4DE2', "HEXAGRAM FOR PROGRESS");
    map.put('\u4DE3', "HEXAGRAM FOR DARKENING OF THE LIGHT");
    map.put('\u4DE4', "HEXAGRAM FOR THE FAMILY");
    map.put('\u4DE5', "HEXAGRAM FOR OPPOSITION");
    map.put('\u4DE6', "HEXAGRAM FOR OBSTRUCTION");
    map.put('\u4DE7', "HEXAGRAM FOR DELIVERANCE");
    map.put('\u4DE8', "HEXAGRAM FOR DECREASE");
    map.put('\u4DE9', "HEXAGRAM FOR INCREASE");
    map.put('\u4DEA', "HEXAGRAM FOR BREAKTHROUGH");
    map.put('\u4DEB', "HEXAGRAM FOR COMING TO MEET");
    map.put('\u4DEC', "HEXAGRAM FOR GATHERING TOGETHER");
    map.put('\u4DED', "HEXAGRAM FOR PUSHING UPWARD");
    map.put('\u4DEE', "HEXAGRAM FOR OPPRESSION");
    map.put('\u4DEF', "HEXAGRAM FOR THE WELL");
    map.put('\u4DF0', "HEXAGRAM FOR REVOLUTION");
    map.put('\u4DF1', "HEXAGRAM FOR THE CAULDRON");
    map.put('\u4DF2', "HEXAGRAM FOR THE AROUSING THUNDER");
    map.put('\u4DF3', "HEXAGRAM FOR THE KEEPING STILL MOUNTAIN");
    map.put('\u4DF4', "HEXAGRAM FOR DEVELOPMENT");
    map.put('\u4DF5', "HEXAGRAM FOR THE MARRYING MAIDEN");
    map.put('\u4DF6', "HEXAGRAM FOR ABUNDANCE");
    map.put('\u4DF7', "HEXAGRAM FOR THE WANDERER");
    map.put('\u4DF8', "HEXAGRAM FOR THE GENTLE WIND");
    map.put('\u4DF9', "HEXAGRAM FOR THE JOYOUS LAKE");
    map.put('\u4DFA', "HEXAGRAM FOR DISPERSION");
    map.put('\u4DFB', "HEXAGRAM FOR LIMITATION");
    map.put('\u4DFC', "HEXAGRAM FOR INNER TRUTH");
    map.put('\u4DFD', "HEXAGRAM FOR SMALL PREPONDERANCE");
    map.put('\u4DFE', "HEXAGRAM FOR AFTER COMPLETION");
    map.put('\u4DFF', "HEXAGRAM FOR BEFORE COMPLETION");
    map.put('\uA000', "YI SYLLABLE IT");
    map.put('\uA001', "YI SYLLABLE IX");
    map.put('\uA002', "YI SYLLABLE I");
    map.put('\uA003', "YI SYLLABLE IP");
    map.put('\uA004', "YI SYLLABLE IET");
    map.put('\uA005', "YI SYLLABLE IEX");
    map.put('\uA006', "YI SYLLABLE IE");
    map.put('\uA007', "YI SYLLABLE IEP");
    map.put('\uA008', "YI SYLLABLE AT");
    map.put('\uA009', "YI SYLLABLE AX");
    map.put('\uA00A', "YI SYLLABLE A");
    map.put('\uA00B', "YI SYLLABLE AP");
    map.put('\uA00C', "YI SYLLABLE UOX");
    map.put('\uA00D', "YI SYLLABLE UO");
    map.put('\uA00E', "YI SYLLABLE UOP");
    map.put('\uA00F', "YI SYLLABLE OT");
    map.put('\uA010', "YI SYLLABLE OX");
    map.put('\uA011', "YI SYLLABLE O");
    map.put('\uA012', "YI SYLLABLE OP");
    map.put('\uA013', "YI SYLLABLE EX");
    map.put('\uA014', "YI SYLLABLE E");
    map.put('\uA015', "YI SYLLABLE WU");
    map.put('\uA016', "YI SYLLABLE BIT");
    map.put('\uA017', "YI SYLLABLE BIX");
    map.put('\uA018', "YI SYLLABLE BI");
    map.put('\uA019', "YI SYLLABLE BIP");
    map.put('\uA01A', "YI SYLLABLE BIET");
    map.put('\uA01B', "YI SYLLABLE BIEX");
    map.put('\uA01C', "YI SYLLABLE BIE");
    map.put('\uA01D', "YI SYLLABLE BIEP");
    map.put('\uA01E', "YI SYLLABLE BAT");
    map.put('\uA01F', "YI SYLLABLE BAX");
    map.put('\uA020', "YI SYLLABLE BA");
    map.put('\uA021', "YI SYLLABLE BAP");
    map.put('\uA022', "YI SYLLABLE BUOX");
    map.put('\uA023', "YI SYLLABLE BUO");
    map.put('\uA024', "YI SYLLABLE BUOP");
    map.put('\uA025', "YI SYLLABLE BOT");
    map.put('\uA026', "YI SYLLABLE BOX");
    map.put('\uA027', "YI SYLLABLE BO");
    map.put('\uA028', "YI SYLLABLE BOP");
    map.put('\uA029', "YI SYLLABLE BEX");
    map.put('\uA02A', "YI SYLLABLE BE");
    map.put('\uA02B', "YI SYLLABLE BEP");
    map.put('\uA02C', "YI SYLLABLE BUT");
    map.put('\uA02D', "YI SYLLABLE BUX");
    map.put('\uA02E', "YI SYLLABLE BU");
    map.put('\uA02F', "YI SYLLABLE BUP");
    map.put('\uA030', "YI SYLLABLE BURX");
    map.put('\uA031', "YI SYLLABLE BUR");
    map.put('\uA032', "YI SYLLABLE BYT");
    map.put('\uA033', "YI SYLLABLE BYX");
    map.put('\uA034', "YI SYLLABLE BY");
    map.put('\uA035', "YI SYLLABLE BYP");
    map.put('\uA036', "YI SYLLABLE BYRX");
    map.put('\uA037', "YI SYLLABLE BYR");
    map.put('\uA038', "YI SYLLABLE PIT");
    map.put('\uA039', "YI SYLLABLE PIX");
    map.put('\uA03A', "YI SYLLABLE PI");
    map.put('\uA03B', "YI SYLLABLE PIP");
    map.put('\uA03C', "YI SYLLABLE PIEX");
    map.put('\uA03D', "YI SYLLABLE PIE");
    map.put('\uA03E', "YI SYLLABLE PIEP");
    map.put('\uA03F', "YI SYLLABLE PAT");
    map.put('\uA040', "YI SYLLABLE PAX");
    map.put('\uA041', "YI SYLLABLE PA");
    map.put('\uA042', "YI SYLLABLE PAP");
    map.put('\uA043', "YI SYLLABLE PUOX");
    map.put('\uA044', "YI SYLLABLE PUO");
    map.put('\uA045', "YI SYLLABLE PUOP");
    map.put('\uA046', "YI SYLLABLE POT");
    map.put('\uA047', "YI SYLLABLE POX");
    map.put('\uA048', "YI SYLLABLE PO");
    map.put('\uA049', "YI SYLLABLE POP");
    map.put('\uA04A', "YI SYLLABLE PUT");
    map.put('\uA04B', "YI SYLLABLE PUX");
    map.put('\uA04C', "YI SYLLABLE PU");
    map.put('\uA04D', "YI SYLLABLE PUP");
    map.put('\uA04E', "YI SYLLABLE PURX");
    map.put('\uA04F', "YI SYLLABLE PUR");
    map.put('\uA050', "YI SYLLABLE PYT");
    map.put('\uA051', "YI SYLLABLE PYX");
    map.put('\uA052', "YI SYLLABLE PY");
    map.put('\uA053', "YI SYLLABLE PYP");
    map.put('\uA054', "YI SYLLABLE PYRX");
    map.put('\uA055', "YI SYLLABLE PYR");
    map.put('\uA056', "YI SYLLABLE BBIT");
    map.put('\uA057', "YI SYLLABLE BBIX");
    map.put('\uA058', "YI SYLLABLE BBI");
    map.put('\uA059', "YI SYLLABLE BBIP");
    map.put('\uA05A', "YI SYLLABLE BBIET");
    map.put('\uA05B', "YI SYLLABLE BBIEX");
    map.put('\uA05C', "YI SYLLABLE BBIE");
    map.put('\uA05D', "YI SYLLABLE BBIEP");
    map.put('\uA05E', "YI SYLLABLE BBAT");
    map.put('\uA05F', "YI SYLLABLE BBAX");
    map.put('\uA060', "YI SYLLABLE BBA");
    map.put('\uA061', "YI SYLLABLE BBAP");
    map.put('\uA062', "YI SYLLABLE BBUOX");
    map.put('\uA063', "YI SYLLABLE BBUO");
    map.put('\uA064', "YI SYLLABLE BBUOP");
    map.put('\uA065', "YI SYLLABLE BBOT");
    map.put('\uA066', "YI SYLLABLE BBOX");
    map.put('\uA067', "YI SYLLABLE BBO");
    map.put('\uA068', "YI SYLLABLE BBOP");
    map.put('\uA069', "YI SYLLABLE BBEX");
    map.put('\uA06A', "YI SYLLABLE BBE");
    map.put('\uA06B', "YI SYLLABLE BBEP");
    map.put('\uA06C', "YI SYLLABLE BBUT");
    map.put('\uA06D', "YI SYLLABLE BBUX");
    map.put('\uA06E', "YI SYLLABLE BBU");
    map.put('\uA06F', "YI SYLLABLE BBUP");
    map.put('\uA070', "YI SYLLABLE BBURX");
    map.put('\uA071', "YI SYLLABLE BBUR");
    map.put('\uA072', "YI SYLLABLE BBYT");
    map.put('\uA073', "YI SYLLABLE BBYX");
    map.put('\uA074', "YI SYLLABLE BBY");
    map.put('\uA075', "YI SYLLABLE BBYP");
    map.put('\uA076', "YI SYLLABLE NBIT");
    map.put('\uA077', "YI SYLLABLE NBIX");
    map.put('\uA078', "YI SYLLABLE NBI");
    map.put('\uA079', "YI SYLLABLE NBIP");
    map.put('\uA07A', "YI SYLLABLE NBIEX");
    map.put('\uA07B', "YI SYLLABLE NBIE");
    map.put('\uA07C', "YI SYLLABLE NBIEP");
    map.put('\uA07D', "YI SYLLABLE NBAT");
    map.put('\uA07E', "YI SYLLABLE NBAX");
    map.put('\uA07F', "YI SYLLABLE NBA");
    map.put('\uA080', "YI SYLLABLE NBAP");
    map.put('\uA081', "YI SYLLABLE NBOT");
    map.put('\uA082', "YI SYLLABLE NBOX");
    map.put('\uA083', "YI SYLLABLE NBO");
    map.put('\uA084', "YI SYLLABLE NBOP");
    map.put('\uA085', "YI SYLLABLE NBUT");
    map.put('\uA086', "YI SYLLABLE NBUX");
    map.put('\uA087', "YI SYLLABLE NBU");
    map.put('\uA088', "YI SYLLABLE NBUP");
    map.put('\uA089', "YI SYLLABLE NBURX");
    map.put('\uA08A', "YI SYLLABLE NBUR");
    map.put('\uA08B', "YI SYLLABLE NBYT");
    map.put('\uA08C', "YI SYLLABLE NBYX");
    map.put('\uA08D', "YI SYLLABLE NBY");
    map.put('\uA08E', "YI SYLLABLE NBYP");
    map.put('\uA08F', "YI SYLLABLE NBYRX");
    map.put('\uA090', "YI SYLLABLE NBYR");
    map.put('\uA091', "YI SYLLABLE HMIT");
    map.put('\uA092', "YI SYLLABLE HMIX");
    map.put('\uA093', "YI SYLLABLE HMI");
    map.put('\uA094', "YI SYLLABLE HMIP");
    map.put('\uA095', "YI SYLLABLE HMIEX");
    map.put('\uA096', "YI SYLLABLE HMIE");
    map.put('\uA097', "YI SYLLABLE HMIEP");
    map.put('\uA098', "YI SYLLABLE HMAT");
    map.put('\uA099', "YI SYLLABLE HMAX");
    map.put('\uA09A', "YI SYLLABLE HMA");
    map.put('\uA09B', "YI SYLLABLE HMAP");
    map.put('\uA09C', "YI SYLLABLE HMUOX");
    map.put('\uA09D', "YI SYLLABLE HMUO");
    map.put('\uA09E', "YI SYLLABLE HMUOP");
    map.put('\uA09F', "YI SYLLABLE HMOT");
    map.put('\uA0A0', "YI SYLLABLE HMOX");
    map.put('\uA0A1', "YI SYLLABLE HMO");
    map.put('\uA0A2', "YI SYLLABLE HMOP");
    map.put('\uA0A3', "YI SYLLABLE HMUT");
    map.put('\uA0A4', "YI SYLLABLE HMUX");
    map.put('\uA0A5', "YI SYLLABLE HMU");
    map.put('\uA0A6', "YI SYLLABLE HMUP");
    map.put('\uA0A7', "YI SYLLABLE HMURX");
    map.put('\uA0A8', "YI SYLLABLE HMUR");
    map.put('\uA0A9', "YI SYLLABLE HMYX");
    map.put('\uA0AA', "YI SYLLABLE HMY");
    map.put('\uA0AB', "YI SYLLABLE HMYP");
    map.put('\uA0AC', "YI SYLLABLE HMYRX");
    map.put('\uA0AD', "YI SYLLABLE HMYR");
    map.put('\uA0AE', "YI SYLLABLE MIT");
    map.put('\uA0AF', "YI SYLLABLE MIX");
    map.put('\uA0B0', "YI SYLLABLE MI");
    map.put('\uA0B1', "YI SYLLABLE MIP");
    map.put('\uA0B2', "YI SYLLABLE MIEX");
    map.put('\uA0B3', "YI SYLLABLE MIE");
    map.put('\uA0B4', "YI SYLLABLE MIEP");
    map.put('\uA0B5', "YI SYLLABLE MAT");
    map.put('\uA0B6', "YI SYLLABLE MAX");
    map.put('\uA0B7', "YI SYLLABLE MA");
    map.put('\uA0B8', "YI SYLLABLE MAP");
    map.put('\uA0B9', "YI SYLLABLE MUOT");
    map.put('\uA0BA', "YI SYLLABLE MUOX");
    map.put('\uA0BB', "YI SYLLABLE MUO");
    map.put('\uA0BC', "YI SYLLABLE MUOP");
    map.put('\uA0BD', "YI SYLLABLE MOT");
    map.put('\uA0BE', "YI SYLLABLE MOX");
    map.put('\uA0BF', "YI SYLLABLE MO");
    map.put('\uA0C0', "YI SYLLABLE MOP");
    map.put('\uA0C1', "YI SYLLABLE MEX");
    map.put('\uA0C2', "YI SYLLABLE ME");
    map.put('\uA0C3', "YI SYLLABLE MUT");
    map.put('\uA0C4', "YI SYLLABLE MUX");
    map.put('\uA0C5', "YI SYLLABLE MU");
    map.put('\uA0C6', "YI SYLLABLE MUP");
    map.put('\uA0C7', "YI SYLLABLE MURX");
    map.put('\uA0C8', "YI SYLLABLE MUR");
    map.put('\uA0C9', "YI SYLLABLE MYT");
    map.put('\uA0CA', "YI SYLLABLE MYX");
    map.put('\uA0CB', "YI SYLLABLE MY");
    map.put('\uA0CC', "YI SYLLABLE MYP");
    map.put('\uA0CD', "YI SYLLABLE FIT");
    map.put('\uA0CE', "YI SYLLABLE FIX");
    map.put('\uA0CF', "YI SYLLABLE FI");
    map.put('\uA0D0', "YI SYLLABLE FIP");
    map.put('\uA0D1', "YI SYLLABLE FAT");
    map.put('\uA0D2', "YI SYLLABLE FAX");
    map.put('\uA0D3', "YI SYLLABLE FA");
    map.put('\uA0D4', "YI SYLLABLE FAP");
    map.put('\uA0D5', "YI SYLLABLE FOX");
    map.put('\uA0D6', "YI SYLLABLE FO");
    map.put('\uA0D7', "YI SYLLABLE FOP");
    map.put('\uA0D8', "YI SYLLABLE FUT");
    map.put('\uA0D9', "YI SYLLABLE FUX");
    map.put('\uA0DA', "YI SYLLABLE FU");
    map.put('\uA0DB', "YI SYLLABLE FUP");
    map.put('\uA0DC', "YI SYLLABLE FURX");
    map.put('\uA0DD', "YI SYLLABLE FUR");
    map.put('\uA0DE', "YI SYLLABLE FYT");
    map.put('\uA0DF', "YI SYLLABLE FYX");
    map.put('\uA0E0', "YI SYLLABLE FY");
    map.put('\uA0E1', "YI SYLLABLE FYP");
    map.put('\uA0E2', "YI SYLLABLE VIT");
    map.put('\uA0E3', "YI SYLLABLE VIX");
    map.put('\uA0E4', "YI SYLLABLE VI");
    map.put('\uA0E5', "YI SYLLABLE VIP");
    map.put('\uA0E6', "YI SYLLABLE VIET");
    map.put('\uA0E7', "YI SYLLABLE VIEX");
    map.put('\uA0E8', "YI SYLLABLE VIE");
    map.put('\uA0E9', "YI SYLLABLE VIEP");
    map.put('\uA0EA', "YI SYLLABLE VAT");
    map.put('\uA0EB', "YI SYLLABLE VAX");
    map.put('\uA0EC', "YI SYLLABLE VA");
    map.put('\uA0ED', "YI SYLLABLE VAP");
    map.put('\uA0EE', "YI SYLLABLE VOT");
    map.put('\uA0EF', "YI SYLLABLE VOX");
    map.put('\uA0F0', "YI SYLLABLE VO");
    map.put('\uA0F1', "YI SYLLABLE VOP");
    map.put('\uA0F2', "YI SYLLABLE VEX");
    map.put('\uA0F3', "YI SYLLABLE VEP");
    map.put('\uA0F4', "YI SYLLABLE VUT");
    map.put('\uA0F5', "YI SYLLABLE VUX");
    map.put('\uA0F6', "YI SYLLABLE VU");
    map.put('\uA0F7', "YI SYLLABLE VUP");
    map.put('\uA0F8', "YI SYLLABLE VURX");
    map.put('\uA0F9', "YI SYLLABLE VUR");
    map.put('\uA0FA', "YI SYLLABLE VYT");
    map.put('\uA0FB', "YI SYLLABLE VYX");
    map.put('\uA0FC', "YI SYLLABLE VY");
    map.put('\uA0FD', "YI SYLLABLE VYP");
    map.put('\uA0FE', "YI SYLLABLE VYRX");
    map.put('\uA0FF', "YI SYLLABLE VYR");
    map.put('\uA100', "YI SYLLABLE DIT");
    map.put('\uA101', "YI SYLLABLE DIX");
    map.put('\uA102', "YI SYLLABLE DI");
    map.put('\uA103', "YI SYLLABLE DIP");
    map.put('\uA104', "YI SYLLABLE DIEX");
    map.put('\uA105', "YI SYLLABLE DIE");
    map.put('\uA106', "YI SYLLABLE DIEP");
    map.put('\uA107', "YI SYLLABLE DAT");
    map.put('\uA108', "YI SYLLABLE DAX");
    map.put('\uA109', "YI SYLLABLE DA");
    map.put('\uA10A', "YI SYLLABLE DAP");
    map.put('\uA10B', "YI SYLLABLE DUOX");
    map.put('\uA10C', "YI SYLLABLE DUO");
    map.put('\uA10D', "YI SYLLABLE DOT");
    map.put('\uA10E', "YI SYLLABLE DOX");
    map.put('\uA10F', "YI SYLLABLE DO");
    map.put('\uA110', "YI SYLLABLE DOP");
    map.put('\uA111', "YI SYLLABLE DEX");
    map.put('\uA112', "YI SYLLABLE DE");
    map.put('\uA113', "YI SYLLABLE DEP");
    map.put('\uA114', "YI SYLLABLE DUT");
    map.put('\uA115', "YI SYLLABLE DUX");
    map.put('\uA116', "YI SYLLABLE DU");
    map.put('\uA117', "YI SYLLABLE DUP");
    map.put('\uA118', "YI SYLLABLE DURX");
    map.put('\uA119', "YI SYLLABLE DUR");
    map.put('\uA11A', "YI SYLLABLE TIT");
    map.put('\uA11B', "YI SYLLABLE TIX");
    map.put('\uA11C', "YI SYLLABLE TI");
    map.put('\uA11D', "YI SYLLABLE TIP");
    map.put('\uA11E', "YI SYLLABLE TIEX");
    map.put('\uA11F', "YI SYLLABLE TIE");
    map.put('\uA120', "YI SYLLABLE TIEP");
    map.put('\uA121', "YI SYLLABLE TAT");
    map.put('\uA122', "YI SYLLABLE TAX");
    map.put('\uA123', "YI SYLLABLE TA");
    map.put('\uA124', "YI SYLLABLE TAP");
    map.put('\uA125', "YI SYLLABLE TUOT");
    map.put('\uA126', "YI SYLLABLE TUOX");
    map.put('\uA127', "YI SYLLABLE TUO");
    map.put('\uA128', "YI SYLLABLE TUOP");
    map.put('\uA129', "YI SYLLABLE TOT");
    map.put('\uA12A', "YI SYLLABLE TOX");
    map.put('\uA12B', "YI SYLLABLE TO");
    map.put('\uA12C', "YI SYLLABLE TOP");
    map.put('\uA12D', "YI SYLLABLE TEX");
    map.put('\uA12E', "YI SYLLABLE TE");
    map.put('\uA12F', "YI SYLLABLE TEP");
    map.put('\uA130', "YI SYLLABLE TUT");
    map.put('\uA131', "YI SYLLABLE TUX");
    map.put('\uA132', "YI SYLLABLE TU");
    map.put('\uA133', "YI SYLLABLE TUP");
    map.put('\uA134', "YI SYLLABLE TURX");
    map.put('\uA135', "YI SYLLABLE TUR");
    map.put('\uA136', "YI SYLLABLE DDIT");
    map.put('\uA137', "YI SYLLABLE DDIX");
    map.put('\uA138', "YI SYLLABLE DDI");
    map.put('\uA139', "YI SYLLABLE DDIP");
    map.put('\uA13A', "YI SYLLABLE DDIEX");
    map.put('\uA13B', "YI SYLLABLE DDIE");
    map.put('\uA13C', "YI SYLLABLE DDIEP");
    map.put('\uA13D', "YI SYLLABLE DDAT");
    map.put('\uA13E', "YI SYLLABLE DDAX");
    map.put('\uA13F', "YI SYLLABLE DDA");
    map.put('\uA140', "YI SYLLABLE DDAP");
    map.put('\uA141', "YI SYLLABLE DDUOX");
    map.put('\uA142', "YI SYLLABLE DDUO");
    map.put('\uA143', "YI SYLLABLE DDUOP");
    map.put('\uA144', "YI SYLLABLE DDOT");
    map.put('\uA145', "YI SYLLABLE DDOX");
    map.put('\uA146', "YI SYLLABLE DDO");
    map.put('\uA147', "YI SYLLABLE DDOP");
    map.put('\uA148', "YI SYLLABLE DDEX");
    map.put('\uA149', "YI SYLLABLE DDE");
    map.put('\uA14A', "YI SYLLABLE DDEP");
    map.put('\uA14B', "YI SYLLABLE DDUT");
    map.put('\uA14C', "YI SYLLABLE DDUX");
    map.put('\uA14D', "YI SYLLABLE DDU");
    map.put('\uA14E', "YI SYLLABLE DDUP");
    map.put('\uA14F', "YI SYLLABLE DDURX");
    map.put('\uA150', "YI SYLLABLE DDUR");
    map.put('\uA151', "YI SYLLABLE NDIT");
    map.put('\uA152', "YI SYLLABLE NDIX");
    map.put('\uA153', "YI SYLLABLE NDI");
    map.put('\uA154', "YI SYLLABLE NDIP");
    map.put('\uA155', "YI SYLLABLE NDIEX");
    map.put('\uA156', "YI SYLLABLE NDIE");
    map.put('\uA157', "YI SYLLABLE NDAT");
    map.put('\uA158', "YI SYLLABLE NDAX");
    map.put('\uA159', "YI SYLLABLE NDA");
    map.put('\uA15A', "YI SYLLABLE NDAP");
    map.put('\uA15B', "YI SYLLABLE NDOT");
    map.put('\uA15C', "YI SYLLABLE NDOX");
    map.put('\uA15D', "YI SYLLABLE NDO");
    map.put('\uA15E', "YI SYLLABLE NDOP");
    map.put('\uA15F', "YI SYLLABLE NDEX");
    map.put('\uA160', "YI SYLLABLE NDE");
    map.put('\uA161', "YI SYLLABLE NDEP");
    map.put('\uA162', "YI SYLLABLE NDUT");
    map.put('\uA163', "YI SYLLABLE NDUX");
    map.put('\uA164', "YI SYLLABLE NDU");
    map.put('\uA165', "YI SYLLABLE NDUP");
    map.put('\uA166', "YI SYLLABLE NDURX");
    map.put('\uA167', "YI SYLLABLE NDUR");
    map.put('\uA168', "YI SYLLABLE HNIT");
    map.put('\uA169', "YI SYLLABLE HNIX");
    map.put('\uA16A', "YI SYLLABLE HNI");
    map.put('\uA16B', "YI SYLLABLE HNIP");
    map.put('\uA16C', "YI SYLLABLE HNIET");
    map.put('\uA16D', "YI SYLLABLE HNIEX");
    map.put('\uA16E', "YI SYLLABLE HNIE");
    map.put('\uA16F', "YI SYLLABLE HNIEP");
    map.put('\uA170', "YI SYLLABLE HNAT");
    map.put('\uA171', "YI SYLLABLE HNAX");
    map.put('\uA172', "YI SYLLABLE HNA");
    map.put('\uA173', "YI SYLLABLE HNAP");
    map.put('\uA174', "YI SYLLABLE HNUOX");
    map.put('\uA175', "YI SYLLABLE HNUO");
    map.put('\uA176', "YI SYLLABLE HNOT");
    map.put('\uA177', "YI SYLLABLE HNOX");
    map.put('\uA178', "YI SYLLABLE HNOP");
    map.put('\uA179', "YI SYLLABLE HNEX");
    map.put('\uA17A', "YI SYLLABLE HNE");
    map.put('\uA17B', "YI SYLLABLE HNEP");
    map.put('\uA17C', "YI SYLLABLE HNUT");
    map.put('\uA17D', "YI SYLLABLE NIT");
    map.put('\uA17E', "YI SYLLABLE NIX");
    map.put('\uA17F', "YI SYLLABLE NI");
    map.put('\uA180', "YI SYLLABLE NIP");
    map.put('\uA181', "YI SYLLABLE NIEX");
    map.put('\uA182', "YI SYLLABLE NIE");
    map.put('\uA183', "YI SYLLABLE NIEP");
    map.put('\uA184', "YI SYLLABLE NAX");
    map.put('\uA185', "YI SYLLABLE NA");
    map.put('\uA186', "YI SYLLABLE NAP");
    map.put('\uA187', "YI SYLLABLE NUOX");
    map.put('\uA188', "YI SYLLABLE NUO");
    map.put('\uA189', "YI SYLLABLE NUOP");
    map.put('\uA18A', "YI SYLLABLE NOT");
    map.put('\uA18B', "YI SYLLABLE NOX");
    map.put('\uA18C', "YI SYLLABLE NO");
    map.put('\uA18D', "YI SYLLABLE NOP");
    map.put('\uA18E', "YI SYLLABLE NEX");
    map.put('\uA18F', "YI SYLLABLE NE");
    map.put('\uA190', "YI SYLLABLE NEP");
    map.put('\uA191', "YI SYLLABLE NUT");
    map.put('\uA192', "YI SYLLABLE NUX");
    map.put('\uA193', "YI SYLLABLE NU");
    map.put('\uA194', "YI SYLLABLE NUP");
    map.put('\uA195', "YI SYLLABLE NURX");
    map.put('\uA196', "YI SYLLABLE NUR");
    map.put('\uA197', "YI SYLLABLE HLIT");
    map.put('\uA198', "YI SYLLABLE HLIX");
    map.put('\uA199', "YI SYLLABLE HLI");
    map.put('\uA19A', "YI SYLLABLE HLIP");
    map.put('\uA19B', "YI SYLLABLE HLIEX");
    map.put('\uA19C', "YI SYLLABLE HLIE");
    map.put('\uA19D', "YI SYLLABLE HLIEP");
    map.put('\uA19E', "YI SYLLABLE HLAT");
    map.put('\uA19F', "YI SYLLABLE HLAX");
    map.put('\uA1A0', "YI SYLLABLE HLA");
    map.put('\uA1A1', "YI SYLLABLE HLAP");
    map.put('\uA1A2', "YI SYLLABLE HLUOX");
    map.put('\uA1A3', "YI SYLLABLE HLUO");
    map.put('\uA1A4', "YI SYLLABLE HLUOP");
    map.put('\uA1A5', "YI SYLLABLE HLOX");
    map.put('\uA1A6', "YI SYLLABLE HLO");
    map.put('\uA1A7', "YI SYLLABLE HLOP");
    map.put('\uA1A8', "YI SYLLABLE HLEX");
    map.put('\uA1A9', "YI SYLLABLE HLE");
    map.put('\uA1AA', "YI SYLLABLE HLEP");
    map.put('\uA1AB', "YI SYLLABLE HLUT");
    map.put('\uA1AC', "YI SYLLABLE HLUX");
    map.put('\uA1AD', "YI SYLLABLE HLU");
    map.put('\uA1AE', "YI SYLLABLE HLUP");
    map.put('\uA1AF', "YI SYLLABLE HLURX");
    map.put('\uA1B0', "YI SYLLABLE HLUR");
    map.put('\uA1B1', "YI SYLLABLE HLYT");
    map.put('\uA1B2', "YI SYLLABLE HLYX");
    map.put('\uA1B3', "YI SYLLABLE HLY");
    map.put('\uA1B4', "YI SYLLABLE HLYP");
    map.put('\uA1B5', "YI SYLLABLE HLYRX");
    map.put('\uA1B6', "YI SYLLABLE HLYR");
    map.put('\uA1B7', "YI SYLLABLE LIT");
    map.put('\uA1B8', "YI SYLLABLE LIX");
    map.put('\uA1B9', "YI SYLLABLE LI");
    map.put('\uA1BA', "YI SYLLABLE LIP");
    map.put('\uA1BB', "YI SYLLABLE LIET");
    map.put('\uA1BC', "YI SYLLABLE LIEX");
    map.put('\uA1BD', "YI SYLLABLE LIE");
    map.put('\uA1BE', "YI SYLLABLE LIEP");
    map.put('\uA1BF', "YI SYLLABLE LAT");
    map.put('\uA1C0', "YI SYLLABLE LAX");
    map.put('\uA1C1', "YI SYLLABLE LA");
    map.put('\uA1C2', "YI SYLLABLE LAP");
    map.put('\uA1C3', "YI SYLLABLE LUOT");
    map.put('\uA1C4', "YI SYLLABLE LUOX");
    map.put('\uA1C5', "YI SYLLABLE LUO");
    map.put('\uA1C6', "YI SYLLABLE LUOP");
    map.put('\uA1C7', "YI SYLLABLE LOT");
    map.put('\uA1C8', "YI SYLLABLE LOX");
    map.put('\uA1C9', "YI SYLLABLE LO");
    map.put('\uA1CA', "YI SYLLABLE LOP");
    map.put('\uA1CB', "YI SYLLABLE LEX");
    map.put('\uA1CC', "YI SYLLABLE LE");
    map.put('\uA1CD', "YI SYLLABLE LEP");
    map.put('\uA1CE', "YI SYLLABLE LUT");
    map.put('\uA1CF', "YI SYLLABLE LUX");
    map.put('\uA1D0', "YI SYLLABLE LU");
    map.put('\uA1D1', "YI SYLLABLE LUP");
    map.put('\uA1D2', "YI SYLLABLE LURX");
    map.put('\uA1D3', "YI SYLLABLE LUR");
    map.put('\uA1D4', "YI SYLLABLE LYT");
    map.put('\uA1D5', "YI SYLLABLE LYX");
    map.put('\uA1D6', "YI SYLLABLE LY");
    map.put('\uA1D7', "YI SYLLABLE LYP");
    map.put('\uA1D8', "YI SYLLABLE LYRX");
    map.put('\uA1D9', "YI SYLLABLE LYR");
    map.put('\uA1DA', "YI SYLLABLE GIT");
    map.put('\uA1DB', "YI SYLLABLE GIX");
    map.put('\uA1DC', "YI SYLLABLE GI");
    map.put('\uA1DD', "YI SYLLABLE GIP");
    map.put('\uA1DE', "YI SYLLABLE GIET");
    map.put('\uA1DF', "YI SYLLABLE GIEX");
    map.put('\uA1E0', "YI SYLLABLE GIE");
    map.put('\uA1E1', "YI SYLLABLE GIEP");
    map.put('\uA1E2', "YI SYLLABLE GAT");
    map.put('\uA1E3', "YI SYLLABLE GAX");
    map.put('\uA1E4', "YI SYLLABLE GA");
    map.put('\uA1E5', "YI SYLLABLE GAP");
    map.put('\uA1E6', "YI SYLLABLE GUOT");
    map.put('\uA1E7', "YI SYLLABLE GUOX");
    map.put('\uA1E8', "YI SYLLABLE GUO");
    map.put('\uA1E9', "YI SYLLABLE GUOP");
    map.put('\uA1EA', "YI SYLLABLE GOT");
    map.put('\uA1EB', "YI SYLLABLE GOX");
    map.put('\uA1EC', "YI SYLLABLE GO");
    map.put('\uA1ED', "YI SYLLABLE GOP");
    map.put('\uA1EE', "YI SYLLABLE GET");
    map.put('\uA1EF', "YI SYLLABLE GEX");
    map.put('\uA1F0', "YI SYLLABLE GE");
    map.put('\uA1F1', "YI SYLLABLE GEP");
    map.put('\uA1F2', "YI SYLLABLE GUT");
    map.put('\uA1F3', "YI SYLLABLE GUX");
    map.put('\uA1F4', "YI SYLLABLE GU");
    map.put('\uA1F5', "YI SYLLABLE GUP");
    map.put('\uA1F6', "YI SYLLABLE GURX");
    map.put('\uA1F7', "YI SYLLABLE GUR");
    map.put('\uA1F8', "YI SYLLABLE KIT");
    map.put('\uA1F9', "YI SYLLABLE KIX");
    map.put('\uA1FA', "YI SYLLABLE KI");
    map.put('\uA1FB', "YI SYLLABLE KIP");
    map.put('\uA1FC', "YI SYLLABLE KIEX");
    map.put('\uA1FD', "YI SYLLABLE KIE");
    map.put('\uA1FE', "YI SYLLABLE KIEP");
    map.put('\uA1FF', "YI SYLLABLE KAT");
    map.put('\uA200', "YI SYLLABLE KAX");
    map.put('\uA201', "YI SYLLABLE KA");
    map.put('\uA202', "YI SYLLABLE KAP");
    map.put('\uA203', "YI SYLLABLE KUOX");
    map.put('\uA204', "YI SYLLABLE KUO");
    map.put('\uA205', "YI SYLLABLE KUOP");
    map.put('\uA206', "YI SYLLABLE KOT");
    map.put('\uA207', "YI SYLLABLE KOX");
    map.put('\uA208', "YI SYLLABLE KO");
    map.put('\uA209', "YI SYLLABLE KOP");
    map.put('\uA20A', "YI SYLLABLE KET");
    map.put('\uA20B', "YI SYLLABLE KEX");
    map.put('\uA20C', "YI SYLLABLE KE");
    map.put('\uA20D', "YI SYLLABLE KEP");
    map.put('\uA20E', "YI SYLLABLE KUT");
    map.put('\uA20F', "YI SYLLABLE KUX");
    map.put('\uA210', "YI SYLLABLE KU");
    map.put('\uA211', "YI SYLLABLE KUP");
    map.put('\uA212', "YI SYLLABLE KURX");
    map.put('\uA213', "YI SYLLABLE KUR");
    map.put('\uA214', "YI SYLLABLE GGIT");
    map.put('\uA215', "YI SYLLABLE GGIX");
    map.put('\uA216', "YI SYLLABLE GGI");
    map.put('\uA217', "YI SYLLABLE GGIEX");
    map.put('\uA218', "YI SYLLABLE GGIE");
    map.put('\uA219', "YI SYLLABLE GGIEP");
    map.put('\uA21A', "YI SYLLABLE GGAT");
    map.put('\uA21B', "YI SYLLABLE GGAX");
    map.put('\uA21C', "YI SYLLABLE GGA");
    map.put('\uA21D', "YI SYLLABLE GGAP");
    map.put('\uA21E', "YI SYLLABLE GGUOT");
    map.put('\uA21F', "YI SYLLABLE GGUOX");
    map.put('\uA220', "YI SYLLABLE GGUO");
    map.put('\uA221', "YI SYLLABLE GGUOP");
    map.put('\uA222', "YI SYLLABLE GGOT");
    map.put('\uA223', "YI SYLLABLE GGOX");
    map.put('\uA224', "YI SYLLABLE GGO");
    map.put('\uA225', "YI SYLLABLE GGOP");
    map.put('\uA226', "YI SYLLABLE GGET");
    map.put('\uA227', "YI SYLLABLE GGEX");
    map.put('\uA228', "YI SYLLABLE GGE");
    map.put('\uA229', "YI SYLLABLE GGEP");
    map.put('\uA22A', "YI SYLLABLE GGUT");
    map.put('\uA22B', "YI SYLLABLE GGUX");
    map.put('\uA22C', "YI SYLLABLE GGU");
    map.put('\uA22D', "YI SYLLABLE GGUP");
    map.put('\uA22E', "YI SYLLABLE GGURX");
    map.put('\uA22F', "YI SYLLABLE GGUR");
    map.put('\uA230', "YI SYLLABLE MGIEX");
    map.put('\uA231', "YI SYLLABLE MGIE");
    map.put('\uA232', "YI SYLLABLE MGAT");
    map.put('\uA233', "YI SYLLABLE MGAX");
    map.put('\uA234', "YI SYLLABLE MGA");
    map.put('\uA235', "YI SYLLABLE MGAP");
    map.put('\uA236', "YI SYLLABLE MGUOX");
    map.put('\uA237', "YI SYLLABLE MGUO");
    map.put('\uA238', "YI SYLLABLE MGUOP");
    map.put('\uA239', "YI SYLLABLE MGOT");
    map.put('\uA23A', "YI SYLLABLE MGOX");
    map.put('\uA23B', "YI SYLLABLE MGO");
    map.put('\uA23C', "YI SYLLABLE MGOP");
    map.put('\uA23D', "YI SYLLABLE MGEX");
    map.put('\uA23E', "YI SYLLABLE MGE");
    map.put('\uA23F', "YI SYLLABLE MGEP");
    map.put('\uA240', "YI SYLLABLE MGUT");
    map.put('\uA241', "YI SYLLABLE MGUX");
    map.put('\uA242', "YI SYLLABLE MGU");
    map.put('\uA243', "YI SYLLABLE MGUP");
    map.put('\uA244', "YI SYLLABLE MGURX");
    map.put('\uA245', "YI SYLLABLE MGUR");
    map.put('\uA246', "YI SYLLABLE HXIT");
    map.put('\uA247', "YI SYLLABLE HXIX");
    map.put('\uA248', "YI SYLLABLE HXI");
    map.put('\uA249', "YI SYLLABLE HXIP");
    map.put('\uA24A', "YI SYLLABLE HXIET");
    map.put('\uA24B', "YI SYLLABLE HXIEX");
    map.put('\uA24C', "YI SYLLABLE HXIE");
    map.put('\uA24D', "YI SYLLABLE HXIEP");
    map.put('\uA24E', "YI SYLLABLE HXAT");
    map.put('\uA24F', "YI SYLLABLE HXAX");
    map.put('\uA250', "YI SYLLABLE HXA");
    map.put('\uA251', "YI SYLLABLE HXAP");
    map.put('\uA252', "YI SYLLABLE HXUOT");
    map.put('\uA253', "YI SYLLABLE HXUOX");
    map.put('\uA254', "YI SYLLABLE HXUO");
    map.put('\uA255', "YI SYLLABLE HXUOP");
    map.put('\uA256', "YI SYLLABLE HXOT");
    map.put('\uA257', "YI SYLLABLE HXOX");
    map.put('\uA258', "YI SYLLABLE HXO");
    map.put('\uA259', "YI SYLLABLE HXOP");
    map.put('\uA25A', "YI SYLLABLE HXEX");
    map.put('\uA25B', "YI SYLLABLE HXE");
    map.put('\uA25C', "YI SYLLABLE HXEP");
    map.put('\uA25D', "YI SYLLABLE NGIEX");
    map.put('\uA25E', "YI SYLLABLE NGIE");
    map.put('\uA25F', "YI SYLLABLE NGIEP");
    map.put('\uA260', "YI SYLLABLE NGAT");
    map.put('\uA261', "YI SYLLABLE NGAX");
    map.put('\uA262', "YI SYLLABLE NGA");
    map.put('\uA263', "YI SYLLABLE NGAP");
    map.put('\uA264', "YI SYLLABLE NGUOT");
    map.put('\uA265', "YI SYLLABLE NGUOX");
    map.put('\uA266', "YI SYLLABLE NGUO");
    map.put('\uA267', "YI SYLLABLE NGOT");
    map.put('\uA268', "YI SYLLABLE NGOX");
    map.put('\uA269', "YI SYLLABLE NGO");
    map.put('\uA26A', "YI SYLLABLE NGOP");
    map.put('\uA26B', "YI SYLLABLE NGEX");
    map.put('\uA26C', "YI SYLLABLE NGE");
    map.put('\uA26D', "YI SYLLABLE NGEP");
    map.put('\uA26E', "YI SYLLABLE HIT");
    map.put('\uA26F', "YI SYLLABLE HIEX");
    map.put('\uA270', "YI SYLLABLE HIE");
    map.put('\uA271', "YI SYLLABLE HAT");
    map.put('\uA272', "YI SYLLABLE HAX");
    map.put('\uA273', "YI SYLLABLE HA");
    map.put('\uA274', "YI SYLLABLE HAP");
    map.put('\uA275', "YI SYLLABLE HUOT");
    map.put('\uA276', "YI SYLLABLE HUOX");
    map.put('\uA277', "YI SYLLABLE HUO");
    map.put('\uA278', "YI SYLLABLE HUOP");
    map.put('\uA279', "YI SYLLABLE HOT");
    map.put('\uA27A', "YI SYLLABLE HOX");
    map.put('\uA27B', "YI SYLLABLE HO");
    map.put('\uA27C', "YI SYLLABLE HOP");
    map.put('\uA27D', "YI SYLLABLE HEX");
    map.put('\uA27E', "YI SYLLABLE HE");
    map.put('\uA27F', "YI SYLLABLE HEP");
    map.put('\uA280', "YI SYLLABLE WAT");
    map.put('\uA281', "YI SYLLABLE WAX");
    map.put('\uA282', "YI SYLLABLE WA");
    map.put('\uA283', "YI SYLLABLE WAP");
    map.put('\uA284', "YI SYLLABLE WUOX");
    map.put('\uA285', "YI SYLLABLE WUO");
    map.put('\uA286', "YI SYLLABLE WUOP");
    map.put('\uA287', "YI SYLLABLE WOX");
    map.put('\uA288', "YI SYLLABLE WO");
    map.put('\uA289', "YI SYLLABLE WOP");
    map.put('\uA28A', "YI SYLLABLE WEX");
    map.put('\uA28B', "YI SYLLABLE WE");
    map.put('\uA28C', "YI SYLLABLE WEP");
    map.put('\uA28D', "YI SYLLABLE ZIT");
    map.put('\uA28E', "YI SYLLABLE ZIX");
    map.put('\uA28F', "YI SYLLABLE ZI");
    map.put('\uA290', "YI SYLLABLE ZIP");
    map.put('\uA291', "YI SYLLABLE ZIEX");
    map.put('\uA292', "YI SYLLABLE ZIE");
    map.put('\uA293', "YI SYLLABLE ZIEP");
    map.put('\uA294', "YI SYLLABLE ZAT");
    map.put('\uA295', "YI SYLLABLE ZAX");
    map.put('\uA296', "YI SYLLABLE ZA");
    map.put('\uA297', "YI SYLLABLE ZAP");
    map.put('\uA298', "YI SYLLABLE ZUOX");
    map.put('\uA299', "YI SYLLABLE ZUO");
    map.put('\uA29A', "YI SYLLABLE ZUOP");
    map.put('\uA29B', "YI SYLLABLE ZOT");
    map.put('\uA29C', "YI SYLLABLE ZOX");
    map.put('\uA29D', "YI SYLLABLE ZO");
    map.put('\uA29E', "YI SYLLABLE ZOP");
    map.put('\uA29F', "YI SYLLABLE ZEX");
    map.put('\uA2A0', "YI SYLLABLE ZE");
    map.put('\uA2A1', "YI SYLLABLE ZEP");
    map.put('\uA2A2', "YI SYLLABLE ZUT");
    map.put('\uA2A3', "YI SYLLABLE ZUX");
    map.put('\uA2A4', "YI SYLLABLE ZU");
    map.put('\uA2A5', "YI SYLLABLE ZUP");
    map.put('\uA2A6', "YI SYLLABLE ZURX");
    map.put('\uA2A7', "YI SYLLABLE ZUR");
    map.put('\uA2A8', "YI SYLLABLE ZYT");
    map.put('\uA2A9', "YI SYLLABLE ZYX");
    map.put('\uA2AA', "YI SYLLABLE ZY");
    map.put('\uA2AB', "YI SYLLABLE ZYP");
    map.put('\uA2AC', "YI SYLLABLE ZYRX");
    map.put('\uA2AD', "YI SYLLABLE ZYR");
    map.put('\uA2AE', "YI SYLLABLE CIT");
    map.put('\uA2AF', "YI SYLLABLE CIX");
    map.put('\uA2B0', "YI SYLLABLE CI");
    map.put('\uA2B1', "YI SYLLABLE CIP");
    map.put('\uA2B2', "YI SYLLABLE CIET");
    map.put('\uA2B3', "YI SYLLABLE CIEX");
    map.put('\uA2B4', "YI SYLLABLE CIE");
    map.put('\uA2B5', "YI SYLLABLE CIEP");
    map.put('\uA2B6', "YI SYLLABLE CAT");
    map.put('\uA2B7', "YI SYLLABLE CAX");
    map.put('\uA2B8', "YI SYLLABLE CA");
    map.put('\uA2B9', "YI SYLLABLE CAP");
    map.put('\uA2BA', "YI SYLLABLE CUOX");
    map.put('\uA2BB', "YI SYLLABLE CUO");
    map.put('\uA2BC', "YI SYLLABLE CUOP");
    map.put('\uA2BD', "YI SYLLABLE COT");
    map.put('\uA2BE', "YI SYLLABLE COX");
    map.put('\uA2BF', "YI SYLLABLE CO");
    map.put('\uA2C0', "YI SYLLABLE COP");
    map.put('\uA2C1', "YI SYLLABLE CEX");
    map.put('\uA2C2', "YI SYLLABLE CE");
    map.put('\uA2C3', "YI SYLLABLE CEP");
    map.put('\uA2C4', "YI SYLLABLE CUT");
    map.put('\uA2C5', "YI SYLLABLE CUX");
    map.put('\uA2C6', "YI SYLLABLE CU");
    map.put('\uA2C7', "YI SYLLABLE CUP");
    map.put('\uA2C8', "YI SYLLABLE CURX");
    map.put('\uA2C9', "YI SYLLABLE CUR");
    map.put('\uA2CA', "YI SYLLABLE CYT");
    map.put('\uA2CB', "YI SYLLABLE CYX");
    map.put('\uA2CC', "YI SYLLABLE CY");
    map.put('\uA2CD', "YI SYLLABLE CYP");
    map.put('\uA2CE', "YI SYLLABLE CYRX");
    map.put('\uA2CF', "YI SYLLABLE CYR");
    map.put('\uA2D0', "YI SYLLABLE ZZIT");
    map.put('\uA2D1', "YI SYLLABLE ZZIX");
    map.put('\uA2D2', "YI SYLLABLE ZZI");
    map.put('\uA2D3', "YI SYLLABLE ZZIP");
    map.put('\uA2D4', "YI SYLLABLE ZZIET");
    map.put('\uA2D5', "YI SYLLABLE ZZIEX");
    map.put('\uA2D6', "YI SYLLABLE ZZIE");
    map.put('\uA2D7', "YI SYLLABLE ZZIEP");
    map.put('\uA2D8', "YI SYLLABLE ZZAT");
    map.put('\uA2D9', "YI SYLLABLE ZZAX");
    map.put('\uA2DA', "YI SYLLABLE ZZA");
    map.put('\uA2DB', "YI SYLLABLE ZZAP");
    map.put('\uA2DC', "YI SYLLABLE ZZOX");
    map.put('\uA2DD', "YI SYLLABLE ZZO");
    map.put('\uA2DE', "YI SYLLABLE ZZOP");
    map.put('\uA2DF', "YI SYLLABLE ZZEX");
    map.put('\uA2E0', "YI SYLLABLE ZZE");
    map.put('\uA2E1', "YI SYLLABLE ZZEP");
    map.put('\uA2E2', "YI SYLLABLE ZZUX");
    map.put('\uA2E3', "YI SYLLABLE ZZU");
    map.put('\uA2E4', "YI SYLLABLE ZZUP");
    map.put('\uA2E5', "YI SYLLABLE ZZURX");
    map.put('\uA2E6', "YI SYLLABLE ZZUR");
    map.put('\uA2E7', "YI SYLLABLE ZZYT");
    map.put('\uA2E8', "YI SYLLABLE ZZYX");
    map.put('\uA2E9', "YI SYLLABLE ZZY");
    map.put('\uA2EA', "YI SYLLABLE ZZYP");
    map.put('\uA2EB', "YI SYLLABLE ZZYRX");
    map.put('\uA2EC', "YI SYLLABLE ZZYR");
    map.put('\uA2ED', "YI SYLLABLE NZIT");
    map.put('\uA2EE', "YI SYLLABLE NZIX");
    map.put('\uA2EF', "YI SYLLABLE NZI");
    map.put('\uA2F0', "YI SYLLABLE NZIP");
    map.put('\uA2F1', "YI SYLLABLE NZIEX");
    map.put('\uA2F2', "YI SYLLABLE NZIE");
    map.put('\uA2F3', "YI SYLLABLE NZIEP");
    map.put('\uA2F4', "YI SYLLABLE NZAT");
    map.put('\uA2F5', "YI SYLLABLE NZAX");
    map.put('\uA2F6', "YI SYLLABLE NZA");
    map.put('\uA2F7', "YI SYLLABLE NZAP");
    map.put('\uA2F8', "YI SYLLABLE NZUOX");
    map.put('\uA2F9', "YI SYLLABLE NZUO");
    map.put('\uA2FA', "YI SYLLABLE NZOX");
    map.put('\uA2FB', "YI SYLLABLE NZOP");
    map.put('\uA2FC', "YI SYLLABLE NZEX");
    map.put('\uA2FD', "YI SYLLABLE NZE");
    map.put('\uA2FE', "YI SYLLABLE NZUX");
    map.put('\uA2FF', "YI SYLLABLE NZU");
    map.put('\uA300', "YI SYLLABLE NZUP");
    map.put('\uA301', "YI SYLLABLE NZURX");
    map.put('\uA302', "YI SYLLABLE NZUR");
    map.put('\uA303', "YI SYLLABLE NZYT");
    map.put('\uA304', "YI SYLLABLE NZYX");
    map.put('\uA305', "YI SYLLABLE NZY");
    map.put('\uA306', "YI SYLLABLE NZYP");
    map.put('\uA307', "YI SYLLABLE NZYRX");
    map.put('\uA308', "YI SYLLABLE NZYR");
    map.put('\uA309', "YI SYLLABLE SIT");
    map.put('\uA30A', "YI SYLLABLE SIX");
    map.put('\uA30B', "YI SYLLABLE SI");
    map.put('\uA30C', "YI SYLLABLE SIP");
    map.put('\uA30D', "YI SYLLABLE SIEX");
    map.put('\uA30E', "YI SYLLABLE SIE");
    map.put('\uA30F', "YI SYLLABLE SIEP");
    map.put('\uA310', "YI SYLLABLE SAT");
    map.put('\uA311', "YI SYLLABLE SAX");
    map.put('\uA312', "YI SYLLABLE SA");
    map.put('\uA313', "YI SYLLABLE SAP");
    map.put('\uA314', "YI SYLLABLE SUOX");
    map.put('\uA315', "YI SYLLABLE SUO");
    map.put('\uA316', "YI SYLLABLE SUOP");
    map.put('\uA317', "YI SYLLABLE SOT");
    map.put('\uA318', "YI SYLLABLE SOX");
    map.put('\uA319', "YI SYLLABLE SO");
    map.put('\uA31A', "YI SYLLABLE SOP");
    map.put('\uA31B', "YI SYLLABLE SEX");
    map.put('\uA31C', "YI SYLLABLE SE");
    map.put('\uA31D', "YI SYLLABLE SEP");
    map.put('\uA31E', "YI SYLLABLE SUT");
    map.put('\uA31F', "YI SYLLABLE SUX");
    map.put('\uA320', "YI SYLLABLE SU");
    map.put('\uA321', "YI SYLLABLE SUP");
    map.put('\uA322', "YI SYLLABLE SURX");
    map.put('\uA323', "YI SYLLABLE SUR");
    map.put('\uA324', "YI SYLLABLE SYT");
    map.put('\uA325', "YI SYLLABLE SYX");
    map.put('\uA326', "YI SYLLABLE SY");
    map.put('\uA327', "YI SYLLABLE SYP");
    map.put('\uA328', "YI SYLLABLE SYRX");
    map.put('\uA329', "YI SYLLABLE SYR");
    map.put('\uA32A', "YI SYLLABLE SSIT");
    map.put('\uA32B', "YI SYLLABLE SSIX");
    map.put('\uA32C', "YI SYLLABLE SSI");
    map.put('\uA32D', "YI SYLLABLE SSIP");
    map.put('\uA32E', "YI SYLLABLE SSIEX");
    map.put('\uA32F', "YI SYLLABLE SSIE");
    map.put('\uA330', "YI SYLLABLE SSIEP");
    map.put('\uA331', "YI SYLLABLE SSAT");
    map.put('\uA332', "YI SYLLABLE SSAX");
    map.put('\uA333', "YI SYLLABLE SSA");
    map.put('\uA334', "YI SYLLABLE SSAP");
    map.put('\uA335', "YI SYLLABLE SSOT");
    map.put('\uA336', "YI SYLLABLE SSOX");
    map.put('\uA337', "YI SYLLABLE SSO");
    map.put('\uA338', "YI SYLLABLE SSOP");
    map.put('\uA339', "YI SYLLABLE SSEX");
    map.put('\uA33A', "YI SYLLABLE SSE");
    map.put('\uA33B', "YI SYLLABLE SSEP");
    map.put('\uA33C', "YI SYLLABLE SSUT");
    map.put('\uA33D', "YI SYLLABLE SSUX");
    map.put('\uA33E', "YI SYLLABLE SSU");
    map.put('\uA33F', "YI SYLLABLE SSUP");
    map.put('\uA340', "YI SYLLABLE SSYT");
    map.put('\uA341', "YI SYLLABLE SSYX");
    map.put('\uA342', "YI SYLLABLE SSY");
    map.put('\uA343', "YI SYLLABLE SSYP");
    map.put('\uA344', "YI SYLLABLE SSYRX");
    map.put('\uA345', "YI SYLLABLE SSYR");
    map.put('\uA346', "YI SYLLABLE ZHAT");
    map.put('\uA347', "YI SYLLABLE ZHAX");
    map.put('\uA348', "YI SYLLABLE ZHA");
    map.put('\uA349', "YI SYLLABLE ZHAP");
    map.put('\uA34A', "YI SYLLABLE ZHUOX");
    map.put('\uA34B', "YI SYLLABLE ZHUO");
    map.put('\uA34C', "YI SYLLABLE ZHUOP");
    map.put('\uA34D', "YI SYLLABLE ZHOT");
    map.put('\uA34E', "YI SYLLABLE ZHOX");
    map.put('\uA34F', "YI SYLLABLE ZHO");
    map.put('\uA350', "YI SYLLABLE ZHOP");
    map.put('\uA351', "YI SYLLABLE ZHET");
    map.put('\uA352', "YI SYLLABLE ZHEX");
    map.put('\uA353', "YI SYLLABLE ZHE");
    map.put('\uA354', "YI SYLLABLE ZHEP");
    map.put('\uA355', "YI SYLLABLE ZHUT");
    map.put('\uA356', "YI SYLLABLE ZHUX");
    map.put('\uA357', "YI SYLLABLE ZHU");
    map.put('\uA358', "YI SYLLABLE ZHUP");
    map.put('\uA359', "YI SYLLABLE ZHURX");
    map.put('\uA35A', "YI SYLLABLE ZHUR");
    map.put('\uA35B', "YI SYLLABLE ZHYT");
    map.put('\uA35C', "YI SYLLABLE ZHYX");
    map.put('\uA35D', "YI SYLLABLE ZHY");
    map.put('\uA35E', "YI SYLLABLE ZHYP");
    map.put('\uA35F', "YI SYLLABLE ZHYRX");
    map.put('\uA360', "YI SYLLABLE ZHYR");
    map.put('\uA361', "YI SYLLABLE CHAT");
    map.put('\uA362', "YI SYLLABLE CHAX");
    map.put('\uA363', "YI SYLLABLE CHA");
    map.put('\uA364', "YI SYLLABLE CHAP");
    map.put('\uA365', "YI SYLLABLE CHUOT");
    map.put('\uA366', "YI SYLLABLE CHUOX");
    map.put('\uA367', "YI SYLLABLE CHUO");
    map.put('\uA368', "YI SYLLABLE CHUOP");
    map.put('\uA369', "YI SYLLABLE CHOT");
    map.put('\uA36A', "YI SYLLABLE CHOX");
    map.put('\uA36B', "YI SYLLABLE CHO");
    map.put('\uA36C', "YI SYLLABLE CHOP");
    map.put('\uA36D', "YI SYLLABLE CHET");
    map.put('\uA36E', "YI SYLLABLE CHEX");
    map.put('\uA36F', "YI SYLLABLE CHE");
    map.put('\uA370', "YI SYLLABLE CHEP");
    map.put('\uA371', "YI SYLLABLE CHUX");
    map.put('\uA372', "YI SYLLABLE CHU");
    map.put('\uA373', "YI SYLLABLE CHUP");
    map.put('\uA374', "YI SYLLABLE CHURX");
    map.put('\uA375', "YI SYLLABLE CHUR");
    map.put('\uA376', "YI SYLLABLE CHYT");
    map.put('\uA377', "YI SYLLABLE CHYX");
    map.put('\uA378', "YI SYLLABLE CHY");
    map.put('\uA379', "YI SYLLABLE CHYP");
    map.put('\uA37A', "YI SYLLABLE CHYRX");
    map.put('\uA37B', "YI SYLLABLE CHYR");
    map.put('\uA37C', "YI SYLLABLE RRAX");
    map.put('\uA37D', "YI SYLLABLE RRA");
    map.put('\uA37E', "YI SYLLABLE RRUOX");
    map.put('\uA37F', "YI SYLLABLE RRUO");
    map.put('\uA380', "YI SYLLABLE RROT");
    map.put('\uA381', "YI SYLLABLE RROX");
    map.put('\uA382', "YI SYLLABLE RRO");
    map.put('\uA383', "YI SYLLABLE RROP");
    map.put('\uA384', "YI SYLLABLE RRET");
    map.put('\uA385', "YI SYLLABLE RREX");
    map.put('\uA386', "YI SYLLABLE RRE");
    map.put('\uA387', "YI SYLLABLE RREP");
    map.put('\uA388', "YI SYLLABLE RRUT");
    map.put('\uA389', "YI SYLLABLE RRUX");
    map.put('\uA38A', "YI SYLLABLE RRU");
    map.put('\uA38B', "YI SYLLABLE RRUP");
    map.put('\uA38C', "YI SYLLABLE RRURX");
    map.put('\uA38D', "YI SYLLABLE RRUR");
    map.put('\uA38E', "YI SYLLABLE RRYT");
    map.put('\uA38F', "YI SYLLABLE RRYX");
    map.put('\uA390', "YI SYLLABLE RRY");
    map.put('\uA391', "YI SYLLABLE RRYP");
    map.put('\uA392', "YI SYLLABLE RRYRX");
    map.put('\uA393', "YI SYLLABLE RRYR");
    map.put('\uA394', "YI SYLLABLE NRAT");
    map.put('\uA395', "YI SYLLABLE NRAX");
    map.put('\uA396', "YI SYLLABLE NRA");
    map.put('\uA397', "YI SYLLABLE NRAP");
    map.put('\uA398', "YI SYLLABLE NROX");
    map.put('\uA399', "YI SYLLABLE NRO");
    map.put('\uA39A', "YI SYLLABLE NROP");
    map.put('\uA39B', "YI SYLLABLE NRET");
    map.put('\uA39C', "YI SYLLABLE NREX");
    map.put('\uA39D', "YI SYLLABLE NRE");
    map.put('\uA39E', "YI SYLLABLE NREP");
    map.put('\uA39F', "YI SYLLABLE NRUT");
    map.put('\uA3A0', "YI SYLLABLE NRUX");
    map.put('\uA3A1', "YI SYLLABLE NRU");
    map.put('\uA3A2', "YI SYLLABLE NRUP");
    map.put('\uA3A3', "YI SYLLABLE NRURX");
    map.put('\uA3A4', "YI SYLLABLE NRUR");
    map.put('\uA3A5', "YI SYLLABLE NRYT");
    map.put('\uA3A6', "YI SYLLABLE NRYX");
    map.put('\uA3A7', "YI SYLLABLE NRY");
    map.put('\uA3A8', "YI SYLLABLE NRYP");
    map.put('\uA3A9', "YI SYLLABLE NRYRX");
    map.put('\uA3AA', "YI SYLLABLE NRYR");
    map.put('\uA3AB', "YI SYLLABLE SHAT");
    map.put('\uA3AC', "YI SYLLABLE SHAX");
    map.put('\uA3AD', "YI SYLLABLE SHA");
    map.put('\uA3AE', "YI SYLLABLE SHAP");
    map.put('\uA3AF', "YI SYLLABLE SHUOX");
    map.put('\uA3B0', "YI SYLLABLE SHUO");
    map.put('\uA3B1', "YI SYLLABLE SHUOP");
    map.put('\uA3B2', "YI SYLLABLE SHOT");
    map.put('\uA3B3', "YI SYLLABLE SHOX");
    map.put('\uA3B4', "YI SYLLABLE SHO");
    map.put('\uA3B5', "YI SYLLABLE SHOP");
    map.put('\uA3B6', "YI SYLLABLE SHET");
    map.put('\uA3B7', "YI SYLLABLE SHEX");
    map.put('\uA3B8', "YI SYLLABLE SHE");
    map.put('\uA3B9', "YI SYLLABLE SHEP");
    map.put('\uA3BA', "YI SYLLABLE SHUT");
    map.put('\uA3BB', "YI SYLLABLE SHUX");
    map.put('\uA3BC', "YI SYLLABLE SHU");
    map.put('\uA3BD', "YI SYLLABLE SHUP");
    map.put('\uA3BE', "YI SYLLABLE SHURX");
    map.put('\uA3BF', "YI SYLLABLE SHUR");
    map.put('\uA3C0', "YI SYLLABLE SHYT");
    map.put('\uA3C1', "YI SYLLABLE SHYX");
    map.put('\uA3C2', "YI SYLLABLE SHY");
    map.put('\uA3C3', "YI SYLLABLE SHYP");
    map.put('\uA3C4', "YI SYLLABLE SHYRX");
    map.put('\uA3C5', "YI SYLLABLE SHYR");
    map.put('\uA3C6', "YI SYLLABLE RAT");
    map.put('\uA3C7', "YI SYLLABLE RAX");
    map.put('\uA3C8', "YI SYLLABLE RA");
    map.put('\uA3C9', "YI SYLLABLE RAP");
    map.put('\uA3CA', "YI SYLLABLE RUOX");
    map.put('\uA3CB', "YI SYLLABLE RUO");
    map.put('\uA3CC', "YI SYLLABLE RUOP");
    map.put('\uA3CD', "YI SYLLABLE ROT");
    map.put('\uA3CE', "YI SYLLABLE ROX");
    map.put('\uA3CF', "YI SYLLABLE RO");
    map.put('\uA3D0', "YI SYLLABLE ROP");
    map.put('\uA3D1', "YI SYLLABLE REX");
    map.put('\uA3D2', "YI SYLLABLE RE");
    map.put('\uA3D3', "YI SYLLABLE REP");
    map.put('\uA3D4', "YI SYLLABLE RUT");
    map.put('\uA3D5', "YI SYLLABLE RUX");
    map.put('\uA3D6', "YI SYLLABLE RU");
    map.put('\uA3D7', "YI SYLLABLE RUP");
    map.put('\uA3D8', "YI SYLLABLE RURX");
    map.put('\uA3D9', "YI SYLLABLE RUR");
    map.put('\uA3DA', "YI SYLLABLE RYT");
    map.put('\uA3DB', "YI SYLLABLE RYX");
    map.put('\uA3DC', "YI SYLLABLE RY");
    map.put('\uA3DD', "YI SYLLABLE RYP");
    map.put('\uA3DE', "YI SYLLABLE RYRX");
    map.put('\uA3DF', "YI SYLLABLE RYR");
    map.put('\uA3E0', "YI SYLLABLE JIT");
    map.put('\uA3E1', "YI SYLLABLE JIX");
    map.put('\uA3E2', "YI SYLLABLE JI");
    map.put('\uA3E3', "YI SYLLABLE JIP");
    map.put('\uA3E4', "YI SYLLABLE JIET");
    map.put('\uA3E5', "YI SYLLABLE JIEX");
    map.put('\uA3E6', "YI SYLLABLE JIE");
    map.put('\uA3E7', "YI SYLLABLE JIEP");
    map.put('\uA3E8', "YI SYLLABLE JUOT");
    map.put('\uA3E9', "YI SYLLABLE JUOX");
    map.put('\uA3EA', "YI SYLLABLE JUO");
    map.put('\uA3EB', "YI SYLLABLE JUOP");
    map.put('\uA3EC', "YI SYLLABLE JOT");
    map.put('\uA3ED', "YI SYLLABLE JOX");
    map.put('\uA3EE', "YI SYLLABLE JO");
    map.put('\uA3EF', "YI SYLLABLE JOP");
    map.put('\uA3F0', "YI SYLLABLE JUT");
    map.put('\uA3F1', "YI SYLLABLE JUX");
    map.put('\uA3F2', "YI SYLLABLE JU");
    map.put('\uA3F3', "YI SYLLABLE JUP");
    map.put('\uA3F4', "YI SYLLABLE JURX");
    map.put('\uA3F5', "YI SYLLABLE JUR");
    map.put('\uA3F6', "YI SYLLABLE JYT");
    map.put('\uA3F7', "YI SYLLABLE JYX");
    map.put('\uA3F8', "YI SYLLABLE JY");
    map.put('\uA3F9', "YI SYLLABLE JYP");
    map.put('\uA3FA', "YI SYLLABLE JYRX");
    map.put('\uA3FB', "YI SYLLABLE JYR");
    map.put('\uA3FC', "YI SYLLABLE QIT");
    map.put('\uA3FD', "YI SYLLABLE QIX");
    map.put('\uA3FE', "YI SYLLABLE QI");
    map.put('\uA3FF', "YI SYLLABLE QIP");
    map.put('\uA400', "YI SYLLABLE QIET");
    map.put('\uA401', "YI SYLLABLE QIEX");
    map.put('\uA402', "YI SYLLABLE QIE");
    map.put('\uA403', "YI SYLLABLE QIEP");
    map.put('\uA404', "YI SYLLABLE QUOT");
    map.put('\uA405', "YI SYLLABLE QUOX");
    map.put('\uA406', "YI SYLLABLE QUO");
    map.put('\uA407', "YI SYLLABLE QUOP");
    map.put('\uA408', "YI SYLLABLE QOT");
    map.put('\uA409', "YI SYLLABLE QOX");
    map.put('\uA40A', "YI SYLLABLE QO");
    map.put('\uA40B', "YI SYLLABLE QOP");
    map.put('\uA40C', "YI SYLLABLE QUT");
    map.put('\uA40D', "YI SYLLABLE QUX");
    map.put('\uA40E', "YI SYLLABLE QU");
    map.put('\uA40F', "YI SYLLABLE QUP");
    map.put('\uA410', "YI SYLLABLE QURX");
    map.put('\uA411', "YI SYLLABLE QUR");
    map.put('\uA412', "YI SYLLABLE QYT");
    map.put('\uA413', "YI SYLLABLE QYX");
    map.put('\uA414', "YI SYLLABLE QY");
    map.put('\uA415', "YI SYLLABLE QYP");
    map.put('\uA416', "YI SYLLABLE QYRX");
    map.put('\uA417', "YI SYLLABLE QYR");
    map.put('\uA418', "YI SYLLABLE JJIT");
    map.put('\uA419', "YI SYLLABLE JJIX");
    map.put('\uA41A', "YI SYLLABLE JJI");
    map.put('\uA41B', "YI SYLLABLE JJIP");
    map.put('\uA41C', "YI SYLLABLE JJIET");
    map.put('\uA41D', "YI SYLLABLE JJIEX");
    map.put('\uA41E', "YI SYLLABLE JJIE");
    map.put('\uA41F', "YI SYLLABLE JJIEP");
    map.put('\uA420', "YI SYLLABLE JJUOX");
    map.put('\uA421', "YI SYLLABLE JJUO");
    map.put('\uA422', "YI SYLLABLE JJUOP");
    map.put('\uA423', "YI SYLLABLE JJOT");
    map.put('\uA424', "YI SYLLABLE JJOX");
    map.put('\uA425', "YI SYLLABLE JJO");
    map.put('\uA426', "YI SYLLABLE JJOP");
    map.put('\uA427', "YI SYLLABLE JJUT");
    map.put('\uA428', "YI SYLLABLE JJUX");
    map.put('\uA429', "YI SYLLABLE JJU");
    map.put('\uA42A', "YI SYLLABLE JJUP");
    map.put('\uA42B', "YI SYLLABLE JJURX");
    map.put('\uA42C', "YI SYLLABLE JJUR");
    map.put('\uA42D', "YI SYLLABLE JJYT");
    map.put('\uA42E', "YI SYLLABLE JJYX");
    map.put('\uA42F', "YI SYLLABLE JJY");
    map.put('\uA430', "YI SYLLABLE JJYP");
    map.put('\uA431', "YI SYLLABLE NJIT");
    map.put('\uA432', "YI SYLLABLE NJIX");
    map.put('\uA433', "YI SYLLABLE NJI");
    map.put('\uA434', "YI SYLLABLE NJIP");
    map.put('\uA435', "YI SYLLABLE NJIET");
    map.put('\uA436', "YI SYLLABLE NJIEX");
    map.put('\uA437', "YI SYLLABLE NJIE");
    map.put('\uA438', "YI SYLLABLE NJIEP");
    map.put('\uA439', "YI SYLLABLE NJUOX");
    map.put('\uA43A', "YI SYLLABLE NJUO");
    map.put('\uA43B', "YI SYLLABLE NJOT");
    map.put('\uA43C', "YI SYLLABLE NJOX");
    map.put('\uA43D', "YI SYLLABLE NJO");
    map.put('\uA43E', "YI SYLLABLE NJOP");
    map.put('\uA43F', "YI SYLLABLE NJUX");
    map.put('\uA440', "YI SYLLABLE NJU");
    map.put('\uA441', "YI SYLLABLE NJUP");
    map.put('\uA442', "YI SYLLABLE NJURX");
    map.put('\uA443', "YI SYLLABLE NJUR");
    map.put('\uA444', "YI SYLLABLE NJYT");
    map.put('\uA445', "YI SYLLABLE NJYX");
    map.put('\uA446', "YI SYLLABLE NJY");
    map.put('\uA447', "YI SYLLABLE NJYP");
    map.put('\uA448', "YI SYLLABLE NJYRX");
    map.put('\uA449', "YI SYLLABLE NJYR");
    map.put('\uA44A', "YI SYLLABLE NYIT");
    map.put('\uA44B', "YI SYLLABLE NYIX");
    map.put('\uA44C', "YI SYLLABLE NYI");
    map.put('\uA44D', "YI SYLLABLE NYIP");
    map.put('\uA44E', "YI SYLLABLE NYIET");
    map.put('\uA44F', "YI SYLLABLE NYIEX");
    map.put('\uA450', "YI SYLLABLE NYIE");
    map.put('\uA451', "YI SYLLABLE NYIEP");
    map.put('\uA452', "YI SYLLABLE NYUOX");
    map.put('\uA453', "YI SYLLABLE NYUO");
    map.put('\uA454', "YI SYLLABLE NYUOP");
    map.put('\uA455', "YI SYLLABLE NYOT");
    map.put('\uA456', "YI SYLLABLE NYOX");
    map.put('\uA457', "YI SYLLABLE NYO");
    map.put('\uA458', "YI SYLLABLE NYOP");
    map.put('\uA459', "YI SYLLABLE NYUT");
    map.put('\uA45A', "YI SYLLABLE NYUX");
    map.put('\uA45B', "YI SYLLABLE NYU");
    map.put('\uA45C', "YI SYLLABLE NYUP");
    map.put('\uA45D', "YI SYLLABLE XIT");
    map.put('\uA45E', "YI SYLLABLE XIX");
    map.put('\uA45F', "YI SYLLABLE XI");
    map.put('\uA460', "YI SYLLABLE XIP");
    map.put('\uA461', "YI SYLLABLE XIET");
    map.put('\uA462', "YI SYLLABLE XIEX");
    map.put('\uA463', "YI SYLLABLE XIE");
    map.put('\uA464', "YI SYLLABLE XIEP");
    map.put('\uA465', "YI SYLLABLE XUOX");
    map.put('\uA466', "YI SYLLABLE XUO");
    map.put('\uA467', "YI SYLLABLE XOT");
    map.put('\uA468', "YI SYLLABLE XOX");
    map.put('\uA469', "YI SYLLABLE XO");
    map.put('\uA46A', "YI SYLLABLE XOP");
    map.put('\uA46B', "YI SYLLABLE XYT");
    map.put('\uA46C', "YI SYLLABLE XYX");
    map.put('\uA46D', "YI SYLLABLE XY");
    map.put('\uA46E', "YI SYLLABLE XYP");
    map.put('\uA46F', "YI SYLLABLE XYRX");
    map.put('\uA470', "YI SYLLABLE XYR");
    map.put('\uA471', "YI SYLLABLE YIT");
    map.put('\uA472', "YI SYLLABLE YIX");
    map.put('\uA473', "YI SYLLABLE YI");
    map.put('\uA474', "YI SYLLABLE YIP");
    map.put('\uA475', "YI SYLLABLE YIET");
    map.put('\uA476', "YI SYLLABLE YIEX");
    map.put('\uA477', "YI SYLLABLE YIE");
    map.put('\uA478', "YI SYLLABLE YIEP");
    map.put('\uA479', "YI SYLLABLE YUOT");
    map.put('\uA47A', "YI SYLLABLE YUOX");
    map.put('\uA47B', "YI SYLLABLE YUO");
    map.put('\uA47C', "YI SYLLABLE YUOP");
    map.put('\uA47D', "YI SYLLABLE YOT");
    map.put('\uA47E', "YI SYLLABLE YOX");
    map.put('\uA47F', "YI SYLLABLE YO");
    map.put('\uA480', "YI SYLLABLE YOP");
    map.put('\uA481', "YI SYLLABLE YUT");
    map.put('\uA482', "YI SYLLABLE YUX");
    map.put('\uA483', "YI SYLLABLE YU");
    map.put('\uA484', "YI SYLLABLE YUP");
    map.put('\uA485', "YI SYLLABLE YURX");
    map.put('\uA486', "YI SYLLABLE YUR");
    map.put('\uA487', "YI SYLLABLE YYT");
    map.put('\uA488', "YI SYLLABLE YYX");
    map.put('\uA489', "YI SYLLABLE YY");
    map.put('\uA48A', "YI SYLLABLE YYP");
    map.put('\uA48B', "YI SYLLABLE YYRX");
    map.put('\uA48C', "YI SYLLABLE YYR");
    map.put('\uA490', "YI RADICAL QOT");
    map.put('\uA491', "YI RADICAL LI");
    map.put('\uA492', "YI RADICAL KIT");
    map.put('\uA493', "YI RADICAL NYIP");
    map.put('\uA494', "YI RADICAL CYP");
    map.put('\uA495', "YI RADICAL SSI");
    map.put('\uA496', "YI RADICAL GGOP");
    map.put('\uA497', "YI RADICAL GEP");
    map.put('\uA498', "YI RADICAL MI");
    map.put('\uA499', "YI RADICAL HXIT");
    map.put('\uA49A', "YI RADICAL LYR");
    map.put('\uA49B', "YI RADICAL BBUT");
    map.put('\uA49C', "YI RADICAL MOP");
    map.put('\uA49D', "YI RADICAL YO");
    map.put('\uA49E', "YI RADICAL PUT");
    map.put('\uA49F', "YI RADICAL HXUO");
    map.put('\uA4A0', "YI RADICAL TAT");
    map.put('\uA4A1', "YI RADICAL GA");
    map.put('\uA4A2', "YI RADICAL ZUP");
    map.put('\uA4A3', "YI RADICAL CYT");
    map.put('\uA4A4', "YI RADICAL DDUR");
    map.put('\uA4A5', "YI RADICAL BUR");
    map.put('\uA4A6', "YI RADICAL GGUO");
    map.put('\uA4A7', "YI RADICAL NYOP");
    map.put('\uA4A8', "YI RADICAL TU");
    map.put('\uA4A9', "YI RADICAL OP");
    map.put('\uA4AA', "YI RADICAL JJUT");
    map.put('\uA4AB', "YI RADICAL ZOT");
    map.put('\uA4AC', "YI RADICAL PYT");
    map.put('\uA4AD', "YI RADICAL HMO");
    map.put('\uA4AE', "YI RADICAL YIT");
    map.put('\uA4AF', "YI RADICAL VUR");
    map.put('\uA4B0', "YI RADICAL SHY");
    map.put('\uA4B1', "YI RADICAL VEP");
    map.put('\uA4B2', "YI RADICAL ZA");
    map.put('\uA4B3', "YI RADICAL JO");
    map.put('\uA4B4', "YI RADICAL NZUP");
    map.put('\uA4B5', "YI RADICAL JJY");
    map.put('\uA4B6', "YI RADICAL GOT");
    map.put('\uA4B7', "YI RADICAL JJIE");
    map.put('\uA4B8', "YI RADICAL WO");
    map.put('\uA4B9', "YI RADICAL DU");
    map.put('\uA4BA', "YI RADICAL SHUR");
    map.put('\uA4BB', "YI RADICAL LIE");
    map.put('\uA4BC', "YI RADICAL CY");
    map.put('\uA4BD', "YI RADICAL CUOP");
    map.put('\uA4BE', "YI RADICAL CIP");
    map.put('\uA4BF', "YI RADICAL HXOP");
    map.put('\uA4C0', "YI RADICAL SHAT");
    map.put('\uA4C1', "YI RADICAL ZUR");
    map.put('\uA4C2', "YI RADICAL SHOP");
    map.put('\uA4C3', "YI RADICAL CHE");
    map.put('\uA4C4', "YI RADICAL ZZIET");
    map.put('\uA4C5', "YI RADICAL NBIE");
    map.put('\uA4C6', "YI RADICAL KE");
    map.put('\uA4D0', "LISU LETTER BA");
    map.put('\uA4D1', "LISU LETTER PA");
    map.put('\uA4D2', "LISU LETTER PHA");
    map.put('\uA4D3', "LISU LETTER DA");
    map.put('\uA4D4', "LISU LETTER TA");
    map.put('\uA4D5', "LISU LETTER THA");
    map.put('\uA4D6', "LISU LETTER GA");
    map.put('\uA4D7', "LISU LETTER KA");
    map.put('\uA4D8', "LISU LETTER KHA");
    map.put('\uA4D9', "LISU LETTER JA");
    map.put('\uA4DA', "LISU LETTER CA");
    map.put('\uA4DB', "LISU LETTER CHA");
    map.put('\uA4DC', "LISU LETTER DZA");
    map.put('\uA4DD', "LISU LETTER TSA");
    map.put('\uA4DE', "LISU LETTER TSHA");
    map.put('\uA4DF', "LISU LETTER MA");
    map.put('\uA4E0', "LISU LETTER NA");
    map.put('\uA4E1', "LISU LETTER LA");
    map.put('\uA4E2', "LISU LETTER SA");
    map.put('\uA4E3', "LISU LETTER ZHA");
    map.put('\uA4E4', "LISU LETTER ZA");
    map.put('\uA4E5', "LISU LETTER NGA");
    map.put('\uA4E6', "LISU LETTER HA");
    map.put('\uA4E7', "LISU LETTER XA");
    map.put('\uA4E8', "LISU LETTER HHA");
    map.put('\uA4E9', "LISU LETTER FA");
    map.put('\uA4EA', "LISU LETTER WA");
    map.put('\uA4EB', "LISU LETTER SHA");
    map.put('\uA4EC', "LISU LETTER YA");
    map.put('\uA4ED', "LISU LETTER GHA");
    map.put('\uA4EE', "LISU LETTER A");
    map.put('\uA4EF', "LISU LETTER AE");
    map.put('\uA4F0', "LISU LETTER E");
    map.put('\uA4F1', "LISU LETTER EU");
    map.put('\uA4F2', "LISU LETTER I");
    map.put('\uA4F3', "LISU LETTER O");
    map.put('\uA4F4', "LISU LETTER U");
    map.put('\uA4F5', "LISU LETTER UE");
    map.put('\uA4F6', "LISU LETTER UH");
    map.put('\uA4F7', "LISU LETTER OE");
    map.put('\uA4F8', "LISU LETTER TONE MYA TI");
    map.put('\uA4F9', "LISU LETTER TONE NA PO");
    map.put('\uA4FA', "LISU LETTER TONE MYA CYA");
    map.put('\uA4FB', "LISU LETTER TONE MYA BO");
    map.put('\uA4FC', "LISU LETTER TONE MYA NA");
    map.put('\uA4FD', "LISU LETTER TONE MYA JEU");
    map.put('\uA4FE', "LISU PUNCTUATION COMMA");
    map.put('\uA4FF', "LISU PUNCTUATION FULL STOP");
    map.put('\uA500', "VAI SYLLABLE EE");
    map.put('\uA501', "VAI SYLLABLE EEN");
    map.put('\uA502', "VAI SYLLABLE HEE");
    map.put('\uA503', "VAI SYLLABLE WEE");
    map.put('\uA504', "VAI SYLLABLE WEEN");
    map.put('\uA505', "VAI SYLLABLE PEE");
    map.put('\uA506', "VAI SYLLABLE BHEE");
    map.put('\uA507', "VAI SYLLABLE BEE");
    map.put('\uA508', "VAI SYLLABLE MBEE");
    map.put('\uA509', "VAI SYLLABLE KPEE");
    map.put('\uA50A', "VAI SYLLABLE MGBEE");
    map.put('\uA50B', "VAI SYLLABLE GBEE");
    map.put('\uA50C', "VAI SYLLABLE FEE");
    map.put('\uA50D', "VAI SYLLABLE VEE");
    map.put('\uA50E', "VAI SYLLABLE TEE");
    map.put('\uA50F', "VAI SYLLABLE THEE");
    map.put('\uA510', "VAI SYLLABLE DHEE");
    map.put('\uA511', "VAI SYLLABLE DHHEE");
    map.put('\uA512', "VAI SYLLABLE LEE");
    map.put('\uA513', "VAI SYLLABLE REE");
    map.put('\uA514', "VAI SYLLABLE DEE");
    map.put('\uA515', "VAI SYLLABLE NDEE");
    map.put('\uA516', "VAI SYLLABLE SEE");
    map.put('\uA517', "VAI SYLLABLE SHEE");
    map.put('\uA518', "VAI SYLLABLE ZEE");
    map.put('\uA519', "VAI SYLLABLE ZHEE");
    map.put('\uA51A', "VAI SYLLABLE CEE");
    map.put('\uA51B', "VAI SYLLABLE JEE");
    map.put('\uA51C', "VAI SYLLABLE NJEE");
    map.put('\uA51D', "VAI SYLLABLE YEE");
    map.put('\uA51E', "VAI SYLLABLE KEE");
    map.put('\uA51F', "VAI SYLLABLE NGGEE");
    map.put('\uA520', "VAI SYLLABLE GEE");
    map.put('\uA521', "VAI SYLLABLE MEE");
    map.put('\uA522', "VAI SYLLABLE NEE");
    map.put('\uA523', "VAI SYLLABLE NYEE");
    map.put('\uA524', "VAI SYLLABLE I");
    map.put('\uA525', "VAI SYLLABLE IN");
    map.put('\uA526', "VAI SYLLABLE HI");
    map.put('\uA527', "VAI SYLLABLE HIN");
    map.put('\uA528', "VAI SYLLABLE WI");
    map.put('\uA529', "VAI SYLLABLE WIN");
    map.put('\uA52A', "VAI SYLLABLE PI");
    map.put('\uA52B', "VAI SYLLABLE BHI");
    map.put('\uA52C', "VAI SYLLABLE BI");
    map.put('\uA52D', "VAI SYLLABLE MBI");
    map.put('\uA52E', "VAI SYLLABLE KPI");
    map.put('\uA52F', "VAI SYLLABLE MGBI");
    map.put('\uA530', "VAI SYLLABLE GBI");
    map.put('\uA531', "VAI SYLLABLE FI");
    map.put('\uA532', "VAI SYLLABLE VI");
    map.put('\uA533', "VAI SYLLABLE TI");
    map.put('\uA534', "VAI SYLLABLE THI");
    map.put('\uA535', "VAI SYLLABLE DHI");
    map.put('\uA536', "VAI SYLLABLE DHHI");
    map.put('\uA537', "VAI SYLLABLE LI");
    map.put('\uA538', "VAI SYLLABLE RI");
    map.put('\uA539', "VAI SYLLABLE DI");
    map.put('\uA53A', "VAI SYLLABLE NDI");
    map.put('\uA53B', "VAI SYLLABLE SI");
    map.put('\uA53C', "VAI SYLLABLE SHI");
    map.put('\uA53D', "VAI SYLLABLE ZI");
    map.put('\uA53E', "VAI SYLLABLE ZHI");
    map.put('\uA53F', "VAI SYLLABLE CI");
    map.put('\uA540', "VAI SYLLABLE JI");
    map.put('\uA541', "VAI SYLLABLE NJI");
    map.put('\uA542', "VAI SYLLABLE YI");
    map.put('\uA543', "VAI SYLLABLE KI");
    map.put('\uA544', "VAI SYLLABLE NGGI");
    map.put('\uA545', "VAI SYLLABLE GI");
    map.put('\uA546', "VAI SYLLABLE MI");
    map.put('\uA547', "VAI SYLLABLE NI");
    map.put('\uA548', "VAI SYLLABLE NYI");
    map.put('\uA549', "VAI SYLLABLE A");
    map.put('\uA54A', "VAI SYLLABLE AN");
    map.put('\uA54B', "VAI SYLLABLE NGAN");
    map.put('\uA54C', "VAI SYLLABLE HA");
    map.put('\uA54D', "VAI SYLLABLE HAN");
    map.put('\uA54E', "VAI SYLLABLE WA");
    map.put('\uA54F', "VAI SYLLABLE WAN");
    map.put('\uA550', "VAI SYLLABLE PA");
    map.put('\uA551', "VAI SYLLABLE BHA");
    map.put('\uA552', "VAI SYLLABLE BA");
    map.put('\uA553', "VAI SYLLABLE MBA");
    map.put('\uA554', "VAI SYLLABLE KPA");
    map.put('\uA555', "VAI SYLLABLE KPAN");
    map.put('\uA556', "VAI SYLLABLE MGBA");
    map.put('\uA557', "VAI SYLLABLE GBA");
    map.put('\uA558', "VAI SYLLABLE FA");
    map.put('\uA559', "VAI SYLLABLE VA");
    map.put('\uA55A', "VAI SYLLABLE TA");
    map.put('\uA55B', "VAI SYLLABLE THA");
    map.put('\uA55C', "VAI SYLLABLE DHA");
    map.put('\uA55D', "VAI SYLLABLE DHHA");
    map.put('\uA55E', "VAI SYLLABLE LA");
    map.put('\uA55F', "VAI SYLLABLE RA");
    map.put('\uA560', "VAI SYLLABLE DA");
    map.put('\uA561', "VAI SYLLABLE NDA");
    map.put('\uA562', "VAI SYLLABLE SA");
    map.put('\uA563', "VAI SYLLABLE SHA");
    map.put('\uA564', "VAI SYLLABLE ZA");
    map.put('\uA565', "VAI SYLLABLE ZHA");
    map.put('\uA566', "VAI SYLLABLE CA");
    map.put('\uA567', "VAI SYLLABLE JA");
    map.put('\uA568', "VAI SYLLABLE NJA");
    map.put('\uA569', "VAI SYLLABLE YA");
    map.put('\uA56A', "VAI SYLLABLE KA");
    map.put('\uA56B', "VAI SYLLABLE KAN");
    map.put('\uA56C', "VAI SYLLABLE NGGA");
    map.put('\uA56D', "VAI SYLLABLE GA");
    map.put('\uA56E', "VAI SYLLABLE MA");
    map.put('\uA56F', "VAI SYLLABLE NA");
    map.put('\uA570', "VAI SYLLABLE NYA");
    map.put('\uA571', "VAI SYLLABLE OO");
    map.put('\uA572', "VAI SYLLABLE OON");
    map.put('\uA573', "VAI SYLLABLE HOO");
    map.put('\uA574', "VAI SYLLABLE WOO");
    map.put('\uA575', "VAI SYLLABLE WOON");
    map.put('\uA576', "VAI SYLLABLE POO");
    map.put('\uA577', "VAI SYLLABLE BHOO");
    map.put('\uA578', "VAI SYLLABLE BOO");
    map.put('\uA579', "VAI SYLLABLE MBOO");
    map.put('\uA57A', "VAI SYLLABLE KPOO");
    map.put('\uA57B', "VAI SYLLABLE MGBOO");
    map.put('\uA57C', "VAI SYLLABLE GBOO");
    map.put('\uA57D', "VAI SYLLABLE FOO");
    map.put('\uA57E', "VAI SYLLABLE VOO");
    map.put('\uA57F', "VAI SYLLABLE TOO");
    map.put('\uA580', "VAI SYLLABLE THOO");
    map.put('\uA581', "VAI SYLLABLE DHOO");
    map.put('\uA582', "VAI SYLLABLE DHHOO");
    map.put('\uA583', "VAI SYLLABLE LOO");
    map.put('\uA584', "VAI SYLLABLE ROO");
    map.put('\uA585', "VAI SYLLABLE DOO");
    map.put('\uA586', "VAI SYLLABLE NDOO");
    map.put('\uA587', "VAI SYLLABLE SOO");
    map.put('\uA588', "VAI SYLLABLE SHOO");
    map.put('\uA589', "VAI SYLLABLE ZOO");
    map.put('\uA58A', "VAI SYLLABLE ZHOO");
    map.put('\uA58B', "VAI SYLLABLE COO");
    map.put('\uA58C', "VAI SYLLABLE JOO");
    map.put('\uA58D', "VAI SYLLABLE NJOO");
    map.put('\uA58E', "VAI SYLLABLE YOO");
    map.put('\uA58F', "VAI SYLLABLE KOO");
    map.put('\uA590', "VAI SYLLABLE NGGOO");
    map.put('\uA591', "VAI SYLLABLE GOO");
    map.put('\uA592', "VAI SYLLABLE MOO");
    map.put('\uA593', "VAI SYLLABLE NOO");
    map.put('\uA594', "VAI SYLLABLE NYOO");
    map.put('\uA595', "VAI SYLLABLE U");
    map.put('\uA596', "VAI SYLLABLE UN");
    map.put('\uA597', "VAI SYLLABLE HU");
    map.put('\uA598', "VAI SYLLABLE HUN");
    map.put('\uA599', "VAI SYLLABLE WU");
    map.put('\uA59A', "VAI SYLLABLE WUN");
    map.put('\uA59B', "VAI SYLLABLE PU");
    map.put('\uA59C', "VAI SYLLABLE BHU");
    map.put('\uA59D', "VAI SYLLABLE BU");
    map.put('\uA59E', "VAI SYLLABLE MBU");
    map.put('\uA59F', "VAI SYLLABLE KPU");
    map.put('\uA5A0', "VAI SYLLABLE MGBU");
    map.put('\uA5A1', "VAI SYLLABLE GBU");
    map.put('\uA5A2', "VAI SYLLABLE FU");
    map.put('\uA5A3', "VAI SYLLABLE VU");
    map.put('\uA5A4', "VAI SYLLABLE TU");
    map.put('\uA5A5', "VAI SYLLABLE THU");
    map.put('\uA5A6', "VAI SYLLABLE DHU");
    map.put('\uA5A7', "VAI SYLLABLE DHHU");
    map.put('\uA5A8', "VAI SYLLABLE LU");
    map.put('\uA5A9', "VAI SYLLABLE RU");
    map.put('\uA5AA', "VAI SYLLABLE DU");
    map.put('\uA5AB', "VAI SYLLABLE NDU");
    map.put('\uA5AC', "VAI SYLLABLE SU");
    map.put('\uA5AD', "VAI SYLLABLE SHU");
    map.put('\uA5AE', "VAI SYLLABLE ZU");
    map.put('\uA5AF', "VAI SYLLABLE ZHU");
    map.put('\uA5B0', "VAI SYLLABLE CU");
    map.put('\uA5B1', "VAI SYLLABLE JU");
    map.put('\uA5B2', "VAI SYLLABLE NJU");
    map.put('\uA5B3', "VAI SYLLABLE YU");
    map.put('\uA5B4', "VAI SYLLABLE KU");
    map.put('\uA5B5', "VAI SYLLABLE NGGU");
    map.put('\uA5B6', "VAI SYLLABLE GU");
    map.put('\uA5B7', "VAI SYLLABLE MU");
    map.put('\uA5B8', "VAI SYLLABLE NU");
    map.put('\uA5B9', "VAI SYLLABLE NYU");
    map.put('\uA5BA', "VAI SYLLABLE O");
    map.put('\uA5BB', "VAI SYLLABLE ON");
    map.put('\uA5BC', "VAI SYLLABLE NGON");
    map.put('\uA5BD', "VAI SYLLABLE HO");
    map.put('\uA5BE', "VAI SYLLABLE HON");
    map.put('\uA5BF', "VAI SYLLABLE WO");
    map.put('\uA5C0', "VAI SYLLABLE WON");
    map.put('\uA5C1', "VAI SYLLABLE PO");
    map.put('\uA5C2', "VAI SYLLABLE BHO");
    map.put('\uA5C3', "VAI SYLLABLE BO");
    map.put('\uA5C4', "VAI SYLLABLE MBO");
    map.put('\uA5C5', "VAI SYLLABLE KPO");
    map.put('\uA5C6', "VAI SYLLABLE MGBO");
    map.put('\uA5C7', "VAI SYLLABLE GBO");
    map.put('\uA5C8', "VAI SYLLABLE GBON");
    map.put('\uA5C9', "VAI SYLLABLE FO");
    map.put('\uA5CA', "VAI SYLLABLE VO");
    map.put('\uA5CB', "VAI SYLLABLE TO");
    map.put('\uA5CC', "VAI SYLLABLE THO");
    map.put('\uA5CD', "VAI SYLLABLE DHO");
    map.put('\uA5CE', "VAI SYLLABLE DHHO");
    map.put('\uA5CF', "VAI SYLLABLE LO");
    map.put('\uA5D0', "VAI SYLLABLE RO");
    map.put('\uA5D1', "VAI SYLLABLE DO");
    map.put('\uA5D2', "VAI SYLLABLE NDO");
    map.put('\uA5D3', "VAI SYLLABLE SO");
    map.put('\uA5D4', "VAI SYLLABLE SHO");
    map.put('\uA5D5', "VAI SYLLABLE ZO");
    map.put('\uA5D6', "VAI SYLLABLE ZHO");
    map.put('\uA5D7', "VAI SYLLABLE CO");
    map.put('\uA5D8', "VAI SYLLABLE JO");
    map.put('\uA5D9', "VAI SYLLABLE NJO");
    map.put('\uA5DA', "VAI SYLLABLE YO");
    map.put('\uA5DB', "VAI SYLLABLE KO");
    map.put('\uA5DC', "VAI SYLLABLE NGGO");
    map.put('\uA5DD', "VAI SYLLABLE GO");
    map.put('\uA5DE', "VAI SYLLABLE MO");
    map.put('\uA5DF', "VAI SYLLABLE NO");
    map.put('\uA5E0', "VAI SYLLABLE NYO");
    map.put('\uA5E1', "VAI SYLLABLE E");
    map.put('\uA5E2', "VAI SYLLABLE EN");
    map.put('\uA5E3', "VAI SYLLABLE NGEN");
    map.put('\uA5E4', "VAI SYLLABLE HE");
    map.put('\uA5E5', "VAI SYLLABLE HEN");
    map.put('\uA5E6', "VAI SYLLABLE WE");
    map.put('\uA5E7', "VAI SYLLABLE WEN");
    map.put('\uA5E8', "VAI SYLLABLE PE");
    map.put('\uA5E9', "VAI SYLLABLE BHE");
    map.put('\uA5EA', "VAI SYLLABLE BE");
    map.put('\uA5EB', "VAI SYLLABLE MBE");
    map.put('\uA5EC', "VAI SYLLABLE KPE");
    map.put('\uA5ED', "VAI SYLLABLE KPEN");
    map.put('\uA5EE', "VAI SYLLABLE MGBE");
    map.put('\uA5EF', "VAI SYLLABLE GBE");
    map.put('\uA5F0', "VAI SYLLABLE GBEN");
    map.put('\uA5F1', "VAI SYLLABLE FE");
    map.put('\uA5F2', "VAI SYLLABLE VE");
    map.put('\uA5F3', "VAI SYLLABLE TE");
    map.put('\uA5F4', "VAI SYLLABLE THE");
    map.put('\uA5F5', "VAI SYLLABLE DHE");
    map.put('\uA5F6', "VAI SYLLABLE DHHE");
    map.put('\uA5F7', "VAI SYLLABLE LE");
    map.put('\uA5F8', "VAI SYLLABLE RE");
    map.put('\uA5F9', "VAI SYLLABLE DE");
    map.put('\uA5FA', "VAI SYLLABLE NDE");
    map.put('\uA5FB', "VAI SYLLABLE SE");
    map.put('\uA5FC', "VAI SYLLABLE SHE");
    map.put('\uA5FD', "VAI SYLLABLE ZE");
    map.put('\uA5FE', "VAI SYLLABLE ZHE");
    map.put('\uA5FF', "VAI SYLLABLE CE");
    map.put('\uA600', "VAI SYLLABLE JE");
    map.put('\uA601', "VAI SYLLABLE NJE");
    map.put('\uA602', "VAI SYLLABLE YE");
    map.put('\uA603', "VAI SYLLABLE KE");
    map.put('\uA604', "VAI SYLLABLE NGGE");
    map.put('\uA605', "VAI SYLLABLE NGGEN");
    map.put('\uA606', "VAI SYLLABLE GE");
    map.put('\uA607', "VAI SYLLABLE GEN");
    map.put('\uA608', "VAI SYLLABLE ME");
    map.put('\uA609', "VAI SYLLABLE NE");
    map.put('\uA60A', "VAI SYLLABLE NYE");
    map.put('\uA60B', "VAI SYLLABLE NG");
    map.put('\uA60C', "VAI SYLLABLE LENGTHENER");
    map.put('\uA60D', "VAI COMMA");
    map.put('\uA60E', "VAI FULL STOP");
    map.put('\uA60F', "VAI QUESTION MARK");
    map.put('\uA610', "VAI SYLLABLE NDOLE FA");
    map.put('\uA611', "VAI SYLLABLE NDOLE KA");
    map.put('\uA612', "VAI SYLLABLE NDOLE SOO");
    map.put('\uA613', "VAI SYMBOL FEENG");
    map.put('\uA614', "VAI SYMBOL KEENG");
    map.put('\uA615', "VAI SYMBOL TING");
    map.put('\uA616', "VAI SYMBOL NII");
    map.put('\uA617', "VAI SYMBOL BANG");
    map.put('\uA618', "VAI SYMBOL FAA");
    map.put('\uA619', "VAI SYMBOL TAA");
    map.put('\uA61A', "VAI SYMBOL DANG");
    map.put('\uA61B', "VAI SYMBOL DOONG");
    map.put('\uA61C', "VAI SYMBOL KUNG");
    map.put('\uA61D', "VAI SYMBOL TONG");
    map.put('\uA61E', "VAI SYMBOL DO-O");
    map.put('\uA61F', "VAI SYMBOL JONG");
    map.put('\uA620', "VAI DIGIT ZERO");
    map.put('\uA621', "VAI DIGIT ONE");
    map.put('\uA622', "VAI DIGIT TWO");
    map.put('\uA623', "VAI DIGIT THREE");
    map.put('\uA624', "VAI DIGIT FOUR");
    map.put('\uA625', "VAI DIGIT FIVE");
    map.put('\uA626', "VAI DIGIT SIX");
    map.put('\uA627', "VAI DIGIT SEVEN");
    map.put('\uA628', "VAI DIGIT EIGHT");
    map.put('\uA629', "VAI DIGIT NINE");
    map.put('\uA62A', "VAI SYLLABLE NDOLE MA");
    map.put('\uA62B', "VAI SYLLABLE NDOLE DO");
    map.put('\uA640', "CYRILLIC CAPITAL LETTER ZEMLYA");
    map.put('\uA641', "CYRILLIC SMALL LETTER ZEMLYA");
    map.put('\uA642', "CYRILLIC CAPITAL LETTER DZELO");
    map.put('\uA643', "CYRILLIC SMALL LETTER DZELO");
    map.put('\uA644', "CYRILLIC CAPITAL LETTER REVERSED DZE");
    map.put('\uA645', "CYRILLIC SMALL LETTER REVERSED DZE");
    map.put('\uA646', "CYRILLIC CAPITAL LETTER IOTA");
    map.put('\uA647', "CYRILLIC SMALL LETTER IOTA");
    map.put('\uA648', "CYRILLIC CAPITAL LETTER DJERV");
    map.put('\uA649', "CYRILLIC SMALL LETTER DJERV");
    map.put('\uA64A', "CYRILLIC CAPITAL LETTER MONOGRAPH UK");
    map.put('\uA64B', "CYRILLIC SMALL LETTER MONOGRAPH UK");
    map.put('\uA64C', "CYRILLIC CAPITAL LETTER BROAD OMEGA");
    map.put('\uA64D', "CYRILLIC SMALL LETTER BROAD OMEGA");
    map.put('\uA64E', "CYRILLIC CAPITAL LETTER NEUTRAL YER");
    map.put('\uA64F', "CYRILLIC SMALL LETTER NEUTRAL YER");
    map.put('\uA650', "CYRILLIC CAPITAL LETTER YERU WITH BACK YER");
    map.put('\uA651', "CYRILLIC SMALL LETTER YERU WITH BACK YER");
    map.put('\uA652', "CYRILLIC CAPITAL LETTER IOTIFIED YAT");
    map.put('\uA653', "CYRILLIC SMALL LETTER IOTIFIED YAT");
    map.put('\uA654', "CYRILLIC CAPITAL LETTER REVERSED YU");
    map.put('\uA655', "CYRILLIC SMALL LETTER REVERSED YU");
    map.put('\uA656', "CYRILLIC CAPITAL LETTER IOTIFIED A");
    map.put('\uA657', "CYRILLIC SMALL LETTER IOTIFIED A");
    map.put('\uA658', "CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS");
    map.put('\uA659', "CYRILLIC SMALL LETTER CLOSED LITTLE YUS");
    map.put('\uA65A', "CYRILLIC CAPITAL LETTER BLENDED YUS");
    map.put('\uA65B', "CYRILLIC SMALL LETTER BLENDED YUS");
    map.put('\uA65C', "CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS");
    map.put('\uA65D', "CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS");
    map.put('\uA65E', "CYRILLIC CAPITAL LETTER YN");
    map.put('\uA65F', "CYRILLIC SMALL LETTER YN");
    map.put('\uA662', "CYRILLIC CAPITAL LETTER SOFT DE");
    map.put('\uA663', "CYRILLIC SMALL LETTER SOFT DE");
    map.put('\uA664', "CYRILLIC CAPITAL LETTER SOFT EL");
    map.put('\uA665', "CYRILLIC SMALL LETTER SOFT EL");
    map.put('\uA666', "CYRILLIC CAPITAL LETTER SOFT EM");
    map.put('\uA667', "CYRILLIC SMALL LETTER SOFT EM");
    map.put('\uA668', "CYRILLIC CAPITAL LETTER MONOCULAR O");
    map.put('\uA669', "CYRILLIC SMALL LETTER MONOCULAR O");
    map.put('\uA66A', "CYRILLIC CAPITAL LETTER BINOCULAR O");
    map.put('\uA66B', "CYRILLIC SMALL LETTER BINOCULAR O");
    map.put('\uA66C', "CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O");
    map.put('\uA66D', "CYRILLIC SMALL LETTER DOUBLE MONOCULAR O");
    map.put('\uA66E', "CYRILLIC LETTER MULTIOCULAR O");
    map.put('\uA66F', "COMBINING CYRILLIC VZMET");
    map.put('\uA670', "COMBINING CYRILLIC TEN MILLIONS SIGN");
    map.put('\uA671', "COMBINING CYRILLIC HUNDRED MILLIONS SIGN");
    map.put('\uA672', "COMBINING CYRILLIC THOUSAND MILLIONS SIGN");
    map.put('\uA673', "SLAVONIC ASTERISK");
    map.put('\uA67C', "COMBINING CYRILLIC KAVYKA");
    map.put('\uA67D', "COMBINING CYRILLIC PAYEROK");
    map.put('\uA67E', "CYRILLIC KAVYKA");
    map.put('\uA67F', "CYRILLIC PAYEROK");
    map.put('\uA680', "CYRILLIC CAPITAL LETTER DWE");
    map.put('\uA681', "CYRILLIC SMALL LETTER DWE");
    map.put('\uA682', "CYRILLIC CAPITAL LETTER DZWE");
    map.put('\uA683', "CYRILLIC SMALL LETTER DZWE");
    map.put('\uA684', "CYRILLIC CAPITAL LETTER ZHWE");
    map.put('\uA685', "CYRILLIC SMALL LETTER ZHWE");
    map.put('\uA686', "CYRILLIC CAPITAL LETTER CCHE");
    map.put('\uA687', "CYRILLIC SMALL LETTER CCHE");
    map.put('\uA688', "CYRILLIC CAPITAL LETTER DZZE");
    map.put('\uA689', "CYRILLIC SMALL LETTER DZZE");
    map.put('\uA68A', "CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK");
    map.put('\uA68B', "CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK");
    map.put('\uA68C', "CYRILLIC CAPITAL LETTER TWE");
    map.put('\uA68D', "CYRILLIC SMALL LETTER TWE");
    map.put('\uA68E', "CYRILLIC CAPITAL LETTER TSWE");
    map.put('\uA68F', "CYRILLIC SMALL LETTER TSWE");
    map.put('\uA690', "CYRILLIC CAPITAL LETTER TSSE");
    map.put('\uA691', "CYRILLIC SMALL LETTER TSSE");
    map.put('\uA692', "CYRILLIC CAPITAL LETTER TCHE");
    map.put('\uA693', "CYRILLIC SMALL LETTER TCHE");
    map.put('\uA694', "CYRILLIC CAPITAL LETTER HWE");
    map.put('\uA695', "CYRILLIC SMALL LETTER HWE");
    map.put('\uA696', "CYRILLIC CAPITAL LETTER SHWE");
    map.put('\uA697', "CYRILLIC SMALL LETTER SHWE");
    map.put('\uA6A0', "BAMUM LETTER A");
    map.put('\uA6A1', "BAMUM LETTER KA");
    map.put('\uA6A2', "BAMUM LETTER U");
    map.put('\uA6A3', "BAMUM LETTER KU");
    map.put('\uA6A4', "BAMUM LETTER EE");
    map.put('\uA6A5', "BAMUM LETTER REE");
    map.put('\uA6A6', "BAMUM LETTER TAE");
    map.put('\uA6A7', "BAMUM LETTER O");
    map.put('\uA6A8', "BAMUM LETTER NYI");
    map.put('\uA6A9', "BAMUM LETTER I");
    map.put('\uA6AA', "BAMUM LETTER LA");
    map.put('\uA6AB', "BAMUM LETTER PA");
    map.put('\uA6AC', "BAMUM LETTER RII");
    map.put('\uA6AD', "BAMUM LETTER RIEE");
    map.put('\uA6AE', "BAMUM LETTER LEEEE");
    map.put('\uA6AF', "BAMUM LETTER MEEEE");
    map.put('\uA6B0', "BAMUM LETTER TAA");
    map.put('\uA6B1', "BAMUM LETTER NDAA");
    map.put('\uA6B2', "BAMUM LETTER NJAEM");
    map.put('\uA6B3', "BAMUM LETTER M");
    map.put('\uA6B4', "BAMUM LETTER SUU");
    map.put('\uA6B5', "BAMUM LETTER MU");
    map.put('\uA6B6', "BAMUM LETTER SHII");
    map.put('\uA6B7', "BAMUM LETTER SI");
    map.put('\uA6B8', "BAMUM LETTER SHEUX");
    map.put('\uA6B9', "BAMUM LETTER SEUX");
    map.put('\uA6BA', "BAMUM LETTER KYEE");
    map.put('\uA6BB', "BAMUM LETTER KET");
    map.put('\uA6BC', "BAMUM LETTER NUAE");
    map.put('\uA6BD', "BAMUM LETTER NU");
    map.put('\uA6BE', "BAMUM LETTER NJUAE");
    map.put('\uA6BF', "BAMUM LETTER YOQ");
    map.put('\uA6C0', "BAMUM LETTER SHU");
    map.put('\uA6C1', "BAMUM LETTER YUQ");
    map.put('\uA6C2', "BAMUM LETTER YA");
    map.put('\uA6C3', "BAMUM LETTER NSHA");
    map.put('\uA6C4', "BAMUM LETTER KEUX");
    map.put('\uA6C5', "BAMUM LETTER PEUX");
    map.put('\uA6C6', "BAMUM LETTER NJEE");
    map.put('\uA6C7', "BAMUM LETTER NTEE");
    map.put('\uA6C8', "BAMUM LETTER PUE");
    map.put('\uA6C9', "BAMUM LETTER WUE");
    map.put('\uA6CA', "BAMUM LETTER PEE");
    map.put('\uA6CB', "BAMUM LETTER FEE");
    map.put('\uA6CC', "BAMUM LETTER RU");
    map.put('\uA6CD', "BAMUM LETTER LU");
    map.put('\uA6CE', "BAMUM LETTER MI");
    map.put('\uA6CF', "BAMUM LETTER NI");
    map.put('\uA6D0', "BAMUM LETTER REUX");
    map.put('\uA6D1', "BAMUM LETTER RAE");
    map.put('\uA6D2', "BAMUM LETTER KEN");
    map.put('\uA6D3', "BAMUM LETTER NGKWAEN");
    map.put('\uA6D4', "BAMUM LETTER NGGA");
    map.put('\uA6D5', "BAMUM LETTER NGA");
    map.put('\uA6D6', "BAMUM LETTER SHO");
    map.put('\uA6D7', "BAMUM LETTER PUAE");
    map.put('\uA6D8', "BAMUM LETTER FU");
    map.put('\uA6D9', "BAMUM LETTER FOM");
    map.put('\uA6DA', "BAMUM LETTER WA");
    map.put('\uA6DB', "BAMUM LETTER NA");
    map.put('\uA6DC', "BAMUM LETTER LI");
    map.put('\uA6DD', "BAMUM LETTER PI");
    map.put('\uA6DE', "BAMUM LETTER LOQ");
    map.put('\uA6DF', "BAMUM LETTER KO");
    map.put('\uA6E0', "BAMUM LETTER MBEN");
    map.put('\uA6E1', "BAMUM LETTER REN");
    map.put('\uA6E2', "BAMUM LETTER MEN");
    map.put('\uA6E3', "BAMUM LETTER MA");
    map.put('\uA6E4', "BAMUM LETTER TI");
    map.put('\uA6E5', "BAMUM LETTER KI");
    map.put('\uA6E6', "BAMUM LETTER MO");
    map.put('\uA6E7', "BAMUM LETTER MBAA");
    map.put('\uA6E8', "BAMUM LETTER TET");
    map.put('\uA6E9', "BAMUM LETTER KPA");
    map.put('\uA6EA', "BAMUM LETTER TEN");
    map.put('\uA6EB', "BAMUM LETTER NTUU");
    map.put('\uA6EC', "BAMUM LETTER SAMBA");
    map.put('\uA6ED', "BAMUM LETTER FAAMAE");
    map.put('\uA6EE', "BAMUM LETTER KOVUU");
    map.put('\uA6EF', "BAMUM LETTER KOGHOM");
    map.put('\uA6F0', "BAMUM COMBINING MARK KOQNDON");
    map.put('\uA6F1', "BAMUM COMBINING MARK TUKWENTIS");
    map.put('\uA6F2', "BAMUM NJAEMLI");
    map.put('\uA6F3', "BAMUM FULL STOP");
    map.put('\uA6F4', "BAMUM COLON");
    map.put('\uA6F5', "BAMUM COMMA");
    map.put('\uA6F6', "BAMUM SEMICOLON");
    map.put('\uA6F7', "BAMUM QUESTION MARK");
    map.put('\uA700', "MODIFIER LETTER CHINESE TONE YIN PING");
    map.put('\uA701', "MODIFIER LETTER CHINESE TONE YANG PING");
    map.put('\uA702', "MODIFIER LETTER CHINESE TONE YIN SHANG");
    map.put('\uA703', "MODIFIER LETTER CHINESE TONE YANG SHANG");
    map.put('\uA704', "MODIFIER LETTER CHINESE TONE YIN QU");
    map.put('\uA705', "MODIFIER LETTER CHINESE TONE YANG QU");
    map.put('\uA706', "MODIFIER LETTER CHINESE TONE YIN RU");
    map.put('\uA707', "MODIFIER LETTER CHINESE TONE YANG RU");
    map.put('\uA708', "MODIFIER LETTER EXTRA-HIGH DOTTED TONE BAR");
    map.put('\uA709', "MODIFIER LETTER HIGH DOTTED TONE BAR");
    map.put('\uA70A', "MODIFIER LETTER MID DOTTED TONE BAR");
    map.put('\uA70B', "MODIFIER LETTER LOW DOTTED TONE BAR");
    map.put('\uA70C', "MODIFIER LETTER EXTRA-LOW DOTTED TONE BAR");
    map.put('\uA70D', "MODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BAR");
    map.put('\uA70E', "MODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR");
    map.put('\uA70F', "MODIFIER LETTER MID DOTTED LEFT-STEM TONE BAR");
    map.put('\uA710', "MODIFIER LETTER LOW DOTTED LEFT-STEM TONE BAR");
    map.put('\uA711', "MODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BAR");
    map.put('\uA712', "MODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BAR");
    map.put('\uA713', "MODIFIER LETTER HIGH LEFT-STEM TONE BAR");
    map.put('\uA714', "MODIFIER LETTER MID LEFT-STEM TONE BAR");
    map.put('\uA715', "MODIFIER LETTER LOW LEFT-STEM TONE BAR");
    map.put('\uA716', "MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR");
    map.put('\uA717', "MODIFIER LETTER DOT VERTICAL BAR");
    map.put('\uA718', "MODIFIER LETTER DOT SLASH");
    map.put('\uA719', "MODIFIER LETTER DOT HORIZONTAL BAR");
    map.put('\uA71A', "MODIFIER LETTER LOWER RIGHT CORNER ANGLE");
    map.put('\uA71B', "MODIFIER LETTER RAISED UP ARROW");
    map.put('\uA71C', "MODIFIER LETTER RAISED DOWN ARROW");
    map.put('\uA71D', "MODIFIER LETTER RAISED EXCLAMATION MARK");
    map.put('\uA71E', "MODIFIER LETTER RAISED INVERTED EXCLAMATION MARK");
    map.put('\uA71F', "MODIFIER LETTER LOW INVERTED EXCLAMATION MARK");
    map.put('\uA720', "MODIFIER LETTER STRESS AND HIGH TONE");
    map.put('\uA721', "MODIFIER LETTER STRESS AND LOW TONE");
    map.put('\uA722', "LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF");
    map.put('\uA723', "LATIN SMALL LETTER EGYPTOLOGICAL ALEF");
    map.put('\uA724', "LATIN CAPITAL LETTER EGYPTOLOGICAL AIN");
    map.put('\uA725', "LATIN SMALL LETTER EGYPTOLOGICAL AIN");
    map.put('\uA726', "LATIN CAPITAL LETTER HENG");
    map.put('\uA727', "LATIN SMALL LETTER HENG");
    map.put('\uA728', "LATIN CAPITAL LETTER TZ");
    map.put('\uA729', "LATIN SMALL LETTER TZ");
    map.put('\uA72A', "LATIN CAPITAL LETTER TRESILLO");
    map.put('\uA72B', "LATIN SMALL LETTER TRESILLO");
    map.put('\uA72C', "LATIN CAPITAL LETTER CUATRILLO");
    map.put('\uA72D', "LATIN SMALL LETTER CUATRILLO");
    map.put('\uA72E', "LATIN CAPITAL LETTER CUATRILLO WITH COMMA");
    map.put('\uA72F', "LATIN SMALL LETTER CUATRILLO WITH COMMA");
    map.put('\uA730', "LATIN LETTER SMALL CAPITAL F");
    map.put('\uA731', "LATIN LETTER SMALL CAPITAL S");
    map.put('\uA732', "LATIN CAPITAL LETTER AA");
    map.put('\uA733', "LATIN SMALL LETTER AA");
    map.put('\uA734', "LATIN CAPITAL LETTER AO");
    map.put('\uA735', "LATIN SMALL LETTER AO");
    map.put('\uA736', "LATIN CAPITAL LETTER AU");
    map.put('\uA737', "LATIN SMALL LETTER AU");
    map.put('\uA738', "LATIN CAPITAL LETTER AV");
    map.put('\uA739', "LATIN SMALL LETTER AV");
    map.put('\uA73A', "LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR");
    map.put('\uA73B', "LATIN SMALL LETTER AV WITH HORIZONTAL BAR");
    map.put('\uA73C', "LATIN CAPITAL LETTER AY");
    map.put('\uA73D', "LATIN SMALL LETTER AY");
    map.put('\uA73E', "LATIN CAPITAL LETTER REVERSED C WITH DOT");
    map.put('\uA73F', "LATIN SMALL LETTER REVERSED C WITH DOT");
    map.put('\uA740', "LATIN CAPITAL LETTER K WITH STROKE");
    map.put('\uA741', "LATIN SMALL LETTER K WITH STROKE");
    map.put('\uA742', "LATIN CAPITAL LETTER K WITH DIAGONAL STROKE");
    map.put('\uA743', "LATIN SMALL LETTER K WITH DIAGONAL STROKE");
    map.put('\uA744', "LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE");
    map.put('\uA745', "LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE");
    map.put('\uA746', "LATIN CAPITAL LETTER BROKEN L");
    map.put('\uA747', "LATIN SMALL LETTER BROKEN L");
    map.put('\uA748', "LATIN CAPITAL LETTER L WITH HIGH STROKE");
    map.put('\uA749', "LATIN SMALL LETTER L WITH HIGH STROKE");
    map.put('\uA74A', "LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY");
    map.put('\uA74B', "LATIN SMALL LETTER O WITH LONG STROKE OVERLAY");
    map.put('\uA74C', "LATIN CAPITAL LETTER O WITH LOOP");
    map.put('\uA74D', "LATIN SMALL LETTER O WITH LOOP");
    map.put('\uA74E', "LATIN CAPITAL LETTER OO");
    map.put('\uA74F', "LATIN SMALL LETTER OO");
    map.put('\uA750', "LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER");
    map.put('\uA751', "LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER");
    map.put('\uA752', "LATIN CAPITAL LETTER P WITH FLOURISH");
    map.put('\uA753', "LATIN SMALL LETTER P WITH FLOURISH");
    map.put('\uA754', "LATIN CAPITAL LETTER P WITH SQUIRREL TAIL");
    map.put('\uA755', "LATIN SMALL LETTER P WITH SQUIRREL TAIL");
    map.put('\uA756', "LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER");
    map.put('\uA757', "LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER");
    map.put('\uA758', "LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE");
    map.put('\uA759', "LATIN SMALL LETTER Q WITH DIAGONAL STROKE");
    map.put('\uA75A', "LATIN CAPITAL LETTER R ROTUNDA");
    map.put('\uA75B', "LATIN SMALL LETTER R ROTUNDA");
    map.put('\uA75C', "LATIN CAPITAL LETTER RUM ROTUNDA");
    map.put('\uA75D', "LATIN SMALL LETTER RUM ROTUNDA");
    map.put('\uA75E', "LATIN CAPITAL LETTER V WITH DIAGONAL STROKE");
    map.put('\uA75F', "LATIN SMALL LETTER V WITH DIAGONAL STROKE");
    map.put('\uA760', "LATIN CAPITAL LETTER VY");
    map.put('\uA761', "LATIN SMALL LETTER VY");
    map.put('\uA762', "LATIN CAPITAL LETTER VISIGOTHIC Z");
    map.put('\uA763', "LATIN SMALL LETTER VISIGOTHIC Z");
    map.put('\uA764', "LATIN CAPITAL LETTER THORN WITH STROKE");
    map.put('\uA765', "LATIN SMALL LETTER THORN WITH STROKE");
    map.put('\uA766', "LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER");
    map.put('\uA767', "LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER");
    map.put('\uA768', "LATIN CAPITAL LETTER VEND");
    map.put('\uA769', "LATIN SMALL LETTER VEND");
    map.put('\uA76A', "LATIN CAPITAL LETTER ET");
    map.put('\uA76B', "LATIN SMALL LETTER ET");
    map.put('\uA76C', "LATIN CAPITAL LETTER IS");
    map.put('\uA76D', "LATIN SMALL LETTER IS");
    map.put('\uA76E', "LATIN CAPITAL LETTER CON");
    map.put('\uA76F', "LATIN SMALL LETTER CON");
    map.put('\uA770', "MODIFIER LETTER US");
    map.put('\uA771', "LATIN SMALL LETTER DUM");
    map.put('\uA772', "LATIN SMALL LETTER LUM");
    map.put('\uA773', "LATIN SMALL LETTER MUM");
    map.put('\uA774', "LATIN SMALL LETTER NUM");
    map.put('\uA775', "LATIN SMALL LETTER RUM");
    map.put('\uA776', "LATIN LETTER SMALL CAPITAL RUM");
    map.put('\uA777', "LATIN SMALL LETTER TUM");
    map.put('\uA778', "LATIN SMALL LETTER UM");
    map.put('\uA779', "LATIN CAPITAL LETTER INSULAR D");
    map.put('\uA77A', "LATIN SMALL LETTER INSULAR D");
    map.put('\uA77B', "LATIN CAPITAL LETTER INSULAR F");
    map.put('\uA77C', "LATIN SMALL LETTER INSULAR F");
    map.put('\uA77D', "LATIN CAPITAL LETTER INSULAR G");
    map.put('\uA77E', "LATIN CAPITAL LETTER TURNED INSULAR G");
    map.put('\uA77F', "LATIN SMALL LETTER TURNED INSULAR G");
    map.put('\uA780', "LATIN CAPITAL LETTER TURNED L");
    map.put('\uA781', "LATIN SMALL LETTER TURNED L");
    map.put('\uA782', "LATIN CAPITAL LETTER INSULAR R");
    map.put('\uA783', "LATIN SMALL LETTER INSULAR R");
    map.put('\uA784', "LATIN CAPITAL LETTER INSULAR S");
    map.put('\uA785', "LATIN SMALL LETTER INSULAR S");
    map.put('\uA786', "LATIN CAPITAL LETTER INSULAR T");
    map.put('\uA787', "LATIN SMALL LETTER INSULAR T");
    map.put('\uA788', "MODIFIER LETTER LOW CIRCUMFLEX ACCENT");
    map.put('\uA789', "MODIFIER LETTER COLON");
    map.put('\uA78A', "MODIFIER LETTER SHORT EQUALS SIGN");
    map.put('\uA78B', "LATIN CAPITAL LETTER SALTILLO");
    map.put('\uA78C', "LATIN SMALL LETTER SALTILLO");
    map.put('\uA7FB', "LATIN EPIGRAPHIC LETTER REVERSED F");
    map.put('\uA7FC', "LATIN EPIGRAPHIC LETTER REVERSED P");
    map.put('\uA7FD', "LATIN EPIGRAPHIC LETTER INVERTED M");
    map.put('\uA7FE', "LATIN EPIGRAPHIC LETTER I LONGA");
    map.put('\uA7FF', "LATIN EPIGRAPHIC LETTER ARCHAIC M");
    map.put('\uA800', "SYLOTI NAGRI LETTER A");
    map.put('\uA801', "SYLOTI NAGRI LETTER I");
    map.put('\uA802', "SYLOTI NAGRI SIGN DVISVARA");
    map.put('\uA803', "SYLOTI NAGRI LETTER U");
    map.put('\uA804', "SYLOTI NAGRI LETTER E");
    map.put('\uA805', "SYLOTI NAGRI LETTER O");
    map.put('\uA806', "SYLOTI NAGRI SIGN HASANTA");
    map.put('\uA807', "SYLOTI NAGRI LETTER KO");
    map.put('\uA808', "SYLOTI NAGRI LETTER KHO");
    map.put('\uA809', "SYLOTI NAGRI LETTER GO");
    map.put('\uA80A', "SYLOTI NAGRI LETTER GHO");
    map.put('\uA80B', "SYLOTI NAGRI SIGN ANUSVARA");
    map.put('\uA80C', "SYLOTI NAGRI LETTER CO");
    map.put('\uA80D', "SYLOTI NAGRI LETTER CHO");
    map.put('\uA80E', "SYLOTI NAGRI LETTER JO");
    map.put('\uA80F', "SYLOTI NAGRI LETTER JHO");
    map.put('\uA810', "SYLOTI NAGRI LETTER TTO");
    map.put('\uA811', "SYLOTI NAGRI LETTER TTHO");
    map.put('\uA812', "SYLOTI NAGRI LETTER DDO");
    map.put('\uA813', "SYLOTI NAGRI LETTER DDHO");
    map.put('\uA814', "SYLOTI NAGRI LETTER TO");
    map.put('\uA815', "SYLOTI NAGRI LETTER THO");
    map.put('\uA816', "SYLOTI NAGRI LETTER DO");
    map.put('\uA817', "SYLOTI NAGRI LETTER DHO");
    map.put('\uA818', "SYLOTI NAGRI LETTER NO");
    map.put('\uA819', "SYLOTI NAGRI LETTER PO");
    map.put('\uA81A', "SYLOTI NAGRI LETTER PHO");
    map.put('\uA81B', "SYLOTI NAGRI LETTER BO");
    map.put('\uA81C', "SYLOTI NAGRI LETTER BHO");
    map.put('\uA81D', "SYLOTI NAGRI LETTER MO");
    map.put('\uA81E', "SYLOTI NAGRI LETTER RO");
    map.put('\uA81F', "SYLOTI NAGRI LETTER LO");
    map.put('\uA820', "SYLOTI NAGRI LETTER RRO");
    map.put('\uA821', "SYLOTI NAGRI LETTER SO");
    map.put('\uA822', "SYLOTI NAGRI LETTER HO");
    map.put('\uA823', "SYLOTI NAGRI VOWEL SIGN A");
    map.put('\uA824', "SYLOTI NAGRI VOWEL SIGN I");
    map.put('\uA825', "SYLOTI NAGRI VOWEL SIGN U");
    map.put('\uA826', "SYLOTI NAGRI VOWEL SIGN E");
    map.put('\uA827', "SYLOTI NAGRI VOWEL SIGN OO");
    map.put('\uA828', "SYLOTI NAGRI POETRY MARK-1");
    map.put('\uA829', "SYLOTI NAGRI POETRY MARK-2");
    map.put('\uA82A', "SYLOTI NAGRI POETRY MARK-3");
    map.put('\uA82B', "SYLOTI NAGRI POETRY MARK-4");
    map.put('\uA830', "NORTH INDIC FRACTION ONE QUARTER");
    map.put('\uA831', "NORTH INDIC FRACTION ONE HALF");
    map.put('\uA832', "NORTH INDIC FRACTION THREE QUARTERS");
    map.put('\uA833', "NORTH INDIC FRACTION ONE SIXTEENTH");
    map.put('\uA834', "NORTH INDIC FRACTION ONE EIGHTH");
    map.put('\uA835', "NORTH INDIC FRACTION THREE SIXTEENTHS");
    map.put('\uA836', "NORTH INDIC QUARTER MARK");
    map.put('\uA837', "NORTH INDIC PLACEHOLDER MARK");
    map.put('\uA838', "NORTH INDIC RUPEE MARK");
    map.put('\uA839', "NORTH INDIC QUANTITY MARK");
    map.put('\uA840', "PHAGS-PA LETTER KA");
    map.put('\uA841', "PHAGS-PA LETTER KHA");
    map.put('\uA842', "PHAGS-PA LETTER GA");
    map.put('\uA843', "PHAGS-PA LETTER NGA");
    map.put('\uA844', "PHAGS-PA LETTER CA");
    map.put('\uA845', "PHAGS-PA LETTER CHA");
    map.put('\uA846', "PHAGS-PA LETTER JA");
    map.put('\uA847', "PHAGS-PA LETTER NYA");
    map.put('\uA848', "PHAGS-PA LETTER TA");
    map.put('\uA849', "PHAGS-PA LETTER THA");
    map.put('\uA84A', "PHAGS-PA LETTER DA");
    map.put('\uA84B', "PHAGS-PA LETTER NA");
    map.put('\uA84C', "PHAGS-PA LETTER PA");
    map.put('\uA84D', "PHAGS-PA LETTER PHA");
    map.put('\uA84E', "PHAGS-PA LETTER BA");
    map.put('\uA84F', "PHAGS-PA LETTER MA");
    map.put('\uA850', "PHAGS-PA LETTER TSA");
    map.put('\uA851', "PHAGS-PA LETTER TSHA");
    map.put('\uA852', "PHAGS-PA LETTER DZA");
    map.put('\uA853', "PHAGS-PA LETTER WA");
    map.put('\uA854', "PHAGS-PA LETTER ZHA");
    map.put('\uA855', "PHAGS-PA LETTER ZA");
    map.put('\uA856', "PHAGS-PA LETTER SMALL A");
    map.put('\uA857', "PHAGS-PA LETTER YA");
    map.put('\uA858', "PHAGS-PA LETTER RA");
    map.put('\uA859', "PHAGS-PA LETTER LA");
    map.put('\uA85A', "PHAGS-PA LETTER SHA");
    map.put('\uA85B', "PHAGS-PA LETTER SA");
    map.put('\uA85C', "PHAGS-PA LETTER HA");
    map.put('\uA85D', "PHAGS-PA LETTER A");
    map.put('\uA85E', "PHAGS-PA LETTER I");
    map.put('\uA85F', "PHAGS-PA LETTER U");
    map.put('\uA860', "PHAGS-PA LETTER E");
    map.put('\uA861', "PHAGS-PA LETTER O");
    map.put('\uA862', "PHAGS-PA LETTER QA");
    map.put('\uA863', "PHAGS-PA LETTER XA");
    map.put('\uA864', "PHAGS-PA LETTER FA");
    map.put('\uA865', "PHAGS-PA LETTER GGA");
    map.put('\uA866', "PHAGS-PA LETTER EE");
    map.put('\uA867', "PHAGS-PA SUBJOINED LETTER WA");
    map.put('\uA868', "PHAGS-PA SUBJOINED LETTER YA");
    map.put('\uA869', "PHAGS-PA LETTER TTA");
    map.put('\uA86A', "PHAGS-PA LETTER TTHA");
    map.put('\uA86B', "PHAGS-PA LETTER DDA");
    map.put('\uA86C', "PHAGS-PA LETTER NNA");
    map.put('\uA86D', "PHAGS-PA LETTER ALTERNATE YA");
    map.put('\uA86E', "PHAGS-PA LETTER VOICELESS SHA");
    map.put('\uA86F', "PHAGS-PA LETTER VOICED HA");
    map.put('\uA870', "PHAGS-PA LETTER ASPIRATED FA");
    map.put('\uA871', "PHAGS-PA SUBJOINED LETTER RA");
    map.put('\uA872', "PHAGS-PA SUPERFIXED LETTER RA");
    map.put('\uA873', "PHAGS-PA LETTER CANDRABINDU");
    map.put('\uA874', "PHAGS-PA SINGLE HEAD MARK");
    map.put('\uA875', "PHAGS-PA DOUBLE HEAD MARK");
    map.put('\uA876', "PHAGS-PA MARK SHAD");
    map.put('\uA877', "PHAGS-PA MARK DOUBLE SHAD");
    map.put('\uA880', "SAURASHTRA SIGN ANUSVARA");
    map.put('\uA881', "SAURASHTRA SIGN VISARGA");
    map.put('\uA882', "SAURASHTRA LETTER A");
    map.put('\uA883', "SAURASHTRA LETTER AA");
    map.put('\uA884', "SAURASHTRA LETTER I");
    map.put('\uA885', "SAURASHTRA LETTER II");
    map.put('\uA886', "SAURASHTRA LETTER U");
    map.put('\uA887', "SAURASHTRA LETTER UU");
    map.put('\uA888', "SAURASHTRA LETTER VOCALIC R");
    map.put('\uA889', "SAURASHTRA LETTER VOCALIC RR");
    map.put('\uA88A', "SAURASHTRA LETTER VOCALIC L");
    map.put('\uA88B', "SAURASHTRA LETTER VOCALIC LL");
    map.put('\uA88C', "SAURASHTRA LETTER E");
    map.put('\uA88D', "SAURASHTRA LETTER EE");
    map.put('\uA88E', "SAURASHTRA LETTER AI");
    map.put('\uA88F', "SAURASHTRA LETTER O");
    map.put('\uA890', "SAURASHTRA LETTER OO");
    map.put('\uA891', "SAURASHTRA LETTER AU");
    map.put('\uA892', "SAURASHTRA LETTER KA");
    map.put('\uA893', "SAURASHTRA LETTER KHA");
    map.put('\uA894', "SAURASHTRA LETTER GA");
    map.put('\uA895', "SAURASHTRA LETTER GHA");
    map.put('\uA896', "SAURASHTRA LETTER NGA");
    map.put('\uA897', "SAURASHTRA LETTER CA");
    map.put('\uA898', "SAURASHTRA LETTER CHA");
    map.put('\uA899', "SAURASHTRA LETTER JA");
    map.put('\uA89A', "SAURASHTRA LETTER JHA");
    map.put('\uA89B', "SAURASHTRA LETTER NYA");
    map.put('\uA89C', "SAURASHTRA LETTER TTA");
    map.put('\uA89D', "SAURASHTRA LETTER TTHA");
    map.put('\uA89E', "SAURASHTRA LETTER DDA");
    map.put('\uA89F', "SAURASHTRA LETTER DDHA");
    map.put('\uA8A0', "SAURASHTRA LETTER NNA");
    map.put('\uA8A1', "SAURASHTRA LETTER TA");
    map.put('\uA8A2', "SAURASHTRA LETTER THA");
    map.put('\uA8A3', "SAURASHTRA LETTER DA");
    map.put('\uA8A4', "SAURASHTRA LETTER DHA");
    map.put('\uA8A5', "SAURASHTRA LETTER NA");
    map.put('\uA8A6', "SAURASHTRA LETTER PA");
    map.put('\uA8A7', "SAURASHTRA LETTER PHA");
    map.put('\uA8A8', "SAURASHTRA LETTER BA");
    map.put('\uA8A9', "SAURASHTRA LETTER BHA");
    map.put('\uA8AA', "SAURASHTRA LETTER MA");
    map.put('\uA8AB', "SAURASHTRA LETTER YA");
    map.put('\uA8AC', "SAURASHTRA LETTER RA");
    map.put('\uA8AD', "SAURASHTRA LETTER LA");
    map.put('\uA8AE', "SAURASHTRA LETTER VA");
    map.put('\uA8AF', "SAURASHTRA LETTER SHA");
    map.put('\uA8B0', "SAURASHTRA LETTER SSA");
    map.put('\uA8B1', "SAURASHTRA LETTER SA");
    map.put('\uA8B2', "SAURASHTRA LETTER HA");
    map.put('\uA8B3', "SAURASHTRA LETTER LLA");
    map.put('\uA8B4', "SAURASHTRA CONSONANT SIGN HAARU");
    map.put('\uA8B5', "SAURASHTRA VOWEL SIGN AA");
    map.put('\uA8B6', "SAURASHTRA VOWEL SIGN I");
    map.put('\uA8B7', "SAURASHTRA VOWEL SIGN II");
    map.put('\uA8B8', "SAURASHTRA VOWEL SIGN U");
    map.put('\uA8B9', "SAURASHTRA VOWEL SIGN UU");
    map.put('\uA8BA', "SAURASHTRA VOWEL SIGN VOCALIC R");
    map.put('\uA8BB', "SAURASHTRA VOWEL SIGN VOCALIC RR");
    map.put('\uA8BC', "SAURASHTRA VOWEL SIGN VOCALIC L");
    map.put('\uA8BD', "SAURASHTRA VOWEL SIGN VOCALIC LL");
    map.put('\uA8BE', "SAURASHTRA VOWEL SIGN E");
    map.put('\uA8BF', "SAURASHTRA VOWEL SIGN EE");
    map.put('\uA8C0', "SAURASHTRA VOWEL SIGN AI");
    map.put('\uA8C1', "SAURASHTRA VOWEL SIGN O");
    map.put('\uA8C2', "SAURASHTRA VOWEL SIGN OO");
    map.put('\uA8C3', "SAURASHTRA VOWEL SIGN AU");
    map.put('\uA8C4', "SAURASHTRA SIGN VIRAMA");
    map.put('\uA8CE', "SAURASHTRA DANDA");
    map.put('\uA8CF', "SAURASHTRA DOUBLE DANDA");
    map.put('\uA8D0', "SAURASHTRA DIGIT ZERO");
    map.put('\uA8D1', "SAURASHTRA DIGIT ONE");
    map.put('\uA8D2', "SAURASHTRA DIGIT TWO");
    map.put('\uA8D3', "SAURASHTRA DIGIT THREE");
    map.put('\uA8D4', "SAURASHTRA DIGIT FOUR");
    map.put('\uA8D5', "SAURASHTRA DIGIT FIVE");
    map.put('\uA8D6', "SAURASHTRA DIGIT SIX");
    map.put('\uA8D7', "SAURASHTRA DIGIT SEVEN");
    map.put('\uA8D8', "SAURASHTRA DIGIT EIGHT");
    map.put('\uA8D9', "SAURASHTRA DIGIT NINE");
    map.put('\uA8E0', "COMBINING DEVANAGARI DIGIT ZERO");
    map.put('\uA8E1', "COMBINING DEVANAGARI DIGIT ONE");
    map.put('\uA8E2', "COMBINING DEVANAGARI DIGIT TWO");
    map.put('\uA8E3', "COMBINING DEVANAGARI DIGIT THREE");
    map.put('\uA8E4', "COMBINING DEVANAGARI DIGIT FOUR");
    map.put('\uA8E5', "COMBINING DEVANAGARI DIGIT FIVE");
    map.put('\uA8E6', "COMBINING DEVANAGARI DIGIT SIX");
    map.put('\uA8E7', "COMBINING DEVANAGARI DIGIT SEVEN");
    map.put('\uA8E8', "COMBINING DEVANAGARI DIGIT EIGHT");
    map.put('\uA8E9', "COMBINING DEVANAGARI DIGIT NINE");
    map.put('\uA8EA', "COMBINING DEVANAGARI LETTER A");
    map.put('\uA8EB', "COMBINING DEVANAGARI LETTER U");
    map.put('\uA8EC', "COMBINING DEVANAGARI LETTER KA");
    map.put('\uA8ED', "COMBINING DEVANAGARI LETTER NA");
    map.put('\uA8EE', "COMBINING DEVANAGARI LETTER PA");
    map.put('\uA8EF', "COMBINING DEVANAGARI LETTER RA");
    map.put('\uA8F0', "COMBINING DEVANAGARI LETTER VI");
    map.put('\uA8F1', "COMBINING DEVANAGARI SIGN AVAGRAHA");
    map.put('\uA8F2', "DEVANAGARI SIGN SPACING CANDRABINDU");
    map.put('\uA8F3', "DEVANAGARI SIGN CANDRABINDU VIRAMA");
    map.put('\uA8F4', "DEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMA");
    map.put('\uA8F5', "DEVANAGARI SIGN CANDRABINDU TWO");
    map.put('\uA8F6', "DEVANAGARI SIGN CANDRABINDU THREE");
    map.put('\uA8F7', "DEVANAGARI SIGN CANDRABINDU AVAGRAHA");
    map.put('\uA8F8', "DEVANAGARI SIGN PUSHPIKA");
    map.put('\uA8F9', "DEVANAGARI GAP FILLER");
    map.put('\uA8FA', "DEVANAGARI CARET");
    map.put('\uA8FB', "DEVANAGARI HEADSTROKE");
    map.put('\uA900', "KAYAH LI DIGIT ZERO");
    map.put('\uA901', "KAYAH LI DIGIT ONE");
    map.put('\uA902', "KAYAH LI DIGIT TWO");
    map.put('\uA903', "KAYAH LI DIGIT THREE");
    map.put('\uA904', "KAYAH LI DIGIT FOUR");
    map.put('\uA905', "KAYAH LI DIGIT FIVE");
    map.put('\uA906', "KAYAH LI DIGIT SIX");
    map.put('\uA907', "KAYAH LI DIGIT SEVEN");
    map.put('\uA908', "KAYAH LI DIGIT EIGHT");
    map.put('\uA909', "KAYAH LI DIGIT NINE");
    map.put('\uA90A', "KAYAH LI LETTER KA");
    map.put('\uA90B', "KAYAH LI LETTER KHA");
    map.put('\uA90C', "KAYAH LI LETTER GA");
    map.put('\uA90D', "KAYAH LI LETTER NGA");
    map.put('\uA90E', "KAYAH LI LETTER SA");
    map.put('\uA90F', "KAYAH LI LETTER SHA");
    map.put('\uA910', "KAYAH LI LETTER ZA");
    map.put('\uA911', "KAYAH LI LETTER NYA");
    map.put('\uA912', "KAYAH LI LETTER TA");
    map.put('\uA913', "KAYAH LI LETTER HTA");
    map.put('\uA914', "KAYAH LI LETTER NA");
    map.put('\uA915', "KAYAH LI LETTER PA");
    map.put('\uA916', "KAYAH LI LETTER PHA");
    map.put('\uA917', "KAYAH LI LETTER MA");
    map.put('\uA918', "KAYAH LI LETTER DA");
    map.put('\uA919', "KAYAH LI LETTER BA");
    map.put('\uA91A', "KAYAH LI LETTER RA");
    map.put('\uA91B', "KAYAH LI LETTER YA");
    map.put('\uA91C', "KAYAH LI LETTER LA");
    map.put('\uA91D', "KAYAH LI LETTER WA");
    map.put('\uA91E', "KAYAH LI LETTER THA");
    map.put('\uA91F', "KAYAH LI LETTER HA");
    map.put('\uA920', "KAYAH LI LETTER VA");
    map.put('\uA921', "KAYAH LI LETTER CA");
    map.put('\uA922', "KAYAH LI LETTER A");
    map.put('\uA923', "KAYAH LI LETTER OE");
    map.put('\uA924', "KAYAH LI LETTER I");
    map.put('\uA925', "KAYAH LI LETTER OO");
    map.put('\uA926', "KAYAH LI VOWEL UE");
    map.put('\uA927', "KAYAH LI VOWEL E");
    map.put('\uA928', "KAYAH LI VOWEL U");
    map.put('\uA929', "KAYAH LI VOWEL EE");
    map.put('\uA92A', "KAYAH LI VOWEL O");
    map.put('\uA92B', "KAYAH LI TONE PLOPHU");
    map.put('\uA92C', "KAYAH LI TONE CALYA");
    map.put('\uA92D', "KAYAH LI TONE CALYA PLOPHU");
    map.put('\uA92E', "KAYAH LI SIGN CWI");
    map.put('\uA92F', "KAYAH LI SIGN SHYA");
    map.put('\uA930', "REJANG LETTER KA");
    map.put('\uA931', "REJANG LETTER GA");
    map.put('\uA932', "REJANG LETTER NGA");
    map.put('\uA933', "REJANG LETTER TA");
    map.put('\uA934', "REJANG LETTER DA");
    map.put('\uA935', "REJANG LETTER NA");
    map.put('\uA936', "REJANG LETTER PA");
    map.put('\uA937', "REJANG LETTER BA");
    map.put('\uA938', "REJANG LETTER MA");
    map.put('\uA939', "REJANG LETTER CA");
    map.put('\uA93A', "REJANG LETTER JA");
    map.put('\uA93B', "REJANG LETTER NYA");
    map.put('\uA93C', "REJANG LETTER SA");
    map.put('\uA93D', "REJANG LETTER RA");
    map.put('\uA93E', "REJANG LETTER LA");
    map.put('\uA93F', "REJANG LETTER YA");
    map.put('\uA940', "REJANG LETTER WA");
    map.put('\uA941', "REJANG LETTER HA");
    map.put('\uA942', "REJANG LETTER MBA");
    map.put('\uA943', "REJANG LETTER NGGA");
    map.put('\uA944', "REJANG LETTER NDA");
    map.put('\uA945', "REJANG LETTER NYJA");
    map.put('\uA946', "REJANG LETTER A");
    map.put('\uA947', "REJANG VOWEL SIGN I");
    map.put('\uA948', "REJANG VOWEL SIGN U");
    map.put('\uA949', "REJANG VOWEL SIGN E");
    map.put('\uA94A', "REJANG VOWEL SIGN AI");
    map.put('\uA94B', "REJANG VOWEL SIGN O");
    map.put('\uA94C', "REJANG VOWEL SIGN AU");
    map.put('\uA94D', "REJANG VOWEL SIGN EU");
    map.put('\uA94E', "REJANG VOWEL SIGN EA");
    map.put('\uA94F', "REJANG CONSONANT SIGN NG");
    map.put('\uA950', "REJANG CONSONANT SIGN N");
    map.put('\uA951', "REJANG CONSONANT SIGN R");
    map.put('\uA952', "REJANG CONSONANT SIGN H");
    map.put('\uA953', "REJANG VIRAMA");
    map.put('\uA95F', "REJANG SECTION MARK");
    map.put('\uA960', "HANGUL CHOSEONG TIKEUT-MIEUM");
    map.put('\uA961', "HANGUL CHOSEONG TIKEUT-PIEUP");
    map.put('\uA962', "HANGUL CHOSEONG TIKEUT-SIOS");
    map.put('\uA963', "HANGUL CHOSEONG TIKEUT-CIEUC");
    map.put('\uA964', "HANGUL CHOSEONG RIEUL-KIYEOK");
    map.put('\uA965', "HANGUL CHOSEONG RIEUL-SSANGKIYEOK");
    map.put('\uA966', "HANGUL CHOSEONG RIEUL-TIKEUT");
    map.put('\uA967', "HANGUL CHOSEONG RIEUL-SSANGTIKEUT");
    map.put('\uA968', "HANGUL CHOSEONG RIEUL-MIEUM");
    map.put('\uA969', "HANGUL CHOSEONG RIEUL-PIEUP");
    map.put('\uA96A', "HANGUL CHOSEONG RIEUL-SSANGPIEUP");
    map.put('\uA96B', "HANGUL CHOSEONG RIEUL-KAPYEOUNPIEUP");
    map.put('\uA96C', "HANGUL CHOSEONG RIEUL-SIOS");
    map.put('\uA96D', "HANGUL CHOSEONG RIEUL-CIEUC");
    map.put('\uA96E', "HANGUL CHOSEONG RIEUL-KHIEUKH");
    map.put('\uA96F', "HANGUL CHOSEONG MIEUM-KIYEOK");
    map.put('\uA970', "HANGUL CHOSEONG MIEUM-TIKEUT");
    map.put('\uA971', "HANGUL CHOSEONG MIEUM-SIOS");
    map.put('\uA972', "HANGUL CHOSEONG PIEUP-SIOS-THIEUTH");
    map.put('\uA973', "HANGUL CHOSEONG PIEUP-KHIEUKH");
    map.put('\uA974', "HANGUL CHOSEONG PIEUP-HIEUH");
    map.put('\uA975', "HANGUL CHOSEONG SSANGSIOS-PIEUP");
    map.put('\uA976', "HANGUL CHOSEONG IEUNG-RIEUL");
    map.put('\uA977', "HANGUL CHOSEONG IEUNG-HIEUH");
    map.put('\uA978', "HANGUL CHOSEONG SSANGCIEUC-HIEUH");
    map.put('\uA979', "HANGUL CHOSEONG SSANGTHIEUTH");
    map.put('\uA97A', "HANGUL CHOSEONG PHIEUPH-HIEUH");
    map.put('\uA97B', "HANGUL CHOSEONG HIEUH-SIOS");
    map.put('\uA97C', "HANGUL CHOSEONG SSANGYEORINHIEUH");
    map.put('\uA980', "JAVANESE SIGN PANYANGGA");
    map.put('\uA981', "JAVANESE SIGN CECAK");
    map.put('\uA982', "JAVANESE SIGN LAYAR");
    map.put('\uA983', "JAVANESE SIGN WIGNYAN");
    map.put('\uA984', "JAVANESE LETTER A");
    map.put('\uA985', "JAVANESE LETTER I KAWI");
    map.put('\uA986', "JAVANESE LETTER I");
    map.put('\uA987', "JAVANESE LETTER II");
    map.put('\uA988', "JAVANESE LETTER U");
    map.put('\uA989', "JAVANESE LETTER PA CEREK");
    map.put('\uA98A', "JAVANESE LETTER NGA LELET");
    map.put('\uA98B', "JAVANESE LETTER NGA LELET RASWADI");
    map.put('\uA98C', "JAVANESE LETTER E");
    map.put('\uA98D', "JAVANESE LETTER AI");
    map.put('\uA98E', "JAVANESE LETTER O");
    map.put('\uA98F', "JAVANESE LETTER KA");
    map.put('\uA990', "JAVANESE LETTER KA SASAK");
    map.put('\uA991', "JAVANESE LETTER KA MURDA");
    map.put('\uA992', "JAVANESE LETTER GA");
    map.put('\uA993', "JAVANESE LETTER GA MURDA");
    map.put('\uA994', "JAVANESE LETTER NGA");
    map.put('\uA995', "JAVANESE LETTER CA");
    map.put('\uA996', "JAVANESE LETTER CA MURDA");
    map.put('\uA997', "JAVANESE LETTER JA");
    map.put('\uA998', "JAVANESE LETTER NYA MURDA");
    map.put('\uA999', "JAVANESE LETTER JA MAHAPRANA");
    map.put('\uA99A', "JAVANESE LETTER NYA");
    map.put('\uA99B', "JAVANESE LETTER TTA");
    map.put('\uA99C', "JAVANESE LETTER TTA MAHAPRANA");
    map.put('\uA99D', "JAVANESE LETTER DDA");
    map.put('\uA99E', "JAVANESE LETTER DDA MAHAPRANA");
    map.put('\uA99F', "JAVANESE LETTER NA MURDA");
    map.put('\uA9A0', "JAVANESE LETTER TA");
    map.put('\uA9A1', "JAVANESE LETTER TA MURDA");
    map.put('\uA9A2', "JAVANESE LETTER DA");
    map.put('\uA9A3', "JAVANESE LETTER DA MAHAPRANA");
    map.put('\uA9A4', "JAVANESE LETTER NA");
    map.put('\uA9A5', "JAVANESE LETTER PA");
    map.put('\uA9A6', "JAVANESE LETTER PA MURDA");
    map.put('\uA9A7', "JAVANESE LETTER BA");
    map.put('\uA9A8', "JAVANESE LETTER BA MURDA");
    map.put('\uA9A9', "JAVANESE LETTER MA");
    map.put('\uA9AA', "JAVANESE LETTER YA");
    map.put('\uA9AB', "JAVANESE LETTER RA");
    map.put('\uA9AC', "JAVANESE LETTER RA AGUNG");
    map.put('\uA9AD', "JAVANESE LETTER LA");
    map.put('\uA9AE', "JAVANESE LETTER WA");
    map.put('\uA9AF', "JAVANESE LETTER SA MURDA");
    map.put('\uA9B0', "JAVANESE LETTER SA MAHAPRANA");
    map.put('\uA9B1', "JAVANESE LETTER SA");
    map.put('\uA9B2', "JAVANESE LETTER HA");
    map.put('\uA9B3', "JAVANESE SIGN CECAK TELU");
    map.put('\uA9B4', "JAVANESE VOWEL SIGN TARUNG");
    map.put('\uA9B5', "JAVANESE VOWEL SIGN TOLONG");
    map.put('\uA9B6', "JAVANESE VOWEL SIGN WULU");
    map.put('\uA9B7', "JAVANESE VOWEL SIGN WULU MELIK");
    map.put('\uA9B8', "JAVANESE VOWEL SIGN SUKU");
    map.put('\uA9B9', "JAVANESE VOWEL SIGN SUKU MENDUT");
    map.put('\uA9BA', "JAVANESE VOWEL SIGN TALING");
    map.put('\uA9BB', "JAVANESE VOWEL SIGN DIRGA MURE");
    map.put('\uA9BC', "JAVANESE VOWEL SIGN PEPET");
    map.put('\uA9BD', "JAVANESE CONSONANT SIGN KERET");
    map.put('\uA9BE', "JAVANESE CONSONANT SIGN PENGKAL");
    map.put('\uA9BF', "JAVANESE CONSONANT SIGN CAKRA");
    map.put('\uA9C0', "JAVANESE PANGKON");
    map.put('\uA9C1', "JAVANESE LEFT RERENGGAN");
    map.put('\uA9C2', "JAVANESE RIGHT RERENGGAN");
    map.put('\uA9C3', "JAVANESE PADA ANDAP");
    map.put('\uA9C4', "JAVANESE PADA MADYA");
    map.put('\uA9C5', "JAVANESE PADA LUHUR");
    map.put('\uA9C6', "JAVANESE PADA WINDU");
    map.put('\uA9C7', "JAVANESE PADA PANGKAT");
    map.put('\uA9C8', "JAVANESE PADA LINGSA");
    map.put('\uA9C9', "JAVANESE PADA LUNGSI");
    map.put('\uA9CA', "JAVANESE PADA ADEG");
    map.put('\uA9CB', "JAVANESE PADA ADEG ADEG");
    map.put('\uA9CC', "JAVANESE PADA PISELEH");
    map.put('\uA9CD', "JAVANESE TURNED PADA PISELEH");
    map.put('\uA9CF', "JAVANESE PANGRANGKEP");
    map.put('\uA9D0', "JAVANESE DIGIT ZERO");
    map.put('\uA9D1', "JAVANESE DIGIT ONE");
    map.put('\uA9D2', "JAVANESE DIGIT TWO");
    map.put('\uA9D3', "JAVANESE DIGIT THREE");
    map.put('\uA9D4', "JAVANESE DIGIT FOUR");
    map.put('\uA9D5', "JAVANESE DIGIT FIVE");
    map.put('\uA9D6', "JAVANESE DIGIT SIX");
    map.put('\uA9D7', "JAVANESE DIGIT SEVEN");
    map.put('\uA9D8', "JAVANESE DIGIT EIGHT");
    map.put('\uA9D9', "JAVANESE DIGIT NINE");
    map.put('\uA9DE', "JAVANESE PADA TIRTA TUMETES");
    map.put('\uA9DF', "JAVANESE PADA ISEN-ISEN");
    map.put('\uAA00', "CHAM LETTER A");
    map.put('\uAA01', "CHAM LETTER I");
    map.put('\uAA02', "CHAM LETTER U");
    map.put('\uAA03', "CHAM LETTER E");
    map.put('\uAA04', "CHAM LETTER AI");
    map.put('\uAA05', "CHAM LETTER O");
    map.put('\uAA06', "CHAM LETTER KA");
    map.put('\uAA07', "CHAM LETTER KHA");
    map.put('\uAA08', "CHAM LETTER GA");
    map.put('\uAA09', "CHAM LETTER GHA");
    map.put('\uAA0A', "CHAM LETTER NGUE");
    map.put('\uAA0B', "CHAM LETTER NGA");
    map.put('\uAA0C', "CHAM LETTER CHA");
    map.put('\uAA0D', "CHAM LETTER CHHA");
    map.put('\uAA0E', "CHAM LETTER JA");
    map.put('\uAA0F', "CHAM LETTER JHA");
    map.put('\uAA10', "CHAM LETTER NHUE");
    map.put('\uAA11', "CHAM LETTER NHA");
    map.put('\uAA12', "CHAM LETTER NHJA");
    map.put('\uAA13', "CHAM LETTER TA");
    map.put('\uAA14', "CHAM LETTER THA");
    map.put('\uAA15', "CHAM LETTER DA");
    map.put('\uAA16', "CHAM LETTER DHA");
    map.put('\uAA17', "CHAM LETTER NUE");
    map.put('\uAA18', "CHAM LETTER NA");
    map.put('\uAA19', "CHAM LETTER DDA");
    map.put('\uAA1A', "CHAM LETTER PA");
    map.put('\uAA1B', "CHAM LETTER PPA");
    map.put('\uAA1C', "CHAM LETTER PHA");
    map.put('\uAA1D', "CHAM LETTER BA");
    map.put('\uAA1E', "CHAM LETTER BHA");
    map.put('\uAA1F', "CHAM LETTER MUE");
    map.put('\uAA20', "CHAM LETTER MA");
    map.put('\uAA21', "CHAM LETTER BBA");
    map.put('\uAA22', "CHAM LETTER YA");
    map.put('\uAA23', "CHAM LETTER RA");
    map.put('\uAA24', "CHAM LETTER LA");
    map.put('\uAA25', "CHAM LETTER VA");
    map.put('\uAA26', "CHAM LETTER SSA");
    map.put('\uAA27', "CHAM LETTER SA");
    map.put('\uAA28', "CHAM LETTER HA");
    map.put('\uAA29', "CHAM VOWEL SIGN AA");
    map.put('\uAA2A', "CHAM VOWEL SIGN I");
    map.put('\uAA2B', "CHAM VOWEL SIGN II");
    map.put('\uAA2C', "CHAM VOWEL SIGN EI");
    map.put('\uAA2D', "CHAM VOWEL SIGN U");
    map.put('\uAA2E', "CHAM VOWEL SIGN OE");
    map.put('\uAA2F', "CHAM VOWEL SIGN O");
    map.put('\uAA30', "CHAM VOWEL SIGN AI");
    map.put('\uAA31', "CHAM VOWEL SIGN AU");
    map.put('\uAA32', "CHAM VOWEL SIGN UE");
    map.put('\uAA33', "CHAM CONSONANT SIGN YA");
    map.put('\uAA34', "CHAM CONSONANT SIGN RA");
    map.put('\uAA35', "CHAM CONSONANT SIGN LA");
    map.put('\uAA36', "CHAM CONSONANT SIGN WA");
    map.put('\uAA40', "CHAM LETTER FINAL K");
    map.put('\uAA41', "CHAM LETTER FINAL G");
    map.put('\uAA42', "CHAM LETTER FINAL NG");
    map.put('\uAA43', "CHAM CONSONANT SIGN FINAL NG");
    map.put('\uAA44', "CHAM LETTER FINAL CH");
    map.put('\uAA45', "CHAM LETTER FINAL T");
    map.put('\uAA46', "CHAM LETTER FINAL N");
    map.put('\uAA47', "CHAM LETTER FINAL P");
    map.put('\uAA48', "CHAM LETTER FINAL Y");
    map.put('\uAA49', "CHAM LETTER FINAL R");
    map.put('\uAA4A', "CHAM LETTER FINAL L");
    map.put('\uAA4B', "CHAM LETTER FINAL SS");
    map.put('\uAA4C', "CHAM CONSONANT SIGN FINAL M");
    map.put('\uAA4D', "CHAM CONSONANT SIGN FINAL H");
    map.put('\uAA50', "CHAM DIGIT ZERO");
    map.put('\uAA51', "CHAM DIGIT ONE");
    map.put('\uAA52', "CHAM DIGIT TWO");
    map.put('\uAA53', "CHAM DIGIT THREE");
    map.put('\uAA54', "CHAM DIGIT FOUR");
    map.put('\uAA55', "CHAM DIGIT FIVE");
    map.put('\uAA56', "CHAM DIGIT SIX");
    map.put('\uAA57', "CHAM DIGIT SEVEN");
    map.put('\uAA58', "CHAM DIGIT EIGHT");
    map.put('\uAA59', "CHAM DIGIT NINE");
    map.put('\uAA5C', "CHAM PUNCTUATION SPIRAL");
    map.put('\uAA5D', "CHAM PUNCTUATION DANDA");
    map.put('\uAA5E', "CHAM PUNCTUATION DOUBLE DANDA");
    map.put('\uAA5F', "CHAM PUNCTUATION TRIPLE DANDA");
    map.put('\uAA60', "MYANMAR LETTER KHAMTI GA");
    map.put('\uAA61', "MYANMAR LETTER KHAMTI CA");
    map.put('\uAA62', "MYANMAR LETTER KHAMTI CHA");
    map.put('\uAA63', "MYANMAR LETTER KHAMTI JA");
    map.put('\uAA64', "MYANMAR LETTER KHAMTI JHA");
    map.put('\uAA65', "MYANMAR LETTER KHAMTI NYA");
    map.put('\uAA66', "MYANMAR LETTER KHAMTI TTA");
    map.put('\uAA67', "MYANMAR LETTER KHAMTI TTHA");
    map.put('\uAA68', "MYANMAR LETTER KHAMTI DDA");
    map.put('\uAA69', "MYANMAR LETTER KHAMTI DDHA");
    map.put('\uAA6A', "MYANMAR LETTER KHAMTI DHA");
    map.put('\uAA6B', "MYANMAR LETTER KHAMTI NA");
    map.put('\uAA6C', "MYANMAR LETTER KHAMTI SA");
    map.put('\uAA6D', "MYANMAR LETTER KHAMTI HA");
    map.put('\uAA6E', "MYANMAR LETTER KHAMTI HHA");
    map.put('\uAA6F', "MYANMAR LETTER KHAMTI FA");
    map.put('\uAA70', "MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION");
    map.put('\uAA71', "MYANMAR LETTER KHAMTI XA");
    map.put('\uAA72', "MYANMAR LETTER KHAMTI ZA");
    map.put('\uAA73', "MYANMAR LETTER KHAMTI RA");
    map.put('\uAA74', "MYANMAR LOGOGRAM KHAMTI OAY");
    map.put('\uAA75', "MYANMAR LOGOGRAM KHAMTI QN");
    map.put('\uAA76', "MYANMAR LOGOGRAM KHAMTI HM");
    map.put('\uAA77', "MYANMAR SYMBOL AITON EXCLAMATION");
    map.put('\uAA78', "MYANMAR SYMBOL AITON ONE");
    map.put('\uAA79', "MYANMAR SYMBOL AITON TWO");
    map.put('\uAA7A', "MYANMAR LETTER AITON RA");
    map.put('\uAA7B', "MYANMAR SIGN PAO KAREN TONE");
    map.put('\uAA80', "TAI VIET LETTER LOW KO");
    map.put('\uAA81', "TAI VIET LETTER HIGH KO");
    map.put('\uAA82', "TAI VIET LETTER LOW KHO");
    map.put('\uAA83', "TAI VIET LETTER HIGH KHO");
    map.put('\uAA84', "TAI VIET LETTER LOW KHHO");
    map.put('\uAA85', "TAI VIET LETTER HIGH KHHO");
    map.put('\uAA86', "TAI VIET LETTER LOW GO");
    map.put('\uAA87', "TAI VIET LETTER HIGH GO");
    map.put('\uAA88', "TAI VIET LETTER LOW NGO");
    map.put('\uAA89', "TAI VIET LETTER HIGH NGO");
    map.put('\uAA8A', "TAI VIET LETTER LOW CO");
    map.put('\uAA8B', "TAI VIET LETTER HIGH CO");
    map.put('\uAA8C', "TAI VIET LETTER LOW CHO");
    map.put('\uAA8D', "TAI VIET LETTER HIGH CHO");
    map.put('\uAA8E', "TAI VIET LETTER LOW SO");
    map.put('\uAA8F', "TAI VIET LETTER HIGH SO");
    map.put('\uAA90', "TAI VIET LETTER LOW NYO");
    map.put('\uAA91', "TAI VIET LETTER HIGH NYO");
    map.put('\uAA92', "TAI VIET LETTER LOW DO");
    map.put('\uAA93', "TAI VIET LETTER HIGH DO");
    map.put('\uAA94', "TAI VIET LETTER LOW TO");
    map.put('\uAA95', "TAI VIET LETTER HIGH TO");
    map.put('\uAA96', "TAI VIET LETTER LOW THO");
    map.put('\uAA97', "TAI VIET LETTER HIGH THO");
    map.put('\uAA98', "TAI VIET LETTER LOW NO");
    map.put('\uAA99', "TAI VIET LETTER HIGH NO");
    map.put('\uAA9A', "TAI VIET LETTER LOW BO");
    map.put('\uAA9B', "TAI VIET LETTER HIGH BO");
    map.put('\uAA9C', "TAI VIET LETTER LOW PO");
    map.put('\uAA9D', "TAI VIET LETTER HIGH PO");
    map.put('\uAA9E', "TAI VIET LETTER LOW PHO");
    map.put('\uAA9F', "TAI VIET LETTER HIGH PHO");
    map.put('\uAAA0', "TAI VIET LETTER LOW FO");
    map.put('\uAAA1', "TAI VIET LETTER HIGH FO");
    map.put('\uAAA2', "TAI VIET LETTER LOW MO");
    map.put('\uAAA3', "TAI VIET LETTER HIGH MO");
    map.put('\uAAA4', "TAI VIET LETTER LOW YO");
    map.put('\uAAA5', "TAI VIET LETTER HIGH YO");
    map.put('\uAAA6', "TAI VIET LETTER LOW RO");
    map.put('\uAAA7', "TAI VIET LETTER HIGH RO");
    map.put('\uAAA8', "TAI VIET LETTER LOW LO");
    map.put('\uAAA9', "TAI VIET LETTER HIGH LO");
    map.put('\uAAAA', "TAI VIET LETTER LOW VO");
    map.put('\uAAAB', "TAI VIET LETTER HIGH VO");
    map.put('\uAAAC', "TAI VIET LETTER LOW HO");
    map.put('\uAAAD', "TAI VIET LETTER HIGH HO");
    map.put('\uAAAE', "TAI VIET LETTER LOW O");
    map.put('\uAAAF', "TAI VIET LETTER HIGH O");
    map.put('\uAAB0', "TAI VIET MAI KANG");
    map.put('\uAAB1', "TAI VIET VOWEL AA");
    map.put('\uAAB2', "TAI VIET VOWEL I");
    map.put('\uAAB3', "TAI VIET VOWEL UE");
    map.put('\uAAB4', "TAI VIET VOWEL U");
    map.put('\uAAB5', "TAI VIET VOWEL E");
    map.put('\uAAB6', "TAI VIET VOWEL O");
    map.put('\uAAB7', "TAI VIET MAI KHIT");
    map.put('\uAAB8', "TAI VIET VOWEL IA");
    map.put('\uAAB9', "TAI VIET VOWEL UEA");
    map.put('\uAABA', "TAI VIET VOWEL UA");
    map.put('\uAABB', "TAI VIET VOWEL AUE");
    map.put('\uAABC', "TAI VIET VOWEL AY");
    map.put('\uAABD', "TAI VIET VOWEL AN");
    map.put('\uAABE', "TAI VIET VOWEL AM");
    map.put('\uAABF', "TAI VIET TONE MAI EK");
    map.put('\uAAC0', "TAI VIET TONE MAI NUENG");
    map.put('\uAAC1', "TAI VIET TONE MAI THO");
    map.put('\uAAC2', "TAI VIET TONE MAI SONG");
    map.put('\uAADB', "TAI VIET SYMBOL KON");
    map.put('\uAADC', "TAI VIET SYMBOL NUENG");
    map.put('\uAADD', "TAI VIET SYMBOL SAM");
    map.put('\uAADE', "TAI VIET SYMBOL HO HOI");
    map.put('\uAADF', "TAI VIET SYMBOL KOI KOI");
    map.put('\uABC0', "MEETEI MAYEK LETTER KOK");
    map.put('\uABC1', "MEETEI MAYEK LETTER SAM");
    map.put('\uABC2', "MEETEI MAYEK LETTER LAI");
    map.put('\uABC3', "MEETEI MAYEK LETTER MIT");
    map.put('\uABC4', "MEETEI MAYEK LETTER PA");
    map.put('\uABC5', "MEETEI MAYEK LETTER NA");
    map.put('\uABC6', "MEETEI MAYEK LETTER CHIL");
    map.put('\uABC7', "MEETEI MAYEK LETTER TIL");
    map.put('\uABC8', "MEETEI MAYEK LETTER KHOU");
    map.put('\uABC9', "MEETEI MAYEK LETTER NGOU");
    map.put('\uABCA', "MEETEI MAYEK LETTER THOU");
    map.put('\uABCB', "MEETEI MAYEK LETTER WAI");
    map.put('\uABCC', "MEETEI MAYEK LETTER YANG");
    map.put('\uABCD', "MEETEI MAYEK LETTER HUK");
    map.put('\uABCE', "MEETEI MAYEK LETTER UN");
    map.put('\uABCF', "MEETEI MAYEK LETTER I");
    map.put('\uABD0', "MEETEI MAYEK LETTER PHAM");
    map.put('\uABD1', "MEETEI MAYEK LETTER ATIYA");
    map.put('\uABD2', "MEETEI MAYEK LETTER GOK");
    map.put('\uABD3', "MEETEI MAYEK LETTER JHAM");
    map.put('\uABD4', "MEETEI MAYEK LETTER RAI");
    map.put('\uABD5', "MEETEI MAYEK LETTER BA");
    map.put('\uABD6', "MEETEI MAYEK LETTER JIL");
    map.put('\uABD7', "MEETEI MAYEK LETTER DIL");
    map.put('\uABD8', "MEETEI MAYEK LETTER GHOU");
    map.put('\uABD9', "MEETEI MAYEK LETTER DHOU");
    map.put('\uABDA', "MEETEI MAYEK LETTER BHAM");
    map.put('\uABDB', "MEETEI MAYEK LETTER KOK LONSUM");
    map.put('\uABDC', "MEETEI MAYEK LETTER LAI LONSUM");
    map.put('\uABDD', "MEETEI MAYEK LETTER MIT LONSUM");
    map.put('\uABDE', "MEETEI MAYEK LETTER PA LONSUM");
    map.put('\uABDF', "MEETEI MAYEK LETTER NA LONSUM");
    map.put('\uABE0', "MEETEI MAYEK LETTER TIL LONSUM");
    map.put('\uABE1', "MEETEI MAYEK LETTER NGOU LONSUM");
    map.put('\uABE2', "MEETEI MAYEK LETTER I LONSUM");
    map.put('\uABE3', "MEETEI MAYEK VOWEL SIGN ONAP");
    map.put('\uABE4', "MEETEI MAYEK VOWEL SIGN INAP");
    map.put('\uABE5', "MEETEI MAYEK VOWEL SIGN ANAP");
    map.put('\uABE6', "MEETEI MAYEK VOWEL SIGN YENAP");
    map.put('\uABE7', "MEETEI MAYEK VOWEL SIGN SOUNAP");
    map.put('\uABE8', "MEETEI MAYEK VOWEL SIGN UNAP");
    map.put('\uABE9', "MEETEI MAYEK VOWEL SIGN CHEINAP");
    map.put('\uABEA', "MEETEI MAYEK VOWEL SIGN NUNG");
    map.put('\uABEB', "MEETEI MAYEK CHEIKHEI");
    map.put('\uABEC', "MEETEI MAYEK LUM IYEK");
    map.put('\uABED', "MEETEI MAYEK APUN IYEK");
    map.put('\uABF0', "MEETEI MAYEK DIGIT ZERO");
    map.put('\uABF1', "MEETEI MAYEK DIGIT ONE");
    map.put('\uABF2', "MEETEI MAYEK DIGIT TWO");
    map.put('\uABF3', "MEETEI MAYEK DIGIT THREE");
    map.put('\uABF4', "MEETEI MAYEK DIGIT FOUR");
    map.put('\uABF5', "MEETEI MAYEK DIGIT FIVE");
    map.put('\uABF6', "MEETEI MAYEK DIGIT SIX");
    map.put('\uABF7', "MEETEI MAYEK DIGIT SEVEN");
    map.put('\uABF8', "MEETEI MAYEK DIGIT EIGHT");
    map.put('\uABF9', "MEETEI MAYEK DIGIT NINE");

  }

  public static final void hangulSyllables(Map<Character, String> map) {

    map.put('\uD7B0', "HANGUL JUNGSEONG O-YEO");
    map.put('\uD7B1', "HANGUL JUNGSEONG O-O-I");
    map.put('\uD7B2', "HANGUL JUNGSEONG YO-A");
    map.put('\uD7B3', "HANGUL JUNGSEONG YO-AE");
    map.put('\uD7B4', "HANGUL JUNGSEONG YO-EO");
    map.put('\uD7B5', "HANGUL JUNGSEONG U-YEO");
    map.put('\uD7B6', "HANGUL JUNGSEONG U-I-I");
    map.put('\uD7B7', "HANGUL JUNGSEONG YU-AE");
    map.put('\uD7B8', "HANGUL JUNGSEONG YU-O");
    map.put('\uD7B9', "HANGUL JUNGSEONG EU-A");
    map.put('\uD7BA', "HANGUL JUNGSEONG EU-EO");
    map.put('\uD7BB', "HANGUL JUNGSEONG EU-E");
    map.put('\uD7BC', "HANGUL JUNGSEONG EU-O");
    map.put('\uD7BD', "HANGUL JUNGSEONG I-YA-O");
    map.put('\uD7BE', "HANGUL JUNGSEONG I-YAE");
    map.put('\uD7BF', "HANGUL JUNGSEONG I-YEO");
    map.put('\uD7C0', "HANGUL JUNGSEONG I-YE");
    map.put('\uD7C1', "HANGUL JUNGSEONG I-O-I");
    map.put('\uD7C2', "HANGUL JUNGSEONG I-YO");
    map.put('\uD7C3', "HANGUL JUNGSEONG I-YU");
    map.put('\uD7C4', "HANGUL JUNGSEONG I-I");
    map.put('\uD7C5', "HANGUL JUNGSEONG ARAEA-A");
    map.put('\uD7C6', "HANGUL JUNGSEONG ARAEA-E");
    map.put('\uD7CB', "HANGUL JONGSEONG NIEUN-RIEUL");
    map.put('\uD7CC', "HANGUL JONGSEONG NIEUN-CHIEUCH");
    map.put('\uD7CD', "HANGUL JONGSEONG SSANGTIKEUT");
    map.put('\uD7CE', "HANGUL JONGSEONG SSANGTIKEUT-PIEUP");
    map.put('\uD7CF', "HANGUL JONGSEONG TIKEUT-PIEUP");
    map.put('\uD7D0', "HANGUL JONGSEONG TIKEUT-SIOS");
    map.put('\uD7D1', "HANGUL JONGSEONG TIKEUT-SIOS-KIYEOK");
    map.put('\uD7D2', "HANGUL JONGSEONG TIKEUT-CIEUC");
    map.put('\uD7D3', "HANGUL JONGSEONG TIKEUT-CHIEUCH");
    map.put('\uD7D4', "HANGUL JONGSEONG TIKEUT-THIEUTH");
    map.put('\uD7D5', "HANGUL JONGSEONG RIEUL-SSANGKIYEOK");
    map.put('\uD7D6', "HANGUL JONGSEONG RIEUL-KIYEOK-HIEUH");
    map.put('\uD7D7', "HANGUL JONGSEONG SSANGRIEUL-KHIEUKH");
    map.put('\uD7D8', "HANGUL JONGSEONG RIEUL-MIEUM-HIEUH");
    map.put('\uD7D9', "HANGUL JONGSEONG RIEUL-PIEUP-TIKEUT");
    map.put('\uD7DA', "HANGUL JONGSEONG RIEUL-PIEUP-PHIEUPH");
    map.put('\uD7DB', "HANGUL JONGSEONG RIEUL-YESIEUNG");
    map.put('\uD7DC', "HANGUL JONGSEONG RIEUL-YEORINHIEUH-HIEUH");
    map.put('\uD7DD', "HANGUL JONGSEONG KAPYEOUNRIEUL");
    map.put('\uD7DE', "HANGUL JONGSEONG MIEUM-NIEUN");
    map.put('\uD7DF', "HANGUL JONGSEONG MIEUM-SSANGNIEUN");
    map.put('\uD7E0', "HANGUL JONGSEONG SSANGMIEUM");
    map.put('\uD7E1', "HANGUL JONGSEONG MIEUM-PIEUP-SIOS");
    map.put('\uD7E2', "HANGUL JONGSEONG MIEUM-CIEUC");
    map.put('\uD7E3', "HANGUL JONGSEONG PIEUP-TIKEUT");
    map.put('\uD7E4', "HANGUL JONGSEONG PIEUP-RIEUL-PHIEUPH");
    map.put('\uD7E5', "HANGUL JONGSEONG PIEUP-MIEUM");
    map.put('\uD7E6', "HANGUL JONGSEONG SSANGPIEUP");
    map.put('\uD7E7', "HANGUL JONGSEONG PIEUP-SIOS-TIKEUT");
    map.put('\uD7E8', "HANGUL JONGSEONG PIEUP-CIEUC");
    map.put('\uD7E9', "HANGUL JONGSEONG PIEUP-CHIEUCH");
    map.put('\uD7EA', "HANGUL JONGSEONG SIOS-MIEUM");
    map.put('\uD7EB', "HANGUL JONGSEONG SIOS-KAPYEOUNPIEUP");
    map.put('\uD7EC', "HANGUL JONGSEONG SSANGSIOS-KIYEOK");
    map.put('\uD7ED', "HANGUL JONGSEONG SSANGSIOS-TIKEUT");
    map.put('\uD7EE', "HANGUL JONGSEONG SIOS-PANSIOS");
    map.put('\uD7EF', "HANGUL JONGSEONG SIOS-CIEUC");
    map.put('\uD7F0', "HANGUL JONGSEONG SIOS-CHIEUCH");
    map.put('\uD7F1', "HANGUL JONGSEONG SIOS-THIEUTH");
    map.put('\uD7F2', "HANGUL JONGSEONG SIOS-HIEUH");
    map.put('\uD7F3', "HANGUL JONGSEONG PANSIOS-PIEUP");
    map.put('\uD7F4', "HANGUL JONGSEONG PANSIOS-KAPYEOUNPIEUP");
    map.put('\uD7F5', "HANGUL JONGSEONG YESIEUNG-MIEUM");
    map.put('\uD7F6', "HANGUL JONGSEONG YESIEUNG-HIEUH");
    map.put('\uD7F7', "HANGUL JONGSEONG CIEUC-PIEUP");
    map.put('\uD7F8', "HANGUL JONGSEONG CIEUC-SSANGPIEUP");
    map.put('\uD7F9', "HANGUL JONGSEONG SSANGCIEUC");
    map.put('\uD7FA', "HANGUL JONGSEONG PHIEUPH-SIOS");
    map.put('\uD7FB', "HANGUL JONGSEONG PHIEUPH-THIEUTH");
    map.put('\uF900', "CJK COMPATIBILITY IDEOGRAPH-F900");
    map.put('\uF901', "CJK COMPATIBILITY IDEOGRAPH-F901");
    map.put('\uF902', "CJK COMPATIBILITY IDEOGRAPH-F902");
    map.put('\uF903', "CJK COMPATIBILITY IDEOGRAPH-F903");
    map.put('\uF904', "CJK COMPATIBILITY IDEOGRAPH-F904");
    map.put('\uF905', "CJK COMPATIBILITY IDEOGRAPH-F905");
    map.put('\uF906', "CJK COMPATIBILITY IDEOGRAPH-F906");
    map.put('\uF907', "CJK COMPATIBILITY IDEOGRAPH-F907");
    map.put('\uF908', "CJK COMPATIBILITY IDEOGRAPH-F908");
    map.put('\uF909', "CJK COMPATIBILITY IDEOGRAPH-F909");
    map.put('\uF90A', "CJK COMPATIBILITY IDEOGRAPH-F90A");
    map.put('\uF90B', "CJK COMPATIBILITY IDEOGRAPH-F90B");
    map.put('\uF90C', "CJK COMPATIBILITY IDEOGRAPH-F90C");
    map.put('\uF90D', "CJK COMPATIBILITY IDEOGRAPH-F90D");
    map.put('\uF90E', "CJK COMPATIBILITY IDEOGRAPH-F90E");
    map.put('\uF90F', "CJK COMPATIBILITY IDEOGRAPH-F90F");
    map.put('\uF910', "CJK COMPATIBILITY IDEOGRAPH-F910");
    map.put('\uF911', "CJK COMPATIBILITY IDEOGRAPH-F911");
    map.put('\uF912', "CJK COMPATIBILITY IDEOGRAPH-F912");
    map.put('\uF913', "CJK COMPATIBILITY IDEOGRAPH-F913");
    map.put('\uF914', "CJK COMPATIBILITY IDEOGRAPH-F914");
    map.put('\uF915', "CJK COMPATIBILITY IDEOGRAPH-F915");
    map.put('\uF916', "CJK COMPATIBILITY IDEOGRAPH-F916");
    map.put('\uF917', "CJK COMPATIBILITY IDEOGRAPH-F917");
    map.put('\uF918', "CJK COMPATIBILITY IDEOGRAPH-F918");
    map.put('\uF919', "CJK COMPATIBILITY IDEOGRAPH-F919");
    map.put('\uF91A', "CJK COMPATIBILITY IDEOGRAPH-F91A");
    map.put('\uF91B', "CJK COMPATIBILITY IDEOGRAPH-F91B");
    map.put('\uF91C', "CJK COMPATIBILITY IDEOGRAPH-F91C");
    map.put('\uF91D', "CJK COMPATIBILITY IDEOGRAPH-F91D");
    map.put('\uF91E', "CJK COMPATIBILITY IDEOGRAPH-F91E");
    map.put('\uF91F', "CJK COMPATIBILITY IDEOGRAPH-F91F");
    map.put('\uF920', "CJK COMPATIBILITY IDEOGRAPH-F920");
    map.put('\uF921', "CJK COMPATIBILITY IDEOGRAPH-F921");
    map.put('\uF922', "CJK COMPATIBILITY IDEOGRAPH-F922");
    map.put('\uF923', "CJK COMPATIBILITY IDEOGRAPH-F923");
    map.put('\uF924', "CJK COMPATIBILITY IDEOGRAPH-F924");
    map.put('\uF925', "CJK COMPATIBILITY IDEOGRAPH-F925");
    map.put('\uF926', "CJK COMPATIBILITY IDEOGRAPH-F926");
    map.put('\uF927', "CJK COMPATIBILITY IDEOGRAPH-F927");
    map.put('\uF928', "CJK COMPATIBILITY IDEOGRAPH-F928");
    map.put('\uF929', "CJK COMPATIBILITY IDEOGRAPH-F929");
    map.put('\uF92A', "CJK COMPATIBILITY IDEOGRAPH-F92A");
    map.put('\uF92B', "CJK COMPATIBILITY IDEOGRAPH-F92B");
    map.put('\uF92C', "CJK COMPATIBILITY IDEOGRAPH-F92C");
    map.put('\uF92D', "CJK COMPATIBILITY IDEOGRAPH-F92D");
    map.put('\uF92E', "CJK COMPATIBILITY IDEOGRAPH-F92E");
    map.put('\uF92F', "CJK COMPATIBILITY IDEOGRAPH-F92F");
    map.put('\uF930', "CJK COMPATIBILITY IDEOGRAPH-F930");
    map.put('\uF931', "CJK COMPATIBILITY IDEOGRAPH-F931");
    map.put('\uF932', "CJK COMPATIBILITY IDEOGRAPH-F932");
    map.put('\uF933', "CJK COMPATIBILITY IDEOGRAPH-F933");
    map.put('\uF934', "CJK COMPATIBILITY IDEOGRAPH-F934");
    map.put('\uF935', "CJK COMPATIBILITY IDEOGRAPH-F935");
    map.put('\uF936', "CJK COMPATIBILITY IDEOGRAPH-F936");
    map.put('\uF937', "CJK COMPATIBILITY IDEOGRAPH-F937");
    map.put('\uF938', "CJK COMPATIBILITY IDEOGRAPH-F938");
    map.put('\uF939', "CJK COMPATIBILITY IDEOGRAPH-F939");
    map.put('\uF93A', "CJK COMPATIBILITY IDEOGRAPH-F93A");
    map.put('\uF93B', "CJK COMPATIBILITY IDEOGRAPH-F93B");
    map.put('\uF93C', "CJK COMPATIBILITY IDEOGRAPH-F93C");
    map.put('\uF93D', "CJK COMPATIBILITY IDEOGRAPH-F93D");
    map.put('\uF93E', "CJK COMPATIBILITY IDEOGRAPH-F93E");
    map.put('\uF93F', "CJK COMPATIBILITY IDEOGRAPH-F93F");
    map.put('\uF940', "CJK COMPATIBILITY IDEOGRAPH-F940");
    map.put('\uF941', "CJK COMPATIBILITY IDEOGRAPH-F941");
    map.put('\uF942', "CJK COMPATIBILITY IDEOGRAPH-F942");
    map.put('\uF943', "CJK COMPATIBILITY IDEOGRAPH-F943");
    map.put('\uF944', "CJK COMPATIBILITY IDEOGRAPH-F944");
    map.put('\uF945', "CJK COMPATIBILITY IDEOGRAPH-F945");
    map.put('\uF946', "CJK COMPATIBILITY IDEOGRAPH-F946");
    map.put('\uF947', "CJK COMPATIBILITY IDEOGRAPH-F947");
    map.put('\uF948', "CJK COMPATIBILITY IDEOGRAPH-F948");
    map.put('\uF949', "CJK COMPATIBILITY IDEOGRAPH-F949");
    map.put('\uF94A', "CJK COMPATIBILITY IDEOGRAPH-F94A");
    map.put('\uF94B', "CJK COMPATIBILITY IDEOGRAPH-F94B");
    map.put('\uF94C', "CJK COMPATIBILITY IDEOGRAPH-F94C");
    map.put('\uF94D', "CJK COMPATIBILITY IDEOGRAPH-F94D");
    map.put('\uF94E', "CJK COMPATIBILITY IDEOGRAPH-F94E");
    map.put('\uF94F', "CJK COMPATIBILITY IDEOGRAPH-F94F");
    map.put('\uF950', "CJK COMPATIBILITY IDEOGRAPH-F950");
    map.put('\uF951', "CJK COMPATIBILITY IDEOGRAPH-F951");
    map.put('\uF952', "CJK COMPATIBILITY IDEOGRAPH-F952");
    map.put('\uF953', "CJK COMPATIBILITY IDEOGRAPH-F953");
    map.put('\uF954', "CJK COMPATIBILITY IDEOGRAPH-F954");
    map.put('\uF955', "CJK COMPATIBILITY IDEOGRAPH-F955");
    map.put('\uF956', "CJK COMPATIBILITY IDEOGRAPH-F956");
    map.put('\uF957', "CJK COMPATIBILITY IDEOGRAPH-F957");
    map.put('\uF958', "CJK COMPATIBILITY IDEOGRAPH-F958");
    map.put('\uF959', "CJK COMPATIBILITY IDEOGRAPH-F959");
    map.put('\uF95A', "CJK COMPATIBILITY IDEOGRAPH-F95A");
    map.put('\uF95B', "CJK COMPATIBILITY IDEOGRAPH-F95B");
    map.put('\uF95C', "CJK COMPATIBILITY IDEOGRAPH-F95C");
    map.put('\uF95D', "CJK COMPATIBILITY IDEOGRAPH-F95D");
    map.put('\uF95E', "CJK COMPATIBILITY IDEOGRAPH-F95E");
    map.put('\uF95F', "CJK COMPATIBILITY IDEOGRAPH-F95F");
    map.put('\uF960', "CJK COMPATIBILITY IDEOGRAPH-F960");
    map.put('\uF961', "CJK COMPATIBILITY IDEOGRAPH-F961");
    map.put('\uF962', "CJK COMPATIBILITY IDEOGRAPH-F962");
    map.put('\uF963', "CJK COMPATIBILITY IDEOGRAPH-F963");
    map.put('\uF964', "CJK COMPATIBILITY IDEOGRAPH-F964");
    map.put('\uF965', "CJK COMPATIBILITY IDEOGRAPH-F965");
    map.put('\uF966', "CJK COMPATIBILITY IDEOGRAPH-F966");
    map.put('\uF967', "CJK COMPATIBILITY IDEOGRAPH-F967");
    map.put('\uF968', "CJK COMPATIBILITY IDEOGRAPH-F968");
    map.put('\uF969', "CJK COMPATIBILITY IDEOGRAPH-F969");
    map.put('\uF96A', "CJK COMPATIBILITY IDEOGRAPH-F96A");
    map.put('\uF96B', "CJK COMPATIBILITY IDEOGRAPH-F96B");
    map.put('\uF96C', "CJK COMPATIBILITY IDEOGRAPH-F96C");
    map.put('\uF96D', "CJK COMPATIBILITY IDEOGRAPH-F96D");
    map.put('\uF96E', "CJK COMPATIBILITY IDEOGRAPH-F96E");
    map.put('\uF96F', "CJK COMPATIBILITY IDEOGRAPH-F96F");
    map.put('\uF970', "CJK COMPATIBILITY IDEOGRAPH-F970");
    map.put('\uF971', "CJK COMPATIBILITY IDEOGRAPH-F971");
    map.put('\uF972', "CJK COMPATIBILITY IDEOGRAPH-F972");
    map.put('\uF973', "CJK COMPATIBILITY IDEOGRAPH-F973");
    map.put('\uF974', "CJK COMPATIBILITY IDEOGRAPH-F974");
    map.put('\uF975', "CJK COMPATIBILITY IDEOGRAPH-F975");
    map.put('\uF976', "CJK COMPATIBILITY IDEOGRAPH-F976");
    map.put('\uF977', "CJK COMPATIBILITY IDEOGRAPH-F977");
    map.put('\uF978', "CJK COMPATIBILITY IDEOGRAPH-F978");
    map.put('\uF979', "CJK COMPATIBILITY IDEOGRAPH-F979");
    map.put('\uF97A', "CJK COMPATIBILITY IDEOGRAPH-F97A");
    map.put('\uF97B', "CJK COMPATIBILITY IDEOGRAPH-F97B");
    map.put('\uF97C', "CJK COMPATIBILITY IDEOGRAPH-F97C");
    map.put('\uF97D', "CJK COMPATIBILITY IDEOGRAPH-F97D");
    map.put('\uF97E', "CJK COMPATIBILITY IDEOGRAPH-F97E");
    map.put('\uF97F', "CJK COMPATIBILITY IDEOGRAPH-F97F");
    map.put('\uF980', "CJK COMPATIBILITY IDEOGRAPH-F980");
    map.put('\uF981', "CJK COMPATIBILITY IDEOGRAPH-F981");
    map.put('\uF982', "CJK COMPATIBILITY IDEOGRAPH-F982");
    map.put('\uF983', "CJK COMPATIBILITY IDEOGRAPH-F983");
    map.put('\uF984', "CJK COMPATIBILITY IDEOGRAPH-F984");
    map.put('\uF985', "CJK COMPATIBILITY IDEOGRAPH-F985");
    map.put('\uF986', "CJK COMPATIBILITY IDEOGRAPH-F986");
    map.put('\uF987', "CJK COMPATIBILITY IDEOGRAPH-F987");
    map.put('\uF988', "CJK COMPATIBILITY IDEOGRAPH-F988");
    map.put('\uF989', "CJK COMPATIBILITY IDEOGRAPH-F989");
    map.put('\uF98A', "CJK COMPATIBILITY IDEOGRAPH-F98A");
    map.put('\uF98B', "CJK COMPATIBILITY IDEOGRAPH-F98B");
    map.put('\uF98C', "CJK COMPATIBILITY IDEOGRAPH-F98C");
    map.put('\uF98D', "CJK COMPATIBILITY IDEOGRAPH-F98D");
    map.put('\uF98E', "CJK COMPATIBILITY IDEOGRAPH-F98E");
    map.put('\uF98F', "CJK COMPATIBILITY IDEOGRAPH-F98F");
    map.put('\uF990', "CJK COMPATIBILITY IDEOGRAPH-F990");
    map.put('\uF991', "CJK COMPATIBILITY IDEOGRAPH-F991");
    map.put('\uF992', "CJK COMPATIBILITY IDEOGRAPH-F992");
    map.put('\uF993', "CJK COMPATIBILITY IDEOGRAPH-F993");
    map.put('\uF994', "CJK COMPATIBILITY IDEOGRAPH-F994");
    map.put('\uF995', "CJK COMPATIBILITY IDEOGRAPH-F995");
    map.put('\uF996', "CJK COMPATIBILITY IDEOGRAPH-F996");
    map.put('\uF997', "CJK COMPATIBILITY IDEOGRAPH-F997");
    map.put('\uF998', "CJK COMPATIBILITY IDEOGRAPH-F998");
    map.put('\uF999', "CJK COMPATIBILITY IDEOGRAPH-F999");
    map.put('\uF99A', "CJK COMPATIBILITY IDEOGRAPH-F99A");
    map.put('\uF99B', "CJK COMPATIBILITY IDEOGRAPH-F99B");
    map.put('\uF99C', "CJK COMPATIBILITY IDEOGRAPH-F99C");
    map.put('\uF99D', "CJK COMPATIBILITY IDEOGRAPH-F99D");
    map.put('\uF99E', "CJK COMPATIBILITY IDEOGRAPH-F99E");
    map.put('\uF99F', "CJK COMPATIBILITY IDEOGRAPH-F99F");
    map.put('\uF9A0', "CJK COMPATIBILITY IDEOGRAPH-F9A0");
    map.put('\uF9A1', "CJK COMPATIBILITY IDEOGRAPH-F9A1");
    map.put('\uF9A2', "CJK COMPATIBILITY IDEOGRAPH-F9A2");
    map.put('\uF9A3', "CJK COMPATIBILITY IDEOGRAPH-F9A3");
    map.put('\uF9A4', "CJK COMPATIBILITY IDEOGRAPH-F9A4");
    map.put('\uF9A5', "CJK COMPATIBILITY IDEOGRAPH-F9A5");
    map.put('\uF9A6', "CJK COMPATIBILITY IDEOGRAPH-F9A6");
    map.put('\uF9A7', "CJK COMPATIBILITY IDEOGRAPH-F9A7");
    map.put('\uF9A8', "CJK COMPATIBILITY IDEOGRAPH-F9A8");
    map.put('\uF9A9', "CJK COMPATIBILITY IDEOGRAPH-F9A9");
    map.put('\uF9AA', "CJK COMPATIBILITY IDEOGRAPH-F9AA");
    map.put('\uF9AB', "CJK COMPATIBILITY IDEOGRAPH-F9AB");
    map.put('\uF9AC', "CJK COMPATIBILITY IDEOGRAPH-F9AC");
    map.put('\uF9AD', "CJK COMPATIBILITY IDEOGRAPH-F9AD");
    map.put('\uF9AE', "CJK COMPATIBILITY IDEOGRAPH-F9AE");
    map.put('\uF9AF', "CJK COMPATIBILITY IDEOGRAPH-F9AF");
    map.put('\uF9B0', "CJK COMPATIBILITY IDEOGRAPH-F9B0");
    map.put('\uF9B1', "CJK COMPATIBILITY IDEOGRAPH-F9B1");
    map.put('\uF9B2', "CJK COMPATIBILITY IDEOGRAPH-F9B2");
    map.put('\uF9B3', "CJK COMPATIBILITY IDEOGRAPH-F9B3");
    map.put('\uF9B4', "CJK COMPATIBILITY IDEOGRAPH-F9B4");
    map.put('\uF9B5', "CJK COMPATIBILITY IDEOGRAPH-F9B5");
    map.put('\uF9B6', "CJK COMPATIBILITY IDEOGRAPH-F9B6");
    map.put('\uF9B7', "CJK COMPATIBILITY IDEOGRAPH-F9B7");
    map.put('\uF9B8', "CJK COMPATIBILITY IDEOGRAPH-F9B8");
    map.put('\uF9B9', "CJK COMPATIBILITY IDEOGRAPH-F9B9");
    map.put('\uF9BA', "CJK COMPATIBILITY IDEOGRAPH-F9BA");
    map.put('\uF9BB', "CJK COMPATIBILITY IDEOGRAPH-F9BB");
    map.put('\uF9BC', "CJK COMPATIBILITY IDEOGRAPH-F9BC");
    map.put('\uF9BD', "CJK COMPATIBILITY IDEOGRAPH-F9BD");
    map.put('\uF9BE', "CJK COMPATIBILITY IDEOGRAPH-F9BE");
    map.put('\uF9BF', "CJK COMPATIBILITY IDEOGRAPH-F9BF");
    map.put('\uF9C0', "CJK COMPATIBILITY IDEOGRAPH-F9C0");
    map.put('\uF9C1', "CJK COMPATIBILITY IDEOGRAPH-F9C1");
    map.put('\uF9C2', "CJK COMPATIBILITY IDEOGRAPH-F9C2");
    map.put('\uF9C3', "CJK COMPATIBILITY IDEOGRAPH-F9C3");
    map.put('\uF9C4', "CJK COMPATIBILITY IDEOGRAPH-F9C4");
    map.put('\uF9C5', "CJK COMPATIBILITY IDEOGRAPH-F9C5");
    map.put('\uF9C6', "CJK COMPATIBILITY IDEOGRAPH-F9C6");
    map.put('\uF9C7', "CJK COMPATIBILITY IDEOGRAPH-F9C7");
    map.put('\uF9C8', "CJK COMPATIBILITY IDEOGRAPH-F9C8");
    map.put('\uF9C9', "CJK COMPATIBILITY IDEOGRAPH-F9C9");
    map.put('\uF9CA', "CJK COMPATIBILITY IDEOGRAPH-F9CA");
    map.put('\uF9CB', "CJK COMPATIBILITY IDEOGRAPH-F9CB");
    map.put('\uF9CC', "CJK COMPATIBILITY IDEOGRAPH-F9CC");
    map.put('\uF9CD', "CJK COMPATIBILITY IDEOGRAPH-F9CD");
    map.put('\uF9CE', "CJK COMPATIBILITY IDEOGRAPH-F9CE");
    map.put('\uF9CF', "CJK COMPATIBILITY IDEOGRAPH-F9CF");
    map.put('\uF9D0', "CJK COMPATIBILITY IDEOGRAPH-F9D0");
    map.put('\uF9D1', "CJK COMPATIBILITY IDEOGRAPH-F9D1");
    map.put('\uF9D2', "CJK COMPATIBILITY IDEOGRAPH-F9D2");
    map.put('\uF9D3', "CJK COMPATIBILITY IDEOGRAPH-F9D3");
    map.put('\uF9D4', "CJK COMPATIBILITY IDEOGRAPH-F9D4");
    map.put('\uF9D5', "CJK COMPATIBILITY IDEOGRAPH-F9D5");
    map.put('\uF9D6', "CJK COMPATIBILITY IDEOGRAPH-F9D6");
    map.put('\uF9D7', "CJK COMPATIBILITY IDEOGRAPH-F9D7");
    map.put('\uF9D8', "CJK COMPATIBILITY IDEOGRAPH-F9D8");
    map.put('\uF9D9', "CJK COMPATIBILITY IDEOGRAPH-F9D9");
    map.put('\uF9DA', "CJK COMPATIBILITY IDEOGRAPH-F9DA");
    map.put('\uF9DB', "CJK COMPATIBILITY IDEOGRAPH-F9DB");
    map.put('\uF9DC', "CJK COMPATIBILITY IDEOGRAPH-F9DC");
    map.put('\uF9DD', "CJK COMPATIBILITY IDEOGRAPH-F9DD");
    map.put('\uF9DE', "CJK COMPATIBILITY IDEOGRAPH-F9DE");
    map.put('\uF9DF', "CJK COMPATIBILITY IDEOGRAPH-F9DF");
    map.put('\uF9E0', "CJK COMPATIBILITY IDEOGRAPH-F9E0");
    map.put('\uF9E1', "CJK COMPATIBILITY IDEOGRAPH-F9E1");
    map.put('\uF9E2', "CJK COMPATIBILITY IDEOGRAPH-F9E2");
    map.put('\uF9E3', "CJK COMPATIBILITY IDEOGRAPH-F9E3");
    map.put('\uF9E4', "CJK COMPATIBILITY IDEOGRAPH-F9E4");
    map.put('\uF9E5', "CJK COMPATIBILITY IDEOGRAPH-F9E5");
    map.put('\uF9E6', "CJK COMPATIBILITY IDEOGRAPH-F9E6");
    map.put('\uF9E7', "CJK COMPATIBILITY IDEOGRAPH-F9E7");
    map.put('\uF9E8', "CJK COMPATIBILITY IDEOGRAPH-F9E8");
    map.put('\uF9E9', "CJK COMPATIBILITY IDEOGRAPH-F9E9");
    map.put('\uF9EA', "CJK COMPATIBILITY IDEOGRAPH-F9EA");
    map.put('\uF9EB', "CJK COMPATIBILITY IDEOGRAPH-F9EB");
    map.put('\uF9EC', "CJK COMPATIBILITY IDEOGRAPH-F9EC");
    map.put('\uF9ED', "CJK COMPATIBILITY IDEOGRAPH-F9ED");
    map.put('\uF9EE', "CJK COMPATIBILITY IDEOGRAPH-F9EE");
    map.put('\uF9EF', "CJK COMPATIBILITY IDEOGRAPH-F9EF");
    map.put('\uF9F0', "CJK COMPATIBILITY IDEOGRAPH-F9F0");
    map.put('\uF9F1', "CJK COMPATIBILITY IDEOGRAPH-F9F1");
    map.put('\uF9F2', "CJK COMPATIBILITY IDEOGRAPH-F9F2");
    map.put('\uF9F3', "CJK COMPATIBILITY IDEOGRAPH-F9F3");
    map.put('\uF9F4', "CJK COMPATIBILITY IDEOGRAPH-F9F4");
    map.put('\uF9F5', "CJK COMPATIBILITY IDEOGRAPH-F9F5");
    map.put('\uF9F6', "CJK COMPATIBILITY IDEOGRAPH-F9F6");
    map.put('\uF9F7', "CJK COMPATIBILITY IDEOGRAPH-F9F7");
    map.put('\uF9F8', "CJK COMPATIBILITY IDEOGRAPH-F9F8");
    map.put('\uF9F9', "CJK COMPATIBILITY IDEOGRAPH-F9F9");
    map.put('\uF9FA', "CJK COMPATIBILITY IDEOGRAPH-F9FA");
    map.put('\uF9FB', "CJK COMPATIBILITY IDEOGRAPH-F9FB");
    map.put('\uF9FC', "CJK COMPATIBILITY IDEOGRAPH-F9FC");
    map.put('\uF9FD', "CJK COMPATIBILITY IDEOGRAPH-F9FD");
    map.put('\uF9FE', "CJK COMPATIBILITY IDEOGRAPH-F9FE");
    map.put('\uF9FF', "CJK COMPATIBILITY IDEOGRAPH-F9FF");
    map.put('\uFA00', "CJK COMPATIBILITY IDEOGRAPH-FA00");
    map.put('\uFA01', "CJK COMPATIBILITY IDEOGRAPH-FA01");
    map.put('\uFA02', "CJK COMPATIBILITY IDEOGRAPH-FA02");
    map.put('\uFA03', "CJK COMPATIBILITY IDEOGRAPH-FA03");
    map.put('\uFA04', "CJK COMPATIBILITY IDEOGRAPH-FA04");
    map.put('\uFA05', "CJK COMPATIBILITY IDEOGRAPH-FA05");
    map.put('\uFA06', "CJK COMPATIBILITY IDEOGRAPH-FA06");
    map.put('\uFA07', "CJK COMPATIBILITY IDEOGRAPH-FA07");
    map.put('\uFA08', "CJK COMPATIBILITY IDEOGRAPH-FA08");
    map.put('\uFA09', "CJK COMPATIBILITY IDEOGRAPH-FA09");
    map.put('\uFA0A', "CJK COMPATIBILITY IDEOGRAPH-FA0A");
    map.put('\uFA0B', "CJK COMPATIBILITY IDEOGRAPH-FA0B");
    map.put('\uFA0C', "CJK COMPATIBILITY IDEOGRAPH-FA0C");
    map.put('\uFA0D', "CJK COMPATIBILITY IDEOGRAPH-FA0D");
    map.put('\uFA0E', "CJK COMPATIBILITY IDEOGRAPH-FA0E");
    map.put('\uFA0F', "CJK COMPATIBILITY IDEOGRAPH-FA0F");
    map.put('\uFA10', "CJK COMPATIBILITY IDEOGRAPH-FA10");
    map.put('\uFA11', "CJK COMPATIBILITY IDEOGRAPH-FA11");
    map.put('\uFA12', "CJK COMPATIBILITY IDEOGRAPH-FA12");
    map.put('\uFA13', "CJK COMPATIBILITY IDEOGRAPH-FA13");
    map.put('\uFA14', "CJK COMPATIBILITY IDEOGRAPH-FA14");
    map.put('\uFA15', "CJK COMPATIBILITY IDEOGRAPH-FA15");
    map.put('\uFA16', "CJK COMPATIBILITY IDEOGRAPH-FA16");
    map.put('\uFA17', "CJK COMPATIBILITY IDEOGRAPH-FA17");
    map.put('\uFA18', "CJK COMPATIBILITY IDEOGRAPH-FA18");
    map.put('\uFA19', "CJK COMPATIBILITY IDEOGRAPH-FA19");
    map.put('\uFA1A', "CJK COMPATIBILITY IDEOGRAPH-FA1A");
    map.put('\uFA1B', "CJK COMPATIBILITY IDEOGRAPH-FA1B");
    map.put('\uFA1C', "CJK COMPATIBILITY IDEOGRAPH-FA1C");
    map.put('\uFA1D', "CJK COMPATIBILITY IDEOGRAPH-FA1D");
    map.put('\uFA1E', "CJK COMPATIBILITY IDEOGRAPH-FA1E");
    map.put('\uFA1F', "CJK COMPATIBILITY IDEOGRAPH-FA1F");
    map.put('\uFA20', "CJK COMPATIBILITY IDEOGRAPH-FA20");
    map.put('\uFA21', "CJK COMPATIBILITY IDEOGRAPH-FA21");
    map.put('\uFA22', "CJK COMPATIBILITY IDEOGRAPH-FA22");
    map.put('\uFA23', "CJK COMPATIBILITY IDEOGRAPH-FA23");
    map.put('\uFA24', "CJK COMPATIBILITY IDEOGRAPH-FA24");
    map.put('\uFA25', "CJK COMPATIBILITY IDEOGRAPH-FA25");
    map.put('\uFA26', "CJK COMPATIBILITY IDEOGRAPH-FA26");
    map.put('\uFA27', "CJK COMPATIBILITY IDEOGRAPH-FA27");
    map.put('\uFA28', "CJK COMPATIBILITY IDEOGRAPH-FA28");
    map.put('\uFA29', "CJK COMPATIBILITY IDEOGRAPH-FA29");
    map.put('\uFA2A', "CJK COMPATIBILITY IDEOGRAPH-FA2A");
    map.put('\uFA2B', "CJK COMPATIBILITY IDEOGRAPH-FA2B");
    map.put('\uFA2C', "CJK COMPATIBILITY IDEOGRAPH-FA2C");
    map.put('\uFA2D', "CJK COMPATIBILITY IDEOGRAPH-FA2D");
    map.put('\uFA30', "CJK COMPATIBILITY IDEOGRAPH-FA30");
    map.put('\uFA31', "CJK COMPATIBILITY IDEOGRAPH-FA31");
    map.put('\uFA32', "CJK COMPATIBILITY IDEOGRAPH-FA32");
    map.put('\uFA33', "CJK COMPATIBILITY IDEOGRAPH-FA33");
    map.put('\uFA34', "CJK COMPATIBILITY IDEOGRAPH-FA34");
    map.put('\uFA35', "CJK COMPATIBILITY IDEOGRAPH-FA35");
    map.put('\uFA36', "CJK COMPATIBILITY IDEOGRAPH-FA36");
    map.put('\uFA37', "CJK COMPATIBILITY IDEOGRAPH-FA37");
    map.put('\uFA38', "CJK COMPATIBILITY IDEOGRAPH-FA38");
    map.put('\uFA39', "CJK COMPATIBILITY IDEOGRAPH-FA39");
    map.put('\uFA3A', "CJK COMPATIBILITY IDEOGRAPH-FA3A");
    map.put('\uFA3B', "CJK COMPATIBILITY IDEOGRAPH-FA3B");
    map.put('\uFA3C', "CJK COMPATIBILITY IDEOGRAPH-FA3C");
    map.put('\uFA3D', "CJK COMPATIBILITY IDEOGRAPH-FA3D");
    map.put('\uFA3E', "CJK COMPATIBILITY IDEOGRAPH-FA3E");
    map.put('\uFA3F', "CJK COMPATIBILITY IDEOGRAPH-FA3F");
    map.put('\uFA40', "CJK COMPATIBILITY IDEOGRAPH-FA40");
    map.put('\uFA41', "CJK COMPATIBILITY IDEOGRAPH-FA41");
    map.put('\uFA42', "CJK COMPATIBILITY IDEOGRAPH-FA42");
    map.put('\uFA43', "CJK COMPATIBILITY IDEOGRAPH-FA43");
    map.put('\uFA44', "CJK COMPATIBILITY IDEOGRAPH-FA44");
    map.put('\uFA45', "CJK COMPATIBILITY IDEOGRAPH-FA45");
    map.put('\uFA46', "CJK COMPATIBILITY IDEOGRAPH-FA46");
    map.put('\uFA47', "CJK COMPATIBILITY IDEOGRAPH-FA47");
    map.put('\uFA48', "CJK COMPATIBILITY IDEOGRAPH-FA48");
    map.put('\uFA49', "CJK COMPATIBILITY IDEOGRAPH-FA49");
    map.put('\uFA4A', "CJK COMPATIBILITY IDEOGRAPH-FA4A");
    map.put('\uFA4B', "CJK COMPATIBILITY IDEOGRAPH-FA4B");
    map.put('\uFA4C', "CJK COMPATIBILITY IDEOGRAPH-FA4C");
    map.put('\uFA4D', "CJK COMPATIBILITY IDEOGRAPH-FA4D");
    map.put('\uFA4E', "CJK COMPATIBILITY IDEOGRAPH-FA4E");
    map.put('\uFA4F', "CJK COMPATIBILITY IDEOGRAPH-FA4F");
    map.put('\uFA50', "CJK COMPATIBILITY IDEOGRAPH-FA50");
    map.put('\uFA51', "CJK COMPATIBILITY IDEOGRAPH-FA51");
    map.put('\uFA52', "CJK COMPATIBILITY IDEOGRAPH-FA52");
    map.put('\uFA53', "CJK COMPATIBILITY IDEOGRAPH-FA53");
    map.put('\uFA54', "CJK COMPATIBILITY IDEOGRAPH-FA54");
    map.put('\uFA55', "CJK COMPATIBILITY IDEOGRAPH-FA55");
    map.put('\uFA56', "CJK COMPATIBILITY IDEOGRAPH-FA56");
    map.put('\uFA57', "CJK COMPATIBILITY IDEOGRAPH-FA57");
    map.put('\uFA58', "CJK COMPATIBILITY IDEOGRAPH-FA58");
    map.put('\uFA59', "CJK COMPATIBILITY IDEOGRAPH-FA59");
    map.put('\uFA5A', "CJK COMPATIBILITY IDEOGRAPH-FA5A");
    map.put('\uFA5B', "CJK COMPATIBILITY IDEOGRAPH-FA5B");
    map.put('\uFA5C', "CJK COMPATIBILITY IDEOGRAPH-FA5C");
    map.put('\uFA5D', "CJK COMPATIBILITY IDEOGRAPH-FA5D");
    map.put('\uFA5E', "CJK COMPATIBILITY IDEOGRAPH-FA5E");
    map.put('\uFA5F', "CJK COMPATIBILITY IDEOGRAPH-FA5F");
    map.put('\uFA60', "CJK COMPATIBILITY IDEOGRAPH-FA60");
    map.put('\uFA61', "CJK COMPATIBILITY IDEOGRAPH-FA61");
    map.put('\uFA62', "CJK COMPATIBILITY IDEOGRAPH-FA62");
    map.put('\uFA63', "CJK COMPATIBILITY IDEOGRAPH-FA63");
    map.put('\uFA64', "CJK COMPATIBILITY IDEOGRAPH-FA64");
    map.put('\uFA65', "CJK COMPATIBILITY IDEOGRAPH-FA65");
    map.put('\uFA66', "CJK COMPATIBILITY IDEOGRAPH-FA66");
    map.put('\uFA67', "CJK COMPATIBILITY IDEOGRAPH-FA67");
    map.put('\uFA68', "CJK COMPATIBILITY IDEOGRAPH-FA68");
    map.put('\uFA69', "CJK COMPATIBILITY IDEOGRAPH-FA69");
    map.put('\uFA6A', "CJK COMPATIBILITY IDEOGRAPH-FA6A");
    map.put('\uFA6B', "CJK COMPATIBILITY IDEOGRAPH-FA6B");
    map.put('\uFA6C', "CJK COMPATIBILITY IDEOGRAPH-FA6C");
    map.put('\uFA6D', "CJK COMPATIBILITY IDEOGRAPH-FA6D");
    map.put('\uFA70', "CJK COMPATIBILITY IDEOGRAPH-FA70");
    map.put('\uFA71', "CJK COMPATIBILITY IDEOGRAPH-FA71");
    map.put('\uFA72', "CJK COMPATIBILITY IDEOGRAPH-FA72");
    map.put('\uFA73', "CJK COMPATIBILITY IDEOGRAPH-FA73");
    map.put('\uFA74', "CJK COMPATIBILITY IDEOGRAPH-FA74");
    map.put('\uFA75', "CJK COMPATIBILITY IDEOGRAPH-FA75");
    map.put('\uFA76', "CJK COMPATIBILITY IDEOGRAPH-FA76");
    map.put('\uFA77', "CJK COMPATIBILITY IDEOGRAPH-FA77");
    map.put('\uFA78', "CJK COMPATIBILITY IDEOGRAPH-FA78");
    map.put('\uFA79', "CJK COMPATIBILITY IDEOGRAPH-FA79");
    map.put('\uFA7A', "CJK COMPATIBILITY IDEOGRAPH-FA7A");
    map.put('\uFA7B', "CJK COMPATIBILITY IDEOGRAPH-FA7B");
    map.put('\uFA7C', "CJK COMPATIBILITY IDEOGRAPH-FA7C");
    map.put('\uFA7D', "CJK COMPATIBILITY IDEOGRAPH-FA7D");
    map.put('\uFA7E', "CJK COMPATIBILITY IDEOGRAPH-FA7E");
    map.put('\uFA7F', "CJK COMPATIBILITY IDEOGRAPH-FA7F");
    map.put('\uFA80', "CJK COMPATIBILITY IDEOGRAPH-FA80");
    map.put('\uFA81', "CJK COMPATIBILITY IDEOGRAPH-FA81");
    map.put('\uFA82', "CJK COMPATIBILITY IDEOGRAPH-FA82");
    map.put('\uFA83', "CJK COMPATIBILITY IDEOGRAPH-FA83");
    map.put('\uFA84', "CJK COMPATIBILITY IDEOGRAPH-FA84");
    map.put('\uFA85', "CJK COMPATIBILITY IDEOGRAPH-FA85");
    map.put('\uFA86', "CJK COMPATIBILITY IDEOGRAPH-FA86");
    map.put('\uFA87', "CJK COMPATIBILITY IDEOGRAPH-FA87");
    map.put('\uFA88', "CJK COMPATIBILITY IDEOGRAPH-FA88");
    map.put('\uFA89', "CJK COMPATIBILITY IDEOGRAPH-FA89");
    map.put('\uFA8A', "CJK COMPATIBILITY IDEOGRAPH-FA8A");
    map.put('\uFA8B', "CJK COMPATIBILITY IDEOGRAPH-FA8B");
    map.put('\uFA8C', "CJK COMPATIBILITY IDEOGRAPH-FA8C");
    map.put('\uFA8D', "CJK COMPATIBILITY IDEOGRAPH-FA8D");
    map.put('\uFA8E', "CJK COMPATIBILITY IDEOGRAPH-FA8E");
    map.put('\uFA8F', "CJK COMPATIBILITY IDEOGRAPH-FA8F");
    map.put('\uFA90', "CJK COMPATIBILITY IDEOGRAPH-FA90");
    map.put('\uFA91', "CJK COMPATIBILITY IDEOGRAPH-FA91");
    map.put('\uFA92', "CJK COMPATIBILITY IDEOGRAPH-FA92");
    map.put('\uFA93', "CJK COMPATIBILITY IDEOGRAPH-FA93");
    map.put('\uFA94', "CJK COMPATIBILITY IDEOGRAPH-FA94");
    map.put('\uFA95', "CJK COMPATIBILITY IDEOGRAPH-FA95");
    map.put('\uFA96', "CJK COMPATIBILITY IDEOGRAPH-FA96");
    map.put('\uFA97', "CJK COMPATIBILITY IDEOGRAPH-FA97");
    map.put('\uFA98', "CJK COMPATIBILITY IDEOGRAPH-FA98");
    map.put('\uFA99', "CJK COMPATIBILITY IDEOGRAPH-FA99");
    map.put('\uFA9A', "CJK COMPATIBILITY IDEOGRAPH-FA9A");
    map.put('\uFA9B', "CJK COMPATIBILITY IDEOGRAPH-FA9B");
    map.put('\uFA9C', "CJK COMPATIBILITY IDEOGRAPH-FA9C");
    map.put('\uFA9D', "CJK COMPATIBILITY IDEOGRAPH-FA9D");
    map.put('\uFA9E', "CJK COMPATIBILITY IDEOGRAPH-FA9E");
    map.put('\uFA9F', "CJK COMPATIBILITY IDEOGRAPH-FA9F");
    map.put('\uFAA0', "CJK COMPATIBILITY IDEOGRAPH-FAA0");
    map.put('\uFAA1', "CJK COMPATIBILITY IDEOGRAPH-FAA1");
    map.put('\uFAA2', "CJK COMPATIBILITY IDEOGRAPH-FAA2");
    map.put('\uFAA3', "CJK COMPATIBILITY IDEOGRAPH-FAA3");
    map.put('\uFAA4', "CJK COMPATIBILITY IDEOGRAPH-FAA4");
    map.put('\uFAA5', "CJK COMPATIBILITY IDEOGRAPH-FAA5");
    map.put('\uFAA6', "CJK COMPATIBILITY IDEOGRAPH-FAA6");
    map.put('\uFAA7', "CJK COMPATIBILITY IDEOGRAPH-FAA7");
    map.put('\uFAA8', "CJK COMPATIBILITY IDEOGRAPH-FAA8");
    map.put('\uFAA9', "CJK COMPATIBILITY IDEOGRAPH-FAA9");
    map.put('\uFAAA', "CJK COMPATIBILITY IDEOGRAPH-FAAA");
    map.put('\uFAAB', "CJK COMPATIBILITY IDEOGRAPH-FAAB");
    map.put('\uFAAC', "CJK COMPATIBILITY IDEOGRAPH-FAAC");
    map.put('\uFAAD', "CJK COMPATIBILITY IDEOGRAPH-FAAD");
    map.put('\uFAAE', "CJK COMPATIBILITY IDEOGRAPH-FAAE");
    map.put('\uFAAF', "CJK COMPATIBILITY IDEOGRAPH-FAAF");
    map.put('\uFAB0', "CJK COMPATIBILITY IDEOGRAPH-FAB0");
    map.put('\uFAB1', "CJK COMPATIBILITY IDEOGRAPH-FAB1");
    map.put('\uFAB2', "CJK COMPATIBILITY IDEOGRAPH-FAB2");
    map.put('\uFAB3', "CJK COMPATIBILITY IDEOGRAPH-FAB3");
    map.put('\uFAB4', "CJK COMPATIBILITY IDEOGRAPH-FAB4");
    map.put('\uFAB5', "CJK COMPATIBILITY IDEOGRAPH-FAB5");
    map.put('\uFAB6', "CJK COMPATIBILITY IDEOGRAPH-FAB6");
    map.put('\uFAB7', "CJK COMPATIBILITY IDEOGRAPH-FAB7");
    map.put('\uFAB8', "CJK COMPATIBILITY IDEOGRAPH-FAB8");
    map.put('\uFAB9', "CJK COMPATIBILITY IDEOGRAPH-FAB9");
    map.put('\uFABA', "CJK COMPATIBILITY IDEOGRAPH-FABA");
    map.put('\uFABB', "CJK COMPATIBILITY IDEOGRAPH-FABB");
    map.put('\uFABC', "CJK COMPATIBILITY IDEOGRAPH-FABC");
    map.put('\uFABD', "CJK COMPATIBILITY IDEOGRAPH-FABD");
    map.put('\uFABE', "CJK COMPATIBILITY IDEOGRAPH-FABE");
    map.put('\uFABF', "CJK COMPATIBILITY IDEOGRAPH-FABF");
    map.put('\uFAC0', "CJK COMPATIBILITY IDEOGRAPH-FAC0");
    map.put('\uFAC1', "CJK COMPATIBILITY IDEOGRAPH-FAC1");
    map.put('\uFAC2', "CJK COMPATIBILITY IDEOGRAPH-FAC2");
    map.put('\uFAC3', "CJK COMPATIBILITY IDEOGRAPH-FAC3");
    map.put('\uFAC4', "CJK COMPATIBILITY IDEOGRAPH-FAC4");
    map.put('\uFAC5', "CJK COMPATIBILITY IDEOGRAPH-FAC5");
    map.put('\uFAC6', "CJK COMPATIBILITY IDEOGRAPH-FAC6");
    map.put('\uFAC7', "CJK COMPATIBILITY IDEOGRAPH-FAC7");
    map.put('\uFAC8', "CJK COMPATIBILITY IDEOGRAPH-FAC8");
    map.put('\uFAC9', "CJK COMPATIBILITY IDEOGRAPH-FAC9");
    map.put('\uFACA', "CJK COMPATIBILITY IDEOGRAPH-FACA");
    map.put('\uFACB', "CJK COMPATIBILITY IDEOGRAPH-FACB");
    map.put('\uFACC', "CJK COMPATIBILITY IDEOGRAPH-FACC");
    map.put('\uFACD', "CJK COMPATIBILITY IDEOGRAPH-FACD");
    map.put('\uFACE', "CJK COMPATIBILITY IDEOGRAPH-FACE");
    map.put('\uFACF', "CJK COMPATIBILITY IDEOGRAPH-FACF");
    map.put('\uFAD0', "CJK COMPATIBILITY IDEOGRAPH-FAD0");
    map.put('\uFAD1', "CJK COMPATIBILITY IDEOGRAPH-FAD1");
    map.put('\uFAD2', "CJK COMPATIBILITY IDEOGRAPH-FAD2");
    map.put('\uFAD3', "CJK COMPATIBILITY IDEOGRAPH-FAD3");
    map.put('\uFAD4', "CJK COMPATIBILITY IDEOGRAPH-FAD4");
    map.put('\uFAD5', "CJK COMPATIBILITY IDEOGRAPH-FAD5");
    map.put('\uFAD6', "CJK COMPATIBILITY IDEOGRAPH-FAD6");
    map.put('\uFAD7', "CJK COMPATIBILITY IDEOGRAPH-FAD7");
    map.put('\uFAD8', "CJK COMPATIBILITY IDEOGRAPH-FAD8");
    map.put('\uFAD9', "CJK COMPATIBILITY IDEOGRAPH-FAD9");
    map.put('\uFB00', "LATIN SMALL LIGATURE FF");
    map.put('\uFB01', "LATIN SMALL LIGATURE FI");
    map.put('\uFB02', "LATIN SMALL LIGATURE FL");
    map.put('\uFB03', "LATIN SMALL LIGATURE FFI");
    map.put('\uFB04', "LATIN SMALL LIGATURE FFL");
    map.put('\uFB05', "LATIN SMALL LIGATURE LONG S T");
    map.put('\uFB06', "LATIN SMALL LIGATURE ST");
    map.put('\uFB13', "ARMENIAN SMALL LIGATURE MEN NOW");
    map.put('\uFB14', "ARMENIAN SMALL LIGATURE MEN ECH");
    map.put('\uFB15', "ARMENIAN SMALL LIGATURE MEN INI");
    map.put('\uFB16', "ARMENIAN SMALL LIGATURE VEW NOW");
    map.put('\uFB17', "ARMENIAN SMALL LIGATURE MEN XEH");
    map.put('\uFB1D', "HEBREW LETTER YOD WITH HIRIQ");
    map.put('\uFB1E', "HEBREW POINT JUDEO-SPANISH VARIKA");
    map.put('\uFB1F', "HEBREW LIGATURE YIDDISH YOD YOD PATAH");
    map.put('\uFB20', "HEBREW LETTER ALTERNATIVE AYIN");
    map.put('\uFB21', "HEBREW LETTER WIDE ALEF");
    map.put('\uFB22', "HEBREW LETTER WIDE DALET");
    map.put('\uFB23', "HEBREW LETTER WIDE HE");
    map.put('\uFB24', "HEBREW LETTER WIDE KAF");
    map.put('\uFB25', "HEBREW LETTER WIDE LAMED");
    map.put('\uFB26', "HEBREW LETTER WIDE FINAL MEM");
    map.put('\uFB27', "HEBREW LETTER WIDE RESH");
    map.put('\uFB28', "HEBREW LETTER WIDE TAV");
    map.put('\uFB29', "HEBREW LETTER ALTERNATIVE PLUS SIGN");
    map.put('\uFB2A', "HEBREW LETTER SHIN WITH SHIN DOT");
    map.put('\uFB2B', "HEBREW LETTER SHIN WITH SIN DOT");
    map.put('\uFB2C', "HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT");
    map.put('\uFB2D', "HEBREW LETTER SHIN WITH DAGESH AND SIN DOT");
    map.put('\uFB2E', "HEBREW LETTER ALEF WITH PATAH");
    map.put('\uFB2F', "HEBREW LETTER ALEF WITH QAMATS");
    map.put('\uFB30', "HEBREW LETTER ALEF WITH MAPIQ");
    map.put('\uFB31', "HEBREW LETTER BET WITH DAGESH");
    map.put('\uFB32', "HEBREW LETTER GIMEL WITH DAGESH");
    map.put('\uFB33', "HEBREW LETTER DALET WITH DAGESH");
    map.put('\uFB34', "HEBREW LETTER HE WITH MAPIQ");
    map.put('\uFB35', "HEBREW LETTER VAV WITH DAGESH");
    map.put('\uFB36', "HEBREW LETTER ZAYIN WITH DAGESH");
    map.put('\uFB38', "HEBREW LETTER TET WITH DAGESH");
    map.put('\uFB39', "HEBREW LETTER YOD WITH DAGESH");
    map.put('\uFB3A', "HEBREW LETTER FINAL KAF WITH DAGESH");
    map.put('\uFB3B', "HEBREW LETTER KAF WITH DAGESH");
    map.put('\uFB3C', "HEBREW LETTER LAMED WITH DAGESH");
    map.put('\uFB3E', "HEBREW LETTER MEM WITH DAGESH");
    map.put('\uFB40', "HEBREW LETTER NUN WITH DAGESH");
    map.put('\uFB41', "HEBREW LETTER SAMEKH WITH DAGESH");
    map.put('\uFB43', "HEBREW LETTER FINAL PE WITH DAGESH");
    map.put('\uFB44', "HEBREW LETTER PE WITH DAGESH");
    map.put('\uFB46', "HEBREW LETTER TSADI WITH DAGESH");
    map.put('\uFB47', "HEBREW LETTER QOF WITH DAGESH");
    map.put('\uFB48', "HEBREW LETTER RESH WITH DAGESH");
    map.put('\uFB49', "HEBREW LETTER SHIN WITH DAGESH");
    map.put('\uFB4A', "HEBREW LETTER TAV WITH DAGESH");
    map.put('\uFB4B', "HEBREW LETTER VAV WITH HOLAM");
    map.put('\uFB4C', "HEBREW LETTER BET WITH RAFE");
    map.put('\uFB4D', "HEBREW LETTER KAF WITH RAFE");
    map.put('\uFB4E', "HEBREW LETTER PE WITH RAFE");
    map.put('\uFB4F', "HEBREW LIGATURE ALEF LAMED");
    map.put('\uFB50', "ARABIC LETTER ALEF WASLA ISOLATED FORM");
    map.put('\uFB51', "ARABIC LETTER ALEF WASLA FINAL FORM");
    map.put('\uFB52', "ARABIC LETTER BEEH ISOLATED FORM");
    map.put('\uFB53', "ARABIC LETTER BEEH FINAL FORM");
    map.put('\uFB54', "ARABIC LETTER BEEH INITIAL FORM");
    map.put('\uFB55', "ARABIC LETTER BEEH MEDIAL FORM");
    map.put('\uFB56', "ARABIC LETTER PEH ISOLATED FORM");
    map.put('\uFB57', "ARABIC LETTER PEH FINAL FORM");
    map.put('\uFB58', "ARABIC LETTER PEH INITIAL FORM");
    map.put('\uFB59', "ARABIC LETTER PEH MEDIAL FORM");
    map.put('\uFB5A', "ARABIC LETTER BEHEH ISOLATED FORM");
    map.put('\uFB5B', "ARABIC LETTER BEHEH FINAL FORM");
    map.put('\uFB5C', "ARABIC LETTER BEHEH INITIAL FORM");
    map.put('\uFB5D', "ARABIC LETTER BEHEH MEDIAL FORM");
    map.put('\uFB5E', "ARABIC LETTER TTEHEH ISOLATED FORM");
    map.put('\uFB5F', "ARABIC LETTER TTEHEH FINAL FORM");
    map.put('\uFB60', "ARABIC LETTER TTEHEH INITIAL FORM");
    map.put('\uFB61', "ARABIC LETTER TTEHEH MEDIAL FORM");
    map.put('\uFB62', "ARABIC LETTER TEHEH ISOLATED FORM");
    map.put('\uFB63', "ARABIC LETTER TEHEH FINAL FORM");
    map.put('\uFB64', "ARABIC LETTER TEHEH INITIAL FORM");
    map.put('\uFB65', "ARABIC LETTER TEHEH MEDIAL FORM");
    map.put('\uFB66', "ARABIC LETTER TTEH ISOLATED FORM");
    map.put('\uFB67', "ARABIC LETTER TTEH FINAL FORM");
    map.put('\uFB68', "ARABIC LETTER TTEH INITIAL FORM");
    map.put('\uFB69', "ARABIC LETTER TTEH MEDIAL FORM");
    map.put('\uFB6A', "ARABIC LETTER VEH ISOLATED FORM");
    map.put('\uFB6B', "ARABIC LETTER VEH FINAL FORM");
    map.put('\uFB6C', "ARABIC LETTER VEH INITIAL FORM");
    map.put('\uFB6D', "ARABIC LETTER VEH MEDIAL FORM");
    map.put('\uFB6E', "ARABIC LETTER PEHEH ISOLATED FORM");
    map.put('\uFB6F', "ARABIC LETTER PEHEH FINAL FORM");
    map.put('\uFB70', "ARABIC LETTER PEHEH INITIAL FORM");
    map.put('\uFB71', "ARABIC LETTER PEHEH MEDIAL FORM");
    map.put('\uFB72', "ARABIC LETTER DYEH ISOLATED FORM");
    map.put('\uFB73', "ARABIC LETTER DYEH FINAL FORM");
    map.put('\uFB74', "ARABIC LETTER DYEH INITIAL FORM");
    map.put('\uFB75', "ARABIC LETTER DYEH MEDIAL FORM");
    map.put('\uFB76', "ARABIC LETTER NYEH ISOLATED FORM");
    map.put('\uFB77', "ARABIC LETTER NYEH FINAL FORM");
    map.put('\uFB78', "ARABIC LETTER NYEH INITIAL FORM");
    map.put('\uFB79', "ARABIC LETTER NYEH MEDIAL FORM");
    map.put('\uFB7A', "ARABIC LETTER TCHEH ISOLATED FORM");
    map.put('\uFB7B', "ARABIC LETTER TCHEH FINAL FORM");
    map.put('\uFB7C', "ARABIC LETTER TCHEH INITIAL FORM");
    map.put('\uFB7D', "ARABIC LETTER TCHEH MEDIAL FORM");
    map.put('\uFB7E', "ARABIC LETTER TCHEHEH ISOLATED FORM");
    map.put('\uFB7F', "ARABIC LETTER TCHEHEH FINAL FORM");
    map.put('\uFB80', "ARABIC LETTER TCHEHEH INITIAL FORM");
    map.put('\uFB81', "ARABIC LETTER TCHEHEH MEDIAL FORM");
    map.put('\uFB82', "ARABIC LETTER DDAHAL ISOLATED FORM");
    map.put('\uFB83', "ARABIC LETTER DDAHAL FINAL FORM");
    map.put('\uFB84', "ARABIC LETTER DAHAL ISOLATED FORM");
    map.put('\uFB85', "ARABIC LETTER DAHAL FINAL FORM");
    map.put('\uFB86', "ARABIC LETTER DUL ISOLATED FORM");
    map.put('\uFB87', "ARABIC LETTER DUL FINAL FORM");
    map.put('\uFB88', "ARABIC LETTER DDAL ISOLATED FORM");
    map.put('\uFB89', "ARABIC LETTER DDAL FINAL FORM");
    map.put('\uFB8A', "ARABIC LETTER JEH ISOLATED FORM");
    map.put('\uFB8B', "ARABIC LETTER JEH FINAL FORM");
    map.put('\uFB8C', "ARABIC LETTER RREH ISOLATED FORM");
    map.put('\uFB8D', "ARABIC LETTER RREH FINAL FORM");
    map.put('\uFB8E', "ARABIC LETTER KEHEH ISOLATED FORM");
    map.put('\uFB8F', "ARABIC LETTER KEHEH FINAL FORM");
    map.put('\uFB90', "ARABIC LETTER KEHEH INITIAL FORM");
    map.put('\uFB91', "ARABIC LETTER KEHEH MEDIAL FORM");
    map.put('\uFB92', "ARABIC LETTER GAF ISOLATED FORM");
    map.put('\uFB93', "ARABIC LETTER GAF FINAL FORM");
    map.put('\uFB94', "ARABIC LETTER GAF INITIAL FORM");
    map.put('\uFB95', "ARABIC LETTER GAF MEDIAL FORM");
    map.put('\uFB96', "ARABIC LETTER GUEH ISOLATED FORM");
    map.put('\uFB97', "ARABIC LETTER GUEH FINAL FORM");
    map.put('\uFB98', "ARABIC LETTER GUEH INITIAL FORM");
    map.put('\uFB99', "ARABIC LETTER GUEH MEDIAL FORM");
    map.put('\uFB9A', "ARABIC LETTER NGOEH ISOLATED FORM");
    map.put('\uFB9B', "ARABIC LETTER NGOEH FINAL FORM");
    map.put('\uFB9C', "ARABIC LETTER NGOEH INITIAL FORM");
    map.put('\uFB9D', "ARABIC LETTER NGOEH MEDIAL FORM");
    map.put('\uFB9E', "ARABIC LETTER NOON GHUNNA ISOLATED FORM");
    map.put('\uFB9F', "ARABIC LETTER NOON GHUNNA FINAL FORM");
    map.put('\uFBA0', "ARABIC LETTER RNOON ISOLATED FORM");
    map.put('\uFBA1', "ARABIC LETTER RNOON FINAL FORM");
    map.put('\uFBA2', "ARABIC LETTER RNOON INITIAL FORM");
    map.put('\uFBA3', "ARABIC LETTER RNOON MEDIAL FORM");
    map.put('\uFBA4', "ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM");
    map.put('\uFBA5', "ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM");
    map.put('\uFBA6', "ARABIC LETTER HEH GOAL ISOLATED FORM");
    map.put('\uFBA7', "ARABIC LETTER HEH GOAL FINAL FORM");
    map.put('\uFBA8', "ARABIC LETTER HEH GOAL INITIAL FORM");
    map.put('\uFBA9', "ARABIC LETTER HEH GOAL MEDIAL FORM");
    map.put('\uFBAA', "ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM");
    map.put('\uFBAB', "ARABIC LETTER HEH DOACHASHMEE FINAL FORM");
    map.put('\uFBAC', "ARABIC LETTER HEH DOACHASHMEE INITIAL FORM");
    map.put('\uFBAD', "ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM");
    map.put('\uFBAE', "ARABIC LETTER YEH BARREE ISOLATED FORM");
    map.put('\uFBAF', "ARABIC LETTER YEH BARREE FINAL FORM");
    map.put('\uFBB0', "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM");
    map.put('\uFBB1', "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM");
    map.put('\uFBD3', "ARABIC LETTER NG ISOLATED FORM");
    map.put('\uFBD4', "ARABIC LETTER NG FINAL FORM");
    map.put('\uFBD5', "ARABIC LETTER NG INITIAL FORM");
    map.put('\uFBD6', "ARABIC LETTER NG MEDIAL FORM");
    map.put('\uFBD7', "ARABIC LETTER U ISOLATED FORM");
    map.put('\uFBD8', "ARABIC LETTER U FINAL FORM");
    map.put('\uFBD9', "ARABIC LETTER OE ISOLATED FORM");
    map.put('\uFBDA', "ARABIC LETTER OE FINAL FORM");
    map.put('\uFBDB', "ARABIC LETTER YU ISOLATED FORM");
    map.put('\uFBDC', "ARABIC LETTER YU FINAL FORM");
    map.put('\uFBDD', "ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM");
    map.put('\uFBDE', "ARABIC LETTER VE ISOLATED FORM");
    map.put('\uFBDF', "ARABIC LETTER VE FINAL FORM");
    map.put('\uFBE0', "ARABIC LETTER KIRGHIZ OE ISOLATED FORM");
    map.put('\uFBE1', "ARABIC LETTER KIRGHIZ OE FINAL FORM");
    map.put('\uFBE2', "ARABIC LETTER KIRGHIZ YU ISOLATED FORM");
    map.put('\uFBE3', "ARABIC LETTER KIRGHIZ YU FINAL FORM");
    map.put('\uFBE4', "ARABIC LETTER E ISOLATED FORM");
    map.put('\uFBE5', "ARABIC LETTER E FINAL FORM");
    map.put('\uFBE6', "ARABIC LETTER E INITIAL FORM");
    map.put('\uFBE7', "ARABIC LETTER E MEDIAL FORM");
    map.put('\uFBE8', "ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM");
    map.put('\uFBE9', "ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM");
    map.put('\uFBEA', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM");
    map.put('\uFBEB', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM");
    map.put('\uFBEC', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM");
    map.put('\uFBED', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM");
    map.put('\uFBEE', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM");
    map.put('\uFBEF', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM");
    map.put('\uFBF0', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM");
    map.put('\uFBF1', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM");
    map.put('\uFBF2', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM");
    map.put('\uFBF3', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM");
    map.put('\uFBF4', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM");
    map.put('\uFBF5', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM");
    map.put('\uFBF6', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM");
    map.put('\uFBF7', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM");
    map.put('\uFBF8', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM");
    map.put('\uFBF9',
        "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFBFA',
        "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFBFB',
        "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM");
    map.put('\uFBFC', "ARABIC LETTER FARSI YEH ISOLATED FORM");
    map.put('\uFBFD', "ARABIC LETTER FARSI YEH FINAL FORM");
    map.put('\uFBFE', "ARABIC LETTER FARSI YEH INITIAL FORM");
    map.put('\uFBFF', "ARABIC LETTER FARSI YEH MEDIAL FORM");
    map.put('\uFC00', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM");
    map.put('\uFC01', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM");
    map.put('\uFC02', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM");
    map.put('\uFC03', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC04', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM");
    map.put('\uFC05', "ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM");
    map.put('\uFC06', "ARABIC LIGATURE BEH WITH HAH ISOLATED FORM");
    map.put('\uFC07', "ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM");
    map.put('\uFC08', "ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM");
    map.put('\uFC09', "ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC0A', "ARABIC LIGATURE BEH WITH YEH ISOLATED FORM");
    map.put('\uFC0B', "ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM");
    map.put('\uFC0C', "ARABIC LIGATURE TEH WITH HAH ISOLATED FORM");
    map.put('\uFC0D', "ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM");
    map.put('\uFC0E', "ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM");
    map.put('\uFC0F', "ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC10', "ARABIC LIGATURE TEH WITH YEH ISOLATED FORM");
    map.put('\uFC11', "ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM");
    map.put('\uFC12', "ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM");
    map.put('\uFC13', "ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC14', "ARABIC LIGATURE THEH WITH YEH ISOLATED FORM");
    map.put('\uFC15', "ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM");
    map.put('\uFC16', "ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM");
    map.put('\uFC17', "ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM");
    map.put('\uFC18', "ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM");
    map.put('\uFC19', "ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM");
    map.put('\uFC1A', "ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM");
    map.put('\uFC1B', "ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM");
    map.put('\uFC1C', "ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM");
    map.put('\uFC1D', "ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM");
    map.put('\uFC1E', "ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM");
    map.put('\uFC1F', "ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM");
    map.put('\uFC20', "ARABIC LIGATURE SAD WITH HAH ISOLATED FORM");
    map.put('\uFC21', "ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM");
    map.put('\uFC22', "ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM");
    map.put('\uFC23', "ARABIC LIGATURE DAD WITH HAH ISOLATED FORM");
    map.put('\uFC24', "ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM");
    map.put('\uFC25', "ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM");
    map.put('\uFC26', "ARABIC LIGATURE TAH WITH HAH ISOLATED FORM");
    map.put('\uFC27', "ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM");
    map.put('\uFC28', "ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM");
    map.put('\uFC29', "ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM");
    map.put('\uFC2A', "ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM");
    map.put('\uFC2B', "ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM");
    map.put('\uFC2C', "ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM");
    map.put('\uFC2D', "ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM");
    map.put('\uFC2E', "ARABIC LIGATURE FEH WITH HAH ISOLATED FORM");
    map.put('\uFC2F', "ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM");
    map.put('\uFC30', "ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM");
    map.put('\uFC31', "ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC32', "ARABIC LIGATURE FEH WITH YEH ISOLATED FORM");
    map.put('\uFC33', "ARABIC LIGATURE QAF WITH HAH ISOLATED FORM");
    map.put('\uFC34', "ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM");
    map.put('\uFC35', "ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC36', "ARABIC LIGATURE QAF WITH YEH ISOLATED FORM");
    map.put('\uFC37', "ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM");
    map.put('\uFC38', "ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM");
    map.put('\uFC39', "ARABIC LIGATURE KAF WITH HAH ISOLATED FORM");
    map.put('\uFC3A', "ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM");
    map.put('\uFC3B', "ARABIC LIGATURE KAF WITH LAM ISOLATED FORM");
    map.put('\uFC3C', "ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM");
    map.put('\uFC3D', "ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC3E', "ARABIC LIGATURE KAF WITH YEH ISOLATED FORM");
    map.put('\uFC3F', "ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM");
    map.put('\uFC40', "ARABIC LIGATURE LAM WITH HAH ISOLATED FORM");
    map.put('\uFC41', "ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM");
    map.put('\uFC42', "ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM");
    map.put('\uFC43', "ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC44', "ARABIC LIGATURE LAM WITH YEH ISOLATED FORM");
    map.put('\uFC45', "ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM");
    map.put('\uFC46', "ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM");
    map.put('\uFC47', "ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM");
    map.put('\uFC48', "ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM");
    map.put('\uFC49', "ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC4A', "ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM");
    map.put('\uFC4B', "ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM");
    map.put('\uFC4C', "ARABIC LIGATURE NOON WITH HAH ISOLATED FORM");
    map.put('\uFC4D', "ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM");
    map.put('\uFC4E', "ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM");
    map.put('\uFC4F', "ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC50', "ARABIC LIGATURE NOON WITH YEH ISOLATED FORM");
    map.put('\uFC51', "ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM");
    map.put('\uFC52', "ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM");
    map.put('\uFC53', "ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC54', "ARABIC LIGATURE HEH WITH YEH ISOLATED FORM");
    map.put('\uFC55', "ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM");
    map.put('\uFC56', "ARABIC LIGATURE YEH WITH HAH ISOLATED FORM");
    map.put('\uFC57', "ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM");
    map.put('\uFC58', "ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM");
    map.put('\uFC59', "ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFC5A', "ARABIC LIGATURE YEH WITH YEH ISOLATED FORM");
    map.put('\uFC5B', "ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM");
    map.put('\uFC5C', "ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM");
    map.put('\uFC5D', "ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM");
    map.put('\uFC5E', "ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM");
    map.put('\uFC5F', "ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM");
    map.put('\uFC60', "ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM");
    map.put('\uFC61', "ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM");
    map.put('\uFC62', "ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM");
    map.put('\uFC63', "ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM");
    map.put('\uFC64', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM");
    map.put('\uFC65', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM");
    map.put('\uFC66', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM");
    map.put('\uFC67', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM");
    map.put('\uFC68', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC69', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM");
    map.put('\uFC6A', "ARABIC LIGATURE BEH WITH REH FINAL FORM");
    map.put('\uFC6B', "ARABIC LIGATURE BEH WITH ZAIN FINAL FORM");
    map.put('\uFC6C', "ARABIC LIGATURE BEH WITH MEEM FINAL FORM");
    map.put('\uFC6D', "ARABIC LIGATURE BEH WITH NOON FINAL FORM");
    map.put('\uFC6E', "ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC6F', "ARABIC LIGATURE BEH WITH YEH FINAL FORM");
    map.put('\uFC70', "ARABIC LIGATURE TEH WITH REH FINAL FORM");
    map.put('\uFC71', "ARABIC LIGATURE TEH WITH ZAIN FINAL FORM");
    map.put('\uFC72', "ARABIC LIGATURE TEH WITH MEEM FINAL FORM");
    map.put('\uFC73', "ARABIC LIGATURE TEH WITH NOON FINAL FORM");
    map.put('\uFC74', "ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC75', "ARABIC LIGATURE TEH WITH YEH FINAL FORM");
    map.put('\uFC76', "ARABIC LIGATURE THEH WITH REH FINAL FORM");
    map.put('\uFC77', "ARABIC LIGATURE THEH WITH ZAIN FINAL FORM");
    map.put('\uFC78', "ARABIC LIGATURE THEH WITH MEEM FINAL FORM");
    map.put('\uFC79', "ARABIC LIGATURE THEH WITH NOON FINAL FORM");
    map.put('\uFC7A', "ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC7B', "ARABIC LIGATURE THEH WITH YEH FINAL FORM");
    map.put('\uFC7C', "ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC7D', "ARABIC LIGATURE FEH WITH YEH FINAL FORM");
    map.put('\uFC7E', "ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC7F', "ARABIC LIGATURE QAF WITH YEH FINAL FORM");
    map.put('\uFC80', "ARABIC LIGATURE KAF WITH ALEF FINAL FORM");
    map.put('\uFC81', "ARABIC LIGATURE KAF WITH LAM FINAL FORM");
    map.put('\uFC82', "ARABIC LIGATURE KAF WITH MEEM FINAL FORM");
    map.put('\uFC83', "ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC84', "ARABIC LIGATURE KAF WITH YEH FINAL FORM");
    map.put('\uFC85', "ARABIC LIGATURE LAM WITH MEEM FINAL FORM");
    map.put('\uFC86', "ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC87', "ARABIC LIGATURE LAM WITH YEH FINAL FORM");
    map.put('\uFC88', "ARABIC LIGATURE MEEM WITH ALEF FINAL FORM");
    map.put('\uFC89', "ARABIC LIGATURE MEEM WITH MEEM FINAL FORM");
    map.put('\uFC8A', "ARABIC LIGATURE NOON WITH REH FINAL FORM");
    map.put('\uFC8B', "ARABIC LIGATURE NOON WITH ZAIN FINAL FORM");
    map.put('\uFC8C', "ARABIC LIGATURE NOON WITH MEEM FINAL FORM");
    map.put('\uFC8D', "ARABIC LIGATURE NOON WITH NOON FINAL FORM");
    map.put('\uFC8E', "ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC8F', "ARABIC LIGATURE NOON WITH YEH FINAL FORM");
    map.put('\uFC90', "ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM");
    map.put('\uFC91', "ARABIC LIGATURE YEH WITH REH FINAL FORM");
    map.put('\uFC92', "ARABIC LIGATURE YEH WITH ZAIN FINAL FORM");
    map.put('\uFC93', "ARABIC LIGATURE YEH WITH MEEM FINAL FORM");
    map.put('\uFC94', "ARABIC LIGATURE YEH WITH NOON FINAL FORM");
    map.put('\uFC95', "ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFC96', "ARABIC LIGATURE YEH WITH YEH FINAL FORM");
    map.put('\uFC97', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM");
    map.put('\uFC98', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM");
    map.put('\uFC99', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM");
    map.put('\uFC9A', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM");
    map.put('\uFC9B', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM");
    map.put('\uFC9C', "ARABIC LIGATURE BEH WITH JEEM INITIAL FORM");
    map.put('\uFC9D', "ARABIC LIGATURE BEH WITH HAH INITIAL FORM");
    map.put('\uFC9E', "ARABIC LIGATURE BEH WITH KHAH INITIAL FORM");
    map.put('\uFC9F', "ARABIC LIGATURE BEH WITH MEEM INITIAL FORM");
    map.put('\uFCA0', "ARABIC LIGATURE BEH WITH HEH INITIAL FORM");
    map.put('\uFCA1', "ARABIC LIGATURE TEH WITH JEEM INITIAL FORM");
    map.put('\uFCA2', "ARABIC LIGATURE TEH WITH HAH INITIAL FORM");
    map.put('\uFCA3', "ARABIC LIGATURE TEH WITH KHAH INITIAL FORM");
    map.put('\uFCA4', "ARABIC LIGATURE TEH WITH MEEM INITIAL FORM");
    map.put('\uFCA5', "ARABIC LIGATURE TEH WITH HEH INITIAL FORM");
    map.put('\uFCA6', "ARABIC LIGATURE THEH WITH MEEM INITIAL FORM");
    map.put('\uFCA7', "ARABIC LIGATURE JEEM WITH HAH INITIAL FORM");
    map.put('\uFCA8', "ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM");
    map.put('\uFCA9', "ARABIC LIGATURE HAH WITH JEEM INITIAL FORM");
    map.put('\uFCAA', "ARABIC LIGATURE HAH WITH MEEM INITIAL FORM");
    map.put('\uFCAB', "ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM");
    map.put('\uFCAC', "ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM");
    map.put('\uFCAD', "ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM");
    map.put('\uFCAE', "ARABIC LIGATURE SEEN WITH HAH INITIAL FORM");
    map.put('\uFCAF', "ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM");
    map.put('\uFCB0', "ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM");
    map.put('\uFCB1', "ARABIC LIGATURE SAD WITH HAH INITIAL FORM");
    map.put('\uFCB2', "ARABIC LIGATURE SAD WITH KHAH INITIAL FORM");
    map.put('\uFCB3', "ARABIC LIGATURE SAD WITH MEEM INITIAL FORM");
    map.put('\uFCB4', "ARABIC LIGATURE DAD WITH JEEM INITIAL FORM");
    map.put('\uFCB5', "ARABIC LIGATURE DAD WITH HAH INITIAL FORM");
    map.put('\uFCB6', "ARABIC LIGATURE DAD WITH KHAH INITIAL FORM");
    map.put('\uFCB7', "ARABIC LIGATURE DAD WITH MEEM INITIAL FORM");
    map.put('\uFCB8', "ARABIC LIGATURE TAH WITH HAH INITIAL FORM");
    map.put('\uFCB9', "ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM");
    map.put('\uFCBA', "ARABIC LIGATURE AIN WITH JEEM INITIAL FORM");
    map.put('\uFCBB', "ARABIC LIGATURE AIN WITH MEEM INITIAL FORM");
    map.put('\uFCBC', "ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM");
    map.put('\uFCBD', "ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM");
    map.put('\uFCBE', "ARABIC LIGATURE FEH WITH JEEM INITIAL FORM");
    map.put('\uFCBF', "ARABIC LIGATURE FEH WITH HAH INITIAL FORM");
    map.put('\uFCC0', "ARABIC LIGATURE FEH WITH KHAH INITIAL FORM");
    map.put('\uFCC1', "ARABIC LIGATURE FEH WITH MEEM INITIAL FORM");
    map.put('\uFCC2', "ARABIC LIGATURE QAF WITH HAH INITIAL FORM");
    map.put('\uFCC3', "ARABIC LIGATURE QAF WITH MEEM INITIAL FORM");
    map.put('\uFCC4', "ARABIC LIGATURE KAF WITH JEEM INITIAL FORM");
    map.put('\uFCC5', "ARABIC LIGATURE KAF WITH HAH INITIAL FORM");
    map.put('\uFCC6', "ARABIC LIGATURE KAF WITH KHAH INITIAL FORM");
    map.put('\uFCC7', "ARABIC LIGATURE KAF WITH LAM INITIAL FORM");
    map.put('\uFCC8', "ARABIC LIGATURE KAF WITH MEEM INITIAL FORM");
    map.put('\uFCC9', "ARABIC LIGATURE LAM WITH JEEM INITIAL FORM");
    map.put('\uFCCA', "ARABIC LIGATURE LAM WITH HAH INITIAL FORM");
    map.put('\uFCCB', "ARABIC LIGATURE LAM WITH KHAH INITIAL FORM");
    map.put('\uFCCC', "ARABIC LIGATURE LAM WITH MEEM INITIAL FORM");
    map.put('\uFCCD', "ARABIC LIGATURE LAM WITH HEH INITIAL FORM");
    map.put('\uFCCE', "ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM");
    map.put('\uFCCF', "ARABIC LIGATURE MEEM WITH HAH INITIAL FORM");
    map.put('\uFCD0', "ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM");
    map.put('\uFCD1', "ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM");
    map.put('\uFCD2', "ARABIC LIGATURE NOON WITH JEEM INITIAL FORM");
    map.put('\uFCD3', "ARABIC LIGATURE NOON WITH HAH INITIAL FORM");
    map.put('\uFCD4', "ARABIC LIGATURE NOON WITH KHAH INITIAL FORM");
    map.put('\uFCD5', "ARABIC LIGATURE NOON WITH MEEM INITIAL FORM");
    map.put('\uFCD6', "ARABIC LIGATURE NOON WITH HEH INITIAL FORM");
    map.put('\uFCD7', "ARABIC LIGATURE HEH WITH JEEM INITIAL FORM");
    map.put('\uFCD8', "ARABIC LIGATURE HEH WITH MEEM INITIAL FORM");
    map.put('\uFCD9', "ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM");
    map.put('\uFCDA', "ARABIC LIGATURE YEH WITH JEEM INITIAL FORM");
    map.put('\uFCDB', "ARABIC LIGATURE YEH WITH HAH INITIAL FORM");
    map.put('\uFCDC', "ARABIC LIGATURE YEH WITH KHAH INITIAL FORM");
    map.put('\uFCDD', "ARABIC LIGATURE YEH WITH MEEM INITIAL FORM");
    map.put('\uFCDE', "ARABIC LIGATURE YEH WITH HEH INITIAL FORM");
    map.put('\uFCDF', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM");
    map.put('\uFCE0', "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM");
    map.put('\uFCE1', "ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM");
    map.put('\uFCE2', "ARABIC LIGATURE BEH WITH HEH MEDIAL FORM");
    map.put('\uFCE3', "ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM");
    map.put('\uFCE4', "ARABIC LIGATURE TEH WITH HEH MEDIAL FORM");
    map.put('\uFCE5', "ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM");
    map.put('\uFCE6', "ARABIC LIGATURE THEH WITH HEH MEDIAL FORM");
    map.put('\uFCE7', "ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM");
    map.put('\uFCE8', "ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM");
    map.put('\uFCE9', "ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM");
    map.put('\uFCEA', "ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM");
    map.put('\uFCEB', "ARABIC LIGATURE KAF WITH LAM MEDIAL FORM");
    map.put('\uFCEC', "ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM");
    map.put('\uFCED', "ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM");
    map.put('\uFCEE', "ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM");
    map.put('\uFCEF', "ARABIC LIGATURE NOON WITH HEH MEDIAL FORM");
    map.put('\uFCF0', "ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM");
    map.put('\uFCF1', "ARABIC LIGATURE YEH WITH HEH MEDIAL FORM");
    map.put('\uFCF2', "ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM");
    map.put('\uFCF3', "ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM");
    map.put('\uFCF4', "ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM");
    map.put('\uFCF5', "ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFCF6', "ARABIC LIGATURE TAH WITH YEH ISOLATED FORM");
    map.put('\uFCF7', "ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFCF8', "ARABIC LIGATURE AIN WITH YEH ISOLATED FORM");
    map.put('\uFCF9', "ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFCFA', "ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM");
    map.put('\uFCFB', "ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFCFC', "ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM");
    map.put('\uFCFD', "ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFCFE', "ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM");
    map.put('\uFCFF', "ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFD00', "ARABIC LIGATURE HAH WITH YEH ISOLATED FORM");
    map.put('\uFD01', "ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFD02', "ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM");
    map.put('\uFD03', "ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFD04', "ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM");
    map.put('\uFD05', "ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFD06', "ARABIC LIGATURE SAD WITH YEH ISOLATED FORM");
    map.put('\uFD07', "ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM");
    map.put('\uFD08', "ARABIC LIGATURE DAD WITH YEH ISOLATED FORM");
    map.put('\uFD09', "ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM");
    map.put('\uFD0A', "ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM");
    map.put('\uFD0B', "ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM");
    map.put('\uFD0C', "ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM");
    map.put('\uFD0D', "ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM");
    map.put('\uFD0E', "ARABIC LIGATURE SEEN WITH REH ISOLATED FORM");
    map.put('\uFD0F', "ARABIC LIGATURE SAD WITH REH ISOLATED FORM");
    map.put('\uFD10', "ARABIC LIGATURE DAD WITH REH ISOLATED FORM");
    map.put('\uFD11', "ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD12', "ARABIC LIGATURE TAH WITH YEH FINAL FORM");
    map.put('\uFD13', "ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD14', "ARABIC LIGATURE AIN WITH YEH FINAL FORM");
    map.put('\uFD15', "ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD16', "ARABIC LIGATURE GHAIN WITH YEH FINAL FORM");
    map.put('\uFD17', "ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD18', "ARABIC LIGATURE SEEN WITH YEH FINAL FORM");
    map.put('\uFD19', "ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD1A', "ARABIC LIGATURE SHEEN WITH YEH FINAL FORM");
    map.put('\uFD1B', "ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD1C', "ARABIC LIGATURE HAH WITH YEH FINAL FORM");
    map.put('\uFD1D', "ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD1E', "ARABIC LIGATURE JEEM WITH YEH FINAL FORM");
    map.put('\uFD1F', "ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD20', "ARABIC LIGATURE KHAH WITH YEH FINAL FORM");
    map.put('\uFD21', "ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD22', "ARABIC LIGATURE SAD WITH YEH FINAL FORM");
    map.put('\uFD23', "ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD24', "ARABIC LIGATURE DAD WITH YEH FINAL FORM");
    map.put('\uFD25', "ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM");
    map.put('\uFD26', "ARABIC LIGATURE SHEEN WITH HAH FINAL FORM");
    map.put('\uFD27', "ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM");
    map.put('\uFD28', "ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM");
    map.put('\uFD29', "ARABIC LIGATURE SHEEN WITH REH FINAL FORM");
    map.put('\uFD2A', "ARABIC LIGATURE SEEN WITH REH FINAL FORM");
    map.put('\uFD2B', "ARABIC LIGATURE SAD WITH REH FINAL FORM");
    map.put('\uFD2C', "ARABIC LIGATURE DAD WITH REH FINAL FORM");
    map.put('\uFD2D', "ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM");
    map.put('\uFD2E', "ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM");
    map.put('\uFD2F', "ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM");
    map.put('\uFD30', "ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM");
    map.put('\uFD31', "ARABIC LIGATURE SEEN WITH HEH INITIAL FORM");
    map.put('\uFD32', "ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM");
    map.put('\uFD33', "ARABIC LIGATURE TAH WITH MEEM INITIAL FORM");
    map.put('\uFD34', "ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM");
    map.put('\uFD35', "ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM");
    map.put('\uFD36', "ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM");
    map.put('\uFD37', "ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM");
    map.put('\uFD38', "ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM");
    map.put('\uFD39', "ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM");
    map.put('\uFD3A', "ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM");
    map.put('\uFD3B', "ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM");
    map.put('\uFD3C', "ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM");
    map.put('\uFD3D', "ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM");
    map.put('\uFD3E', "ORNATE LEFT PARENTHESIS");
    map.put('\uFD3F', "ORNATE RIGHT PARENTHESIS");
    map.put('\uFD50', "ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM");
    map.put('\uFD51', "ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM");
    map.put('\uFD52', "ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM");
    map.put('\uFD53', "ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM");
    map.put('\uFD54', "ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM");
    map.put('\uFD55', "ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM");
    map.put('\uFD56', "ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM");
    map.put('\uFD57', "ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM");
    map.put('\uFD58', "ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM");
    map.put('\uFD59', "ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM");
    map.put('\uFD5A', "ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFD5B', "ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD5C', "ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM");
    map.put('\uFD5D', "ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM");
    map.put('\uFD5E', "ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD5F', "ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM");
    map.put('\uFD60', "ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM");
    map.put('\uFD61', "ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM");
    map.put('\uFD62', "ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD63', "ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFD64', "ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM");
    map.put('\uFD65', "ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM");
    map.put('\uFD66', "ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD67', "ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM");
    map.put('\uFD68', "ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM");
    map.put('\uFD69', "ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFD6A', "ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM");
    map.put('\uFD6B', "ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM");
    map.put('\uFD6C', "ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD6D', "ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFD6E', "ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD6F', "ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM");
    map.put('\uFD70', "ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM");
    map.put('\uFD71', "ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM");
    map.put('\uFD72', "ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM");
    map.put('\uFD73', "ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFD74', "ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFD75', "ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM");
    map.put('\uFD76', "ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD77', "ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFD78', "ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD79', "ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD7A', "ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFD7B', "ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD7C', "ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM");
    map.put('\uFD7D', "ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM");
    map.put('\uFD7E', "ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM");
    map.put('\uFD7F', "ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD80', "ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM");
    map.put('\uFD81', "ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM");
    map.put('\uFD82', "ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD83', "ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM");
    map.put('\uFD84', "ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM");
    map.put('\uFD85', "ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM");
    map.put('\uFD86', "ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM");
    map.put('\uFD87', "ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM");
    map.put('\uFD88', "ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM");
    map.put('\uFD89', "ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM");
    map.put('\uFD8A', "ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM");
    map.put('\uFD8B', "ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM");
    map.put('\uFD8C', "ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM");
    map.put('\uFD8D', "ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM");
    map.put('\uFD8E', "ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM");
    map.put('\uFD8F', "ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM");
    map.put('\uFD92', "ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM");
    map.put('\uFD93', "ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM");
    map.put('\uFD94', "ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFD95', "ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM");
    map.put('\uFD96', "ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD97', "ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM");
    map.put('\uFD98', "ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM");
    map.put('\uFD99', "ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD9A', "ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFD9B', "ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFD9C', "ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFD9D', "ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFD9E', "ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM");
    map.put('\uFD9F', "ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFDA0', "ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFDA1', "ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM");
    map.put('\uFDA2', "ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFDA3', "ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDA4', "ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFDA5', "ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDA6', "ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFDA7', "ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFDA8', "ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM");
    map.put('\uFDA9', "ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDAA', "ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDAB', "ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDAC', "ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFDAD', "ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDAE', "ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDAF', "ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFDB0', "ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDB1', "ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDB2', "ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDB3', "ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDB4', "ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM");
    map.put('\uFDB5', "ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM");
    map.put('\uFDB6', "ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDB7', "ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDB8', "ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM");
    map.put('\uFDB9', "ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM");
    map.put('\uFDBA', "ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM");
    map.put('\uFDBB', "ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM");
    map.put('\uFDBC', "ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM");
    map.put('\uFDBD', "ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM");
    map.put('\uFDBE', "ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDBF', "ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFDC0', "ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFDC1', "ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM");
    map.put('\uFDC2', "ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM");
    map.put('\uFDC3', "ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFDC4', "ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM");
    map.put('\uFDC5', "ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM");
    map.put('\uFDC6', "ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM");
    map.put('\uFDC7', "ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM");
    map.put('\uFDD0', "<not a character>");
    map.put('\uFDD1', "<not a character>");
    map.put('\uFDD2', "<not a character>");
    map.put('\uFDD3', "<not a character>");
    map.put('\uFDD4', "<not a character>");
    map.put('\uFDD5', "<not a character>");
    map.put('\uFDD6', "<not a character>");
    map.put('\uFDD7', "<not a character>");
    map.put('\uFDD8', "<not a character>");
    map.put('\uFDD9', "<not a character>");
    map.put('\uFDDA', "<not a character>");
    map.put('\uFDDB', "<not a character>");
    map.put('\uFDDC', "<not a character>");
    map.put('\uFDDD', "<not a character>");
    map.put('\uFDDE', "<not a character>");
    map.put('\uFDDF', "<not a character>");
    map.put('\uFDE0', "<not a character>");
    map.put('\uFDE1', "<not a character>");
    map.put('\uFDE2', "<not a character>");
    map.put('\uFDE3', "<not a character>");
    map.put('\uFDE4', "<not a character>");
    map.put('\uFDE5', "<not a character>");
    map.put('\uFDE6', "<not a character>");
    map.put('\uFDE7', "<not a character>");
    map.put('\uFDE8', "<not a character>");
    map.put('\uFDE9', "<not a character>");
    map.put('\uFDEA', "<not a character>");
    map.put('\uFDEB', "<not a character>");
    map.put('\uFDEC', "<not a character>");
    map.put('\uFDED', "<not a character>");
    map.put('\uFDEE', "<not a character>");
    map.put('\uFDEF', "<not a character>");
    map.put('\uFDF0', "ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM");
    map.put('\uFDF1', "ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM");
    map.put('\uFDF2', "ARABIC LIGATURE ALLAH ISOLATED FORM");
    map.put('\uFDF3', "ARABIC LIGATURE AKBAR ISOLATED FORM");
    map.put('\uFDF4', "ARABIC LIGATURE MOHAMMAD ISOLATED FORM");
    map.put('\uFDF5', "ARABIC LIGATURE SALAM ISOLATED FORM");
    map.put('\uFDF6', "ARABIC LIGATURE RASOUL ISOLATED FORM");
    map.put('\uFDF7', "ARABIC LIGATURE ALAYHE ISOLATED FORM");
    map.put('\uFDF8', "ARABIC LIGATURE WASALLAM ISOLATED FORM");
    map.put('\uFDF9', "ARABIC LIGATURE SALLA ISOLATED FORM");
    map.put('\uFDFA', "ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM");
    map.put('\uFDFB', "ARABIC LIGATURE JALLAJALALOUHOU");
    map.put('\uFDFC', "RIAL SIGN");
    map.put('\uFDFD', "ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM");
    map.put('\uFE00', "VARIATION SELECTOR-1");
    map.put('\uFE01', "VARIATION SELECTOR-2");
    map.put('\uFE02', "VARIATION SELECTOR-3");
    map.put('\uFE03', "VARIATION SELECTOR-4");
    map.put('\uFE04', "VARIATION SELECTOR-5");
    map.put('\uFE05', "VARIATION SELECTOR-6");
    map.put('\uFE06', "VARIATION SELECTOR-7");
    map.put('\uFE07', "VARIATION SELECTOR-8");
    map.put('\uFE08', "VARIATION SELECTOR-9");
    map.put('\uFE09', "VARIATION SELECTOR-10");
    map.put('\uFE0A', "VARIATION SELECTOR-11");
    map.put('\uFE0B', "VARIATION SELECTOR-12");
    map.put('\uFE0C', "VARIATION SELECTOR-13");
    map.put('\uFE0D', "VARIATION SELECTOR-14");
    map.put('\uFE0E', "VARIATION SELECTOR-15");
    map.put('\uFE0F', "VARIATION SELECTOR-16");
    map.put('\uFE10', "PRESENTATION FORM FOR VERTICAL COMMA");
    map.put('\uFE11', "PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA");
    map.put('\uFE12', "PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP");
    map.put('\uFE13', "PRESENTATION FORM FOR VERTICAL COLON");
    map.put('\uFE14', "PRESENTATION FORM FOR VERTICAL SEMICOLON");
    map.put('\uFE15', "PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK");
    map.put('\uFE16', "PRESENTATION FORM FOR VERTICAL QUESTION MARK");
    map.put('\uFE17', "PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET");
    map.put('\uFE18', "PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET");
    map.put('\uFE19', "PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS");
    map.put('\uFE20', "COMBINING LIGATURE LEFT HALF");
    map.put('\uFE21', "COMBINING LIGATURE RIGHT HALF");
    map.put('\uFE22', "COMBINING DOUBLE TILDE LEFT HALF");
    map.put('\uFE23', "COMBINING DOUBLE TILDE RIGHT HALF");
    map.put('\uFE24', "COMBINING MACRON LEFT HALF");
    map.put('\uFE25', "COMBINING MACRON RIGHT HALF");
    map.put('\uFE26', "COMBINING CONJOINING MACRON");
    map.put('\uFE30', "PRESENTATION FORM FOR VERTICAL TWO DOT LEADER");
    map.put('\uFE31', "PRESENTATION FORM FOR VERTICAL EM DASH");
    map.put('\uFE32', "PRESENTATION FORM FOR VERTICAL EN DASH");
    map.put('\uFE33', "PRESENTATION FORM FOR VERTICAL LOW LINE");
    map.put('\uFE34', "PRESENTATION FORM FOR VERTICAL WAVY LOW LINE");
    map.put('\uFE35', "PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS");
    map.put('\uFE36', "PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS");
    map.put('\uFE37', "PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET");
    map.put('\uFE38', "PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET");
    map.put('\uFE39', "PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET");
    map.put('\uFE3A', "PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET");
    map.put('\uFE3B', "PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET");
    map.put('\uFE3C', "PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET");
    map.put('\uFE3D', "PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET");
    map.put('\uFE3E', "PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET");
    map.put('\uFE3F', "PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET");
    map.put('\uFE40', "PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET");
    map.put('\uFE41', "PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET");
    map.put('\uFE42', "PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET");
    map.put('\uFE43', "PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET");
    map.put('\uFE44', "PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET");
    map.put('\uFE45', "SESAME DOT");
    map.put('\uFE46', "WHITE SESAME DOT");
    map.put('\uFE47', "PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET");
    map.put('\uFE48', "PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET");
    map.put('\uFE49', "DASHED OVERLINE");
    map.put('\uFE4A', "CENTRELINE OVERLINE");
    map.put('\uFE4B', "WAVY OVERLINE");
    map.put('\uFE4C', "DOUBLE WAVY OVERLINE");
    map.put('\uFE4D', "DASHED LOW LINE");
    map.put('\uFE4E', "CENTRELINE LOW LINE");
    map.put('\uFE4F', "WAVY LOW LINE");
    map.put('\uFE50', "SMALL COMMA");
    map.put('\uFE51', "SMALL IDEOGRAPHIC COMMA");
    map.put('\uFE52', "SMALL FULL STOP");
    map.put('\uFE54', "SMALL SEMICOLON");
    map.put('\uFE55', "SMALL COLON");
    map.put('\uFE56', "SMALL QUESTION MARK");
    map.put('\uFE57', "SMALL EXCLAMATION MARK");
    map.put('\uFE58', "SMALL EM DASH");
    map.put('\uFE59', "SMALL LEFT PARENTHESIS");
    map.put('\uFE5A', "SMALL RIGHT PARENTHESIS");
    map.put('\uFE5B', "SMALL LEFT CURLY BRACKET");
    map.put('\uFE5C', "SMALL RIGHT CURLY BRACKET");
    map.put('\uFE5D', "SMALL LEFT TORTOISE SHELL BRACKET");
    map.put('\uFE5E', "SMALL RIGHT TORTOISE SHELL BRACKET");
    map.put('\uFE5F', "SMALL NUMBER SIGN");
    map.put('\uFE60', "SMALL AMPERSAND");
    map.put('\uFE61', "SMALL ASTERISK");
    map.put('\uFE62', "SMALL PLUS SIGN");
    map.put('\uFE63', "SMALL HYPHEN-MINUS");
    map.put('\uFE64', "SMALL LESS-THAN SIGN");
    map.put('\uFE65', "SMALL GREATER-THAN SIGN");
    map.put('\uFE66', "SMALL EQUALS SIGN");
    map.put('\uFE68', "SMALL REVERSE SOLIDUS");
    map.put('\uFE69', "SMALL DOLLAR SIGN");
    map.put('\uFE6A', "SMALL PERCENT SIGN");
    map.put('\uFE6B', "SMALL COMMERCIAL AT");
    map.put('\uFE70', "ARABIC FATHATAN ISOLATED FORM");
    map.put('\uFE71', "ARABIC TATWEEL WITH FATHATAN ABOVE");
    map.put('\uFE72', "ARABIC DAMMATAN ISOLATED FORM");
    map.put('\uFE73', "ARABIC TAIL FRAGMENT");
    map.put('\uFE74', "ARABIC KASRATAN ISOLATED FORM");
    map.put('\uFE76', "ARABIC FATHA ISOLATED FORM");
    map.put('\uFE77', "ARABIC FATHA MEDIAL FORM");
    map.put('\uFE78', "ARABIC DAMMA ISOLATED FORM");
    map.put('\uFE79', "ARABIC DAMMA MEDIAL FORM");
    map.put('\uFE7A', "ARABIC KASRA ISOLATED FORM");
    map.put('\uFE7B', "ARABIC KASRA MEDIAL FORM");
    map.put('\uFE7C', "ARABIC SHADDA ISOLATED FORM");
    map.put('\uFE7D', "ARABIC SHADDA MEDIAL FORM");
    map.put('\uFE7E', "ARABIC SUKUN ISOLATED FORM");
    map.put('\uFE7F', "ARABIC SUKUN MEDIAL FORM");
    map.put('\uFE80', "ARABIC LETTER HAMZA ISOLATED FORM");
    map.put('\uFE81', "ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM");
    map.put('\uFE82', "ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM");
    map.put('\uFE83', "ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM");
    map.put('\uFE84', "ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM");
    map.put('\uFE85', "ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM");
    map.put('\uFE86', "ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM");
    map.put('\uFE87', "ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM");
    map.put('\uFE88', "ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM");
    map.put('\uFE89', "ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM");
    map.put('\uFE8A', "ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM");
    map.put('\uFE8B', "ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM");
    map.put('\uFE8C', "ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM");
    map.put('\uFE8D', "ARABIC LETTER ALEF ISOLATED FORM");
    map.put('\uFE8E', "ARABIC LETTER ALEF FINAL FORM");
    map.put('\uFE8F', "ARABIC LETTER BEH ISOLATED FORM");
    map.put('\uFE90', "ARABIC LETTER BEH FINAL FORM");
    map.put('\uFE91', "ARABIC LETTER BEH INITIAL FORM");
    map.put('\uFE92', "ARABIC LETTER BEH MEDIAL FORM");
    map.put('\uFE93', "ARABIC LETTER TEH MARBUTA ISOLATED FORM");
    map.put('\uFE94', "ARABIC LETTER TEH MARBUTA FINAL FORM");
    map.put('\uFE95', "ARABIC LETTER TEH ISOLATED FORM");
    map.put('\uFE96', "ARABIC LETTER TEH FINAL FORM");
    map.put('\uFE97', "ARABIC LETTER TEH INITIAL FORM");
    map.put('\uFE98', "ARABIC LETTER TEH MEDIAL FORM");
    map.put('\uFE99', "ARABIC LETTER THEH ISOLATED FORM");
    map.put('\uFE9A', "ARABIC LETTER THEH FINAL FORM");
    map.put('\uFE9B', "ARABIC LETTER THEH INITIAL FORM");
    map.put('\uFE9C', "ARABIC LETTER THEH MEDIAL FORM");
    map.put('\uFE9D', "ARABIC LETTER JEEM ISOLATED FORM");
    map.put('\uFE9E', "ARABIC LETTER JEEM FINAL FORM");
    map.put('\uFE9F', "ARABIC LETTER JEEM INITIAL FORM");
    map.put('\uFEA0', "ARABIC LETTER JEEM MEDIAL FORM");
    map.put('\uFEA1', "ARABIC LETTER HAH ISOLATED FORM");
    map.put('\uFEA2', "ARABIC LETTER HAH FINAL FORM");
    map.put('\uFEA3', "ARABIC LETTER HAH INITIAL FORM");
    map.put('\uFEA4', "ARABIC LETTER HAH MEDIAL FORM");
    map.put('\uFEA5', "ARABIC LETTER KHAH ISOLATED FORM");
    map.put('\uFEA6', "ARABIC LETTER KHAH FINAL FORM");
    map.put('\uFEA7', "ARABIC LETTER KHAH INITIAL FORM");
    map.put('\uFEA8', "ARABIC LETTER KHAH MEDIAL FORM");
    map.put('\uFEA9', "ARABIC LETTER DAL ISOLATED FORM");
    map.put('\uFEAA', "ARABIC LETTER DAL FINAL FORM");
    map.put('\uFEAB', "ARABIC LETTER THAL ISOLATED FORM");
    map.put('\uFEAC', "ARABIC LETTER THAL FINAL FORM");
    map.put('\uFEAD', "ARABIC LETTER REH ISOLATED FORM");
    map.put('\uFEAE', "ARABIC LETTER REH FINAL FORM");
    map.put('\uFEAF', "ARABIC LETTER ZAIN ISOLATED FORM");
    map.put('\uFEB0', "ARABIC LETTER ZAIN FINAL FORM");
    map.put('\uFEB1', "ARABIC LETTER SEEN ISOLATED FORM");
    map.put('\uFEB2', "ARABIC LETTER SEEN FINAL FORM");
    map.put('\uFEB3', "ARABIC LETTER SEEN INITIAL FORM");
    map.put('\uFEB4', "ARABIC LETTER SEEN MEDIAL FORM");
    map.put('\uFEB5', "ARABIC LETTER SHEEN ISOLATED FORM");
    map.put('\uFEB6', "ARABIC LETTER SHEEN FINAL FORM");
    map.put('\uFEB7', "ARABIC LETTER SHEEN INITIAL FORM");
    map.put('\uFEB8', "ARABIC LETTER SHEEN MEDIAL FORM");
    map.put('\uFEB9', "ARABIC LETTER SAD ISOLATED FORM");
    map.put('\uFEBA', "ARABIC LETTER SAD FINAL FORM");
    map.put('\uFEBB', "ARABIC LETTER SAD INITIAL FORM");
    map.put('\uFEBC', "ARABIC LETTER SAD MEDIAL FORM");
    map.put('\uFEBD', "ARABIC LETTER DAD ISOLATED FORM");
    map.put('\uFEBE', "ARABIC LETTER DAD FINAL FORM");
    map.put('\uFEBF', "ARABIC LETTER DAD INITIAL FORM");
    map.put('\uFEC0', "ARABIC LETTER DAD MEDIAL FORM");
    map.put('\uFEC1', "ARABIC LETTER TAH ISOLATED FORM");
    map.put('\uFEC2', "ARABIC LETTER TAH FINAL FORM");
    map.put('\uFEC3', "ARABIC LETTER TAH INITIAL FORM");
    map.put('\uFEC4', "ARABIC LETTER TAH MEDIAL FORM");
    map.put('\uFEC5', "ARABIC LETTER ZAH ISOLATED FORM");
    map.put('\uFEC6', "ARABIC LETTER ZAH FINAL FORM");
    map.put('\uFEC7', "ARABIC LETTER ZAH INITIAL FORM");
    map.put('\uFEC8', "ARABIC LETTER ZAH MEDIAL FORM");
    map.put('\uFEC9', "ARABIC LETTER AIN ISOLATED FORM");
    map.put('\uFECA', "ARABIC LETTER AIN FINAL FORM");
    map.put('\uFECB', "ARABIC LETTER AIN INITIAL FORM");
    map.put('\uFECC', "ARABIC LETTER AIN MEDIAL FORM");
    map.put('\uFECD', "ARABIC LETTER GHAIN ISOLATED FORM");
    map.put('\uFECE', "ARABIC LETTER GHAIN FINAL FORM");
    map.put('\uFECF', "ARABIC LETTER GHAIN INITIAL FORM");
    map.put('\uFED0', "ARABIC LETTER GHAIN MEDIAL FORM");
    map.put('\uFED1', "ARABIC LETTER FEH ISOLATED FORM");
    map.put('\uFED2', "ARABIC LETTER FEH FINAL FORM");
    map.put('\uFED3', "ARABIC LETTER FEH INITIAL FORM");
    map.put('\uFED4', "ARABIC LETTER FEH MEDIAL FORM");
    map.put('\uFED5', "ARABIC LETTER QAF ISOLATED FORM");
    map.put('\uFED6', "ARABIC LETTER QAF FINAL FORM");
    map.put('\uFED7', "ARABIC LETTER QAF INITIAL FORM");
    map.put('\uFED8', "ARABIC LETTER QAF MEDIAL FORM");
    map.put('\uFED9', "ARABIC LETTER KAF ISOLATED FORM");
    map.put('\uFEDA', "ARABIC LETTER KAF FINAL FORM");
    map.put('\uFEDB', "ARABIC LETTER KAF INITIAL FORM");
    map.put('\uFEDC', "ARABIC LETTER KAF MEDIAL FORM");
    map.put('\uFEDD', "ARABIC LETTER LAM ISOLATED FORM");
    map.put('\uFEDE', "ARABIC LETTER LAM FINAL FORM");
    map.put('\uFEDF', "ARABIC LETTER LAM INITIAL FORM");
    map.put('\uFEE0', "ARABIC LETTER LAM MEDIAL FORM");
    map.put('\uFEE1', "ARABIC LETTER MEEM ISOLATED FORM");
    map.put('\uFEE2', "ARABIC LETTER MEEM FINAL FORM");
    map.put('\uFEE3', "ARABIC LETTER MEEM INITIAL FORM");
    map.put('\uFEE4', "ARABIC LETTER MEEM MEDIAL FORM");
    map.put('\uFEE5', "ARABIC LETTER NOON ISOLATED FORM");
    map.put('\uFEE6', "ARABIC LETTER NOON FINAL FORM");
    map.put('\uFEE7', "ARABIC LETTER NOON INITIAL FORM");
    map.put('\uFEE8', "ARABIC LETTER NOON MEDIAL FORM");
    map.put('\uFEE9', "ARABIC LETTER HEH ISOLATED FORM");
    map.put('\uFEEA', "ARABIC LETTER HEH FINAL FORM");
    map.put('\uFEEB', "ARABIC LETTER HEH INITIAL FORM");
    map.put('\uFEEC', "ARABIC LETTER HEH MEDIAL FORM");
    map.put('\uFEED', "ARABIC LETTER WAW ISOLATED FORM");
    map.put('\uFEEE', "ARABIC LETTER WAW FINAL FORM");
    map.put('\uFEEF', "ARABIC LETTER ALEF MAKSURA ISOLATED FORM");
    map.put('\uFEF0', "ARABIC LETTER ALEF MAKSURA FINAL FORM");
    map.put('\uFEF1', "ARABIC LETTER YEH ISOLATED FORM");
    map.put('\uFEF2', "ARABIC LETTER YEH FINAL FORM");
    map.put('\uFEF3', "ARABIC LETTER YEH INITIAL FORM");
    map.put('\uFEF4', "ARABIC LETTER YEH MEDIAL FORM");
    map.put('\uFEF5', "ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM");
    map.put('\uFEF6', "ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM");
    map.put('\uFEF7', "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM");
    map.put('\uFEF8', "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM");
    map.put('\uFEF9', "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM");
    map.put('\uFEFA', "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM");
    map.put('\uFEFB', "ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM");
    map.put('\uFEFC', "ARABIC LIGATURE LAM WITH ALEF FINAL FORM");
    map.put('\uFEFF', "ZERO WIDTH NO-BREAK SPACE");
    map.put('\uFF01', "FULLWIDTH EXCLAMATION MARK");
    map.put('\uFF02', "FULLWIDTH QUOTATION MARK");
    map.put('\uFF03', "FULLWIDTH NUMBER SIGN");
    map.put('\uFF04', "FULLWIDTH DOLLAR SIGN");
    map.put('\uFF05', "FULLWIDTH PERCENT SIGN");
    map.put('\uFF06', "FULLWIDTH AMPERSAND");
    map.put('\uFF07', "FULLWIDTH APOSTROPHE");
    map.put('\uFF08', "FULLWIDTH LEFT PARENTHESIS");
    map.put('\uFF09', "FULLWIDTH RIGHT PARENTHESIS");
    map.put('\uFF0A', "FULLWIDTH ASTERISK");
    map.put('\uFF0B', "FULLWIDTH PLUS SIGN");
    map.put('\uFF0C', "FULLWIDTH COMMA");
    map.put('\uFF0D', "FULLWIDTH HYPHEN-MINUS");
    map.put('\uFF0E', "FULLWIDTH FULL STOP");
    map.put('\uFF0F', "FULLWIDTH SOLIDUS");
    map.put('\uFF10', "FULLWIDTH DIGIT ZERO");
    map.put('\uFF11', "FULLWIDTH DIGIT ONE");
    map.put('\uFF12', "FULLWIDTH DIGIT TWO");
    map.put('\uFF13', "FULLWIDTH DIGIT THREE");
    map.put('\uFF14', "FULLWIDTH DIGIT FOUR");
    map.put('\uFF15', "FULLWIDTH DIGIT FIVE");
    map.put('\uFF16', "FULLWIDTH DIGIT SIX");
    map.put('\uFF17', "FULLWIDTH DIGIT SEVEN");
    map.put('\uFF18', "FULLWIDTH DIGIT EIGHT");
    map.put('\uFF19', "FULLWIDTH DIGIT NINE");
    map.put('\uFF1A', "FULLWIDTH COLON");
    map.put('\uFF1B', "FULLWIDTH SEMICOLON");
    map.put('\uFF1C', "FULLWIDTH LESS-THAN SIGN");
    map.put('\uFF1D', "FULLWIDTH EQUALS SIGN");
    map.put('\uFF1E', "FULLWIDTH GREATER-THAN SIGN");
    map.put('\uFF1F', "FULLWIDTH QUESTION MARK");
    map.put('\uFF20', "FULLWIDTH COMMERCIAL AT");
    map.put('\uFF21', "FULLWIDTH LATIN CAPITAL LETTER A");
    map.put('\uFF22', "FULLWIDTH LATIN CAPITAL LETTER B");
    map.put('\uFF23', "FULLWIDTH LATIN CAPITAL LETTER C");
    map.put('\uFF24', "FULLWIDTH LATIN CAPITAL LETTER D");
    map.put('\uFF25', "FULLWIDTH LATIN CAPITAL LETTER E");
    map.put('\uFF26', "FULLWIDTH LATIN CAPITAL LETTER F");
    map.put('\uFF27', "FULLWIDTH LATIN CAPITAL LETTER G");
    map.put('\uFF28', "FULLWIDTH LATIN CAPITAL LETTER H");
    map.put('\uFF29', "FULLWIDTH LATIN CAPITAL LETTER I");
    map.put('\uFF2A', "FULLWIDTH LATIN CAPITAL LETTER J");
    map.put('\uFF2B', "FULLWIDTH LATIN CAPITAL LETTER K");
    map.put('\uFF2C', "FULLWIDTH LATIN CAPITAL LETTER L");
    map.put('\uFF2D', "FULLWIDTH LATIN CAPITAL LETTER M");
    map.put('\uFF2E', "FULLWIDTH LATIN CAPITAL LETTER N");
    map.put('\uFF2F', "FULLWIDTH LATIN CAPITAL LETTER O");
    map.put('\uFF30', "FULLWIDTH LATIN CAPITAL LETTER P");
    map.put('\uFF31', "FULLWIDTH LATIN CAPITAL LETTER Q");
    map.put('\uFF32', "FULLWIDTH LATIN CAPITAL LETTER R");
    map.put('\uFF33', "FULLWIDTH LATIN CAPITAL LETTER S");
    map.put('\uFF34', "FULLWIDTH LATIN CAPITAL LETTER T");
    map.put('\uFF35', "FULLWIDTH LATIN CAPITAL LETTER U");
    map.put('\uFF36', "FULLWIDTH LATIN CAPITAL LETTER V");
    map.put('\uFF37', "FULLWIDTH LATIN CAPITAL LETTER W");
    map.put('\uFF38', "FULLWIDTH LATIN CAPITAL LETTER X");
    map.put('\uFF39', "FULLWIDTH LATIN CAPITAL LETTER Y");
    map.put('\uFF3A', "FULLWIDTH LATIN CAPITAL LETTER Z");
    map.put('\uFF3B', "FULLWIDTH LEFT SQUARE BRACKET");
    map.put('\uFF3C', "FULLWIDTH REVERSE SOLIDUS");
    map.put('\uFF3D', "FULLWIDTH RIGHT SQUARE BRACKET");
    map.put('\uFF3E', "FULLWIDTH CIRCUMFLEX ACCENT");
    map.put('\uFF3F', "FULLWIDTH LOW LINE");
    map.put('\uFF40', "FULLWIDTH GRAVE ACCENT");
    map.put('\uFF41', "FULLWIDTH LATIN SMALL LETTER A");
    map.put('\uFF42', "FULLWIDTH LATIN SMALL LETTER B");
    map.put('\uFF43', "FULLWIDTH LATIN SMALL LETTER C");
    map.put('\uFF44', "FULLWIDTH LATIN SMALL LETTER D");
    map.put('\uFF45', "FULLWIDTH LATIN SMALL LETTER E");
    map.put('\uFF46', "FULLWIDTH LATIN SMALL LETTER F");
    map.put('\uFF47', "FULLWIDTH LATIN SMALL LETTER G");
    map.put('\uFF48', "FULLWIDTH LATIN SMALL LETTER H");
    map.put('\uFF49', "FULLWIDTH LATIN SMALL LETTER I");
    map.put('\uFF4A', "FULLWIDTH LATIN SMALL LETTER J");
    map.put('\uFF4B', "FULLWIDTH LATIN SMALL LETTER K");
    map.put('\uFF4C', "FULLWIDTH LATIN SMALL LETTER L");
    map.put('\uFF4D', "FULLWIDTH LATIN SMALL LETTER M");
    map.put('\uFF4E', "FULLWIDTH LATIN SMALL LETTER N");
    map.put('\uFF4F', "FULLWIDTH LATIN SMALL LETTER O");
    map.put('\uFF50', "FULLWIDTH LATIN SMALL LETTER P");
    map.put('\uFF51', "FULLWIDTH LATIN SMALL LETTER Q");
    map.put('\uFF52', "FULLWIDTH LATIN SMALL LETTER R");
    map.put('\uFF53', "FULLWIDTH LATIN SMALL LETTER S");
    map.put('\uFF54', "FULLWIDTH LATIN SMALL LETTER T");
    map.put('\uFF55', "FULLWIDTH LATIN SMALL LETTER U");
    map.put('\uFF56', "FULLWIDTH LATIN SMALL LETTER V");
    map.put('\uFF57', "FULLWIDTH LATIN SMALL LETTER W");
    map.put('\uFF58', "FULLWIDTH LATIN SMALL LETTER X");
    map.put('\uFF59', "FULLWIDTH LATIN SMALL LETTER Y");
    map.put('\uFF5A', "FULLWIDTH LATIN SMALL LETTER Z");
    map.put('\uFF5B', "FULLWIDTH LEFT CURLY BRACKET");
    map.put('\uFF5C', "FULLWIDTH VERTICAL LINE");
    map.put('\uFF5D', "FULLWIDTH RIGHT CURLY BRACKET");
    map.put('\uFF5E', "FULLWIDTH TILDE");
    map.put('\uFF5F', "FULLWIDTH LEFT WHITE PARENTHESIS");
    map.put('\uFF60', "FULLWIDTH RIGHT WHITE PARENTHESIS");
    map.put('\uFF61', "HALFWIDTH IDEOGRAPHIC FULL STOP");
    map.put('\uFF62', "HALFWIDTH LEFT CORNER BRACKET");
    map.put('\uFF63', "HALFWIDTH RIGHT CORNER BRACKET");
    map.put('\uFF64', "HALFWIDTH IDEOGRAPHIC COMMA");
    map.put('\uFF65', "HALFWIDTH KATAKANA MIDDLE DOT");
    map.put('\uFF66', "HALFWIDTH KATAKANA LETTER WO");
    map.put('\uFF67', "HALFWIDTH KATAKANA LETTER SMALL A");
    map.put('\uFF68', "HALFWIDTH KATAKANA LETTER SMALL I");
    map.put('\uFF69', "HALFWIDTH KATAKANA LETTER SMALL U");
    map.put('\uFF6A', "HALFWIDTH KATAKANA LETTER SMALL E");
    map.put('\uFF6B', "HALFWIDTH KATAKANA LETTER SMALL O");
    map.put('\uFF6C', "HALFWIDTH KATAKANA LETTER SMALL YA");
    map.put('\uFF6D', "HALFWIDTH KATAKANA LETTER SMALL YU");
    map.put('\uFF6E', "HALFWIDTH KATAKANA LETTER SMALL YO");
    map.put('\uFF6F', "HALFWIDTH KATAKANA LETTER SMALL TU");
    map.put('\uFF70', "HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK");
    map.put('\uFF71', "HALFWIDTH KATAKANA LETTER A");
    map.put('\uFF72', "HALFWIDTH KATAKANA LETTER I");
    map.put('\uFF73', "HALFWIDTH KATAKANA LETTER U");
    map.put('\uFF74', "HALFWIDTH KATAKANA LETTER E");
    map.put('\uFF75', "HALFWIDTH KATAKANA LETTER O");
    map.put('\uFF76', "HALFWIDTH KATAKANA LETTER KA");
    map.put('\uFF77', "HALFWIDTH KATAKANA LETTER KI");
    map.put('\uFF78', "HALFWIDTH KATAKANA LETTER KU");
    map.put('\uFF79', "HALFWIDTH KATAKANA LETTER KE");
    map.put('\uFF7A', "HALFWIDTH KATAKANA LETTER KO");
    map.put('\uFF7B', "HALFWIDTH KATAKANA LETTER SA");
    map.put('\uFF7C', "HALFWIDTH KATAKANA LETTER SI");
    map.put('\uFF7D', "HALFWIDTH KATAKANA LETTER SU");
    map.put('\uFF7E', "HALFWIDTH KATAKANA LETTER SE");
    map.put('\uFF7F', "HALFWIDTH KATAKANA LETTER SO");
    map.put('\uFF80', "HALFWIDTH KATAKANA LETTER TA");
    map.put('\uFF81', "HALFWIDTH KATAKANA LETTER TI");
    map.put('\uFF82', "HALFWIDTH KATAKANA LETTER TU");
    map.put('\uFF83', "HALFWIDTH KATAKANA LETTER TE");
    map.put('\uFF84', "HALFWIDTH KATAKANA LETTER TO");
    map.put('\uFF85', "HALFWIDTH KATAKANA LETTER NA");
    map.put('\uFF86', "HALFWIDTH KATAKANA LETTER NI");
    map.put('\uFF87', "HALFWIDTH KATAKANA LETTER NU");
    map.put('\uFF88', "HALFWIDTH KATAKANA LETTER NE");
    map.put('\uFF89', "HALFWIDTH KATAKANA LETTER NO");
    map.put('\uFF8A', "HALFWIDTH KATAKANA LETTER HA");
    map.put('\uFF8B', "HALFWIDTH KATAKANA LETTER HI");
    map.put('\uFF8C', "HALFWIDTH KATAKANA LETTER HU");
    map.put('\uFF8D', "HALFWIDTH KATAKANA LETTER HE");
    map.put('\uFF8E', "HALFWIDTH KATAKANA LETTER HO");
    map.put('\uFF8F', "HALFWIDTH KATAKANA LETTER MA");
    map.put('\uFF90', "HALFWIDTH KATAKANA LETTER MI");
    map.put('\uFF91', "HALFWIDTH KATAKANA LETTER MU");
    map.put('\uFF92', "HALFWIDTH KATAKANA LETTER ME");
    map.put('\uFF93', "HALFWIDTH KATAKANA LETTER MO");
    map.put('\uFF94', "HALFWIDTH KATAKANA LETTER YA");
    map.put('\uFF95', "HALFWIDTH KATAKANA LETTER YU");
    map.put('\uFF96', "HALFWIDTH KATAKANA LETTER YO");
    map.put('\uFF97', "HALFWIDTH KATAKANA LETTER RA");
    map.put('\uFF98', "HALFWIDTH KATAKANA LETTER RI");
    map.put('\uFF99', "HALFWIDTH KATAKANA LETTER RU");
    map.put('\uFF9A', "HALFWIDTH KATAKANA LETTER RE");
    map.put('\uFF9B', "HALFWIDTH KATAKANA LETTER RO");
    map.put('\uFF9C', "HALFWIDTH KATAKANA LETTER WA");
    map.put('\uFF9D', "HALFWIDTH KATAKANA LETTER N");
    map.put('\uFF9E', "HALFWIDTH KATAKANA VOICED SOUND MARK");
    map.put('\uFF9F', "HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK");
    map.put('\uFFA0', "HALFWIDTH HANGUL FILLER");
    map.put('\uFFA1', "HALFWIDTH HANGUL LETTER KIYEOK");
    map.put('\uFFA2', "HALFWIDTH HANGUL LETTER SSANGKIYEOK");
    map.put('\uFFA3', "HALFWIDTH HANGUL LETTER KIYEOK-SIOS");
    map.put('\uFFA4', "HALFWIDTH HANGUL LETTER NIEUN");
    map.put('\uFFA5', "HALFWIDTH HANGUL LETTER NIEUN-CIEUC");
    map.put('\uFFA6', "HALFWIDTH HANGUL LETTER NIEUN-HIEUH");
    map.put('\uFFA7', "HALFWIDTH HANGUL LETTER TIKEUT");
    map.put('\uFFA8', "HALFWIDTH HANGUL LETTER SSANGTIKEUT");
    map.put('\uFFA9', "HALFWIDTH HANGUL LETTER RIEUL");
    map.put('\uFFAA', "HALFWIDTH HANGUL LETTER RIEUL-KIYEOK");
    map.put('\uFFAB', "HALFWIDTH HANGUL LETTER RIEUL-MIEUM");
    map.put('\uFFAC', "HALFWIDTH HANGUL LETTER RIEUL-PIEUP");
    map.put('\uFFAD', "HALFWIDTH HANGUL LETTER RIEUL-SIOS");
    map.put('\uFFAE', "HALFWIDTH HANGUL LETTER RIEUL-THIEUTH");
    map.put('\uFFAF', "HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH");
    map.put('\uFFB0', "HALFWIDTH HANGUL LETTER RIEUL-HIEUH");
    map.put('\uFFB1', "HALFWIDTH HANGUL LETTER MIEUM");
    map.put('\uFFB2', "HALFWIDTH HANGUL LETTER PIEUP");
    map.put('\uFFB3', "HALFWIDTH HANGUL LETTER SSANGPIEUP");
    map.put('\uFFB4', "HALFWIDTH HANGUL LETTER PIEUP-SIOS");
    map.put('\uFFB5', "HALFWIDTH HANGUL LETTER SIOS");
    map.put('\uFFB6', "HALFWIDTH HANGUL LETTER SSANGSIOS");
    map.put('\uFFB7', "HALFWIDTH HANGUL LETTER IEUNG");
    map.put('\uFFB8', "HALFWIDTH HANGUL LETTER CIEUC");
    map.put('\uFFB9', "HALFWIDTH HANGUL LETTER SSANGCIEUC");
    map.put('\uFFBA', "HALFWIDTH HANGUL LETTER CHIEUCH");
    map.put('\uFFBB', "HALFWIDTH HANGUL LETTER KHIEUKH");
    map.put('\uFFBC', "HALFWIDTH HANGUL LETTER THIEUTH");
    map.put('\uFFBD', "HALFWIDTH HANGUL LETTER PHIEUPH");
    map.put('\uFFBE', "HALFWIDTH HANGUL LETTER HIEUH");
    map.put('\uFFC2', "HALFWIDTH HANGUL LETTER A");
    map.put('\uFFC3', "HALFWIDTH HANGUL LETTER AE");
    map.put('\uFFC4', "HALFWIDTH HANGUL LETTER YA");
    map.put('\uFFC5', "HALFWIDTH HANGUL LETTER YAE");
    map.put('\uFFC6', "HALFWIDTH HANGUL LETTER EO");
    map.put('\uFFC7', "HALFWIDTH HANGUL LETTER E");
    map.put('\uFFCA', "HALFWIDTH HANGUL LETTER YEO");
    map.put('\uFFCB', "HALFWIDTH HANGUL LETTER YE");
    map.put('\uFFCC', "HALFWIDTH HANGUL LETTER O");
    map.put('\uFFCD', "HALFWIDTH HANGUL LETTER WA");
    map.put('\uFFCE', "HALFWIDTH HANGUL LETTER WAE");
    map.put('\uFFCF', "HALFWIDTH HANGUL LETTER OE");
    map.put('\uFFD2', "HALFWIDTH HANGUL LETTER YO");
    map.put('\uFFD3', "HALFWIDTH HANGUL LETTER U");
    map.put('\uFFD4', "HALFWIDTH HANGUL LETTER WEO");
    map.put('\uFFD5', "HALFWIDTH HANGUL LETTER WE");
    map.put('\uFFD6', "HALFWIDTH HANGUL LETTER WI");
    map.put('\uFFD7', "HALFWIDTH HANGUL LETTER YU");
    map.put('\uFFDA', "HALFWIDTH HANGUL LETTER EU");
    map.put('\uFFDB', "HALFWIDTH HANGUL LETTER YI");
    map.put('\uFFDC', "HALFWIDTH HANGUL LETTER I");
    map.put('\uFFE0', "FULLWIDTH CENT SIGN");
    map.put('\uFFE1', "FULLWIDTH POUND SIGN");
    map.put('\uFFE2', "FULLWIDTH NOT SIGN");
    map.put('\uFFE3', "FULLWIDTH MACRON");
    map.put('\uFFE4', "FULLWIDTH BROKEN BAR");
    map.put('\uFFE5', "FULLWIDTH YEN SIGN");
    map.put('\uFFE6', "FULLWIDTH WON SIGN");
    map.put('\uFFE8', "HALFWIDTH FORMS LIGHT VERTICAL");
    map.put('\uFFE9', "HALFWIDTH LEFTWARDS ARROW");
    map.put('\uFFEA', "HALFWIDTH UPWARDS ARROW");
    map.put('\uFFEB', "HALFWIDTH RIGHTWARDS ARROW");
    map.put('\uFFEC', "HALFWIDTH DOWNWARDS ARROW");
    map.put('\uFFED', "HALFWIDTH BLACK SQUARE");
    map.put('\uFFEE', "HALFWIDTH WHITE CIRCLE");
    map.put('\uFFF9', "INTERLINEAR ANNOTATION ANCHOR");
    map.put('\uFFFA', "INTERLINEAR ANNOTATION SEPARATOR");
    map.put('\uFFFB', "INTERLINEAR ANNOTATION TERMINATOR");
    map.put('\uFFFC', "OBJECT REPLACEMENT CHARACTER");
    map.put('\uFFFD', "REPLACEMENT CHARACTER");
    map.put('\uFFFE', "<not a character>");
    map.put('\uFFFF', "<not a character>");

  }


  // private final void linearBSyllabary() {
  //
  // map.put('\u10000',"LINEAR B SYLLABLE B008 A");
  // map.put('\u10001',"LINEAR B SYLLABLE B038 E");
  // map.put('\u10002',"LINEAR B SYLLABLE B028 I");
  // map.put('\u10003',"LINEAR B SYLLABLE B061 O");
  // map.put('\u10004',"LINEAR B SYLLABLE B010 U");
  // map.put('\u10005',"LINEAR B SYLLABLE B001 DA");
  // map.put('\u10006',"LINEAR B SYLLABLE B045 DE");
  // map.put('\u10007',"LINEAR B SYLLABLE B007 DI");
  // map.put('\u10008',"LINEAR B SYLLABLE B014 DO");
  // map.put('\u10009',"LINEAR B SYLLABLE B051 DU");
  // map.put('\u1000A',"LINEAR B SYLLABLE B057 JA");
  // map.put('\u1000B',"LINEAR B SYLLABLE B046 JE");
  // map.put('\u1000D',"LINEAR B SYLLABLE B036 JO");
  // map.put('\u1000E',"LINEAR B SYLLABLE B065 JU");
  // map.put('\u1000F',"LINEAR B SYLLABLE B077 KA");
  // map.put('\u10010',"LINEAR B SYLLABLE B044 KE");
  // map.put('\u10011',"LINEAR B SYLLABLE B067 KI");
  // map.put('\u10012',"LINEAR B SYLLABLE B070 KO");
  // map.put('\u10013',"LINEAR B SYLLABLE B081 KU");
  // map.put('\u10014',"LINEAR B SYLLABLE B080 MA");
  // map.put('\u10015',"LINEAR B SYLLABLE B013 ME");
  // map.put('\u10016',"LINEAR B SYLLABLE B073 MI");
  // map.put('\u10017',"LINEAR B SYLLABLE B015 MO");
  // map.put('\u10018',"LINEAR B SYLLABLE B023 MU");
  // map.put('\u10019',"LINEAR B SYLLABLE B006 NA");
  // map.put('\u1001A',"LINEAR B SYLLABLE B024 NE");
  // map.put('\u1001B',"LINEAR B SYLLABLE B030 NI");
  // map.put('\u1001C',"LINEAR B SYLLABLE B052 NO");
  // map.put('\u1001D',"LINEAR B SYLLABLE B055 NU");
  // map.put('\u1001E',"LINEAR B SYLLABLE B003 PA");
  // map.put('\u1001F',"LINEAR B SYLLABLE B072 PE");
  // map.put('\u10020',"LINEAR B SYLLABLE B039 PI");
  // map.put('\u10021',"LINEAR B SYLLABLE B011 PO");
  // map.put('\u10022',"LINEAR B SYLLABLE B050 PU");
  // map.put('\u10023',"LINEAR B SYLLABLE B016 QA");
  // map.put('\u10024',"LINEAR B SYLLABLE B078 QE");
  // map.put('\u10025',"LINEAR B SYLLABLE B021 QI");
  // map.put('\u10026',"LINEAR B SYLLABLE B032 QO");
  // map.put('\u10028',"LINEAR B SYLLABLE B060 RA");
  // map.put('\u10029',"LINEAR B SYLLABLE B027 RE");
  // map.put('\u1002A',"LINEAR B SYLLABLE B053 RI");
  // map.put('\u1002B',"LINEAR B SYLLABLE B002 RO");
  // map.put('\u1002C',"LINEAR B SYLLABLE B026 RU");
  // map.put('\u1002D',"LINEAR B SYLLABLE B031 SA");
  // map.put('\u1002E',"LINEAR B SYLLABLE B009 SE");
  // map.put('\u1002F',"LINEAR B SYLLABLE B041 SI");
  // map.put('\u10030',"LINEAR B SYLLABLE B012 SO");
  // map.put('\u10031',"LINEAR B SYLLABLE B058 SU");
  // map.put('\u10032',"LINEAR B SYLLABLE B059 TA");
  // map.put('\u10033',"LINEAR B SYLLABLE B004 TE");
  // map.put('\u10034',"LINEAR B SYLLABLE B037 TI");
  // map.put('\u10035',"LINEAR B SYLLABLE B005 TO");
  // map.put('\u10036',"LINEAR B SYLLABLE B069 TU");
  // map.put('\u10037',"LINEAR B SYLLABLE B054 WA");
  // map.put('\u10038',"LINEAR B SYLLABLE B075 WE");
  // map.put('\u10039',"LINEAR B SYLLABLE B040 WI");
  // map.put('\u1003A',"LINEAR B SYLLABLE B042 WO");
  // map.put('\u1003C',"LINEAR B SYLLABLE B017 ZA");
  // map.put('\u1003D',"LINEAR B SYLLABLE B074 ZE");
  // map.put('\u1003F',"LINEAR B SYLLABLE B020 ZO");
  // map.put('\u10040',"LINEAR B SYLLABLE B025 A2");
  // map.put('\u10041',"LINEAR B SYLLABLE B043 A3");
  // map.put('\u10042',"LINEAR B SYLLABLE B085 AU");
  // map.put('\u10043',"LINEAR B SYLLABLE B071 DWE");
  // map.put('\u10044',"LINEAR B SYLLABLE B090 DWO");
  // map.put('\u10045',"LINEAR B SYLLABLE B048 NWA");
  // map.put('\u10046',"LINEAR B SYLLABLE B029 PU2");
  // map.put('\u10047',"LINEAR B SYLLABLE B062 PTE");
  // map.put('\u10048',"LINEAR B SYLLABLE B076 RA2");
  // map.put('\u10049',"LINEAR B SYLLABLE B033 RA3");
  // map.put('\u1004A',"LINEAR B SYLLABLE B068 RO2");
  // map.put('\u1004B',"LINEAR B SYLLABLE B066 TA2");
  // map.put('\u1004C',"LINEAR B SYLLABLE B087 TWE");
  // map.put('\u1004D',"LINEAR B SYLLABLE B091 TWO");
  // map.put('\u10050',"LINEAR B SYMBOL B018");
  // map.put('\u10051',"LINEAR B SYMBOL B019");
  // map.put('\u10052',"LINEAR B SYMBOL B022");
  // map.put('\u10053',"LINEAR B SYMBOL B034");
  // map.put('\u10054',"LINEAR B SYMBOL B047");
  // map.put('\u10055',"LINEAR B SYMBOL B049");
  // map.put('\u10056',"LINEAR B SYMBOL B056");
  // map.put('\u10057',"LINEAR B SYMBOL B063");
  // map.put('\u10058',"LINEAR B SYMBOL B064");
  // map.put('\u10059',"LINEAR B SYMBOL B079");
  // map.put('\u1005A',"LINEAR B SYMBOL B082");
  // map.put('\u1005B',"LINEAR B SYMBOL B083");
  // map.put('\u1005C',"LINEAR B SYMBOL B086");
  // map.put('\u1005D',"LINEAR B SYMBOL B089");
  // map.put('\u10080',"LINEAR B IDEOGRAM B100 MAN");
  // map.put('\u10081',"LINEAR B IDEOGRAM B102 WOMAN");
  // map.put('\u10082',"LINEAR B IDEOGRAM B104 DEER");
  // map.put('\u10083',"LINEAR B IDEOGRAM B105 EQUID");
  // map.put('\u10084',"LINEAR B IDEOGRAM B105F MARE");
  // map.put('\u10085',"LINEAR B IDEOGRAM B105M STALLION");
  // map.put('\u10086',"LINEAR B IDEOGRAM B106F EWE");
  // map.put('\u10087',"LINEAR B IDEOGRAM B106M RAM");
  // map.put('\u10088',"LINEAR B IDEOGRAM B107F SHE-GOAT");
  // map.put('\u10089',"LINEAR B IDEOGRAM B107M HE-GOAT");
  // map.put('\u1008A',"LINEAR B IDEOGRAM B108F SOW");
  // map.put('\u1008B',"LINEAR B IDEOGRAM B108M BOAR");
  // map.put('\u1008C',"LINEAR B IDEOGRAM B109F COW");
  // map.put('\u1008D',"LINEAR B IDEOGRAM B109M BULL");
  // map.put('\u1008E',"LINEAR B IDEOGRAM B120 WHEAT");
  // map.put('\u1008F',"LINEAR B IDEOGRAM B121 BARLEY");
  // map.put('\u10090',"LINEAR B IDEOGRAM B122 OLIVE");
  // map.put('\u10091',"LINEAR B IDEOGRAM B123 SPICE");
  // map.put('\u10092',"LINEAR B IDEOGRAM B125 CYPERUS");
  // map.put('\u10093',"LINEAR B MONOGRAM B127 KAPO");
  // map.put('\u10094',"LINEAR B MONOGRAM B128 KANAKO");
  // map.put('\u10095',"LINEAR B IDEOGRAM B130 OIL");
  // map.put('\u10096',"LINEAR B IDEOGRAM B131 WINE");
  // map.put('\u10097',"LINEAR B IDEOGRAM B132");
  // map.put('\u10098',"LINEAR B MONOGRAM B133 AREPA");
  // map.put('\u10099',"LINEAR B MONOGRAM B135 MERI");
  // map.put('\u1009A',"LINEAR B IDEOGRAM B140 BRONZE");
  // map.put('\u1009B',"LINEAR B IDEOGRAM B141 GOLD");
  // map.put('\u1009C',"LINEAR B IDEOGRAM B142");
  // map.put('\u1009D',"LINEAR B IDEOGRAM B145 WOOL");
  // map.put('\u1009E',"LINEAR B IDEOGRAM B146");
  // map.put('\u1009F',"LINEAR B IDEOGRAM B150");
  // map.put('\u100A0',"LINEAR B IDEOGRAM B151 HORN");
  // map.put('\u100A1',"LINEAR B IDEOGRAM B152");
  // map.put('\u100A2',"LINEAR B IDEOGRAM B153");
  // map.put('\u100A3',"LINEAR B IDEOGRAM B154");
  // map.put('\u100A4',"LINEAR B MONOGRAM B156 TURO2");
  // map.put('\u100A5',"LINEAR B IDEOGRAM B157");
  // map.put('\u100A6',"LINEAR B IDEOGRAM B158");
  // map.put('\u100A7',"LINEAR B IDEOGRAM B159 CLOTH");
  // map.put('\u100A8',"LINEAR B IDEOGRAM B160");
  // map.put('\u100A9',"LINEAR B IDEOGRAM B161");
  // map.put('\u100AA',"LINEAR B IDEOGRAM B162 GARMENT");
  // map.put('\u100AB',"LINEAR B IDEOGRAM B163 ARMOUR");
  // map.put('\u100AC',"LINEAR B IDEOGRAM B164");
  // map.put('\u100AD',"LINEAR B IDEOGRAM B165");
  // map.put('\u100AE',"LINEAR B IDEOGRAM B166");
  // map.put('\u100AF',"LINEAR B IDEOGRAM B167");
  // map.put('\u100B0',"LINEAR B IDEOGRAM B168");
  // map.put('\u100B1',"LINEAR B IDEOGRAM B169");
  // map.put('\u100B2',"LINEAR B IDEOGRAM B170");
  // map.put('\u100B3',"LINEAR B IDEOGRAM B171");
  // map.put('\u100B4',"LINEAR B IDEOGRAM B172");
  // map.put('\u100B5',"LINEAR B IDEOGRAM B173 MONTH");
  // map.put('\u100B6',"LINEAR B IDEOGRAM B174");
  // map.put('\u100B7',"LINEAR B IDEOGRAM B176 TREE");
  // map.put('\u100B8',"LINEAR B IDEOGRAM B177");
  // map.put('\u100B9',"LINEAR B IDEOGRAM B178");
  // map.put('\u100BA',"LINEAR B IDEOGRAM B179");
  // map.put('\u100BB',"LINEAR B IDEOGRAM B180");
  // map.put('\u100BC',"LINEAR B IDEOGRAM B181");
  // map.put('\u100BD',"LINEAR B IDEOGRAM B182");
  // map.put('\u100BE',"LINEAR B IDEOGRAM B183");
  // map.put('\u100BF',"LINEAR B IDEOGRAM B184");
  // map.put('\u100C0',"LINEAR B IDEOGRAM B185");
  // map.put('\u100C1',"LINEAR B IDEOGRAM B189");
  // map.put('\u100C2',"LINEAR B IDEOGRAM B190");
  // map.put('\u100C3',"LINEAR B IDEOGRAM B191 HELMET");
  // map.put('\u100C4',"LINEAR B IDEOGRAM B220 FOOTSTOOL");
  // map.put('\u100C5',"LINEAR B IDEOGRAM B225 BATHTUB");
  // map.put('\u100C6',"LINEAR B IDEOGRAM B230 SPEAR");
  // map.put('\u100C7',"LINEAR B IDEOGRAM B231 ARROW");
  // map.put('\u100C8',"LINEAR B IDEOGRAM B232");
  // map.put('\u100C9',"LINEAR B IDEOGRAM B233 SWORD");
  // map.put('\u100CA',"LINEAR B IDEOGRAM B234");
  // map.put('\u100CB',"LINEAR B IDEOGRAM B236");
  // map.put('\u100CC',"LINEAR B IDEOGRAM B240 WHEELED CHARIOT");
  // map.put('\u100CD',"LINEAR B IDEOGRAM B241 CHARIOT");
  // map.put('\u100CE',"LINEAR B IDEOGRAM B242 CHARIOT FRAME");
  // map.put('\u100CF',"LINEAR B IDEOGRAM B243 WHEEL");
  // map.put('\u100D0',"LINEAR B IDEOGRAM B245");
  // map.put('\u100D1',"LINEAR B IDEOGRAM B246");
  // map.put('\u100D2',"LINEAR B MONOGRAM B247 DIPTE");
  // map.put('\u100D3',"LINEAR B IDEOGRAM B248");
  // map.put('\u100D4',"LINEAR B IDEOGRAM B249");
  // map.put('\u100D5',"LINEAR B IDEOGRAM B251");
  // map.put('\u100D6',"LINEAR B IDEOGRAM B252");
  // map.put('\u100D7',"LINEAR B IDEOGRAM B253");
  // map.put('\u100D8',"LINEAR B IDEOGRAM B254 DART");
  // map.put('\u100D9',"LINEAR B IDEOGRAM B255");
  // map.put('\u100DA',"LINEAR B IDEOGRAM B256");
  // map.put('\u100DB',"LINEAR B IDEOGRAM B257");
  // map.put('\u100DC',"LINEAR B IDEOGRAM B258");
  // map.put('\u100DD',"LINEAR B IDEOGRAM B259");
  // map.put('\u100DE',"LINEAR B IDEOGRAM VESSEL B155");
  // map.put('\u100DF',"LINEAR B IDEOGRAM VESSEL B200");
  // map.put('\u100E0',"LINEAR B IDEOGRAM VESSEL B201");
  // map.put('\u100E1',"LINEAR B IDEOGRAM VESSEL B202");
  // map.put('\u100E2',"LINEAR B IDEOGRAM VESSEL B203");
  // map.put('\u100E3',"LINEAR B IDEOGRAM VESSEL B204");
  // map.put('\u100E4',"LINEAR B IDEOGRAM VESSEL B205");
  // map.put('\u100E5',"LINEAR B IDEOGRAM VESSEL B206");
  // map.put('\u100E6',"LINEAR B IDEOGRAM VESSEL B207");
  // map.put('\u100E7',"LINEAR B IDEOGRAM VESSEL B208");
  // map.put('\u100E8',"LINEAR B IDEOGRAM VESSEL B209");
  // map.put('\u100E9',"LINEAR B IDEOGRAM VESSEL B210");
  // map.put('\u100EA',"LINEAR B IDEOGRAM VESSEL B211");
  // map.put('\u100EB',"LINEAR B IDEOGRAM VESSEL B212");
  // map.put('\u100EC',"LINEAR B IDEOGRAM VESSEL B213");
  // map.put('\u100ED',"LINEAR B IDEOGRAM VESSEL B214");
  // map.put('\u100EE',"LINEAR B IDEOGRAM VESSEL B215");
  // map.put('\u100EF',"LINEAR B IDEOGRAM VESSEL B216");
  // map.put('\u100F0',"LINEAR B IDEOGRAM VESSEL B217");
  // map.put('\u100F1',"LINEAR B IDEOGRAM VESSEL B218");
  // map.put('\u100F2',"LINEAR B IDEOGRAM VESSEL B219");
  // map.put('\u100F3',"LINEAR B IDEOGRAM VESSEL B221");
  // map.put('\u100F4',"LINEAR B IDEOGRAM VESSEL B222");
  // map.put('\u100F5',"LINEAR B IDEOGRAM VESSEL B226");
  // map.put('\u100F6',"LINEAR B IDEOGRAM VESSEL B227");
  // map.put('\u100F7',"LINEAR B IDEOGRAM VESSEL B228");
  // map.put('\u100F8',"LINEAR B IDEOGRAM VESSEL B229");
  // map.put('\u100F9',"LINEAR B IDEOGRAM VESSEL B250");
  // map.put('\u100FA',"LINEAR B IDEOGRAM VESSEL B305");
  // map.put('\u10100',"AEGEAN WORD SEPARATOR LINE");
  // map.put('\u10101',"AEGEAN WORD SEPARATOR DOT");
  // map.put('\u10102',"AEGEAN CHECK MARK");
  // map.put('\u10107',"AEGEAN NUMBER ONE");
  // map.put('\u10108',"AEGEAN NUMBER TWO");
  // map.put('\u10109',"AEGEAN NUMBER THREE");
  // map.put('\u1010A',"AEGEAN NUMBER FOUR");
  // map.put('\u1010B',"AEGEAN NUMBER FIVE");
  // map.put('\u1010C',"AEGEAN NUMBER SIX");
  // map.put('\u1010D',"AEGEAN NUMBER SEVEN");
  // map.put('\u1010E',"AEGEAN NUMBER EIGHT");
  // map.put('\u1010F',"AEGEAN NUMBER NINE");
  // map.put('\u10110',"AEGEAN NUMBER TEN");
  // map.put('\u10111',"AEGEAN NUMBER TWENTY");
  // map.put('\u10112',"AEGEAN NUMBER THIRTY");
  // map.put('\u10113',"AEGEAN NUMBER FORTY");
  // map.put('\u10114',"AEGEAN NUMBER FIFTY");
  // map.put('\u10115',"AEGEAN NUMBER SIXTY");
  // map.put('\u10116',"AEGEAN NUMBER SEVENTY");
  // map.put('\u10117',"AEGEAN NUMBER EIGHTY");
  // map.put('\u10118',"AEGEAN NUMBER NINETY");
  // map.put('\u10119',"AEGEAN NUMBER ONE HUNDRED");
  // map.put('\u1011A',"AEGEAN NUMBER TWO HUNDRED");
  // map.put('\u1011B',"AEGEAN NUMBER THREE HUNDRED");
  // map.put('\u1011C',"AEGEAN NUMBER FOUR HUNDRED");
  // map.put('\u1011D',"AEGEAN NUMBER FIVE HUNDRED");
  // map.put('\u1011E',"AEGEAN NUMBER SIX HUNDRED");
  // map.put('\u1011F',"AEGEAN NUMBER SEVEN HUNDRED");
  // map.put('\u10120',"AEGEAN NUMBER EIGHT HUNDRED");
  // map.put('\u10121',"AEGEAN NUMBER NINE HUNDRED");
  // map.put('\u10122',"AEGEAN NUMBER ONE THOUSAND");
  // map.put('\u10123',"AEGEAN NUMBER TWO THOUSAND");
  // map.put('\u10124',"AEGEAN NUMBER THREE THOUSAND");
  // map.put('\u10125',"AEGEAN NUMBER FOUR THOUSAND");
  // map.put('\u10126',"AEGEAN NUMBER FIVE THOUSAND");
  // map.put('\u10127',"AEGEAN NUMBER SIX THOUSAND");
  // map.put('\u10128',"AEGEAN NUMBER SEVEN THOUSAND");
  // map.put('\u10129',"AEGEAN NUMBER EIGHT THOUSAND");
  // map.put('\u1012A',"AEGEAN NUMBER NINE THOUSAND");
  // map.put('\u1012B',"AEGEAN NUMBER TEN THOUSAND");
  // map.put('\u1012C',"AEGEAN NUMBER TWENTY THOUSAND");
  // map.put('\u1012D',"AEGEAN NUMBER THIRTY THOUSAND");
  // map.put('\u1012E',"AEGEAN NUMBER FORTY THOUSAND");
  // map.put('\u1012F',"AEGEAN NUMBER FIFTY THOUSAND");
  // map.put('\u10130',"AEGEAN NUMBER SIXTY THOUSAND");
  // map.put('\u10131',"AEGEAN NUMBER SEVENTY THOUSAND");
  // map.put('\u10132',"AEGEAN NUMBER EIGHTY THOUSAND");
  // map.put('\u10133',"AEGEAN NUMBER NINETY THOUSAND");
  // map.put('\u10137',"AEGEAN WEIGHT BASE UNIT");
  // map.put('\u10138',"AEGEAN WEIGHT FIRST SUBUNIT");
  // map.put('\u10139',"AEGEAN WEIGHT SECOND SUBUNIT");
  // map.put('\u1013A',"AEGEAN WEIGHT THIRD SUBUNIT");
  // map.put('\u1013B',"AEGEAN WEIGHT FOURTH SUBUNIT");
  // map.put('\u1013C',"AEGEAN DRY MEASURE FIRST SUBUNIT");
  // map.put('\u1013D',"AEGEAN LIQUID MEASURE FIRST SUBUNIT");
  // map.put('\u1013E',"AEGEAN MEASURE SECOND SUBUNIT");
  // map.put('\u1013F',"AEGEAN MEASURE THIRD SUBUNIT");
  // map.put('\u10140',"GREEK ACROPHONIC ATTIC ONE QUARTER");
  // map.put('\u10141',"GREEK ACROPHONIC ATTIC ONE HALF");
  // map.put('\u10142',"GREEK ACROPHONIC ATTIC ONE DRACHMA");
  // map.put('\u10143',"GREEK ACROPHONIC ATTIC FIVE");
  // map.put('\u10144',"GREEK ACROPHONIC ATTIC FIFTY");
  // map.put('\u10145',"GREEK ACROPHONIC ATTIC FIVE HUNDRED");
  // map.put('\u10146',"GREEK ACROPHONIC ATTIC FIVE THOUSAND");
  // map.put('\u10147',"GREEK ACROPHONIC ATTIC FIFTY THOUSAND");
  // map.put('\u10148',"GREEK ACROPHONIC ATTIC FIVE TALENTS");
  // map.put('\u10149',"GREEK ACROPHONIC ATTIC TEN TALENTS");
  // map.put('\u1014A',"GREEK ACROPHONIC ATTIC FIFTY TALENTS");
  // map.put('\u1014B',"GREEK ACROPHONIC ATTIC ONE HUNDRED TALENTS");
  // map.put('\u1014C',"GREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTS");
  // map.put('\u1014D',"GREEK ACROPHONIC ATTIC ONE THOUSAND TALENTS");
  // map.put('\u1014E',"GREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTS");
  // map.put('\u1014F',"GREEK ACROPHONIC ATTIC FIVE STATERS");
  // map.put('\u10150',"GREEK ACROPHONIC ATTIC TEN STATERS");
  // map.put('\u10151',"GREEK ACROPHONIC ATTIC FIFTY STATERS");
  // map.put('\u10152',"GREEK ACROPHONIC ATTIC ONE HUNDRED STATERS");
  // map.put('\u10153',"GREEK ACROPHONIC ATTIC FIVE HUNDRED STATERS");
  // map.put('\u10154',"GREEK ACROPHONIC ATTIC ONE THOUSAND STATERS");
  // map.put('\u10155',"GREEK ACROPHONIC ATTIC TEN THOUSAND STATERS");
  // map.put('\u10156',"GREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERS");
  // map.put('\u10157',"GREEK ACROPHONIC ATTIC TEN MNAS");
  // map.put('\u10158',"GREEK ACROPHONIC HERAEUM ONE PLETHRON");
  // map.put('\u10159',"GREEK ACROPHONIC THESPIAN ONE");
  // map.put('\u1015A',"GREEK ACROPHONIC HERMIONIAN ONE");
  // map.put('\u1015B',"GREEK ACROPHONIC EPIDAUREAN TWO");
  // map.put('\u1015C',"GREEK ACROPHONIC THESPIAN TWO");
  // map.put('\u1015D',"GREEK ACROPHONIC CYRENAIC TWO DRACHMAS");
  // map.put('\u1015E',"GREEK ACROPHONIC EPIDAUREAN TWO DRACHMAS");
  // map.put('\u1015F',"GREEK ACROPHONIC TROEZENIAN FIVE");
  // map.put('\u10160',"GREEK ACROPHONIC TROEZENIAN TEN");
  // map.put('\u10161',"GREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORM");
  // map.put('\u10162',"GREEK ACROPHONIC HERMIONIAN TEN");
  // map.put('\u10163',"GREEK ACROPHONIC MESSENIAN TEN");
  // map.put('\u10164',"GREEK ACROPHONIC THESPIAN TEN");
  // map.put('\u10165',"GREEK ACROPHONIC THESPIAN THIRTY");
  // map.put('\u10166',"GREEK ACROPHONIC TROEZENIAN FIFTY");
  // map.put('\u10167',"GREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORM");
  // map.put('\u10168',"GREEK ACROPHONIC HERMIONIAN FIFTY");
  // map.put('\u10169',"GREEK ACROPHONIC THESPIAN FIFTY");
  // map.put('\u1016A',"GREEK ACROPHONIC THESPIAN ONE HUNDRED");
  // map.put('\u1016B',"GREEK ACROPHONIC THESPIAN THREE HUNDRED");
  // map.put('\u1016C',"GREEK ACROPHONIC EPIDAUREAN FIVE HUNDRED");
  // map.put('\u1016D',"GREEK ACROPHONIC TROEZENIAN FIVE HUNDRED");
  // map.put('\u1016E',"GREEK ACROPHONIC THESPIAN FIVE HUNDRED");
  // map.put('\u1016F',"GREEK ACROPHONIC CARYSTIAN FIVE HUNDRED");
  // map.put('\u10170',"GREEK ACROPHONIC NAXIAN FIVE HUNDRED");
  // map.put('\u10171',"GREEK ACROPHONIC THESPIAN ONE THOUSAND");
  // map.put('\u10172',"GREEK ACROPHONIC THESPIAN FIVE THOUSAND");
  // map.put('\u10173',"GREEK ACROPHONIC DELPHIC FIVE MNAS");
  // map.put('\u10174',"GREEK ACROPHONIC STRATIAN FIFTY MNAS");
  // map.put('\u10175',"GREEK ONE HALF SIGN");
  // map.put('\u10176',"GREEK ONE HALF SIGN ALTERNATE FORM");
  // map.put('\u10177',"GREEK TWO THIRDS SIGN");
  // map.put('\u10178',"GREEK THREE QUARTERS SIGN");
  // map.put('\u10179',"GREEK YEAR SIGN");
  // map.put('\u1017A',"GREEK TALENT SIGN");
  // map.put('\u1017B',"GREEK DRACHMA SIGN");
  // map.put('\u1017C',"GREEK OBOL SIGN");
  // map.put('\u1017D',"GREEK TWO OBOLS SIGN");
  // map.put('\u1017E',"GREEK THREE OBOLS SIGN");
  // map.put('\u1017F',"GREEK FOUR OBOLS SIGN");
  // map.put('\u10180',"GREEK FIVE OBOLS SIGN");
  // map.put('\u10181',"GREEK METRETES SIGN");
  // map.put('\u10182',"GREEK KYATHOS BASE SIGN");
  // map.put('\u10183',"GREEK LITRA SIGN");
  // map.put('\u10184',"GREEK OUNKIA SIGN");
  // map.put('\u10185',"GREEK XESTES SIGN");
  // map.put('\u10186',"GREEK ARTABE SIGN");
  // map.put('\u10187',"GREEK AROURA SIGN");
  // map.put('\u10188',"GREEK GRAMMA SIGN");
  // map.put('\u10189',"GREEK TRYBLION BASE SIGN");
  // map.put('\u1018A',"GREEK ZERO SIGN");
  // map.put('\u10190',"ROMAN SEXTANS SIGN");
  // map.put('\u10191',"ROMAN UNCIA SIGN");
  // map.put('\u10192',"ROMAN SEMUNCIA SIGN");
  // map.put('\u10193',"ROMAN SEXTULA SIGN");
  // map.put('\u10194',"ROMAN DIMIDIA SEXTULA SIGN");
  // map.put('\u10195',"ROMAN SILIQUA SIGN");
  // map.put('\u10196',"ROMAN DENARIUS SIGN");
  // map.put('\u10197',"ROMAN QUINARIUS SIGN");
  // map.put('\u10198',"ROMAN SESTERTIUS SIGN");
  // map.put('\u10199',"ROMAN DUPONDIUS SIGN");
  // map.put('\u1019A',"ROMAN AS SIGN");
  // map.put('\u1019B',"ROMAN CENTURIAL SIGN");
  // map.put('\u101D0',"PHAISTOS DISC SIGN PEDESTRIAN");
  // map.put('\u101D1',"PHAISTOS DISC SIGN PLUMED HEAD");
  // map.put('\u101D2',"PHAISTOS DISC SIGN TATTOOED HEAD");
  // map.put('\u101D3',"PHAISTOS DISC SIGN CAPTIVE");
  // map.put('\u101D4',"PHAISTOS DISC SIGN CHILD");
  // map.put('\u101D5',"PHAISTOS DISC SIGN WOMAN");
  // map.put('\u101D6',"PHAISTOS DISC SIGN HELMET");
  // map.put('\u101D7',"PHAISTOS DISC SIGN GAUNTLET");
  // map.put('\u101D8',"PHAISTOS DISC SIGN TIARA");
  // map.put('\u101D9',"PHAISTOS DISC SIGN ARROW");
  // map.put('\u101DA',"PHAISTOS DISC SIGN BOW");
  // map.put('\u101DB',"PHAISTOS DISC SIGN SHIELD");
  // map.put('\u101DC',"PHAISTOS DISC SIGN CLUB");
  // map.put('\u101DD',"PHAISTOS DISC SIGN MANACLES");
  // map.put('\u101DE',"PHAISTOS DISC SIGN MATTOCK");
  // map.put('\u101DF',"PHAISTOS DISC SIGN SAW");
  // map.put('\u101E0',"PHAISTOS DISC SIGN LID");
  // map.put('\u101E1',"PHAISTOS DISC SIGN BOOMERANG");
  // map.put('\u101E2',"PHAISTOS DISC SIGN CARPENTRY PLANE");
  // map.put('\u101E3',"PHAISTOS DISC SIGN DOLIUM");
  // map.put('\u101E4',"PHAISTOS DISC SIGN COMB");
  // map.put('\u101E5',"PHAISTOS DISC SIGN SLING");
  // map.put('\u101E6',"PHAISTOS DISC SIGN COLUMN");
  // map.put('\u101E7',"PHAISTOS DISC SIGN BEEHIVE");
  // map.put('\u101E8',"PHAISTOS DISC SIGN SHIP");
  // map.put('\u101E9',"PHAISTOS DISC SIGN HORN");
  // map.put('\u101EA',"PHAISTOS DISC SIGN HIDE");
  // map.put('\u101EB',"PHAISTOS DISC SIGN BULLS LEG");
  // map.put('\u101EC',"PHAISTOS DISC SIGN CAT");
  // map.put('\u101ED',"PHAISTOS DISC SIGN RAM");
  // map.put('\u101EE',"PHAISTOS DISC SIGN EAGLE");
  // map.put('\u101EF',"PHAISTOS DISC SIGN DOVE");
  // map.put('\u101F0',"PHAISTOS DISC SIGN TUNNY");
  // map.put('\u101F1',"PHAISTOS DISC SIGN BEE");
  // map.put('\u101F2',"PHAISTOS DISC SIGN PLANE TREE");
  // map.put('\u101F3',"PHAISTOS DISC SIGN VINE");
  // map.put('\u101F4',"PHAISTOS DISC SIGN PAPYRUS");
  // map.put('\u101F5',"PHAISTOS DISC SIGN ROSETTE");
  // map.put('\u101F6',"PHAISTOS DISC SIGN LILY");
  // map.put('\u101F7',"PHAISTOS DISC SIGN OX BACK");
  // map.put('\u101F8',"PHAISTOS DISC SIGN FLUTE");
  // map.put('\u101F9',"PHAISTOS DISC SIGN GRATER");
  // map.put('\u101FA',"PHAISTOS DISC SIGN STRAINER");
  // map.put('\u101FB',"PHAISTOS DISC SIGN SMALL AXE");
  // map.put('\u101FC',"PHAISTOS DISC SIGN WAVY BAND");
  // map.put('\u101FD',"PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE");
  // map.put('\u10280',"LYCIAN LETTER A");
  // map.put('\u10281',"LYCIAN LETTER E");
  // map.put('\u10282',"LYCIAN LETTER B");
  // map.put('\u10283',"LYCIAN LETTER BH");
  // map.put('\u10284',"LYCIAN LETTER G");
  // map.put('\u10285',"LYCIAN LETTER D");
  // map.put('\u10286',"LYCIAN LETTER I");
  // map.put('\u10287',"LYCIAN LETTER W");
  // map.put('\u10288',"LYCIAN LETTER Z");
  // map.put('\u10289',"LYCIAN LETTER TH");
  // map.put('\u1028A',"LYCIAN LETTER J");
  // map.put('\u1028B',"LYCIAN LETTER K");
  // map.put('\u1028C',"LYCIAN LETTER Q");
  // map.put('\u1028D',"LYCIAN LETTER L");
  // map.put('\u1028E',"LYCIAN LETTER M");
  // map.put('\u1028F',"LYCIAN LETTER N");
  // map.put('\u10290',"LYCIAN LETTER MM");
  // map.put('\u10291',"LYCIAN LETTER NN");
  // map.put('\u10292',"LYCIAN LETTER U");
  // map.put('\u10293',"LYCIAN LETTER P");
  // map.put('\u10294',"LYCIAN LETTER KK");
  // map.put('\u10295',"LYCIAN LETTER R");
  // map.put('\u10296',"LYCIAN LETTER S");
  // map.put('\u10297',"LYCIAN LETTER T");
  // map.put('\u10298',"LYCIAN LETTER TT");
  // map.put('\u10299',"LYCIAN LETTER AN");
  // map.put('\u1029A',"LYCIAN LETTER EN");
  // map.put('\u1029B',"LYCIAN LETTER H");
  // map.put('\u1029C',"LYCIAN LETTER X");
  // map.put('\u102A0',"CARIAN LETTER A");
  // map.put('\u102A1',"CARIAN LETTER P2");
  // map.put('\u102A2',"CARIAN LETTER D");
  // map.put('\u102A3',"CARIAN LETTER L");
  // map.put('\u102A4',"CARIAN LETTER UUU");
  // map.put('\u102A5',"CARIAN LETTER R");
  // map.put('\u102A6',"CARIAN LETTER LD");
  // map.put('\u102A7',"CARIAN LETTER A2");
  // map.put('\u102A8',"CARIAN LETTER Q");
  // map.put('\u102A9',"CARIAN LETTER B");
  // map.put('\u102AA',"CARIAN LETTER M");
  // map.put('\u102AB',"CARIAN LETTER O");
  // map.put('\u102AC',"CARIAN LETTER D2");
  // map.put('\u102AD',"CARIAN LETTER T");
  // map.put('\u102AE',"CARIAN LETTER SH");
  // map.put('\u102AF',"CARIAN LETTER SH2");
  // map.put('\u102B0',"CARIAN LETTER S");
  // map.put('\u102B1',"CARIAN LETTER C-18");
  // map.put('\u102B2',"CARIAN LETTER U");
  // map.put('\u102B3',"CARIAN LETTER NN");
  // map.put('\u102B4',"CARIAN LETTER X");
  // map.put('\u102B5',"CARIAN LETTER N");
  // map.put('\u102B6',"CARIAN LETTER TT2");
  // map.put('\u102B7',"CARIAN LETTER P");
  // map.put('\u102B8',"CARIAN LETTER SS");
  // map.put('\u102B9',"CARIAN LETTER I");
  // map.put('\u102BA',"CARIAN LETTER E");
  // map.put('\u102BB',"CARIAN LETTER UUUU");
  // map.put('\u102BC',"CARIAN LETTER K");
  // map.put('\u102BD',"CARIAN LETTER K2");
  // map.put('\u102BE',"CARIAN LETTER ND");
  // map.put('\u102BF',"CARIAN LETTER UU");
  // map.put('\u102C0',"CARIAN LETTER G");
  // map.put('\u102C1',"CARIAN LETTER G2");
  // map.put('\u102C2',"CARIAN LETTER ST");
  // map.put('\u102C3',"CARIAN LETTER ST2");
  // map.put('\u102C4',"CARIAN LETTER NG");
  // map.put('\u102C5',"CARIAN LETTER II");
  // map.put('\u102C6',"CARIAN LETTER C-39");
  // map.put('\u102C7',"CARIAN LETTER TT");
  // map.put('\u102C8',"CARIAN LETTER UUU2");
  // map.put('\u102C9',"CARIAN LETTER RR");
  // map.put('\u102CA',"CARIAN LETTER MB");
  // map.put('\u102CB',"CARIAN LETTER MB2");
  // map.put('\u102CC',"CARIAN LETTER MB3");
  // map.put('\u102CD',"CARIAN LETTER MB4");
  // map.put('\u102CE',"CARIAN LETTER LD2");
  // map.put('\u102CF',"CARIAN LETTER E2");
  // map.put('\u102D0',"CARIAN LETTER UUU3");
  // map.put('\u10300',"OLD ITALIC LETTER A");
  // map.put('\u10301',"OLD ITALIC LETTER BE");
  // map.put('\u10302',"OLD ITALIC LETTER KE");
  // map.put('\u10303',"OLD ITALIC LETTER DE");
  // map.put('\u10304',"OLD ITALIC LETTER E");
  // map.put('\u10305',"OLD ITALIC LETTER VE");
  // map.put('\u10306',"OLD ITALIC LETTER ZE");
  // map.put('\u10307',"OLD ITALIC LETTER HE");
  // map.put('\u10308',"OLD ITALIC LETTER THE");
  // map.put('\u10309',"OLD ITALIC LETTER I");
  // map.put('\u1030A',"OLD ITALIC LETTER KA");
  // map.put('\u1030B',"OLD ITALIC LETTER EL");
  // map.put('\u1030C',"OLD ITALIC LETTER EM");
  // map.put('\u1030D',"OLD ITALIC LETTER EN");
  // map.put('\u1030E',"OLD ITALIC LETTER ESH");
  // map.put('\u1030F',"OLD ITALIC LETTER O");
  // map.put('\u10310',"OLD ITALIC LETTER PE");
  // map.put('\u10311',"OLD ITALIC LETTER SHE");
  // map.put('\u10312',"OLD ITALIC LETTER KU");
  // map.put('\u10313',"OLD ITALIC LETTER ER");
  // map.put('\u10314',"OLD ITALIC LETTER ES");
  // map.put('\u10315',"OLD ITALIC LETTER TE");
  // map.put('\u10316',"OLD ITALIC LETTER U");
  // map.put('\u10317',"OLD ITALIC LETTER EKS");
  // map.put('\u10318',"OLD ITALIC LETTER PHE");
  // map.put('\u10319',"OLD ITALIC LETTER KHE");
  // map.put('\u1031A',"OLD ITALIC LETTER EF");
  // map.put('\u1031B',"OLD ITALIC LETTER ERS");
  // map.put('\u1031C',"OLD ITALIC LETTER CHE");
  // map.put('\u1031D',"OLD ITALIC LETTER II");
  // map.put('\u1031E',"OLD ITALIC LETTER UU");
  // map.put('\u10320',"OLD ITALIC NUMERAL ONE");
  // map.put('\u10321',"OLD ITALIC NUMERAL FIVE");
  // map.put('\u10322',"OLD ITALIC NUMERAL TEN");
  // map.put('\u10323',"OLD ITALIC NUMERAL FIFTY");
  // map.put('\u10330',"GOTHIC LETTER AHSA");
  // map.put('\u10331',"GOTHIC LETTER BAIRKAN");
  // map.put('\u10332',"GOTHIC LETTER GIBA");
  // map.put('\u10333',"GOTHIC LETTER DAGS");
  // map.put('\u10334',"GOTHIC LETTER AIHVUS");
  // map.put('\u10335',"GOTHIC LETTER QAIRTHRA");
  // map.put('\u10336',"GOTHIC LETTER IUJA");
  // map.put('\u10337',"GOTHIC LETTER HAGL");
  // map.put('\u10338',"GOTHIC LETTER THIUTH");
  // map.put('\u10339',"GOTHIC LETTER EIS");
  // map.put('\u1033A',"GOTHIC LETTER KUSMA");
  // map.put('\u1033B',"GOTHIC LETTER LAGUS");
  // map.put('\u1033C',"GOTHIC LETTER MANNA");
  // map.put('\u1033D',"GOTHIC LETTER NAUTHS");
  // map.put('\u1033E',"GOTHIC LETTER JER");
  // map.put('\u1033F',"GOTHIC LETTER URUS");
  // map.put('\u10340',"GOTHIC LETTER PAIRTHRA");
  // map.put('\u10341',"GOTHIC LETTER NINETY");
  // map.put('\u10342',"GOTHIC LETTER RAIDA");
  // map.put('\u10343',"GOTHIC LETTER SAUIL");
  // map.put('\u10344',"GOTHIC LETTER TEIWS");
  // map.put('\u10345',"GOTHIC LETTER WINJA");
  // map.put('\u10346',"GOTHIC LETTER FAIHU");
  // map.put('\u10347',"GOTHIC LETTER IGGWS");
  // map.put('\u10348',"GOTHIC LETTER HWAIR");
  // map.put('\u10349',"GOTHIC LETTER OTHAL");
  // map.put('\u1034A',"GOTHIC LETTER NINE HUNDRED");
  // map.put('\u10380',"UGARITIC LETTER ALPA");
  // map.put('\u10381',"UGARITIC LETTER BETA");
  // map.put('\u10382',"UGARITIC LETTER GAMLA");
  // map.put('\u10383',"UGARITIC LETTER KHA");
  // map.put('\u10384',"UGARITIC LETTER DELTA");
  // map.put('\u10385',"UGARITIC LETTER HO");
  // map.put('\u10386',"UGARITIC LETTER WO");
  // map.put('\u10387',"UGARITIC LETTER ZETA");
  // map.put('\u10388',"UGARITIC LETTER HOTA");
  // map.put('\u10389',"UGARITIC LETTER TET");
  // map.put('\u1038A',"UGARITIC LETTER YOD");
  // map.put('\u1038B',"UGARITIC LETTER KAF");
  // map.put('\u1038C',"UGARITIC LETTER SHIN");
  // map.put('\u1038D',"UGARITIC LETTER LAMDA");
  // map.put('\u1038E',"UGARITIC LETTER MEM");
  // map.put('\u1038F',"UGARITIC LETTER DHAL");
  // map.put('\u10390',"UGARITIC LETTER NUN");
  // map.put('\u10391',"UGARITIC LETTER ZU");
  // map.put('\u10392',"UGARITIC LETTER SAMKA");
  // map.put('\u10393',"UGARITIC LETTER AIN");
  // map.put('\u10394',"UGARITIC LETTER PU");
  // map.put('\u10395',"UGARITIC LETTER SADE");
  // map.put('\u10396',"UGARITIC LETTER QOPA");
  // map.put('\u10397',"UGARITIC LETTER RASHA");
  // map.put('\u10398',"UGARITIC LETTER THANNA");
  // map.put('\u10399',"UGARITIC LETTER GHAIN");
  // map.put('\u1039A',"UGARITIC LETTER TO");
  // map.put('\u1039B',"UGARITIC LETTER I");
  // map.put('\u1039C',"UGARITIC LETTER U");
  // map.put('\u1039D',"UGARITIC LETTER SSU");
  // map.put('\u1039F',"UGARITIC WORD DIVIDER");
  // map.put('\u103A0',"OLD PERSIAN SIGN A");
  // map.put('\u103A1',"OLD PERSIAN SIGN I");
  // map.put('\u103A2',"OLD PERSIAN SIGN U");
  // map.put('\u103A3',"OLD PERSIAN SIGN KA");
  // map.put('\u103A4',"OLD PERSIAN SIGN KU");
  // map.put('\u103A5',"OLD PERSIAN SIGN GA");
  // map.put('\u103A6',"OLD PERSIAN SIGN GU");
  // map.put('\u103A7',"OLD PERSIAN SIGN XA");
  // map.put('\u103A8',"OLD PERSIAN SIGN CA");
  // map.put('\u103A9',"OLD PERSIAN SIGN JA");
  // map.put('\u103AA',"OLD PERSIAN SIGN JI");
  // map.put('\u103AB',"OLD PERSIAN SIGN TA");
  // map.put('\u103AC',"OLD PERSIAN SIGN TU");
  // map.put('\u103AD',"OLD PERSIAN SIGN DA");
  // map.put('\u103AE',"OLD PERSIAN SIGN DI");
  // map.put('\u103AF',"OLD PERSIAN SIGN DU");
  // map.put('\u103B0',"OLD PERSIAN SIGN THA");
  // map.put('\u103B1',"OLD PERSIAN SIGN PA");
  // map.put('\u103B2',"OLD PERSIAN SIGN BA");
  // map.put('\u103B3',"OLD PERSIAN SIGN FA");
  // map.put('\u103B4',"OLD PERSIAN SIGN NA");
  // map.put('\u103B5',"OLD PERSIAN SIGN NU");
  // map.put('\u103B6',"OLD PERSIAN SIGN MA");
  // map.put('\u103B7',"OLD PERSIAN SIGN MI");
  // map.put('\u103B8',"OLD PERSIAN SIGN MU");
  // map.put('\u103B9',"OLD PERSIAN SIGN YA");
  // map.put('\u103BA',"OLD PERSIAN SIGN VA");
  // map.put('\u103BB',"OLD PERSIAN SIGN VI");
  // map.put('\u103BC',"OLD PERSIAN SIGN RA");
  // map.put('\u103BD',"OLD PERSIAN SIGN RU");
  // map.put('\u103BE',"OLD PERSIAN SIGN LA");
  // map.put('\u103BF',"OLD PERSIAN SIGN SA");
  // map.put('\u103C0',"OLD PERSIAN SIGN ZA");
  // map.put('\u103C1',"OLD PERSIAN SIGN SHA");
  // map.put('\u103C2',"OLD PERSIAN SIGN SSA");
  // map.put('\u103C3',"OLD PERSIAN SIGN HA");
  // map.put('\u103C8',"OLD PERSIAN SIGN AURAMAZDAA");
  // map.put('\u103C9',"OLD PERSIAN SIGN AURAMAZDAA-2");
  // map.put('\u103CA',"OLD PERSIAN SIGN AURAMAZDAAHA");
  // map.put('\u103CB',"OLD PERSIAN SIGN XSHAAYATHIYA");
  // map.put('\u103CC',"OLD PERSIAN SIGN DAHYAAUSH");
  // map.put('\u103CD',"OLD PERSIAN SIGN DAHYAAUSH-2");
  // map.put('\u103CE',"OLD PERSIAN SIGN BAGA");
  // map.put('\u103CF',"OLD PERSIAN SIGN BUUMISH");
  // map.put('\u103D0',"OLD PERSIAN WORD DIVIDER");
  // map.put('\u103D1',"OLD PERSIAN NUMBER ONE");
  // map.put('\u103D2',"OLD PERSIAN NUMBER TWO");
  // map.put('\u103D3',"OLD PERSIAN NUMBER TEN");
  // map.put('\u103D4',"OLD PERSIAN NUMBER TWENTY");
  // map.put('\u103D5',"OLD PERSIAN NUMBER HUNDRED");
  // map.put('\u10400',"DESERET CAPITAL LETTER LONG I");
  // map.put('\u10401',"DESERET CAPITAL LETTER LONG E");
  // map.put('\u10402',"DESERET CAPITAL LETTER LONG A");
  // map.put('\u10403',"DESERET CAPITAL LETTER LONG AH");
  // map.put('\u10404',"DESERET CAPITAL LETTER LONG O");
  // map.put('\u10405',"DESERET CAPITAL LETTER LONG OO");
  // map.put('\u10406',"DESERET CAPITAL LETTER SHORT I");
  // map.put('\u10407',"DESERET CAPITAL LETTER SHORT E");
  // map.put('\u10408',"DESERET CAPITAL LETTER SHORT A");
  // map.put('\u10409',"DESERET CAPITAL LETTER SHORT AH");
  // map.put('\u1040A',"DESERET CAPITAL LETTER SHORT O");
  // map.put('\u1040B',"DESERET CAPITAL LETTER SHORT OO");
  // map.put('\u1040C',"DESERET CAPITAL LETTER AY");
  // map.put('\u1040D',"DESERET CAPITAL LETTER OW");
  // map.put('\u1040E',"DESERET CAPITAL LETTER WU");
  // map.put('\u1040F',"DESERET CAPITAL LETTER YEE");
  // map.put('\u10410',"DESERET CAPITAL LETTER H");
  // map.put('\u10411',"DESERET CAPITAL LETTER PEE");
  // map.put('\u10412',"DESERET CAPITAL LETTER BEE");
  // map.put('\u10413',"DESERET CAPITAL LETTER TEE");
  // map.put('\u10414',"DESERET CAPITAL LETTER DEE");
  // map.put('\u10415',"DESERET CAPITAL LETTER CHEE");
  // map.put('\u10416',"DESERET CAPITAL LETTER JEE");
  // map.put('\u10417',"DESERET CAPITAL LETTER KAY");
  // map.put('\u10418',"DESERET CAPITAL LETTER GAY");
  // map.put('\u10419',"DESERET CAPITAL LETTER EF");
  // map.put('\u1041A',"DESERET CAPITAL LETTER VEE");
  // map.put('\u1041B',"DESERET CAPITAL LETTER ETH");
  // map.put('\u1041C',"DESERET CAPITAL LETTER THEE");
  // map.put('\u1041D',"DESERET CAPITAL LETTER ES");
  // map.put('\u1041E',"DESERET CAPITAL LETTER ZEE");
  // map.put('\u1041F',"DESERET CAPITAL LETTER ESH");
  // map.put('\u10420',"DESERET CAPITAL LETTER ZHEE");
  // map.put('\u10421',"DESERET CAPITAL LETTER ER");
  // map.put('\u10422',"DESERET CAPITAL LETTER EL");
  // map.put('\u10423',"DESERET CAPITAL LETTER EM");
  // map.put('\u10424',"DESERET CAPITAL LETTER EN");
  // map.put('\u10425',"DESERET CAPITAL LETTER ENG");
  // map.put('\u10426',"DESERET CAPITAL LETTER OI");
  // map.put('\u10427',"DESERET CAPITAL LETTER EW");
  // map.put('\u10428',"DESERET SMALL LETTER LONG I");
  // map.put('\u10429',"DESERET SMALL LETTER LONG E");
  // map.put('\u1042A',"DESERET SMALL LETTER LONG A");
  // map.put('\u1042B',"DESERET SMALL LETTER LONG AH");
  // map.put('\u1042C',"DESERET SMALL LETTER LONG O");
  // map.put('\u1042D',"DESERET SMALL LETTER LONG OO");
  // map.put('\u1042E',"DESERET SMALL LETTER SHORT I");
  // map.put('\u1042F',"DESERET SMALL LETTER SHORT E");
  // map.put('\u10430',"DESERET SMALL LETTER SHORT A");
  // map.put('\u10431',"DESERET SMALL LETTER SHORT AH");
  // map.put('\u10432',"DESERET SMALL LETTER SHORT O");
  // map.put('\u10433',"DESERET SMALL LETTER SHORT OO");
  // map.put('\u10434',"DESERET SMALL LETTER AY");
  // map.put('\u10435',"DESERET SMALL LETTER OW");
  // map.put('\u10436',"DESERET SMALL LETTER WU");
  // map.put('\u10437',"DESERET SMALL LETTER YEE");
  // map.put('\u10438',"DESERET SMALL LETTER H");
  // map.put('\u10439',"DESERET SMALL LETTER PEE");
  // map.put('\u1043A',"DESERET SMALL LETTER BEE");
  // map.put('\u1043B',"DESERET SMALL LETTER TEE");
  // map.put('\u1043C',"DESERET SMALL LETTER DEE");
  // map.put('\u1043D',"DESERET SMALL LETTER CHEE");
  // map.put('\u1043E',"DESERET SMALL LETTER JEE");
  // map.put('\u1043F',"DESERET SMALL LETTER KAY");
  // map.put('\u10440',"DESERET SMALL LETTER GAY");
  // map.put('\u10441',"DESERET SMALL LETTER EF");
  // map.put('\u10442',"DESERET SMALL LETTER VEE");
  // map.put('\u10443',"DESERET SMALL LETTER ETH");
  // map.put('\u10444',"DESERET SMALL LETTER THEE");
  // map.put('\u10445',"DESERET SMALL LETTER ES");
  // map.put('\u10446',"DESERET SMALL LETTER ZEE");
  // map.put('\u10447',"DESERET SMALL LETTER ESH");
  // map.put('\u10448',"DESERET SMALL LETTER ZHEE");
  // map.put('\u10449',"DESERET SMALL LETTER ER");
  // map.put('\u1044A',"DESERET SMALL LETTER EL");
  // map.put('\u1044B',"DESERET SMALL LETTER EM");
  // map.put('\u1044C',"DESERET SMALL LETTER EN");
  // map.put('\u1044D',"DESERET SMALL LETTER ENG");
  // map.put('\u1044E',"DESERET SMALL LETTER OI");
  // map.put('\u1044F',"DESERET SMALL LETTER EW");
  // map.put('\u10450',"SHAVIAN LETTER PEEP");
  // map.put('\u10451',"SHAVIAN LETTER TOT");
  // map.put('\u10452',"SHAVIAN LETTER KICK");
  // map.put('\u10453',"SHAVIAN LETTER FEE");
  // map.put('\u10454',"SHAVIAN LETTER THIGH");
  // map.put('\u10455',"SHAVIAN LETTER SO");
  // map.put('\u10456',"SHAVIAN LETTER SURE");
  // map.put('\u10457',"SHAVIAN LETTER CHURCH");
  // map.put('\u10458',"SHAVIAN LETTER YEA");
  // map.put('\u10459',"SHAVIAN LETTER HUNG");
  // map.put('\u1045A',"SHAVIAN LETTER BIB");
  // map.put('\u1045B',"SHAVIAN LETTER DEAD");
  // map.put('\u1045C',"SHAVIAN LETTER GAG");
  // map.put('\u1045D',"SHAVIAN LETTER VOW");
  // map.put('\u1045E',"SHAVIAN LETTER THEY");
  // map.put('\u1045F',"SHAVIAN LETTER ZOO");
  // map.put('\u10460',"SHAVIAN LETTER MEASURE");
  // map.put('\u10461',"SHAVIAN LETTER JUDGE");
  // map.put('\u10462',"SHAVIAN LETTER WOE");
  // map.put('\u10463',"SHAVIAN LETTER HA-HA");
  // map.put('\u10464',"SHAVIAN LETTER LOLL");
  // map.put('\u10465',"SHAVIAN LETTER MIME");
  // map.put('\u10466',"SHAVIAN LETTER IF");
  // map.put('\u10467',"SHAVIAN LETTER EGG");
  // map.put('\u10468',"SHAVIAN LETTER ASH");
  // map.put('\u10469',"SHAVIAN LETTER ADO");
  // map.put('\u1046A',"SHAVIAN LETTER ON");
  // map.put('\u1046B',"SHAVIAN LETTER WOOL");
  // map.put('\u1046C',"SHAVIAN LETTER OUT");
  // map.put('\u1046D',"SHAVIAN LETTER AH");
  // map.put('\u1046E',"SHAVIAN LETTER ROAR");
  // map.put('\u1046F',"SHAVIAN LETTER NUN");
  // map.put('\u10470',"SHAVIAN LETTER EAT");
  // map.put('\u10471',"SHAVIAN LETTER AGE");
  // map.put('\u10472',"SHAVIAN LETTER ICE");
  // map.put('\u10473',"SHAVIAN LETTER UP");
  // map.put('\u10474',"SHAVIAN LETTER OAK");
  // map.put('\u10475',"SHAVIAN LETTER OOZE");
  // map.put('\u10476',"SHAVIAN LETTER OIL");
  // map.put('\u10477',"SHAVIAN LETTER AWE");
  // map.put('\u10478',"SHAVIAN LETTER ARE");
  // map.put('\u10479',"SHAVIAN LETTER OR");
  // map.put('\u1047A',"SHAVIAN LETTER AIR");
  // map.put('\u1047B',"SHAVIAN LETTER ERR");
  // map.put('\u1047C',"SHAVIAN LETTER ARRAY");
  // map.put('\u1047D',"SHAVIAN LETTER EAR");
  // map.put('\u1047E',"SHAVIAN LETTER IAN");
  // map.put('\u1047F',"SHAVIAN LETTER YEW");
  // map.put('\u10480',"OSMANYA LETTER ALEF");
  // map.put('\u10481',"OSMANYA LETTER BA");
  // map.put('\u10482',"OSMANYA LETTER TA");
  // map.put('\u10483',"OSMANYA LETTER JA");
  // map.put('\u10484',"OSMANYA LETTER XA");
  // map.put('\u10485',"OSMANYA LETTER KHA");
  // map.put('\u10486',"OSMANYA LETTER DEEL");
  // map.put('\u10487',"OSMANYA LETTER RA");
  // map.put('\u10488',"OSMANYA LETTER SA");
  // map.put('\u10489',"OSMANYA LETTER SHIIN");
  // map.put('\u1048A',"OSMANYA LETTER DHA");
  // map.put('\u1048B',"OSMANYA LETTER CAYN");
  // map.put('\u1048C',"OSMANYA LETTER GA");
  // map.put('\u1048D',"OSMANYA LETTER FA");
  // map.put('\u1048E',"OSMANYA LETTER QAAF");
  // map.put('\u1048F',"OSMANYA LETTER KAAF");
  // map.put('\u10490',"OSMANYA LETTER LAAN");
  // map.put('\u10491',"OSMANYA LETTER MIIN");
  // map.put('\u10492',"OSMANYA LETTER NUUN");
  // map.put('\u10493',"OSMANYA LETTER WAW");
  // map.put('\u10494',"OSMANYA LETTER HA");
  // map.put('\u10495',"OSMANYA LETTER YA");
  // map.put('\u10496',"OSMANYA LETTER A");
  // map.put('\u10497',"OSMANYA LETTER E");
  // map.put('\u10498',"OSMANYA LETTER I");
  // map.put('\u10499',"OSMANYA LETTER O");
  // map.put('\u1049A',"OSMANYA LETTER U");
  // map.put('\u1049B',"OSMANYA LETTER AA");
  // map.put('\u1049C',"OSMANYA LETTER EE");
  // map.put('\u1049D',"OSMANYA LETTER OO");
  // map.put('\u104A0',"OSMANYA DIGIT ZERO");
  // map.put('\u104A1',"OSMANYA DIGIT ONE");
  // map.put('\u104A2',"OSMANYA DIGIT TWO");
  // map.put('\u104A3',"OSMANYA DIGIT THREE");
  // map.put('\u104A4',"OSMANYA DIGIT FOUR");
  // map.put('\u104A5',"OSMANYA DIGIT FIVE");
  // map.put('\u104A6',"OSMANYA DIGIT SIX");
  // map.put('\u104A7',"OSMANYA DIGIT SEVEN");
  // map.put('\u104A8',"OSMANYA DIGIT EIGHT");
  // map.put('\u104A9',"OSMANYA DIGIT NINE");
  // map.put('\u10800',"CYPRIOT SYLLABLE A");
  // map.put('\u10801',"CYPRIOT SYLLABLE E");
  // map.put('\u10802',"CYPRIOT SYLLABLE I");
  // map.put('\u10803',"CYPRIOT SYLLABLE O");
  // map.put('\u10804',"CYPRIOT SYLLABLE U");
  // map.put('\u10805',"CYPRIOT SYLLABLE JA");
  // map.put('\u10808',"CYPRIOT SYLLABLE JO");
  // map.put('\u1080A',"CYPRIOT SYLLABLE KA");
  // map.put('\u1080B',"CYPRIOT SYLLABLE KE");
  // map.put('\u1080C',"CYPRIOT SYLLABLE KI");
  // map.put('\u1080D',"CYPRIOT SYLLABLE KO");
  // map.put('\u1080E',"CYPRIOT SYLLABLE KU");
  // map.put('\u1080F',"CYPRIOT SYLLABLE LA");
  // map.put('\u10810',"CYPRIOT SYLLABLE LE");
  // map.put('\u10811',"CYPRIOT SYLLABLE LI");
  // map.put('\u10812',"CYPRIOT SYLLABLE LO");
  // map.put('\u10813',"CYPRIOT SYLLABLE LU");
  // map.put('\u10814',"CYPRIOT SYLLABLE MA");
  // map.put('\u10815',"CYPRIOT SYLLABLE ME");
  // map.put('\u10816',"CYPRIOT SYLLABLE MI");
  // map.put('\u10817',"CYPRIOT SYLLABLE MO");
  // map.put('\u10818',"CYPRIOT SYLLABLE MU");
  // map.put('\u10819',"CYPRIOT SYLLABLE NA");
  // map.put('\u1081A',"CYPRIOT SYLLABLE NE");
  // map.put('\u1081B',"CYPRIOT SYLLABLE NI");
  // map.put('\u1081C',"CYPRIOT SYLLABLE NO");
  // map.put('\u1081D',"CYPRIOT SYLLABLE NU");
  // map.put('\u1081E',"CYPRIOT SYLLABLE PA");
  // map.put('\u1081F',"CYPRIOT SYLLABLE PE");
  // map.put('\u10820',"CYPRIOT SYLLABLE PI");
  // map.put('\u10821',"CYPRIOT SYLLABLE PO");
  // map.put('\u10822',"CYPRIOT SYLLABLE PU");
  // map.put('\u10823',"CYPRIOT SYLLABLE RA");
  // map.put('\u10824',"CYPRIOT SYLLABLE RE");
  // map.put('\u10825',"CYPRIOT SYLLABLE RI");
  // map.put('\u10826',"CYPRIOT SYLLABLE RO");
  // map.put('\u10827',"CYPRIOT SYLLABLE RU");
  // map.put('\u10828',"CYPRIOT SYLLABLE SA");
  // map.put('\u10829',"CYPRIOT SYLLABLE SE");
  // map.put('\u1082A',"CYPRIOT SYLLABLE SI");
  // map.put('\u1082B',"CYPRIOT SYLLABLE SO");
  // map.put('\u1082C',"CYPRIOT SYLLABLE SU");
  // map.put('\u1082D',"CYPRIOT SYLLABLE TA");
  // map.put('\u1082E',"CYPRIOT SYLLABLE TE");
  // map.put('\u1082F',"CYPRIOT SYLLABLE TI");
  // map.put('\u10830',"CYPRIOT SYLLABLE TO");
  // map.put('\u10831',"CYPRIOT SYLLABLE TU");
  // map.put('\u10832',"CYPRIOT SYLLABLE WA");
  // map.put('\u10833',"CYPRIOT SYLLABLE WE");
  // map.put('\u10834',"CYPRIOT SYLLABLE WI");
  // map.put('\u10835',"CYPRIOT SYLLABLE WO");
  // map.put('\u10837',"CYPRIOT SYLLABLE XA");
  // map.put('\u10838',"CYPRIOT SYLLABLE XE");
  // map.put('\u1083C',"CYPRIOT SYLLABLE ZA");
  // map.put('\u1083F',"CYPRIOT SYLLABLE ZO");
  // map.put('\u10840',"IMPERIAL ARAMAIC LETTER ALEPH");
  // map.put('\u10841',"IMPERIAL ARAMAIC LETTER BETH");
  // map.put('\u10842',"IMPERIAL ARAMAIC LETTER GIMEL");
  // map.put('\u10843',"IMPERIAL ARAMAIC LETTER DALETH");
  // map.put('\u10844',"IMPERIAL ARAMAIC LETTER HE");
  // map.put('\u10845',"IMPERIAL ARAMAIC LETTER WAW");
  // map.put('\u10846',"IMPERIAL ARAMAIC LETTER ZAYIN");
  // map.put('\u10847',"IMPERIAL ARAMAIC LETTER HETH");
  // map.put('\u10848',"IMPERIAL ARAMAIC LETTER TETH");
  // map.put('\u10849',"IMPERIAL ARAMAIC LETTER YODH");
  // map.put('\u1084A',"IMPERIAL ARAMAIC LETTER KAPH");
  // map.put('\u1084B',"IMPERIAL ARAMAIC LETTER LAMEDH");
  // map.put('\u1084C',"IMPERIAL ARAMAIC LETTER MEM");
  // map.put('\u1084D',"IMPERIAL ARAMAIC LETTER NUN");
  // map.put('\u1084E',"IMPERIAL ARAMAIC LETTER SAMEKH");
  // map.put('\u1084F',"IMPERIAL ARAMAIC LETTER AYIN");
  // map.put('\u10850',"IMPERIAL ARAMAIC LETTER PE");
  // map.put('\u10851',"IMPERIAL ARAMAIC LETTER SADHE");
  // map.put('\u10852',"IMPERIAL ARAMAIC LETTER QOPH");
  // map.put('\u10853',"IMPERIAL ARAMAIC LETTER RESH");
  // map.put('\u10854',"IMPERIAL ARAMAIC LETTER SHIN");
  // map.put('\u10855',"IMPERIAL ARAMAIC LETTER TAW");
  // map.put('\u10857',"IMPERIAL ARAMAIC SECTION SIGN");
  // map.put('\u10858',"IMPERIAL ARAMAIC NUMBER ONE");
  // map.put('\u10859',"IMPERIAL ARAMAIC NUMBER TWO");
  // map.put('\u1085A',"IMPERIAL ARAMAIC NUMBER THREE");
  // map.put('\u1085B',"IMPERIAL ARAMAIC NUMBER TEN");
  // map.put('\u1085C',"IMPERIAL ARAMAIC NUMBER TWENTY");
  // map.put('\u1085D',"IMPERIAL ARAMAIC NUMBER ONE HUNDRED");
  // map.put('\u1085E',"IMPERIAL ARAMAIC NUMBER ONE THOUSAND");
  // map.put('\u1085F',"IMPERIAL ARAMAIC NUMBER TEN THOUSAND");
  // map.put('\u10900',"PHOENICIAN LETTER ALF");
  // map.put('\u10901',"PHOENICIAN LETTER BET");
  // map.put('\u10902',"PHOENICIAN LETTER GAML");
  // map.put('\u10903',"PHOENICIAN LETTER DELT");
  // map.put('\u10904',"PHOENICIAN LETTER HE");
  // map.put('\u10905',"PHOENICIAN LETTER WAU");
  // map.put('\u10906',"PHOENICIAN LETTER ZAI");
  // map.put('\u10907',"PHOENICIAN LETTER HET");
  // map.put('\u10908',"PHOENICIAN LETTER TET");
  // map.put('\u10909',"PHOENICIAN LETTER YOD");
  // map.put('\u1090A',"PHOENICIAN LETTER KAF");
  // map.put('\u1090B',"PHOENICIAN LETTER LAMD");
  // map.put('\u1090C',"PHOENICIAN LETTER MEM");
  // map.put('\u1090D',"PHOENICIAN LETTER NUN");
  // map.put('\u1090E',"PHOENICIAN LETTER SEMK");
  // map.put('\u1090F',"PHOENICIAN LETTER AIN");
  // map.put('\u10910',"PHOENICIAN LETTER PE");
  // map.put('\u10911',"PHOENICIAN LETTER SADE");
  // map.put('\u10912',"PHOENICIAN LETTER QOF");
  // map.put('\u10913',"PHOENICIAN LETTER ROSH");
  // map.put('\u10914',"PHOENICIAN LETTER SHIN");
  // map.put('\u10915',"PHOENICIAN LETTER TAU");
  // map.put('\u10916',"PHOENICIAN NUMBER ONE");
  // map.put('\u10917',"PHOENICIAN NUMBER TEN");
  // map.put('\u10918',"PHOENICIAN NUMBER TWENTY");
  // map.put('\u10919',"PHOENICIAN NUMBER ONE HUNDRED");
  // map.put('\u1091A',"PHOENICIAN NUMBER TWO");
  // map.put('\u1091B',"PHOENICIAN NUMBER THREE");
  // map.put('\u1091F',"PHOENICIAN WORD SEPARATOR");
  // map.put('\u10920',"LYDIAN LETTER A");
  // map.put('\u10921',"LYDIAN LETTER B");
  // map.put('\u10922',"LYDIAN LETTER G");
  // map.put('\u10923',"LYDIAN LETTER D");
  // map.put('\u10924',"LYDIAN LETTER E");
  // map.put('\u10925',"LYDIAN LETTER V");
  // map.put('\u10926',"LYDIAN LETTER I");
  // map.put('\u10927',"LYDIAN LETTER Y");
  // map.put('\u10928',"LYDIAN LETTER K");
  // map.put('\u10929',"LYDIAN LETTER L");
  // map.put('\u1092A',"LYDIAN LETTER M");
  // map.put('\u1092B',"LYDIAN LETTER N");
  // map.put('\u1092C',"LYDIAN LETTER O");
  // map.put('\u1092D',"LYDIAN LETTER R");
  // map.put('\u1092E',"LYDIAN LETTER SS");
  // map.put('\u1092F',"LYDIAN LETTER T");
  // map.put('\u10930',"LYDIAN LETTER U");
  // map.put('\u10931',"LYDIAN LETTER F");
  // map.put('\u10932',"LYDIAN LETTER Q");
  // map.put('\u10933',"LYDIAN LETTER S");
  // map.put('\u10934',"LYDIAN LETTER TT");
  // map.put('\u10935',"LYDIAN LETTER AN");
  // map.put('\u10936',"LYDIAN LETTER EN");
  // map.put('\u10937',"LYDIAN LETTER LY");
  // map.put('\u10938',"LYDIAN LETTER NN");
  // map.put('\u10939',"LYDIAN LETTER C");
  // map.put('\u1093F',"LYDIAN TRIANGULAR MARK");
  // map.put('\u10A00',"KHAROSHTHI LETTER A");
  // map.put('\u10A01',"KHAROSHTHI VOWEL SIGN I");
  // map.put('\u10A02',"KHAROSHTHI VOWEL SIGN U");
  // map.put('\u10A03',"KHAROSHTHI VOWEL SIGN VOCALIC R");
  // map.put('\u10A05',"KHAROSHTHI VOWEL SIGN E");
  // map.put('\u10A06',"KHAROSHTHI VOWEL SIGN O");
  // map.put('\u10A0C',"KHAROSHTHI VOWEL LENGTH MARK");
  // map.put('\u10A0D',"KHAROSHTHI SIGN DOUBLE RING BELOW");
  // map.put('\u10A0E',"KHAROSHTHI SIGN ANUSVARA");
  // map.put('\u10A0F',"KHAROSHTHI SIGN VISARGA");
  // map.put('\u10A10',"KHAROSHTHI LETTER KA");
  // map.put('\u10A11',"KHAROSHTHI LETTER KHA");
  // map.put('\u10A12',"KHAROSHTHI LETTER GA");
  // map.put('\u10A13',"KHAROSHTHI LETTER GHA");
  // map.put('\u10A15',"KHAROSHTHI LETTER CA");
  // map.put('\u10A16',"KHAROSHTHI LETTER CHA");
  // map.put('\u10A17',"KHAROSHTHI LETTER JA");
  // map.put('\u10A19',"KHAROSHTHI LETTER NYA");
  // map.put('\u10A1A',"KHAROSHTHI LETTER TTA");
  // map.put('\u10A1B',"KHAROSHTHI LETTER TTHA");
  // map.put('\u10A1C',"KHAROSHTHI LETTER DDA");
  // map.put('\u10A1D',"KHAROSHTHI LETTER DDHA");
  // map.put('\u10A1E',"KHAROSHTHI LETTER NNA");
  // map.put('\u10A1F',"KHAROSHTHI LETTER TA");
  // map.put('\u10A20',"KHAROSHTHI LETTER THA");
  // map.put('\u10A21',"KHAROSHTHI LETTER DA");
  // map.put('\u10A22',"KHAROSHTHI LETTER DHA");
  // map.put('\u10A23',"KHAROSHTHI LETTER NA");
  // map.put('\u10A24',"KHAROSHTHI LETTER PA");
  // map.put('\u10A25',"KHAROSHTHI LETTER PHA");
  // map.put('\u10A26',"KHAROSHTHI LETTER BA");
  // map.put('\u10A27',"KHAROSHTHI LETTER BHA");
  // map.put('\u10A28',"KHAROSHTHI LETTER MA");
  // map.put('\u10A29',"KHAROSHTHI LETTER YA");
  // map.put('\u10A2A',"KHAROSHTHI LETTER RA");
  // map.put('\u10A2B',"KHAROSHTHI LETTER LA");
  // map.put('\u10A2C',"KHAROSHTHI LETTER VA");
  // map.put('\u10A2D',"KHAROSHTHI LETTER SHA");
  // map.put('\u10A2E',"KHAROSHTHI LETTER SSA");
  // map.put('\u10A2F',"KHAROSHTHI LETTER SA");
  // map.put('\u10A30',"KHAROSHTHI LETTER ZA");
  // map.put('\u10A31',"KHAROSHTHI LETTER HA");
  // map.put('\u10A32',"KHAROSHTHI LETTER KKA");
  // map.put('\u10A33',"KHAROSHTHI LETTER TTTHA");
  // map.put('\u10A38',"KHAROSHTHI SIGN BAR ABOVE");
  // map.put('\u10A39',"KHAROSHTHI SIGN CAUDA");
  // map.put('\u10A3A',"KHAROSHTHI SIGN DOT BELOW");
  // map.put('\u10A3F',"KHAROSHTHI VIRAMA");
  // map.put('\u10A40',"KHAROSHTHI DIGIT ONE");
  // map.put('\u10A41',"KHAROSHTHI DIGIT TWO");
  // map.put('\u10A42',"KHAROSHTHI DIGIT THREE");
  // map.put('\u10A43',"KHAROSHTHI DIGIT FOUR");
  // map.put('\u10A44',"KHAROSHTHI NUMBER TEN");
  // map.put('\u10A45',"KHAROSHTHI NUMBER TWENTY");
  // map.put('\u10A46',"KHAROSHTHI NUMBER ONE HUNDRED");
  // map.put('\u10A47',"KHAROSHTHI NUMBER ONE THOUSAND");
  // map.put('\u10A50',"KHAROSHTHI PUNCTUATION DOT");
  // map.put('\u10A51',"KHAROSHTHI PUNCTUATION SMALL CIRCLE");
  // map.put('\u10A52',"KHAROSHTHI PUNCTUATION CIRCLE");
  // map.put('\u10A53',"KHAROSHTHI PUNCTUATION CRESCENT BAR");
  // map.put('\u10A54',"KHAROSHTHI PUNCTUATION MANGALAM");
  // map.put('\u10A55',"KHAROSHTHI PUNCTUATION LOTUS");
  // map.put('\u10A56',"KHAROSHTHI PUNCTUATION DANDA");
  // map.put('\u10A57',"KHAROSHTHI PUNCTUATION DOUBLE DANDA");
  // map.put('\u10A58',"KHAROSHTHI PUNCTUATION LINES");
  // map.put('\u10A60',"OLD SOUTH ARABIAN LETTER HE");
  // map.put('\u10A61',"OLD SOUTH ARABIAN LETTER LAMEDH");
  // map.put('\u10A62',"OLD SOUTH ARABIAN LETTER HETH");
  // map.put('\u10A63',"OLD SOUTH ARABIAN LETTER MEM");
  // map.put('\u10A64',"OLD SOUTH ARABIAN LETTER QOPH");
  // map.put('\u10A65',"OLD SOUTH ARABIAN LETTER WAW");
  // map.put('\u10A66',"OLD SOUTH ARABIAN LETTER SHIN");
  // map.put('\u10A67',"OLD SOUTH ARABIAN LETTER RESH");
  // map.put('\u10A68',"OLD SOUTH ARABIAN LETTER BETH");
  // map.put('\u10A69',"OLD SOUTH ARABIAN LETTER TAW");
  // map.put('\u10A6A',"OLD SOUTH ARABIAN LETTER SAT");
  // map.put('\u10A6B',"OLD SOUTH ARABIAN LETTER KAPH");
  // map.put('\u10A6C',"OLD SOUTH ARABIAN LETTER NUN");
  // map.put('\u10A6D',"OLD SOUTH ARABIAN LETTER KHETH");
  // map.put('\u10A6E',"OLD SOUTH ARABIAN LETTER SADHE");
  // map.put('\u10A6F',"OLD SOUTH ARABIAN LETTER SAMEKH");
  // map.put('\u10A70',"OLD SOUTH ARABIAN LETTER FE");
  // map.put('\u10A71',"OLD SOUTH ARABIAN LETTER ALEF");
  // map.put('\u10A72',"OLD SOUTH ARABIAN LETTER AYN");
  // map.put('\u10A73',"OLD SOUTH ARABIAN LETTER DHADHE");
  // map.put('\u10A74',"OLD SOUTH ARABIAN LETTER GIMEL");
  // map.put('\u10A75',"OLD SOUTH ARABIAN LETTER DALETH");
  // map.put('\u10A76',"OLD SOUTH ARABIAN LETTER GHAYN");
  // map.put('\u10A77',"OLD SOUTH ARABIAN LETTER TETH");
  // map.put('\u10A78',"OLD SOUTH ARABIAN LETTER ZAYN");
  // map.put('\u10A79',"OLD SOUTH ARABIAN LETTER DHALETH");
  // map.put('\u10A7A',"OLD SOUTH ARABIAN LETTER YODH");
  // map.put('\u10A7B',"OLD SOUTH ARABIAN LETTER THAW");
  // map.put('\u10A7C',"OLD SOUTH ARABIAN LETTER THETH");
  // map.put('\u10A7D',"OLD SOUTH ARABIAN NUMBER ONE");
  // map.put('\u10A7E',"OLD SOUTH ARABIAN NUMBER FIFTY");
  // map.put('\u10A7F',"OLD SOUTH ARABIAN NUMERIC INDICATOR");
  // map.put('\u10B00',"AVESTAN LETTER A");
  // map.put('\u10B01',"AVESTAN LETTER AA");
  // map.put('\u10B02',"AVESTAN LETTER AO");
  // map.put('\u10B03',"AVESTAN LETTER AAO");
  // map.put('\u10B04',"AVESTAN LETTER AN");
  // map.put('\u10B05',"AVESTAN LETTER AAN");
  // map.put('\u10B06',"AVESTAN LETTER AE");
  // map.put('\u10B07',"AVESTAN LETTER AEE");
  // map.put('\u10B08',"AVESTAN LETTER E");
  // map.put('\u10B09',"AVESTAN LETTER EE");
  // map.put('\u10B0A',"AVESTAN LETTER O");
  // map.put('\u10B0B',"AVESTAN LETTER OO");
  // map.put('\u10B0C',"AVESTAN LETTER I");
  // map.put('\u10B0D',"AVESTAN LETTER II");
  // map.put('\u10B0E',"AVESTAN LETTER U");
  // map.put('\u10B0F',"AVESTAN LETTER UU");
  // map.put('\u10B10',"AVESTAN LETTER KE");
  // map.put('\u10B11',"AVESTAN LETTER XE");
  // map.put('\u10B12',"AVESTAN LETTER XYE");
  // map.put('\u10B13',"AVESTAN LETTER XVE");
  // map.put('\u10B14',"AVESTAN LETTER GE");
  // map.put('\u10B15',"AVESTAN LETTER GGE");
  // map.put('\u10B16',"AVESTAN LETTER GHE");
  // map.put('\u10B17',"AVESTAN LETTER CE");
  // map.put('\u10B18',"AVESTAN LETTER JE");
  // map.put('\u10B19',"AVESTAN LETTER TE");
  // map.put('\u10B1A',"AVESTAN LETTER THE");
  // map.put('\u10B1B',"AVESTAN LETTER DE");
  // map.put('\u10B1C',"AVESTAN LETTER DHE");
  // map.put('\u10B1D',"AVESTAN LETTER TTE");
  // map.put('\u10B1E',"AVESTAN LETTER PE");
  // map.put('\u10B1F',"AVESTAN LETTER FE");
  // map.put('\u10B20',"AVESTAN LETTER BE");
  // map.put('\u10B21',"AVESTAN LETTER BHE");
  // map.put('\u10B22',"AVESTAN LETTER NGE");
  // map.put('\u10B23',"AVESTAN LETTER NGYE");
  // map.put('\u10B24',"AVESTAN LETTER NGVE");
  // map.put('\u10B25',"AVESTAN LETTER NE");
  // map.put('\u10B26',"AVESTAN LETTER NYE");
  // map.put('\u10B27',"AVESTAN LETTER NNE");
  // map.put('\u10B28',"AVESTAN LETTER ME");
  // map.put('\u10B29',"AVESTAN LETTER HME");
  // map.put('\u10B2A',"AVESTAN LETTER YYE");
  // map.put('\u10B2B',"AVESTAN LETTER YE");
  // map.put('\u10B2C',"AVESTAN LETTER VE");
  // map.put('\u10B2D',"AVESTAN LETTER RE");
  // map.put('\u10B2E',"AVESTAN LETTER LE");
  // map.put('\u10B2F',"AVESTAN LETTER SE");
  // map.put('\u10B30',"AVESTAN LETTER ZE");
  // map.put('\u10B31',"AVESTAN LETTER SHE");
  // map.put('\u10B32',"AVESTAN LETTER ZHE");
  // map.put('\u10B33',"AVESTAN LETTER SHYE");
  // map.put('\u10B34',"AVESTAN LETTER SSHE");
  // map.put('\u10B35',"AVESTAN LETTER HE");
  // map.put('\u10B39',"AVESTAN ABBREVIATION MARK");
  // map.put('\u10B3A',"TINY TWO DOTS OVER ONE DOT PUNCTUATION");
  // map.put('\u10B3B',"SMALL TWO DOTS OVER ONE DOT PUNCTUATION");
  // map.put('\u10B3C',"LARGE TWO DOTS OVER ONE DOT PUNCTUATION");
  // map.put('\u10B3D',"LARGE ONE DOT OVER TWO DOTS PUNCTUATION");
  // map.put('\u10B3E',"LARGE TWO RINGS OVER ONE RING PUNCTUATION");
  // map.put('\u10B3F',"LARGE ONE RING OVER TWO RINGS PUNCTUATION");
  // map.put('\u10B40',"INSCRIPTIONAL PARTHIAN LETTER ALEPH");
  // map.put('\u10B41',"INSCRIPTIONAL PARTHIAN LETTER BETH");
  // map.put('\u10B42',"INSCRIPTIONAL PARTHIAN LETTER GIMEL");
  // map.put('\u10B43',"INSCRIPTIONAL PARTHIAN LETTER DALETH");
  // map.put('\u10B44',"INSCRIPTIONAL PARTHIAN LETTER HE");
  // map.put('\u10B45',"INSCRIPTIONAL PARTHIAN LETTER WAW");
  // map.put('\u10B46',"INSCRIPTIONAL PARTHIAN LETTER ZAYIN");
  // map.put('\u10B47',"INSCRIPTIONAL PARTHIAN LETTER HETH");
  // map.put('\u10B48',"INSCRIPTIONAL PARTHIAN LETTER TETH");
  // map.put('\u10B49',"INSCRIPTIONAL PARTHIAN LETTER YODH");
  // map.put('\u10B4A',"INSCRIPTIONAL PARTHIAN LETTER KAPH");
  // map.put('\u10B4B',"INSCRIPTIONAL PARTHIAN LETTER LAMEDH");
  // map.put('\u10B4C',"INSCRIPTIONAL PARTHIAN LETTER MEM");
  // map.put('\u10B4D',"INSCRIPTIONAL PARTHIAN LETTER NUN");
  // map.put('\u10B4E',"INSCRIPTIONAL PARTHIAN LETTER SAMEKH");
  // map.put('\u10B4F',"INSCRIPTIONAL PARTHIAN LETTER AYIN");
  // map.put('\u10B50',"INSCRIPTIONAL PARTHIAN LETTER PE");
  // map.put('\u10B51',"INSCRIPTIONAL PARTHIAN LETTER SADHE");
  // map.put('\u10B52',"INSCRIPTIONAL PARTHIAN LETTER QOPH");
  // map.put('\u10B53',"INSCRIPTIONAL PARTHIAN LETTER RESH");
  // map.put('\u10B54',"INSCRIPTIONAL PARTHIAN LETTER SHIN");
  // map.put('\u10B55',"INSCRIPTIONAL PARTHIAN LETTER TAW");
  // map.put('\u10B58',"INSCRIPTIONAL PARTHIAN NUMBER ONE");
  // map.put('\u10B59',"INSCRIPTIONAL PARTHIAN NUMBER TWO");
  // map.put('\u10B5A',"INSCRIPTIONAL PARTHIAN NUMBER THREE");
  // map.put('\u10B5B',"INSCRIPTIONAL PARTHIAN NUMBER FOUR");
  // map.put('\u10B5C',"INSCRIPTIONAL PARTHIAN NUMBER TEN");
  // map.put('\u10B5D',"INSCRIPTIONAL PARTHIAN NUMBER TWENTY");
  // map.put('\u10B5E',"INSCRIPTIONAL PARTHIAN NUMBER ONE HUNDRED");
  // map.put('\u10B5F',"INSCRIPTIONAL PARTHIAN NUMBER ONE THOUSAND");
  // map.put('\u10B60',"INSCRIPTIONAL PAHLAVI LETTER ALEPH");
  // map.put('\u10B61',"INSCRIPTIONAL PAHLAVI LETTER BETH");
  // map.put('\u10B62',"INSCRIPTIONAL PAHLAVI LETTER GIMEL");
  // map.put('\u10B63',"INSCRIPTIONAL PAHLAVI LETTER DALETH");
  // map.put('\u10B64',"INSCRIPTIONAL PAHLAVI LETTER HE");
  // map.put('\u10B65',"INSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESH");
  // map.put('\u10B66',"INSCRIPTIONAL PAHLAVI LETTER ZAYIN");
  // map.put('\u10B67',"INSCRIPTIONAL PAHLAVI LETTER HETH");
  // map.put('\u10B68',"INSCRIPTIONAL PAHLAVI LETTER TETH");
  // map.put('\u10B69',"INSCRIPTIONAL PAHLAVI LETTER YODH");
  // map.put('\u10B6A',"INSCRIPTIONAL PAHLAVI LETTER KAPH");
  // map.put('\u10B6B',"INSCRIPTIONAL PAHLAVI LETTER LAMEDH");
  // map.put('\u10B6C',"INSCRIPTIONAL PAHLAVI LETTER MEM-QOPH");
  // map.put('\u10B6D',"INSCRIPTIONAL PAHLAVI LETTER NUN");
  // map.put('\u10B6E',"INSCRIPTIONAL PAHLAVI LETTER SAMEKH");
  // map.put('\u10B6F',"INSCRIPTIONAL PAHLAVI LETTER PE");
  // map.put('\u10B70',"INSCRIPTIONAL PAHLAVI LETTER SADHE");
  // map.put('\u10B71',"INSCRIPTIONAL PAHLAVI LETTER SHIN");
  // map.put('\u10B72',"INSCRIPTIONAL PAHLAVI LETTER TAW");
  // map.put('\u10B78',"INSCRIPTIONAL PAHLAVI NUMBER ONE");
  // map.put('\u10B79',"INSCRIPTIONAL PAHLAVI NUMBER TWO");
  // map.put('\u10B7A',"INSCRIPTIONAL PAHLAVI NUMBER THREE");
  // map.put('\u10B7B',"INSCRIPTIONAL PAHLAVI NUMBER FOUR");
  // map.put('\u10B7C',"INSCRIPTIONAL PAHLAVI NUMBER TEN");
  // map.put('\u10B7D',"INSCRIPTIONAL PAHLAVI NUMBER TWENTY");
  // map.put('\u10B7E',"INSCRIPTIONAL PAHLAVI NUMBER ONE HUNDRED");
  // map.put('\u10B7F',"INSCRIPTIONAL PAHLAVI NUMBER ONE THOUSAND");
  // map.put('\u10C00',"OLD TURKIC LETTER ORKHON A");
  // map.put('\u10C01',"OLD TURKIC LETTER YENISEI A");
  // map.put('\u10C02',"OLD TURKIC LETTER YENISEI AE");
  // map.put('\u10C03',"OLD TURKIC LETTER ORKHON I");
  // map.put('\u10C04',"OLD TURKIC LETTER YENISEI I");
  // map.put('\u10C05',"OLD TURKIC LETTER YENISEI E");
  // map.put('\u10C06',"OLD TURKIC LETTER ORKHON O");
  // map.put('\u10C07',"OLD TURKIC LETTER ORKHON OE");
  // map.put('\u10C08',"OLD TURKIC LETTER YENISEI OE");
  // map.put('\u10C09',"OLD TURKIC LETTER ORKHON AB");
  // map.put('\u10C0A',"OLD TURKIC LETTER YENISEI AB");
  // map.put('\u10C0B',"OLD TURKIC LETTER ORKHON AEB");
  // map.put('\u10C0C',"OLD TURKIC LETTER YENISEI AEB");
  // map.put('\u10C0D',"OLD TURKIC LETTER ORKHON AG");
  // map.put('\u10C0E',"OLD TURKIC LETTER YENISEI AG");
  // map.put('\u10C0F',"OLD TURKIC LETTER ORKHON AEG");
  // map.put('\u10C10',"OLD TURKIC LETTER YENISEI AEG");
  // map.put('\u10C11',"OLD TURKIC LETTER ORKHON AD");
  // map.put('\u10C12',"OLD TURKIC LETTER YENISEI AD");
  // map.put('\u10C13',"OLD TURKIC LETTER ORKHON AED");
  // map.put('\u10C14',"OLD TURKIC LETTER ORKHON EZ");
  // map.put('\u10C15',"OLD TURKIC LETTER YENISEI EZ");
  // map.put('\u10C16',"OLD TURKIC LETTER ORKHON AY");
  // map.put('\u10C17',"OLD TURKIC LETTER YENISEI AY");
  // map.put('\u10C18',"OLD TURKIC LETTER ORKHON AEY");
  // map.put('\u10C19',"OLD TURKIC LETTER YENISEI AEY");
  // map.put('\u10C1A',"OLD TURKIC LETTER ORKHON AEK");
  // map.put('\u10C1B',"OLD TURKIC LETTER YENISEI AEK");
  // map.put('\u10C1C',"OLD TURKIC LETTER ORKHON OEK");
  // map.put('\u10C1D',"OLD TURKIC LETTER YENISEI OEK");
  // map.put('\u10C1E',"OLD TURKIC LETTER ORKHON AL");
  // map.put('\u10C1F',"OLD TURKIC LETTER YENISEI AL");
  // map.put('\u10C20',"OLD TURKIC LETTER ORKHON AEL");
  // map.put('\u10C21',"OLD TURKIC LETTER ORKHON ELT");
  // map.put('\u10C22',"OLD TURKIC LETTER ORKHON EM");
  // map.put('\u10C23',"OLD TURKIC LETTER ORKHON AN");
  // map.put('\u10C24',"OLD TURKIC LETTER ORKHON AEN");
  // map.put('\u10C25',"OLD TURKIC LETTER YENISEI AEN");
  // map.put('\u10C26',"OLD TURKIC LETTER ORKHON ENT");
  // map.put('\u10C27',"OLD TURKIC LETTER YENISEI ENT");
  // map.put('\u10C28',"OLD TURKIC LETTER ORKHON ENC");
  // map.put('\u10C29',"OLD TURKIC LETTER YENISEI ENC");
  // map.put('\u10C2A',"OLD TURKIC LETTER ORKHON ENY");
  // map.put('\u10C2B',"OLD TURKIC LETTER YENISEI ENY");
  // map.put('\u10C2C',"OLD TURKIC LETTER YENISEI ANG");
  // map.put('\u10C2D',"OLD TURKIC LETTER ORKHON ENG");
  // map.put('\u10C2E',"OLD TURKIC LETTER YENISEI AENG");
  // map.put('\u10C2F',"OLD TURKIC LETTER ORKHON EP");
  // map.put('\u10C30',"OLD TURKIC LETTER ORKHON OP");
  // map.put('\u10C31',"OLD TURKIC LETTER ORKHON IC");
  // map.put('\u10C32',"OLD TURKIC LETTER ORKHON EC");
  // map.put('\u10C33',"OLD TURKIC LETTER YENISEI EC");
  // map.put('\u10C34',"OLD TURKIC LETTER ORKHON AQ");
  // map.put('\u10C35',"OLD TURKIC LETTER YENISEI AQ");
  // map.put('\u10C36',"OLD TURKIC LETTER ORKHON IQ");
  // map.put('\u10C37',"OLD TURKIC LETTER YENISEI IQ");
  // map.put('\u10C38',"OLD TURKIC LETTER ORKHON OQ");
  // map.put('\u10C39',"OLD TURKIC LETTER YENISEI OQ");
  // map.put('\u10C3A',"OLD TURKIC LETTER ORKHON AR");
  // map.put('\u10C3B',"OLD TURKIC LETTER YENISEI AR");
  // map.put('\u10C3C',"OLD TURKIC LETTER ORKHON AER");
  // map.put('\u10C3D',"OLD TURKIC LETTER ORKHON AS");
  // map.put('\u10C3E',"OLD TURKIC LETTER ORKHON AES");
  // map.put('\u10C3F',"OLD TURKIC LETTER ORKHON ASH");
  // map.put('\u10C40',"OLD TURKIC LETTER YENISEI ASH");
  // map.put('\u10C41',"OLD TURKIC LETTER ORKHON ESH");
  // map.put('\u10C42',"OLD TURKIC LETTER YENISEI ESH");
  // map.put('\u10C43',"OLD TURKIC LETTER ORKHON AT");
  // map.put('\u10C44',"OLD TURKIC LETTER YENISEI AT");
  // map.put('\u10C45',"OLD TURKIC LETTER ORKHON AET");
  // map.put('\u10C46',"OLD TURKIC LETTER YENISEI AET");
  // map.put('\u10C47',"OLD TURKIC LETTER ORKHON OT");
  // map.put('\u10C48',"OLD TURKIC LETTER ORKHON BASH");
  // map.put('\u10E60',"RUMI DIGIT ONE");
  // map.put('\u10E61',"RUMI DIGIT TWO");
  // map.put('\u10E62',"RUMI DIGIT THREE");
  // map.put('\u10E63',"RUMI DIGIT FOUR");
  // map.put('\u10E64',"RUMI DIGIT FIVE");
  // map.put('\u10E65',"RUMI DIGIT SIX");
  // map.put('\u10E66',"RUMI DIGIT SEVEN");
  // map.put('\u10E67',"RUMI DIGIT EIGHT");
  // map.put('\u10E68',"RUMI DIGIT NINE");
  // map.put('\u10E69',"RUMI NUMBER TEN");
  // map.put('\u10E6A',"RUMI NUMBER TWENTY");
  // map.put('\u10E6B',"RUMI NUMBER THIRTY");
  // map.put('\u10E6C',"RUMI NUMBER FORTY");
  // map.put('\u10E6D',"RUMI NUMBER FIFTY");
  // map.put('\u10E6E',"RUMI NUMBER SIXTY");
  // map.put('\u10E6F',"RUMI NUMBER SEVENTY");
  // map.put('\u10E70',"RUMI NUMBER EIGHTY");
  // map.put('\u10E71',"RUMI NUMBER NINETY");
  // map.put('\u10E72',"RUMI NUMBER ONE HUNDRED");
  // map.put('\u10E73',"RUMI NUMBER TWO HUNDRED");
  // map.put('\u10E74',"RUMI NUMBER THREE HUNDRED");
  // map.put('\u10E75',"RUMI NUMBER FOUR HUNDRED");
  // map.put('\u10E76',"RUMI NUMBER FIVE HUNDRED");
  // map.put('\u10E77',"RUMI NUMBER SIX HUNDRED");
  // map.put('\u10E78',"RUMI NUMBER SEVEN HUNDRED");
  // map.put('\u10E79',"RUMI NUMBER EIGHT HUNDRED");
  // map.put('\u10E7A',"RUMI NUMBER NINE HUNDRED");
  // map.put('\u10E7B',"RUMI FRACTION ONE HALF");
  // map.put('\u10E7C',"RUMI FRACTION ONE QUARTER");
  // map.put('\u10E7D',"RUMI FRACTION ONE THIRD");
  // map.put('\u10E7E',"RUMI FRACTION TWO THIRDS");
  // map.put('\u11080',"KAITHI SIGN CANDRABINDU");
  // map.put('\u11081',"KAITHI SIGN ANUSVARA");
  // map.put('\u11082',"KAITHI SIGN VISARGA");
  // map.put('\u11083',"KAITHI LETTER A");
  // map.put('\u11084',"KAITHI LETTER AA");
  // map.put('\u11085',"KAITHI LETTER I");
  // map.put('\u11086',"KAITHI LETTER II");
  // map.put('\u11087',"KAITHI LETTER U");
  // map.put('\u11088',"KAITHI LETTER UU");
  // map.put('\u11089',"KAITHI LETTER E");
  // map.put('\u1108A',"KAITHI LETTER AI");
  // map.put('\u1108B',"KAITHI LETTER O");
  // map.put('\u1108C',"KAITHI LETTER AU");
  // map.put('\u1108D',"KAITHI LETTER KA");
  // map.put('\u1108E',"KAITHI LETTER KHA");
  // map.put('\u1108F',"KAITHI LETTER GA");
  // map.put('\u11090',"KAITHI LETTER GHA");
  // map.put('\u11091',"KAITHI LETTER NGA");
  // map.put('\u11092',"KAITHI LETTER CA");
  // map.put('\u11093',"KAITHI LETTER CHA");
  // map.put('\u11094',"KAITHI LETTER JA");
  // map.put('\u11095',"KAITHI LETTER JHA");
  // map.put('\u11096',"KAITHI LETTER NYA");
  // map.put('\u11097',"KAITHI LETTER TTA");
  // map.put('\u11098',"KAITHI LETTER TTHA");
  // map.put('\u11099',"KAITHI LETTER DDA");
  // map.put('\u1109A',"KAITHI LETTER DDDHA");
  // map.put('\u1109B',"KAITHI LETTER DDHA");
  // map.put('\u1109C',"KAITHI LETTER RHA");
  // map.put('\u1109D',"KAITHI LETTER NNA");
  // map.put('\u1109E',"KAITHI LETTER TA");
  // map.put('\u1109F',"KAITHI LETTER THA");
  // map.put('\u110A0',"KAITHI LETTER DA");
  // map.put('\u110A1',"KAITHI LETTER DHA");
  // map.put('\u110A2',"KAITHI LETTER NA");
  // map.put('\u110A3',"KAITHI LETTER PA");
  // map.put('\u110A4',"KAITHI LETTER PHA");
  // map.put('\u110A5',"KAITHI LETTER BA");
  // map.put('\u110A6',"KAITHI LETTER BHA");
  // map.put('\u110A7',"KAITHI LETTER MA");
  // map.put('\u110A8',"KAITHI LETTER YA");
  // map.put('\u110A9',"KAITHI LETTER RA");
  // map.put('\u110AA',"KAITHI LETTER LA");
  // map.put('\u110AB',"KAITHI LETTER VA");
  // map.put('\u110AC',"KAITHI LETTER SHA");
  // map.put('\u110AD',"KAITHI LETTER SSA");
  // map.put('\u110AE',"KAITHI LETTER SA");
  // map.put('\u110AF',"KAITHI LETTER HA");
  // map.put('\u110B0',"KAITHI VOWEL SIGN AA");
  // map.put('\u110B1',"KAITHI VOWEL SIGN I");
  // map.put('\u110B2',"KAITHI VOWEL SIGN II");
  // map.put('\u110B3',"KAITHI VOWEL SIGN U");
  // map.put('\u110B4',"KAITHI VOWEL SIGN UU");
  // map.put('\u110B5',"KAITHI VOWEL SIGN E");
  // map.put('\u110B6',"KAITHI VOWEL SIGN AI");
  // map.put('\u110B7',"KAITHI VOWEL SIGN O");
  // map.put('\u110B8',"KAITHI VOWEL SIGN AU");
  // map.put('\u110B9',"KAITHI SIGN VIRAMA");
  // map.put('\u110BA',"KAITHI SIGN NUKTA");
  // map.put('\u110BB',"KAITHI ABBREVIATION SIGN");
  // map.put('\u110BC',"KAITHI ENUMERATION SIGN");
  // map.put('\u110BD',"KAITHI NUMBER SIGN");
  // map.put('\u110BE',"KAITHI SECTION MARK");
  // map.put('\u110BF',"KAITHI DOUBLE SECTION MARK");
  // map.put('\u110C0',"KAITHI DANDA");
  // map.put('\u110C1',"KAITHI DOUBLE DANDA");
  // map.put('\u12000',"CUNEIFORM SIGN A");
  // map.put('\u12001',"CUNEIFORM SIGN A TIMES A");
  // map.put('\u12002',"CUNEIFORM SIGN A TIMES BAD");
  // map.put('\u12003',"CUNEIFORM SIGN A TIMES GAN2 TENU");
  // map.put('\u12004',"CUNEIFORM SIGN A TIMES HA");
  // map.put('\u12005',"CUNEIFORM SIGN A TIMES IGI");
  // map.put('\u12006',"CUNEIFORM SIGN A TIMES LAGAR GUNU");
  // map.put('\u12007',"CUNEIFORM SIGN A TIMES MUSH");
  // map.put('\u12008',"CUNEIFORM SIGN A TIMES SAG");
  // map.put('\u12009',"CUNEIFORM SIGN A2");
  // map.put('\u1200A',"CUNEIFORM SIGN AB");
  // map.put('\u1200B',"CUNEIFORM SIGN AB TIMES ASH2");
  // map.put('\u1200C',"CUNEIFORM SIGN AB TIMES DUN3 GUNU");
  // map.put('\u1200D',"CUNEIFORM SIGN AB TIMES GAL");
  // map.put('\u1200E',"CUNEIFORM SIGN AB TIMES GAN2 TENU");
  // map.put('\u1200F',"CUNEIFORM SIGN AB TIMES HA");
  // map.put('\u12010',"CUNEIFORM SIGN AB TIMES IGI GUNU");
  // map.put('\u12011',"CUNEIFORM SIGN AB TIMES IMIN");
  // map.put('\u12012',"CUNEIFORM SIGN AB TIMES LAGAB");
  // map.put('\u12013',"CUNEIFORM SIGN AB TIMES SHESH");
  // map.put('\u12014',"CUNEIFORM SIGN AB TIMES U PLUS U PLUS U");
  // map.put('\u12015',"CUNEIFORM SIGN AB GUNU");
  // map.put('\u12016',"CUNEIFORM SIGN AB2");
  // map.put('\u12017',"CUNEIFORM SIGN AB2 TIMES BALAG");
  // map.put('\u12018',"CUNEIFORM SIGN AB2 TIMES GAN2 TENU");
  // map.put('\u12019',"CUNEIFORM SIGN AB2 TIMES ME PLUS EN");
  // map.put('\u1201A',"CUNEIFORM SIGN AB2 TIMES SHA3");
  // map.put('\u1201B',"CUNEIFORM SIGN AB2 TIMES TAK4");
  // map.put('\u1201C',"CUNEIFORM SIGN AD");
  // map.put('\u1201D',"CUNEIFORM SIGN AK");
  // map.put('\u1201E',"CUNEIFORM SIGN AK TIMES ERIN2");
  // map.put('\u1201F',"CUNEIFORM SIGN AK TIMES SHITA PLUS GISH");
  // map.put('\u12020',"CUNEIFORM SIGN AL");
  // map.put('\u12021',"CUNEIFORM SIGN AL TIMES AL");
  // map.put('\u12022',"CUNEIFORM SIGN AL TIMES DIM2");
  // map.put('\u12023',"CUNEIFORM SIGN AL TIMES GISH");
  // map.put('\u12024',"CUNEIFORM SIGN AL TIMES HA");
  // map.put('\u12025',"CUNEIFORM SIGN AL TIMES KAD3");
  // map.put('\u12026',"CUNEIFORM SIGN AL TIMES KI");
  // map.put('\u12027',"CUNEIFORM SIGN AL TIMES SHE");
  // map.put('\u12028',"CUNEIFORM SIGN AL TIMES USH");
  // map.put('\u12029',"CUNEIFORM SIGN ALAN");
  // map.put('\u1202A',"CUNEIFORM SIGN ALEPH");
  // map.put('\u1202B',"CUNEIFORM SIGN AMAR");
  // map.put('\u1202C',"CUNEIFORM SIGN AMAR TIMES SHE");
  // map.put('\u1202D',"CUNEIFORM SIGN AN");
  // map.put('\u1202E',"CUNEIFORM SIGN AN OVER AN");
  // map.put('\u1202F',"CUNEIFORM SIGN AN THREE TIMES");
  // map.put('\u12030',"CUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGA");
  // map.put('\u12031',"CUNEIFORM SIGN AN PLUS NAGA SQUARED");
  // map.put('\u12032',"CUNEIFORM SIGN ANSHE");
  // map.put('\u12033',"CUNEIFORM SIGN APIN");
  // map.put('\u12034',"CUNEIFORM SIGN ARAD");
  // map.put('\u12035',"CUNEIFORM SIGN ARAD TIMES KUR");
  // map.put('\u12036',"CUNEIFORM SIGN ARKAB");
  // map.put('\u12037',"CUNEIFORM SIGN ASAL2");
  // map.put('\u12038',"CUNEIFORM SIGN ASH");
  // map.put('\u12039',"CUNEIFORM SIGN ASH ZIDA TENU");
  // map.put('\u1203A',"CUNEIFORM SIGN ASH KABA TENU");
  // map.put('\u1203B',"CUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAP");
  // map.put('\u1203C',"CUNEIFORM SIGN ASH OVER ASH OVER ASH");
  // map.put('\u1203D',"CUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER ASH");
  // map.put('\u1203E',"CUNEIFORM SIGN ASH2");
  // map.put('\u1203F',"CUNEIFORM SIGN ASHGAB");
  // map.put('\u12040',"CUNEIFORM SIGN BA");
  // map.put('\u12041',"CUNEIFORM SIGN BAD");
  // map.put('\u12042',"CUNEIFORM SIGN BAG3");
  // map.put('\u12043',"CUNEIFORM SIGN BAHAR2");
  // map.put('\u12044',"CUNEIFORM SIGN BAL");
  // map.put('\u12045',"CUNEIFORM SIGN BAL OVER BAL");
  // map.put('\u12046',"CUNEIFORM SIGN BALAG");
  // map.put('\u12047',"CUNEIFORM SIGN BAR");
  // map.put('\u12048',"CUNEIFORM SIGN BARA2");
  // map.put('\u12049',"CUNEIFORM SIGN BI");
  // map.put('\u1204A',"CUNEIFORM SIGN BI TIMES A");
  // map.put('\u1204B',"CUNEIFORM SIGN BI TIMES GAR");
  // map.put('\u1204C',"CUNEIFORM SIGN BI TIMES IGI GUNU");
  // map.put('\u1204D',"CUNEIFORM SIGN BU");
  // map.put('\u1204E',"CUNEIFORM SIGN BU OVER BU AB");
  // map.put('\u1204F',"CUNEIFORM SIGN BU OVER BU UN");
  // map.put('\u12050',"CUNEIFORM SIGN BU CROSSING BU");
  // map.put('\u12051',"CUNEIFORM SIGN BULUG");
  // map.put('\u12052',"CUNEIFORM SIGN BULUG OVER BULUG");
  // map.put('\u12053',"CUNEIFORM SIGN BUR");
  // map.put('\u12054',"CUNEIFORM SIGN BUR2");
  // map.put('\u12055',"CUNEIFORM SIGN DA");
  // map.put('\u12056',"CUNEIFORM SIGN DAG");
  // map.put('\u12057',"CUNEIFORM SIGN DAG KISIM5 TIMES A PLUS MASH");
  // map.put('\u12058',"CUNEIFORM SIGN DAG KISIM5 TIMES AMAR");
  // map.put('\u12059',"CUNEIFORM SIGN DAG KISIM5 TIMES BALAG");
  // map.put('\u1205A',"CUNEIFORM SIGN DAG KISIM5 TIMES BI");
  // map.put('\u1205B',"CUNEIFORM SIGN DAG KISIM5 TIMES GA");
  // map.put('\u1205C',"CUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASH");
  // map.put('\u1205D',"CUNEIFORM SIGN DAG KISIM5 TIMES GI");
  // map.put('\u1205E',"CUNEIFORM SIGN DAG KISIM5 TIMES GIR2");
  // map.put('\u1205F',"CUNEIFORM SIGN DAG KISIM5 TIMES GUD");
  // map.put('\u12060',"CUNEIFORM SIGN DAG KISIM5 TIMES HA");
  // map.put('\u12061',"CUNEIFORM SIGN DAG KISIM5 TIMES IR");
  // map.put('\u12062',"CUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LU");
  // map.put('\u12063',"CUNEIFORM SIGN DAG KISIM5 TIMES KAK");
  // map.put('\u12064',"CUNEIFORM SIGN DAG KISIM5 TIMES LA");
  // map.put('\u12065',"CUNEIFORM SIGN DAG KISIM5 TIMES LU");
  // map.put('\u12066',"CUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2");
  // map.put('\u12067',"CUNEIFORM SIGN DAG KISIM5 TIMES LUM");
  // map.put('\u12068',"CUNEIFORM SIGN DAG KISIM5 TIMES NE");
  // map.put('\u12069',"CUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAP");
  // map.put('\u1206A',"CUNEIFORM SIGN DAG KISIM5 TIMES SI");
  // map.put('\u1206B',"CUNEIFORM SIGN DAG KISIM5 TIMES TAK4");
  // map.put('\u1206C',"CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2");
  // map.put('\u1206D',"CUNEIFORM SIGN DAG KISIM5 TIMES USH");
  // map.put('\u1206E',"CUNEIFORM SIGN DAM");
  // map.put('\u1206F',"CUNEIFORM SIGN DAR");
  // map.put('\u12070',"CUNEIFORM SIGN DARA3");
  // map.put('\u12071',"CUNEIFORM SIGN DARA4");
  // map.put('\u12072',"CUNEIFORM SIGN DI");
  // map.put('\u12073',"CUNEIFORM SIGN DIB");
  // map.put('\u12074',"CUNEIFORM SIGN DIM");
  // map.put('\u12075',"CUNEIFORM SIGN DIM TIMES SHE");
  // map.put('\u12076',"CUNEIFORM SIGN DIM2");
  // map.put('\u12077',"CUNEIFORM SIGN DIN");
  // map.put('\u12078',"CUNEIFORM SIGN DIN KASKAL U GUNU DISH");
  // map.put('\u12079',"CUNEIFORM SIGN DISH");
  // map.put('\u1207A',"CUNEIFORM SIGN DU");
  // map.put('\u1207B',"CUNEIFORM SIGN DU OVER DU");
  // map.put('\u1207C',"CUNEIFORM SIGN DU GUNU");
  // map.put('\u1207D',"CUNEIFORM SIGN DU SHESHIG");
  // map.put('\u1207E',"CUNEIFORM SIGN DUB");
  // map.put('\u1207F',"CUNEIFORM SIGN DUB TIMES ESH2");
  // map.put('\u12080',"CUNEIFORM SIGN DUB2");
  // map.put('\u12081',"CUNEIFORM SIGN DUG");
  // map.put('\u12082',"CUNEIFORM SIGN DUGUD");
  // map.put('\u12083',"CUNEIFORM SIGN DUH");
  // map.put('\u12084',"CUNEIFORM SIGN DUN");
  // map.put('\u12085',"CUNEIFORM SIGN DUN3");
  // map.put('\u12086',"CUNEIFORM SIGN DUN3 GUNU");
  // map.put('\u12087',"CUNEIFORM SIGN DUN3 GUNU GUNU");
  // map.put('\u12088',"CUNEIFORM SIGN DUN4");
  // map.put('\u12089',"CUNEIFORM SIGN DUR2");
  // map.put('\u1208A',"CUNEIFORM SIGN E");
  // map.put('\u1208B',"CUNEIFORM SIGN E TIMES PAP");
  // map.put('\u1208C',"CUNEIFORM SIGN E OVER E NUN OVER NUN");
  // map.put('\u1208D',"CUNEIFORM SIGN E2");
  // map.put('\u1208E',"CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DA");
  // map.put('\u1208F',"CUNEIFORM SIGN E2 TIMES GAR");
  // map.put('\u12090',"CUNEIFORM SIGN E2 TIMES MI");
  // map.put('\u12091',"CUNEIFORM SIGN E2 TIMES SAL");
  // map.put('\u12092',"CUNEIFORM SIGN E2 TIMES SHE");
  // map.put('\u12093',"CUNEIFORM SIGN E2 TIMES U");
  // map.put('\u12094',"CUNEIFORM SIGN EDIN");
  // map.put('\u12095',"CUNEIFORM SIGN EGIR");
  // map.put('\u12096',"CUNEIFORM SIGN EL");
  // map.put('\u12097',"CUNEIFORM SIGN EN");
  // map.put('\u12098',"CUNEIFORM SIGN EN TIMES GAN2");
  // map.put('\u12099',"CUNEIFORM SIGN EN TIMES GAN2 TENU");
  // map.put('\u1209A',"CUNEIFORM SIGN EN TIMES ME");
  // map.put('\u1209B',"CUNEIFORM SIGN EN CROSSING EN");
  // map.put('\u1209C',"CUNEIFORM SIGN EN OPPOSING EN");
  // map.put('\u1209D',"CUNEIFORM SIGN EN SQUARED");
  // map.put('\u1209E',"CUNEIFORM SIGN EREN");
  // map.put('\u1209F',"CUNEIFORM SIGN ERIN2");
  // map.put('\u120A0',"CUNEIFORM SIGN ESH2");
  // map.put('\u120A1',"CUNEIFORM SIGN EZEN");
  // map.put('\u120A2',"CUNEIFORM SIGN EZEN TIMES A");
  // map.put('\u120A3',"CUNEIFORM SIGN EZEN TIMES A PLUS LAL");
  // map.put('\u120A4',"CUNEIFORM SIGN EZEN TIMES A PLUS LAL TIMES LAL");
  // map.put('\u120A5',"CUNEIFORM SIGN EZEN TIMES AN");
  // map.put('\u120A6',"CUNEIFORM SIGN EZEN TIMES BAD");
  // map.put('\u120A7',"CUNEIFORM SIGN EZEN TIMES DUN3 GUNU");
  // map.put('\u120A8',"CUNEIFORM SIGN EZEN TIMES DUN3 GUNU GUNU");
  // map.put('\u120A9',"CUNEIFORM SIGN EZEN TIMES HA");
  // map.put('\u120AA',"CUNEIFORM SIGN EZEN TIMES HA GUNU");
  // map.put('\u120AB',"CUNEIFORM SIGN EZEN TIMES IGI GUNU");
  // map.put('\u120AC',"CUNEIFORM SIGN EZEN TIMES KASKAL");
  // map.put('\u120AD',"CUNEIFORM SIGN EZEN TIMES KASKAL SQUARED");
  // map.put('\u120AE',"CUNEIFORM SIGN EZEN TIMES KU3");
  // map.put('\u120AF',"CUNEIFORM SIGN EZEN TIMES LA");
  // map.put('\u120B0',"CUNEIFORM SIGN EZEN TIMES LAL TIMES LAL");
  // map.put('\u120B1',"CUNEIFORM SIGN EZEN TIMES LI");
  // map.put('\u120B2',"CUNEIFORM SIGN EZEN TIMES LU");
  // map.put('\u120B3',"CUNEIFORM SIGN EZEN TIMES U2");
  // map.put('\u120B4',"CUNEIFORM SIGN EZEN TIMES UD");
  // map.put('\u120B5',"CUNEIFORM SIGN GA");
  // map.put('\u120B6',"CUNEIFORM SIGN GA GUNU");
  // map.put('\u120B7',"CUNEIFORM SIGN GA2");
  // map.put('\u120B8',"CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HA");
  // map.put('\u120B9',"CUNEIFORM SIGN GA2 TIMES A PLUS HA");
  // map.put('\u120BA',"CUNEIFORM SIGN GA2 TIMES A PLUS IGI");
  // map.put('\u120BB',"CUNEIFORM SIGN GA2 TIMES AB2 TENU PLUS TAB");
  // map.put('\u120BC',"CUNEIFORM SIGN GA2 TIMES AN");
  // map.put('\u120BD',"CUNEIFORM SIGN GA2 TIMES ASH");
  // map.put('\u120BE',"CUNEIFORM SIGN GA2 TIMES ASH2 PLUS GAL");
  // map.put('\u120BF',"CUNEIFORM SIGN GA2 TIMES BAD");
  // map.put('\u120C0',"CUNEIFORM SIGN GA2 TIMES BAR PLUS RA");
  // map.put('\u120C1',"CUNEIFORM SIGN GA2 TIMES BUR");
  // map.put('\u120C2',"CUNEIFORM SIGN GA2 TIMES BUR PLUS RA");
  // map.put('\u120C3',"CUNEIFORM SIGN GA2 TIMES DA");
  // map.put('\u120C4',"CUNEIFORM SIGN GA2 TIMES DI");
  // map.put('\u120C5',"CUNEIFORM SIGN GA2 TIMES DIM TIMES SHE");
  // map.put('\u120C6',"CUNEIFORM SIGN GA2 TIMES DUB");
  // map.put('\u120C7',"CUNEIFORM SIGN GA2 TIMES EL");
  // map.put('\u120C8',"CUNEIFORM SIGN GA2 TIMES EL PLUS LA");
  // map.put('\u120C9',"CUNEIFORM SIGN GA2 TIMES EN");
  // map.put('\u120CA',"CUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENU");
  // map.put('\u120CB',"CUNEIFORM SIGN GA2 TIMES GAN2 TENU");
  // map.put('\u120CC',"CUNEIFORM SIGN GA2 TIMES GAR");
  // map.put('\u120CD',"CUNEIFORM SIGN GA2 TIMES GI");
  // map.put('\u120CE',"CUNEIFORM SIGN GA2 TIMES GI4");
  // map.put('\u120CF',"CUNEIFORM SIGN GA2 TIMES GI4 PLUS A");
  // map.put('\u120D0',"CUNEIFORM SIGN GA2 TIMES GIR2 PLUS SU");
  // map.put('\u120D1',"CUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS ESH2");
  // map.put('\u120D2',"CUNEIFORM SIGN GA2 TIMES HAL");
  // map.put('\u120D3',"CUNEIFORM SIGN GA2 TIMES HAL PLUS LA");
  // map.put('\u120D4',"CUNEIFORM SIGN GA2 TIMES HI PLUS LI");
  // map.put('\u120D5',"CUNEIFORM SIGN GA2 TIMES HUB2");
  // map.put('\u120D6',"CUNEIFORM SIGN GA2 TIMES IGI GUNU");
  // map.put('\u120D7',"CUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASH");
  // map.put('\u120D8',"CUNEIFORM SIGN GA2 TIMES KAK");
  // map.put('\u120D9',"CUNEIFORM SIGN GA2 TIMES KASKAL");
  // map.put('\u120DA',"CUNEIFORM SIGN GA2 TIMES KID");
  // map.put('\u120DB',"CUNEIFORM SIGN GA2 TIMES KID PLUS LAL");
  // map.put('\u120DC',"CUNEIFORM SIGN GA2 TIMES KU3 PLUS AN");
  // map.put('\u120DD',"CUNEIFORM SIGN GA2 TIMES LA");
  // map.put('\u120DE',"CUNEIFORM SIGN GA2 TIMES ME PLUS EN");
  // map.put('\u120DF',"CUNEIFORM SIGN GA2 TIMES MI");
  // map.put('\u120E0',"CUNEIFORM SIGN GA2 TIMES NUN");
  // map.put('\u120E1',"CUNEIFORM SIGN GA2 TIMES NUN OVER NUN");
  // map.put('\u120E2',"CUNEIFORM SIGN GA2 TIMES PA");
  // map.put('\u120E3',"CUNEIFORM SIGN GA2 TIMES SAL");
  // map.put('\u120E4',"CUNEIFORM SIGN GA2 TIMES SAR");
  // map.put('\u120E5',"CUNEIFORM SIGN GA2 TIMES SHE");
  // map.put('\u120E6',"CUNEIFORM SIGN GA2 TIMES SHE PLUS TUR");
  // map.put('\u120E7',"CUNEIFORM SIGN GA2 TIMES SHID");
  // map.put('\u120E8',"CUNEIFORM SIGN GA2 TIMES SUM");
  // map.put('\u120E9',"CUNEIFORM SIGN GA2 TIMES TAK4");
  // map.put('\u120EA',"CUNEIFORM SIGN GA2 TIMES U");
  // map.put('\u120EB',"CUNEIFORM SIGN GA2 TIMES UD");
  // map.put('\u120EC',"CUNEIFORM SIGN GA2 TIMES UD PLUS DU");
  // map.put('\u120ED',"CUNEIFORM SIGN GA2 OVER GA2");
  // map.put('\u120EE',"CUNEIFORM SIGN GABA");
  // map.put('\u120EF',"CUNEIFORM SIGN GABA CROSSING GABA");
  // map.put('\u120F0',"CUNEIFORM SIGN GAD");
  // map.put('\u120F1',"CUNEIFORM SIGN GAD OVER GAD GAR OVER GAR");
  // map.put('\u120F2',"CUNEIFORM SIGN GAL");
  // map.put('\u120F3',"CUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GAR");
  // map.put('\u120F4',"CUNEIFORM SIGN GALAM");
  // map.put('\u120F5',"CUNEIFORM SIGN GAM");
  // map.put('\u120F6',"CUNEIFORM SIGN GAN");
  // map.put('\u120F7',"CUNEIFORM SIGN GAN2");
  // map.put('\u120F8',"CUNEIFORM SIGN GAN2 TENU");
  // map.put('\u120F9',"CUNEIFORM SIGN GAN2 OVER GAN2");
  // map.put('\u120FA',"CUNEIFORM SIGN GAN2 CROSSING GAN2");
  // map.put('\u120FB',"CUNEIFORM SIGN GAR");
  // map.put('\u120FC',"CUNEIFORM SIGN GAR3");
  // map.put('\u120FD',"CUNEIFORM SIGN GASHAN");
  // map.put('\u120FE',"CUNEIFORM SIGN GESHTIN");
  // map.put('\u120FF',"CUNEIFORM SIGN GESHTIN TIMES KUR");
  // map.put('\u12100',"CUNEIFORM SIGN GI");
  // map.put('\u12101',"CUNEIFORM SIGN GI TIMES E");
  // map.put('\u12102',"CUNEIFORM SIGN GI TIMES U");
  // map.put('\u12103',"CUNEIFORM SIGN GI CROSSING GI");
  // map.put('\u12104',"CUNEIFORM SIGN GI4");
  // map.put('\u12105',"CUNEIFORM SIGN GI4 OVER GI4");
  // map.put('\u12106',"CUNEIFORM SIGN GI4 CROSSING GI4");
  // map.put('\u12107',"CUNEIFORM SIGN GIDIM");
  // map.put('\u12108',"CUNEIFORM SIGN GIR2");
  // map.put('\u12109',"CUNEIFORM SIGN GIR2 GUNU");
  // map.put('\u1210A',"CUNEIFORM SIGN GIR3");
  // map.put('\u1210B',"CUNEIFORM SIGN GIR3 TIMES A PLUS IGI");
  // map.put('\u1210C',"CUNEIFORM SIGN GIR3 TIMES GAN2 TENU");
  // map.put('\u1210D',"CUNEIFORM SIGN GIR3 TIMES IGI");
  // map.put('\u1210E',"CUNEIFORM SIGN GIR3 TIMES LU PLUS IGI");
  // map.put('\u1210F',"CUNEIFORM SIGN GIR3 TIMES PA");
  // map.put('\u12110',"CUNEIFORM SIGN GISAL");
  // map.put('\u12111',"CUNEIFORM SIGN GISH");
  // map.put('\u12112',"CUNEIFORM SIGN GISH CROSSING GISH");
  // map.put('\u12113',"CUNEIFORM SIGN GISH TIMES BAD");
  // map.put('\u12114',"CUNEIFORM SIGN GISH TIMES TAK4");
  // map.put('\u12115',"CUNEIFORM SIGN GISH TENU");
  // map.put('\u12116',"CUNEIFORM SIGN GU");
  // map.put('\u12117',"CUNEIFORM SIGN GU CROSSING GU");
  // map.put('\u12118',"CUNEIFORM SIGN GU2");
  // map.put('\u12119',"CUNEIFORM SIGN GU2 TIMES KAK");
  // map.put('\u1211A',"CUNEIFORM SIGN GU2 TIMES KAK TIMES IGI GUNU");
  // map.put('\u1211B',"CUNEIFORM SIGN GU2 TIMES NUN");
  // map.put('\u1211C',"CUNEIFORM SIGN GU2 TIMES SAL PLUS TUG2");
  // map.put('\u1211D',"CUNEIFORM SIGN GU2 GUNU");
  // map.put('\u1211E',"CUNEIFORM SIGN GUD");
  // map.put('\u1211F',"CUNEIFORM SIGN GUD TIMES A PLUS KUR");
  // map.put('\u12120',"CUNEIFORM SIGN GUD TIMES KUR");
  // map.put('\u12121',"CUNEIFORM SIGN GUD OVER GUD LUGAL");
  // map.put('\u12122',"CUNEIFORM SIGN GUL");
  // map.put('\u12123',"CUNEIFORM SIGN GUM");
  // map.put('\u12124',"CUNEIFORM SIGN GUM TIMES SHE");
  // map.put('\u12125',"CUNEIFORM SIGN GUR");
  // map.put('\u12126',"CUNEIFORM SIGN GUR7");
  // map.put('\u12127',"CUNEIFORM SIGN GURUN");
  // map.put('\u12128',"CUNEIFORM SIGN GURUSH");
  // map.put('\u12129',"CUNEIFORM SIGN HA");
  // map.put('\u1212A',"CUNEIFORM SIGN HA TENU");
  // map.put('\u1212B',"CUNEIFORM SIGN HA GUNU");
  // map.put('\u1212C',"CUNEIFORM SIGN HAL");
  // map.put('\u1212D',"CUNEIFORM SIGN HI");
  // map.put('\u1212E',"CUNEIFORM SIGN HI TIMES ASH");
  // map.put('\u1212F',"CUNEIFORM SIGN HI TIMES ASH2");
  // map.put('\u12130',"CUNEIFORM SIGN HI TIMES BAD");
  // map.put('\u12131',"CUNEIFORM SIGN HI TIMES DISH");
  // map.put('\u12132',"CUNEIFORM SIGN HI TIMES GAD");
  // map.put('\u12133',"CUNEIFORM SIGN HI TIMES KIN");
  // map.put('\u12134',"CUNEIFORM SIGN HI TIMES NUN");
  // map.put('\u12135',"CUNEIFORM SIGN HI TIMES SHE");
  // map.put('\u12136',"CUNEIFORM SIGN HI TIMES U");
  // map.put('\u12137',"CUNEIFORM SIGN HU");
  // map.put('\u12138',"CUNEIFORM SIGN HUB2");
  // map.put('\u12139',"CUNEIFORM SIGN HUB2 TIMES AN");
  // map.put('\u1213A',"CUNEIFORM SIGN HUB2 TIMES HAL");
  // map.put('\u1213B',"CUNEIFORM SIGN HUB2 TIMES KASKAL");
  // map.put('\u1213C',"CUNEIFORM SIGN HUB2 TIMES LISH");
  // map.put('\u1213D',"CUNEIFORM SIGN HUB2 TIMES UD");
  // map.put('\u1213E',"CUNEIFORM SIGN HUL2");
  // map.put('\u1213F',"CUNEIFORM SIGN I");
  // map.put('\u12140',"CUNEIFORM SIGN I A");
  // map.put('\u12141',"CUNEIFORM SIGN IB");
  // map.put('\u12142',"CUNEIFORM SIGN IDIM");
  // map.put('\u12143',"CUNEIFORM SIGN IDIM OVER IDIM BUR");
  // map.put('\u12144',"CUNEIFORM SIGN IDIM OVER IDIM SQUARED");
  // map.put('\u12145',"CUNEIFORM SIGN IG");
  // map.put('\u12146',"CUNEIFORM SIGN IGI");
  // map.put('\u12147',"CUNEIFORM SIGN IGI DIB");
  // map.put('\u12148',"CUNEIFORM SIGN IGI RI");
  // map.put('\u12149',"CUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR UD OVER UD");
  // map.put('\u1214A',"CUNEIFORM SIGN IGI GUNU");
  // map.put('\u1214B',"CUNEIFORM SIGN IL");
  // map.put('\u1214C',"CUNEIFORM SIGN IL TIMES GAN2 TENU");
  // map.put('\u1214D',"CUNEIFORM SIGN IL2");
  // map.put('\u1214E',"CUNEIFORM SIGN IM");
  // map.put('\u1214F',"CUNEIFORM SIGN IM TIMES TAK4");
  // map.put('\u12150',"CUNEIFORM SIGN IM CROSSING IM");
  // map.put('\u12151',"CUNEIFORM SIGN IM OPPOSING IM");
  // map.put('\u12152',"CUNEIFORM SIGN IM SQUARED");
  // map.put('\u12153',"CUNEIFORM SIGN IMIN");
  // map.put('\u12154',"CUNEIFORM SIGN IN");
  // map.put('\u12155',"CUNEIFORM SIGN IR");
  // map.put('\u12156',"CUNEIFORM SIGN ISH");
  // map.put('\u12157',"CUNEIFORM SIGN KA");
  // map.put('\u12158',"CUNEIFORM SIGN KA TIMES A");
  // map.put('\u12159',"CUNEIFORM SIGN KA TIMES AD");
  // map.put('\u1215A',"CUNEIFORM SIGN KA TIMES AD PLUS KU3");
  // map.put('\u1215B',"CUNEIFORM SIGN KA TIMES ASH2");
  // map.put('\u1215C',"CUNEIFORM SIGN KA TIMES BAD");
  // map.put('\u1215D',"CUNEIFORM SIGN KA TIMES BALAG");
  // map.put('\u1215E',"CUNEIFORM SIGN KA TIMES BAR");
  // map.put('\u1215F',"CUNEIFORM SIGN KA TIMES BI");
  // map.put('\u12160',"CUNEIFORM SIGN KA TIMES ERIN2");
  // map.put('\u12161',"CUNEIFORM SIGN KA TIMES ESH2");
  // map.put('\u12162',"CUNEIFORM SIGN KA TIMES GA");
  // map.put('\u12163',"CUNEIFORM SIGN KA TIMES GAL");
  // map.put('\u12164',"CUNEIFORM SIGN KA TIMES GAN2 TENU");
  // map.put('\u12165',"CUNEIFORM SIGN KA TIMES GAR");
  // map.put('\u12166',"CUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS A");
  // map.put('\u12167',"CUNEIFORM SIGN KA TIMES GI");
  // map.put('\u12168',"CUNEIFORM SIGN KA TIMES GIR2");
  // map.put('\u12169',"CUNEIFORM SIGN KA TIMES GISH PLUS SAR");
  // map.put('\u1216A',"CUNEIFORM SIGN KA TIMES GISH CROSSING GISH");
  // map.put('\u1216B',"CUNEIFORM SIGN KA TIMES GU");
  // map.put('\u1216C',"CUNEIFORM SIGN KA TIMES GUR7");
  // map.put('\u1216D',"CUNEIFORM SIGN KA TIMES IGI");
  // map.put('\u1216E',"CUNEIFORM SIGN KA TIMES IM");
  // map.put('\u1216F',"CUNEIFORM SIGN KA TIMES KAK");
  // map.put('\u12170',"CUNEIFORM SIGN KA TIMES KI");
  // map.put('\u12171',"CUNEIFORM SIGN KA TIMES KID");
  // map.put('\u12172',"CUNEIFORM SIGN KA TIMES LI");
  // map.put('\u12173',"CUNEIFORM SIGN KA TIMES LU");
  // map.put('\u12174',"CUNEIFORM SIGN KA TIMES ME");
  // map.put('\u12175',"CUNEIFORM SIGN KA TIMES ME PLUS DU");
  // map.put('\u12176',"CUNEIFORM SIGN KA TIMES ME PLUS GI");
  // map.put('\u12177',"CUNEIFORM SIGN KA TIMES ME PLUS TE");
  // map.put('\u12178',"CUNEIFORM SIGN KA TIMES MI");
  // map.put('\u12179',"CUNEIFORM SIGN KA TIMES MI PLUS NUNUZ");
  // map.put('\u1217A',"CUNEIFORM SIGN KA TIMES NE");
  // map.put('\u1217B',"CUNEIFORM SIGN KA TIMES NUN");
  // map.put('\u1217C',"CUNEIFORM SIGN KA TIMES PI");
  // map.put('\u1217D',"CUNEIFORM SIGN KA TIMES RU");
  // map.put('\u1217E',"CUNEIFORM SIGN KA TIMES SA");
  // map.put('\u1217F',"CUNEIFORM SIGN KA TIMES SAR");
  // map.put('\u12180',"CUNEIFORM SIGN KA TIMES SHA");
  // map.put('\u12181',"CUNEIFORM SIGN KA TIMES SHE");
  // map.put('\u12182',"CUNEIFORM SIGN KA TIMES SHID");
  // map.put('\u12183',"CUNEIFORM SIGN KA TIMES SHU");
  // map.put('\u12184',"CUNEIFORM SIGN KA TIMES SIG");
  // map.put('\u12185',"CUNEIFORM SIGN KA TIMES SUHUR");
  // map.put('\u12186',"CUNEIFORM SIGN KA TIMES TAR");
  // map.put('\u12187',"CUNEIFORM SIGN KA TIMES U");
  // map.put('\u12188',"CUNEIFORM SIGN KA TIMES U2");
  // map.put('\u12189',"CUNEIFORM SIGN KA TIMES UD");
  // map.put('\u1218A',"CUNEIFORM SIGN KA TIMES UMUM TIMES PA");
  // map.put('\u1218B',"CUNEIFORM SIGN KA TIMES USH");
  // map.put('\u1218C',"CUNEIFORM SIGN KA TIMES ZI");
  // map.put('\u1218D',"CUNEIFORM SIGN KA2");
  // map.put('\u1218E',"CUNEIFORM SIGN KA2 CROSSING KA2");
  // map.put('\u1218F',"CUNEIFORM SIGN KAB");
  // map.put('\u12190',"CUNEIFORM SIGN KAD2");
  // map.put('\u12191',"CUNEIFORM SIGN KAD3");
  // map.put('\u12192',"CUNEIFORM SIGN KAD4");
  // map.put('\u12193',"CUNEIFORM SIGN KAD5");
  // map.put('\u12194',"CUNEIFORM SIGN KAD5 OVER KAD5");
  // map.put('\u12195',"CUNEIFORM SIGN KAK");
  // map.put('\u12196',"CUNEIFORM SIGN KAK TIMES IGI GUNU");
  // map.put('\u12197',"CUNEIFORM SIGN KAL");
  // map.put('\u12198',"CUNEIFORM SIGN KAL TIMES BAD");
  // map.put('\u12199',"CUNEIFORM SIGN KAL CROSSING KAL");
  // map.put('\u1219A',"CUNEIFORM SIGN KAM2");
  // map.put('\u1219B',"CUNEIFORM SIGN KAM4");
  // map.put('\u1219C',"CUNEIFORM SIGN KASKAL");
  // map.put('\u1219D',"CUNEIFORM SIGN KASKAL LAGAB TIMES U OVER LAGAB TIMES U");
  // map.put('\u1219E',"CUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U");
  // map.put('\u1219F',"CUNEIFORM SIGN KESH2");
  // map.put('\u121A0',"CUNEIFORM SIGN KI");
  // map.put('\u121A1',"CUNEIFORM SIGN KI TIMES BAD");
  // map.put('\u121A2',"CUNEIFORM SIGN KI TIMES U");
  // map.put('\u121A3',"CUNEIFORM SIGN KI TIMES UD");
  // map.put('\u121A4',"CUNEIFORM SIGN KID");
  // map.put('\u121A5',"CUNEIFORM SIGN KIN");
  // map.put('\u121A6',"CUNEIFORM SIGN KISAL");
  // map.put('\u121A7',"CUNEIFORM SIGN KISH");
  // map.put('\u121A8',"CUNEIFORM SIGN KISIM5");
  // map.put('\u121A9',"CUNEIFORM SIGN KISIM5 OVER KISIM5");
  // map.put('\u121AA',"CUNEIFORM SIGN KU");
  // map.put('\u121AB',"CUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2");
  // map.put('\u121AC',"CUNEIFORM SIGN KU3");
  // map.put('\u121AD',"CUNEIFORM SIGN KU4");
  // map.put('\u121AE',"CUNEIFORM SIGN KU4 VARIANT FORM");
  // map.put('\u121AF',"CUNEIFORM SIGN KU7");
  // map.put('\u121B0',"CUNEIFORM SIGN KUL");
  // map.put('\u121B1',"CUNEIFORM SIGN KUL GUNU");
  // map.put('\u121B2',"CUNEIFORM SIGN KUN");
  // map.put('\u121B3',"CUNEIFORM SIGN KUR");
  // map.put('\u121B4',"CUNEIFORM SIGN KUR OPPOSING KUR");
  // map.put('\u121B5',"CUNEIFORM SIGN KUSHU2");
  // map.put('\u121B6',"CUNEIFORM SIGN KWU318");
  // map.put('\u121B7',"CUNEIFORM SIGN LA");
  // map.put('\u121B8',"CUNEIFORM SIGN LAGAB");
  // map.put('\u121B9',"CUNEIFORM SIGN LAGAB TIMES A");
  // map.put('\u121BA',"CUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HA");
  // map.put('\u121BB',"CUNEIFORM SIGN LAGAB TIMES A PLUS GAR");
  // map.put('\u121BC',"CUNEIFORM SIGN LAGAB TIMES A PLUS LAL");
  // map.put('\u121BD',"CUNEIFORM SIGN LAGAB TIMES AL");
  // map.put('\u121BE',"CUNEIFORM SIGN LAGAB TIMES AN");
  // map.put('\u121BF',"CUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENU");
  // map.put('\u121C0',"CUNEIFORM SIGN LAGAB TIMES BAD");
  // map.put('\u121C1',"CUNEIFORM SIGN LAGAB TIMES BI");
  // map.put('\u121C2',"CUNEIFORM SIGN LAGAB TIMES DAR");
  // map.put('\u121C3',"CUNEIFORM SIGN LAGAB TIMES EN");
  // map.put('\u121C4',"CUNEIFORM SIGN LAGAB TIMES GA");
  // map.put('\u121C5',"CUNEIFORM SIGN LAGAB TIMES GAR");
  // map.put('\u121C6',"CUNEIFORM SIGN LAGAB TIMES GUD");
  // map.put('\u121C7',"CUNEIFORM SIGN LAGAB TIMES GUD PLUS GUD");
  // map.put('\u121C8',"CUNEIFORM SIGN LAGAB TIMES HA");
  // map.put('\u121C9',"CUNEIFORM SIGN LAGAB TIMES HAL");
  // map.put('\u121CA',"CUNEIFORM SIGN LAGAB TIMES HI TIMES NUN");
  // map.put('\u121CB',"CUNEIFORM SIGN LAGAB TIMES IGI GUNU");
  // map.put('\u121CC',"CUNEIFORM SIGN LAGAB TIMES IM");
  // map.put('\u121CD',"CUNEIFORM SIGN LAGAB TIMES IM PLUS HA");
  // map.put('\u121CE',"CUNEIFORM SIGN LAGAB TIMES IM PLUS LU");
  // map.put('\u121CF',"CUNEIFORM SIGN LAGAB TIMES KI");
  // map.put('\u121D0',"CUNEIFORM SIGN LAGAB TIMES KIN");
  // map.put('\u121D1',"CUNEIFORM SIGN LAGAB TIMES KU3");
  // map.put('\u121D2',"CUNEIFORM SIGN LAGAB TIMES KUL");
  // map.put('\u121D3',"CUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS A");
  // map.put('\u121D4',"CUNEIFORM SIGN LAGAB TIMES LAGAB");
  // map.put('\u121D5',"CUNEIFORM SIGN LAGAB TIMES LISH");
  // map.put('\u121D6',"CUNEIFORM SIGN LAGAB TIMES LU");
  // map.put('\u121D7',"CUNEIFORM SIGN LAGAB TIMES LUL");
  // map.put('\u121D8',"CUNEIFORM SIGN LAGAB TIMES ME");
  // map.put('\u121D9',"CUNEIFORM SIGN LAGAB TIMES ME PLUS EN");
  // map.put('\u121DA',"CUNEIFORM SIGN LAGAB TIMES MUSH");
  // map.put('\u121DB',"CUNEIFORM SIGN LAGAB TIMES NE");
  // map.put('\u121DC',"CUNEIFORM SIGN LAGAB TIMES SHE PLUS SUM");
  // map.put('\u121DD',"CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2");
  // map.put('\u121DE',"CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH TENU");
  // map.put('\u121DF',"CUNEIFORM SIGN LAGAB TIMES SHU2");
  // map.put('\u121E0',"CUNEIFORM SIGN LAGAB TIMES SHU2 PLUS SHU2");
  // map.put('\u121E1',"CUNEIFORM SIGN LAGAB TIMES SUM");
  // map.put('\u121E2',"CUNEIFORM SIGN LAGAB TIMES TAG");
  // map.put('\u121E3',"CUNEIFORM SIGN LAGAB TIMES TAK4");
  // map.put('\u121E4',"CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS SU PLUS NA");
  // map.put('\u121E5',"CUNEIFORM SIGN LAGAB TIMES U");
  // map.put('\u121E6',"CUNEIFORM SIGN LAGAB TIMES U PLUS A");
  // map.put('\u121E7',"CUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS U");
  // map.put('\u121E8',"CUNEIFORM SIGN LAGAB TIMES U2 PLUS ASH");
  // map.put('\u121E9',"CUNEIFORM SIGN LAGAB TIMES UD");
  // map.put('\u121EA',"CUNEIFORM SIGN LAGAB TIMES USH");
  // map.put('\u121EB',"CUNEIFORM SIGN LAGAB SQUARED");
  // map.put('\u121EC',"CUNEIFORM SIGN LAGAR");
  // map.put('\u121ED',"CUNEIFORM SIGN LAGAR TIMES SHE");
  // map.put('\u121EE',"CUNEIFORM SIGN LAGAR TIMES SHE PLUS SUM");
  // map.put('\u121EF',"CUNEIFORM SIGN LAGAR GUNU");
  // map.put('\u121F0',"CUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHE");
  // map.put('\u121F1',"CUNEIFORM SIGN LAHSHU");
  // map.put('\u121F2',"CUNEIFORM SIGN LAL");
  // map.put('\u121F3',"CUNEIFORM SIGN LAL TIMES LAL");
  // map.put('\u121F4',"CUNEIFORM SIGN LAM");
  // map.put('\u121F5',"CUNEIFORM SIGN LAM TIMES KUR");
  // map.put('\u121F6',"CUNEIFORM SIGN LAM TIMES KUR PLUS RU");
  // map.put('\u121F7',"CUNEIFORM SIGN LI");
  // map.put('\u121F8',"CUNEIFORM SIGN LIL");
  // map.put('\u121F9',"CUNEIFORM SIGN LIMMU2");
  // map.put('\u121FA',"CUNEIFORM SIGN LISH");
  // map.put('\u121FB',"CUNEIFORM SIGN LU");
  // map.put('\u121FC',"CUNEIFORM SIGN LU TIMES BAD");
  // map.put('\u121FD',"CUNEIFORM SIGN LU2");
  // map.put('\u121FE',"CUNEIFORM SIGN LU2 TIMES AL");
  // map.put('\u121FF',"CUNEIFORM SIGN LU2 TIMES BAD");
  // map.put('\u12200',"CUNEIFORM SIGN LU2 TIMES ESH2");
  // map.put('\u12201',"CUNEIFORM SIGN LU2 TIMES ESH2 TENU");
  // map.put('\u12202',"CUNEIFORM SIGN LU2 TIMES GAN2 TENU");
  // map.put('\u12203',"CUNEIFORM SIGN LU2 TIMES HI TIMES BAD");
  // map.put('\u12204',"CUNEIFORM SIGN LU2 TIMES IM");
  // map.put('\u12205',"CUNEIFORM SIGN LU2 TIMES KAD2");
  // map.put('\u12206',"CUNEIFORM SIGN LU2 TIMES KAD3");
  // map.put('\u12207',"CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASH");
  // map.put('\u12208',"CUNEIFORM SIGN LU2 TIMES KI");
  // map.put('\u12209',"CUNEIFORM SIGN LU2 TIMES LA PLUS ASH");
  // map.put('\u1220A',"CUNEIFORM SIGN LU2 TIMES LAGAB");
  // map.put('\u1220B',"CUNEIFORM SIGN LU2 TIMES ME PLUS EN");
  // map.put('\u1220C',"CUNEIFORM SIGN LU2 TIMES NE");
  // map.put('\u1220D',"CUNEIFORM SIGN LU2 TIMES NU");
  // map.put('\u1220E',"CUNEIFORM SIGN LU2 TIMES SI PLUS ASH");
  // map.put('\u1220F',"CUNEIFORM SIGN LU2 TIMES SIK2 PLUS BU");
  // map.put('\u12210',"CUNEIFORM SIGN LU2 TIMES TUG2");
  // map.put('\u12211',"CUNEIFORM SIGN LU2 TENU");
  // map.put('\u12212',"CUNEIFORM SIGN LU2 CROSSING LU2");
  // map.put('\u12213',"CUNEIFORM SIGN LU2 OPPOSING LU2");
  // map.put('\u12214',"CUNEIFORM SIGN LU2 SQUARED");
  // map.put('\u12215',"CUNEIFORM SIGN LU2 SHESHIG");
  // map.put('\u12216',"CUNEIFORM SIGN LU3");
  // map.put('\u12217',"CUNEIFORM SIGN LUGAL");
  // map.put('\u12218',"CUNEIFORM SIGN LUGAL OVER LUGAL");
  // map.put('\u12219',"CUNEIFORM SIGN LUGAL OPPOSING LUGAL");
  // map.put('\u1221A',"CUNEIFORM SIGN LUGAL SHESHIG");
  // map.put('\u1221B',"CUNEIFORM SIGN LUH");
  // map.put('\u1221C',"CUNEIFORM SIGN LUL");
  // map.put('\u1221D',"CUNEIFORM SIGN LUM");
  // map.put('\u1221E',"CUNEIFORM SIGN LUM OVER LUM");
  // map.put('\u1221F',"CUNEIFORM SIGN LUM OVER LUM GAR OVER GAR");
  // map.put('\u12220',"CUNEIFORM SIGN MA");
  // map.put('\u12221',"CUNEIFORM SIGN MA TIMES TAK4");
  // map.put('\u12222',"CUNEIFORM SIGN MA GUNU");
  // map.put('\u12223',"CUNEIFORM SIGN MA2");
  // map.put('\u12224',"CUNEIFORM SIGN MAH");
  // map.put('\u12225',"CUNEIFORM SIGN MAR");
  // map.put('\u12226',"CUNEIFORM SIGN MASH");
  // map.put('\u12227',"CUNEIFORM SIGN MASH2");
  // map.put('\u12228',"CUNEIFORM SIGN ME");
  // map.put('\u12229',"CUNEIFORM SIGN MES");
  // map.put('\u1222A',"CUNEIFORM SIGN MI");
  // map.put('\u1222B',"CUNEIFORM SIGN MIN");
  // map.put('\u1222C',"CUNEIFORM SIGN MU");
  // map.put('\u1222D',"CUNEIFORM SIGN MU OVER MU");
  // map.put('\u1222E',"CUNEIFORM SIGN MUG");
  // map.put('\u1222F',"CUNEIFORM SIGN MUG GUNU");
  // map.put('\u12230',"CUNEIFORM SIGN MUNSUB");
  // map.put('\u12231',"CUNEIFORM SIGN MURGU2");
  // map.put('\u12232',"CUNEIFORM SIGN MUSH");
  // map.put('\u12233',"CUNEIFORM SIGN MUSH TIMES A");
  // map.put('\u12234',"CUNEIFORM SIGN MUSH TIMES KUR");
  // map.put('\u12235',"CUNEIFORM SIGN MUSH TIMES ZA");
  // map.put('\u12236',"CUNEIFORM SIGN MUSH OVER MUSH");
  // map.put('\u12237',"CUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NA");
  // map.put('\u12238',"CUNEIFORM SIGN MUSH CROSSING MUSH");
  // map.put('\u12239',"CUNEIFORM SIGN MUSH3");
  // map.put('\u1223A',"CUNEIFORM SIGN MUSH3 TIMES A");
  // map.put('\u1223B',"CUNEIFORM SIGN MUSH3 TIMES A PLUS DI");
  // map.put('\u1223C',"CUNEIFORM SIGN MUSH3 TIMES DI");
  // map.put('\u1223D',"CUNEIFORM SIGN MUSH3 GUNU");
  // map.put('\u1223E',"CUNEIFORM SIGN NA");
  // map.put('\u1223F',"CUNEIFORM SIGN NA2");
  // map.put('\u12240',"CUNEIFORM SIGN NAGA");
  // map.put('\u12241',"CUNEIFORM SIGN NAGA INVERTED");
  // map.put('\u12242',"CUNEIFORM SIGN NAGA TIMES SHU TENU");
  // map.put('\u12243',"CUNEIFORM SIGN NAGA OPPOSING NAGA");
  // map.put('\u12244',"CUNEIFORM SIGN NAGAR");
  // map.put('\u12245',"CUNEIFORM SIGN NAM NUTILLU");
  // map.put('\u12246',"CUNEIFORM SIGN NAM");
  // map.put('\u12247',"CUNEIFORM SIGN NAM2");
  // map.put('\u12248',"CUNEIFORM SIGN NE");
  // map.put('\u12249',"CUNEIFORM SIGN NE TIMES A");
  // map.put('\u1224A',"CUNEIFORM SIGN NE TIMES UD");
  // map.put('\u1224B',"CUNEIFORM SIGN NE SHESHIG");
  // map.put('\u1224C',"CUNEIFORM SIGN NI");
  // map.put('\u1224D',"CUNEIFORM SIGN NI TIMES E");
  // map.put('\u1224E',"CUNEIFORM SIGN NI2");
  // map.put('\u1224F',"CUNEIFORM SIGN NIM");
  // map.put('\u12250',"CUNEIFORM SIGN NIM TIMES GAN2 TENU");
  // map.put('\u12251',"CUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENU");
  // map.put('\u12252',"CUNEIFORM SIGN NINDA2");
  // map.put('\u12253',"CUNEIFORM SIGN NINDA2 TIMES AN");
  // map.put('\u12254',"CUNEIFORM SIGN NINDA2 TIMES ASH");
  // map.put('\u12255',"CUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASH");
  // map.put('\u12256',"CUNEIFORM SIGN NINDA2 TIMES GUD");
  // map.put('\u12257',"CUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENU");
  // map.put('\u12258',"CUNEIFORM SIGN NINDA2 TIMES NE");
  // map.put('\u12259',"CUNEIFORM SIGN NINDA2 TIMES NUN");
  // map.put('\u1225A',"CUNEIFORM SIGN NINDA2 TIMES SHE");
  // map.put('\u1225B',"CUNEIFORM SIGN NINDA2 TIMES SHE PLUS A AN");
  // map.put('\u1225C',"CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH");
  // map.put('\u1225D',"CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASH");
  // map.put('\u1225E',"CUNEIFORM SIGN NINDA2 TIMES U2 PLUS ASH");
  // map.put('\u1225F',"CUNEIFORM SIGN NINDA2 TIMES USH");
  // map.put('\u12260',"CUNEIFORM SIGN NISAG");
  // map.put('\u12261',"CUNEIFORM SIGN NU");
  // map.put('\u12262',"CUNEIFORM SIGN NU11");
  // map.put('\u12263',"CUNEIFORM SIGN NUN");
  // map.put('\u12264',"CUNEIFORM SIGN NUN LAGAR TIMES GAR");
  // map.put('\u12265',"CUNEIFORM SIGN NUN LAGAR TIMES MASH");
  // map.put('\u12266',"CUNEIFORM SIGN NUN LAGAR TIMES SAL");
  // map.put('\u12267',"CUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SAL");
  // map.put('\u12268',"CUNEIFORM SIGN NUN LAGAR TIMES USH");
  // map.put('\u12269',"CUNEIFORM SIGN NUN TENU");
  // map.put('\u1226A',"CUNEIFORM SIGN NUN OVER NUN");
  // map.put('\u1226B',"CUNEIFORM SIGN NUN CROSSING NUN");
  // map.put('\u1226C',"CUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGAR");
  // map.put('\u1226D',"CUNEIFORM SIGN NUNUZ");
  // map.put('\u1226E',"CUNEIFORM SIGN NUNUZ AB2 TIMES ASHGAB");
  // map.put('\u1226F',"CUNEIFORM SIGN NUNUZ AB2 TIMES BI");
  // map.put('\u12270',"CUNEIFORM SIGN NUNUZ AB2 TIMES DUG");
  // map.put('\u12271',"CUNEIFORM SIGN NUNUZ AB2 TIMES GUD");
  // map.put('\u12272',"CUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNU");
  // map.put('\u12273',"CUNEIFORM SIGN NUNUZ AB2 TIMES KAD3");
  // map.put('\u12274',"CUNEIFORM SIGN NUNUZ AB2 TIMES LA");
  // map.put('\u12275',"CUNEIFORM SIGN NUNUZ AB2 TIMES NE");
  // map.put('\u12276',"CUNEIFORM SIGN NUNUZ AB2 TIMES SILA3");
  // map.put('\u12277',"CUNEIFORM SIGN NUNUZ AB2 TIMES U2");
  // map.put('\u12278',"CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI");
  // map.put('\u12279',"CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI U");
  // map.put('\u1227A',"CUNEIFORM SIGN PA");
  // map.put('\u1227B',"CUNEIFORM SIGN PAD");
  // map.put('\u1227C',"CUNEIFORM SIGN PAN");
  // map.put('\u1227D',"CUNEIFORM SIGN PAP");
  // map.put('\u1227E',"CUNEIFORM SIGN PESH2");
  // map.put('\u1227F',"CUNEIFORM SIGN PI");
  // map.put('\u12280',"CUNEIFORM SIGN PI TIMES A");
  // map.put('\u12281',"CUNEIFORM SIGN PI TIMES AB");
  // map.put('\u12282',"CUNEIFORM SIGN PI TIMES BI");
  // map.put('\u12283',"CUNEIFORM SIGN PI TIMES BU");
  // map.put('\u12284',"CUNEIFORM SIGN PI TIMES E");
  // map.put('\u12285',"CUNEIFORM SIGN PI TIMES I");
  // map.put('\u12286',"CUNEIFORM SIGN PI TIMES IB");
  // map.put('\u12287',"CUNEIFORM SIGN PI TIMES U");
  // map.put('\u12288',"CUNEIFORM SIGN PI TIMES U2");
  // map.put('\u12289',"CUNEIFORM SIGN PI CROSSING PI");
  // map.put('\u1228A',"CUNEIFORM SIGN PIRIG");
  // map.put('\u1228B',"CUNEIFORM SIGN PIRIG TIMES KAL");
  // map.put('\u1228C',"CUNEIFORM SIGN PIRIG TIMES UD");
  // map.put('\u1228D',"CUNEIFORM SIGN PIRIG TIMES ZA");
  // map.put('\u1228E',"CUNEIFORM SIGN PIRIG OPPOSING PIRIG");
  // map.put('\u1228F',"CUNEIFORM SIGN RA");
  // map.put('\u12290',"CUNEIFORM SIGN RAB");
  // map.put('\u12291',"CUNEIFORM SIGN RI");
  // map.put('\u12292',"CUNEIFORM SIGN RU");
  // map.put('\u12293',"CUNEIFORM SIGN SA");
  // map.put('\u12294',"CUNEIFORM SIGN SAG NUTILLU");
  // map.put('\u12295',"CUNEIFORM SIGN SAG");
  // map.put('\u12296',"CUNEIFORM SIGN SAG TIMES A");
  // map.put('\u12297',"CUNEIFORM SIGN SAG TIMES DU");
  // map.put('\u12298',"CUNEIFORM SIGN SAG TIMES DUB");
  // map.put('\u12299',"CUNEIFORM SIGN SAG TIMES HA");
  // map.put('\u1229A',"CUNEIFORM SIGN SAG TIMES KAK");
  // map.put('\u1229B',"CUNEIFORM SIGN SAG TIMES KUR");
  // map.put('\u1229C',"CUNEIFORM SIGN SAG TIMES LUM");
  // map.put('\u1229D',"CUNEIFORM SIGN SAG TIMES MI");
  // map.put('\u1229E',"CUNEIFORM SIGN SAG TIMES NUN");
  // map.put('\u1229F',"CUNEIFORM SIGN SAG TIMES SAL");
  // map.put('\u122A0',"CUNEIFORM SIGN SAG TIMES SHID");
  // map.put('\u122A1',"CUNEIFORM SIGN SAG TIMES TAB");
  // map.put('\u122A2',"CUNEIFORM SIGN SAG TIMES U2");
  // map.put('\u122A3',"CUNEIFORM SIGN SAG TIMES UB");
  // map.put('\u122A4',"CUNEIFORM SIGN SAG TIMES UM");
  // map.put('\u122A5',"CUNEIFORM SIGN SAG TIMES UR");
  // map.put('\u122A6',"CUNEIFORM SIGN SAG TIMES USH");
  // map.put('\u122A7',"CUNEIFORM SIGN SAG OVER SAG");
  // map.put('\u122A8',"CUNEIFORM SIGN SAG GUNU");
  // map.put('\u122A9',"CUNEIFORM SIGN SAL");
  // map.put('\u122AA',"CUNEIFORM SIGN SAL LAGAB TIMES ASH2");
  // map.put('\u122AB',"CUNEIFORM SIGN SANGA2");
  // map.put('\u122AC',"CUNEIFORM SIGN SAR");
  // map.put('\u122AD',"CUNEIFORM SIGN SHA");
  // map.put('\u122AE',"CUNEIFORM SIGN SHA3");
  // map.put('\u122AF',"CUNEIFORM SIGN SHA3 TIMES A");
  // map.put('\u122B0',"CUNEIFORM SIGN SHA3 TIMES BAD");
  // map.put('\u122B1',"CUNEIFORM SIGN SHA3 TIMES GISH");
  // map.put('\u122B2',"CUNEIFORM SIGN SHA3 TIMES NE");
  // map.put('\u122B3',"CUNEIFORM SIGN SHA3 TIMES SHU2");
  // map.put('\u122B4',"CUNEIFORM SIGN SHA3 TIMES TUR");
  // map.put('\u122B5',"CUNEIFORM SIGN SHA3 TIMES U");
  // map.put('\u122B6',"CUNEIFORM SIGN SHA3 TIMES U PLUS A");
  // map.put('\u122B7',"CUNEIFORM SIGN SHA6");
  // map.put('\u122B8',"CUNEIFORM SIGN SHAB6");
  // map.put('\u122B9',"CUNEIFORM SIGN SHAR2");
  // map.put('\u122BA',"CUNEIFORM SIGN SHE");
  // map.put('\u122BB',"CUNEIFORM SIGN SHE HU");
  // map.put('\u122BC',"CUNEIFORM SIGN SHE OVER SHE GAD OVER GAD GAR OVER GAR");
  // map.put('\u122BD',"CUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVER GAR");
  // map.put('\u122BE',"CUNEIFORM SIGN SHEG9");
  // map.put('\u122BF',"CUNEIFORM SIGN SHEN");
  // map.put('\u122C0',"CUNEIFORM SIGN SHESH");
  // map.put('\u122C1',"CUNEIFORM SIGN SHESH2");
  // map.put('\u122C2',"CUNEIFORM SIGN SHESHLAM");
  // map.put('\u122C3',"CUNEIFORM SIGN SHID");
  // map.put('\u122C4',"CUNEIFORM SIGN SHID TIMES A");
  // map.put('\u122C5',"CUNEIFORM SIGN SHID TIMES IM");
  // map.put('\u122C6',"CUNEIFORM SIGN SHIM");
  // map.put('\u122C7',"CUNEIFORM SIGN SHIM TIMES A");
  // map.put('\u122C8',"CUNEIFORM SIGN SHIM TIMES BAL");
  // map.put('\u122C9',"CUNEIFORM SIGN SHIM TIMES BULUG");
  // map.put('\u122CA',"CUNEIFORM SIGN SHIM TIMES DIN");
  // map.put('\u122CB',"CUNEIFORM SIGN SHIM TIMES GAR");
  // map.put('\u122CC',"CUNEIFORM SIGN SHIM TIMES IGI");
  // map.put('\u122CD',"CUNEIFORM SIGN SHIM TIMES IGI GUNU");
  // map.put('\u122CE',"CUNEIFORM SIGN SHIM TIMES KUSHU2");
  // map.put('\u122CF',"CUNEIFORM SIGN SHIM TIMES LUL");
  // map.put('\u122D0',"CUNEIFORM SIGN SHIM TIMES MUG");
  // map.put('\u122D1',"CUNEIFORM SIGN SHIM TIMES SAL");
  // map.put('\u122D2',"CUNEIFORM SIGN SHINIG");
  // map.put('\u122D3',"CUNEIFORM SIGN SHIR");
  // map.put('\u122D4',"CUNEIFORM SIGN SHIR TENU");
  // map.put('\u122D5',"CUNEIFORM SIGN SHIR OVER SHIR BUR OVER BUR");
  // map.put('\u122D6',"CUNEIFORM SIGN SHITA");
  // map.put('\u122D7',"CUNEIFORM SIGN SHU");
  // map.put('\u122D8',"CUNEIFORM SIGN SHU OVER INVERTED SHU");
  // map.put('\u122D9',"CUNEIFORM SIGN SHU2");
  // map.put('\u122DA',"CUNEIFORM SIGN SHUBUR");
  // map.put('\u122DB',"CUNEIFORM SIGN SI");
  // map.put('\u122DC',"CUNEIFORM SIGN SI GUNU");
  // map.put('\u122DD',"CUNEIFORM SIGN SIG");
  // map.put('\u122DE',"CUNEIFORM SIGN SIG4");
  // map.put('\u122DF',"CUNEIFORM SIGN SIG4 OVER SIG4 SHU2");
  // map.put('\u122E0',"CUNEIFORM SIGN SIK2");
  // map.put('\u122E1',"CUNEIFORM SIGN SILA3");
  // map.put('\u122E2',"CUNEIFORM SIGN SU");
  // map.put('\u122E3',"CUNEIFORM SIGN SU OVER SU");
  // map.put('\u122E4',"CUNEIFORM SIGN SUD");
  // map.put('\u122E5',"CUNEIFORM SIGN SUD2");
  // map.put('\u122E6',"CUNEIFORM SIGN SUHUR");
  // map.put('\u122E7',"CUNEIFORM SIGN SUM");
  // map.put('\u122E8',"CUNEIFORM SIGN SUMASH");
  // map.put('\u122E9',"CUNEIFORM SIGN SUR");
  // map.put('\u122EA',"CUNEIFORM SIGN SUR9");
  // map.put('\u122EB',"CUNEIFORM SIGN TA");
  // map.put('\u122EC',"CUNEIFORM SIGN TA ASTERISK");
  // map.put('\u122ED',"CUNEIFORM SIGN TA TIMES HI");
  // map.put('\u122EE',"CUNEIFORM SIGN TA TIMES MI");
  // map.put('\u122EF',"CUNEIFORM SIGN TA GUNU");
  // map.put('\u122F0',"CUNEIFORM SIGN TAB");
  // map.put('\u122F1',"CUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISH");
  // map.put('\u122F2',"CUNEIFORM SIGN TAB SQUARED");
  // map.put('\u122F3',"CUNEIFORM SIGN TAG");
  // map.put('\u122F4',"CUNEIFORM SIGN TAG TIMES BI");
  // map.put('\u122F5',"CUNEIFORM SIGN TAG TIMES GUD");
  // map.put('\u122F6',"CUNEIFORM SIGN TAG TIMES SHE");
  // map.put('\u122F7',"CUNEIFORM SIGN TAG TIMES SHU");
  // map.put('\u122F8',"CUNEIFORM SIGN TAG TIMES TUG2");
  // map.put('\u122F9',"CUNEIFORM SIGN TAG TIMES UD");
  // map.put('\u122FA',"CUNEIFORM SIGN TAK4");
  // map.put('\u122FB',"CUNEIFORM SIGN TAR");
  // map.put('\u122FC',"CUNEIFORM SIGN TE");
  // map.put('\u122FD',"CUNEIFORM SIGN TE GUNU");
  // map.put('\u122FE',"CUNEIFORM SIGN TI");
  // map.put('\u122FF',"CUNEIFORM SIGN TI TENU");
  // map.put('\u12300',"CUNEIFORM SIGN TIL");
  // map.put('\u12301',"CUNEIFORM SIGN TIR");
  // map.put('\u12302',"CUNEIFORM SIGN TIR TIMES TAK4");
  // map.put('\u12303',"CUNEIFORM SIGN TIR OVER TIR");
  // map.put('\u12304',"CUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GAR");
  // map.put('\u12305',"CUNEIFORM SIGN TU");
  // map.put('\u12306',"CUNEIFORM SIGN TUG2");
  // map.put('\u12307',"CUNEIFORM SIGN TUK");
  // map.put('\u12308',"CUNEIFORM SIGN TUM");
  // map.put('\u12309',"CUNEIFORM SIGN TUR");
  // map.put('\u1230A',"CUNEIFORM SIGN TUR OVER TUR ZA OVER ZA");
  // map.put('\u1230B',"CUNEIFORM SIGN U");
  // map.put('\u1230C',"CUNEIFORM SIGN U GUD");
  // map.put('\u1230D',"CUNEIFORM SIGN U U U");
  // map.put('\u1230E',"CUNEIFORM SIGN U OVER U PA OVER PA GAR OVER GAR");
  // map.put('\u1230F',"CUNEIFORM SIGN U OVER U SUR OVER SUR");
  // map.put('\u12310',"CUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSED");
  // map.put('\u12311',"CUNEIFORM SIGN U2");
  // map.put('\u12312',"CUNEIFORM SIGN UB");
  // map.put('\u12313',"CUNEIFORM SIGN UD");
  // map.put('\u12314',"CUNEIFORM SIGN UD KUSHU2");
  // map.put('\u12315',"CUNEIFORM SIGN UD TIMES BAD");
  // map.put('\u12316',"CUNEIFORM SIGN UD TIMES MI");
  // map.put('\u12317',"CUNEIFORM SIGN UD TIMES U PLUS U PLUS U");
  // map.put('\u12318',"CUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNU");
  // map.put('\u12319',"CUNEIFORM SIGN UD GUNU");
  // map.put('\u1231A',"CUNEIFORM SIGN UD SHESHIG");
  // map.put('\u1231B',"CUNEIFORM SIGN UD SHESHIG TIMES BAD");
  // map.put('\u1231C',"CUNEIFORM SIGN UDUG");
  // map.put('\u1231D',"CUNEIFORM SIGN UM");
  // map.put('\u1231E',"CUNEIFORM SIGN UM TIMES LAGAB");
  // map.put('\u1231F',"CUNEIFORM SIGN UM TIMES ME PLUS DA");
  // map.put('\u12320',"CUNEIFORM SIGN UM TIMES SHA3");
  // map.put('\u12321',"CUNEIFORM SIGN UM TIMES U");
  // map.put('\u12322',"CUNEIFORM SIGN UMBIN");
  // map.put('\u12323',"CUNEIFORM SIGN UMUM");
  // map.put('\u12324',"CUNEIFORM SIGN UMUM TIMES KASKAL");
  // map.put('\u12325',"CUNEIFORM SIGN UMUM TIMES PA");
  // map.put('\u12326',"CUNEIFORM SIGN UN");
  // map.put('\u12327',"CUNEIFORM SIGN UN GUNU");
  // map.put('\u12328',"CUNEIFORM SIGN UR");
  // map.put('\u12329',"CUNEIFORM SIGN UR CROSSING UR");
  // map.put('\u1232A',"CUNEIFORM SIGN UR SHESHIG");
  // map.put('\u1232B',"CUNEIFORM SIGN UR2");
  // map.put('\u1232C',"CUNEIFORM SIGN UR2 TIMES A PLUS HA");
  // map.put('\u1232D',"CUNEIFORM SIGN UR2 TIMES A PLUS NA");
  // map.put('\u1232E',"CUNEIFORM SIGN UR2 TIMES AL");
  // map.put('\u1232F',"CUNEIFORM SIGN UR2 TIMES HA");
  // map.put('\u12330',"CUNEIFORM SIGN UR2 TIMES NUN");
  // map.put('\u12331',"CUNEIFORM SIGN UR2 TIMES U2");
  // map.put('\u12332',"CUNEIFORM SIGN UR2 TIMES U2 PLUS ASH");
  // map.put('\u12333',"CUNEIFORM SIGN UR2 TIMES U2 PLUS BI");
  // map.put('\u12334',"CUNEIFORM SIGN UR4");
  // map.put('\u12335',"CUNEIFORM SIGN URI");
  // map.put('\u12336',"CUNEIFORM SIGN URI3");
  // map.put('\u12337',"CUNEIFORM SIGN URU");
  // map.put('\u12338',"CUNEIFORM SIGN URU TIMES A");
  // map.put('\u12339',"CUNEIFORM SIGN URU TIMES ASHGAB");
  // map.put('\u1233A',"CUNEIFORM SIGN URU TIMES BAR");
  // map.put('\u1233B',"CUNEIFORM SIGN URU TIMES DUN");
  // map.put('\u1233C',"CUNEIFORM SIGN URU TIMES GA");
  // map.put('\u1233D',"CUNEIFORM SIGN URU TIMES GAL");
  // map.put('\u1233E',"CUNEIFORM SIGN URU TIMES GAN2 TENU");
  // map.put('\u1233F',"CUNEIFORM SIGN URU TIMES GAR");
  // map.put('\u12340',"CUNEIFORM SIGN URU TIMES GU");
  // map.put('\u12341',"CUNEIFORM SIGN URU TIMES HA");
  // map.put('\u12342',"CUNEIFORM SIGN URU TIMES IGI");
  // map.put('\u12343',"CUNEIFORM SIGN URU TIMES IM");
  // map.put('\u12344',"CUNEIFORM SIGN URU TIMES ISH");
  // map.put('\u12345',"CUNEIFORM SIGN URU TIMES KI");
  // map.put('\u12346',"CUNEIFORM SIGN URU TIMES LUM");
  // map.put('\u12347',"CUNEIFORM SIGN URU TIMES MIN");
  // map.put('\u12348',"CUNEIFORM SIGN URU TIMES PA");
  // map.put('\u12349',"CUNEIFORM SIGN URU TIMES SHE");
  // map.put('\u1234A',"CUNEIFORM SIGN URU TIMES SIG4");
  // map.put('\u1234B',"CUNEIFORM SIGN URU TIMES TU");
  // map.put('\u1234C',"CUNEIFORM SIGN URU TIMES U PLUS GUD");
  // map.put('\u1234D',"CUNEIFORM SIGN URU TIMES UD");
  // map.put('\u1234E',"CUNEIFORM SIGN URU TIMES URUDA");
  // map.put('\u1234F',"CUNEIFORM SIGN URUDA");
  // map.put('\u12350',"CUNEIFORM SIGN URUDA TIMES U");
  // map.put('\u12351',"CUNEIFORM SIGN USH");
  // map.put('\u12352',"CUNEIFORM SIGN USH TIMES A");
  // map.put('\u12353',"CUNEIFORM SIGN USH TIMES KU");
  // map.put('\u12354',"CUNEIFORM SIGN USH TIMES KUR");
  // map.put('\u12355',"CUNEIFORM SIGN USH TIMES TAK4");
  // map.put('\u12356',"CUNEIFORM SIGN USHX");
  // map.put('\u12357',"CUNEIFORM SIGN USH2");
  // map.put('\u12358',"CUNEIFORM SIGN USHUMX");
  // map.put('\u12359',"CUNEIFORM SIGN UTUKI");
  // map.put('\u1235A',"CUNEIFORM SIGN UZ3");
  // map.put('\u1235B',"CUNEIFORM SIGN UZ3 TIMES KASKAL");
  // map.put('\u1235C',"CUNEIFORM SIGN UZU");
  // map.put('\u1235D',"CUNEIFORM SIGN ZA");
  // map.put('\u1235E',"CUNEIFORM SIGN ZA TENU");
  // map.put('\u1235F',"CUNEIFORM SIGN ZA SQUARED TIMES KUR");
  // map.put('\u12360',"CUNEIFORM SIGN ZAG");
  // map.put('\u12361',"CUNEIFORM SIGN ZAMX");
  // map.put('\u12362',"CUNEIFORM SIGN ZE2");
  // map.put('\u12363',"CUNEIFORM SIGN ZI");
  // map.put('\u12364',"CUNEIFORM SIGN ZI OVER ZI");
  // map.put('\u12365',"CUNEIFORM SIGN ZI3");
  // map.put('\u12366',"CUNEIFORM SIGN ZIB");
  // map.put('\u12367',"CUNEIFORM SIGN ZIB KABA TENU");
  // map.put('\u12368',"CUNEIFORM SIGN ZIG");
  // map.put('\u12369',"CUNEIFORM SIGN ZIZ2");
  // map.put('\u1236A',"CUNEIFORM SIGN ZU");
  // map.put('\u1236B',"CUNEIFORM SIGN ZU5");
  // map.put('\u1236C',"CUNEIFORM SIGN ZU5 TIMES A");
  // map.put('\u1236D',"CUNEIFORM SIGN ZUBUR");
  // map.put('\u1236E',"CUNEIFORM SIGN ZUM");
  // map.put('\u12400',"CUNEIFORM NUMERIC SIGN TWO ASH");
  // map.put('\u12401',"CUNEIFORM NUMERIC SIGN THREE ASH");
  // map.put('\u12402',"CUNEIFORM NUMERIC SIGN FOUR ASH");
  // map.put('\u12403',"CUNEIFORM NUMERIC SIGN FIVE ASH");
  // map.put('\u12404',"CUNEIFORM NUMERIC SIGN SIX ASH");
  // map.put('\u12405',"CUNEIFORM NUMERIC SIGN SEVEN ASH");
  // map.put('\u12406',"CUNEIFORM NUMERIC SIGN EIGHT ASH");
  // map.put('\u12407',"CUNEIFORM NUMERIC SIGN NINE ASH");
  // map.put('\u12408',"CUNEIFORM NUMERIC SIGN THREE DISH");
  // map.put('\u12409',"CUNEIFORM NUMERIC SIGN FOUR DISH");
  // map.put('\u1240A',"CUNEIFORM NUMERIC SIGN FIVE DISH");
  // map.put('\u1240B',"CUNEIFORM NUMERIC SIGN SIX DISH");
  // map.put('\u1240C',"CUNEIFORM NUMERIC SIGN SEVEN DISH");
  // map.put('\u1240D',"CUNEIFORM NUMERIC SIGN EIGHT DISH");
  // map.put('\u1240E',"CUNEIFORM NUMERIC SIGN NINE DISH");
  // map.put('\u1240F',"CUNEIFORM NUMERIC SIGN FOUR U");
  // map.put('\u12410',"CUNEIFORM NUMERIC SIGN FIVE U");
  // map.put('\u12411',"CUNEIFORM NUMERIC SIGN SIX U");
  // map.put('\u12412',"CUNEIFORM NUMERIC SIGN SEVEN U");
  // map.put('\u12413',"CUNEIFORM NUMERIC SIGN EIGHT U");
  // map.put('\u12414',"CUNEIFORM NUMERIC SIGN NINE U");
  // map.put('\u12415',"CUNEIFORM NUMERIC SIGN ONE GESH2");
  // map.put('\u12416',"CUNEIFORM NUMERIC SIGN TWO GESH2");
  // map.put('\u12417',"CUNEIFORM NUMERIC SIGN THREE GESH2");
  // map.put('\u12418',"CUNEIFORM NUMERIC SIGN FOUR GESH2");
  // map.put('\u12419',"CUNEIFORM NUMERIC SIGN FIVE GESH2");
  // map.put('\u1241A',"CUNEIFORM NUMERIC SIGN SIX GESH2");
  // map.put('\u1241B',"CUNEIFORM NUMERIC SIGN SEVEN GESH2");
  // map.put('\u1241C',"CUNEIFORM NUMERIC SIGN EIGHT GESH2");
  // map.put('\u1241D',"CUNEIFORM NUMERIC SIGN NINE GESH2");
  // map.put('\u1241E',"CUNEIFORM NUMERIC SIGN ONE GESHU");
  // map.put('\u1241F',"CUNEIFORM NUMERIC SIGN TWO GESHU");
  // map.put('\u12420',"CUNEIFORM NUMERIC SIGN THREE GESHU");
  // map.put('\u12421',"CUNEIFORM NUMERIC SIGN FOUR GESHU");
  // map.put('\u12422',"CUNEIFORM NUMERIC SIGN FIVE GESHU");
  // map.put('\u12423',"CUNEIFORM NUMERIC SIGN TWO SHAR2");
  // map.put('\u12424',"CUNEIFORM NUMERIC SIGN THREE SHAR2");
  // map.put('\u12425',"CUNEIFORM NUMERIC SIGN THREE SHAR2 VARIANT FORM");
  // map.put('\u12426',"CUNEIFORM NUMERIC SIGN FOUR SHAR2");
  // map.put('\u12427',"CUNEIFORM NUMERIC SIGN FIVE SHAR2");
  // map.put('\u12428',"CUNEIFORM NUMERIC SIGN SIX SHAR2");
  // map.put('\u12429',"CUNEIFORM NUMERIC SIGN SEVEN SHAR2");
  // map.put('\u1242A',"CUNEIFORM NUMERIC SIGN EIGHT SHAR2");
  // map.put('\u1242B',"CUNEIFORM NUMERIC SIGN NINE SHAR2");
  // map.put('\u1242C',"CUNEIFORM NUMERIC SIGN ONE SHARU");
  // map.put('\u1242D',"CUNEIFORM NUMERIC SIGN TWO SHARU");
  // map.put('\u1242E',"CUNEIFORM NUMERIC SIGN THREE SHARU");
  // map.put('\u1242F',"CUNEIFORM NUMERIC SIGN THREE SHARU VARIANT FORM");
  // map.put('\u12430',"CUNEIFORM NUMERIC SIGN FOUR SHARU");
  // map.put('\u12431',"CUNEIFORM NUMERIC SIGN FIVE SHARU");
  // map.put('\u12432',"CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISH");
  // map.put('\u12433',"CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MIN");
  // map.put('\u12434',"CUNEIFORM NUMERIC SIGN ONE BURU");
  // map.put('\u12435',"CUNEIFORM NUMERIC SIGN TWO BURU");
  // map.put('\u12436',"CUNEIFORM NUMERIC SIGN THREE BURU");
  // map.put('\u12437',"CUNEIFORM NUMERIC SIGN THREE BURU VARIANT FORM");
  // map.put('\u12438',"CUNEIFORM NUMERIC SIGN FOUR BURU");
  // map.put('\u12439',"CUNEIFORM NUMERIC SIGN FIVE BURU");
  // map.put('\u1243A',"CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16");
  // map.put('\u1243B',"CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21");
  // map.put('\u1243C',"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU");
  // map.put('\u1243D',"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4");
  // map.put('\u1243E',"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU A");
  // map.put('\u1243F',"CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU B");
  // map.put('\u12440',"CUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9");
  // map.put('\u12441',"CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3");
  // map.put('\u12442',"CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN A");
  // map.put('\u12443',"CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN B");
  // map.put('\u12444',"CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU");
  // map.put('\u12445',"CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3");
  // map.put('\u12446',"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU");
  // map.put('\u12447',"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3");
  // map.put('\u12448',"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4");
  // map.put('\u12449',"CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU A");
  // map.put('\u1244A',"CUNEIFORM NUMERIC SIGN TWO ASH TENU");
  // map.put('\u1244B',"CUNEIFORM NUMERIC SIGN THREE ASH TENU");
  // map.put('\u1244C',"CUNEIFORM NUMERIC SIGN FOUR ASH TENU");
  // map.put('\u1244D',"CUNEIFORM NUMERIC SIGN FIVE ASH TENU");
  // map.put('\u1244E',"CUNEIFORM NUMERIC SIGN SIX ASH TENU");
  // map.put('\u1244F',"CUNEIFORM NUMERIC SIGN ONE BAN2");
  // map.put('\u12450',"CUNEIFORM NUMERIC SIGN TWO BAN2");
  // map.put('\u12451',"CUNEIFORM NUMERIC SIGN THREE BAN2");
  // map.put('\u12452',"CUNEIFORM NUMERIC SIGN FOUR BAN2");
  // map.put('\u12453',"CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORM");
  // map.put('\u12454',"CUNEIFORM NUMERIC SIGN FIVE BAN2");
  // map.put('\u12455',"CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORM");
  // map.put('\u12456',"CUNEIFORM NUMERIC SIGN NIGIDAMIN");
  // map.put('\u12457',"CUNEIFORM NUMERIC SIGN NIGIDAESH");
  // map.put('\u12458',"CUNEIFORM NUMERIC SIGN ONE ESHE3");
  // map.put('\u12459',"CUNEIFORM NUMERIC SIGN TWO ESHE3");
  // map.put('\u1245A',"CUNEIFORM NUMERIC SIGN ONE THIRD DISH");
  // map.put('\u1245B',"CUNEIFORM NUMERIC SIGN TWO THIRDS DISH");
  // map.put('\u1245C',"CUNEIFORM NUMERIC SIGN FIVE SIXTHS DISH");
  // map.put('\u1245D',"CUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM A");
  // map.put('\u1245E',"CUNEIFORM NUMERIC SIGN TWO THIRDS VARIANT FORM A");
  // map.put('\u1245F',"CUNEIFORM NUMERIC SIGN ONE EIGHTH ASH");
  // map.put('\u12460',"CUNEIFORM NUMERIC SIGN ONE QUARTER ASH");
  // map.put('\u12461',"CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTH");
  // map.put('\u12462',"CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER");
  // map.put('\u12470',"CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER");
  // map.put('\u12471',"CUNEIFORM PUNCTUATION SIGN VERTICAL COLON");
  // map.put('\u12472',"CUNEIFORM PUNCTUATION SIGN DIAGONAL COLON");
  // map.put('\u12473',"CUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLON");
  // map.put('\u13000',"EGYPTIAN HIEROGLYPH A001");
  // map.put('\u13001',"EGYPTIAN HIEROGLYPH A002");
  // map.put('\u13002',"EGYPTIAN HIEROGLYPH A003");
  // map.put('\u13003',"EGYPTIAN HIEROGLYPH A004");
  // map.put('\u13004',"EGYPTIAN HIEROGLYPH A005");
  // map.put('\u13005',"EGYPTIAN HIEROGLYPH A005A");
  // map.put('\u13006',"EGYPTIAN HIEROGLYPH A006");
  // map.put('\u13007',"EGYPTIAN HIEROGLYPH A006A");
  // map.put('\u13008',"EGYPTIAN HIEROGLYPH A006B");
  // map.put('\u13009',"EGYPTIAN HIEROGLYPH A007");
  // map.put('\u1300A',"EGYPTIAN HIEROGLYPH A008");
  // map.put('\u1300B',"EGYPTIAN HIEROGLYPH A009");
  // map.put('\u1300C',"EGYPTIAN HIEROGLYPH A010");
  // map.put('\u1300D',"EGYPTIAN HIEROGLYPH A011");
  // map.put('\u1300E',"EGYPTIAN HIEROGLYPH A012");
  // map.put('\u1300F',"EGYPTIAN HIEROGLYPH A013");
  // map.put('\u13010',"EGYPTIAN HIEROGLYPH A014");
  // map.put('\u13011',"EGYPTIAN HIEROGLYPH A014A");
  // map.put('\u13012',"EGYPTIAN HIEROGLYPH A015");
  // map.put('\u13013',"EGYPTIAN HIEROGLYPH A016");
  // map.put('\u13014',"EGYPTIAN HIEROGLYPH A017");
  // map.put('\u13015',"EGYPTIAN HIEROGLYPH A017A");
  // map.put('\u13016',"EGYPTIAN HIEROGLYPH A018");
  // map.put('\u13017',"EGYPTIAN HIEROGLYPH A019");
  // map.put('\u13018',"EGYPTIAN HIEROGLYPH A020");
  // map.put('\u13019',"EGYPTIAN HIEROGLYPH A021");
  // map.put('\u1301A',"EGYPTIAN HIEROGLYPH A022");
  // map.put('\u1301B',"EGYPTIAN HIEROGLYPH A023");
  // map.put('\u1301C',"EGYPTIAN HIEROGLYPH A024");
  // map.put('\u1301D',"EGYPTIAN HIEROGLYPH A025");
  // map.put('\u1301E',"EGYPTIAN HIEROGLYPH A026");
  // map.put('\u1301F',"EGYPTIAN HIEROGLYPH A027");
  // map.put('\u13020',"EGYPTIAN HIEROGLYPH A028");
  // map.put('\u13021',"EGYPTIAN HIEROGLYPH A029");
  // map.put('\u13022',"EGYPTIAN HIEROGLYPH A030");
  // map.put('\u13023',"EGYPTIAN HIEROGLYPH A031");
  // map.put('\u13024',"EGYPTIAN HIEROGLYPH A032");
  // map.put('\u13025',"EGYPTIAN HIEROGLYPH A032A");
  // map.put('\u13026',"EGYPTIAN HIEROGLYPH A033");
  // map.put('\u13027',"EGYPTIAN HIEROGLYPH A034");
  // map.put('\u13028',"EGYPTIAN HIEROGLYPH A035");
  // map.put('\u13029',"EGYPTIAN HIEROGLYPH A036");
  // map.put('\u1302A',"EGYPTIAN HIEROGLYPH A037");
  // map.put('\u1302B',"EGYPTIAN HIEROGLYPH A038");
  // map.put('\u1302C',"EGYPTIAN HIEROGLYPH A039");
  // map.put('\u1302D',"EGYPTIAN HIEROGLYPH A040");
  // map.put('\u1302E',"EGYPTIAN HIEROGLYPH A040A");
  // map.put('\u1302F',"EGYPTIAN HIEROGLYPH A041");
  // map.put('\u13030',"EGYPTIAN HIEROGLYPH A042");
  // map.put('\u13031',"EGYPTIAN HIEROGLYPH A042A");
  // map.put('\u13032',"EGYPTIAN HIEROGLYPH A043");
  // map.put('\u13033',"EGYPTIAN HIEROGLYPH A043A");
  // map.put('\u13034',"EGYPTIAN HIEROGLYPH A044");
  // map.put('\u13035',"EGYPTIAN HIEROGLYPH A045");
  // map.put('\u13036',"EGYPTIAN HIEROGLYPH A045A");
  // map.put('\u13037',"EGYPTIAN HIEROGLYPH A046");
  // map.put('\u13038',"EGYPTIAN HIEROGLYPH A047");
  // map.put('\u13039',"EGYPTIAN HIEROGLYPH A048");
  // map.put('\u1303A',"EGYPTIAN HIEROGLYPH A049");
  // map.put('\u1303B',"EGYPTIAN HIEROGLYPH A050");
  // map.put('\u1303C',"EGYPTIAN HIEROGLYPH A051");
  // map.put('\u1303D',"EGYPTIAN HIEROGLYPH A052");
  // map.put('\u1303E',"EGYPTIAN HIEROGLYPH A053");
  // map.put('\u1303F',"EGYPTIAN HIEROGLYPH A054");
  // map.put('\u13040',"EGYPTIAN HIEROGLYPH A055");
  // map.put('\u13041',"EGYPTIAN HIEROGLYPH A056");
  // map.put('\u13042',"EGYPTIAN HIEROGLYPH A057");
  // map.put('\u13043',"EGYPTIAN HIEROGLYPH A058");
  // map.put('\u13044',"EGYPTIAN HIEROGLYPH A059");
  // map.put('\u13045',"EGYPTIAN HIEROGLYPH A060");
  // map.put('\u13046',"EGYPTIAN HIEROGLYPH A061");
  // map.put('\u13047',"EGYPTIAN HIEROGLYPH A062");
  // map.put('\u13048',"EGYPTIAN HIEROGLYPH A063");
  // map.put('\u13049',"EGYPTIAN HIEROGLYPH A064");
  // map.put('\u1304A',"EGYPTIAN HIEROGLYPH A065");
  // map.put('\u1304B',"EGYPTIAN HIEROGLYPH A066");
  // map.put('\u1304C',"EGYPTIAN HIEROGLYPH A067");
  // map.put('\u1304D',"EGYPTIAN HIEROGLYPH A068");
  // map.put('\u1304E',"EGYPTIAN HIEROGLYPH A069");
  // map.put('\u1304F',"EGYPTIAN HIEROGLYPH A070");
  // map.put('\u13050',"EGYPTIAN HIEROGLYPH B001");
  // map.put('\u13051',"EGYPTIAN HIEROGLYPH B002");
  // map.put('\u13052',"EGYPTIAN HIEROGLYPH B003");
  // map.put('\u13053',"EGYPTIAN HIEROGLYPH B004");
  // map.put('\u13054',"EGYPTIAN HIEROGLYPH B005");
  // map.put('\u13055',"EGYPTIAN HIEROGLYPH B005A");
  // map.put('\u13056',"EGYPTIAN HIEROGLYPH B006");
  // map.put('\u13057',"EGYPTIAN HIEROGLYPH B007");
  // map.put('\u13058',"EGYPTIAN HIEROGLYPH B008");
  // map.put('\u13059',"EGYPTIAN HIEROGLYPH B009");
  // map.put('\u1305A',"EGYPTIAN HIEROGLYPH C001");
  // map.put('\u1305B',"EGYPTIAN HIEROGLYPH C002");
  // map.put('\u1305C',"EGYPTIAN HIEROGLYPH C002A");
  // map.put('\u1305D',"EGYPTIAN HIEROGLYPH C002B");
  // map.put('\u1305E',"EGYPTIAN HIEROGLYPH C002C");
  // map.put('\u1305F',"EGYPTIAN HIEROGLYPH C003");
  // map.put('\u13060',"EGYPTIAN HIEROGLYPH C004");
  // map.put('\u13061',"EGYPTIAN HIEROGLYPH C005");
  // map.put('\u13062',"EGYPTIAN HIEROGLYPH C006");
  // map.put('\u13063',"EGYPTIAN HIEROGLYPH C007");
  // map.put('\u13064',"EGYPTIAN HIEROGLYPH C008");
  // map.put('\u13065',"EGYPTIAN HIEROGLYPH C009");
  // map.put('\u13066',"EGYPTIAN HIEROGLYPH C010");
  // map.put('\u13067',"EGYPTIAN HIEROGLYPH C010A");
  // map.put('\u13068',"EGYPTIAN HIEROGLYPH C011");
  // map.put('\u13069',"EGYPTIAN HIEROGLYPH C012");
  // map.put('\u1306A',"EGYPTIAN HIEROGLYPH C013");
  // map.put('\u1306B',"EGYPTIAN HIEROGLYPH C014");
  // map.put('\u1306C',"EGYPTIAN HIEROGLYPH C015");
  // map.put('\u1306D',"EGYPTIAN HIEROGLYPH C016");
  // map.put('\u1306E',"EGYPTIAN HIEROGLYPH C017");
  // map.put('\u1306F',"EGYPTIAN HIEROGLYPH C018");
  // map.put('\u13070',"EGYPTIAN HIEROGLYPH C019");
  // map.put('\u13071',"EGYPTIAN HIEROGLYPH C020");
  // map.put('\u13072',"EGYPTIAN HIEROGLYPH C021");
  // map.put('\u13073',"EGYPTIAN HIEROGLYPH C022");
  // map.put('\u13074',"EGYPTIAN HIEROGLYPH C023");
  // map.put('\u13075',"EGYPTIAN HIEROGLYPH C024");
  // map.put('\u13076',"EGYPTIAN HIEROGLYPH D001");
  // map.put('\u13077',"EGYPTIAN HIEROGLYPH D002");
  // map.put('\u13078',"EGYPTIAN HIEROGLYPH D003");
  // map.put('\u13079',"EGYPTIAN HIEROGLYPH D004");
  // map.put('\u1307A',"EGYPTIAN HIEROGLYPH D005");
  // map.put('\u1307B',"EGYPTIAN HIEROGLYPH D006");
  // map.put('\u1307C',"EGYPTIAN HIEROGLYPH D007");
  // map.put('\u1307D',"EGYPTIAN HIEROGLYPH D008");
  // map.put('\u1307E',"EGYPTIAN HIEROGLYPH D008A");
  // map.put('\u1307F',"EGYPTIAN HIEROGLYPH D009");
  // map.put('\u13080',"EGYPTIAN HIEROGLYPH D010");
  // map.put('\u13081',"EGYPTIAN HIEROGLYPH D011");
  // map.put('\u13082',"EGYPTIAN HIEROGLYPH D012");
  // map.put('\u13083',"EGYPTIAN HIEROGLYPH D013");
  // map.put('\u13084',"EGYPTIAN HIEROGLYPH D014");
  // map.put('\u13085',"EGYPTIAN HIEROGLYPH D015");
  // map.put('\u13086',"EGYPTIAN HIEROGLYPH D016");
  // map.put('\u13087',"EGYPTIAN HIEROGLYPH D017");
  // map.put('\u13088',"EGYPTIAN HIEROGLYPH D018");
  // map.put('\u13089',"EGYPTIAN HIEROGLYPH D019");
  // map.put('\u1308A',"EGYPTIAN HIEROGLYPH D020");
  // map.put('\u1308B',"EGYPTIAN HIEROGLYPH D021");
  // map.put('\u1308C',"EGYPTIAN HIEROGLYPH D022");
  // map.put('\u1308D',"EGYPTIAN HIEROGLYPH D023");
  // map.put('\u1308E',"EGYPTIAN HIEROGLYPH D024");
  // map.put('\u1308F',"EGYPTIAN HIEROGLYPH D025");
  // map.put('\u13090',"EGYPTIAN HIEROGLYPH D026");
  // map.put('\u13091',"EGYPTIAN HIEROGLYPH D027");
  // map.put('\u13092',"EGYPTIAN HIEROGLYPH D027A");
  // map.put('\u13093',"EGYPTIAN HIEROGLYPH D028");
  // map.put('\u13094',"EGYPTIAN HIEROGLYPH D029");
  // map.put('\u13095',"EGYPTIAN HIEROGLYPH D030");
  // map.put('\u13096',"EGYPTIAN HIEROGLYPH D031");
  // map.put('\u13097',"EGYPTIAN HIEROGLYPH D031A");
  // map.put('\u13098',"EGYPTIAN HIEROGLYPH D032");
  // map.put('\u13099',"EGYPTIAN HIEROGLYPH D033");
  // map.put('\u1309A',"EGYPTIAN HIEROGLYPH D034");
  // map.put('\u1309B',"EGYPTIAN HIEROGLYPH D034A");
  // map.put('\u1309C',"EGYPTIAN HIEROGLYPH D035");
  // map.put('\u1309D',"EGYPTIAN HIEROGLYPH D036");
  // map.put('\u1309E',"EGYPTIAN HIEROGLYPH D037");
  // map.put('\u1309F',"EGYPTIAN HIEROGLYPH D038");
  // map.put('\u130A0',"EGYPTIAN HIEROGLYPH D039");
  // map.put('\u130A1',"EGYPTIAN HIEROGLYPH D040");
  // map.put('\u130A2',"EGYPTIAN HIEROGLYPH D041");
  // map.put('\u130A3',"EGYPTIAN HIEROGLYPH D042");
  // map.put('\u130A4',"EGYPTIAN HIEROGLYPH D043");
  // map.put('\u130A5',"EGYPTIAN HIEROGLYPH D044");
  // map.put('\u130A6',"EGYPTIAN HIEROGLYPH D045");
  // map.put('\u130A7',"EGYPTIAN HIEROGLYPH D046");
  // map.put('\u130A8',"EGYPTIAN HIEROGLYPH D046A");
  // map.put('\u130A9',"EGYPTIAN HIEROGLYPH D047");
  // map.put('\u130AA',"EGYPTIAN HIEROGLYPH D048");
  // map.put('\u130AB',"EGYPTIAN HIEROGLYPH D048A");
  // map.put('\u130AC',"EGYPTIAN HIEROGLYPH D049");
  // map.put('\u130AD',"EGYPTIAN HIEROGLYPH D050");
  // map.put('\u130AE',"EGYPTIAN HIEROGLYPH D050A");
  // map.put('\u130AF',"EGYPTIAN HIEROGLYPH D050B");
  // map.put('\u130B0',"EGYPTIAN HIEROGLYPH D050C");
  // map.put('\u130B1',"EGYPTIAN HIEROGLYPH D050D");
  // map.put('\u130B2',"EGYPTIAN HIEROGLYPH D050E");
  // map.put('\u130B3',"EGYPTIAN HIEROGLYPH D050F");
  // map.put('\u130B4',"EGYPTIAN HIEROGLYPH D050G");
  // map.put('\u130B5',"EGYPTIAN HIEROGLYPH D050H");
  // map.put('\u130B6',"EGYPTIAN HIEROGLYPH D050I");
  // map.put('\u130B7',"EGYPTIAN HIEROGLYPH D051");
  // map.put('\u130B8',"EGYPTIAN HIEROGLYPH D052");
  // map.put('\u130B9',"EGYPTIAN HIEROGLYPH D052A");
  // map.put('\u130BA',"EGYPTIAN HIEROGLYPH D053");
  // map.put('\u130BB',"EGYPTIAN HIEROGLYPH D054");
  // map.put('\u130BC',"EGYPTIAN HIEROGLYPH D054A");
  // map.put('\u130BD',"EGYPTIAN HIEROGLYPH D055");
  // map.put('\u130BE',"EGYPTIAN HIEROGLYPH D056");
  // map.put('\u130BF',"EGYPTIAN HIEROGLYPH D057");
  // map.put('\u130C0',"EGYPTIAN HIEROGLYPH D058");
  // map.put('\u130C1',"EGYPTIAN HIEROGLYPH D059");
  // map.put('\u130C2',"EGYPTIAN HIEROGLYPH D060");
  // map.put('\u130C3',"EGYPTIAN HIEROGLYPH D061");
  // map.put('\u130C4',"EGYPTIAN HIEROGLYPH D062");
  // map.put('\u130C5',"EGYPTIAN HIEROGLYPH D063");
  // map.put('\u130C6',"EGYPTIAN HIEROGLYPH D064");
  // map.put('\u130C7',"EGYPTIAN HIEROGLYPH D065");
  // map.put('\u130C8',"EGYPTIAN HIEROGLYPH D066");
  // map.put('\u130C9',"EGYPTIAN HIEROGLYPH D067");
  // map.put('\u130CA',"EGYPTIAN HIEROGLYPH D067A");
  // map.put('\u130CB',"EGYPTIAN HIEROGLYPH D067B");
  // map.put('\u130CC',"EGYPTIAN HIEROGLYPH D067C");
  // map.put('\u130CD',"EGYPTIAN HIEROGLYPH D067D");
  // map.put('\u130CE',"EGYPTIAN HIEROGLYPH D067E");
  // map.put('\u130CF',"EGYPTIAN HIEROGLYPH D067F");
  // map.put('\u130D0',"EGYPTIAN HIEROGLYPH D067G");
  // map.put('\u130D1',"EGYPTIAN HIEROGLYPH D067H");
  // map.put('\u130D2',"EGYPTIAN HIEROGLYPH E001");
  // map.put('\u130D3',"EGYPTIAN HIEROGLYPH E002");
  // map.put('\u130D4',"EGYPTIAN HIEROGLYPH E003");
  // map.put('\u130D5',"EGYPTIAN HIEROGLYPH E004");
  // map.put('\u130D6',"EGYPTIAN HIEROGLYPH E005");
  // map.put('\u130D7',"EGYPTIAN HIEROGLYPH E006");
  // map.put('\u130D8',"EGYPTIAN HIEROGLYPH E007");
  // map.put('\u130D9',"EGYPTIAN HIEROGLYPH E008");
  // map.put('\u130DA',"EGYPTIAN HIEROGLYPH E008A");
  // map.put('\u130DB',"EGYPTIAN HIEROGLYPH E009");
  // map.put('\u130DC',"EGYPTIAN HIEROGLYPH E009A");
  // map.put('\u130DD',"EGYPTIAN HIEROGLYPH E010");
  // map.put('\u130DE',"EGYPTIAN HIEROGLYPH E011");
  // map.put('\u130DF',"EGYPTIAN HIEROGLYPH E012");
  // map.put('\u130E0',"EGYPTIAN HIEROGLYPH E013");
  // map.put('\u130E1',"EGYPTIAN HIEROGLYPH E014");
  // map.put('\u130E2',"EGYPTIAN HIEROGLYPH E015");
  // map.put('\u130E3',"EGYPTIAN HIEROGLYPH E016");
  // map.put('\u130E4',"EGYPTIAN HIEROGLYPH E016A");
  // map.put('\u130E5',"EGYPTIAN HIEROGLYPH E017");
  // map.put('\u130E6',"EGYPTIAN HIEROGLYPH E017A");
  // map.put('\u130E7',"EGYPTIAN HIEROGLYPH E018");
  // map.put('\u130E8',"EGYPTIAN HIEROGLYPH E019");
  // map.put('\u130E9',"EGYPTIAN HIEROGLYPH E020");
  // map.put('\u130EA',"EGYPTIAN HIEROGLYPH E020A");
  // map.put('\u130EB',"EGYPTIAN HIEROGLYPH E021");
  // map.put('\u130EC',"EGYPTIAN HIEROGLYPH E022");
  // map.put('\u130ED',"EGYPTIAN HIEROGLYPH E023");
  // map.put('\u130EE',"EGYPTIAN HIEROGLYPH E024");
  // map.put('\u130EF',"EGYPTIAN HIEROGLYPH E025");
  // map.put('\u130F0',"EGYPTIAN HIEROGLYPH E026");
  // map.put('\u130F1',"EGYPTIAN HIEROGLYPH E027");
  // map.put('\u130F2',"EGYPTIAN HIEROGLYPH E028");
  // map.put('\u130F3',"EGYPTIAN HIEROGLYPH E028A");
  // map.put('\u130F4',"EGYPTIAN HIEROGLYPH E029");
  // map.put('\u130F5',"EGYPTIAN HIEROGLYPH E030");
  // map.put('\u130F6',"EGYPTIAN HIEROGLYPH E031");
  // map.put('\u130F7',"EGYPTIAN HIEROGLYPH E032");
  // map.put('\u130F8',"EGYPTIAN HIEROGLYPH E033");
  // map.put('\u130F9',"EGYPTIAN HIEROGLYPH E034");
  // map.put('\u130FA',"EGYPTIAN HIEROGLYPH E034A");
  // map.put('\u130FB',"EGYPTIAN HIEROGLYPH E036");
  // map.put('\u130FC',"EGYPTIAN HIEROGLYPH E037");
  // map.put('\u130FD',"EGYPTIAN HIEROGLYPH E038");
  // map.put('\u130FE',"EGYPTIAN HIEROGLYPH F001");
  // map.put('\u130FF',"EGYPTIAN HIEROGLYPH F001A");
  // map.put('\u13100',"EGYPTIAN HIEROGLYPH F002");
  // map.put('\u13101',"EGYPTIAN HIEROGLYPH F003");
  // map.put('\u13102',"EGYPTIAN HIEROGLYPH F004");
  // map.put('\u13103',"EGYPTIAN HIEROGLYPH F005");
  // map.put('\u13104',"EGYPTIAN HIEROGLYPH F006");
  // map.put('\u13105',"EGYPTIAN HIEROGLYPH F007");
  // map.put('\u13106',"EGYPTIAN HIEROGLYPH F008");
  // map.put('\u13107',"EGYPTIAN HIEROGLYPH F009");
  // map.put('\u13108',"EGYPTIAN HIEROGLYPH F010");
  // map.put('\u13109',"EGYPTIAN HIEROGLYPH F011");
  // map.put('\u1310A',"EGYPTIAN HIEROGLYPH F012");
  // map.put('\u1310B',"EGYPTIAN HIEROGLYPH F013");
  // map.put('\u1310C',"EGYPTIAN HIEROGLYPH F013A");
  // map.put('\u1310D',"EGYPTIAN HIEROGLYPH F014");
  // map.put('\u1310E',"EGYPTIAN HIEROGLYPH F015");
  // map.put('\u1310F',"EGYPTIAN HIEROGLYPH F016");
  // map.put('\u13110',"EGYPTIAN HIEROGLYPH F017");
  // map.put('\u13111',"EGYPTIAN HIEROGLYPH F018");
  // map.put('\u13112',"EGYPTIAN HIEROGLYPH F019");
  // map.put('\u13113',"EGYPTIAN HIEROGLYPH F020");
  // map.put('\u13114',"EGYPTIAN HIEROGLYPH F021");
  // map.put('\u13115',"EGYPTIAN HIEROGLYPH F021A");
  // map.put('\u13116',"EGYPTIAN HIEROGLYPH F022");
  // map.put('\u13117',"EGYPTIAN HIEROGLYPH F023");
  // map.put('\u13118',"EGYPTIAN HIEROGLYPH F024");
  // map.put('\u13119',"EGYPTIAN HIEROGLYPH F025");
  // map.put('\u1311A',"EGYPTIAN HIEROGLYPH F026");
  // map.put('\u1311B',"EGYPTIAN HIEROGLYPH F027");
  // map.put('\u1311C',"EGYPTIAN HIEROGLYPH F028");
  // map.put('\u1311D',"EGYPTIAN HIEROGLYPH F029");
  // map.put('\u1311E',"EGYPTIAN HIEROGLYPH F030");
  // map.put('\u1311F',"EGYPTIAN HIEROGLYPH F031");
  // map.put('\u13120',"EGYPTIAN HIEROGLYPH F031A");
  // map.put('\u13121',"EGYPTIAN HIEROGLYPH F032");
  // map.put('\u13122',"EGYPTIAN HIEROGLYPH F033");
  // map.put('\u13123',"EGYPTIAN HIEROGLYPH F034");
  // map.put('\u13124',"EGYPTIAN HIEROGLYPH F035");
  // map.put('\u13125',"EGYPTIAN HIEROGLYPH F036");
  // map.put('\u13126',"EGYPTIAN HIEROGLYPH F037");
  // map.put('\u13127',"EGYPTIAN HIEROGLYPH F037A");
  // map.put('\u13128',"EGYPTIAN HIEROGLYPH F038");
  // map.put('\u13129',"EGYPTIAN HIEROGLYPH F038A");
  // map.put('\u1312A',"EGYPTIAN HIEROGLYPH F039");
  // map.put('\u1312B',"EGYPTIAN HIEROGLYPH F040");
  // map.put('\u1312C',"EGYPTIAN HIEROGLYPH F041");
  // map.put('\u1312D',"EGYPTIAN HIEROGLYPH F042");
  // map.put('\u1312E',"EGYPTIAN HIEROGLYPH F043");
  // map.put('\u1312F',"EGYPTIAN HIEROGLYPH F044");
  // map.put('\u13130',"EGYPTIAN HIEROGLYPH F045");
  // map.put('\u13131',"EGYPTIAN HIEROGLYPH F045A");
  // map.put('\u13132',"EGYPTIAN HIEROGLYPH F046");
  // map.put('\u13133',"EGYPTIAN HIEROGLYPH F046A");
  // map.put('\u13134',"EGYPTIAN HIEROGLYPH F047");
  // map.put('\u13135',"EGYPTIAN HIEROGLYPH F047A");
  // map.put('\u13136',"EGYPTIAN HIEROGLYPH F048");
  // map.put('\u13137',"EGYPTIAN HIEROGLYPH F049");
  // map.put('\u13138',"EGYPTIAN HIEROGLYPH F050");
  // map.put('\u13139',"EGYPTIAN HIEROGLYPH F051");
  // map.put('\u1313A',"EGYPTIAN HIEROGLYPH F051A");
  // map.put('\u1313B',"EGYPTIAN HIEROGLYPH F051B");
  // map.put('\u1313C',"EGYPTIAN HIEROGLYPH F051C");
  // map.put('\u1313D',"EGYPTIAN HIEROGLYPH F052");
  // map.put('\u1313E',"EGYPTIAN HIEROGLYPH F053");
  // map.put('\u1313F',"EGYPTIAN HIEROGLYPH G001");
  // map.put('\u13140',"EGYPTIAN HIEROGLYPH G002");
  // map.put('\u13141',"EGYPTIAN HIEROGLYPH G003");
  // map.put('\u13142',"EGYPTIAN HIEROGLYPH G004");
  // map.put('\u13143',"EGYPTIAN HIEROGLYPH G005");
  // map.put('\u13144',"EGYPTIAN HIEROGLYPH G006");
  // map.put('\u13145',"EGYPTIAN HIEROGLYPH G006A");
  // map.put('\u13146',"EGYPTIAN HIEROGLYPH G007");
  // map.put('\u13147',"EGYPTIAN HIEROGLYPH G007A");
  // map.put('\u13148',"EGYPTIAN HIEROGLYPH G007B");
  // map.put('\u13149',"EGYPTIAN HIEROGLYPH G008");
  // map.put('\u1314A',"EGYPTIAN HIEROGLYPH G009");
  // map.put('\u1314B',"EGYPTIAN HIEROGLYPH G010");
  // map.put('\u1314C',"EGYPTIAN HIEROGLYPH G011");
  // map.put('\u1314D',"EGYPTIAN HIEROGLYPH G011A");
  // map.put('\u1314E',"EGYPTIAN HIEROGLYPH G012");
  // map.put('\u1314F',"EGYPTIAN HIEROGLYPH G013");
  // map.put('\u13150',"EGYPTIAN HIEROGLYPH G014");
  // map.put('\u13151',"EGYPTIAN HIEROGLYPH G015");
  // map.put('\u13152',"EGYPTIAN HIEROGLYPH G016");
  // map.put('\u13153',"EGYPTIAN HIEROGLYPH G017");
  // map.put('\u13154',"EGYPTIAN HIEROGLYPH G018");
  // map.put('\u13155',"EGYPTIAN HIEROGLYPH G019");
  // map.put('\u13156',"EGYPTIAN HIEROGLYPH G020");
  // map.put('\u13157',"EGYPTIAN HIEROGLYPH G020A");
  // map.put('\u13158',"EGYPTIAN HIEROGLYPH G021");
  // map.put('\u13159',"EGYPTIAN HIEROGLYPH G022");
  // map.put('\u1315A',"EGYPTIAN HIEROGLYPH G023");
  // map.put('\u1315B',"EGYPTIAN HIEROGLYPH G024");
  // map.put('\u1315C',"EGYPTIAN HIEROGLYPH G025");
  // map.put('\u1315D',"EGYPTIAN HIEROGLYPH G026");
  // map.put('\u1315E',"EGYPTIAN HIEROGLYPH G026A");
  // map.put('\u1315F',"EGYPTIAN HIEROGLYPH G027");
  // map.put('\u13160',"EGYPTIAN HIEROGLYPH G028");
  // map.put('\u13161',"EGYPTIAN HIEROGLYPH G029");
  // map.put('\u13162',"EGYPTIAN HIEROGLYPH G030");
  // map.put('\u13163',"EGYPTIAN HIEROGLYPH G031");
  // map.put('\u13164',"EGYPTIAN HIEROGLYPH G032");
  // map.put('\u13165',"EGYPTIAN HIEROGLYPH G033");
  // map.put('\u13166',"EGYPTIAN HIEROGLYPH G034");
  // map.put('\u13167',"EGYPTIAN HIEROGLYPH G035");
  // map.put('\u13168',"EGYPTIAN HIEROGLYPH G036");
  // map.put('\u13169',"EGYPTIAN HIEROGLYPH G036A");
  // map.put('\u1316A',"EGYPTIAN HIEROGLYPH G037");
  // map.put('\u1316B',"EGYPTIAN HIEROGLYPH G037A");
  // map.put('\u1316C',"EGYPTIAN HIEROGLYPH G038");
  // map.put('\u1316D',"EGYPTIAN HIEROGLYPH G039");
  // map.put('\u1316E',"EGYPTIAN HIEROGLYPH G040");
  // map.put('\u1316F',"EGYPTIAN HIEROGLYPH G041");
  // map.put('\u13170',"EGYPTIAN HIEROGLYPH G042");
  // map.put('\u13171',"EGYPTIAN HIEROGLYPH G043");
  // map.put('\u13172',"EGYPTIAN HIEROGLYPH G043A");
  // map.put('\u13173',"EGYPTIAN HIEROGLYPH G044");
  // map.put('\u13174',"EGYPTIAN HIEROGLYPH G045");
  // map.put('\u13175',"EGYPTIAN HIEROGLYPH G045A");
  // map.put('\u13176',"EGYPTIAN HIEROGLYPH G046");
  // map.put('\u13177',"EGYPTIAN HIEROGLYPH G047");
  // map.put('\u13178',"EGYPTIAN HIEROGLYPH G048");
  // map.put('\u13179',"EGYPTIAN HIEROGLYPH G049");
  // map.put('\u1317A',"EGYPTIAN HIEROGLYPH G050");
  // map.put('\u1317B',"EGYPTIAN HIEROGLYPH G051");
  // map.put('\u1317C',"EGYPTIAN HIEROGLYPH G052");
  // map.put('\u1317D',"EGYPTIAN HIEROGLYPH G053");
  // map.put('\u1317E',"EGYPTIAN HIEROGLYPH G054");
  // map.put('\u1317F',"EGYPTIAN HIEROGLYPH H001");
  // map.put('\u13180',"EGYPTIAN HIEROGLYPH H002");
  // map.put('\u13181',"EGYPTIAN HIEROGLYPH H003");
  // map.put('\u13182',"EGYPTIAN HIEROGLYPH H004");
  // map.put('\u13183',"EGYPTIAN HIEROGLYPH H005");
  // map.put('\u13184',"EGYPTIAN HIEROGLYPH H006");
  // map.put('\u13185',"EGYPTIAN HIEROGLYPH H006A");
  // map.put('\u13186',"EGYPTIAN HIEROGLYPH H007");
  // map.put('\u13187',"EGYPTIAN HIEROGLYPH H008");
  // map.put('\u13188',"EGYPTIAN HIEROGLYPH I001");
  // map.put('\u13189',"EGYPTIAN HIEROGLYPH I002");
  // map.put('\u1318A',"EGYPTIAN HIEROGLYPH I003");
  // map.put('\u1318B',"EGYPTIAN HIEROGLYPH I004");
  // map.put('\u1318C',"EGYPTIAN HIEROGLYPH I005");
  // map.put('\u1318D',"EGYPTIAN HIEROGLYPH I005A");
  // map.put('\u1318E',"EGYPTIAN HIEROGLYPH I006");
  // map.put('\u1318F',"EGYPTIAN HIEROGLYPH I007");
  // map.put('\u13190',"EGYPTIAN HIEROGLYPH I008");
  // map.put('\u13191',"EGYPTIAN HIEROGLYPH I009");
  // map.put('\u13192',"EGYPTIAN HIEROGLYPH I009A");
  // map.put('\u13193',"EGYPTIAN HIEROGLYPH I010");
  // map.put('\u13194',"EGYPTIAN HIEROGLYPH I010A");
  // map.put('\u13195',"EGYPTIAN HIEROGLYPH I011");
  // map.put('\u13196',"EGYPTIAN HIEROGLYPH I011A");
  // map.put('\u13197',"EGYPTIAN HIEROGLYPH I012");
  // map.put('\u13198',"EGYPTIAN HIEROGLYPH I013");
  // map.put('\u13199',"EGYPTIAN HIEROGLYPH I014");
  // map.put('\u1319A',"EGYPTIAN HIEROGLYPH I015");
  // map.put('\u1319B',"EGYPTIAN HIEROGLYPH K001");
  // map.put('\u1319C',"EGYPTIAN HIEROGLYPH K002");
  // map.put('\u1319D',"EGYPTIAN HIEROGLYPH K003");
  // map.put('\u1319E',"EGYPTIAN HIEROGLYPH K004");
  // map.put('\u1319F',"EGYPTIAN HIEROGLYPH K005");
  // map.put('\u131A0',"EGYPTIAN HIEROGLYPH K006");
  // map.put('\u131A1',"EGYPTIAN HIEROGLYPH K007");
  // map.put('\u131A2',"EGYPTIAN HIEROGLYPH K008");
  // map.put('\u131A3',"EGYPTIAN HIEROGLYPH L001");
  // map.put('\u131A4',"EGYPTIAN HIEROGLYPH L002");
  // map.put('\u131A5',"EGYPTIAN HIEROGLYPH L002A");
  // map.put('\u131A6',"EGYPTIAN HIEROGLYPH L003");
  // map.put('\u131A7',"EGYPTIAN HIEROGLYPH L004");
  // map.put('\u131A8',"EGYPTIAN HIEROGLYPH L005");
  // map.put('\u131A9',"EGYPTIAN HIEROGLYPH L006");
  // map.put('\u131AA',"EGYPTIAN HIEROGLYPH L006A");
  // map.put('\u131AB',"EGYPTIAN HIEROGLYPH L007");
  // map.put('\u131AC',"EGYPTIAN HIEROGLYPH L008");
  // map.put('\u131AD',"EGYPTIAN HIEROGLYPH M001");
  // map.put('\u131AE',"EGYPTIAN HIEROGLYPH M001A");
  // map.put('\u131AF',"EGYPTIAN HIEROGLYPH M001B");
  // map.put('\u131B0',"EGYPTIAN HIEROGLYPH M002");
  // map.put('\u131B1',"EGYPTIAN HIEROGLYPH M003");
  // map.put('\u131B2',"EGYPTIAN HIEROGLYPH M003A");
  // map.put('\u131B3',"EGYPTIAN HIEROGLYPH M004");
  // map.put('\u131B4',"EGYPTIAN HIEROGLYPH M005");
  // map.put('\u131B5',"EGYPTIAN HIEROGLYPH M006");
  // map.put('\u131B6',"EGYPTIAN HIEROGLYPH M007");
  // map.put('\u131B7',"EGYPTIAN HIEROGLYPH M008");
  // map.put('\u131B8',"EGYPTIAN HIEROGLYPH M009");
  // map.put('\u131B9',"EGYPTIAN HIEROGLYPH M010");
  // map.put('\u131BA',"EGYPTIAN HIEROGLYPH M010A");
  // map.put('\u131BB',"EGYPTIAN HIEROGLYPH M011");
  // map.put('\u131BC',"EGYPTIAN HIEROGLYPH M012");
  // map.put('\u131BD',"EGYPTIAN HIEROGLYPH M012A");
  // map.put('\u131BE',"EGYPTIAN HIEROGLYPH M012B");
  // map.put('\u131BF',"EGYPTIAN HIEROGLYPH M012C");
  // map.put('\u131C0',"EGYPTIAN HIEROGLYPH M012D");
  // map.put('\u131C1',"EGYPTIAN HIEROGLYPH M012E");
  // map.put('\u131C2',"EGYPTIAN HIEROGLYPH M012F");
  // map.put('\u131C3',"EGYPTIAN HIEROGLYPH M012G");
  // map.put('\u131C4',"EGYPTIAN HIEROGLYPH M012H");
  // map.put('\u131C5',"EGYPTIAN HIEROGLYPH M013");
  // map.put('\u131C6',"EGYPTIAN HIEROGLYPH M014");
  // map.put('\u131C7',"EGYPTIAN HIEROGLYPH M015");
  // map.put('\u131C8',"EGYPTIAN HIEROGLYPH M015A");
  // map.put('\u131C9',"EGYPTIAN HIEROGLYPH M016");
  // map.put('\u131CA',"EGYPTIAN HIEROGLYPH M016A");
  // map.put('\u131CB',"EGYPTIAN HIEROGLYPH M017");
  // map.put('\u131CC',"EGYPTIAN HIEROGLYPH M017A");
  // map.put('\u131CD',"EGYPTIAN HIEROGLYPH M018");
  // map.put('\u131CE',"EGYPTIAN HIEROGLYPH M019");
  // map.put('\u131CF',"EGYPTIAN HIEROGLYPH M020");
  // map.put('\u131D0',"EGYPTIAN HIEROGLYPH M021");
  // map.put('\u131D1',"EGYPTIAN HIEROGLYPH M022");
  // map.put('\u131D2',"EGYPTIAN HIEROGLYPH M022A");
  // map.put('\u131D3',"EGYPTIAN HIEROGLYPH M023");
  // map.put('\u131D4',"EGYPTIAN HIEROGLYPH M024");
  // map.put('\u131D5',"EGYPTIAN HIEROGLYPH M024A");
  // map.put('\u131D6',"EGYPTIAN HIEROGLYPH M025");
  // map.put('\u131D7',"EGYPTIAN HIEROGLYPH M026");
  // map.put('\u131D8',"EGYPTIAN HIEROGLYPH M027");
  // map.put('\u131D9',"EGYPTIAN HIEROGLYPH M028");
  // map.put('\u131DA',"EGYPTIAN HIEROGLYPH M028A");
  // map.put('\u131DB',"EGYPTIAN HIEROGLYPH M029");
  // map.put('\u131DC',"EGYPTIAN HIEROGLYPH M030");
  // map.put('\u131DD',"EGYPTIAN HIEROGLYPH M031");
  // map.put('\u131DE',"EGYPTIAN HIEROGLYPH M031A");
  // map.put('\u131DF',"EGYPTIAN HIEROGLYPH M032");
  // map.put('\u131E0',"EGYPTIAN HIEROGLYPH M033");
  // map.put('\u131E1',"EGYPTIAN HIEROGLYPH M033A");
  // map.put('\u131E2',"EGYPTIAN HIEROGLYPH M033B");
  // map.put('\u131E3',"EGYPTIAN HIEROGLYPH M034");
  // map.put('\u131E4',"EGYPTIAN HIEROGLYPH M035");
  // map.put('\u131E5',"EGYPTIAN HIEROGLYPH M036");
  // map.put('\u131E6',"EGYPTIAN HIEROGLYPH M037");
  // map.put('\u131E7',"EGYPTIAN HIEROGLYPH M038");
  // map.put('\u131E8',"EGYPTIAN HIEROGLYPH M039");
  // map.put('\u131E9',"EGYPTIAN HIEROGLYPH M040");
  // map.put('\u131EA',"EGYPTIAN HIEROGLYPH M040A");
  // map.put('\u131EB',"EGYPTIAN HIEROGLYPH M041");
  // map.put('\u131EC',"EGYPTIAN HIEROGLYPH M042");
  // map.put('\u131ED',"EGYPTIAN HIEROGLYPH M043");
  // map.put('\u131EE',"EGYPTIAN HIEROGLYPH M044");
  // map.put('\u131EF',"EGYPTIAN HIEROGLYPH N001");
  // map.put('\u131F0',"EGYPTIAN HIEROGLYPH N002");
  // map.put('\u131F1',"EGYPTIAN HIEROGLYPH N003");
  // map.put('\u131F2',"EGYPTIAN HIEROGLYPH N004");
  // map.put('\u131F3',"EGYPTIAN HIEROGLYPH N005");
  // map.put('\u131F4',"EGYPTIAN HIEROGLYPH N006");
  // map.put('\u131F5',"EGYPTIAN HIEROGLYPH N007");
  // map.put('\u131F6',"EGYPTIAN HIEROGLYPH N008");
  // map.put('\u131F7',"EGYPTIAN HIEROGLYPH N009");
  // map.put('\u131F8',"EGYPTIAN HIEROGLYPH N010");
  // map.put('\u131F9',"EGYPTIAN HIEROGLYPH N011");
  // map.put('\u131FA',"EGYPTIAN HIEROGLYPH N012");
  // map.put('\u131FB',"EGYPTIAN HIEROGLYPH N013");
  // map.put('\u131FC',"EGYPTIAN HIEROGLYPH N014");
  // map.put('\u131FD',"EGYPTIAN HIEROGLYPH N015");
  // map.put('\u131FE',"EGYPTIAN HIEROGLYPH N016");
  // map.put('\u131FF',"EGYPTIAN HIEROGLYPH N017");
  // map.put('\u13200',"EGYPTIAN HIEROGLYPH N018");
  // map.put('\u13201',"EGYPTIAN HIEROGLYPH N018A");
  // map.put('\u13202',"EGYPTIAN HIEROGLYPH N018B");
  // map.put('\u13203',"EGYPTIAN HIEROGLYPH N019");
  // map.put('\u13204',"EGYPTIAN HIEROGLYPH N020");
  // map.put('\u13205',"EGYPTIAN HIEROGLYPH N021");
  // map.put('\u13206',"EGYPTIAN HIEROGLYPH N022");
  // map.put('\u13207',"EGYPTIAN HIEROGLYPH N023");
  // map.put('\u13208',"EGYPTIAN HIEROGLYPH N024");
  // map.put('\u13209',"EGYPTIAN HIEROGLYPH N025");
  // map.put('\u1320A',"EGYPTIAN HIEROGLYPH N025A");
  // map.put('\u1320B',"EGYPTIAN HIEROGLYPH N026");
  // map.put('\u1320C',"EGYPTIAN HIEROGLYPH N027");
  // map.put('\u1320D',"EGYPTIAN HIEROGLYPH N028");
  // map.put('\u1320E',"EGYPTIAN HIEROGLYPH N029");
  // map.put('\u1320F',"EGYPTIAN HIEROGLYPH N030");
  // map.put('\u13210',"EGYPTIAN HIEROGLYPH N031");
  // map.put('\u13211',"EGYPTIAN HIEROGLYPH N032");
  // map.put('\u13212',"EGYPTIAN HIEROGLYPH N033");
  // map.put('\u13213',"EGYPTIAN HIEROGLYPH N033A");
  // map.put('\u13214',"EGYPTIAN HIEROGLYPH N034");
  // map.put('\u13215',"EGYPTIAN HIEROGLYPH N034A");
  // map.put('\u13216',"EGYPTIAN HIEROGLYPH N035");
  // map.put('\u13217',"EGYPTIAN HIEROGLYPH N035A");
  // map.put('\u13218',"EGYPTIAN HIEROGLYPH N036");
  // map.put('\u13219',"EGYPTIAN HIEROGLYPH N037");
  // map.put('\u1321A',"EGYPTIAN HIEROGLYPH N037A");
  // map.put('\u1321B',"EGYPTIAN HIEROGLYPH N038");
  // map.put('\u1321C',"EGYPTIAN HIEROGLYPH N039");
  // map.put('\u1321D',"EGYPTIAN HIEROGLYPH N040");
  // map.put('\u1321E',"EGYPTIAN HIEROGLYPH N041");
  // map.put('\u1321F',"EGYPTIAN HIEROGLYPH N042");
  // map.put('\u13220',"EGYPTIAN HIEROGLYPH NL001");
  // map.put('\u13221',"EGYPTIAN HIEROGLYPH NL002");
  // map.put('\u13222',"EGYPTIAN HIEROGLYPH NL003");
  // map.put('\u13223',"EGYPTIAN HIEROGLYPH NL004");
  // map.put('\u13224',"EGYPTIAN HIEROGLYPH NL005");
  // map.put('\u13225',"EGYPTIAN HIEROGLYPH NL005A");
  // map.put('\u13226',"EGYPTIAN HIEROGLYPH NL006");
  // map.put('\u13227',"EGYPTIAN HIEROGLYPH NL007");
  // map.put('\u13228',"EGYPTIAN HIEROGLYPH NL008");
  // map.put('\u13229',"EGYPTIAN HIEROGLYPH NL009");
  // map.put('\u1322A',"EGYPTIAN HIEROGLYPH NL010");
  // map.put('\u1322B',"EGYPTIAN HIEROGLYPH NL011");
  // map.put('\u1322C',"EGYPTIAN HIEROGLYPH NL012");
  // map.put('\u1322D',"EGYPTIAN HIEROGLYPH NL013");
  // map.put('\u1322E',"EGYPTIAN HIEROGLYPH NL014");
  // map.put('\u1322F',"EGYPTIAN HIEROGLYPH NL015");
  // map.put('\u13230',"EGYPTIAN HIEROGLYPH NL016");
  // map.put('\u13231',"EGYPTIAN HIEROGLYPH NL017");
  // map.put('\u13232',"EGYPTIAN HIEROGLYPH NL017A");
  // map.put('\u13233',"EGYPTIAN HIEROGLYPH NL018");
  // map.put('\u13234',"EGYPTIAN HIEROGLYPH NL019");
  // map.put('\u13235',"EGYPTIAN HIEROGLYPH NL020");
  // map.put('\u13236',"EGYPTIAN HIEROGLYPH NU001");
  // map.put('\u13237',"EGYPTIAN HIEROGLYPH NU002");
  // map.put('\u13238',"EGYPTIAN HIEROGLYPH NU003");
  // map.put('\u13239',"EGYPTIAN HIEROGLYPH NU004");
  // map.put('\u1323A',"EGYPTIAN HIEROGLYPH NU005");
  // map.put('\u1323B',"EGYPTIAN HIEROGLYPH NU006");
  // map.put('\u1323C',"EGYPTIAN HIEROGLYPH NU007");
  // map.put('\u1323D',"EGYPTIAN HIEROGLYPH NU008");
  // map.put('\u1323E',"EGYPTIAN HIEROGLYPH NU009");
  // map.put('\u1323F',"EGYPTIAN HIEROGLYPH NU010");
  // map.put('\u13240',"EGYPTIAN HIEROGLYPH NU010A");
  // map.put('\u13241',"EGYPTIAN HIEROGLYPH NU011");
  // map.put('\u13242',"EGYPTIAN HIEROGLYPH NU011A");
  // map.put('\u13243',"EGYPTIAN HIEROGLYPH NU012");
  // map.put('\u13244',"EGYPTIAN HIEROGLYPH NU013");
  // map.put('\u13245',"EGYPTIAN HIEROGLYPH NU014");
  // map.put('\u13246',"EGYPTIAN HIEROGLYPH NU015");
  // map.put('\u13247',"EGYPTIAN HIEROGLYPH NU016");
  // map.put('\u13248',"EGYPTIAN HIEROGLYPH NU017");
  // map.put('\u13249',"EGYPTIAN HIEROGLYPH NU018");
  // map.put('\u1324A',"EGYPTIAN HIEROGLYPH NU018A");
  // map.put('\u1324B',"EGYPTIAN HIEROGLYPH NU019");
  // map.put('\u1324C',"EGYPTIAN HIEROGLYPH NU020");
  // map.put('\u1324D',"EGYPTIAN HIEROGLYPH NU021");
  // map.put('\u1324E',"EGYPTIAN HIEROGLYPH NU022");
  // map.put('\u1324F',"EGYPTIAN HIEROGLYPH NU022A");
  // map.put('\u13250',"EGYPTIAN HIEROGLYPH O001");
  // map.put('\u13251',"EGYPTIAN HIEROGLYPH O001A");
  // map.put('\u13252',"EGYPTIAN HIEROGLYPH O002");
  // map.put('\u13253',"EGYPTIAN HIEROGLYPH O003");
  // map.put('\u13254',"EGYPTIAN HIEROGLYPH O004");
  // map.put('\u13255',"EGYPTIAN HIEROGLYPH O005");
  // map.put('\u13256',"EGYPTIAN HIEROGLYPH O005A");
  // map.put('\u13257',"EGYPTIAN HIEROGLYPH O006");
  // map.put('\u13258',"EGYPTIAN HIEROGLYPH O006A");
  // map.put('\u13259',"EGYPTIAN HIEROGLYPH O006B");
  // map.put('\u1325A',"EGYPTIAN HIEROGLYPH O006C");
  // map.put('\u1325B',"EGYPTIAN HIEROGLYPH O006D");
  // map.put('\u1325C',"EGYPTIAN HIEROGLYPH O006E");
  // map.put('\u1325D',"EGYPTIAN HIEROGLYPH O006F");
  // map.put('\u1325E',"EGYPTIAN HIEROGLYPH O007");
  // map.put('\u1325F',"EGYPTIAN HIEROGLYPH O008");
  // map.put('\u13260',"EGYPTIAN HIEROGLYPH O009");
  // map.put('\u13261',"EGYPTIAN HIEROGLYPH O010");
  // map.put('\u13262',"EGYPTIAN HIEROGLYPH O010A");
  // map.put('\u13263',"EGYPTIAN HIEROGLYPH O010B");
  // map.put('\u13264',"EGYPTIAN HIEROGLYPH O010C");
  // map.put('\u13265',"EGYPTIAN HIEROGLYPH O011");
  // map.put('\u13266',"EGYPTIAN HIEROGLYPH O012");
  // map.put('\u13267',"EGYPTIAN HIEROGLYPH O013");
  // map.put('\u13268',"EGYPTIAN HIEROGLYPH O014");
  // map.put('\u13269',"EGYPTIAN HIEROGLYPH O015");
  // map.put('\u1326A',"EGYPTIAN HIEROGLYPH O016");
  // map.put('\u1326B',"EGYPTIAN HIEROGLYPH O017");
  // map.put('\u1326C',"EGYPTIAN HIEROGLYPH O018");
  // map.put('\u1326D',"EGYPTIAN HIEROGLYPH O019");
  // map.put('\u1326E',"EGYPTIAN HIEROGLYPH O019A");
  // map.put('\u1326F',"EGYPTIAN HIEROGLYPH O020");
  // map.put('\u13270',"EGYPTIAN HIEROGLYPH O020A");
  // map.put('\u13271',"EGYPTIAN HIEROGLYPH O021");
  // map.put('\u13272',"EGYPTIAN HIEROGLYPH O022");
  // map.put('\u13273',"EGYPTIAN HIEROGLYPH O023");
  // map.put('\u13274',"EGYPTIAN HIEROGLYPH O024");
  // map.put('\u13275',"EGYPTIAN HIEROGLYPH O024A");
  // map.put('\u13276',"EGYPTIAN HIEROGLYPH O025");
  // map.put('\u13277',"EGYPTIAN HIEROGLYPH O025A");
  // map.put('\u13278',"EGYPTIAN HIEROGLYPH O026");
  // map.put('\u13279',"EGYPTIAN HIEROGLYPH O027");
  // map.put('\u1327A',"EGYPTIAN HIEROGLYPH O028");
  // map.put('\u1327B',"EGYPTIAN HIEROGLYPH O029");
  // map.put('\u1327C',"EGYPTIAN HIEROGLYPH O029A");
  // map.put('\u1327D',"EGYPTIAN HIEROGLYPH O030");
  // map.put('\u1327E',"EGYPTIAN HIEROGLYPH O030A");
  // map.put('\u1327F',"EGYPTIAN HIEROGLYPH O031");
  // map.put('\u13280',"EGYPTIAN HIEROGLYPH O032");
  // map.put('\u13281',"EGYPTIAN HIEROGLYPH O033");
  // map.put('\u13282',"EGYPTIAN HIEROGLYPH O033A");
  // map.put('\u13283',"EGYPTIAN HIEROGLYPH O034");
  // map.put('\u13284',"EGYPTIAN HIEROGLYPH O035");
  // map.put('\u13285',"EGYPTIAN HIEROGLYPH O036");
  // map.put('\u13286',"EGYPTIAN HIEROGLYPH O036A");
  // map.put('\u13287',"EGYPTIAN HIEROGLYPH O036B");
  // map.put('\u13288',"EGYPTIAN HIEROGLYPH O036C");
  // map.put('\u13289',"EGYPTIAN HIEROGLYPH O036D");
  // map.put('\u1328A',"EGYPTIAN HIEROGLYPH O037");
  // map.put('\u1328B',"EGYPTIAN HIEROGLYPH O038");
  // map.put('\u1328C',"EGYPTIAN HIEROGLYPH O039");
  // map.put('\u1328D',"EGYPTIAN HIEROGLYPH O040");
  // map.put('\u1328E',"EGYPTIAN HIEROGLYPH O041");
  // map.put('\u1328F',"EGYPTIAN HIEROGLYPH O042");
  // map.put('\u13290',"EGYPTIAN HIEROGLYPH O043");
  // map.put('\u13291',"EGYPTIAN HIEROGLYPH O044");
  // map.put('\u13292',"EGYPTIAN HIEROGLYPH O045");
  // map.put('\u13293',"EGYPTIAN HIEROGLYPH O046");
  // map.put('\u13294',"EGYPTIAN HIEROGLYPH O047");
  // map.put('\u13295',"EGYPTIAN HIEROGLYPH O048");
  // map.put('\u13296',"EGYPTIAN HIEROGLYPH O049");
  // map.put('\u13297',"EGYPTIAN HIEROGLYPH O050");
  // map.put('\u13298',"EGYPTIAN HIEROGLYPH O050A");
  // map.put('\u13299',"EGYPTIAN HIEROGLYPH O050B");
  // map.put('\u1329A',"EGYPTIAN HIEROGLYPH O051");
  // map.put('\u1329B',"EGYPTIAN HIEROGLYPH P001");
  // map.put('\u1329C',"EGYPTIAN HIEROGLYPH P001A");
  // map.put('\u1329D',"EGYPTIAN HIEROGLYPH P002");
  // map.put('\u1329E',"EGYPTIAN HIEROGLYPH P003");
  // map.put('\u1329F',"EGYPTIAN HIEROGLYPH P003A");
  // map.put('\u132A0',"EGYPTIAN HIEROGLYPH P004");
  // map.put('\u132A1',"EGYPTIAN HIEROGLYPH P005");
  // map.put('\u132A2',"EGYPTIAN HIEROGLYPH P006");
  // map.put('\u132A3',"EGYPTIAN HIEROGLYPH P007");
  // map.put('\u132A4',"EGYPTIAN HIEROGLYPH P008");
  // map.put('\u132A5',"EGYPTIAN HIEROGLYPH P009");
  // map.put('\u132A6',"EGYPTIAN HIEROGLYPH P010");
  // map.put('\u132A7',"EGYPTIAN HIEROGLYPH P011");
  // map.put('\u132A8',"EGYPTIAN HIEROGLYPH Q001");
  // map.put('\u132A9',"EGYPTIAN HIEROGLYPH Q002");
  // map.put('\u132AA',"EGYPTIAN HIEROGLYPH Q003");
  // map.put('\u132AB',"EGYPTIAN HIEROGLYPH Q004");
  // map.put('\u132AC',"EGYPTIAN HIEROGLYPH Q005");
  // map.put('\u132AD',"EGYPTIAN HIEROGLYPH Q006");
  // map.put('\u132AE',"EGYPTIAN HIEROGLYPH Q007");
  // map.put('\u132AF',"EGYPTIAN HIEROGLYPH R001");
  // map.put('\u132B0',"EGYPTIAN HIEROGLYPH R002");
  // map.put('\u132B1',"EGYPTIAN HIEROGLYPH R002A");
  // map.put('\u132B2',"EGYPTIAN HIEROGLYPH R003");
  // map.put('\u132B3',"EGYPTIAN HIEROGLYPH R003A");
  // map.put('\u132B4',"EGYPTIAN HIEROGLYPH R003B");
  // map.put('\u132B5',"EGYPTIAN HIEROGLYPH R004");
  // map.put('\u132B6',"EGYPTIAN HIEROGLYPH R005");
  // map.put('\u132B7',"EGYPTIAN HIEROGLYPH R006");
  // map.put('\u132B8',"EGYPTIAN HIEROGLYPH R007");
  // map.put('\u132B9',"EGYPTIAN HIEROGLYPH R008");
  // map.put('\u132BA',"EGYPTIAN HIEROGLYPH R009");
  // map.put('\u132BB',"EGYPTIAN HIEROGLYPH R010");
  // map.put('\u132BC',"EGYPTIAN HIEROGLYPH R010A");
  // map.put('\u132BD',"EGYPTIAN HIEROGLYPH R011");
  // map.put('\u132BE',"EGYPTIAN HIEROGLYPH R012");
  // map.put('\u132BF',"EGYPTIAN HIEROGLYPH R013");
  // map.put('\u132C0',"EGYPTIAN HIEROGLYPH R014");
  // map.put('\u132C1',"EGYPTIAN HIEROGLYPH R015");
  // map.put('\u132C2',"EGYPTIAN HIEROGLYPH R016");
  // map.put('\u132C3',"EGYPTIAN HIEROGLYPH R016A");
  // map.put('\u132C4',"EGYPTIAN HIEROGLYPH R017");
  // map.put('\u132C5',"EGYPTIAN HIEROGLYPH R018");
  // map.put('\u132C6',"EGYPTIAN HIEROGLYPH R019");
  // map.put('\u132C7',"EGYPTIAN HIEROGLYPH R020");
  // map.put('\u132C8',"EGYPTIAN HIEROGLYPH R021");
  // map.put('\u132C9',"EGYPTIAN HIEROGLYPH R022");
  // map.put('\u132CA',"EGYPTIAN HIEROGLYPH R023");
  // map.put('\u132CB',"EGYPTIAN HIEROGLYPH R024");
  // map.put('\u132CC',"EGYPTIAN HIEROGLYPH R025");
  // map.put('\u132CD',"EGYPTIAN HIEROGLYPH R026");
  // map.put('\u132CE',"EGYPTIAN HIEROGLYPH R027");
  // map.put('\u132CF',"EGYPTIAN HIEROGLYPH R028");
  // map.put('\u132D0',"EGYPTIAN HIEROGLYPH R029");
  // map.put('\u132D1',"EGYPTIAN HIEROGLYPH S001");
  // map.put('\u132D2',"EGYPTIAN HIEROGLYPH S002");
  // map.put('\u132D3',"EGYPTIAN HIEROGLYPH S002A");
  // map.put('\u132D4',"EGYPTIAN HIEROGLYPH S003");
  // map.put('\u132D5',"EGYPTIAN HIEROGLYPH S004");
  // map.put('\u132D6',"EGYPTIAN HIEROGLYPH S005");
  // map.put('\u132D7',"EGYPTIAN HIEROGLYPH S006");
  // map.put('\u132D8',"EGYPTIAN HIEROGLYPH S006A");
  // map.put('\u132D9',"EGYPTIAN HIEROGLYPH S007");
  // map.put('\u132DA',"EGYPTIAN HIEROGLYPH S008");
  // map.put('\u132DB',"EGYPTIAN HIEROGLYPH S009");
  // map.put('\u132DC',"EGYPTIAN HIEROGLYPH S010");
  // map.put('\u132DD',"EGYPTIAN HIEROGLYPH S011");
  // map.put('\u132DE',"EGYPTIAN HIEROGLYPH S012");
  // map.put('\u132DF',"EGYPTIAN HIEROGLYPH S013");
  // map.put('\u132E0',"EGYPTIAN HIEROGLYPH S014");
  // map.put('\u132E1',"EGYPTIAN HIEROGLYPH S014A");
  // map.put('\u132E2',"EGYPTIAN HIEROGLYPH S014B");
  // map.put('\u132E3',"EGYPTIAN HIEROGLYPH S015");
  // map.put('\u132E4',"EGYPTIAN HIEROGLYPH S016");
  // map.put('\u132E5',"EGYPTIAN HIEROGLYPH S017");
  // map.put('\u132E6',"EGYPTIAN HIEROGLYPH S017A");
  // map.put('\u132E7',"EGYPTIAN HIEROGLYPH S018");
  // map.put('\u132E8',"EGYPTIAN HIEROGLYPH S019");
  // map.put('\u132E9',"EGYPTIAN HIEROGLYPH S020");
  // map.put('\u132EA',"EGYPTIAN HIEROGLYPH S021");
  // map.put('\u132EB',"EGYPTIAN HIEROGLYPH S022");
  // map.put('\u132EC',"EGYPTIAN HIEROGLYPH S023");
  // map.put('\u132ED',"EGYPTIAN HIEROGLYPH S024");
  // map.put('\u132EE',"EGYPTIAN HIEROGLYPH S025");
  // map.put('\u132EF',"EGYPTIAN HIEROGLYPH S026");
  // map.put('\u132F0',"EGYPTIAN HIEROGLYPH S026A");
  // map.put('\u132F1',"EGYPTIAN HIEROGLYPH S026B");
  // map.put('\u132F2',"EGYPTIAN HIEROGLYPH S027");
  // map.put('\u132F3',"EGYPTIAN HIEROGLYPH S028");
  // map.put('\u132F4',"EGYPTIAN HIEROGLYPH S029");
  // map.put('\u132F5',"EGYPTIAN HIEROGLYPH S030");
  // map.put('\u132F6',"EGYPTIAN HIEROGLYPH S031");
  // map.put('\u132F7',"EGYPTIAN HIEROGLYPH S032");
  // map.put('\u132F8',"EGYPTIAN HIEROGLYPH S033");
  // map.put('\u132F9',"EGYPTIAN HIEROGLYPH S034");
  // map.put('\u132FA',"EGYPTIAN HIEROGLYPH S035");
  // map.put('\u132FB',"EGYPTIAN HIEROGLYPH S035A");
  // map.put('\u132FC',"EGYPTIAN HIEROGLYPH S036");
  // map.put('\u132FD',"EGYPTIAN HIEROGLYPH S037");
  // map.put('\u132FE',"EGYPTIAN HIEROGLYPH S038");
  // map.put('\u132FF',"EGYPTIAN HIEROGLYPH S039");
  // map.put('\u13300',"EGYPTIAN HIEROGLYPH S040");
  // map.put('\u13301',"EGYPTIAN HIEROGLYPH S041");
  // map.put('\u13302',"EGYPTIAN HIEROGLYPH S042");
  // map.put('\u13303',"EGYPTIAN HIEROGLYPH S043");
  // map.put('\u13304',"EGYPTIAN HIEROGLYPH S044");
  // map.put('\u13305',"EGYPTIAN HIEROGLYPH S045");
  // map.put('\u13306',"EGYPTIAN HIEROGLYPH S046");
  // map.put('\u13307',"EGYPTIAN HIEROGLYPH T001");
  // map.put('\u13308',"EGYPTIAN HIEROGLYPH T002");
  // map.put('\u13309',"EGYPTIAN HIEROGLYPH T003");
  // map.put('\u1330A',"EGYPTIAN HIEROGLYPH T003A");
  // map.put('\u1330B',"EGYPTIAN HIEROGLYPH T004");
  // map.put('\u1330C',"EGYPTIAN HIEROGLYPH T005");
  // map.put('\u1330D',"EGYPTIAN HIEROGLYPH T006");
  // map.put('\u1330E',"EGYPTIAN HIEROGLYPH T007");
  // map.put('\u1330F',"EGYPTIAN HIEROGLYPH T007A");
  // map.put('\u13310',"EGYPTIAN HIEROGLYPH T008");
  // map.put('\u13311',"EGYPTIAN HIEROGLYPH T008A");
  // map.put('\u13312',"EGYPTIAN HIEROGLYPH T009");
  // map.put('\u13313',"EGYPTIAN HIEROGLYPH T009A");
  // map.put('\u13314',"EGYPTIAN HIEROGLYPH T010");
  // map.put('\u13315',"EGYPTIAN HIEROGLYPH T011");
  // map.put('\u13316',"EGYPTIAN HIEROGLYPH T011A");
  // map.put('\u13317',"EGYPTIAN HIEROGLYPH T012");
  // map.put('\u13318',"EGYPTIAN HIEROGLYPH T013");
  // map.put('\u13319',"EGYPTIAN HIEROGLYPH T014");
  // map.put('\u1331A',"EGYPTIAN HIEROGLYPH T015");
  // map.put('\u1331B',"EGYPTIAN HIEROGLYPH T016");
  // map.put('\u1331C',"EGYPTIAN HIEROGLYPH T016A");
  // map.put('\u1331D',"EGYPTIAN HIEROGLYPH T017");
  // map.put('\u1331E',"EGYPTIAN HIEROGLYPH T018");
  // map.put('\u1331F',"EGYPTIAN HIEROGLYPH T019");
  // map.put('\u13320',"EGYPTIAN HIEROGLYPH T020");
  // map.put('\u13321',"EGYPTIAN HIEROGLYPH T021");
  // map.put('\u13322',"EGYPTIAN HIEROGLYPH T022");
  // map.put('\u13323',"EGYPTIAN HIEROGLYPH T023");
  // map.put('\u13324',"EGYPTIAN HIEROGLYPH T024");
  // map.put('\u13325',"EGYPTIAN HIEROGLYPH T025");
  // map.put('\u13326',"EGYPTIAN HIEROGLYPH T026");
  // map.put('\u13327',"EGYPTIAN HIEROGLYPH T027");
  // map.put('\u13328',"EGYPTIAN HIEROGLYPH T028");
  // map.put('\u13329',"EGYPTIAN HIEROGLYPH T029");
  // map.put('\u1332A',"EGYPTIAN HIEROGLYPH T030");
  // map.put('\u1332B',"EGYPTIAN HIEROGLYPH T031");
  // map.put('\u1332C',"EGYPTIAN HIEROGLYPH T032");
  // map.put('\u1332D',"EGYPTIAN HIEROGLYPH T032A");
  // map.put('\u1332E',"EGYPTIAN HIEROGLYPH T033");
  // map.put('\u1332F',"EGYPTIAN HIEROGLYPH T033A");
  // map.put('\u13330',"EGYPTIAN HIEROGLYPH T034");
  // map.put('\u13331',"EGYPTIAN HIEROGLYPH T035");
  // map.put('\u13332',"EGYPTIAN HIEROGLYPH T036");
  // map.put('\u13333',"EGYPTIAN HIEROGLYPH U001");
  // map.put('\u13334',"EGYPTIAN HIEROGLYPH U002");
  // map.put('\u13335',"EGYPTIAN HIEROGLYPH U003");
  // map.put('\u13336',"EGYPTIAN HIEROGLYPH U004");
  // map.put('\u13337',"EGYPTIAN HIEROGLYPH U005");
  // map.put('\u13338',"EGYPTIAN HIEROGLYPH U006");
  // map.put('\u13339',"EGYPTIAN HIEROGLYPH U006A");
  // map.put('\u1333A',"EGYPTIAN HIEROGLYPH U006B");
  // map.put('\u1333B',"EGYPTIAN HIEROGLYPH U007");
  // map.put('\u1333C',"EGYPTIAN HIEROGLYPH U008");
  // map.put('\u1333D',"EGYPTIAN HIEROGLYPH U009");
  // map.put('\u1333E',"EGYPTIAN HIEROGLYPH U010");
  // map.put('\u1333F',"EGYPTIAN HIEROGLYPH U011");
  // map.put('\u13340',"EGYPTIAN HIEROGLYPH U012");
  // map.put('\u13341',"EGYPTIAN HIEROGLYPH U013");
  // map.put('\u13342',"EGYPTIAN HIEROGLYPH U014");
  // map.put('\u13343',"EGYPTIAN HIEROGLYPH U015");
  // map.put('\u13344',"EGYPTIAN HIEROGLYPH U016");
  // map.put('\u13345',"EGYPTIAN HIEROGLYPH U017");
  // map.put('\u13346',"EGYPTIAN HIEROGLYPH U018");
  // map.put('\u13347',"EGYPTIAN HIEROGLYPH U019");
  // map.put('\u13348',"EGYPTIAN HIEROGLYPH U020");
  // map.put('\u13349',"EGYPTIAN HIEROGLYPH U021");
  // map.put('\u1334A',"EGYPTIAN HIEROGLYPH U022");
  // map.put('\u1334B',"EGYPTIAN HIEROGLYPH U023");
  // map.put('\u1334C',"EGYPTIAN HIEROGLYPH U023A");
  // map.put('\u1334D',"EGYPTIAN HIEROGLYPH U024");
  // map.put('\u1334E',"EGYPTIAN HIEROGLYPH U025");
  // map.put('\u1334F',"EGYPTIAN HIEROGLYPH U026");
  // map.put('\u13350',"EGYPTIAN HIEROGLYPH U027");
  // map.put('\u13351',"EGYPTIAN HIEROGLYPH U028");
  // map.put('\u13352',"EGYPTIAN HIEROGLYPH U029");
  // map.put('\u13353',"EGYPTIAN HIEROGLYPH U029A");
  // map.put('\u13354',"EGYPTIAN HIEROGLYPH U030");
  // map.put('\u13355',"EGYPTIAN HIEROGLYPH U031");
  // map.put('\u13356',"EGYPTIAN HIEROGLYPH U032");
  // map.put('\u13357',"EGYPTIAN HIEROGLYPH U032A");
  // map.put('\u13358',"EGYPTIAN HIEROGLYPH U033");
  // map.put('\u13359',"EGYPTIAN HIEROGLYPH U034");
  // map.put('\u1335A',"EGYPTIAN HIEROGLYPH U035");
  // map.put('\u1335B',"EGYPTIAN HIEROGLYPH U036");
  // map.put('\u1335C',"EGYPTIAN HIEROGLYPH U037");
  // map.put('\u1335D',"EGYPTIAN HIEROGLYPH U038");
  // map.put('\u1335E