/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import ptolemy.gui.CancelException;

public class MessageHandler {
    private static MessageHandler _handler = new MessageHandler();

    protected void _error(String info) {
        System.err.println(info);
    }

    protected void _error(String info, Exception exception) {
        if (exception instanceof CancelException) {
            return;
        }
        System.err.println(info);
        exception.printStackTrace();
    }

    protected void _message(String info) {
        System.err.println(info);
    }

    protected void _warning(String info) throws CancelException {
        this._error(info);
    }

    protected void _warning(String info, Exception exception) throws CancelException {
        this._error(info, exception);
    }

    public static void error(String info) {
        _handler._error(info);
    }

    public static void error(String info, Exception exception) {
        _handler._error(info, exception);
    }

    public static MessageHandler getMessageHandler() {
        return _handler;
    }

    public static void message(String info) {
        _handler._message(info);
    }

    public static void setMessageHandler(MessageHandler handler) {
        if (handler != null) {
            _handler = handler;
        }
    }

    public static void warning(String info) throws CancelException {
        _handler._warning(info);
    }

    public static void warning(String info, Exception exception) throws CancelException {
        _handler._warning(String.valueOf(info) + ": " + exception.getMessage(), exception);
    }
}

