/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import ptolemy.plot.EditListener;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotPoint;

public class EditablePlot
extends Plot {
    private int[] _editSpecX;
    private int[] _editSpecY;
    private boolean[] _editSpecSet;
    private int _currentEditX;
    private int _currentEditY;
    private int _dataset = 0;
    private static final Color _editColor = Color.white;
    private Stack _undoStack = new Stack();
    private Stack _redoStack = new Stack();
    private Vector _editListeners = null;

    public EditablePlot() {
        this.addMouseListener(new EditMouseListener());
        this.addMouseMotionListener(new ModifyListener());
        this.addKeyListener(new UndoListener());
    }

    private synchronized void _edit(int x, int y) {
        if (this._dataset < 0) {
            return;
        }
        Object[] save = new Object[]{new Integer(this._dataset), this.getData(this._dataset)};
        this._undoStack.push(save);
        while (!this._redoStack.empty()) {
            this._redoStack.pop();
        }
        Graphics graphics = this.getGraphics();
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        this._editPoint(x, y);
        Vector pts = (Vector)this._points.elementAt(this._dataset);
        int i = 0;
        while (i < pts.size()) {
            int index;
            PlotPoint pt = (PlotPoint)pts.elementAt(i);
            if (pt.x >= this._xMin && pt.x <= this._xMax && (index = (int)((pt.x - this._xMin) * this._xscale) - (this._lrx - this._ulx - this._editSpecX.length)) >= 0 && index < this._editSpecX.length && this._editSpecSet[index]) {
                pt.y = this._yMax - (double)(this._editSpecY[index] - this._uly) / this._yscale;
                if (pt.y < this._yBottom) {
                    this._yBottom = pt.y;
                }
                if (pt.y > this._yTop) {
                    this._yTop = pt.y;
                }
            }
            ++i;
        }
        this.repaint();
        graphics.setXORMode(_editColor);
        int i2 = 0;
        while (i2 < this._editSpecX.length) {
            if (this._editSpecSet[i2]) {
                graphics.drawLine(this._editSpecX[i2], this._editSpecY[i2] - 1, this._editSpecX[i2], this._editSpecY[i2] + 1);
            }
            ++i2;
        }
        graphics.setPaintMode();
        this._notifyListeners(this._dataset);
    }

    private synchronized void _editPoint(int x, int y) {
        if (this._dataset < 0) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        if (x <= this._currentEditX || x >= this._lrx) {
            return;
        }
        int step = this._currentEditX;
        while (step <= x) {
            int index = step - (this._lrx - this._editSpecX.length);
            double proportion = (double)(step - this._currentEditX) / (double)(x - this._currentEditX);
            int newY = (int)((double)this._currentEditY + proportion * (double)(y - this._currentEditY));
            if (!this._editSpecSet[index]) {
                this._editSpecX[index] = step;
                this._editSpecY[index] = newY;
                this._editSpecSet[index] = true;
                graphics.setXORMode(_editColor);
                graphics.drawLine(step, newY - 1, step, newY + 1);
                graphics.setPaintMode();
            }
            ++step;
        }
        this._currentEditX = x;
        this._currentEditY = y;
    }

    private synchronized void _editStart(int x, int y) {
        if (this._dataset < 0) {
            return;
        }
        if (y > this._lry) {
            y = this._lry;
        }
        if (y < this._uly) {
            y = this._uly;
        }
        if (x > this._lrx) {
            x = this._lrx;
        }
        if (x < this._ulx) {
            x = this._ulx;
        }
        int size = this._lrx - x + 1;
        this._editSpecX = new int[size];
        this._editSpecY = new int[size];
        this._editSpecSet = new boolean[size];
        this._editSpecX[0] = x;
        this._editSpecY[0] = y;
        this._editSpecSet[0] = true;
        this._currentEditX = x;
        this._currentEditY = y;
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(_editColor);
        graphics.drawLine(x, y - 1, x, y + 1);
        graphics.setPaintMode();
    }

    private void _notifyListeners(int dataset) {
        if (this._editListeners == null) {
            return;
        }
        Enumeration listeners = this._editListeners.elements();
        while (listeners.hasMoreElements()) {
            ((EditListener)listeners.nextElement()).editDataModified(this, dataset);
        }
    }

    private void _setData(int dataset, double[][] data) {
        this._checkDatasetIndex(dataset);
        Vector pts = (Vector)this._points.elementAt(this._dataset);
        int size = pts.size();
        if (data[0].length < size) {
            size = data[0].length;
        }
        int i = 0;
        while (i < size) {
            PlotPoint pt = (PlotPoint)pts.elementAt(i);
            pt.x = data[0][i];
            pt.y = data[1][i];
            ++i;
        }
    }

    public void addEditListener(EditListener listener) {
        if (this._editListeners == null) {
            this._editListeners = new Vector();
        } else if (this._editListeners.contains(listener)) {
            return;
        }
        this._editListeners.addElement(listener);
    }

    public double[][] getData(int dataset) {
        this._checkDatasetIndex(dataset);
        Vector pts = (Vector)this._points.elementAt(this._dataset);
        int size = pts.size();
        double[][] result = new double[2][size];
        int i = 0;
        while (i < size) {
            PlotPoint pt = (PlotPoint)pts.elementAt(i);
            result[0][i] = pt.x;
            result[1][i] = pt.y;
            ++i;
        }
        return result;
    }

    public void redo() {
        if (this._redoStack.empty()) {
            return;
        }
        Object[] save = new Object[]{new Integer(this._dataset), this.getData(this._dataset)};
        this._undoStack.push(save);
        Object[] saved = (Object[])this._redoStack.pop();
        this._setData((Integer)saved[0], (double[][])saved[1]);
        this.repaint();
        this._notifyListeners(this._dataset);
    }

    public void removeEditListener(EditListener listener) {
        if (this._editListeners == null) {
            return;
        }
        this._editListeners.removeElement(listener);
    }

    public void setEditable(int dataset) {
        if (dataset >= 0) {
            this._checkDatasetIndex(dataset);
        }
        this._dataset = dataset;
    }

    public void undo() {
        if (this._undoStack.empty()) {
            return;
        }
        Object[] save = new Object[]{new Integer(this._dataset), this.getData(this._dataset)};
        this._redoStack.push(save);
        Object[] saved = (Object[])this._undoStack.pop();
        this._setData((Integer)saved[0], (double[][])saved[1]);
        this.repaint();
        this._notifyListeners(this._dataset);
    }

    public class EditMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                EditablePlot.this._editStart(event.getX(), event.getY());
            }
        }

        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                EditablePlot.this._edit(event.getX(), event.getY());
            }
        }
    }

    public class ModifyListener
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                EditablePlot.this._editPoint(event.getX(), event.getY());
            }
        }

        public void mouseMoved(MouseEvent event) {
        }
    }

    public class UndoListener
    implements KeyListener {
        private boolean _control = false;

        public void keyPressed(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 17: {
                    this._control = true;
                    break;
                }
                case 90: {
                    if (!this._control) break;
                    EditablePlot.this.undo();
                    break;
                }
                case 89: {
                    if (!this._control) break;
                    EditablePlot.this.redo();
                    break;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 17: {
                    this._control = false;
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

