/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.adapters.DOMAdapter;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class DOMBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: DOMBuilder.java,v $ $Revision: 1.50 $ $Date: 2003/04/06 02:00:44 $ $Name: jdom_1_0_b9_rc2 $";
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";
    private boolean validate;
    private String adapterClass;
    private JDOMFactory factory = new DefaultJDOMFactory();

    public DOMBuilder() {
        this(false);
    }

    public DOMBuilder(boolean validate) {
        this.setValidation(validate);
    }

    public DOMBuilder(String adapterClass) {
        this(adapterClass, false);
    }

    public DOMBuilder(String adapterClass, boolean validate) {
        this.adapterClass = adapterClass;
        this.setValidation(validate);
    }

    public void setFactory(JDOMFactory factory) {
        this.factory = factory;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public Document build(InputStream in) throws JDOMException {
        Document doc = this.factory.document(null);
        org.w3c.dom.Document domDoc = null;
        try {
            DOMAdapter adapter;
            if (this.adapterClass != null) {
                try {
                    adapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
                    domDoc = adapter.getDocument(in, this.validate);
                }
                catch (ClassNotFoundException e) {}
            } else {
                try {
                    adapter = (DOMAdapter)Class.forName("org.jdom.adapters.JAXPDOMAdapter").newInstance();
                    domDoc = adapter.getDocument(in, this.validate);
                }
                catch (ClassNotFoundException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (domDoc == null && this.adapterClass == null) {
                try {
                    adapter = (DOMAdapter)Class.forName(DEFAULT_ADAPTER_CLASS).newInstance();
                    domDoc = adapter.getDocument(in, this.validate);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            this.buildTree(domDoc, doc, null, true);
        }
        catch (Throwable e) {
            if (e instanceof SAXParseException) {
                SAXParseException p = (SAXParseException)e;
                String systemId = p.getSystemId();
                if (systemId != null) {
                    throw new JDOMException("Error on line " + p.getLineNumber() + " of document " + systemId, e);
                }
                throw new JDOMException("Error on line " + p.getLineNumber(), e);
            }
            throw new JDOMException("Error in building from stream", e);
        }
        return doc;
    }

    public Document build(File file) throws JDOMException {
        try {
            FileInputStream in = new FileInputStream(file);
            return this.build(in);
        }
        catch (FileNotFoundException e) {
            throw new JDOMException("Error in building from " + file, e);
        }
    }

    public Document build(URL url) throws JDOMException {
        try {
            return this.build(url.openStream());
        }
        catch (IOException e) {
            throw new JDOMException("Error in building from " + url, e);
        }
    }

    public Document build(org.w3c.dom.Document domDocument) {
        Document doc = this.factory.document(null);
        this.buildTree(domDocument, doc, null, true);
        return doc;
    }

    public Element build(org.w3c.dom.Element domElement) {
        Document doc = this.factory.document(null);
        this.buildTree(domElement, doc, null, true);
        return doc.getRootElement();
    }

    private void buildTree(Node node, Document doc, Element current, boolean atRoot) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodes = node.getChildNodes();
                int size = nodes.getLength();
                for (int i = 0; i < size; ++i) {
                    this.buildTree(nodes.item(i), doc, current, true);
                }
                break;
            }
            case 1: {
                String attPrefix;
                String attname;
                Attr att;
                int i;
                String nodeName = node.getNodeName();
                String prefix = "";
                String localName = nodeName;
                int colon = nodeName.indexOf(58);
                if (colon >= 0) {
                    prefix = nodeName.substring(0, colon);
                    localName = nodeName.substring(colon + 1);
                }
                Namespace ns = null;
                String uri = node.getNamespaceURI();
                ns = uri == null ? (current == null ? Namespace.NO_NAMESPACE : current.getNamespace(prefix)) : Namespace.getNamespace(prefix, uri);
                Element element = this.factory.element(localName, ns);
                if (atRoot) {
                    doc.setRootElement(element);
                } else {
                    current.addContent(element);
                }
                NamedNodeMap attributeList = node.getAttributes();
                int attsize = attributeList.getLength();
                for (i = 0; i < attsize; ++i) {
                    att = (Attr)attributeList.item(i);
                    attname = att.getName();
                    if (!attname.startsWith("xmlns")) continue;
                    attPrefix = "";
                    colon = attname.indexOf(58);
                    if (colon >= 0) {
                        attPrefix = attname.substring(colon + 1);
                    }
                    String attvalue = att.getValue();
                    Namespace declaredNS = Namespace.getNamespace(attPrefix, attvalue);
                    if (prefix.equals(attPrefix)) {
                        element.setNamespace(declaredNS);
                        continue;
                    }
                    element.addNamespaceDeclaration(declaredNS);
                }
                for (i = 0; i < attsize; ++i) {
                    att = (Attr)attributeList.item(i);
                    attname = att.getName();
                    if (attname.startsWith("xmlns")) continue;
                    attPrefix = "";
                    String attLocalName = attname;
                    colon = attname.indexOf(58);
                    if (colon >= 0) {
                        attPrefix = attname.substring(0, colon);
                        attLocalName = attname.substring(colon + 1);
                    }
                    String attvalue = att.getValue();
                    Namespace attns = null;
                    attns = "".equals(attPrefix) ? Namespace.NO_NAMESPACE : element.getNamespace(attPrefix);
                    Attribute attribute = this.factory.attribute(attLocalName, attvalue, attns);
                    element.setAttribute(attribute);
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int size = children.getLength();
                for (int i2 = 0; i2 < size; ++i2) {
                    Node item = children.item(i2);
                    if (item == null) continue;
                    this.buildTree(item, doc, element, false);
                }
                break;
            }
            case 3: {
                String data = node.getNodeValue();
                current.addContent(this.factory.text(data));
                break;
            }
            case 4: {
                String cdata = node.getNodeValue();
                current.addContent(this.factory.cdata(cdata));
                break;
            }
            case 7: {
                if (atRoot) {
                    doc.addContent(this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                    break;
                }
                current.addContent(this.factory.processingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                if (atRoot) {
                    doc.addContent(this.factory.comment(node.getNodeValue()));
                    break;
                }
                current.addContent(this.factory.comment(node.getNodeValue()));
                break;
            }
            case 5: {
                EntityRef entity = this.factory.entityRef(node.getNodeName());
                current.addContent(entity);
                break;
            }
            case 6: {
                break;
            }
            case 10: {
                DocumentType domDocType = (DocumentType)node;
                String publicID = domDocType.getPublicId();
                String systemID = domDocType.getSystemId();
                String internalDTD = domDocType.getInternalSubset();
                DocType docType = this.factory.docType(domDocType.getName());
                docType.setPublicID(publicID);
                docType.setSystemID(systemID);
                docType.setInternalSubset(internalDTD);
                doc.setDocType(docType);
            }
        }
    }
}

