/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.ImageObserver;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

public class EPSGraphics
extends Graphics {
    private Color _currentColor = Color.black;
    private Font _currentFont;
    private int _width;
    private int _height;
    private Hashtable _linepattern = new Hashtable();
    private OutputStream _out;
    private StringBuffer _buffer = new StringBuffer();
    private Clipboard _clipboard;
    private static String[] _patterns = new String[]{"[]", "[1 1]", "[4 4]", "[4 4 1 4]", "[2 2]", "[4 2 1 2 1 2]", "[5 3 2 3]", "[3 3]", "[4 2 1 2 2 2]", "[1 2 5 2 1 2 1 2]", "[4 1 2 1]"};
    private int _patternIndex = 0;

    public EPSGraphics(OutputStream out, int width, int height) {
        this._width = width;
        this._height = height;
        this._out = out;
        this._buffer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this._buffer.append("%%Creator: UC Berkeley Plot Package\n");
        this._buffer.append("%%BoundingBox: 50 50 " + (50 + width) + " " + (50 + height) + "\n");
        this._buffer.append("%%Pages: 1\n");
        this._buffer.append("%%Page: 1 1\n");
        this._buffer.append("%%LanguageLevel: 2\n");
    }

    private Point _convert(int x, int y) {
        return new Point(x + 50, this._height + 50 - y);
    }

    private void _fillPattern() {
        int red = this._currentColor.getRed();
        int green = this._currentColor.getGreen();
        int blue = this._currentColor.getBlue();
        double bluescale = 0.6;
        double redscale = 0.8;
        double greenscale = 1.0;
        double fullscale = Math.sqrt(65025.0 * (bluescale * bluescale + redscale * redscale + greenscale * greenscale));
        double graylevel = Math.sqrt((double)(red * red) * redscale * redscale + (double)(blue * blue) * bluescale * bluescale + (double)(green * green) * greenscale * greenscale) / fullscale;
        this._buffer.append(graylevel + " setgray\n");
        this._buffer.append("%---- rgb: " + red + " " + green + " " + blue + "\n");
    }

    private boolean _polygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints < 3 || xPoints.length < nPoints || yPoints.length < nPoints) {
            return false;
        }
        Point start = this._convert(xPoints[0], yPoints[0]);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        int i = 1;
        while (i < nPoints) {
            Point vertex = this._convert(xPoints[i], yPoints[i]);
            this._buffer.append(vertex.x + " " + vertex.y + " lineto\n");
            ++i;
        }
        return true;
    }

    public void clearRect(int x, int y, int width, int height) {
    }

    public void clipRect(int x, int y, int width, int height) {
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Graphics create() {
        return new EPSGraphics(this._out, this._width, this._height);
    }

    public void dispose() {
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return true;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return true;
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return true;
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return true;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Point start = this._convert(x1, y1);
        Point end = this._convert(x2, y2);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append(end.x + " " + end.y + " lineto\n");
        this._buffer.append("stroke\n");
    }

    public void drawOval(int x, int y, int width, int height) {
        int radius = width / 2;
        Point center = this._convert(x + radius, y + radius);
        this._buffer.append("newpath " + center.x + " " + center.y + " " + radius + " 0 360 arc closepath stroke\n");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (!this._polygon(xPoints, yPoints, nPoints)) {
            return;
        }
        this._buffer.append("closepath stroke\n");
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    public void drawRect(int x, int y, int width, int height) {
        Point start = this._convert(x, y);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append("0 " + -height + " rlineto\n");
        this._buffer.append(width + " 0 rlineto\n");
        this._buffer.append("0 " + height + " rlineto\n");
        this._buffer.append(-width + " 0 rlineto\n");
        this._buffer.append("closepath stroke\n");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public void drawString(String str, int x, int y) {
        Point start = this._convert(x, y);
        this._buffer.append(start.x + " " + start.y + " moveto\n");
        this._buffer.append("(" + str + ") show\n");
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new RuntimeException("Sorry, drawString(java.text.AttributedCharacterIterator, int , int) is not implemented in EPSGraphics");
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    public void fillOval(int x, int y, int width, int height) {
        int radius = width / 2;
        Point center = this._convert(x + radius, y + radius);
        this._buffer.append("newpath " + center.x + " " + center.y + " " + radius + " 0 360 arc closepath fill\n");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (!this._polygon(xPoints, yPoints, nPoints)) {
            return;
        }
        this._buffer.append("closepath fill\n");
    }

    public void fillRect(int x, int y, int width, int height) {
        Point start = this._convert(x, y);
        this._fillPattern();
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append("0 " + -height + " rlineto\n");
        this._buffer.append(width + " 0 rlineto\n");
        this._buffer.append("0 " + height + " rlineto\n");
        this._buffer.append(-width + " 0 rlineto\n");
        this._buffer.append("closepath gsave fill grestore\n");
        this._buffer.append("0.5 setlinewidth 0 setgray [] 0 setdash stroke\n");
        this._buffer.append("1 setlinewidth\n");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    public Shape getClip() {
        return null;
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public Color getColor() {
        return this._currentColor;
    }

    public Font getFont() {
        return this._currentFont;
    }

    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    public void setClip(int x, int y, int width, int height) {
    }

    public void setClip(Shape clip) {
    }

    public void setColor(Color c) {
        if (c == Color.black) {
            this._buffer.append("0 setgray\n");
            this._buffer.append("[] 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
        } else if (c == Color.white) {
            this._buffer.append("1 setgray\n");
            this._buffer.append("[] 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
        } else if (c == Color.lightGray) {
            this._buffer.append("0.9 setgray\n");
            this._buffer.append("[] 0 setdash\n");
            this._buffer.append("0.5 setlinewidth\n");
        } else if (this._linepattern.containsKey(c)) {
            this._buffer.append(String.valueOf((String)this._linepattern.get(c)) + " 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
        } else {
            this._buffer.append("0 setgray\n");
            if (this._patternIndex >= _patterns.length) {
                this._patternIndex = 0;
            }
            this._buffer.append(String.valueOf(_patterns[this._patternIndex]) + " 0 setdash\n");
            this._buffer.append("1 setlinewidth\n");
            this._linepattern.put(c, _patterns[this._patternIndex]);
            ++this._patternIndex;
        }
        this._currentColor = c;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        int size = font.getSize();
        boolean bold = font.isBold();
        if (bold) {
            this._buffer.append("/Helvetica-Bold findfont\n");
        } else {
            this._buffer.append("/Helvetica findfont\n");
        }
        this._buffer.append(size + " scalefont setfont\n");
        this._currentFont = font;
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public void showpage() {
        this._buffer.append("showpage\n");
        if (this._out != null) {
            PrintWriter output = new PrintWriter(new BufferedOutputStream(this._out));
            output.println(this._buffer.toString());
            output.flush();
        } else {
            if (this._clipboard == null) {
                this._clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            StringSelection sel = new StringSelection(this._buffer.toString());
            this._clipboard.setContents(sel, sel);
        }
    }

    public void translate(int x, int y) {
    }
}

