/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PxgraphParser {
    protected Plot _plot;
    private static final int _NATIVE_ENDIAN = 0;
    private static final int _BIG_ENDIAN = 1;
    private static final int _LITTLE_ENDIAN = 2;
    private boolean _binary = false;
    private boolean _connected = true;
    protected int _currentdataset = -1;
    private static int _debug = 0;
    private int _endian = 0;
    private boolean _firstinset = true;
    private boolean _sawfirstdataset = false;

    public PxgraphParser(Plot plot) {
        this._plot = plot;
    }

    private boolean _addLegendIfNecessary(boolean connected) {
        if (!this._sawfirstdataset || this._currentdataset < 0) {
            this._sawfirstdataset = true;
            ++this._currentdataset;
        }
        if (this._plot.getLegend(this._currentdataset) == null) {
            this._firstinset = true;
            this._sawfirstdataset = true;
            this._plot.addLegend(this._currentdataset, new String("Set " + this._currentdataset));
        }
        if (this._firstinset) {
            connected = false;
            this._firstinset = false;
        }
        return connected;
    }

    private double[] _parseDoubles(String spec) {
        int comma = spec.indexOf(",");
        if (comma < 0) {
            double[] result = new double[]{Double.valueOf(spec)};
            return result;
        }
        double[] result = new double[2];
        String spec1 = spec.substring(0, comma);
        result[0] = Double.valueOf(spec1);
        String spec2 = spec.substring(comma + 1);
        result[1] = Double.valueOf(spec2);
        return result;
    }

    public int parseArgs(String[] args) throws CmdLineArgException, FileNotFoundException, IOException {
        return this.parseArgs(args, null);
    }

    public int parseArgs(String[] args, URL base) throws CmdLineArgException, FileNotFoundException, IOException {
        int i = 0;
        int argumentsRead = 0;
        boolean sawbararg = false;
        boolean sawnlarg = false;
        String savedmarks = "none";
        this._binary = false;
        int width = 400;
        int height = 400;
        String[] unsupportedOptions = new String[]{"-bd", "-brb", "-bw", "-gw", "-lw", "-zg", "-zw"};
        while (args != null && i < args.length && (args[i].startsWith("-") || args[i].startsWith("="))) {
            String arg;
            if ((arg = args[i++]).startsWith("-")) {
                boolean badarg = false;
                int j = 0;
                while (j < unsupportedOptions.length) {
                    if (arg.equals(unsupportedOptions[j])) {
                        System.err.println("Warning: pxgraph: " + arg + " is not supported");
                        ++i;
                        badarg = true;
                    }
                    ++j;
                }
                if (badarg || arg.equals("-bb")) continue;
                if (arg.equals("-bg")) {
                    this._plot.setBackground(PlotBox.getColorByName(args[i++]));
                    continue;
                }
                if (arg.equals("-brw")) {
                    double[] spec;
                    if ((spec = this._parseDoubles(args[i++])).length == 1) {
                        this._plot.setBars(spec[0], 0.0);
                        continue;
                    }
                    this._plot.setBars(spec[0], spec[1]);
                    continue;
                }
                if (arg.equals("-lf")) {
                    this._plot.setLabelFont(args[i++]);
                    continue;
                }
                if (arg.equals("-lx")) {
                    double[] spec;
                    if ((spec = this._parseDoubles(args[i++])).length == 1) {
                        throw new CmdLineArgException("Failed to parse `" + arg + "'");
                    }
                    this._plot.setXRange(spec[0], spec[1]);
                    continue;
                }
                if (arg.equals("-ly")) {
                    double[] spec;
                    if ((spec = this._parseDoubles(args[i++])).length == 1) {
                        throw new CmdLineArgException("Failed to parse `" + arg + "'");
                    }
                    this._plot.setYRange(spec[0], spec[1]);
                    continue;
                }
                if (arg.equals("-t")) {
                    String title = args[i++];
                    this._plot.setTitle(title);
                    continue;
                }
                if (arg.equals("-tf")) {
                    this._plot.setTitleFont(args[i++]);
                    continue;
                }
                if (arg.equals("-x")) {
                    this._plot.setXLabel(args[i++]);
                    continue;
                }
                if (arg.equals("-y")) {
                    this._plot.setYLabel(args[i++]);
                    continue;
                }
                if (arg.equals("-bar")) {
                    sawbararg = true;
                    if (sawnlarg) {
                        this._plot.setImpulses(true);
                    } else {
                        this._plot.setBars(true);
                        this._plot.setMarksStyle("none");
                    }
                    this._plot.setConnected(false);
                    continue;
                }
                if (arg.equals("-binary")) {
                    this._binary = true;
                    this._endian = 0;
                    continue;
                }
                if (arg.equals("-bigendian")) {
                    this._binary = true;
                    this._endian = 1;
                    continue;
                }
                if (arg.equals("-littleendian")) {
                    this._binary = true;
                    this._endian = 2;
                    continue;
                }
                if (arg.equals("-db")) {
                    _debug = 10;
                    continue;
                }
                if (arg.equals("-debug")) {
                    _debug = Integer.valueOf(args[i++]);
                    continue;
                }
                if (arg.equals("-fg")) {
                    this._plot.setForeground(PlotBox.getColorByName(args[i++]));
                    continue;
                }
                if (arg.equals("-help")) continue;
                if (arg.equals("-impulses")) {
                    this._plot.setImpulses(true);
                    this._plot.setConnected(false);
                    continue;
                }
                if (arg.equals("-lnx")) {
                    this._plot.setXLog(true);
                    continue;
                }
                if (arg.equals("-lny")) {
                    this._plot.setYLog(true);
                    continue;
                }
                if (arg.equals("-m")) {
                    this._plot.setMarksStyle("various");
                    savedmarks = "various";
                    continue;
                }
                if (arg.equals("-M")) {
                    this._plot.setMarksStyle("various");
                    savedmarks = "various";
                    continue;
                }
                if (arg.equals("-nl")) {
                    sawnlarg = true;
                    if (sawbararg) {
                        this._plot.setMarksStyle(savedmarks);
                        this._plot.setBars(false);
                        this._plot.setImpulses(true);
                    }
                    this._plot.setConnected(false);
                    continue;
                }
                if (arg.equals("-o")) {
                    ++i;
                    continue;
                }
                if (arg.equals("-p")) {
                    this._plot.setMarksStyle("points");
                    savedmarks = "points";
                    continue;
                }
                if (arg.equals("-P")) {
                    this._plot.setMarksStyle("dots");
                    savedmarks = "dots";
                    continue;
                }
                if (arg.equals("-print")) continue;
                if (arg.equals("-rv")) {
                    this._plot.setBackground(PlotBox.getColorByName("black"));
                    this._plot.setForeground(PlotBox.getColorByName("white"));
                    continue;
                }
                if (arg.equals("-test")) continue;
                if (arg.equals("-tk")) {
                    this._plot.setGrid(false);
                    continue;
                }
                if (arg.equals("-v") || arg.equals("-version")) continue;
                if (arg.length() > 1 && arg.charAt(0) == '-') {
                    try {
                        Integer datasetnumberint = new Integer(arg.substring(1));
                        int datasetnumber = datasetnumberint;
                        if (datasetnumber >= 0) {
                            this._plot.addLegend(datasetnumber, args[i++]);
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            } else if (arg.startsWith("=")) {
                width = Integer.valueOf(arg.substring(1, arg.indexOf(120)));
                int plusIndex = arg.indexOf(43);
                int minusIndex = arg.indexOf(45);
                if (plusIndex != -1 || minusIndex != -1) {
                    if (plusIndex != -1 && minusIndex != -1) {
                        int index = minusIndex;
                        if (plusIndex < minusIndex) {
                            index = plusIndex;
                        }
                        height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, index));
                        continue;
                    }
                    if (plusIndex != -1) {
                        height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, plusIndex));
                        continue;
                    }
                    height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, minusIndex));
                    continue;
                }
                if (arg.length() <= arg.indexOf(120)) continue;
                height = Integer.valueOf(arg.substring(arg.indexOf(120) + 1, arg.length()));
                continue;
            }
            throw new CmdLineArgException("Failed to parse `" + arg + "'");
        }
        argumentsRead = i++;
        this._plot.setSize(width, height);
        i = argumentsRead;
        while (i < args.length) {
            InputStream instream;
            try {
                URL inurl = new URL(base, args[i]);
                instream = inurl.openStream();
            }
            catch (MalformedURLException malformedURLException) {
                instream = new FileInputStream(args[i]);
            }
            this.read(instream);
            ++i;
        }
        return argumentsRead;
    }

    /*
     * Exception decompiling
     */
    public int parsePxgraphargs(String pxgraphargs, URL base) throws CmdLineArgException, FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void read(InputStream inputstream) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(inputstream));
        if (this._binary) {
            float x = 0.0f;
            float y = 0.0f;
            float pointCount = 0.0f;
            boolean byteSwapped = false;
            boolean connected = false;
            byte[] input = new byte[4];
            if (this._connected) {
                connected = true;
            }
            switch (this._endian) {
                case 0: {
                    try {
                        if (!System.getProperty("os.arch").equals("x86")) break;
                        byteSwapped = true;
                    }
                    catch (SecurityException securityException) {}
                    break;
                }
                case 2: {
                    byteSwapped = true;
                    break;
                }
                default: {
                    throw new IOException("Internal Error: Don't know about '" + this._endian + "' style of endian");
                }
                case 1: 
            }
            try {
                this._firstinset = true;
                this._sawfirstdataset = false;
                int c = in.readByte();
                if (c != 100) {
                    int bits = c;
                    bits <<= 8;
                    bits += in.readByte();
                    bits <<= 8;
                    bits += in.readByte();
                    bits <<= 8;
                    x = Float.intBitsToFloat(bits += in.readByte());
                    y = in.readFloat();
                    connected = this._addLegendIfNecessary(connected);
                    this._plot.addPoint(this._currentdataset, x, y, connected);
                    if (this._connected) {
                        connected = true;
                    }
                    while (true) {
                        x = in.readFloat();
                        y = in.readFloat();
                        connected = this._addLegendIfNecessary(connected);
                        this._plot.addPoint(this._currentdataset, x, y, connected);
                        if (!this._connected) continue;
                        connected = true;
                    }
                }
                while (true) {
                    switch (c) {
                        case 100: {
                            if (byteSwapped) {
                                in.readFully(input);
                                x = Float.intBitsToFloat((input[3] & 0xFF) << 24 | (input[2] & 0xFF) << 16 | (input[1] & 0xFF) << 8 | input[0] & 0xFF);
                                in.readFully(input);
                                y = Float.intBitsToFloat((input[3] & 0xFF) << 24 | (input[2] & 0xFF) << 16 | (input[1] & 0xFF) << 8 | input[0] & 0xFF);
                            } else {
                                x = in.readFloat();
                                y = in.readFloat();
                            }
                            pointCount += 1.0f;
                            connected = this._addLegendIfNecessary(connected);
                            this._plot.addPoint(this._currentdataset, x, y, connected);
                            if (!this._connected) break;
                            connected = true;
                            break;
                        }
                        case 101: {
                            connected = false;
                            break;
                        }
                        case 110: {
                            this._firstinset = true;
                            this._sawfirstdataset = true;
                            StringBuffer datasetname = new StringBuffer();
                            ++this._currentdataset;
                            while (c != 10) {
                                datasetname.append(in.readChar());
                            }
                            this._plot.addLegend(this._currentdataset, datasetname.toString());
                            this._plot.setConnected(true);
                            break;
                        }
                        case 109: {
                            connected = false;
                            break;
                        }
                        default: {
                            throw new IOException("Don't understand `" + (char)c + "' character " + "(decimal value = " + c + ") in binary file.  Last point was (" + x + "," + y + ").\nProcessed " + pointCount + " points successfully");
                        }
                    }
                    c = in.readByte();
                }
            }
            catch (EOFException eOFException) {}
        } else {
            this._plot.read(inputstream);
        }
    }
}

