/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.jar;

import com.oyoaha.jar.OyoahaJarEntry;
import com.oyoaha.jar.OyoahaJarStreamWarper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class OyoahaJarReader {
    protected String header;
    protected byte[] rootKey;
    protected boolean compress;
    protected Hashtable entries;
    protected boolean cache;
    protected OyoahaJarStreamWarper warper;

    public OyoahaJarReader(OyoahaJarStreamWarper oyoahaJarStreamWarper, String string) {
        this.warper = oyoahaJarStreamWarper;
        this.header = string;
        this.initializeEntries();
    }

    public OyoahaJarReader(OyoahaJarStreamWarper oyoahaJarStreamWarper, String string, byte[] byArray) {
        this.warper = oyoahaJarStreamWarper;
        this.header = string;
        this.rootKey = byArray;
        this.initializeEntries();
    }

    public void enabledCache(boolean bl) {
        this.cache = bl;
    }

    private void initializeEntries() {
        this.entries = new Hashtable();
        try {
            Object object;
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream());
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[2];
            this.readFully(bufferedInputStream, byArray, 0, byArray.length);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2 = this.decodeBytes(byArray2);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
            int n2 = dataInputStream.readUnsignedShort();
            dataInputStream.close();
            byArray2 = new byte[byArray.length + n2 + 12];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.readFully(bufferedInputStream, byArray2, byArray.length, byArray2.length - byArray.length);
            byArray2 = this.decodeBytes(byArray2);
            dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray2));
            String string = dataInputStream.readUTF();
            if (!this.header.equals(string)) {
                dataInputStream.close();
                ((InputStream)bufferedInputStream).close();
                return;
            }
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            this.compress = n5 >= 1;
            dataInputStream.close();
            byte[] byArray3 = new byte[n4];
            this.readFully(bufferedInputStream, byArray3, 0, byArray3.length);
            byArray3 = this.decodeBytes(byArray3, n4);
            long l = byArray2.length + byArray3.length;
            Vector<OyoahaJarEntry> vector = new Vector<OyoahaJarEntry>(n3);
            dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray3));
            for (n = 0; n < n3; ++n) {
                object = dataInputStream.readUTF();
                long l2 = dataInputStream.readLong();
                OyoahaJarEntry oyoahaJarEntry = new OyoahaJarEntry((String)object, l, l2);
                if (this.compress) {
                    oyoahaJarEntry.uncompressed = dataInputStream.readLong();
                }
                l += oyoahaJarEntry.length;
                vector.addElement(oyoahaJarEntry);
                this.entries.put(oyoahaJarEntry.name, oyoahaJarEntry);
            }
            dataInputStream.close();
            l = byArray2.length + byArray3.length;
            for (n = 0; n < vector.size(); ++n) {
                object = (OyoahaJarEntry)vector.elementAt(n);
                if (this.warper.forceLoading()) {
                    byte[] byArray4 = new byte[(int)((OyoahaJarEntry)object).length];
                    this.readFully(bufferedInputStream, byArray4, 0, byArray4.length);
                    byArray4 = this.decodeBytes(byArray4, ((OyoahaJarEntry)object).length);
                    if (this.compress) {
                        byte[] byArray5 = new byte[(int)((OyoahaJarEntry)object).uncompressed];
                        byArray5 = this.readCompressed(byArray5, byArray4, 0, byArray5.length);
                        ((OyoahaJarEntry)object).data = byArray5;
                        continue;
                    }
                    ((OyoahaJarEntry)object).data = byArray4;
                    continue;
                }
                ((OyoahaJarEntry)object).start = l;
                l += ((OyoahaJarEntry)object).length;
            }
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InputStream getInputStream() {
        if (this.warper != null) {
            return this.warper.getInputStream();
        }
        return null;
    }

    private byte[] readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
        return byArray;
    }

    private byte[] readCompressed(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray2));
        for (int i = 0; i < n2; i += n3) {
            n3 = gZIPInputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
        return byArray;
    }

    private byte[] decodeBytes(byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3 = byArray2 = this.rootKey != null ? this.rootKey : null;
        if (byArray2 != null) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] - byArray2[n++]);
                if (n != byArray2.length) continue;
                n = 0;
            }
        }
        return byArray;
    }

    private byte[] decodeBytes(byte[] byArray, long l) {
        byte[] byArray2;
        byte[] byArray3 = byArray2 = this.rootKey != null ? this.rootKey : null;
        if (byArray2 != null) {
            byte[] byArray4 = Long.toHexString(l).getBytes();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] - byArray2[n++]);
                if (n == byArray2.length) {
                    n = 0;
                }
                int n4 = i;
                byArray[n4] = (byte)(byArray[n4] - byArray4[n2++]);
                if (n2 != byArray4.length) continue;
                n2 = 0;
            }
        }
        return byArray;
    }

    public String[] getOyoahaJarEntryName() {
        String[] stringArray = new String[this.entries.size()];
        Enumeration enumeration = this.entries.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public OyoahaJarEntry getOyoahaJarEntry(String string) {
        return (OyoahaJarEntry)this.entries.get(string);
    }

    public InputStream getInputStream(String string) {
        byte[] byArray = this.getBytes(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public byte[] getBytes(String string) {
        try {
            if (!this.entries.containsKey(string)) {
                byte[] byArray = null;
                return byArray;
            }
            OyoahaJarEntry oyoahaJarEntry = (OyoahaJarEntry)this.entries.get(string);
            if (oyoahaJarEntry.data != null) {
                byte[] byArray = oyoahaJarEntry.data;
                return byArray;
            }
            byte[] byArray = new byte[(int)oyoahaJarEntry.length];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream());
            ((InputStream)bufferedInputStream).skip(oyoahaJarEntry.start);
            this.readFully(bufferedInputStream, byArray, 0, byArray.length);
            byArray = this.decodeBytes(byArray, oyoahaJarEntry.length);
            ((InputStream)bufferedInputStream).close();
            if (this.compress) {
                byte[] byArray2 = new byte[(int)oyoahaJarEntry.uncompressed];
                byArray2 = this.readCompressed(byArray2, byArray, 0, byArray2.length);
                if (!this.cache) {
                    oyoahaJarEntry.data = byArray2;
                }
                byte[] byArray3 = byArray2;
                return byArray3;
            }
            if (!this.cache) {
                oyoahaJarEntry.data = byArray;
            }
            byte[] byArray4 = byArray;
            return byArray4;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

