/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha;

import com.oyoaha.swing.plaf.oyoaha.DemoPanel;
import com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel;
import com.oyoaha.swing.plaf.oyoaha.OyoahaMetalTheme;
import com.oyoaha.swing.plaf.oyoaha.editor.OyoahaCompactorFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class Main
extends JFrame
implements ActionListener {
    private File openDirectory = new File(System.getProperty("user.dir"));
    private JFrame preview;
    private JFrame help;
    private JFrame compress;
    private static File currentTheme;
    private static MetalTheme currentMetalTheme;
    private boolean showHelp;
    private boolean showCompress;
    private JTextArea text;
    private JCheckBox brollover;

    public Main() {
        Serializable serializable;
        if (currentTheme == null && ((File)(serializable = new File(System.getProperty("user.dir"), "gradient.otm"))).exists()) {
            currentTheme = serializable;
        }
        try {
            serializable = new OyoahaLookAndFeel();
            UIManager.setLookAndFeel((LookAndFeel)((Object)serializable));
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new JButton("Test");
        JButton jButton = new JButton("Select a oyoaha theme");
        JButton jButton2 = new JButton("Compress");
        JButton jButton3 = new JButton("Help");
        this.brollover = new JCheckBox("Enabled rollover effect");
        this.brollover.setToolTipText("Enabled rollover effect for button, checkbox, scrollbar...");
        this.brollover.setSelected(true);
        ((JComponent)serializable).setToolTipText("Test oyoaha lookandfeel");
        jButton.setToolTipText("Select a oyoaha theme");
        jButton2.setToolTipText("Utility to remove unused features from the oyoaha lookandfeel jar file");
        jButton3.setToolTipText("Show help");
        ((Component)serializable).setName("test");
        jButton.setName("open");
        jButton2.setName("compress");
        jButton3.setName("help");
        ((AbstractButton)serializable).addActionListener(this);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("rc/test.gif"));
            ((AbstractButton)serializable).setIcon(imageIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("rc/open.gif"));
            jButton.setIcon(imageIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("rc/compress.gif"));
            jButton2.setIcon(imageIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            imageIcon = new ImageIcon(this.getClass().getResource("rc/help.gif"));
            jButton3.setIcon(imageIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        ((AbstractButton)serializable).setHorizontalAlignment(2);
        jButton.setHorizontalAlignment(2);
        jButton2.setHorizontalAlignment(2);
        jButton3.setHorizontalAlignment(2);
        jPanel.add((Component)serializable);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.brollover, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        this.setBounds((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        if (currentTheme == null) {
            super.setVisible(true);
        } else {
            this.help = null;
            this.compress = null;
            this.test();
        }
        this.compress = new OyoahaCompactorFrame(false);
        this.help = new HelpFrame();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = ((Component)actionEvent.getSource()).getName();
        if (string.equals("test")) {
            this.test();
        } else if (string.equals("open")) {
            this.open();
        } else if (string.equals("compress")) {
            if (this.compress != null) {
                this.compress.setVisible(true);
            }
        } else if (string.equals("help") && this.help != null) {
            this.help.setVisible(true);
        }
    }

    protected void open() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new ThemeFileFilter());
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(this.openDirectory);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            this.openDirectory = jFileChooser.getCurrentDirectory();
            File file = jFileChooser.getSelectedFile();
            if (file != null && file.exists()) {
                currentTheme = file;
                this.setTitle(file.getPath());
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            try {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                OyoahaLookAndFeel oyoahaLookAndFeel = new OyoahaLookAndFeel();
                UIManager.setLookAndFeel(oyoahaLookAndFeel);
                SwingUtilities.updateComponentTreeUI(this);
                if (this.help != null) {
                    SwingUtilities.updateComponentTreeUI(this.help);
                }
                if (this.compress != null) {
                    SwingUtilities.updateComponentTreeUI(this.compress);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.help != null && this.showHelp) {
                this.help.setVisible(true);
            }
            if (this.compress != null && this.showCompress) {
                this.compress.setVisible(true);
            }
        } else {
            if (this.help != null) {
                this.help.setVisible(false);
            }
            if (this.compress != null) {
                this.showCompress = this.compress.isVisible();
                this.compress.setVisible(false);
            }
        }
        super.setVisible(bl);
        if (bl) {
            this.toFront();
        }
    }

    private void test() {
        if (this.preview == null) {
            try {
                if (currentMetalTheme != null) {
                    MetalLookAndFeel.setCurrentTheme(currentMetalTheme);
                }
                OyoahaLookAndFeel oyoahaLookAndFeel = new OyoahaLookAndFeel(this.brollover.isSelected());
                if (currentTheme != null) {
                    oyoahaLookAndFeel.setOyoahaTheme(currentTheme);
                }
                UIManager.setLookAndFeel(oyoahaLookAndFeel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.preview = new PreviewFrame(this);
            if (currentTheme != null) {
                this.preview.setTitle(currentTheme.getName());
            } else {
                this.preview.setTitle("Use default theme");
            }
            this.preview.setVisible(true);
            super.setVisible(false);
            this.preview.toFront();
        } else {
            try {
                if (currentMetalTheme != null) {
                    MetalLookAndFeel.setCurrentTheme(currentMetalTheme);
                }
                OyoahaLookAndFeel oyoahaLookAndFeel = new OyoahaLookAndFeel(this.brollover.isSelected());
                if (currentTheme != null) {
                    oyoahaLookAndFeel.setOyoahaTheme(currentTheme);
                }
                UIManager.setLookAndFeel(oyoahaLookAndFeel);
                SwingUtilities.updateComponentTreeUI(this.preview);
                if (currentTheme != null) {
                    this.preview.setTitle(currentTheme.getName());
                } else {
                    this.preview.setTitle("Use default theme");
                }
                this.preview.setVisible(true);
                super.setVisible(false);
                this.preview.toFront();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length > 0 && (file = new File(stringArray[0])).exists() && file.isFile()) {
            if (file.getName().endsWith(".theme")) {
                currentMetalTheme = new OyoahaMetalTheme(file);
            } else {
                currentTheme = file;
            }
        }
        new Main();
    }

    protected void forceRepaintAfterDialog() {
        this.repaint();
    }

    protected class ThemeFileFilter
    extends FileFilter {
        protected ThemeFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".otm");
        }

        public String getDescription() {
            return "OyoahaTheme";
        }
    }

    class MetalThemeMenu
    extends JMenu
    implements ActionListener {
        protected Object[] themes;

        public MetalThemeMenu(String string, Vector vector) {
            super(string);
            this.themes = new Object[vector.size()];
            vector.copyInto(this.themes);
            ButtonGroup buttonGroup = new ButtonGroup();
            int n = 0;
            while (n < this.themes.length) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(((MetalTheme)this.themes[n]).getName());
                buttonGroup.add(jRadioButtonMenuItem);
                this.add(jRadioButtonMenuItem);
                jRadioButtonMenuItem.setActionCommand(n + "");
                jRadioButtonMenuItem.addActionListener(this);
                if (n == 0) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                ++n;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            currentMetalTheme = (MetalTheme)this.themes[Integer.parseInt(string)];
            try {
                MetalLookAndFeel.setCurrentTheme(currentMetalTheme);
                OyoahaLookAndFeel oyoahaLookAndFeel = new OyoahaLookAndFeel();
                if (currentTheme != null) {
                    oyoahaLookAndFeel.setOyoahaTheme(currentTheme);
                }
                UIManager.setLookAndFeel(oyoahaLookAndFeel);
                SwingUtilities.updateComponentTreeUI(Main.this.preview);
                Main.this.preview.pack();
                Main.this.preview.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PreviewFrame
    extends JFrame
    implements ActionListener {
        private JFrame parent;
        private JTabbedPane tabbedPane;
        private DemoPanel demo;
        private JColorChooser colorChooser;

        PreviewFrame(JFrame jFrame) {
            JMenuItem jMenuItem;
            Serializable serializable;
            String[] stringArray;
            Serializable serializable2;
            this.parent = jFrame;
            this.demo = new DemoPanel();
            this.tabbedPane = this.demo.getTabbedPane();
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.setOpaque(true);
            try {
                serializable2 = new File(System.getProperty("user.dir"), "metal");
                if (((File)serializable2).exists() && ((File)serializable2).isDirectory()) {
                    stringArray = ((File)serializable2).list();
                    serializable = new Vector();
                    ((Vector)serializable).addElement(new DefaultMetalTheme());
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].endsWith(".theme")) {
                            ((Vector)serializable).addElement(new OyoahaMetalTheme(new File((File)serializable2, stringArray[n])));
                        }
                        ++n;
                    }
                    jMenuItem = new MetalThemeMenu("MetalTheme", (Vector)serializable);
                    jMenuBar.add((JMenu)jMenuItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializable2 = new JMenu("TabbedPane");
            stringArray = new JCheckBoxMenuItem("TabbedPane.top");
            serializable = new JCheckBoxMenuItem("TabbedPane.left");
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("TabbedPane.bottom");
            jMenuItem = new JCheckBoxMenuItem("TabbedPane.right");
            stringArray.setName("top");
            ((Component)serializable).setName("left");
            jCheckBoxMenuItem.setName("bottom");
            jMenuItem.setName("right");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)stringArray);
            buttonGroup.add(jCheckBoxMenuItem);
            buttonGroup.add((AbstractButton)serializable);
            buttonGroup.add(jMenuItem);
            stringArray.setSelected(true);
            stringArray.addActionListener(this);
            jCheckBoxMenuItem.addActionListener(this);
            ((AbstractButton)serializable).addActionListener(this);
            jMenuItem.addActionListener(this);
            ((JMenu)serializable2).add((JMenuItem)stringArray);
            ((JMenu)serializable2).add((JMenuItem)serializable);
            ((JMenu)serializable2).add(jCheckBoxMenuItem);
            ((JMenu)serializable2).add(jMenuItem);
            this.colorChooser = new JColorChooser();
            jMenuBar.add((JMenu)serializable2);
            JMenu jMenu = new JMenu("OptionPane");
            JMenuItem jMenuItem2 = new JMenuItem("ColorChooser...");
            JMenuItem jMenuItem3 = new JMenuItem("FileChooser...");
            JMenuItem jMenuItem4 = new JMenuItem("Information Dialog...");
            JMenuItem jMenuItem5 = new JMenuItem("Question Dialog...");
            JMenuItem jMenuItem6 = new JMenuItem("Warning Dialog...");
            JMenuItem jMenuItem7 = new JMenuItem("Error Dialog...");
            jMenuItem2.setName("color");
            jMenuItem3.setName("file");
            jMenuItem4.setName("info");
            jMenuItem5.setName("question");
            jMenuItem6.setName("warning");
            jMenuItem7.setName("error");
            jMenuItem2.addActionListener(this);
            jMenuItem3.addActionListener(this);
            jMenuItem4.addActionListener(this);
            jMenuItem5.addActionListener(this);
            jMenuItem6.addActionListener(this);
            jMenuItem7.addActionListener(this);
            jMenu.add(jMenuItem2);
            jMenu.add(jMenuItem3);
            jMenu.addSeparator();
            jMenu.add(jMenuItem4);
            jMenu.add(jMenuItem5);
            jMenu.add(jMenuItem6);
            jMenu.add(jMenuItem7);
            jMenuBar.add(jMenu);
            this.setJMenuBar(jMenuBar);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.demo, "Center");
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ PreviewFrame this$1;
                {
                    this.this$1 = previewFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                }
            });
            JCheckBox jCheckBox = new JCheckBox("Disable components");
            jCheckBox.addActionListener(this);
            JButton jButton = new JButton("close");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PreviewFrame this$1;
                {
                    this.this$1 = previewFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setVisible(false);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2));
            jPanel.add(jCheckBox);
            jPanel.add(jButton);
            this.getContentPane().add((Component)jPanel, "South");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = ((Component)object).getName();
            if (object instanceof JCheckBox) {
                this.demo.setEnabled(!((JCheckBox)object).isSelected());
            } else if (object instanceof JCheckBoxMenuItem) {
                if (string.equalsIgnoreCase("top")) {
                    this.tabbedPane.setTabPlacement(1);
                } else if (string.equalsIgnoreCase("left")) {
                    this.tabbedPane.setTabPlacement(2);
                } else if (string.equalsIgnoreCase("bottom")) {
                    this.tabbedPane.setTabPlacement(3);
                } else if (string.equalsIgnoreCase("right")) {
                    this.tabbedPane.setTabPlacement(4);
                }
                this.pack();
            } else if (string.equalsIgnoreCase("color")) {
                Color color = JColorChooser.showDialog(this, "Color chooser", Color.pink);
                if (color != null) {
                    this.demo.setColor(color);
                }
                Main.this.forceRepaintAfterDialog();
            } else if (string.equalsIgnoreCase("file")) {
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showOpenDialog(this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file == null || !file.exists() || file.isDirectory()) {
                        return;
                    }
                    String string2 = file.getName().toLowerCase();
                    if (string2.endsWith(".gif") || string2.endsWith(".jpeg") || string2.endsWith(".jpg")) {
                        this.demo.openImage(file.getPath());
                    }
                }
                Main.this.forceRepaintAfterDialog();
            } else if (string.equalsIgnoreCase("question")) {
                JOptionPane.showMessageDialog(this, "This a question message", "question", 3);
            } else if (string.equalsIgnoreCase("warning")) {
                JOptionPane.showMessageDialog(this, "This a warning message", "warning", 2);
            } else if (string.equalsIgnoreCase("error")) {
                JOptionPane.showMessageDialog(this, "This a error message", "error", 0);
            } else if (string.equalsIgnoreCase("info")) {
                JOptionPane.showMessageDialog(this, "This a information message", "information", 1);
            }
        }

        public void setVisible(boolean bl) {
            this.parent.setVisible(!bl);
            if (bl) {
                this.pack();
            }
            if (bl) {
                this.toFront();
                this.demo.updateLnFInformation();
            }
            super.setVisible(bl);
        }

        public void pack() {
            super.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            this.setBounds((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        }
    }

    class HelpFrame
    extends JFrame {
        HelpFrame() {
            super("help");
            Serializable serializable;
            Serializable serializable2;
            Object object;
            Serializable serializable3;
            this.getContentPane().setLayout(new BorderLayout());
            try {
                serializable3 = null;
                object = null;
                try {
                    object = "rc/index.html";
                    serializable3 = this.getClass().getResource((String)object);
                }
                catch (Exception exception) {
                    serializable3 = null;
                }
                if (serializable3 != null) {
                    serializable2 = new JEditorPane((URL)serializable3);
                    serializable2.setEditable(false);
                    serializable = new JScrollPane();
                    JViewport jViewport = serializable.getViewport();
                    jViewport.add((Component)serializable2);
                    this.getContentPane().add((Component)serializable, "Center");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ HelpFrame this$1;
                {
                    this.this$1 = helpFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$1.setVisible(false);
                    Main.access$102(HelpFrame.access$000(this.this$1), false);
                }
            });
            serializable3 = new JButton("close");
            ((AbstractButton)serializable3).addActionListener(new ActionListener(this){
                private final /* synthetic */ HelpFrame this$1;
                {
                    this.this$1 = helpFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setVisible(false);
                    Main.access$102(HelpFrame.access$000(this.this$1), false);
                }
            });
            object = new JPanel();
            ((Container)object).setLayout(new FlowLayout(2));
            ((Container)object).add((Component)serializable3);
            this.getContentPane().add((Component)object, "South");
            this.pack();
            serializable2 = this.getToolkit().getScreenSize();
            serializable = new Dimension(440, 380);
            if (((Dimension)serializable).width > ((Dimension)serializable2).width) {
                ((Dimension)serializable).width = ((Dimension)serializable2).width;
            }
            if (((Dimension)serializable).height > ((Dimension)serializable2).height) {
                ((Dimension)serializable).height = ((Dimension)serializable2).height;
            }
            this.setBounds((((Dimension)serializable2).width - ((Dimension)serializable).width) / 2, (((Dimension)serializable2).height - ((Dimension)serializable).height) / 2, ((Dimension)serializable).width, ((Dimension)serializable).height);
        }

        public void setVisible(boolean bl) {
            if (!Main.this.showHelp && bl) {
                Main.this.showHelp = true;
            }
            super.setVisible(bl);
        }

        static /* synthetic */ Main access$000(HelpFrame helpFrame) {
            return helpFrame.Main.this;
        }
    }
}

