/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha;

import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeLoader;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeLoaderUtilities;
import com.oyoaha.swing.plaf.oyoaha.OyoahaThemeSchemeChanged;
import com.oyoaha.swing.plaf.oyoaha.pool.OyoahaPoolUtilities;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class OyoahaThemeScheme {
    public static final String ENABLED = "enabled";
    public static final String SELECTED = "selected";
    public static final String FOCUS = "focus";
    public static final String ROLLOVER = "rollover";
    public static final String PRESSED = "pressed";
    public static final String DISABLED = "disabled";
    public static final String GRAY = "gray";
    public static final String BLACK = "black";
    public static final String WHITE = "white";
    protected ColorUIResource enabled;
    protected ColorUIResource selected;
    protected ColorUIResource focus;
    protected ColorUIResource rollover;
    protected ColorUIResource pressed;
    protected ColorUIResource disabled;
    protected ColorUIResource gray;
    protected ColorUIResource black;
    protected ColorUIResource white;
    protected boolean isDefaultMetalTheme;
    protected boolean isDefaultOyoahaTheme;
    protected boolean isCustomEnabledColor;

    public OyoahaThemeScheme() {
        this.load();
    }

    public boolean isDefaultOyoahaTheme() {
        return this.isDefaultOyoahaTheme;
    }

    public boolean isDefaultMetalTheme() {
        return this.isDefaultMetalTheme;
    }

    public static boolean isDefaultMetalTheme(MetalTheme metalTheme) {
        if (metalTheme instanceof DefaultMetalTheme) {
            return true;
        }
        DefaultMetalTheme defaultMetalTheme = new DefaultMetalTheme();
        return metalTheme.getControl().equals(defaultMetalTheme.getControl()) && metalTheme.getPrimaryControl().equals(defaultMetalTheme.getPrimaryControl()) && metalTheme.getFocusColor().equals(defaultMetalTheme.getFocusColor()) && metalTheme.getMenuSelectedBackground().equals(defaultMetalTheme.getMenuSelectedBackground()) && metalTheme.getControlShadow().equals(defaultMetalTheme.getControlShadow()) && metalTheme.getControlDisabled().equals(defaultMetalTheme.getControlDisabled()) && metalTheme.getControlInfo().equals(defaultMetalTheme.getControlInfo()) && metalTheme.getControlHighlight().equals(defaultMetalTheme.getControlHighlight());
    }

    public boolean isCustomEnabledColor() {
        return this.isCustomEnabledColor;
    }

    protected void init() {
        DefaultMetalTheme defaultMetalTheme = new DefaultMetalTheme();
        this.isDefaultMetalTheme = this.enabled.equals(defaultMetalTheme.getControl()) && this.selected.equals(defaultMetalTheme.getPrimaryControl()) && this.focus.equals(defaultMetalTheme.getFocusColor()) && this.rollover.equals(defaultMetalTheme.getMenuSelectedBackground()) && this.pressed.equals(defaultMetalTheme.getControlShadow()) && this.disabled.equals(defaultMetalTheme.getControlDisabled()) && this.black.equals(defaultMetalTheme.getControlInfo()) && this.white.equals(defaultMetalTheme.getControlHighlight());
        this.isCustomEnabledColor = !this.enabled.equals(defaultMetalTheme.getControl());
    }

    public void load() {
        this.isDefaultOyoahaTheme = false;
        try {
            this.enabled = MetalLookAndFeel.getControl();
            this.selected = MetalLookAndFeel.getPrimaryControl();
            this.focus = MetalLookAndFeel.getFocusColor();
            this.rollover = MetalLookAndFeel.getMenuSelectedBackground();
            this.pressed = MetalLookAndFeel.getControlShadow();
            this.disabled = MetalLookAndFeel.getControlDisabled();
            this.black = MetalLookAndFeel.getBlack();
            this.white = MetalLookAndFeel.getWhite();
            this.gray = OyoahaPoolUtilities.darken(this.enabled, 2);
            this.init();
        }
        catch (NullPointerException nullPointerException) {
            this.load(new DefaultMetalTheme());
        }
    }

    public OyoahaThemeSchemeChanged load(OyoahaThemeLoader oyoahaThemeLoader, MetalTheme metalTheme) {
        try {
            Properties properties = oyoahaThemeLoader.loadDefaultOyoahaThemeScheme();
            if (properties != null && properties.size() > 0) {
                OyoahaThemeSchemeChanged oyoahaThemeSchemeChanged = this.load(properties);
                this.isDefaultOyoahaTheme = true;
                return oyoahaThemeSchemeChanged;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (metalTheme == null) {
            return this.load(new DefaultMetalTheme());
        }
        return this.load(metalTheme);
    }

    public OyoahaThemeSchemeChanged load(MetalTheme metalTheme) {
        this.isDefaultOyoahaTheme = false;
        if (metalTheme == null) {
            return new OyoahaThemeSchemeChanged();
        }
        ColorUIResource[] colorUIResourceArray = new ColorUIResource[]{metalTheme.getControl(), metalTheme.getPrimaryControl(), metalTheme.getFocusColor(), metalTheme.getMenuSelectedBackground(), metalTheme.getControlShadow(), metalTheme.getControlDisabled(), metalTheme.getControlInfo(), metalTheme.getControlHighlight()};
        return this.fillValue(colorUIResourceArray);
    }

    protected OyoahaThemeSchemeChanged load(Properties properties) {
        if (properties == null) {
            return this.loadDefault();
        }
        this.isDefaultOyoahaTheme = false;
        ColorUIResource[] colorUIResourceArray = new ColorUIResource[8];
        if (properties.containsKey(ENABLED)) {
            colorUIResourceArray[0] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(ENABLED));
        }
        if (properties.containsKey(SELECTED)) {
            colorUIResourceArray[1] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(SELECTED));
        }
        if (properties.containsKey(FOCUS)) {
            colorUIResourceArray[2] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(FOCUS));
        }
        if (properties.containsKey(ROLLOVER)) {
            colorUIResourceArray[3] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(ROLLOVER));
        }
        if (properties.containsKey(PRESSED)) {
            colorUIResourceArray[4] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(PRESSED));
        }
        if (properties.containsKey(DISABLED)) {
            colorUIResourceArray[5] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(DISABLED));
        }
        if (properties.containsKey(BLACK)) {
            colorUIResourceArray[6] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(BLACK));
        }
        if (properties.containsKey(WHITE)) {
            colorUIResourceArray[7] = OyoahaThemeLoaderUtilities.readColor(properties.getProperty(WHITE));
        }
        return this.fillValue(colorUIResourceArray);
    }

    protected OyoahaThemeSchemeChanged loadDefault() {
        this.isDefaultOyoahaTheme = false;
        ColorUIResource[] colorUIResourceArray = new ColorUIResource[]{new ColorUIResource(145, 173, 211), new ColorUIResource(214, 193, 174), new ColorUIResource(225, 255, 255), new ColorUIResource(255, 219, 174), new ColorUIResource(255, 115, 174), new ColorUIResource(225, 255, 255), new ColorUIResource(0, 0, 0), new ColorUIResource(225, 255, 255)};
        return this.fillValue(colorUIResourceArray);
    }

    protected OyoahaThemeSchemeChanged fillValue(ColorUIResource[] colorUIResourceArray) {
        OyoahaThemeSchemeChanged oyoahaThemeSchemeChanged = new OyoahaThemeSchemeChanged();
        if (colorUIResourceArray.length != 8) {
            this.init();
            return oyoahaThemeSchemeChanged;
        }
        if (colorUIResourceArray[0] != null) {
            if (this.enabled != null) {
                oyoahaThemeSchemeChanged.enabled = !this.enabled.equals(colorUIResourceArray[0]);
            }
            this.enabled = colorUIResourceArray[0];
        }
        if (colorUIResourceArray[1] != null) {
            if (this.selected != null) {
                oyoahaThemeSchemeChanged.selected = !this.selected.equals(colorUIResourceArray[1]);
            }
            this.selected = colorUIResourceArray[1];
        }
        if (colorUIResourceArray[2] != null) {
            if (this.focus != null) {
                oyoahaThemeSchemeChanged.focus = !this.focus.equals(colorUIResourceArray[2]);
            }
            this.focus = colorUIResourceArray[2];
        }
        if (colorUIResourceArray[3] != null) {
            if (this.rollover != null) {
                oyoahaThemeSchemeChanged.rollover = !this.rollover.equals(colorUIResourceArray[3]);
            }
            this.rollover = colorUIResourceArray[3];
        }
        if (colorUIResourceArray[4] != null) {
            if (this.pressed != null) {
                oyoahaThemeSchemeChanged.pressed = !this.pressed.equals(colorUIResourceArray[4]);
            }
            this.pressed = colorUIResourceArray[4];
        }
        if (colorUIResourceArray[5] != null) {
            if (this.disabled != null) {
                oyoahaThemeSchemeChanged.disabled = !this.disabled.equals(colorUIResourceArray[5]);
            }
            this.disabled = colorUIResourceArray[5];
        }
        if (colorUIResourceArray[6] != null) {
            if (this.black != null) {
                oyoahaThemeSchemeChanged.black = !this.black.equals(colorUIResourceArray[6]);
            }
            this.black = colorUIResourceArray[6];
        }
        if (colorUIResourceArray[7] != null) {
            if (this.white != null) {
                oyoahaThemeSchemeChanged.white = !this.white.equals(colorUIResourceArray[7]);
            }
            this.white = colorUIResourceArray[7];
        }
        ColorUIResource colorUIResource = OyoahaPoolUtilities.darken(this.enabled, 2);
        if (this.gray == null) {
            this.gray = colorUIResource;
        } else if (!this.gray.equals(colorUIResource)) {
            this.gray = colorUIResource;
            oyoahaThemeSchemeChanged.gray = true;
        }
        this.init();
        return oyoahaThemeSchemeChanged;
    }

    public ColorUIResource get(int n) {
        switch (n) {
            case 1003: 
            case 1007: {
                return this.disabled;
            }
            case 1001: 
            case 1005: {
                return this.pressed;
            }
            case 1004: {
                return this.selected;
            }
            case 1002: 
            case 1006: {
                return this.rollover;
            }
            case 100: {
                return this.focus;
            }
            case 101: {
                return this.white;
            }
            case 102: {
                return this.black;
            }
            case 103: {
                return this.gray;
            }
        }
        return this.enabled;
    }

    public ColorUIResource getEnabled() {
        return this.enabled;
    }

    public ColorUIResource getSelected() {
        return this.selected;
    }

    public ColorUIResource getFocus() {
        return this.focus;
    }

    public ColorUIResource getRollover() {
        return this.rollover;
    }

    public ColorUIResource getPressed() {
        return this.pressed;
    }

    public ColorUIResource getDisabled() {
        return this.disabled;
    }

    public ColorUIResource getBlack() {
        return this.black;
    }

    public ColorUIResource getWhite() {
        return this.white;
    }

    public ColorUIResource getGray() {
        return this.gray;
    }
}

