/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class OyoahaCompactor {
    protected File target;
    protected File source;
    protected boolean rManifest;
    protected boolean rTree;
    protected boolean rExamples;
    protected boolean rFilechooser;
    protected boolean rInternalFrame;
    protected boolean rMenu;
    protected boolean rOptionPane;
    protected boolean rSound;
    protected boolean rSplitPane;
    protected boolean rTabbedPane;
    protected boolean rTable;
    protected boolean rColorchooser;
    protected boolean rApplet;
    protected boolean rJavaFile;
    protected boolean rJava1_2;
    protected boolean rJava1_3;

    public void setSourceFile(File file) {
        this.source = file;
    }

    public File getSourceFile() {
        return this.source;
    }

    public void setTargetFile(File file) {
        this.target = file;
    }

    public File getTargetFile() {
        return this.target;
    }

    public void setrManifest(boolean bl) {
        this.rManifest = bl;
    }

    public void setrTree(boolean bl) {
        this.rTree = bl;
    }

    public void setrExamples(boolean bl) {
        this.rExamples = bl;
    }

    public void setrFilechooser(boolean bl) {
        this.rFilechooser = bl;
    }

    public void setrInternalFrame(boolean bl) {
        this.rInternalFrame = bl;
    }

    public void setrJava1_2(boolean bl) {
        this.rJava1_2 = bl;
    }

    public void setrJava1_3(boolean bl) {
        this.rJava1_3 = bl;
    }

    public void setrMenu(boolean bl) {
        this.rMenu = bl;
    }

    public void setrOptionPane(boolean bl) {
        this.rOptionPane = bl;
    }

    public void setrSound(boolean bl) {
        this.rSound = bl;
    }

    public void setrSplitPane(boolean bl) {
        this.rSplitPane = bl;
    }

    public void setrTabbedPane(boolean bl) {
        this.rTabbedPane = bl;
    }

    public void setrTable(boolean bl) {
        this.rTable = bl;
    }

    public void setrColorchooser(boolean bl) {
        this.rColorchooser = bl;
    }

    public void setrJavaFile(boolean bl) {
        this.rJavaFile = bl;
    }

    public void setrApplet(boolean bl) {
        this.rApplet = bl;
    }

    public boolean getrManifest() {
        return this.rManifest;
    }

    public boolean getrTree() {
        return this.rTree;
    }

    public boolean getrExamples() {
        return this.rExamples;
    }

    public boolean getrFilechooser() {
        return this.rFilechooser;
    }

    public boolean getrInternalFrame() {
        return this.rInternalFrame;
    }

    public boolean getrJava1_2() {
        return this.rJava1_2;
    }

    public boolean getrJava1_3() {
        return this.rJava1_3;
    }

    public boolean getrMenu() {
        return this.rMenu;
    }

    public boolean getrOptionPane() {
        return this.rOptionPane;
    }

    public boolean getrSound() {
        return this.rSound;
    }

    public boolean getrSplitPane() {
        return this.rSplitPane;
    }

    public boolean getrTabbedPane() {
        return this.rTabbedPane;
    }

    public boolean getrTable() {
        return this.rTable;
    }

    public boolean getrColorchooser() {
        return this.rColorchooser;
    }

    public boolean getrJavaFile() {
        return this.rJavaFile;
    }

    public boolean getrApplet() {
        return this.rApplet;
    }

    public void loadConfiguration(File file) {
        String string;
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.source == null && (string = properties.getProperty("source")) != null) {
            this.source = new File(string);
        }
        if (this.target == null && (string = properties.getProperty("target")) != null) {
            this.target = new File(string);
        }
        this.rManifest = this.getBoolean(properties.getProperty("rManifest", "false"));
        this.rTree = this.getBoolean(properties.getProperty("rTree", "false"));
        this.rExamples = this.getBoolean(properties.getProperty("rExamples", "false"));
        this.rFilechooser = this.getBoolean(properties.getProperty("rFilechooser", "false"));
        this.rInternalFrame = this.getBoolean(properties.getProperty("rInternalFrame", "false"));
        this.rJava1_2 = this.getBoolean(properties.getProperty("rJava1_2", "false"));
        this.rJava1_3 = this.getBoolean(properties.getProperty("rJava1_3", "false"));
        this.rMenu = this.getBoolean(properties.getProperty("rMenu", "false"));
        this.rOptionPane = this.getBoolean(properties.getProperty("rOptionPane", "false"));
        this.rSound = this.getBoolean(properties.getProperty("rSound", "false"));
        this.rSplitPane = this.getBoolean(properties.getProperty("rSplitPane", "false"));
        this.rTabbedPane = this.getBoolean(properties.getProperty("rTabbedPane", "false"));
        this.rTable = this.getBoolean(properties.getProperty("rTable", "false"));
        this.rColorchooser = this.getBoolean(properties.getProperty("rColorchooser", "false"));
        this.rJavaFile = this.getBoolean(properties.getProperty("rJavaFile", "false"));
        this.rApplet = this.getBoolean(properties.getProperty("rApplet", "false"));
    }

    protected boolean getBoolean(String string) {
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void saveConfiguration(File file, boolean bl, boolean bl2) {
        Properties properties = new Properties();
        if (this.source != null && bl) {
            properties.put("source", this.source.getPath());
        }
        if (this.target != null && bl2) {
            properties.put("target", this.target.getPath());
        }
        properties.put("rManifest", String.valueOf(this.rManifest));
        properties.put("rTree", String.valueOf(this.rTree));
        properties.put("rExamples", String.valueOf(this.rExamples));
        properties.put("rFilechooser", String.valueOf(this.rFilechooser));
        properties.put("rInternalFrame", String.valueOf(this.rInternalFrame));
        properties.put("rJava1_2", String.valueOf(this.rJava1_2));
        properties.put("rJava1_3", String.valueOf(this.rJava1_3));
        properties.put("rMenu", String.valueOf(this.rMenu));
        properties.put("rOptionPane", String.valueOf(this.rOptionPane));
        properties.put("rSound", String.valueOf(this.rSound));
        properties.put("rSplitPane", String.valueOf(this.rSplitPane));
        properties.put("rTabbedPane", String.valueOf(this.rTabbedPane));
        properties.put("rTable", String.valueOf(this.rTable));
        properties.put("rColorchooser", String.valueOf(this.rColorchooser));
        properties.put("rJavaFile", String.valueOf(this.rJavaFile));
        properties.put("rApplet", String.valueOf(this.rApplet));
        try {
            properties.save(new FileOutputStream(file), "OyoahaLnFCompactor");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void compact() {
        Vector<String> vector = new Vector<String>();
        if (this.rManifest) {
            vector.addElement("meta-inf/manifest.mf");
        }
        if (this.rTree) {
            this.fill(vector, "/rules/rTree.list");
        }
        if (this.rExamples) {
            this.fill(vector, "/rules/rExamples.list");
        }
        if (this.rFilechooser) {
            this.fill(vector, "/rules/rFilechooser.list");
        }
        if (this.rInternalFrame) {
            this.fill(vector, "/rules/rInternalFrame.list");
        }
        if (this.rApplet) {
            this.fill(vector, "/rules/rApplet.list");
        }
        if (this.rMenu) {
            this.fill(vector, "/rules/rMenu.list");
        }
        if (this.rOptionPane) {
            this.fill(vector, "/rules/rOptionPane.list");
        }
        if (this.rSound) {
            this.fill(vector, "/rules/rSound.list");
        }
        if (this.rSplitPane) {
            this.fill(vector, "/rules/rSplitPane.list");
        }
        if (this.rTabbedPane) {
            this.fill(vector, "/rules/rTabbedPane.list");
        }
        if (this.rTable) {
            this.fill(vector, "/rules/rTable.list");
        }
        if (this.rColorchooser) {
            this.fill(vector, "/rules/rColorchooser.list");
        }
        this.fill(vector, "/rules/rDebug.list");
        this.fill(vector, "/rules/rEditor.list");
        try {
            ZipFile zipFile = new ZipFile(this.source);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.target));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.getName().toLowerCase().equals("com/oyoaha/swing/plaf/oyoaha/uidefaults2.properties")) {
                    if (this.rJava1_3) continue;
                    this.writeUIDefault(zipFile, zipOutputStream, zipEntry);
                    continue;
                }
                if (zipEntry.getName().toLowerCase().equals("com/oyoaha/swing/plaf/oyoaha/uidefaults.properties")) {
                    if (this.rJava1_2) continue;
                    this.writeUIDefault(zipFile, zipOutputStream, zipEntry);
                    continue;
                }
                if (this.rJavaFile && zipEntry.getName().toLowerCase().endsWith(".java") || vector.contains(zipEntry.getName().toLowerCase())) continue;
                this.add(zipFile, zipOutputStream, zipEntry);
            }
            zipOutputStream.finish();
            zipOutputStream.close();
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void writeUIDefault(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(zipEntry));
        if (this.rTree) {
            properties.remove("TreeUI");
        }
        if (this.rFilechooser) {
            properties.remove("FileChooserUI");
        }
        if (this.rInternalFrame) {
            properties.remove("InternalFrameUI");
            properties.remove("DesktopIconUI");
            properties.remove("DesktopPaneUI");
        }
        if (this.rMenu) {
            properties.remove("MenuBarUI");
            properties.remove("MenuItemUI");
            properties.remove("MenuUI");
            properties.remove("CheckBoxMenuItemUI");
            properties.remove("RadioButtonMenuItemUI");
        }
        if (this.rOptionPane) {
            properties.remove("OptionPaneUI");
        }
        if (this.rSplitPane) {
            properties.remove("SplitPaneUI");
        }
        if (this.rTabbedPane) {
            properties.remove("TabbedPaneUI");
        }
        if (this.rTable) {
            properties.remove("TableUI");
            properties.remove("TableHeaderUI");
        }
        if (this.rColorchooser) {
            properties.remove("ColorChooserUI");
        }
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipOutputStream.putNextEntry(zipEntry2);
        properties.save(zipOutputStream, "");
        zipOutputStream.closeEntry();
    }

    protected void add(ZipFile zipFile, ZipOutputStream zipOutputStream, ZipEntry zipEntry) throws IOException {
        int n;
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        zipOutputStream.putNextEntry(zipEntry2);
        byte[] byArray = new byte[10240];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) >= 0) {
            zipOutputStream.write(byArray, 0, n);
            ++n2;
        }
        inputStream.close();
        zipOutputStream.closeEntry();
    }

    protected void fill(Vector vector, String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(string)));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                vector.addElement(string2.toLowerCase());
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void main(String[] stringArray) {
        File file = stringArray.length > 0 ? new File(stringArray[0]) : new File(System.getProperty("user.dir"), "com.zip");
        OyoahaCompactor oyoahaCompactor = new OyoahaCompactor();
        oyoahaCompactor.setSourceFile(file);
        oyoahaCompactor.setTargetFile(new File(System.getProperty("user.dir"), "oalnf.jar"));
        oyoahaCompactor.setrJavaFile(true);
        oyoahaCompactor.setrApplet(true);
        oyoahaCompactor.setrExamples(false);
        oyoahaCompactor.setrColorchooser(false);
        oyoahaCompactor.setrFilechooser(false);
        oyoahaCompactor.setrInternalFrame(false);
        oyoahaCompactor.setrManifest(false);
        oyoahaCompactor.setrMenu(false);
        oyoahaCompactor.setrOptionPane(false);
        oyoahaCompactor.setrSound(false);
        oyoahaCompactor.setrSplitPane(false);
        oyoahaCompactor.setrTabbedPane(false);
        oyoahaCompactor.setrTable(false);
        oyoahaCompactor.setrTree(false);
        oyoahaCompactor.setrJava1_2(false);
        oyoahaCompactor.compact();
    }
}

