/*
 * Decompiled with CFR 0.152.
 */
package com.oyoaha.swing.plaf.oyoaha.editor;

import com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel;
import com.oyoaha.swing.plaf.oyoaha.editor.OyoahaCompactor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class OyoahaCompactorFrame
extends JFrame
implements ActionListener {
    protected File openDirectory = new File(System.getProperty("user.dir"));
    protected JCheckBox rManifest;
    protected JCheckBox rTree;
    protected JCheckBox rExamples;
    protected JCheckBox rFilechooser;
    protected JCheckBox rInternalFrame;
    protected JCheckBox rMenu;
    protected JCheckBox rOptionPane;
    protected JCheckBox rSplitPane;
    protected JCheckBox rTabbedPane;
    protected JCheckBox rTable;
    protected JCheckBox rColorchooser;
    protected JCheckBox rSound;
    protected JCheckBox rJavaFile;
    protected JRadioButton rJavaKeep;
    protected JRadioButton rJava1_2;
    protected JRadioButton rJava1_3;
    protected OyoahaCompactor compactor;
    protected JButton cancel;
    protected JButton ok;
    protected JButton chooseTargetFile;
    protected JButton chooseSourceFile;
    protected boolean exitOnClose;

    public OyoahaCompactorFrame(boolean bl) {
        this.setTitle("compress...");
        this.exitOnClose = bl;
        if (bl) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        this.compactor = new OyoahaCompactor();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        this.chooseSourceFile = new JButton("choose the source jar...");
        this.chooseTargetFile = new JButton("choose the target jar...");
        this.chooseSourceFile.setHorizontalAlignment(2);
        this.chooseTargetFile.setHorizontalAlignment(2);
        this.chooseSourceFile.addActionListener(this);
        this.chooseTargetFile.addActionListener(this);
        jPanel.add(this.chooseSourceFile);
        jPanel.add(this.chooseTargetFile);
        this.getContentPane().add((Component)jPanel, "North");
        this.rExamples = new JCheckBox("remove Examples");
        this.rTree = new JCheckBox("remove JTree support");
        this.rFilechooser = new JCheckBox("remove JFilechooser support");
        this.rInternalFrame = new JCheckBox("remove JInternalFrame support");
        this.rMenu = new JCheckBox("remove JMenu support");
        this.rOptionPane = new JCheckBox("remove JOptionPane support");
        this.rSplitPane = new JCheckBox("remove JSplitPane support");
        this.rTabbedPane = new JCheckBox("remove JTabbedPane support");
        this.rTable = new JCheckBox("remove JTable support");
        this.rColorchooser = new JCheckBox("remove JColorChooser support");
        this.rSound = new JCheckBox("remove Sound support");
        this.rJavaFile = new JCheckBox("remove all java source file");
        this.rExamples.addActionListener(this);
        this.rTree.addActionListener(this);
        this.rFilechooser.addActionListener(this);
        this.rInternalFrame.addActionListener(this);
        this.rMenu.addActionListener(this);
        this.rOptionPane.addActionListener(this);
        this.rSound.addActionListener(this);
        this.rSplitPane.addActionListener(this);
        this.rTabbedPane.addActionListener(this);
        this.rTable.addActionListener(this);
        this.rColorchooser.addActionListener(this);
        this.rJavaFile.addActionListener(this);
        this.rJavaKeep = new JRadioButton("leave java1 & java2 support");
        this.rJava1_2 = new JRadioButton("remove java1 support");
        this.rJava1_3 = new JRadioButton("remove java2 support");
        this.rJavaKeep.addActionListener(this);
        this.rJava1_2.addActionListener(this);
        this.rJava1_3.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rJavaKeep);
        buttonGroup.add(this.rJava1_2);
        buttonGroup.add(this.rJava1_3);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.rExamples);
        jPanel.add(this.rTree);
        jPanel.add(this.rFilechooser);
        jPanel.add(this.rInternalFrame);
        jPanel.add(this.rMenu);
        jPanel.add(this.rOptionPane);
        jPanel.add(this.rSplitPane);
        jPanel.add(this.rTabbedPane);
        jPanel.add(this.rTable);
        jPanel.add(this.rColorchooser);
        jPanel.add(this.rSound);
        jPanel.add(this.rJavaFile);
        jPanel.add(this.rJavaKeep);
        jPanel.add(this.rJava1_2);
        jPanel.add(this.rJava1_3);
        this.useDefaultConfiguration();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.height /= 2;
        dimension.width += 40;
        jScrollPane.setPreferredSize(dimension);
        this.getContentPane().add(jScrollPane);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.cancel = new JButton("cancel");
        this.ok = new JButton("ok");
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        jPanel.add(this.cancel);
        jPanel.add(this.ok);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        dimension = this.getPreferredSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        ((Component)this).setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        if (bl) {
            ((Component)this).setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        if (abstractButton == this.rManifest) {
            this.compactor.setrManifest(abstractButton.isSelected());
        } else if (abstractButton == this.rTree) {
            this.compactor.setrTree(abstractButton.isSelected());
        } else if (abstractButton == this.rExamples) {
            this.compactor.setrExamples(abstractButton.isSelected());
            this.compactor.setrApplet(abstractButton.isSelected());
        } else if (abstractButton == this.rFilechooser) {
            this.compactor.setrFilechooser(abstractButton.isSelected());
        } else if (abstractButton == this.rInternalFrame) {
            this.compactor.setrInternalFrame(abstractButton.isSelected());
        } else if (abstractButton == this.rMenu) {
            this.compactor.setrMenu(abstractButton.isSelected());
        } else if (abstractButton == this.rOptionPane) {
            this.compactor.setrOptionPane(abstractButton.isSelected());
        } else if (abstractButton == this.rSound) {
            this.compactor.setrSound(abstractButton.isSelected());
        } else if (abstractButton == this.rSplitPane) {
            this.compactor.setrSplitPane(abstractButton.isSelected());
        } else if (abstractButton == this.rTabbedPane) {
            this.compactor.setrTabbedPane(abstractButton.isSelected());
        } else if (abstractButton == this.rTable) {
            this.compactor.setrTable(abstractButton.isSelected());
        } else if (abstractButton == this.rColorchooser) {
            this.compactor.setrColorchooser(abstractButton.isSelected());
        } else if (abstractButton == this.rJavaFile) {
            this.compactor.setrJavaFile(abstractButton.isSelected());
        } else if (abstractButton == this.rJavaKeep) {
            this.compactor.setrJava1_2(!abstractButton.isSelected());
            this.compactor.setrJava1_3(!abstractButton.isSelected());
        } else if (abstractButton == this.rJava1_2) {
            this.compactor.setrJava1_2(abstractButton.isSelected());
        } else if (abstractButton == this.rJava1_3) {
            this.compactor.setrJava1_3(abstractButton.isSelected());
        } else if (abstractButton == this.cancel) {
            if (this.exitOnClose) {
                System.exit(0);
            } else {
                this.dispose();
            }
        } else if (abstractButton == this.ok) {
            this.compactor.compact();
            if (this.exitOnClose) {
                System.exit(0);
            }
        } else if (abstractButton == this.chooseSourceFile) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new JarFileFilter());
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setCurrentDirectory(this.openDirectory);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                this.openDirectory = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                if (file != null && file.exists()) {
                    File file2 = this.compactor.getTargetFile();
                    if (file2 != null) {
                        if (file.equals(file2)) {
                            JOptionPane.showMessageDialog(this, "Target and Source can't be the same file", "wrong source file", 0);
                        } else {
                            this.compactor.setSourceFile(file);
                            abstractButton.setText("source: " + file.getName());
                            this.ok.setEnabled(true);
                        }
                    } else {
                        this.compactor.setSourceFile(file);
                        abstractButton.setText("source: " + file.getName());
                    }
                }
            }
        } else if (abstractButton == this.chooseTargetFile) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new JarFileFilter());
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setCurrentDirectory(this.openDirectory);
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                this.openDirectory = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    File file3 = this.compactor.getSourceFile();
                    if (file3 != null) {
                        if (file.equals(file3)) {
                            JOptionPane.showMessageDialog(this, "Target and Source can't be the same file", "wrong target file", 0);
                        } else {
                            this.compactor.setTargetFile(file);
                            abstractButton.setText("target: " + file.getName());
                            this.ok.setEnabled(true);
                        }
                    } else {
                        this.compactor.setTargetFile(file);
                        abstractButton.setText("target: " + file.getName());
                    }
                }
            }
        }
    }

    protected void openConfigurationFile() {
    }

    protected void saveConfigurationFile() {
    }

    protected void useDefaultConfiguration() {
        this.rExamples.setSelected(true);
        this.rTree.setSelected(false);
        this.rFilechooser.setSelected(false);
        this.rInternalFrame.setSelected(false);
        this.rMenu.setSelected(false);
        this.rOptionPane.setSelected(false);
        this.rSplitPane.setSelected(false);
        this.rTabbedPane.setSelected(false);
        this.rTable.setSelected(false);
        this.rColorchooser.setSelected(false);
        this.rSound.setSelected(false);
        this.rJavaFile.setSelected(true);
        this.rJavaKeep.setSelected(true);
        this.rJava1_2.setSelected(false);
        this.rJava1_3.setSelected(false);
        this.compactor.setrExamples(true);
        this.compactor.setrApplet(true);
        this.compactor.setrTree(false);
        this.compactor.setrFilechooser(false);
        this.compactor.setrInternalFrame(false);
        this.compactor.setrMenu(false);
        this.compactor.setrOptionPane(false);
        this.compactor.setrSplitPane(false);
        this.compactor.setrTabbedPane(false);
        this.compactor.setrTable(false);
        this.compactor.setrColorchooser(false);
        this.compactor.setrSound(false);
        this.compactor.setrJavaFile(true);
        this.compactor.setrJava1_2(false);
        this.compactor.setrJava1_3(false);
    }

    public static final void main(String[] stringArray) {
        try {
            OyoahaLookAndFeel oyoahaLookAndFeel = new OyoahaLookAndFeel();
            UIManager.setLookAndFeel(oyoahaLookAndFeel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        new OyoahaCompactorFrame(true);
    }

    protected class JarFileFilter
    extends FileFilter {
        protected JarFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".jar") || string.endsWith(".zip");
        }

        public String getDescription() {
            return "jar/zip file";
        }
    }
}

